//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package marsh

import (
	"fmt"
	"strconv"
)

// Usage of MANUAL_SETPOINT message, sent in mode_switch field.
type MARSH_MANUAL_SETPOINT_MODE uint64

const (
	// Values for target inceptors positions that the pilot should follow.
	MARSH_MANUAL_SETPOINT_MODE_TARGET MARSH_MANUAL_SETPOINT_MODE = 0
	// Values for inceptors trim positions, the exact meaning depends on the flight model.
	MARSH_MANUAL_SETPOINT_MODE_TRIM MARSH_MANUAL_SETPOINT_MODE = 1
)

var value_to_label_MARSH_MANUAL_SETPOINT_MODE = map[MARSH_MANUAL_SETPOINT_MODE]string{
	MARSH_MANUAL_SETPOINT_MODE_TARGET: "MARSH_MANUAL_SETPOINT_MODE_TARGET",
	MARSH_MANUAL_SETPOINT_MODE_TRIM:   "MARSH_MANUAL_SETPOINT_MODE_TRIM",
}

var label_to_value_MARSH_MANUAL_SETPOINT_MODE = map[string]MARSH_MANUAL_SETPOINT_MODE{
	"MARSH_MANUAL_SETPOINT_MODE_TARGET": MARSH_MANUAL_SETPOINT_MODE_TARGET,
	"MARSH_MANUAL_SETPOINT_MODE_TRIM":   MARSH_MANUAL_SETPOINT_MODE_TRIM,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MARSH_MANUAL_SETPOINT_MODE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MARSH_MANUAL_SETPOINT_MODE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MARSH_MANUAL_SETPOINT_MODE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MARSH_MANUAL_SETPOINT_MODE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MARSH_MANUAL_SETPOINT_MODE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MARSH_MANUAL_SETPOINT_MODE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
