//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package marsh

import (
	"fmt"
	"strconv"
)

// Mode of a motion platform system.
type MOTION_PLATFORM_MODE uint64

const (
	// Mode information is unsupported on this device.
	MOTION_PLATFORM_MODE_UNKNOWN MOTION_PLATFORM_MODE = 0
	// Mode is currently not available, but may be in different condition.
	MOTION_PLATFORM_MODE_UNINITIALIZED MOTION_PLATFORM_MODE = 1
	// Platform actuators are turned off, but control system is responsive.
	MOTION_PLATFORM_MODE_OFF MOTION_PLATFORM_MODE = 2
	// Platform is in the lowest position and/or locked, appropriate for personnel entry.
	MOTION_PLATFORM_MODE_SETTLED MOTION_PLATFORM_MODE = 3
	// Platform is in a neutral reference position, not accepting movement commands.
	MOTION_PLATFORM_MODE_NEUTRAL MOTION_PLATFORM_MODE = 4
	// Platform is stopped in any position, not accepting movement commands.
	MOTION_PLATFORM_MODE_FROZEN MOTION_PLATFORM_MODE = 5
	// Platform is in any position, accepting movement commands.
	MOTION_PLATFORM_MODE_ENGAGED MOTION_PLATFORM_MODE = 6
)

var value_to_label_MOTION_PLATFORM_MODE = map[MOTION_PLATFORM_MODE]string{
	MOTION_PLATFORM_MODE_UNKNOWN:       "MOTION_PLATFORM_MODE_UNKNOWN",
	MOTION_PLATFORM_MODE_UNINITIALIZED: "MOTION_PLATFORM_MODE_UNINITIALIZED",
	MOTION_PLATFORM_MODE_OFF:           "MOTION_PLATFORM_MODE_OFF",
	MOTION_PLATFORM_MODE_SETTLED:       "MOTION_PLATFORM_MODE_SETTLED",
	MOTION_PLATFORM_MODE_NEUTRAL:       "MOTION_PLATFORM_MODE_NEUTRAL",
	MOTION_PLATFORM_MODE_FROZEN:        "MOTION_PLATFORM_MODE_FROZEN",
	MOTION_PLATFORM_MODE_ENGAGED:       "MOTION_PLATFORM_MODE_ENGAGED",
}

var label_to_value_MOTION_PLATFORM_MODE = map[string]MOTION_PLATFORM_MODE{
	"MOTION_PLATFORM_MODE_UNKNOWN":       MOTION_PLATFORM_MODE_UNKNOWN,
	"MOTION_PLATFORM_MODE_UNINITIALIZED": MOTION_PLATFORM_MODE_UNINITIALIZED,
	"MOTION_PLATFORM_MODE_OFF":           MOTION_PLATFORM_MODE_OFF,
	"MOTION_PLATFORM_MODE_SETTLED":       MOTION_PLATFORM_MODE_SETTLED,
	"MOTION_PLATFORM_MODE_NEUTRAL":       MOTION_PLATFORM_MODE_NEUTRAL,
	"MOTION_PLATFORM_MODE_FROZEN":        MOTION_PLATFORM_MODE_FROZEN,
	"MOTION_PLATFORM_MODE_ENGAGED":       MOTION_PLATFORM_MODE_ENGAGED,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MOTION_PLATFORM_MODE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MOTION_PLATFORM_MODE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MOTION_PLATFORM_MODE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MOTION_PLATFORM_MODE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MOTION_PLATFORM_MODE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MOTION_PLATFORM_MODE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
