// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/ai/generativelanguage/v1/generative_service.proto

package generativelanguagepb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	GenerativeService_GenerateContent_FullMethodName       = "/google.ai.generativelanguage.v1.GenerativeService/GenerateContent"
	GenerativeService_StreamGenerateContent_FullMethodName = "/google.ai.generativelanguage.v1.GenerativeService/StreamGenerateContent"
	GenerativeService_EmbedContent_FullMethodName          = "/google.ai.generativelanguage.v1.GenerativeService/EmbedContent"
	GenerativeService_BatchEmbedContents_FullMethodName    = "/google.ai.generativelanguage.v1.GenerativeService/BatchEmbedContents"
	GenerativeService_CountTokens_FullMethodName           = "/google.ai.generativelanguage.v1.GenerativeService/CountTokens"
)

// GenerativeServiceClient is the client API for GenerativeService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GenerativeServiceClient interface {
	// Generates a model response given an input `GenerateContentRequest`.
	// Refer to the [text generation
	// guide](https://ai.google.dev/gemini-api/docs/text-generation) for detailed
	// usage information. Input capabilities differ between models, including
	// tuned models. Refer to the [model
	// guide](https://ai.google.dev/gemini-api/docs/models/gemini) and [tuning
	// guide](https://ai.google.dev/gemini-api/docs/model-tuning) for details.
	GenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (*GenerateContentResponse, error)
	// Generates a [streamed
	// response](https://ai.google.dev/gemini-api/docs/text-generation?lang=python#generate-a-text-stream)
	// from the model given an input `GenerateContentRequest`.
	StreamGenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (GenerativeService_StreamGenerateContentClient, error)
	// Generates a text embedding vector from the input `Content` using the
	// specified [Gemini Embedding
	// model](https://ai.google.dev/gemini-api/docs/models/gemini#text-embedding).
	EmbedContent(ctx context.Context, in *EmbedContentRequest, opts ...grpc.CallOption) (*EmbedContentResponse, error)
	// Generates multiple embedding vectors from the input `Content` which
	// consists of a batch of strings represented as `EmbedContentRequest`
	// objects.
	BatchEmbedContents(ctx context.Context, in *BatchEmbedContentsRequest, opts ...grpc.CallOption) (*BatchEmbedContentsResponse, error)
	// Runs a model's tokenizer on input `Content` and returns the token count.
	// Refer to the [tokens guide](https://ai.google.dev/gemini-api/docs/tokens)
	// to learn more about tokens.
	CountTokens(ctx context.Context, in *CountTokensRequest, opts ...grpc.CallOption) (*CountTokensResponse, error)
}

type generativeServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewGenerativeServiceClient(cc grpc.ClientConnInterface) GenerativeServiceClient {
	return &generativeServiceClient{cc}
}

func (c *generativeServiceClient) GenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (*GenerateContentResponse, error) {
	out := new(GenerateContentResponse)
	err := c.cc.Invoke(ctx, GenerativeService_GenerateContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeServiceClient) StreamGenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (GenerativeService_StreamGenerateContentClient, error) {
	stream, err := c.cc.NewStream(ctx, &GenerativeService_ServiceDesc.Streams[0], GenerativeService_StreamGenerateContent_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &generativeServiceStreamGenerateContentClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type GenerativeService_StreamGenerateContentClient interface {
	Recv() (*GenerateContentResponse, error)
	grpc.ClientStream
}

type generativeServiceStreamGenerateContentClient struct {
	grpc.ClientStream
}

func (x *generativeServiceStreamGenerateContentClient) Recv() (*GenerateContentResponse, error) {
	m := new(GenerateContentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *generativeServiceClient) EmbedContent(ctx context.Context, in *EmbedContentRequest, opts ...grpc.CallOption) (*EmbedContentResponse, error) {
	out := new(EmbedContentResponse)
	err := c.cc.Invoke(ctx, GenerativeService_EmbedContent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeServiceClient) BatchEmbedContents(ctx context.Context, in *BatchEmbedContentsRequest, opts ...grpc.CallOption) (*BatchEmbedContentsResponse, error) {
	out := new(BatchEmbedContentsResponse)
	err := c.cc.Invoke(ctx, GenerativeService_BatchEmbedContents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generativeServiceClient) CountTokens(ctx context.Context, in *CountTokensRequest, opts ...grpc.CallOption) (*CountTokensResponse, error) {
	out := new(CountTokensResponse)
	err := c.cc.Invoke(ctx, GenerativeService_CountTokens_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GenerativeServiceServer is the server API for GenerativeService service.
// All implementations should embed UnimplementedGenerativeServiceServer
// for forward compatibility
type GenerativeServiceServer interface {
	// Generates a model response given an input `GenerateContentRequest`.
	// Refer to the [text generation
	// guide](https://ai.google.dev/gemini-api/docs/text-generation) for detailed
	// usage information. Input capabilities differ between models, including
	// tuned models. Refer to the [model
	// guide](https://ai.google.dev/gemini-api/docs/models/gemini) and [tuning
	// guide](https://ai.google.dev/gemini-api/docs/model-tuning) for details.
	GenerateContent(context.Context, *GenerateContentRequest) (*GenerateContentResponse, error)
	// Generates a [streamed
	// response](https://ai.google.dev/gemini-api/docs/text-generation?lang=python#generate-a-text-stream)
	// from the model given an input `GenerateContentRequest`.
	StreamGenerateContent(*GenerateContentRequest, GenerativeService_StreamGenerateContentServer) error
	// Generates a text embedding vector from the input `Content` using the
	// specified [Gemini Embedding
	// model](https://ai.google.dev/gemini-api/docs/models/gemini#text-embedding).
	EmbedContent(context.Context, *EmbedContentRequest) (*EmbedContentResponse, error)
	// Generates multiple embedding vectors from the input `Content` which
	// consists of a batch of strings represented as `EmbedContentRequest`
	// objects.
	BatchEmbedContents(context.Context, *BatchEmbedContentsRequest) (*BatchEmbedContentsResponse, error)
	// Runs a model's tokenizer on input `Content` and returns the token count.
	// Refer to the [tokens guide](https://ai.google.dev/gemini-api/docs/tokens)
	// to learn more about tokens.
	CountTokens(context.Context, *CountTokensRequest) (*CountTokensResponse, error)
}

// UnimplementedGenerativeServiceServer should be embedded to have forward compatible implementations.
type UnimplementedGenerativeServiceServer struct {
}

func (UnimplementedGenerativeServiceServer) GenerateContent(context.Context, *GenerateContentRequest) (*GenerateContentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateContent not implemented")
}
func (UnimplementedGenerativeServiceServer) StreamGenerateContent(*GenerateContentRequest, GenerativeService_StreamGenerateContentServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamGenerateContent not implemented")
}
func (UnimplementedGenerativeServiceServer) EmbedContent(context.Context, *EmbedContentRequest) (*EmbedContentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method EmbedContent not implemented")
}
func (UnimplementedGenerativeServiceServer) BatchEmbedContents(context.Context, *BatchEmbedContentsRequest) (*BatchEmbedContentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchEmbedContents not implemented")
}
func (UnimplementedGenerativeServiceServer) CountTokens(context.Context, *CountTokensRequest) (*CountTokensResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CountTokens not implemented")
}

// UnsafeGenerativeServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GenerativeServiceServer will
// result in compilation errors.
type UnsafeGenerativeServiceServer interface {
	mustEmbedUnimplementedGenerativeServiceServer()
}

func RegisterGenerativeServiceServer(s grpc.ServiceRegistrar, srv GenerativeServiceServer) {
	s.RegisterService(&GenerativeService_ServiceDesc, srv)
}

func _GenerativeService_GenerateContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeServiceServer).GenerateContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GenerativeService_GenerateContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeServiceServer).GenerateContent(ctx, req.(*GenerateContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeService_StreamGenerateContent_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GenerateContentRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(GenerativeServiceServer).StreamGenerateContent(m, &generativeServiceStreamGenerateContentServer{stream})
}

type GenerativeService_StreamGenerateContentServer interface {
	Send(*GenerateContentResponse) error
	grpc.ServerStream
}

type generativeServiceStreamGenerateContentServer struct {
	grpc.ServerStream
}

func (x *generativeServiceStreamGenerateContentServer) Send(m *GenerateContentResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _GenerativeService_EmbedContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EmbedContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeServiceServer).EmbedContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GenerativeService_EmbedContent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeServiceServer).EmbedContent(ctx, req.(*EmbedContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeService_BatchEmbedContents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchEmbedContentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeServiceServer).BatchEmbedContents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GenerativeService_BatchEmbedContents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeServiceServer).BatchEmbedContents(ctx, req.(*BatchEmbedContentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GenerativeService_CountTokens_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CountTokensRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GenerativeServiceServer).CountTokens(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GenerativeService_CountTokens_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GenerativeServiceServer).CountTokens(ctx, req.(*CountTokensRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GenerativeService_ServiceDesc is the grpc.ServiceDesc for GenerativeService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GenerativeService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.ai.generativelanguage.v1.GenerativeService",
	HandlerType: (*GenerativeServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GenerateContent",
			Handler:    _GenerativeService_GenerateContent_Handler,
		},
		{
			MethodName: "EmbedContent",
			Handler:    _GenerativeService_EmbedContent_Handler,
		},
		{
			MethodName: "BatchEmbedContents",
			Handler:    _GenerativeService_BatchEmbedContents_Handler,
		},
		{
			MethodName: "CountTokens",
			Handler:    _GenerativeService_CountTokens_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamGenerateContent",
			Handler:       _GenerativeService_StreamGenerateContent_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/ai/generativelanguage/v1/generative_service.proto",
}
