package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"

	"strings"
)

// ListVpcChannelsV2Request Request Object
type ListVpcChannelsV2Request struct {

	// 实例ID，在API网关控制台的“实例信息”中获取。
	InstanceId string `json:"instance_id"`

	// 偏移量，表示从此偏移量开始查询，偏移量小于0时，自动转换为0
	Offset *int64 `json:"offset,omitempty"`

	// 每页显示的条目数量，条目数量小于等于0时，自动转换为20，条目数量大于500时，自动转换为500
	Limit *int32 `json:"limit,omitempty"`

	// VPC通道的编号
	Id *string `json:"id,omitempty"`

	// VPC通道的名称
	Name *string `json:"name,omitempty"`

	// VPC通道的字典编码  支持英文，数字，特殊字符（-_.）  暂不支持
	DictCode *string `json:"dict_code,omitempty"`

	// 指定需要精确匹配查找的参数名称，多个参数需要支持精确匹配时参数之间使用“,”隔开。  目前支持name，member_group_name。
	PreciseSearch *string `json:"precise_search,omitempty"`

	// 后端服务地址。默认精确查询，不支持模糊查询。
	MemberHost *string `json:"member_host,omitempty"`

	// 后端服务器端口
	MemberPort *int32 `json:"member_port,omitempty"`

	// 后端服务器组名称
	MemberGroupName *string `json:"member_group_name,omitempty"`

	// 后端服务器组编号
	MemberGroupId *string `json:"member_group_id,omitempty"`

	// vpc通道类型： - builtin：服务器类型 - microservice： 微服务类型 - reference：引用负载通道类型
	VpcChannelType *ListVpcChannelsV2RequestVpcChannelType `json:"vpc_channel_type,omitempty"`
}

func (o ListVpcChannelsV2Request) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ListVpcChannelsV2Request struct{}"
	}

	return strings.Join([]string{"ListVpcChannelsV2Request", string(data)}, " ")
}

type ListVpcChannelsV2RequestVpcChannelType struct {
	value string
}

type ListVpcChannelsV2RequestVpcChannelTypeEnum struct {
	BUILTIN      ListVpcChannelsV2RequestVpcChannelType
	MICROSERVICE ListVpcChannelsV2RequestVpcChannelType
	REFERENCE    ListVpcChannelsV2RequestVpcChannelType
}

func GetListVpcChannelsV2RequestVpcChannelTypeEnum() ListVpcChannelsV2RequestVpcChannelTypeEnum {
	return ListVpcChannelsV2RequestVpcChannelTypeEnum{
		BUILTIN: ListVpcChannelsV2RequestVpcChannelType{
			value: "builtin",
		},
		MICROSERVICE: ListVpcChannelsV2RequestVpcChannelType{
			value: "microservice",
		},
		REFERENCE: ListVpcChannelsV2RequestVpcChannelType{
			value: "reference",
		},
	}
}

func (c ListVpcChannelsV2RequestVpcChannelType) Value() string {
	return c.value
}

func (c ListVpcChannelsV2RequestVpcChannelType) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *ListVpcChannelsV2RequestVpcChannelType) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}
