package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

type SmartConnectTaskReqSourceConfig struct {

	// 当前Kafka实例别名。（仅源端类型为Kafka时需要填写）
	CurrentClusterName *string `json:"current_cluster_name,omitempty"`

	// 对端Kafka实例别名。（仅源端类型为Kafka时需要填写）
	ClusterName *string `json:"cluster_name,omitempty"`

	// 对端Kafka开启SASL_SSL时设置的用户名，或者创建SASL_SSL用户时设置的用户名。（仅源端类型为Kafka且对端Kafka认证方式为“SASL_SSL”时需要填写）
	UserName *string `json:"user_name,omitempty"`

	// 对端Kafka开启SASL_SSL时设置的密码，或者创建SASL_SSL用户时设置的密码。（仅源端类型为Kafka且对端Kafka认证方式为“SASL_SSL”时需要填写）
	Password *string `json:"password,omitempty"`

	// 对端Kafka认证机制。（仅源端类型为Kafka且“认证方式”为“SASL_SSL”时需要填写）
	SaslMechanism *string `json:"sasl_mechanism,omitempty"`

	// 对端Kafka实例ID。（仅源端类型为Kafka时需要填写，instance_id和bootstrap_servers仅需要填写其中一个）
	InstanceId *string `json:"instance_id,omitempty"`

	// 对端Kafka实例地址。（仅源端类型为Kafka时需要填写，instance_id和bootstrap_servers仅需要填写其中一个）
	BootstrapServers *string `json:"bootstrap_servers,omitempty"`

	// 对端Kafka认证方式。（仅源端类型为Kafka需要填写） 支持以下两种认证方式：   - SASL_SSL：表示实例已开启SASL_SSL。   - PLAINTEXT：表示实例未开启SASL_SSL。
	SecurityProtocol *string `json:"security_protocol,omitempty"`

	// 同步方向；pull为把对端Kafka实例数据复制到当前Kafka实例中，push为把当前Kafka实例数据复制到对端Kafka实例中，two-way为对两端Kafka实例数据进行双向复制。（仅源端类型为Kafka时需要填写）
	Direction *string `json:"direction,omitempty"`

	// 是否同步消费进度。（仅源端类型为Kafka时需要填写）
	SyncConsumerOffsetsEnabled *bool `json:"sync_consumer_offsets_enabled,omitempty"`

	// 在对端实例中自动创建Topic时，指定Topic的副本数，此参数值不能超过对端实例的代理数。如果对端实例中设置了“default.replication.factor”，此参数的优先级高于“default.replication.factor”。（仅源端类型为Kafka时需要填写）
	ReplicationFactor *int32 `json:"replication_factor,omitempty"`

	// 数据复制的任务数。默认值为2，建议保持默认值。如果“同步方式”为“双向”，实际任务数=设置的任务数*2。（仅源端类型为Kafka时需要填写）
	TaskNum *int32 `json:"task_num,omitempty"`

	// 是否重命名Topic，在目标Topic名称前添加源端Kafka实例的别名，形成目标Topic新的名称。（仅源端类型为Kafka时需要填写）
	RenameTopicEnabled *bool `json:"rename_topic_enabled,omitempty"`

	// 目标Topic接收复制的消息，此消息header中包含消息来源。两端实例数据双向复制时，请开启“添加来源header”，防止循环复制。（仅源端类型为Kafka时需要填写）
	ProvenanceHeaderEnabled *bool `json:"provenance_header_enabled,omitempty"`

	// 启动偏移量，latest为获取最新的数据，earliest为获取最早的数据。（仅源端类型为Kafka时需要填写）
	ConsumerStrategy *string `json:"consumer_strategy,omitempty"`

	// **参数解释**： 压缩算法。（仅源端类型为Kafka时会显示） **约束限制**： 不涉及。 **取值范围**： - none - gzip - snappy - lz4 - zstd **默认取值**： 不涉及。
	CompressionType *string `json:"compression_type,omitempty"`

	// Topic映射，用于自定义目标端Topic名称。不能同时设置“重命名Topic”和“Topic映射”。Topic映射请按照“源端Topic:目的端Topic”的格式填写，如涉及多个Topic映射，请用“,”分隔开，例如：topic-sc-1:topic-sc-2,topic-sc-3:topic-sc-4。（仅源端类型为Kafka时需要填写）
	TopicsMapping *string `json:"topics_mapping,omitempty"`
}

func (o SmartConnectTaskReqSourceConfig) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "SmartConnectTaskReqSourceConfig struct{}"
	}

	return strings.Join([]string{"SmartConnectTaskReqSourceConfig", string(data)}, " ")
}
