package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// ListEngineProductsResponse Response Object
type ListEngineProductsResponse struct {

	// **参数解释**： 消息引擎类型。 **取值范围**： rabbitmq：RabbitMQ引擎。
	Engine *string `json:"engine,omitempty"`

	// **参数解释**： 支持的产品版本类型。
	Versions *[]string `json:"versions,omitempty"`

	// **参数解释**： 产品规格的详细信息。
	Products       *[]ListEngineProductsEntity `json:"products,omitempty"`
	HttpStatusCode int                         `json:"-"`
}

func (o ListEngineProductsResponse) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ListEngineProductsResponse struct{}"
	}

	return strings.Join([]string{"ListEngineProductsResponse", string(data)}, " ")
}
