// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcommon "go.opentelemetry.io/proto/slim/otlp/common/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyAnyValue(t *testing.T) {
	for name, src := range genTestEncodingValuesAnyValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewAnyValue()
				CopyAnyValue(dest, src)
				assert.Equal(t, src, dest)
				CopyAnyValue(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyAnyValueSlice(t *testing.T) {
	src := []AnyValue{}
	dest := []AnyValue{}
	// Test CopyTo empty
	dest = CopyAnyValueSlice(dest, src)
	assert.Equal(t, []AnyValue{}, dest)

	// Test CopyTo larger slice
	src = GenTestAnyValueSlice()
	dest = CopyAnyValueSlice(dest, src)
	assert.Equal(t, GenTestAnyValueSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyAnyValueSlice(dest, src)
	assert.Equal(t, GenTestAnyValueSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyAnyValueSlice(dest, []AnyValue{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyAnyValueSlice(dest, src)
	assert.Equal(t, GenTestAnyValueSlice(), dest)
}

func TestCopyAnyValuePtrSlice(t *testing.T) {
	src := []*AnyValue{}
	dest := []*AnyValue{}
	// Test CopyTo empty
	dest = CopyAnyValuePtrSlice(dest, src)
	assert.Equal(t, []*AnyValue{}, dest)

	// Test CopyTo larger slice
	src = GenTestAnyValuePtrSlice()
	dest = CopyAnyValuePtrSlice(dest, src)
	assert.Equal(t, GenTestAnyValuePtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyAnyValuePtrSlice(dest, src)
	assert.Equal(t, GenTestAnyValuePtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyAnyValuePtrSlice(dest, []*AnyValue{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyAnyValuePtrSlice(dest, src)
	assert.Equal(t, GenTestAnyValuePtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONAnyValueUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewAnyValue()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewAnyValue(), dest)
}

func TestMarshalAndUnmarshalJSONAnyValue(t *testing.T) {
	for name, src := range genTestEncodingValuesAnyValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewAnyValue()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteAnyValue(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoAnyValueFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesAnyValue() {
		t.Run(name, func(t *testing.T) {
			dest := NewAnyValue()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoAnyValueUnknown(t *testing.T) {
	dest := NewAnyValue()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewAnyValue(), dest)
}

func TestMarshalAndUnmarshalProtoAnyValue(t *testing.T) {
	for name, src := range genTestEncodingValuesAnyValue() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewAnyValue()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteAnyValue(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufAnyValue(t *testing.T) {
	for name, src := range genTestEncodingValuesAnyValue() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcommon.AnyValue{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewAnyValue()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesAnyValue() map[string][]byte {
	return map[string][]byte{
		"invalid_field": {0x02},

		"StringValue/wrong_wire_type": {0xc},
		"StringValue/missing_value":   {0xa},

		"BoolValue/wrong_wire_type": {0x14},
		"BoolValue/missing_value":   {0x10},

		"IntValue/wrong_wire_type": {0x1c},
		"IntValue/missing_value":   {0x18},

		"DoubleValue/wrong_wire_type": {0x24},
		"DoubleValue/missing_value":   {0x21},

		"ArrayValue/wrong_wire_type": {0x2c},
		"ArrayValue/missing_value":   {0x2a},

		"KvlistValue/wrong_wire_type": {0x34},
		"KvlistValue/missing_value":   {0x32},

		"BytesValue/wrong_wire_type": {0x3c},
		"BytesValue/missing_value":   {0x3a},
	}
}

func genTestEncodingValuesAnyValue() map[string]*AnyValue {
	return map[string]*AnyValue{
		"empty":               NewAnyValue(),
		"StringValue/default": {Value: &AnyValue_StringValue{StringValue: ""}},
		"StringValue/test":    {Value: &AnyValue_StringValue{StringValue: "test_stringvalue"}},
		"BoolValue/default":   {Value: &AnyValue_BoolValue{BoolValue: false}},
		"BoolValue/test":      {Value: &AnyValue_BoolValue{BoolValue: true}},
		"IntValue/default":    {Value: &AnyValue_IntValue{IntValue: int64(0)}},
		"IntValue/test":       {Value: &AnyValue_IntValue{IntValue: int64(13)}},
		"DoubleValue/default": {Value: &AnyValue_DoubleValue{DoubleValue: float64(0)}},
		"DoubleValue/test":    {Value: &AnyValue_DoubleValue{DoubleValue: float64(3.1415926)}},
		"ArrayValue/default":  {Value: &AnyValue_ArrayValue{ArrayValue: &ArrayValue{}}},
		"ArrayValue/test":     {Value: &AnyValue_ArrayValue{ArrayValue: GenTestArrayValue()}},
		"KvlistValue/default": {Value: &AnyValue_KvlistValue{KvlistValue: &KeyValueList{}}},
		"KvlistValue/test":    {Value: &AnyValue_KvlistValue{KvlistValue: GenTestKeyValueList()}},
		"BytesValue/default":  {Value: &AnyValue_BytesValue{BytesValue: nil}},
		"BytesValue/test":     {Value: &AnyValue_BytesValue{BytesValue: []byte{1, 2, 3}}},
	}
}
