// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectorlogs "go.opentelemetry.io/proto/slim/otlp/collector/logs/v1"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyExportLogsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewExportLogsPartialSuccess()
				CopyExportLogsPartialSuccess(dest, src)
				assert.Equal(t, src, dest)
				CopyExportLogsPartialSuccess(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyExportLogsPartialSuccessSlice(t *testing.T) {
	src := []ExportLogsPartialSuccess{}
	dest := []ExportLogsPartialSuccess{}
	// Test CopyTo empty
	dest = CopyExportLogsPartialSuccessSlice(dest, src)
	assert.Equal(t, []ExportLogsPartialSuccess{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportLogsPartialSuccessSlice()
	dest = CopyExportLogsPartialSuccessSlice(dest, src)
	assert.Equal(t, GenTestExportLogsPartialSuccessSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportLogsPartialSuccessSlice(dest, src)
	assert.Equal(t, GenTestExportLogsPartialSuccessSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportLogsPartialSuccessSlice(dest, []ExportLogsPartialSuccess{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportLogsPartialSuccessSlice(dest, src)
	assert.Equal(t, GenTestExportLogsPartialSuccessSlice(), dest)
}

func TestCopyExportLogsPartialSuccessPtrSlice(t *testing.T) {
	src := []*ExportLogsPartialSuccess{}
	dest := []*ExportLogsPartialSuccess{}
	// Test CopyTo empty
	dest = CopyExportLogsPartialSuccessPtrSlice(dest, src)
	assert.Equal(t, []*ExportLogsPartialSuccess{}, dest)

	// Test CopyTo larger slice
	src = GenTestExportLogsPartialSuccessPtrSlice()
	dest = CopyExportLogsPartialSuccessPtrSlice(dest, src)
	assert.Equal(t, GenTestExportLogsPartialSuccessPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyExportLogsPartialSuccessPtrSlice(dest, src)
	assert.Equal(t, GenTestExportLogsPartialSuccessPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyExportLogsPartialSuccessPtrSlice(dest, []*ExportLogsPartialSuccess{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyExportLogsPartialSuccessPtrSlice(dest, src)
	assert.Equal(t, GenTestExportLogsPartialSuccessPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONExportLogsPartialSuccessUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewExportLogsPartialSuccess()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewExportLogsPartialSuccess(), dest)
}

func TestMarshalAndUnmarshalJSONExportLogsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewExportLogsPartialSuccess()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteExportLogsPartialSuccess(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoExportLogsPartialSuccessFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportLogsPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			dest := NewExportLogsPartialSuccess()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoExportLogsPartialSuccessUnknown(t *testing.T) {
	dest := NewExportLogsPartialSuccess()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewExportLogsPartialSuccess(), dest)
}

func TestMarshalAndUnmarshalProtoExportLogsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsPartialSuccess() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewExportLogsPartialSuccess()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteExportLogsPartialSuccess(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportLogsPartialSuccess(t *testing.T) {
	for name, src := range genTestEncodingValuesExportLogsPartialSuccess() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectorlogs.ExportLogsPartialSuccess{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewExportLogsPartialSuccess()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportLogsPartialSuccess() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                      {0x02},
		"RejectedLogRecords/wrong_wire_type": {0xc},
		"RejectedLogRecords/missing_value":   {0x8},
		"ErrorMessage/wrong_wire_type":       {0x14},
		"ErrorMessage/missing_value":         {0x12},
	}
}

func genTestEncodingValuesExportLogsPartialSuccess() map[string]*ExportLogsPartialSuccess {
	return map[string]*ExportLogsPartialSuccess{
		"empty":                   NewExportLogsPartialSuccess(),
		"RejectedLogRecords/test": {RejectedLogRecords: int64(13)},
		"ErrorMessage/test":       {ErrorMessage: "test_errormessage"},
	}
}
