// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ResourceSpans is a collection of spans from a Resource.
type ResourceSpans struct {
	Resource             Resource
	ScopeSpans           []*ScopeSpans
	SchemaUrl            string
	DeprecatedScopeSpans []*ScopeSpans
}

var (
	protoPoolResourceSpans = sync.Pool{
		New: func() any {
			return &ResourceSpans{}
		},
	}
)

func NewResourceSpans() *ResourceSpans {
	if !UseProtoPooling.IsEnabled() {
		return &ResourceSpans{}
	}
	return protoPoolResourceSpans.Get().(*ResourceSpans)
}

func DeleteResourceSpans(orig *ResourceSpans, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteResource(&orig.Resource, false)
	for i := range orig.ScopeSpans {
		DeleteScopeSpans(orig.ScopeSpans[i], true)
	}
	for i := range orig.DeprecatedScopeSpans {
		DeleteScopeSpans(orig.DeprecatedScopeSpans[i], true)
	}

	orig.Reset()
	if nullable {
		protoPoolResourceSpans.Put(orig)
	}
}

func CopyResourceSpans(dest, src *ResourceSpans) *ResourceSpans {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewResourceSpans()
	}
	CopyResource(&dest.Resource, &src.Resource)

	dest.ScopeSpans = CopyScopeSpansPtrSlice(dest.ScopeSpans, src.ScopeSpans)

	dest.SchemaUrl = src.SchemaUrl

	dest.DeprecatedScopeSpans = CopyScopeSpansPtrSlice(dest.DeprecatedScopeSpans, src.DeprecatedScopeSpans)

	return dest
}

func CopyResourceSpansSlice(dest, src []ResourceSpans) []ResourceSpans {
	var newDest []ResourceSpans
	if cap(dest) < len(src) {
		newDest = make([]ResourceSpans, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteResourceSpans(&dest[i], false)
		}
	}
	for i := range src {
		CopyResourceSpans(&newDest[i], &src[i])
	}
	return newDest
}

func CopyResourceSpansPtrSlice(dest, src []*ResourceSpans) []*ResourceSpans {
	var newDest []*ResourceSpans
	if cap(dest) < len(src) {
		newDest = make([]*ResourceSpans, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewResourceSpans()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteResourceSpans(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewResourceSpans()
		}
	}
	for i := range src {
		CopyResourceSpans(newDest[i], src[i])
	}
	return newDest
}

func (orig *ResourceSpans) Reset() {
	*orig = ResourceSpans{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ResourceSpans) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	dest.WriteObjectField("resource")
	orig.Resource.MarshalJSON(dest)
	if len(orig.ScopeSpans) > 0 {
		dest.WriteObjectField("scopeSpans")
		dest.WriteArrayStart()
		orig.ScopeSpans[0].MarshalJSON(dest)
		for i := 1; i < len(orig.ScopeSpans); i++ {
			dest.WriteMore()
			orig.ScopeSpans[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.SchemaUrl != "" {
		dest.WriteObjectField("schemaUrl")
		dest.WriteString(orig.SchemaUrl)
	}
	if len(orig.DeprecatedScopeSpans) > 0 {
		dest.WriteObjectField("deprecatedScopeSpans")
		dest.WriteArrayStart()
		orig.DeprecatedScopeSpans[0].MarshalJSON(dest)
		for i := 1; i < len(orig.DeprecatedScopeSpans); i++ {
			dest.WriteMore()
			orig.DeprecatedScopeSpans[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ResourceSpans) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "resource":

			orig.Resource.UnmarshalJSON(iter)
		case "scopeSpans", "scope_spans":
			for iter.ReadArray() {
				orig.ScopeSpans = append(orig.ScopeSpans, NewScopeSpans())
				orig.ScopeSpans[len(orig.ScopeSpans)-1].UnmarshalJSON(iter)
			}

		case "schemaUrl", "schema_url":
			orig.SchemaUrl = iter.ReadString()
		case "deprecatedScopeSpans", "deprecated_scope_spans":
			for iter.ReadArray() {
				orig.DeprecatedScopeSpans = append(orig.DeprecatedScopeSpans, NewScopeSpans())
				orig.DeprecatedScopeSpans[len(orig.DeprecatedScopeSpans)-1].UnmarshalJSON(iter)
			}

		default:
			iter.Skip()
		}
	}
}

func (orig *ResourceSpans) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.Resource.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	for i := range orig.ScopeSpans {
		l = orig.ScopeSpans[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.DeprecatedScopeSpans {
		l = orig.DeprecatedScopeSpans[i].SizeProto()
		n += 2 + proto.Sov(uint64(l)) + l
	}
	return n
}

func (orig *ResourceSpans) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.Resource.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	for i := len(orig.ScopeSpans) - 1; i >= 0; i-- {
		l = orig.ScopeSpans[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x12
	}
	l = len(orig.SchemaUrl)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.SchemaUrl)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	for i := len(orig.DeprecatedScopeSpans) - 1; i >= 0; i-- {
		l = orig.DeprecatedScopeSpans[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x3e
		pos--
		buf[pos] = 0xc2
	}
	return len(buf) - pos
}

func (orig *ResourceSpans) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Resource", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Resource.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ScopeSpans", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ScopeSpans = append(orig.ScopeSpans, NewScopeSpans())
			err = orig.ScopeSpans[len(orig.ScopeSpans)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SchemaUrl", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.SchemaUrl = string(buf[startPos:pos])

		case 1000:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedScopeSpans", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.DeprecatedScopeSpans = append(orig.DeprecatedScopeSpans, NewScopeSpans())
			err = orig.DeprecatedScopeSpans[len(orig.DeprecatedScopeSpans)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestResourceSpans() *ResourceSpans {
	orig := NewResourceSpans()
	orig.Resource = *GenTestResource()
	orig.ScopeSpans = []*ScopeSpans{{}, GenTestScopeSpans()}
	orig.SchemaUrl = "test_schemaurl"
	orig.DeprecatedScopeSpans = []*ScopeSpans{{}, GenTestScopeSpans()}
	return orig
}

func GenTestResourceSpansPtrSlice() []*ResourceSpans {
	orig := make([]*ResourceSpans, 5)
	orig[0] = NewResourceSpans()
	orig[1] = GenTestResourceSpans()
	orig[2] = NewResourceSpans()
	orig[3] = GenTestResourceSpans()
	orig[4] = NewResourceSpans()
	return orig
}

func GenTestResourceSpansSlice() []ResourceSpans {
	orig := make([]ResourceSpans, 5)
	orig[1] = *GenTestResourceSpans()
	orig[3] = *GenTestResourceSpans()
	return orig
}
