// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpprofiles "go.opentelemetry.io/proto/slim/otlp/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyStack(t *testing.T) {
	for name, src := range genTestEncodingValuesStack() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewStack()
				CopyStack(dest, src)
				assert.Equal(t, src, dest)
				CopyStack(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyStackSlice(t *testing.T) {
	src := []Stack{}
	dest := []Stack{}
	// Test CopyTo empty
	dest = CopyStackSlice(dest, src)
	assert.Equal(t, []Stack{}, dest)

	// Test CopyTo larger slice
	src = GenTestStackSlice()
	dest = CopyStackSlice(dest, src)
	assert.Equal(t, GenTestStackSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyStackSlice(dest, src)
	assert.Equal(t, GenTestStackSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyStackSlice(dest, []Stack{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyStackSlice(dest, src)
	assert.Equal(t, GenTestStackSlice(), dest)
}

func TestCopyStackPtrSlice(t *testing.T) {
	src := []*Stack{}
	dest := []*Stack{}
	// Test CopyTo empty
	dest = CopyStackPtrSlice(dest, src)
	assert.Equal(t, []*Stack{}, dest)

	// Test CopyTo larger slice
	src = GenTestStackPtrSlice()
	dest = CopyStackPtrSlice(dest, src)
	assert.Equal(t, GenTestStackPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyStackPtrSlice(dest, src)
	assert.Equal(t, GenTestStackPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyStackPtrSlice(dest, []*Stack{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyStackPtrSlice(dest, src)
	assert.Equal(t, GenTestStackPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONStackUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewStack()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewStack(), dest)
}

func TestMarshalAndUnmarshalJSONStack(t *testing.T) {
	for name, src := range genTestEncodingValuesStack() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewStack()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteStack(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoStackFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesStack() {
		t.Run(name, func(t *testing.T) {
			dest := NewStack()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoStackUnknown(t *testing.T) {
	dest := NewStack()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewStack(), dest)
}

func TestMarshalAndUnmarshalProtoStack(t *testing.T) {
	for name, src := range genTestEncodingValuesStack() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewStack()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteStack(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufStack(t *testing.T) {
	for name, src := range genTestEncodingValuesStack() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpprofiles.Stack{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewStack()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesStack() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                   {0x02},
		"LocationIndices/wrong_wire_type": {0xc},
		"LocationIndices/missing_value":   {0xa},
	}
}

func genTestEncodingValuesStack() map[string]*Stack {
	return map[string]*Stack{
		"empty":                NewStack(),
		"LocationIndices/test": {LocationIndices: []int32{int32(0), int32(13)}},
	}
}
