// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storage/armstorage"
	"net/http"
	"net/url"
	"regexp"
)

// BlobServicesServer is a fake server for instances of the armstorage.BlobServicesClient type.
type BlobServicesServer struct {
	// GetServiceProperties is the fake for method BlobServicesClient.GetServiceProperties
	// HTTP status codes to indicate success: http.StatusOK
	GetServiceProperties func(ctx context.Context, resourceGroupName string, accountName string, options *armstorage.BlobServicesClientGetServicePropertiesOptions) (resp azfake.Responder[armstorage.BlobServicesClientGetServicePropertiesResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method BlobServicesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, accountName string, options *armstorage.BlobServicesClientListOptions) (resp azfake.PagerResponder[armstorage.BlobServicesClientListResponse])

	// SetServiceProperties is the fake for method BlobServicesClient.SetServiceProperties
	// HTTP status codes to indicate success: http.StatusOK
	SetServiceProperties func(ctx context.Context, resourceGroupName string, accountName string, parameters armstorage.BlobServiceProperties, options *armstorage.BlobServicesClientSetServicePropertiesOptions) (resp azfake.Responder[armstorage.BlobServicesClientSetServicePropertiesResponse], errResp azfake.ErrorResponder)
}

// NewBlobServicesServerTransport creates a new instance of BlobServicesServerTransport with the provided implementation.
// The returned BlobServicesServerTransport instance is connected to an instance of armstorage.BlobServicesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewBlobServicesServerTransport(srv *BlobServicesServer) *BlobServicesServerTransport {
	return &BlobServicesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armstorage.BlobServicesClientListResponse]](),
	}
}

// BlobServicesServerTransport connects instances of armstorage.BlobServicesClient to instances of BlobServicesServer.
// Don't use this type directly, use NewBlobServicesServerTransport instead.
type BlobServicesServerTransport struct {
	srv          *BlobServicesServer
	newListPager *tracker[azfake.PagerResponder[armstorage.BlobServicesClientListResponse]]
}

// Do implements the policy.Transporter interface for BlobServicesServerTransport.
func (b *BlobServicesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	return b.dispatchToMethodFake(req, method)
}

func (b *BlobServicesServerTransport) dispatchToMethodFake(req *http.Request, method string) (*http.Response, error) {
	resultChan := make(chan result)
	defer close(resultChan)

	go func() {
		var intercepted bool
		var res result
		if blobServicesServerTransportInterceptor != nil {
			res.resp, res.err, intercepted = blobServicesServerTransportInterceptor.Do(req)
		}
		if !intercepted {
			switch method {
			case "BlobServicesClient.GetServiceProperties":
				res.resp, res.err = b.dispatchGetServiceProperties(req)
			case "BlobServicesClient.NewListPager":
				res.resp, res.err = b.dispatchNewListPager(req)
			case "BlobServicesClient.SetServiceProperties":
				res.resp, res.err = b.dispatchSetServiceProperties(req)
			default:
				res.err = fmt.Errorf("unhandled API %s", method)
			}

		}
		select {
		case resultChan <- res:
		case <-req.Context().Done():
		}
	}()

	select {
	case <-req.Context().Done():
		return nil, req.Context().Err()
	case res := <-resultChan:
		return res.resp, res.err
	}
}

func (b *BlobServicesServerTransport) dispatchGetServiceProperties(req *http.Request) (*http.Response, error) {
	if b.srv.GetServiceProperties == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetServiceProperties not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/blobServices/(?P<BlobServicesName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.GetServiceProperties(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BlobServiceProperties, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (b *BlobServicesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if b.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := b.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/blobServices`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		resp := b.srv.NewListPager(resourceGroupNameParam, accountNameParam, nil)
		newListPager = &resp
		b.newListPager.add(req, newListPager)
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		b.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		b.newListPager.remove(req)
	}
	return resp, nil
}

func (b *BlobServicesServerTransport) dispatchSetServiceProperties(req *http.Request) (*http.Response, error) {
	if b.srv.SetServiceProperties == nil {
		return nil, &nonRetriableError{errors.New("fake for method SetServiceProperties not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/blobServices/(?P<BlobServicesName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorage.BlobServiceProperties](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := b.srv.SetServiceProperties(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).BlobServiceProperties, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// set this to conditionally intercept incoming requests to BlobServicesServerTransport
var blobServicesServerTransportInterceptor interface {
	// Do returns true if the server transport should use the returned response/error
	Do(*http.Request) (*http.Response, error, bool)
}
