// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storage/armstorage"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// FileServicesServer is a fake server for instances of the armstorage.FileServicesClient type.
type FileServicesServer struct {
	// GetServiceProperties is the fake for method FileServicesClient.GetServiceProperties
	// HTTP status codes to indicate success: http.StatusOK
	GetServiceProperties func(ctx context.Context, resourceGroupName string, accountName string, options *armstorage.FileServicesClientGetServicePropertiesOptions) (resp azfake.Responder[armstorage.FileServicesClientGetServicePropertiesResponse], errResp azfake.ErrorResponder)

	// GetServiceUsage is the fake for method FileServicesClient.GetServiceUsage
	// HTTP status codes to indicate success: http.StatusOK
	GetServiceUsage func(ctx context.Context, resourceGroupName string, accountName string, options *armstorage.FileServicesClientGetServiceUsageOptions) (resp azfake.Responder[armstorage.FileServicesClientGetServiceUsageResponse], errResp azfake.ErrorResponder)

	// List is the fake for method FileServicesClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, accountName string, options *armstorage.FileServicesClientListOptions) (resp azfake.Responder[armstorage.FileServicesClientListResponse], errResp azfake.ErrorResponder)

	// NewListServiceUsagesPager is the fake for method FileServicesClient.NewListServiceUsagesPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListServiceUsagesPager func(resourceGroupName string, accountName string, options *armstorage.FileServicesClientListServiceUsagesOptions) (resp azfake.PagerResponder[armstorage.FileServicesClientListServiceUsagesResponse])

	// SetServiceProperties is the fake for method FileServicesClient.SetServiceProperties
	// HTTP status codes to indicate success: http.StatusOK
	SetServiceProperties func(ctx context.Context, resourceGroupName string, accountName string, parameters armstorage.FileServiceProperties, options *armstorage.FileServicesClientSetServicePropertiesOptions) (resp azfake.Responder[armstorage.FileServicesClientSetServicePropertiesResponse], errResp azfake.ErrorResponder)
}

// NewFileServicesServerTransport creates a new instance of FileServicesServerTransport with the provided implementation.
// The returned FileServicesServerTransport instance is connected to an instance of armstorage.FileServicesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewFileServicesServerTransport(srv *FileServicesServer) *FileServicesServerTransport {
	return &FileServicesServerTransport{
		srv:                       srv,
		newListServiceUsagesPager: newTracker[azfake.PagerResponder[armstorage.FileServicesClientListServiceUsagesResponse]](),
	}
}

// FileServicesServerTransport connects instances of armstorage.FileServicesClient to instances of FileServicesServer.
// Don't use this type directly, use NewFileServicesServerTransport instead.
type FileServicesServerTransport struct {
	srv                       *FileServicesServer
	newListServiceUsagesPager *tracker[azfake.PagerResponder[armstorage.FileServicesClientListServiceUsagesResponse]]
}

// Do implements the policy.Transporter interface for FileServicesServerTransport.
func (f *FileServicesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	return f.dispatchToMethodFake(req, method)
}

func (f *FileServicesServerTransport) dispatchToMethodFake(req *http.Request, method string) (*http.Response, error) {
	resultChan := make(chan result)
	defer close(resultChan)

	go func() {
		var intercepted bool
		var res result
		if fileServicesServerTransportInterceptor != nil {
			res.resp, res.err, intercepted = fileServicesServerTransportInterceptor.Do(req)
		}
		if !intercepted {
			switch method {
			case "FileServicesClient.GetServiceProperties":
				res.resp, res.err = f.dispatchGetServiceProperties(req)
			case "FileServicesClient.GetServiceUsage":
				res.resp, res.err = f.dispatchGetServiceUsage(req)
			case "FileServicesClient.List":
				res.resp, res.err = f.dispatchList(req)
			case "FileServicesClient.NewListServiceUsagesPager":
				res.resp, res.err = f.dispatchNewListServiceUsagesPager(req)
			case "FileServicesClient.SetServiceProperties":
				res.resp, res.err = f.dispatchSetServiceProperties(req)
			default:
				res.err = fmt.Errorf("unhandled API %s", method)
			}

		}
		select {
		case resultChan <- res:
		case <-req.Context().Done():
		}
	}()

	select {
	case <-req.Context().Done():
		return nil, req.Context().Err()
	case res := <-resultChan:
		return res.resp, res.err
	}
}

func (f *FileServicesServerTransport) dispatchGetServiceProperties(req *http.Request) (*http.Response, error) {
	if f.srv.GetServiceProperties == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetServiceProperties not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fileServices/(?P<FileServicesName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.GetServiceProperties(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FileServiceProperties, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FileServicesServerTransport) dispatchGetServiceUsage(req *http.Request) (*http.Response, error) {
	if f.srv.GetServiceUsage == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetServiceUsage not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fileServices/(?P<FileServicesName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/usages/(?P<fileServiceUsagesName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.GetServiceUsage(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FileServiceUsage, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FileServicesServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if f.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fileServices`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.List(req.Context(), resourceGroupNameParam, accountNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FileServiceItems, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (f *FileServicesServerTransport) dispatchNewListServiceUsagesPager(req *http.Request) (*http.Response, error) {
	if f.srv.NewListServiceUsagesPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListServiceUsagesPager not implemented")}
	}
	newListServiceUsagesPager := f.newListServiceUsagesPager.get(req)
	if newListServiceUsagesPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fileServices/(?P<FileServicesName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/usages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
		if err != nil {
			return nil, err
		}
		maxpagesizeUnescaped, err := url.QueryUnescape(qp.Get("$maxpagesize"))
		if err != nil {
			return nil, err
		}
		maxpagesizeParam, err := parseOptional(maxpagesizeUnescaped, func(v string) (int32, error) {
			p, parseErr := strconv.ParseInt(v, 10, 32)
			if parseErr != nil {
				return 0, parseErr
			}
			return int32(p), nil
		})
		if err != nil {
			return nil, err
		}
		var options *armstorage.FileServicesClientListServiceUsagesOptions
		if maxpagesizeParam != nil {
			options = &armstorage.FileServicesClientListServiceUsagesOptions{
				Maxpagesize: maxpagesizeParam,
			}
		}
		resp := f.srv.NewListServiceUsagesPager(resourceGroupNameParam, accountNameParam, options)
		newListServiceUsagesPager = &resp
		f.newListServiceUsagesPager.add(req, newListServiceUsagesPager)
		server.PagerResponderInjectNextLinks(newListServiceUsagesPager, req, func(page *armstorage.FileServicesClientListServiceUsagesResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListServiceUsagesPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		f.newListServiceUsagesPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListServiceUsagesPager) {
		f.newListServiceUsagesPager.remove(req)
	}
	return resp, nil
}

func (f *FileServicesServerTransport) dispatchSetServiceProperties(req *http.Request) (*http.Response, error) {
	if f.srv.SetServiceProperties == nil {
		return nil, &nonRetriableError{errors.New("fake for method SetServiceProperties not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Storage/storageAccounts/(?P<accountName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/fileServices/(?P<FileServicesName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armstorage.FileServiceProperties](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	accountNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("accountName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := f.srv.SetServiceProperties(req.Context(), resourceGroupNameParam, accountNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).FileServiceProperties, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// set this to conditionally intercept incoming requests to FileServicesServerTransport
var fileServicesServerTransportInterceptor interface {
	// Do returns true if the server transport should use the returned response/error
	Do(*http.Request) (*http.Response, error, bool)
}
