// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2/conversation_model.proto

package dialogflowpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ConversationModels_CreateConversationModel_FullMethodName           = "/google.cloud.dialogflow.v2.ConversationModels/CreateConversationModel"
	ConversationModels_GetConversationModel_FullMethodName              = "/google.cloud.dialogflow.v2.ConversationModels/GetConversationModel"
	ConversationModels_ListConversationModels_FullMethodName            = "/google.cloud.dialogflow.v2.ConversationModels/ListConversationModels"
	ConversationModels_DeleteConversationModel_FullMethodName           = "/google.cloud.dialogflow.v2.ConversationModels/DeleteConversationModel"
	ConversationModels_DeployConversationModel_FullMethodName           = "/google.cloud.dialogflow.v2.ConversationModels/DeployConversationModel"
	ConversationModels_UndeployConversationModel_FullMethodName         = "/google.cloud.dialogflow.v2.ConversationModels/UndeployConversationModel"
	ConversationModels_GetConversationModelEvaluation_FullMethodName    = "/google.cloud.dialogflow.v2.ConversationModels/GetConversationModelEvaluation"
	ConversationModels_ListConversationModelEvaluations_FullMethodName  = "/google.cloud.dialogflow.v2.ConversationModels/ListConversationModelEvaluations"
	ConversationModels_CreateConversationModelEvaluation_FullMethodName = "/google.cloud.dialogflow.v2.ConversationModels/CreateConversationModelEvaluation"
)

// ConversationModelsClient is the client API for ConversationModels service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ConversationModelsClient interface {
	// Creates a model.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [CreateConversationModelOperationMetadata][google.cloud.dialogflow.v2.CreateConversationModelOperationMetadata]
	// - `response`:
	// [ConversationModel][google.cloud.dialogflow.v2.ConversationModel]
	CreateConversationModel(ctx context.Context, in *CreateConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets conversation model.
	GetConversationModel(ctx context.Context, in *GetConversationModelRequest, opts ...grpc.CallOption) (*ConversationModel, error)
	// Lists conversation models.
	ListConversationModels(ctx context.Context, in *ListConversationModelsRequest, opts ...grpc.CallOption) (*ListConversationModelsResponse, error)
	// Deletes a model.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [DeleteConversationModelOperationMetadata][google.cloud.dialogflow.v2.DeleteConversationModelOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	DeleteConversationModel(ctx context.Context, in *DeleteConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deploys a model. If a model is already deployed, deploying it
	// has no effect. A model can only serve prediction requests after it gets
	// deployed. For article suggestion, custom model will not be used unless
	// it is deployed.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [DeployConversationModelOperationMetadata][google.cloud.dialogflow.v2.DeployConversationModelOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	DeployConversationModel(ctx context.Context, in *DeployConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Undeploys a model. If the model is not deployed this method has no effect.
	// If the model is currently being used:
	//   - For article suggestion, article suggestion will fallback to the default
	//     model if model is undeployed.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [UndeployConversationModelOperationMetadata][google.cloud.dialogflow.v2.UndeployConversationModelOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	UndeployConversationModel(ctx context.Context, in *UndeployConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an evaluation of conversation model.
	GetConversationModelEvaluation(ctx context.Context, in *GetConversationModelEvaluationRequest, opts ...grpc.CallOption) (*ConversationModelEvaluation, error)
	// Lists evaluations of a conversation model.
	ListConversationModelEvaluations(ctx context.Context, in *ListConversationModelEvaluationsRequest, opts ...grpc.CallOption) (*ListConversationModelEvaluationsResponse, error)
	// Creates evaluation of a conversation model.
	CreateConversationModelEvaluation(ctx context.Context, in *CreateConversationModelEvaluationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type conversationModelsClient struct {
	cc grpc.ClientConnInterface
}

func NewConversationModelsClient(cc grpc.ClientConnInterface) ConversationModelsClient {
	return &conversationModelsClient{cc}
}

func (c *conversationModelsClient) CreateConversationModel(ctx context.Context, in *CreateConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConversationModels_CreateConversationModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) GetConversationModel(ctx context.Context, in *GetConversationModelRequest, opts ...grpc.CallOption) (*ConversationModel, error) {
	out := new(ConversationModel)
	err := c.cc.Invoke(ctx, ConversationModels_GetConversationModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) ListConversationModels(ctx context.Context, in *ListConversationModelsRequest, opts ...grpc.CallOption) (*ListConversationModelsResponse, error) {
	out := new(ListConversationModelsResponse)
	err := c.cc.Invoke(ctx, ConversationModels_ListConversationModels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) DeleteConversationModel(ctx context.Context, in *DeleteConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConversationModels_DeleteConversationModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) DeployConversationModel(ctx context.Context, in *DeployConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConversationModels_DeployConversationModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) UndeployConversationModel(ctx context.Context, in *UndeployConversationModelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConversationModels_UndeployConversationModel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) GetConversationModelEvaluation(ctx context.Context, in *GetConversationModelEvaluationRequest, opts ...grpc.CallOption) (*ConversationModelEvaluation, error) {
	out := new(ConversationModelEvaluation)
	err := c.cc.Invoke(ctx, ConversationModels_GetConversationModelEvaluation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) ListConversationModelEvaluations(ctx context.Context, in *ListConversationModelEvaluationsRequest, opts ...grpc.CallOption) (*ListConversationModelEvaluationsResponse, error) {
	out := new(ListConversationModelEvaluationsResponse)
	err := c.cc.Invoke(ctx, ConversationModels_ListConversationModelEvaluations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationModelsClient) CreateConversationModelEvaluation(ctx context.Context, in *CreateConversationModelEvaluationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ConversationModels_CreateConversationModelEvaluation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversationModelsServer is the server API for ConversationModels service.
// All implementations should embed UnimplementedConversationModelsServer
// for forward compatibility
type ConversationModelsServer interface {
	// Creates a model.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [CreateConversationModelOperationMetadata][google.cloud.dialogflow.v2.CreateConversationModelOperationMetadata]
	// - `response`:
	// [ConversationModel][google.cloud.dialogflow.v2.ConversationModel]
	CreateConversationModel(context.Context, *CreateConversationModelRequest) (*longrunningpb.Operation, error)
	// Gets conversation model.
	GetConversationModel(context.Context, *GetConversationModelRequest) (*ConversationModel, error)
	// Lists conversation models.
	ListConversationModels(context.Context, *ListConversationModelsRequest) (*ListConversationModelsResponse, error)
	// Deletes a model.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [DeleteConversationModelOperationMetadata][google.cloud.dialogflow.v2.DeleteConversationModelOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	DeleteConversationModel(context.Context, *DeleteConversationModelRequest) (*longrunningpb.Operation, error)
	// Deploys a model. If a model is already deployed, deploying it
	// has no effect. A model can only serve prediction requests after it gets
	// deployed. For article suggestion, custom model will not be used unless
	// it is deployed.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [DeployConversationModelOperationMetadata][google.cloud.dialogflow.v2.DeployConversationModelOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	DeployConversationModel(context.Context, *DeployConversationModelRequest) (*longrunningpb.Operation, error)
	// Undeploys a model. If the model is not deployed this method has no effect.
	// If the model is currently being used:
	//   - For article suggestion, article suggestion will fallback to the default
	//     model if model is undeployed.
	//
	// This method is a [long-running
	// operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
	// The returned `Operation` type has the following method-specific fields:
	//
	// - `metadata`:
	// [UndeployConversationModelOperationMetadata][google.cloud.dialogflow.v2.UndeployConversationModelOperationMetadata]
	//   - `response`: An [Empty
	//     message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
	UndeployConversationModel(context.Context, *UndeployConversationModelRequest) (*longrunningpb.Operation, error)
	// Gets an evaluation of conversation model.
	GetConversationModelEvaluation(context.Context, *GetConversationModelEvaluationRequest) (*ConversationModelEvaluation, error)
	// Lists evaluations of a conversation model.
	ListConversationModelEvaluations(context.Context, *ListConversationModelEvaluationsRequest) (*ListConversationModelEvaluationsResponse, error)
	// Creates evaluation of a conversation model.
	CreateConversationModelEvaluation(context.Context, *CreateConversationModelEvaluationRequest) (*longrunningpb.Operation, error)
}

// UnimplementedConversationModelsServer should be embedded to have forward compatible implementations.
type UnimplementedConversationModelsServer struct {
}

func (UnimplementedConversationModelsServer) CreateConversationModel(context.Context, *CreateConversationModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversationModel not implemented")
}
func (UnimplementedConversationModelsServer) GetConversationModel(context.Context, *GetConversationModelRequest) (*ConversationModel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversationModel not implemented")
}
func (UnimplementedConversationModelsServer) ListConversationModels(context.Context, *ListConversationModelsRequest) (*ListConversationModelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversationModels not implemented")
}
func (UnimplementedConversationModelsServer) DeleteConversationModel(context.Context, *DeleteConversationModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversationModel not implemented")
}
func (UnimplementedConversationModelsServer) DeployConversationModel(context.Context, *DeployConversationModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeployConversationModel not implemented")
}
func (UnimplementedConversationModelsServer) UndeployConversationModel(context.Context, *UndeployConversationModelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeployConversationModel not implemented")
}
func (UnimplementedConversationModelsServer) GetConversationModelEvaluation(context.Context, *GetConversationModelEvaluationRequest) (*ConversationModelEvaluation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversationModelEvaluation not implemented")
}
func (UnimplementedConversationModelsServer) ListConversationModelEvaluations(context.Context, *ListConversationModelEvaluationsRequest) (*ListConversationModelEvaluationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversationModelEvaluations not implemented")
}
func (UnimplementedConversationModelsServer) CreateConversationModelEvaluation(context.Context, *CreateConversationModelEvaluationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateConversationModelEvaluation not implemented")
}

// UnsafeConversationModelsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ConversationModelsServer will
// result in compilation errors.
type UnsafeConversationModelsServer interface {
	mustEmbedUnimplementedConversationModelsServer()
}

func RegisterConversationModelsServer(s grpc.ServiceRegistrar, srv ConversationModelsServer) {
	s.RegisterService(&ConversationModels_ServiceDesc, srv)
}

func _ConversationModels_CreateConversationModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversationModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).CreateConversationModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationModels_CreateConversationModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).CreateConversationModel(ctx, req.(*CreateConversationModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_GetConversationModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).GetConversationModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationModels_GetConversationModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).GetConversationModel(ctx, req.(*GetConversationModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_ListConversationModels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationModelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).ListConversationModels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationModels_ListConversationModels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).ListConversationModels(ctx, req.(*ListConversationModelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_DeleteConversationModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversationModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).DeleteConversationModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationModels_DeleteConversationModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).DeleteConversationModel(ctx, req.(*DeleteConversationModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_DeployConversationModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeployConversationModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).DeployConversationModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationModels_DeployConversationModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).DeployConversationModel(ctx, req.(*DeployConversationModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_UndeployConversationModel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeployConversationModelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).UndeployConversationModel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationModels_UndeployConversationModel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).UndeployConversationModel(ctx, req.(*UndeployConversationModelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_GetConversationModelEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationModelEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).GetConversationModelEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationModels_GetConversationModelEvaluation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).GetConversationModelEvaluation(ctx, req.(*GetConversationModelEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_ListConversationModelEvaluations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationModelEvaluationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).ListConversationModelEvaluations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationModels_ListConversationModelEvaluations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).ListConversationModelEvaluations(ctx, req.(*ListConversationModelEvaluationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationModels_CreateConversationModelEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateConversationModelEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationModelsServer).CreateConversationModelEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationModels_CreateConversationModelEvaluation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationModelsServer).CreateConversationModelEvaluation(ctx, req.(*CreateConversationModelEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ConversationModels_ServiceDesc is the grpc.ServiceDesc for ConversationModels service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ConversationModels_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2.ConversationModels",
	HandlerType: (*ConversationModelsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateConversationModel",
			Handler:    _ConversationModels_CreateConversationModel_Handler,
		},
		{
			MethodName: "GetConversationModel",
			Handler:    _ConversationModels_GetConversationModel_Handler,
		},
		{
			MethodName: "ListConversationModels",
			Handler:    _ConversationModels_ListConversationModels_Handler,
		},
		{
			MethodName: "DeleteConversationModel",
			Handler:    _ConversationModels_DeleteConversationModel_Handler,
		},
		{
			MethodName: "DeployConversationModel",
			Handler:    _ConversationModels_DeployConversationModel_Handler,
		},
		{
			MethodName: "UndeployConversationModel",
			Handler:    _ConversationModels_UndeployConversationModel_Handler,
		},
		{
			MethodName: "GetConversationModelEvaluation",
			Handler:    _ConversationModels_GetConversationModelEvaluation_Handler,
		},
		{
			MethodName: "ListConversationModelEvaluations",
			Handler:    _ConversationModels_ListConversationModelEvaluations_Handler,
		},
		{
			MethodName: "CreateConversationModelEvaluation",
			Handler:    _ConversationModels_CreateConversationModelEvaluation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2/conversation_model.proto",
}
