// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2beta1/phone_number.proto

package dialogflowpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PhoneNumbers_ListPhoneNumbers_FullMethodName    = "/google.cloud.dialogflow.v2beta1.PhoneNumbers/ListPhoneNumbers"
	PhoneNumbers_UpdatePhoneNumber_FullMethodName   = "/google.cloud.dialogflow.v2beta1.PhoneNumbers/UpdatePhoneNumber"
	PhoneNumbers_DeletePhoneNumber_FullMethodName   = "/google.cloud.dialogflow.v2beta1.PhoneNumbers/DeletePhoneNumber"
	PhoneNumbers_UndeletePhoneNumber_FullMethodName = "/google.cloud.dialogflow.v2beta1.PhoneNumbers/UndeletePhoneNumber"
)

// PhoneNumbersClient is the client API for PhoneNumbers service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PhoneNumbersClient interface {
	// Returns the list of all phone numbers in the specified project.
	ListPhoneNumbers(ctx context.Context, in *ListPhoneNumbersRequest, opts ...grpc.CallOption) (*ListPhoneNumbersResponse, error)
	// Updates the specified `PhoneNumber`.
	UpdatePhoneNumber(ctx context.Context, in *UpdatePhoneNumberRequest, opts ...grpc.CallOption) (*PhoneNumber, error)
	// Requests deletion of a `PhoneNumber`. The `PhoneNumber` is moved into the
	// [DELETE_REQUESTED][google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState.DELETE_REQUESTED]
	// state immediately, and is deleted approximately 30 days later. This method
	// may only be called on a `PhoneNumber` in the
	// [ACTIVE][google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState.ACTIVE]
	// state.
	DeletePhoneNumber(ctx context.Context, in *DeletePhoneNumberRequest, opts ...grpc.CallOption) (*PhoneNumber, error)
	// Cancels the deletion request for a `PhoneNumber`. This method may only be
	// called on a `PhoneNumber` in the
	// [DELETE_REQUESTED][google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState.DELETE_REQUESTED]
	// state.
	UndeletePhoneNumber(ctx context.Context, in *UndeletePhoneNumberRequest, opts ...grpc.CallOption) (*PhoneNumber, error)
}

type phoneNumbersClient struct {
	cc grpc.ClientConnInterface
}

func NewPhoneNumbersClient(cc grpc.ClientConnInterface) PhoneNumbersClient {
	return &phoneNumbersClient{cc}
}

func (c *phoneNumbersClient) ListPhoneNumbers(ctx context.Context, in *ListPhoneNumbersRequest, opts ...grpc.CallOption) (*ListPhoneNumbersResponse, error) {
	out := new(ListPhoneNumbersResponse)
	err := c.cc.Invoke(ctx, PhoneNumbers_ListPhoneNumbers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *phoneNumbersClient) UpdatePhoneNumber(ctx context.Context, in *UpdatePhoneNumberRequest, opts ...grpc.CallOption) (*PhoneNumber, error) {
	out := new(PhoneNumber)
	err := c.cc.Invoke(ctx, PhoneNumbers_UpdatePhoneNumber_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *phoneNumbersClient) DeletePhoneNumber(ctx context.Context, in *DeletePhoneNumberRequest, opts ...grpc.CallOption) (*PhoneNumber, error) {
	out := new(PhoneNumber)
	err := c.cc.Invoke(ctx, PhoneNumbers_DeletePhoneNumber_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *phoneNumbersClient) UndeletePhoneNumber(ctx context.Context, in *UndeletePhoneNumberRequest, opts ...grpc.CallOption) (*PhoneNumber, error) {
	out := new(PhoneNumber)
	err := c.cc.Invoke(ctx, PhoneNumbers_UndeletePhoneNumber_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PhoneNumbersServer is the server API for PhoneNumbers service.
// All implementations should embed UnimplementedPhoneNumbersServer
// for forward compatibility
type PhoneNumbersServer interface {
	// Returns the list of all phone numbers in the specified project.
	ListPhoneNumbers(context.Context, *ListPhoneNumbersRequest) (*ListPhoneNumbersResponse, error)
	// Updates the specified `PhoneNumber`.
	UpdatePhoneNumber(context.Context, *UpdatePhoneNumberRequest) (*PhoneNumber, error)
	// Requests deletion of a `PhoneNumber`. The `PhoneNumber` is moved into the
	// [DELETE_REQUESTED][google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState.DELETE_REQUESTED]
	// state immediately, and is deleted approximately 30 days later. This method
	// may only be called on a `PhoneNumber` in the
	// [ACTIVE][google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState.ACTIVE]
	// state.
	DeletePhoneNumber(context.Context, *DeletePhoneNumberRequest) (*PhoneNumber, error)
	// Cancels the deletion request for a `PhoneNumber`. This method may only be
	// called on a `PhoneNumber` in the
	// [DELETE_REQUESTED][google.cloud.dialogflow.v2beta1.PhoneNumber.LifecycleState.DELETE_REQUESTED]
	// state.
	UndeletePhoneNumber(context.Context, *UndeletePhoneNumberRequest) (*PhoneNumber, error)
}

// UnimplementedPhoneNumbersServer should be embedded to have forward compatible implementations.
type UnimplementedPhoneNumbersServer struct {
}

func (UnimplementedPhoneNumbersServer) ListPhoneNumbers(context.Context, *ListPhoneNumbersRequest) (*ListPhoneNumbersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPhoneNumbers not implemented")
}
func (UnimplementedPhoneNumbersServer) UpdatePhoneNumber(context.Context, *UpdatePhoneNumberRequest) (*PhoneNumber, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePhoneNumber not implemented")
}
func (UnimplementedPhoneNumbersServer) DeletePhoneNumber(context.Context, *DeletePhoneNumberRequest) (*PhoneNumber, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePhoneNumber not implemented")
}
func (UnimplementedPhoneNumbersServer) UndeletePhoneNumber(context.Context, *UndeletePhoneNumberRequest) (*PhoneNumber, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeletePhoneNumber not implemented")
}

// UnsafePhoneNumbersServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PhoneNumbersServer will
// result in compilation errors.
type UnsafePhoneNumbersServer interface {
	mustEmbedUnimplementedPhoneNumbersServer()
}

func RegisterPhoneNumbersServer(s grpc.ServiceRegistrar, srv PhoneNumbersServer) {
	s.RegisterService(&PhoneNumbers_ServiceDesc, srv)
}

func _PhoneNumbers_ListPhoneNumbers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPhoneNumbersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PhoneNumbersServer).ListPhoneNumbers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PhoneNumbers_ListPhoneNumbers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PhoneNumbersServer).ListPhoneNumbers(ctx, req.(*ListPhoneNumbersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PhoneNumbers_UpdatePhoneNumber_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePhoneNumberRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PhoneNumbersServer).UpdatePhoneNumber(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PhoneNumbers_UpdatePhoneNumber_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PhoneNumbersServer).UpdatePhoneNumber(ctx, req.(*UpdatePhoneNumberRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PhoneNumbers_DeletePhoneNumber_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePhoneNumberRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PhoneNumbersServer).DeletePhoneNumber(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PhoneNumbers_DeletePhoneNumber_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PhoneNumbersServer).DeletePhoneNumber(ctx, req.(*DeletePhoneNumberRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PhoneNumbers_UndeletePhoneNumber_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeletePhoneNumberRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PhoneNumbersServer).UndeletePhoneNumber(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PhoneNumbers_UndeletePhoneNumber_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PhoneNumbersServer).UndeletePhoneNumber(ctx, req.(*UndeletePhoneNumberRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PhoneNumbers_ServiceDesc is the grpc.ServiceDesc for PhoneNumbers service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PhoneNumbers_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.PhoneNumbers",
	HandlerType: (*PhoneNumbersServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPhoneNumbers",
			Handler:    _PhoneNumbers_ListPhoneNumbers_Handler,
		},
		{
			MethodName: "UpdatePhoneNumber",
			Handler:    _PhoneNumbers_UpdatePhoneNumber_Handler,
		},
		{
			MethodName: "DeletePhoneNumber",
			Handler:    _PhoneNumbers_DeletePhoneNumber_Handler,
		},
		{
			MethodName: "UndeletePhoneNumber",
			Handler:    _PhoneNumbers_UndeletePhoneNumber_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/phone_number.proto",
}
