//go:build !disable_pgv
// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: envoy/data/dns/v3/dns_table.proto

package dnsv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on DnsTable with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *DnsTable) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DnsTable with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in DnsTableMultiError, or nil
// if none found.
func (m *DnsTable) ValidateAll() error {
	return m.validate(true)
}

func (m *DnsTable) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetExternalRetryCount() > 3 {
		err := DnsTableValidationError{
			field:  "ExternalRetryCount",
			reason: "value must be less than or equal to 3",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetVirtualDomains() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, DnsTableValidationError{
						field:  fmt.Sprintf("VirtualDomains[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, DnsTableValidationError{
						field:  fmt.Sprintf("VirtualDomains[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return DnsTableValidationError{
					field:  fmt.Sprintf("VirtualDomains[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	for idx, item := range m.GetKnownSuffixes() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, DnsTableValidationError{
						field:  fmt.Sprintf("KnownSuffixes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, DnsTableValidationError{
						field:  fmt.Sprintf("KnownSuffixes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return DnsTableValidationError{
					field:  fmt.Sprintf("KnownSuffixes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return DnsTableMultiError(errors)
	}

	return nil
}

// DnsTableMultiError is an error wrapping multiple validation errors returned
// by DnsTable.ValidateAll() if the designated constraints aren't met.
type DnsTableMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DnsTableMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DnsTableMultiError) AllErrors() []error { return m }

// DnsTableValidationError is the validation error returned by
// DnsTable.Validate if the designated constraints aren't met.
type DnsTableValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DnsTableValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DnsTableValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DnsTableValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DnsTableValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DnsTableValidationError) ErrorName() string { return "DnsTableValidationError" }

// Error satisfies the builtin error interface
func (e DnsTableValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDnsTable.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DnsTableValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DnsTableValidationError{}

// Validate checks the field values on DnsTable_AddressList with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *DnsTable_AddressList) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DnsTable_AddressList with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DnsTable_AddressListMultiError, or nil if none found.
func (m *DnsTable_AddressList) ValidateAll() error {
	return m.validate(true)
}

func (m *DnsTable_AddressList) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetAddress()) < 1 {
		err := DnsTable_AddressListValidationError{
			field:  "Address",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetAddress() {
		_, _ = idx, item

		if utf8.RuneCountInString(item) < 3 {
			err := DnsTable_AddressListValidationError{
				field:  fmt.Sprintf("Address[%v]", idx),
				reason: "value length must be at least 3 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return DnsTable_AddressListMultiError(errors)
	}

	return nil
}

// DnsTable_AddressListMultiError is an error wrapping multiple validation
// errors returned by DnsTable_AddressList.ValidateAll() if the designated
// constraints aren't met.
type DnsTable_AddressListMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DnsTable_AddressListMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DnsTable_AddressListMultiError) AllErrors() []error { return m }

// DnsTable_AddressListValidationError is the validation error returned by
// DnsTable_AddressList.Validate if the designated constraints aren't met.
type DnsTable_AddressListValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DnsTable_AddressListValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DnsTable_AddressListValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DnsTable_AddressListValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DnsTable_AddressListValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DnsTable_AddressListValidationError) ErrorName() string {
	return "DnsTable_AddressListValidationError"
}

// Error satisfies the builtin error interface
func (e DnsTable_AddressListValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDnsTable_AddressList.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DnsTable_AddressListValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DnsTable_AddressListValidationError{}

// Validate checks the field values on DnsTable_DnsServiceProtocol with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *DnsTable_DnsServiceProtocol) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DnsTable_DnsServiceProtocol with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DnsTable_DnsServiceProtocolMultiError, or nil if none found.
func (m *DnsTable_DnsServiceProtocol) ValidateAll() error {
	return m.validate(true)
}

func (m *DnsTable_DnsServiceProtocol) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofProtocolConfigPresent := false
	switch v := m.ProtocolConfig.(type) {
	case *DnsTable_DnsServiceProtocol_Number:
		if v == nil {
			err := DnsTable_DnsServiceProtocolValidationError{
				field:  "ProtocolConfig",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofProtocolConfigPresent = true

		if m.GetNumber() >= 255 {
			err := DnsTable_DnsServiceProtocolValidationError{
				field:  "Number",
				reason: "value must be less than 255",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *DnsTable_DnsServiceProtocol_Name:
		if v == nil {
			err := DnsTable_DnsServiceProtocolValidationError{
				field:  "ProtocolConfig",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofProtocolConfigPresent = true

		if utf8.RuneCountInString(m.GetName()) < 1 {
			err := DnsTable_DnsServiceProtocolValidationError{
				field:  "Name",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_DnsTable_DnsServiceProtocol_Name_Pattern.MatchString(m.GetName()) {
			err := DnsTable_DnsServiceProtocolValidationError{
				field:  "Name",
				reason: "value does not match regex pattern \"^:?[0-9a-zA-Z!#$%&'*+-.^_|~`]+$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofProtocolConfigPresent {
		err := DnsTable_DnsServiceProtocolValidationError{
			field:  "ProtocolConfig",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return DnsTable_DnsServiceProtocolMultiError(errors)
	}

	return nil
}

// DnsTable_DnsServiceProtocolMultiError is an error wrapping multiple
// validation errors returned by DnsTable_DnsServiceProtocol.ValidateAll() if
// the designated constraints aren't met.
type DnsTable_DnsServiceProtocolMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DnsTable_DnsServiceProtocolMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DnsTable_DnsServiceProtocolMultiError) AllErrors() []error { return m }

// DnsTable_DnsServiceProtocolValidationError is the validation error returned
// by DnsTable_DnsServiceProtocol.Validate if the designated constraints
// aren't met.
type DnsTable_DnsServiceProtocolValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DnsTable_DnsServiceProtocolValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DnsTable_DnsServiceProtocolValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DnsTable_DnsServiceProtocolValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DnsTable_DnsServiceProtocolValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DnsTable_DnsServiceProtocolValidationError) ErrorName() string {
	return "DnsTable_DnsServiceProtocolValidationError"
}

// Error satisfies the builtin error interface
func (e DnsTable_DnsServiceProtocolValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDnsTable_DnsServiceProtocol.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DnsTable_DnsServiceProtocolValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DnsTable_DnsServiceProtocolValidationError{}

var _DnsTable_DnsServiceProtocol_Name_Pattern = regexp.MustCompile("^:?[0-9a-zA-Z!#$%&'*+-.^_|~`]+$")

// Validate checks the field values on DnsTable_DnsServiceTarget with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *DnsTable_DnsServiceTarget) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DnsTable_DnsServiceTarget with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DnsTable_DnsServiceTargetMultiError, or nil if none found.
func (m *DnsTable_DnsServiceTarget) ValidateAll() error {
	return m.validate(true)
}

func (m *DnsTable_DnsServiceTarget) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetPriority() >= 65536 {
		err := DnsTable_DnsServiceTargetValidationError{
			field:  "Priority",
			reason: "value must be less than 65536",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetWeight() >= 65536 {
		err := DnsTable_DnsServiceTargetValidationError{
			field:  "Weight",
			reason: "value must be less than 65536",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetPort() >= 65536 {
		err := DnsTable_DnsServiceTargetValidationError{
			field:  "Port",
			reason: "value must be less than 65536",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	oneofEndpointTypePresent := false
	switch v := m.EndpointType.(type) {
	case *DnsTable_DnsServiceTarget_HostName:
		if v == nil {
			err := DnsTable_DnsServiceTargetValidationError{
				field:  "EndpointType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofEndpointTypePresent = true

		if utf8.RuneCountInString(m.GetHostName()) < 1 {
			err := DnsTable_DnsServiceTargetValidationError{
				field:  "HostName",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_DnsTable_DnsServiceTarget_HostName_Pattern.MatchString(m.GetHostName()) {
			err := DnsTable_DnsServiceTargetValidationError{
				field:  "HostName",
				reason: "value does not match regex pattern \"^:?[0-9a-zA-Z!#$%&'*+-.^_|~`]+$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	case *DnsTable_DnsServiceTarget_ClusterName:
		if v == nil {
			err := DnsTable_DnsServiceTargetValidationError{
				field:  "EndpointType",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofEndpointTypePresent = true

		if utf8.RuneCountInString(m.GetClusterName()) < 1 {
			err := DnsTable_DnsServiceTargetValidationError{
				field:  "ClusterName",
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if !_DnsTable_DnsServiceTarget_ClusterName_Pattern.MatchString(m.GetClusterName()) {
			err := DnsTable_DnsServiceTargetValidationError{
				field:  "ClusterName",
				reason: "value does not match regex pattern \"^:?[0-9a-zA-Z!#$%&'*+-.^_|~`]+$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofEndpointTypePresent {
		err := DnsTable_DnsServiceTargetValidationError{
			field:  "EndpointType",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return DnsTable_DnsServiceTargetMultiError(errors)
	}

	return nil
}

// DnsTable_DnsServiceTargetMultiError is an error wrapping multiple validation
// errors returned by DnsTable_DnsServiceTarget.ValidateAll() if the
// designated constraints aren't met.
type DnsTable_DnsServiceTargetMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DnsTable_DnsServiceTargetMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DnsTable_DnsServiceTargetMultiError) AllErrors() []error { return m }

// DnsTable_DnsServiceTargetValidationError is the validation error returned by
// DnsTable_DnsServiceTarget.Validate if the designated constraints aren't met.
type DnsTable_DnsServiceTargetValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DnsTable_DnsServiceTargetValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DnsTable_DnsServiceTargetValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DnsTable_DnsServiceTargetValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DnsTable_DnsServiceTargetValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DnsTable_DnsServiceTargetValidationError) ErrorName() string {
	return "DnsTable_DnsServiceTargetValidationError"
}

// Error satisfies the builtin error interface
func (e DnsTable_DnsServiceTargetValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDnsTable_DnsServiceTarget.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DnsTable_DnsServiceTargetValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DnsTable_DnsServiceTargetValidationError{}

var _DnsTable_DnsServiceTarget_HostName_Pattern = regexp.MustCompile("^:?[0-9a-zA-Z!#$%&'*+-.^_|~`]+$")

var _DnsTable_DnsServiceTarget_ClusterName_Pattern = regexp.MustCompile("^:?[0-9a-zA-Z!#$%&'*+-.^_|~`]+$")

// Validate checks the field values on DnsTable_DnsService with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *DnsTable_DnsService) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DnsTable_DnsService with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DnsTable_DnsServiceMultiError, or nil if none found.
func (m *DnsTable_DnsService) ValidateAll() error {
	return m.validate(true)
}

func (m *DnsTable_DnsService) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetServiceName()) < 1 {
		err := DnsTable_DnsServiceValidationError{
			field:  "ServiceName",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_DnsTable_DnsService_ServiceName_Pattern.MatchString(m.GetServiceName()) {
		err := DnsTable_DnsServiceValidationError{
			field:  "ServiceName",
			reason: "value does not match regex pattern \"^:?[0-9a-zA-Z!#$%&'*+-.^_|~`]+$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetProtocol()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, DnsTable_DnsServiceValidationError{
					field:  "Protocol",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, DnsTable_DnsServiceValidationError{
					field:  "Protocol",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetProtocol()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DnsTable_DnsServiceValidationError{
				field:  "Protocol",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if d := m.GetTtl(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = DnsTable_DnsServiceValidationError{
				field:  "Ttl",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gte := time.Duration(1*time.Second + 0*time.Nanosecond)

			if dur < gte {
				err := DnsTable_DnsServiceValidationError{
					field:  "Ttl",
					reason: "value must be greater than or equal to 1s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(m.GetTargets()) < 1 {
		err := DnsTable_DnsServiceValidationError{
			field:  "Targets",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetTargets() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, DnsTable_DnsServiceValidationError{
						field:  fmt.Sprintf("Targets[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, DnsTable_DnsServiceValidationError{
						field:  fmt.Sprintf("Targets[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return DnsTable_DnsServiceValidationError{
					field:  fmt.Sprintf("Targets[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return DnsTable_DnsServiceMultiError(errors)
	}

	return nil
}

// DnsTable_DnsServiceMultiError is an error wrapping multiple validation
// errors returned by DnsTable_DnsService.ValidateAll() if the designated
// constraints aren't met.
type DnsTable_DnsServiceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DnsTable_DnsServiceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DnsTable_DnsServiceMultiError) AllErrors() []error { return m }

// DnsTable_DnsServiceValidationError is the validation error returned by
// DnsTable_DnsService.Validate if the designated constraints aren't met.
type DnsTable_DnsServiceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DnsTable_DnsServiceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DnsTable_DnsServiceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DnsTable_DnsServiceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DnsTable_DnsServiceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DnsTable_DnsServiceValidationError) ErrorName() string {
	return "DnsTable_DnsServiceValidationError"
}

// Error satisfies the builtin error interface
func (e DnsTable_DnsServiceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDnsTable_DnsService.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DnsTable_DnsServiceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DnsTable_DnsServiceValidationError{}

var _DnsTable_DnsService_ServiceName_Pattern = regexp.MustCompile("^:?[0-9a-zA-Z!#$%&'*+-.^_|~`]+$")

// Validate checks the field values on DnsTable_DnsServiceList with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *DnsTable_DnsServiceList) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DnsTable_DnsServiceList with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DnsTable_DnsServiceListMultiError, or nil if none found.
func (m *DnsTable_DnsServiceList) ValidateAll() error {
	return m.validate(true)
}

func (m *DnsTable_DnsServiceList) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetServices()) < 1 {
		err := DnsTable_DnsServiceListValidationError{
			field:  "Services",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetServices() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, DnsTable_DnsServiceListValidationError{
						field:  fmt.Sprintf("Services[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, DnsTable_DnsServiceListValidationError{
						field:  fmt.Sprintf("Services[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return DnsTable_DnsServiceListValidationError{
					field:  fmt.Sprintf("Services[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return DnsTable_DnsServiceListMultiError(errors)
	}

	return nil
}

// DnsTable_DnsServiceListMultiError is an error wrapping multiple validation
// errors returned by DnsTable_DnsServiceList.ValidateAll() if the designated
// constraints aren't met.
type DnsTable_DnsServiceListMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DnsTable_DnsServiceListMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DnsTable_DnsServiceListMultiError) AllErrors() []error { return m }

// DnsTable_DnsServiceListValidationError is the validation error returned by
// DnsTable_DnsServiceList.Validate if the designated constraints aren't met.
type DnsTable_DnsServiceListValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DnsTable_DnsServiceListValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DnsTable_DnsServiceListValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DnsTable_DnsServiceListValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DnsTable_DnsServiceListValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DnsTable_DnsServiceListValidationError) ErrorName() string {
	return "DnsTable_DnsServiceListValidationError"
}

// Error satisfies the builtin error interface
func (e DnsTable_DnsServiceListValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDnsTable_DnsServiceList.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DnsTable_DnsServiceListValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DnsTable_DnsServiceListValidationError{}

// Validate checks the field values on DnsTable_DnsEndpoint with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *DnsTable_DnsEndpoint) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DnsTable_DnsEndpoint with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DnsTable_DnsEndpointMultiError, or nil if none found.
func (m *DnsTable_DnsEndpoint) ValidateAll() error {
	return m.validate(true)
}

func (m *DnsTable_DnsEndpoint) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	oneofEndpointConfigPresent := false
	switch v := m.EndpointConfig.(type) {
	case *DnsTable_DnsEndpoint_AddressList:
		if v == nil {
			err := DnsTable_DnsEndpointValidationError{
				field:  "EndpointConfig",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofEndpointConfigPresent = true

		if all {
			switch v := interface{}(m.GetAddressList()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, DnsTable_DnsEndpointValidationError{
						field:  "AddressList",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, DnsTable_DnsEndpointValidationError{
						field:  "AddressList",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetAddressList()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return DnsTable_DnsEndpointValidationError{
					field:  "AddressList",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *DnsTable_DnsEndpoint_ClusterName:
		if v == nil {
			err := DnsTable_DnsEndpointValidationError{
				field:  "EndpointConfig",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofEndpointConfigPresent = true
		// no validation rules for ClusterName
	case *DnsTable_DnsEndpoint_ServiceList:
		if v == nil {
			err := DnsTable_DnsEndpointValidationError{
				field:  "EndpointConfig",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofEndpointConfigPresent = true

		if all {
			switch v := interface{}(m.GetServiceList()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, DnsTable_DnsEndpointValidationError{
						field:  "ServiceList",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, DnsTable_DnsEndpointValidationError{
						field:  "ServiceList",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetServiceList()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return DnsTable_DnsEndpointValidationError{
					field:  "ServiceList",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofEndpointConfigPresent {
		err := DnsTable_DnsEndpointValidationError{
			field:  "EndpointConfig",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return DnsTable_DnsEndpointMultiError(errors)
	}

	return nil
}

// DnsTable_DnsEndpointMultiError is an error wrapping multiple validation
// errors returned by DnsTable_DnsEndpoint.ValidateAll() if the designated
// constraints aren't met.
type DnsTable_DnsEndpointMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DnsTable_DnsEndpointMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DnsTable_DnsEndpointMultiError) AllErrors() []error { return m }

// DnsTable_DnsEndpointValidationError is the validation error returned by
// DnsTable_DnsEndpoint.Validate if the designated constraints aren't met.
type DnsTable_DnsEndpointValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DnsTable_DnsEndpointValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DnsTable_DnsEndpointValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DnsTable_DnsEndpointValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DnsTable_DnsEndpointValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DnsTable_DnsEndpointValidationError) ErrorName() string {
	return "DnsTable_DnsEndpointValidationError"
}

// Error satisfies the builtin error interface
func (e DnsTable_DnsEndpointValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDnsTable_DnsEndpoint.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DnsTable_DnsEndpointValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DnsTable_DnsEndpointValidationError{}

// Validate checks the field values on DnsTable_DnsVirtualDomain with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *DnsTable_DnsVirtualDomain) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DnsTable_DnsVirtualDomain with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DnsTable_DnsVirtualDomainMultiError, or nil if none found.
func (m *DnsTable_DnsVirtualDomain) ValidateAll() error {
	return m.validate(true)
}

func (m *DnsTable_DnsVirtualDomain) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetName()) < 1 {
		err := DnsTable_DnsVirtualDomainValidationError{
			field:  "Name",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_DnsTable_DnsVirtualDomain_Name_Pattern.MatchString(m.GetName()) {
		err := DnsTable_DnsVirtualDomainValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^:?[0-9a-zA-Z!#$%&'*+-.^_|~`]+$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetEndpoint()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, DnsTable_DnsVirtualDomainValidationError{
					field:  "Endpoint",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, DnsTable_DnsVirtualDomainValidationError{
					field:  "Endpoint",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetEndpoint()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return DnsTable_DnsVirtualDomainValidationError{
				field:  "Endpoint",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if d := m.GetAnswerTtl(); d != nil {
		dur, err := d.AsDuration(), d.CheckValid()
		if err != nil {
			err = DnsTable_DnsVirtualDomainValidationError{
				field:  "AnswerTtl",
				reason: "value is not a valid duration",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			gte := time.Duration(30*time.Second + 0*time.Nanosecond)

			if dur < gte {
				err := DnsTable_DnsVirtualDomainValidationError{
					field:  "AnswerTtl",
					reason: "value must be greater than or equal to 30s",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return DnsTable_DnsVirtualDomainMultiError(errors)
	}

	return nil
}

// DnsTable_DnsVirtualDomainMultiError is an error wrapping multiple validation
// errors returned by DnsTable_DnsVirtualDomain.ValidateAll() if the
// designated constraints aren't met.
type DnsTable_DnsVirtualDomainMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DnsTable_DnsVirtualDomainMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DnsTable_DnsVirtualDomainMultiError) AllErrors() []error { return m }

// DnsTable_DnsVirtualDomainValidationError is the validation error returned by
// DnsTable_DnsVirtualDomain.Validate if the designated constraints aren't met.
type DnsTable_DnsVirtualDomainValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DnsTable_DnsVirtualDomainValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DnsTable_DnsVirtualDomainValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DnsTable_DnsVirtualDomainValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DnsTable_DnsVirtualDomainValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DnsTable_DnsVirtualDomainValidationError) ErrorName() string {
	return "DnsTable_DnsVirtualDomainValidationError"
}

// Error satisfies the builtin error interface
func (e DnsTable_DnsVirtualDomainValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDnsTable_DnsVirtualDomain.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DnsTable_DnsVirtualDomainValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DnsTable_DnsVirtualDomainValidationError{}

var _DnsTable_DnsVirtualDomain_Name_Pattern = regexp.MustCompile("^:?[0-9a-zA-Z!#$%&'*+-.^_|~`]+$")
