package libinjection

const (
	attributeTypeNone = iota
	attributeTypeBlack
	attributeTypeAttrURL
	attributeTypeStyle
	attributeTypeAttrIndirect
)

type stringType struct {
	name          string
	attributeType int
}

// You can get these using:
//
//	curl https://raw.githubusercontent.com/WebKit/WebKit/main/Source/WebCore/dom/EventNames.json | \
//	  jq -r 'keys[] as $k | $k | ascii_upcase |  "{\"" + . +"\", attributeTypeBlack },"' | sort
var blackEvents = []stringType{
	{"ABORT", attributeTypeBlack},
	{"ACTIVATE", attributeTypeBlack},
	{"ACTIVE", attributeTypeBlack},
	{"ADDSOURCEBUFFER", attributeTypeBlack},
	{"ADDSTREAM", attributeTypeBlack},
	{"ADDTRACK", attributeTypeBlack},
	{"AFTERPRINT", attributeTypeBlack},
	{"ANIMATIONCANCEL", attributeTypeBlack},
	{"ANIMATIONEND", attributeTypeBlack},
	{"ANIMATIONITERATION", attributeTypeBlack},
	{"ANIMATIONSTART", attributeTypeBlack},
	{"AUDIOEND", attributeTypeBlack},
	{"AUDIOPROCESS", attributeTypeBlack},
	{"AUDIOSTART", attributeTypeBlack},
	{"AUTOCOMPLETE", attributeTypeBlack},
	{"AUTOCOMPLETEERROR", attributeTypeBlack},
	{"BACKGROUNDFETCHABORT", attributeTypeBlack},
	{"BACKGROUNDFETCHCLICK", attributeTypeBlack},
	{"BACKGROUNDFETCHFAIL", attributeTypeBlack},
	{"BACKGROUNDFETCHSUCCESS", attributeTypeBlack},
	{"BEFORECOPY", attributeTypeBlack},
	{"BEFORECUT", attributeTypeBlack},
	{"BEFOREINPUT", attributeTypeBlack},
	{"BEFORELOAD", attributeTypeBlack},
	{"BEFOREPASTE", attributeTypeBlack},
	{"BEFOREPRINT", attributeTypeBlack},
	{"BEFORETOGGLE", attributeTypeBlack},
	{"BEFOREUNLOAD", attributeTypeBlack},
	{"BEGINEVENT", attributeTypeBlack},
	{"BLOCKED", attributeTypeBlack},
	{"BLUR", attributeTypeBlack},
	{"BOUNDARY", attributeTypeBlack},
	{"BUFFEREDAMOUNTLOW", attributeTypeBlack},
	{"BUFFEREDCHANGE", attributeTypeBlack},
	{"CACHED", attributeTypeBlack},
	{"CANCEL", attributeTypeBlack},
	{"CANPLAY", attributeTypeBlack},
	{"CANPLAYTHROUGH", attributeTypeBlack},
	{"CHANGE", attributeTypeBlack},
	{"CHARGINGCHANGE", attributeTypeBlack},
	{"CHARGINGTIMECHANGE", attributeTypeBlack},
	{"CHECKING", attributeTypeBlack},
	{"CLICK", attributeTypeBlack},
	{"CLOSE", attributeTypeBlack},
	{"CLOSING", attributeTypeBlack},
	{"COMPLETE", attributeTypeBlack},
	{"COMPOSITIONEND", attributeTypeBlack},
	{"COMPOSITIONSTART", attributeTypeBlack},
	{"COMPOSITIONUPDATE", attributeTypeBlack},
	{"CONFIGURATIONCHANGE", attributeTypeBlack},
	{"CONNECT", attributeTypeBlack},
	{"CONNECTING", attributeTypeBlack},
	{"CONNECTIONSTATECHANGE", attributeTypeBlack},
	{"CONTENTVISIBILITYAUTOSTATECHANGE", attributeTypeBlack},
	{"CONTEXTMENU", attributeTypeBlack},
	{"CONTROLLERCHANGE", attributeTypeBlack},
	{"COOKIECHANGE", attributeTypeBlack},
	{"COORDINATORSTATECHANGE", attributeTypeBlack},
	{"COPY", attributeTypeBlack},
	{"COUPONCODECHANGED", attributeTypeBlack},
	{"CUECHANGE", attributeTypeBlack},
	{"CURRENTENTRYCHANGE", attributeTypeBlack},
	{"CUT", attributeTypeBlack},
	{"DATAAVAILABLE", attributeTypeBlack},
	{"DATACHANNEL", attributeTypeBlack},
	{"DBLCLICK", attributeTypeBlack},
	{"DEQUEUE", attributeTypeBlack},
	{"DEVICECHANGE", attributeTypeBlack},
	{"DEVICEMOTION", attributeTypeBlack},
	{"DEVICEORIENTATION", attributeTypeBlack},
	{"DISCHARGINGTIMECHANGE", attributeTypeBlack},
	{"DISCONNECT", attributeTypeBlack},
	{"DISPOSE", attributeTypeBlack},
	{"DOMACTIVATE", attributeTypeBlack},
	{"DOMCHARACTERDATAMODIFIED", attributeTypeBlack},
	{"DOMCONTENTLOADED", attributeTypeBlack},
	{"DOMNODEINSERTED", attributeTypeBlack},
	{"DOMNODEINSERTEDINTODOCUMENT", attributeTypeBlack},
	{"DOMNODEREMOVED", attributeTypeBlack},
	{"DOMNODEREMOVEDFROMDOCUMENT", attributeTypeBlack},
	{"DOMSUBTREEMODIFIED", attributeTypeBlack},
	{"DOWNLOADING", attributeTypeBlack},
	{"DRAG", attributeTypeBlack},
	{"DRAGEND", attributeTypeBlack},
	{"DRAGENTER", attributeTypeBlack},
	{"DRAGLEAVE", attributeTypeBlack},
	{"DRAGOVER", attributeTypeBlack},
	{"DRAGSTART", attributeTypeBlack},
	{"DROP", attributeTypeBlack},
	{"DURATIONCHANGE", attributeTypeBlack},
	{"EMPTIED", attributeTypeBlack},
	{"ENCRYPTED", attributeTypeBlack},
	{"END", attributeTypeBlack},
	{"ENDED", attributeTypeBlack},
	{"ENDEVENT", attributeTypeBlack},
	{"ENDSTREAMING", attributeTypeBlack},
	{"ENTER", attributeTypeBlack},
	{"ENTERPICTUREINPICTURE", attributeTypeBlack},
	{"ERROR", attributeTypeBlack},
	{"EXIT", attributeTypeBlack},
	{"FETCH", attributeTypeBlack},
	{"FINISH", attributeTypeBlack},
	{"FOCUS", attributeTypeBlack},
	{"FOCUSIN", attributeTypeBlack},
	{"FOCUSOUT", attributeTypeBlack},
	{"FORMDATA", attributeTypeBlack},
	{"FULLSCREENCHANGE", attributeTypeBlack},
	{"FULLSCREENERROR", attributeTypeBlack},
	{"GAMEPADCONNECTED", attributeTypeBlack},
	{"GAMEPADDISCONNECTED", attributeTypeBlack},
	{"GATHERINGSTATECHANGE", attributeTypeBlack},
	{"GESTURECHANGE", attributeTypeBlack},
	{"GESTUREEND", attributeTypeBlack},
	{"GESTURESCROLLEND", attributeTypeBlack},
	{"GESTURESCROLLSTART", attributeTypeBlack},
	{"GESTURESCROLLUPDATE", attributeTypeBlack},
	{"GESTURESTART", attributeTypeBlack},
	{"GESTURETAP", attributeTypeBlack},
	{"GESTURETAPDOWN", attributeTypeBlack},
	{"GOTPOINTERCAPTURE", attributeTypeBlack},
	{"HASHCHANGE", attributeTypeBlack},
	{"ICECANDIDATE", attributeTypeBlack},
	{"ICECANDIDATEERROR", attributeTypeBlack},
	{"ICECONNECTIONSTATECHANGE", attributeTypeBlack},
	{"ICEGATHERINGSTATECHANGE", attributeTypeBlack},
	{"INACTIVE", attributeTypeBlack},
	{"INPUT", attributeTypeBlack},
	{"INPUTSOURCESCHANGE", attributeTypeBlack},
	{"INSTALL", attributeTypeBlack},
	{"INVALID", attributeTypeBlack},
	{"INVOKE", attributeTypeBlack},
	{"KEYDOWN", attributeTypeBlack},
	{"KEYPRESS", attributeTypeBlack},
	{"KEYSTATUSESCHANGE", attributeTypeBlack},
	{"KEYUP", attributeTypeBlack},
	{"LANGUAGECHANGE", attributeTypeBlack},
	{"LEAVEPICTUREINPICTURE", attributeTypeBlack},
	{"LEVELCHANGE", attributeTypeBlack},
	{"LOAD", attributeTypeBlack},
	{"LOADEDDATA", attributeTypeBlack},
	{"LOADEDMETADATA", attributeTypeBlack},
	{"LOADEND", attributeTypeBlack},
	{"LOADING", attributeTypeBlack},
	{"LOADINGDONE", attributeTypeBlack},
	{"LOADINGERROR", attributeTypeBlack},
	{"LOADSTART", attributeTypeBlack},
	{"LOSTPOINTERCAPTURE", attributeTypeBlack},
	{"MARK", attributeTypeBlack},
	{"MERCHANTVALIDATION", attributeTypeBlack},
	{"MESSAGE", attributeTypeBlack},
	{"MESSAGEERROR", attributeTypeBlack},
	{"MOUSEDOWN", attributeTypeBlack},
	{"MOUSEENTER", attributeTypeBlack},
	{"MOUSELEAVE", attributeTypeBlack},
	{"MOUSEMOVE", attributeTypeBlack},
	{"MOUSEOUT", attributeTypeBlack},
	{"MOUSEOVER", attributeTypeBlack},
	{"MOUSEUP", attributeTypeBlack},
	{"MOUSEWHEEL", attributeTypeBlack},
	{"MUTE", attributeTypeBlack},
	{"NAVIGATE", attributeTypeBlack},
	{"NAVIGATEERROR", attributeTypeBlack},
	{"NAVIGATESUCCESS", attributeTypeBlack},
	{"NEGOTIATIONNEEDED", attributeTypeBlack},
	{"NEXTTRACK", attributeTypeBlack},
	{"NOMATCH", attributeTypeBlack},
	{"NOTIFICATIONCLICK", attributeTypeBlack},
	{"NOTIFICATIONCLOSE", attributeTypeBlack},
	{"NOUPDATE", attributeTypeBlack},
	{"OBSOLETE", attributeTypeBlack},
	{"OFFLINE", attributeTypeBlack},
	{"ONLINE", attributeTypeBlack},
	{"OPEN", attributeTypeBlack},
	{"ORIENTATIONCHANGE", attributeTypeBlack},
	{"OVERFLOWCHANGED", attributeTypeBlack},
	{"PAGEHIDE", attributeTypeBlack},
	{"PAGESHOW", attributeTypeBlack},
	{"PASTE", attributeTypeBlack},
	{"PAUSE", attributeTypeBlack},
	{"PAYERDETAILCHANGE", attributeTypeBlack},
	{"PAYMENTAUTHORIZED", attributeTypeBlack},
	{"PAYMENTMETHODCHANGE", attributeTypeBlack},
	{"PAYMENTMETHODSELECTED", attributeTypeBlack},
	{"PLAY", attributeTypeBlack},
	{"PLAYING", attributeTypeBlack},
	{"POINTERCANCEL", attributeTypeBlack},
	{"POINTERDOWN", attributeTypeBlack},
	{"POINTERENTER", attributeTypeBlack},
	{"POINTERLEAVE", attributeTypeBlack},
	{"POINTERLOCKCHANGE", attributeTypeBlack},
	{"POINTERLOCKERROR", attributeTypeBlack},
	{"POINTERMOVE", attributeTypeBlack},
	{"POINTEROUT", attributeTypeBlack},
	{"POINTEROVER", attributeTypeBlack},
	{"POINTERUP", attributeTypeBlack},
	{"POPSTATE", attributeTypeBlack},
	{"PREVIOUSTRACK", attributeTypeBlack},
	{"PROCESSORERROR", attributeTypeBlack},
	{"PROGRESS", attributeTypeBlack},
	{"PUSH", attributeTypeBlack},
	{"PUSHNOTIFICATION", attributeTypeBlack},
	{"PUSHSUBSCRIPTIONCHANGE", attributeTypeBlack},
	{"QUALITYCHANGE", attributeTypeBlack},
	{"RATECHANGE", attributeTypeBlack},
	{"READYSTATECHANGE", attributeTypeBlack},
	{"REJECTIONHANDLED", attributeTypeBlack},
	{"RELEASE", attributeTypeBlack},
	{"REMOVE", attributeTypeBlack},
	{"REMOVESOURCEBUFFER", attributeTypeBlack},
	{"REMOVESTREAM", attributeTypeBlack},
	{"REMOVETRACK", attributeTypeBlack},
	{"RESET", attributeTypeBlack},
	{"RESIZE", attributeTypeBlack},
	{"RESOURCETIMINGBUFFERFULL", attributeTypeBlack},
	{"RESULT", attributeTypeBlack},
	{"RESUME", attributeTypeBlack},
	{"RTCTRANSFORM", attributeTypeBlack},
	{"SCROLL", attributeTypeBlack},
	{"SEARCH", attributeTypeBlack},
	{"SECURITYPOLICYVIOLATION", attributeTypeBlack},
	{"SEEKED", attributeTypeBlack},
	{"SEEKING", attributeTypeBlack},
	{"SELECT", attributeTypeBlack},
	{"SELECTEDCANDIDATEPAIRCHANGE", attributeTypeBlack},
	{"SELECTEND", attributeTypeBlack},
	{"SELECTIONCHANGE", attributeTypeBlack},
	{"SELECTSTART", attributeTypeBlack},
	{"SHIPPINGADDRESSCHANGE", attributeTypeBlack},
	{"SHIPPINGCONTACTSELECTED", attributeTypeBlack},
	{"SHIPPINGMETHODSELECTED", attributeTypeBlack},
	{"SHIPPINGOPTIONCHANGE", attributeTypeBlack},
	{"SHOW", attributeTypeBlack},
	{"SIGNALINGSTATECHANGE", attributeTypeBlack},
	{"SLOTCHANGE", attributeTypeBlack},
	{"SOUNDEND", attributeTypeBlack},
	{"SOUNDSTART", attributeTypeBlack},
	{"SOURCECLOSE", attributeTypeBlack},
	{"SOURCEENDED", attributeTypeBlack},
	{"SOURCEOPEN", attributeTypeBlack},
	{"SPEECHEND", attributeTypeBlack},
	{"SPEECHSTART", attributeTypeBlack},
	{"SQUEEZE", attributeTypeBlack},
	{"SQUEEZEEND", attributeTypeBlack},
	{"SQUEEZESTART", attributeTypeBlack},
	{"STALLED", attributeTypeBlack},
	{"START", attributeTypeBlack},
	{"STARTED", attributeTypeBlack},
	{"STARTSTREAMING", attributeTypeBlack},
	{"STATECHANGE", attributeTypeBlack},
	{"STOP", attributeTypeBlack},
	{"STORAGE", attributeTypeBlack},
	{"SUBMIT", attributeTypeBlack},
	{"SUCCESS", attributeTypeBlack},
	{"SUSPEND", attributeTypeBlack},
	{"TEXTINPUT", attributeTypeBlack},
	{"TIMEOUT", attributeTypeBlack},
	{"TIMEUPDATE", attributeTypeBlack},
	{"TOGGLE", attributeTypeBlack},
	{"TONECHANGE", attributeTypeBlack},
	{"TOUCHCANCEL", attributeTypeBlack},
	{"TOUCHEND", attributeTypeBlack},
	{"TOUCHFORCECHANGE", attributeTypeBlack},
	{"TOUCHMOVE", attributeTypeBlack},
	{"TOUCHSTART", attributeTypeBlack},
	{"TRACK", attributeTypeBlack},
	{"TRANSITIONCANCEL", attributeTypeBlack},
	{"TRANSITIONEND", attributeTypeBlack},
	{"TRANSITIONRUN", attributeTypeBlack},
	{"TRANSITIONSTART", attributeTypeBlack},
	{"UNCAPTUREDERROR", attributeTypeBlack},
	{"UNHANDLEDREJECTION", attributeTypeBlack},
	{"UNLOAD", attributeTypeBlack},
	{"UNMUTE", attributeTypeBlack},
	{"UPDATE", attributeTypeBlack},
	{"UPDATEEND", attributeTypeBlack},
	{"UPDATEFOUND", attributeTypeBlack},
	{"UPDATEREADY", attributeTypeBlack},
	{"UPDATESTART", attributeTypeBlack},
	{"UPGRADENEEDED", attributeTypeBlack},
	{"VALIDATEMERCHANT", attributeTypeBlack},
	{"VERSIONCHANGE", attributeTypeBlack},
	{"VISIBILITYCHANGE", attributeTypeBlack},
	{"VOICESCHANGED", attributeTypeBlack},
	{"VOLUMECHANGE", attributeTypeBlack},
	{"WAITING", attributeTypeBlack},
	{"WAITINGFORKEY", attributeTypeBlack},
	{"WEBGLCONTEXTCREATIONERROR", attributeTypeBlack},
	{"WEBGLCONTEXTLOST", attributeTypeBlack},
	{"WEBGLCONTEXTRESTORED", attributeTypeBlack},
	{"WEBKITANIMATIONEND", attributeTypeBlack},
	{"WEBKITANIMATIONITERATION", attributeTypeBlack},
	{"WEBKITANIMATIONSTART", attributeTypeBlack},
	{"WEBKITBEFORETEXTINSERTED", attributeTypeBlack},
	{"WEBKITBEGINFULLSCREEN", attributeTypeBlack},
	{"WEBKITCURRENTPLAYBACKTARGETISWIRELESSCHANGED", attributeTypeBlack},
	{"WEBKITENDFULLSCREEN", attributeTypeBlack},
	{"WEBKITFULLSCREENCHANGE", attributeTypeBlack},
	{"WEBKITFULLSCREENERROR", attributeTypeBlack},
	{"WEBKITKEYADDED", attributeTypeBlack},
	{"WEBKITKEYERROR", attributeTypeBlack},
	{"WEBKITKEYMESSAGE", attributeTypeBlack},
	{"WEBKITMOUSEFORCECHANGED", attributeTypeBlack},
	{"WEBKITMOUSEFORCEDOWN", attributeTypeBlack},
	{"WEBKITMOUSEFORCEUP", attributeTypeBlack},
	{"WEBKITMOUSEFORCEWILLBEGIN", attributeTypeBlack},
	{"WEBKITNEEDKEY", attributeTypeBlack},
	{"WEBKITNETWORKINFOCHANGE", attributeTypeBlack},
	{"WEBKITPLAYBACKTARGETAVAILABILITYCHANGED", attributeTypeBlack},
	{"WEBKITPRESENTATIONMODECHANGED", attributeTypeBlack},
	{"WEBKITREMOVESOURCEBUFFER", attributeTypeBlack},
	{"WEBKITSOURCECLOSE", attributeTypeBlack},
	{"WEBKITSOURCEENDED", attributeTypeBlack},
	{"WEBKITSOURCEOPEN", attributeTypeBlack},
	{"WEBKITTRANSITIONEND", attributeTypeBlack},
	{"WHEEL", attributeTypeBlack},
	{"WRITE", attributeTypeBlack},
	{"WRITEEND", attributeTypeBlack},
	{"WRITESTART", attributeTypeBlack},
	{"ZOOM", attributeTypeBlack},
}

var blackTags = []string{
	"APPLET",
	"BASE",
	"COMMENT", // IE http://html5sec.org/#38
	"EMBED",
	"FRAME",
	"FRAMESET",
	"HANDLER", // Opera SVG, effectively a script tag
	"IFRAME",
	"IMPORT",
	"ISINDEX",
	"LINK",
	"LISTENER",
	"META",
	"NOSCRIPT",
	"OBJECT",
	"SCRIPT",
	"STYLE",
	"VMLFRAME",
	"XML",
	"XSS",
}

// view-source:
// data:
// javascript:
var blacks = []stringType{
	{"ACTION", attributeTypeAttrURL},             // form
	{"ATTRIBUTENAME", attributeTypeAttrIndirect}, // SVG allow indirection of attribute names
	{"BY", attributeTypeAttrURL},                 // SVG
	{"BACKGROUND", attributeTypeAttrURL},         // IE6, O11
	{"DATAFORMATAS", attributeTypeBlack},         // IE
	{"DATASRC", attributeTypeBlack},              // IE
	{"DYNSRC", attributeTypeAttrURL},             // Obsolete img attribute
	{"FILTER", attributeTypeStyle},               // Opera, SVG inline style
	{"FORMACTION", attributeTypeAttrURL},         // HTML 5
	{"FOLDER", attributeTypeAttrURL},             // Only on A tags, IE-only
	{"FROM", attributeTypeAttrURL},               // SVG
	{"HANDLER", attributeTypeAttrURL},            // SVG Tiny, Opera
	{"HREF", attributeTypeAttrURL},
	{"LOWSRC", attributeTypeAttrURL}, // Obsolete img attribute
	{"POSTER", attributeTypeAttrURL}, // Opera 10,11
	{"SRC", attributeTypeAttrURL},
	{"STYLE", attributeTypeStyle},
	{"TO", attributeTypeAttrURL},     // SVG
	{"VALUES", attributeTypeAttrURL}, // SVG
	{"XLINK:HREF", attributeTypeAttrURL},
}

var gsHexDecodeMap = []int{
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 256, 256,
	256, 256, 256, 256, 256, 10, 11, 12, 13, 14, 15, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 10, 11, 12, 13, 14, 15, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256, 256,
	256, 256, 256, 256,
}
