// Code generated by 'ccgo -o vfs_darwin_arm64.go c/vfs.c -I../testdata/sqlite-amalgamation-3380500 -lmodernc.org/sqlite/lib -pkgname vfs -nocapi -export-externs X -D SQLITE_OS_UNIX -hide=vfsFullPathname -hide=vfsOpen -hide=vfsRead -hide=vfsAccess -hide=vfsFileSize -hide=vfsClose', DO NOT EDIT.

package vfs

import (
	"math"
	"reflect"
	"sync/atomic"
	"unsafe"

	"modernc.org/libc"
	"modernc.org/libc/sys/types"
	"modernc.org/sqlite/lib"
)

var _ = math.Pi
var _ reflect.Kind
var _ atomic.Value
var _ unsafe.Pointer
var _ *libc.TLS
var _ types.Size_t

const (
	FILESEC_OWNER   = 1
	FILESEC_GROUP   = 2
	FILESEC_UUID    = 3
	FILESEC_MODE    = 4
	FILESEC_ACL     = 5
	FILESEC_GRPUUID = 6

	FILESEC_ACL_RAW       = 100
	FILESEC_ACL_ALLOCSIZE = 101
)

const (
	_CLOCK_REALTIME             = 0
	_CLOCK_MONOTONIC            = 6
	_CLOCK_MONOTONIC_RAW        = 4
	_CLOCK_MONOTONIC_RAW_APPROX = 5
	_CLOCK_UPTIME_RAW           = 8
	_CLOCK_UPTIME_RAW_APPROX    = 9
	_CLOCK_PROCESS_CPUTIME_ID   = 12
	_CLOCK_THREAD_CPUTIME_ID    = 16
)

type ptrdiff_t = int64

type size_t = uint64

type wchar_t = int32

var X__darwin_check_fd_set_overflow uintptr

type va_list = uintptr

type sqlite_int64 = int64
type sqlite_uint64 = uint64
type sqlite3_int64 = sqlite_int64
type sqlite3_uint64 = sqlite_uint64

type sqlite3_callback = uintptr

type sqlite3_file1 = struct{ pMethods uintptr }

type sqlite3_file = sqlite3_file1
type sqlite3_io_methods1 = struct {
	iVersion               int32
	_                      [4]byte
	xClose                 uintptr
	xRead                  uintptr
	xWrite                 uintptr
	xTruncate              uintptr
	xSync                  uintptr
	xFileSize              uintptr
	xLock                  uintptr
	xUnlock                uintptr
	xCheckReservedLock     uintptr
	xFileControl           uintptr
	xSectorSize            uintptr
	xDeviceCharacteristics uintptr
	xShmMap                uintptr
	xShmLock               uintptr
	xShmBarrier            uintptr
	xShmUnmap              uintptr
	xFetch                 uintptr
	xUnfetch               uintptr
}

type sqlite3_io_methods = sqlite3_io_methods1

type sqlite3_vfs1 = struct {
	iVersion          int32
	szOsFile          int32
	mxPathname        int32
	_                 [4]byte
	pNext             uintptr
	zName             uintptr
	pAppData          uintptr
	xOpen             uintptr
	xDelete           uintptr
	xAccess           uintptr
	xFullPathname     uintptr
	xDlOpen           uintptr
	xDlError          uintptr
	xDlSym            uintptr
	xDlClose          uintptr
	xRandomness       uintptr
	xSleep            uintptr
	xCurrentTime      uintptr
	xGetLastError     uintptr
	xCurrentTimeInt64 uintptr
	xSetSystemCall    uintptr
	xGetSystemCall    uintptr
	xNextSystemCall   uintptr
}

type sqlite3_vfs = sqlite3_vfs1
type sqlite3_syscall_ptr = uintptr

type sqlite3_mem_methods1 = struct {
	xMalloc   uintptr
	xFree     uintptr
	xRealloc  uintptr
	xSize     uintptr
	xRoundup  uintptr
	xInit     uintptr
	xShutdown uintptr
	pAppData  uintptr
}

type sqlite3_mem_methods = sqlite3_mem_methods1

type sqlite3_destructor_type = uintptr

type sqlite3_vtab1 = struct {
	pModule uintptr
	nRef    int32
	_       [4]byte
	zErrMsg uintptr
}

type sqlite3_vtab = sqlite3_vtab1
type sqlite3_index_info1 = struct {
	nConstraint      int32
	_                [4]byte
	aConstraint      uintptr
	nOrderBy         int32
	_                [4]byte
	aOrderBy         uintptr
	aConstraintUsage uintptr
	idxNum           int32
	_                [4]byte
	idxStr           uintptr
	needToFreeIdxStr int32
	orderByConsumed  int32
	estimatedCost    float64
	estimatedRows    sqlite3_int64
	idxFlags         int32
	_                [4]byte
	colUsed          sqlite3_uint64
}

type sqlite3_index_info = sqlite3_index_info1
type sqlite3_vtab_cursor1 = struct{ pVtab uintptr }

type sqlite3_vtab_cursor = sqlite3_vtab_cursor1
type sqlite3_module1 = struct {
	iVersion      int32
	_             [4]byte
	xCreate       uintptr
	xConnect      uintptr
	xBestIndex    uintptr
	xDisconnect   uintptr
	xDestroy      uintptr
	xOpen         uintptr
	xClose        uintptr
	xFilter       uintptr
	xNext         uintptr
	xEof          uintptr
	xColumn       uintptr
	xRowid        uintptr
	xUpdate       uintptr
	xBegin        uintptr
	xSync         uintptr
	xCommit       uintptr
	xRollback     uintptr
	xFindFunction uintptr
	xRename       uintptr
	xSavepoint    uintptr
	xRelease      uintptr
	xRollbackTo   uintptr
	xShadowName   uintptr
}

type sqlite3_module = sqlite3_module1

type sqlite3_index_constraint = struct {
	iColumn     int32
	op          uint8
	usable      uint8
	_           [2]byte
	iTermOffset int32
}

type sqlite3_index_orderby = struct {
	iColumn int32
	desc    uint8
	_       [3]byte
}

type sqlite3_index_constraint_usage = struct {
	argvIndex int32
	omit      uint8
	_         [3]byte
}

type sqlite3_mutex_methods1 = struct {
	xMutexInit    uintptr
	xMutexEnd     uintptr
	xMutexAlloc   uintptr
	xMutexFree    uintptr
	xMutexEnter   uintptr
	xMutexTry     uintptr
	xMutexLeave   uintptr
	xMutexHeld    uintptr
	xMutexNotheld uintptr
}

type sqlite3_mutex_methods = sqlite3_mutex_methods1

type sqlite3_pcache_page1 = struct {
	pBuf   uintptr
	pExtra uintptr
}

type sqlite3_pcache_page = sqlite3_pcache_page1

type sqlite3_pcache_methods21 = struct {
	iVersion   int32
	_          [4]byte
	pArg       uintptr
	xInit      uintptr
	xShutdown  uintptr
	xCreate    uintptr
	xCachesize uintptr
	xPagecount uintptr
	xFetch     uintptr
	xUnpin     uintptr
	xRekey     uintptr
	xTruncate  uintptr
	xDestroy   uintptr
	xShrink    uintptr
}

type sqlite3_pcache_methods2 = sqlite3_pcache_methods21

type sqlite3_pcache_methods1 = struct {
	pArg       uintptr
	xInit      uintptr
	xShutdown  uintptr
	xCreate    uintptr
	xCachesize uintptr
	xPagecount uintptr
	xFetch     uintptr
	xUnpin     uintptr
	xRekey     uintptr
	xTruncate  uintptr
	xDestroy   uintptr
}

type sqlite3_pcache_methods = sqlite3_pcache_methods1

type sqlite3_snapshot1 = struct{ hidden [48]uint8 }

type sqlite3_snapshot = sqlite3_snapshot1

type sqlite3_rtree_geometry1 = struct {
	pContext uintptr
	nParam   int32
	_        [4]byte
	aParam   uintptr
	pUser    uintptr
	xDelUser uintptr
}

type sqlite3_rtree_geometry = sqlite3_rtree_geometry1
type sqlite3_rtree_query_info1 = struct {
	pContext      uintptr
	nParam        int32
	_             [4]byte
	aParam        uintptr
	pUser         uintptr
	xDelUser      uintptr
	aCoord        uintptr
	anQueue       uintptr
	nCoord        int32
	iLevel        int32
	mxLevel       int32
	_             [4]byte
	iRowid        sqlite3_int64
	rParentScore  sqlite3_rtree_dbl
	eParentWithin int32
	eWithin       int32
	rScore        sqlite3_rtree_dbl
	apSqlParam    uintptr
}

type sqlite3_rtree_query_info = sqlite3_rtree_query_info1

type sqlite3_rtree_dbl = float64

type Fts5ExtensionApi1 = struct {
	iVersion           int32
	_                  [4]byte
	xUserData          uintptr
	xColumnCount       uintptr
	xRowCount          uintptr
	xColumnTotalSize   uintptr
	xTokenize          uintptr
	xPhraseCount       uintptr
	xPhraseSize        uintptr
	xInstCount         uintptr
	xInst              uintptr
	xRowid             uintptr
	xColumnText        uintptr
	xColumnSize        uintptr
	xQueryPhrase       uintptr
	xSetAuxdata        uintptr
	xGetAuxdata        uintptr
	xPhraseFirst       uintptr
	xPhraseNext        uintptr
	xPhraseFirstColumn uintptr
	xPhraseNextColumn  uintptr
}

type Fts5ExtensionApi = Fts5ExtensionApi1
type Fts5PhraseIter1 = struct {
	a uintptr
	b uintptr
}

type Fts5PhraseIter = Fts5PhraseIter1

type fts5_extension_function = uintptr
type fts5_tokenizer1 = struct {
	xCreate   uintptr
	xDelete   uintptr
	xTokenize uintptr
}

type fts5_tokenizer = fts5_tokenizer1

type fts5_api1 = struct {
	iVersion         int32
	_                [4]byte
	xCreateTokenizer uintptr
	xFindTokenizer   uintptr
	xCreateFunction  uintptr
}

type fts5_api = fts5_api1

type __darwin_pthread_handler_rec = struct {
	__routine uintptr
	__arg     uintptr
	__next    uintptr
}

type _opaque_pthread_attr_t = struct {
	__sig    int64
	__opaque [56]int8
}

type _opaque_pthread_cond_t = struct {
	__sig    int64
	__opaque [40]int8
}

type _opaque_pthread_condattr_t = struct {
	__sig    int64
	__opaque [8]int8
}

type _opaque_pthread_mutex_t = struct {
	__sig    int64
	__opaque [56]int8
}

type _opaque_pthread_mutexattr_t = struct {
	__sig    int64
	__opaque [8]int8
}

type _opaque_pthread_once_t = struct {
	__sig    int64
	__opaque [8]int8
}

type _opaque_pthread_rwlock_t = struct {
	__sig    int64
	__opaque [192]int8
}

type _opaque_pthread_rwlockattr_t = struct {
	__sig    int64
	__opaque [16]int8
}

type _opaque_pthread_t = struct {
	__sig           int64
	__cleanup_stack uintptr
	__opaque        [8176]int8
}

type int8_t = int8

type int16_t = int16

type int32_t = int32

type int64_t = int64

type u_int8_t = uint8

type u_int16_t = uint16

type u_int32_t = uint32

type u_int64_t = uint64

type register_t = int64_t

type intptr_t = int64

type uintptr_t = uint64

type user_addr_t = u_int64_t
type user_size_t = u_int64_t
type user_ssize_t = int64_t
type user_long_t = int64_t
type user_ulong_t = u_int64_t
type user_time_t = int64_t
type user_off_t = int64_t

type syscall_arg_t = u_int64_t

type rsize_t = uint64

type errno_t = int32

type ssize_t = int64
type uint64_t = uint64

type int_least64_t = int64_t
type uint_least64_t = uint64_t
type int_fast64_t = int64_t
type uint_fast64_t = uint64_t

type uint32_t = uint32

type int_least32_t = int32_t
type uint_least32_t = uint32_t
type int_fast32_t = int32_t
type uint_fast32_t = uint32_t
type uint16_t = uint16

type int_least16_t = int16_t
type uint_least16_t = uint16_t
type int_fast16_t = int16_t
type uint_fast16_t = uint16_t
type uint8_t = uint8

type int_least8_t = int8_t
type uint_least8_t = uint8_t
type int_fast8_t = int8_t
type uint_fast8_t = uint8_t

type intmax_t = int64
type uintmax_t = uint64

func _OSSwapInt16(tls *libc.TLS, _data uint16_t) uint16_t {
	return uint16_t(int32(_data)<<8 | int32(_data)>>8)
}

func _OSSwapInt32(tls *libc.TLS, _data uint32_t) uint32_t {
	_data = libc.X__builtin_bswap32(tls, _data)

	return _data
}

func _OSSwapInt64(tls *libc.TLS, _data uint64_t) uint64_t {
	return libc.X__builtin_bswap64(tls, _data)
}

type _OSUnalignedU16 = struct{ __val uint16_t }

type _OSUnalignedU32 = struct{ __val uint32_t }

type _OSUnalignedU64 = struct{ __val uint64_t }

type u_char = uint8

type u_short = uint16

type u_int = uint32
type u_long = uint64
type ushort = uint16
type uint = uint32

type u_quad_t = u_int64_t
type quad_t = int64_t
type qaddr_t = uintptr

type caddr_t = uintptr

type daddr_t = int32_t

type dev_t = int32

type fixpt_t = u_int32_t

type blkcnt_t = int64

type blksize_t = int32

type gid_t = uint32

type in_addr_t = uint32

type in_port_t = uint16

type ino_t = uint64

type ino64_t = uint64

type key_t = int32

type mode_t = uint16

type nlink_t = uint16

type id_t = uint32

type pid_t = int32

type off_t = int64

type segsz_t = int32_t
type swblk_t = int32_t

type uid_t = uint32

type clock_t = uint64

type time_t = int64

type useconds_t = uint32

type suseconds_t = int32

type fd_set1 = struct{ fds_bits [32]int32 }

type fd_set = fd_set1

func X__darwin_check_fd_set(tls *libc.TLS, _a int32, _b uintptr) int32 {
	if uintptr_t(uintptr(unsafe.Pointer(&X__darwin_check_fd_set_overflow))) != uint64(0) {
		return (*struct {
			f func(*libc.TLS, int32, uintptr, int32) int32
		})(unsafe.Pointer(&struct{ uintptr }{X__darwin_check_fd_set_overflow})).f(tls, _a, _b, 0)
	} else {
		return 1
	}
	return int32(0)
}

func X__darwin_fd_isset(tls *libc.TLS, _fd int32, _p uintptr) int32 {
	if X__darwin_check_fd_set(tls, _fd, _p) != 0 {
		return *(*int32)(unsafe.Pointer(_p + uintptr(uint64(_fd)/(uint64(unsafe.Sizeof(int32(0)))*uint64(8)))*4)) & int32(uint64(1)<<(uint64(_fd)%(uint64(unsafe.Sizeof(int32(0)))*uint64(8))))
	}

	return 0
}

func X__darwin_fd_set(tls *libc.TLS, _fd int32, _p uintptr) {
	if X__darwin_check_fd_set(tls, _fd, _p) != 0 {
		*(*int32)(unsafe.Pointer(_p + uintptr(uint64(_fd)/(uint64(unsafe.Sizeof(int32(0)))*uint64(8)))*4)) |= int32(uint64(1) << (uint64(_fd) % (uint64(unsafe.Sizeof(int32(0))) * uint64(8))))
	}
}

func X__darwin_fd_clr(tls *libc.TLS, _fd int32, _p uintptr) {
	if X__darwin_check_fd_set(tls, _fd, _p) != 0 {
		*(*int32)(unsafe.Pointer(_p + uintptr(uint64(_fd)/(uint64(unsafe.Sizeof(int32(0)))*uint64(8)))*4)) &= ^int32(uint64(1) << (uint64(_fd) % (uint64(unsafe.Sizeof(int32(0))) * uint64(8))))
	}
}

type fd_mask = int32

type pthread_attr_t = _opaque_pthread_attr_t

type pthread_cond_t = _opaque_pthread_cond_t

type pthread_condattr_t = _opaque_pthread_condattr_t

type pthread_mutex_t = _opaque_pthread_mutex_t

type pthread_mutexattr_t = _opaque_pthread_mutexattr_t

type pthread_once_t = _opaque_pthread_once_t

type pthread_rwlock_t = _opaque_pthread_rwlock_t

type pthread_rwlockattr_t = _opaque_pthread_rwlockattr_t

type pthread_t = uintptr

type pthread_key_t = uint64

type fsblkcnt_t = uint32

type fsfilcnt_t = uint32

type timespec = struct {
	tv_sec  int64
	tv_nsec int64
}

type ostat = struct {
	st_dev       uint16
	_            [6]byte
	st_ino       ino_t
	st_mode      mode_t
	st_nlink     nlink_t
	st_uid       uint16
	st_gid       uint16
	st_rdev      uint16
	_            [2]byte
	st_size      int32
	st_atimespec struct {
		tv_sec  int64
		tv_nsec int64
	}
	st_mtimespec struct {
		tv_sec  int64
		tv_nsec int64
	}
	st_ctimespec struct {
		tv_sec  int64
		tv_nsec int64
	}
	st_blksize int32
	st_blocks  int32
	st_flags   uint32
	st_gen     uint32
}

type stat = struct {
	st_dev       dev_t
	st_mode      mode_t
	st_nlink     nlink_t
	st_ino       uint64
	st_uid       uid_t
	st_gid       gid_t
	st_rdev      dev_t
	_            [4]byte
	st_atimespec struct {
		tv_sec  int64
		tv_nsec int64
	}
	st_mtimespec struct {
		tv_sec  int64
		tv_nsec int64
	}
	st_ctimespec struct {
		tv_sec  int64
		tv_nsec int64
	}
	st_birthtimespec struct {
		tv_sec  int64
		tv_nsec int64
	}
	st_size    off_t
	st_blocks  blkcnt_t
	st_blksize blksize_t
	st_flags   uint32
	st_gen     uint32
	st_lspare  int32
	st_qspare  [2]int64
}

type filesec_t = uintptr

type flock = struct {
	l_start  off_t
	l_len    off_t
	l_pid    pid_t
	l_type   int16
	l_whence int16
}

type flocktimeout = struct {
	fl struct {
		l_start  off_t
		l_len    off_t
		l_pid    pid_t
		l_type   int16
		l_whence int16
	}
	timeout struct {
		tv_sec  int64
		tv_nsec int64
	}
}

type radvisory = struct {
	ra_offset off_t
	ra_count  int32
	_         [4]byte
}

type fsignatures = struct {
	fs_file_start       off_t
	fs_blob_start       uintptr
	fs_blob_size        size_t
	fs_fsignatures_size size_t
	fs_cdhash           [20]int8
	fs_hash_type        int32
}

type fsignatures_t = fsignatures

type fsupplement = struct {
	fs_file_start off_t
	fs_blob_start off_t
	fs_blob_size  size_t
	fs_orig_fd    int32
	_             [4]byte
}

type fsupplement_t = fsupplement

type fchecklv = struct {
	lv_file_start         off_t
	lv_error_message_size size_t
	lv_error_message      uintptr
}

type fchecklv_t = fchecklv

type fgetsigsinfo = struct {
	fg_file_start      off_t
	fg_info_request    int32
	fg_sig_is_platform int32
}

type fgetsigsinfo_t = fgetsigsinfo

type fstore = struct {
	fst_flags      uint32
	fst_posmode    int32
	fst_offset     off_t
	fst_length     off_t
	fst_bytesalloc off_t
}

type fstore_t = fstore

type fpunchhole = struct {
	fp_flags  uint32
	reserved  uint32
	fp_offset off_t
	fp_length off_t
}

type fpunchhole_t = fpunchhole

type ftrimactivefile = struct {
	fta_offset off_t
	fta_length off_t
}

type ftrimactivefile_t = ftrimactivefile

type fspecread = struct {
	fsr_flags  uint32
	reserved   uint32
	fsr_offset off_t
	fsr_length off_t
}

type fspecread_t = fspecread

type fbootstraptransfer = struct {
	fbt_offset off_t
	fbt_length size_t
	fbt_buffer uintptr
}

type fbootstraptransfer_t = fbootstraptransfer

type log2phys = struct {
	l2p_flags       uint32
	_               [4]byte
	l2p_contigbytes off_t
	l2p_devoffset   off_t
}

type filesec_property_t = uint32

type accessx_descriptor = struct {
	ad_name_offset uint32
	ad_flags       int32
	ad_pad         [2]int32
}

type kauth_cred_t = uintptr
type posix_cred_t = uintptr

type sig_atomic_t = int32

type __darwin_arm_exception_state = struct {
	__exception uint32
	__fsr       uint32
	__far       uint32
}

type __darwin_arm_exception_state64 = struct {
	__far       uint64
	__esr       uint32
	__exception uint32
}

type __darwin_arm_thread_state = struct {
	__r    [13]uint32
	__sp   uint32
	__lr   uint32
	__pc   uint32
	__cpsr uint32
}

type __darwin_arm_thread_state64 = struct {
	__x    [29]uint64
	__fp   uint64
	__lr   uint64
	__sp   uint64
	__pc   uint64
	__cpsr uint32
	__pad  uint32
}

type __darwin_arm_vfp_state = struct {
	__r     [64]uint32
	__fpscr uint32
}

type __darwin_arm_neon_state64 = struct {
	__v [32]struct {
		lo uint64
		hi uint64
	}
	__fpsr uint32
	__fpcr uint32
}

type __darwin_arm_neon_state = struct {
	__v [16]struct {
		lo uint64
		hi uint64
	}
	__fpsr uint32
	__fpcr uint32
}

type __arm_pagein_state = struct{ __pagein_error int32 }

type __arm_legacy_debug_state = struct {
	__bvr [16]uint32
	__bcr [16]uint32
	__wvr [16]uint32
	__wcr [16]uint32
}

type __darwin_arm_debug_state32 = struct {
	__bvr       [16]uint32
	__bcr       [16]uint32
	__wvr       [16]uint32
	__wcr       [16]uint32
	__mdscr_el1 uint64
}

type __darwin_arm_debug_state64 = struct {
	__bvr       [16]uint64
	__bcr       [16]uint64
	__wvr       [16]uint64
	__wcr       [16]uint64
	__mdscr_el1 uint64
}

type __darwin_arm_cpmu_state64 = struct{ __ctrs [16]uint64 }

type __darwin_mcontext32 = struct {
	__es struct {
		__exception uint32
		__fsr       uint32
		__far       uint32
	}
	__ss struct {
		__r    [13]uint32
		__sp   uint32
		__lr   uint32
		__pc   uint32
		__cpsr uint32
	}
	__fs struct {
		__r     [64]uint32
		__fpscr uint32
	}
}

type __darwin_mcontext64 = struct {
	__es struct {
		__far       uint64
		__esr       uint32
		__exception uint32
	}
	__ss struct {
		__x    [29]uint64
		__fp   uint64
		__lr   uint64
		__sp   uint64
		__pc   uint64
		__cpsr uint32
		__pad  uint32
	}
	__ns struct {
		__v [32]struct {
			lo uint64
			hi uint64
		}
		__fpsr uint32
		__fpcr uint32
	}
}

type mcontext_t = uintptr

type __darwin_sigaltstack = struct {
	ss_sp    uintptr
	ss_size  uint64
	ss_flags int32
	_        [4]byte
}

type stack_t = __darwin_sigaltstack

type __darwin_ucontext = struct {
	uc_onstack int32
	uc_sigmask uint32
	uc_stack   struct {
		ss_sp    uintptr
		ss_size  uint64
		ss_flags int32
		_        [4]byte
	}
	uc_link     uintptr
	uc_mcsize   uint64
	uc_mcontext uintptr
}

type ucontext_t = __darwin_ucontext

type sigset_t = uint32

type sigval = struct {
	_         [0]uint64
	sival_int int32
	_         [4]byte
}

type sigevent = struct {
	sigev_notify int32
	sigev_signo  int32
	sigev_value  struct {
		_         [0]uint64
		sival_int int32
		_         [4]byte
	}
	sigev_notify_function   uintptr
	sigev_notify_attributes uintptr
}

type __siginfo = struct {
	si_signo  int32
	si_errno  int32
	si_code   int32
	si_pid    pid_t
	si_uid    uid_t
	si_status int32
	si_addr   uintptr
	si_value  struct {
		_         [0]uint64
		sival_int int32
		_         [4]byte
	}
	si_band int64
	__pad   [7]uint64
}

type siginfo_t = __siginfo

type __sigaction_u = struct{ __sa_handler uintptr }

type __sigaction = struct {
	__sigaction_u struct{ __sa_handler uintptr }
	sa_tramp      uintptr
	sa_mask       sigset_t
	sa_flags      int32
}

type sigaction = struct {
	__sigaction_u struct{ __sa_handler uintptr }
	sa_mask       sigset_t
	sa_flags      int32
}

type sig_t = uintptr

type sigvec = struct {
	sv_handler uintptr
	sv_mask    int32
	sv_flags   int32
}

type sigstack = struct {
	ss_sp      uintptr
	ss_onstack int32
	_          [4]byte
}

type timeval = struct {
	tv_sec  int64
	tv_usec int32
	_       [4]byte
}

type uuid_t = [16]uint8

type tm = struct {
	tm_sec    int32
	tm_min    int32
	tm_hour   int32
	tm_mday   int32
	tm_mon    int32
	tm_year   int32
	tm_wday   int32
	tm_yday   int32
	tm_isdst  int32
	_         [4]byte
	tm_gmtoff int64
	tm_zone   uintptr
}

type clockid_t = uint32

type VFSFile1 = struct {
	base        sqlite3_file
	fsFile      uintptr
	fd          int32
	_           [4]byte
	aBuffer     uintptr
	nBuffer     int32
	_           [4]byte
	iBufferOfst sqlite3_int64
}

type VFSFile = VFSFile1

func vfsDirectWrite(tls *libc.TLS, p uintptr, zBuf uintptr, iAmt int32, iOfst sqlite_int64) int32 {
	bp := tls.Alloc(16)
	defer tls.Free(16)

	var ofst off_t
	var nWrite size_t

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__)), 178))
	libc.X__builtin_abort(tls)
	ofst = libc.Xlseek(tls, (*VFSFile)(unsafe.Pointer(p)).fd, iOfst, 0)
	if ofst != iOfst {
		return 10 | int32(3)<<8
	}

	nWrite = size_t(libc.Xwrite(tls, (*VFSFile)(unsafe.Pointer(p)).fd, zBuf, uint64(iAmt)))
	if nWrite != size_t(iAmt) {
		return 10 | int32(3)<<8
	}

	return 0
}

var __func__ = *(*[15]int8)(unsafe.Pointer(ts + 13))

func vfsFlushBuffer(tls *libc.TLS, p uintptr) int32 {
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__1)), 198))
	libc.X__builtin_abort(tls)
	var rc int32 = 0
	if (*VFSFile)(unsafe.Pointer(p)).nBuffer != 0 {
		rc = vfsDirectWrite(tls, p, (*VFSFile)(unsafe.Pointer(p)).aBuffer, (*VFSFile)(unsafe.Pointer(p)).nBuffer, (*VFSFile)(unsafe.Pointer(p)).iBufferOfst)
		(*VFSFile)(unsafe.Pointer(p)).nBuffer = 0
	}
	return rc
}

var __func__1 = *(*[15]int8)(unsafe.Pointer(ts + 28))

func vfsWrite(tls *libc.TLS, pFile uintptr, zBuf uintptr, iAmt int32, iOfst sqlite_int64) int32 {
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__4)), 273))
	libc.X__builtin_abort(tls)
	var p uintptr = pFile

	if (*VFSFile)(unsafe.Pointer(p)).aBuffer != 0 {
		var z uintptr = zBuf
		var n int32 = iAmt
		var i sqlite3_int64 = iOfst

		for n > 0 {
			var nCopy int32

			if (*VFSFile)(unsafe.Pointer(p)).nBuffer == 8192 || (*VFSFile)(unsafe.Pointer(p)).iBufferOfst+sqlite3_int64((*VFSFile)(unsafe.Pointer(p)).nBuffer) != i {
				var rc int32 = vfsFlushBuffer(tls, p)
				if rc != 0 {
					return rc
				}
			}
			if libc.X__builtin_expect(tls, libc.BoolInt64(!((*VFSFile)(unsafe.Pointer(p)).nBuffer == 0 || (*VFSFile)(unsafe.Pointer(p)).iBufferOfst+sqlite3_int64((*VFSFile)(unsafe.Pointer(p)).nBuffer) == i)), int64(0)) != 0 {
				libc.X__assert_rtn(tls, uintptr(unsafe.Pointer(&__func__4)), ts+43, 294, ts+51)
			} else {
			}
			(*VFSFile)(unsafe.Pointer(p)).iBufferOfst = i - sqlite3_int64((*VFSFile)(unsafe.Pointer(p)).nBuffer)

			nCopy = 8192 - (*VFSFile)(unsafe.Pointer(p)).nBuffer
			if nCopy > n {
				nCopy = n
			}
			libc.X__builtin___memcpy_chk(tls, (*VFSFile)(unsafe.Pointer(p)).aBuffer+uintptr((*VFSFile)(unsafe.Pointer(p)).nBuffer), z, uint64(nCopy), libc.X__builtin_object_size(tls, (*VFSFile)(unsafe.Pointer(p)).aBuffer+uintptr((*VFSFile)(unsafe.Pointer(p)).nBuffer), 0))
			*(*int32)(unsafe.Pointer(p + 32)) += nCopy

			n = n - nCopy
			i = i + sqlite3_int64(nCopy)
			z += uintptr(nCopy)
		}
	} else {
		return vfsDirectWrite(tls, p, zBuf, iAmt, iOfst)
	}

	return 0
}

var __func__4 = *(*[9]int8)(unsafe.Pointer(ts + 97))

func vfsTruncate(tls *libc.TLS, pFile uintptr, size sqlite_int64) int32 {
	return 0
}

func vfsSync(tls *libc.TLS, pFile uintptr, flags int32) int32 {
	bp := tls.Alloc(16)
	defer tls.Free(16)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__5)), 331))
	libc.X__builtin_abort(tls)
	var p uintptr = pFile
	var rc int32

	rc = vfsFlushBuffer(tls, p)
	if rc != 0 {
		return rc
	}

	rc = libc.Xfsync(tls, (*VFSFile)(unsafe.Pointer(p)).fd)
	return func() int32 {
		if rc == 0 {
			return 0
		}
		return 10 | int32(4)<<8
	}()
}

var __func__5 = *(*[8]int8)(unsafe.Pointer(ts + 106))

func vfsLock(tls *libc.TLS, pFile uintptr, eLock int32) int32 {
	return 0
}

func vfsUnlock(tls *libc.TLS, pFile uintptr, eLock int32) int32 {
	return 0
}

func vfsCheckReservedLock(tls *libc.TLS, pFile uintptr, pResOut uintptr) int32 {
	*(*int32)(unsafe.Pointer(pResOut)) = 0
	return 0
}

func vfsFileControl(tls *libc.TLS, pFile uintptr, op int32, pArg uintptr) int32 {
	return 12
}

func vfsSectorSize(tls *libc.TLS, pFile uintptr) int32 {
	return 0
}

func vfsDeviceCharacteristics(tls *libc.TLS, pFile uintptr) int32 {
	return 0
}

func vfsDelete(tls *libc.TLS, pVfs uintptr, zPath uintptr, dirSync int32) int32 {
	bp := tls.Alloc(4129)
	defer tls.Free(4129)

	libc.X__builtin_printf(tls, ts, libc.VaList(bp, uintptr(unsafe.Pointer(&__func__8)), 473))
	libc.X__builtin_abort(tls)
	var rc int32

	rc = libc.Xunlink(tls, zPath)
	if rc != 0 && *(*int32)(unsafe.Pointer(libc.X__error(tls))) == 2 {
		return 0
	}

	if rc == 0 && dirSync != 0 {
		var dfd int32
		var i int32

		sqlite3.Xsqlite3_snprintf(tls, 4096, bp+32, ts+114, libc.VaList(bp+16, zPath))
		*(*int8)(unsafe.Pointer(bp + 32 + 4096)) = int8(0)
		for i = int32(libc.Xstrlen(tls, bp+32)); i > 1 && int32(*(*int8)(unsafe.Pointer(bp + 32 + uintptr(i)))) != '/'; i++ {
		}
		*(*int8)(unsafe.Pointer(bp + 32 + uintptr(i))) = int8(0)

		dfd = libc.Xopen(tls, bp+32, 0x0000, libc.VaList(bp+24, 0))
		if dfd < 0 {
			rc = -1
		} else {
			rc = libc.Xfsync(tls, dfd)
			libc.Xclose(tls, dfd)
		}
	}
	return func() int32 {
		if rc == 0 {
			return 0
		}
		return 10 | int32(10)<<8
	}()
}

var __func__8 = *(*[10]int8)(unsafe.Pointer(ts + 117))

func vfsDlOpen(tls *libc.TLS, pVfs uintptr, zPath uintptr) uintptr {
	return uintptr(0)
}

func vfsDlError(tls *libc.TLS, pVfs uintptr, nByte int32, zErrMsg uintptr) {
	sqlite3.Xsqlite3_snprintf(tls, nByte, zErrMsg, ts+127, 0)
	*(*int8)(unsafe.Pointer(zErrMsg + uintptr(nByte-1))) = int8(0)
}

func vfsDlSym(tls *libc.TLS, pVfs uintptr, pH uintptr, z uintptr) uintptr {
	return uintptr(0)
}

func vfsDlClose(tls *libc.TLS, pVfs uintptr, pHandle uintptr) {
	return
}

func vfsRandomness(tls *libc.TLS, pVfs uintptr, nByte int32, zByte uintptr) int32 {
	return 0
}

func vfsSleep(tls *libc.TLS, pVfs uintptr, nMicro int32) int32 {
	libc.Xsleep(tls, uint32(nMicro/1000000))
	libc.Xusleep(tls, uint32(nMicro%1000000))
	return nMicro
}

func vfsCurrentTime(tls *libc.TLS, pVfs uintptr, pTime uintptr) int32 {
	var t time_t = libc.Xtime(tls, uintptr(0))
	*(*float64)(unsafe.Pointer(pTime)) = float64(t)/86400.0 + 2440587.5
	return 0
}

func Xsqlite3_fsFS(tls *libc.TLS, zName uintptr, pAppData uintptr) uintptr {
	var p uintptr = sqlite3.Xsqlite3_malloc(tls, int32(unsafe.Sizeof(sqlite3_vfs{})))
	if !(p != 0) {
		return uintptr(0)
	}

	*(*sqlite3_vfs)(unsafe.Pointer(p)) = sqlite3_vfs{
		iVersion:   1,
		szOsFile:   int32(unsafe.Sizeof(VFSFile{})),
		mxPathname: 4096,
		zName:      zName,
		pAppData:   pAppData,
		xOpen: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, uintptr, int32, uintptr) int32
		}{vfsOpen})),
		xDelete: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, int32) int32
		}{vfsDelete})),
		xAccess: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, int32, uintptr) int32
		}{vfsAccess})),
		xFullPathname: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, int32, uintptr) int32
		}{vfsFullPathname})),
		xDlOpen: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr) uintptr
		}{vfsDlOpen})),
		xDlError: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, int32, uintptr)
		}{vfsDlError})),
		xDlSym: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr, uintptr) uintptr
		}{vfsDlSym})),
		xDlClose: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr)
		}{vfsDlClose})),
		xRandomness: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, int32, uintptr) int32
		}{vfsRandomness})),
		xSleep: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, int32) int32
		}{vfsSleep})),
		xCurrentTime: *(*uintptr)(unsafe.Pointer(&struct {
			f func(*libc.TLS, uintptr, uintptr) int32
		}{vfsCurrentTime}))}
	return p
}

var ts1 = "TODO %s:%i:\n\x00vfsDirectWrite\x00vfsFlushBuffer\x00c/vfs.c\x00p->nBuffer==0 || p->iBufferOfst+p->nBuffer==i\x00vfsWrite\x00vfsSync\x00%s\x00vfsDelete\x00Loadable extensions are not supported\x00"
var ts = (*reflect.StringHeader)(unsafe.Pointer(&ts1)).Data
