// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/speech/v2/cloud_speech.proto

package speechpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Speech_CreateRecognizer_FullMethodName    = "/google.cloud.speech.v2.Speech/CreateRecognizer"
	Speech_ListRecognizers_FullMethodName     = "/google.cloud.speech.v2.Speech/ListRecognizers"
	Speech_GetRecognizer_FullMethodName       = "/google.cloud.speech.v2.Speech/GetRecognizer"
	Speech_UpdateRecognizer_FullMethodName    = "/google.cloud.speech.v2.Speech/UpdateRecognizer"
	Speech_DeleteRecognizer_FullMethodName    = "/google.cloud.speech.v2.Speech/DeleteRecognizer"
	Speech_UndeleteRecognizer_FullMethodName  = "/google.cloud.speech.v2.Speech/UndeleteRecognizer"
	Speech_Recognize_FullMethodName           = "/google.cloud.speech.v2.Speech/Recognize"
	Speech_StreamingRecognize_FullMethodName  = "/google.cloud.speech.v2.Speech/StreamingRecognize"
	Speech_BatchRecognize_FullMethodName      = "/google.cloud.speech.v2.Speech/BatchRecognize"
	Speech_GetConfig_FullMethodName           = "/google.cloud.speech.v2.Speech/GetConfig"
	Speech_UpdateConfig_FullMethodName        = "/google.cloud.speech.v2.Speech/UpdateConfig"
	Speech_CreateCustomClass_FullMethodName   = "/google.cloud.speech.v2.Speech/CreateCustomClass"
	Speech_ListCustomClasses_FullMethodName   = "/google.cloud.speech.v2.Speech/ListCustomClasses"
	Speech_GetCustomClass_FullMethodName      = "/google.cloud.speech.v2.Speech/GetCustomClass"
	Speech_UpdateCustomClass_FullMethodName   = "/google.cloud.speech.v2.Speech/UpdateCustomClass"
	Speech_DeleteCustomClass_FullMethodName   = "/google.cloud.speech.v2.Speech/DeleteCustomClass"
	Speech_UndeleteCustomClass_FullMethodName = "/google.cloud.speech.v2.Speech/UndeleteCustomClass"
	Speech_CreatePhraseSet_FullMethodName     = "/google.cloud.speech.v2.Speech/CreatePhraseSet"
	Speech_ListPhraseSets_FullMethodName      = "/google.cloud.speech.v2.Speech/ListPhraseSets"
	Speech_GetPhraseSet_FullMethodName        = "/google.cloud.speech.v2.Speech/GetPhraseSet"
	Speech_UpdatePhraseSet_FullMethodName     = "/google.cloud.speech.v2.Speech/UpdatePhraseSet"
	Speech_DeletePhraseSet_FullMethodName     = "/google.cloud.speech.v2.Speech/DeletePhraseSet"
	Speech_UndeletePhraseSet_FullMethodName   = "/google.cloud.speech.v2.Speech/UndeletePhraseSet"
)

// SpeechClient is the client API for Speech service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type SpeechClient interface {
	// Creates a [Recognizer][google.cloud.speech.v2.Recognizer].
	CreateRecognizer(ctx context.Context, in *CreateRecognizerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists Recognizers.
	ListRecognizers(ctx context.Context, in *ListRecognizersRequest, opts ...grpc.CallOption) (*ListRecognizersResponse, error)
	// Returns the requested
	// [Recognizer][google.cloud.speech.v2.Recognizer]. Fails with
	// [NOT_FOUND][google.rpc.Code.NOT_FOUND] if the requested Recognizer doesn't
	// exist.
	GetRecognizer(ctx context.Context, in *GetRecognizerRequest, opts ...grpc.CallOption) (*Recognizer, error)
	// Updates the [Recognizer][google.cloud.speech.v2.Recognizer].
	UpdateRecognizer(ctx context.Context, in *UpdateRecognizerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the [Recognizer][google.cloud.speech.v2.Recognizer].
	DeleteRecognizer(ctx context.Context, in *DeleteRecognizerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Undeletes the [Recognizer][google.cloud.speech.v2.Recognizer].
	UndeleteRecognizer(ctx context.Context, in *UndeleteRecognizerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Performs synchronous Speech recognition: receive results after all audio
	// has been sent and processed.
	Recognize(ctx context.Context, in *RecognizeRequest, opts ...grpc.CallOption) (*RecognizeResponse, error)
	// Performs bidirectional streaming speech recognition: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingRecognize(ctx context.Context, opts ...grpc.CallOption) (Speech_StreamingRecognizeClient, error)
	// Performs batch asynchronous speech recognition: send a request with N
	// audio files and receive a long running operation that can be polled to see
	// when the transcriptions are finished.
	BatchRecognize(ctx context.Context, in *BatchRecognizeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Returns the requested [Config][google.cloud.speech.v2.Config].
	GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*Config, error)
	// Updates the [Config][google.cloud.speech.v2.Config].
	UpdateConfig(ctx context.Context, in *UpdateConfigRequest, opts ...grpc.CallOption) (*Config, error)
	// Creates a [CustomClass][google.cloud.speech.v2.CustomClass].
	CreateCustomClass(ctx context.Context, in *CreateCustomClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists CustomClasses.
	ListCustomClasses(ctx context.Context, in *ListCustomClassesRequest, opts ...grpc.CallOption) (*ListCustomClassesResponse, error)
	// Returns the requested
	// [CustomClass][google.cloud.speech.v2.CustomClass].
	GetCustomClass(ctx context.Context, in *GetCustomClassRequest, opts ...grpc.CallOption) (*CustomClass, error)
	// Updates the [CustomClass][google.cloud.speech.v2.CustomClass].
	UpdateCustomClass(ctx context.Context, in *UpdateCustomClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the [CustomClass][google.cloud.speech.v2.CustomClass].
	DeleteCustomClass(ctx context.Context, in *DeleteCustomClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Undeletes the [CustomClass][google.cloud.speech.v2.CustomClass].
	UndeleteCustomClass(ctx context.Context, in *UndeleteCustomClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a [PhraseSet][google.cloud.speech.v2.PhraseSet].
	CreatePhraseSet(ctx context.Context, in *CreatePhraseSetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists PhraseSets.
	ListPhraseSets(ctx context.Context, in *ListPhraseSetsRequest, opts ...grpc.CallOption) (*ListPhraseSetsResponse, error)
	// Returns the requested
	// [PhraseSet][google.cloud.speech.v2.PhraseSet].
	GetPhraseSet(ctx context.Context, in *GetPhraseSetRequest, opts ...grpc.CallOption) (*PhraseSet, error)
	// Updates the [PhraseSet][google.cloud.speech.v2.PhraseSet].
	UpdatePhraseSet(ctx context.Context, in *UpdatePhraseSetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes the [PhraseSet][google.cloud.speech.v2.PhraseSet].
	DeletePhraseSet(ctx context.Context, in *DeletePhraseSetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Undeletes the [PhraseSet][google.cloud.speech.v2.PhraseSet].
	UndeletePhraseSet(ctx context.Context, in *UndeletePhraseSetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type speechClient struct {
	cc grpc.ClientConnInterface
}

func NewSpeechClient(cc grpc.ClientConnInterface) SpeechClient {
	return &speechClient{cc}
}

func (c *speechClient) CreateRecognizer(ctx context.Context, in *CreateRecognizerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Speech_CreateRecognizer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) ListRecognizers(ctx context.Context, in *ListRecognizersRequest, opts ...grpc.CallOption) (*ListRecognizersResponse, error) {
	out := new(ListRecognizersResponse)
	err := c.cc.Invoke(ctx, Speech_ListRecognizers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) GetRecognizer(ctx context.Context, in *GetRecognizerRequest, opts ...grpc.CallOption) (*Recognizer, error) {
	out := new(Recognizer)
	err := c.cc.Invoke(ctx, Speech_GetRecognizer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) UpdateRecognizer(ctx context.Context, in *UpdateRecognizerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Speech_UpdateRecognizer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) DeleteRecognizer(ctx context.Context, in *DeleteRecognizerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Speech_DeleteRecognizer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) UndeleteRecognizer(ctx context.Context, in *UndeleteRecognizerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Speech_UndeleteRecognizer_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) Recognize(ctx context.Context, in *RecognizeRequest, opts ...grpc.CallOption) (*RecognizeResponse, error) {
	out := new(RecognizeResponse)
	err := c.cc.Invoke(ctx, Speech_Recognize_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) StreamingRecognize(ctx context.Context, opts ...grpc.CallOption) (Speech_StreamingRecognizeClient, error) {
	stream, err := c.cc.NewStream(ctx, &Speech_ServiceDesc.Streams[0], Speech_StreamingRecognize_FullMethodName, opts...)
	if err != nil {
		return nil, err
	}
	x := &speechStreamingRecognizeClient{stream}
	return x, nil
}

type Speech_StreamingRecognizeClient interface {
	Send(*StreamingRecognizeRequest) error
	Recv() (*StreamingRecognizeResponse, error)
	grpc.ClientStream
}

type speechStreamingRecognizeClient struct {
	grpc.ClientStream
}

func (x *speechStreamingRecognizeClient) Send(m *StreamingRecognizeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *speechStreamingRecognizeClient) Recv() (*StreamingRecognizeResponse, error) {
	m := new(StreamingRecognizeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *speechClient) BatchRecognize(ctx context.Context, in *BatchRecognizeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Speech_BatchRecognize_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) GetConfig(ctx context.Context, in *GetConfigRequest, opts ...grpc.CallOption) (*Config, error) {
	out := new(Config)
	err := c.cc.Invoke(ctx, Speech_GetConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) UpdateConfig(ctx context.Context, in *UpdateConfigRequest, opts ...grpc.CallOption) (*Config, error) {
	out := new(Config)
	err := c.cc.Invoke(ctx, Speech_UpdateConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) CreateCustomClass(ctx context.Context, in *CreateCustomClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Speech_CreateCustomClass_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) ListCustomClasses(ctx context.Context, in *ListCustomClassesRequest, opts ...grpc.CallOption) (*ListCustomClassesResponse, error) {
	out := new(ListCustomClassesResponse)
	err := c.cc.Invoke(ctx, Speech_ListCustomClasses_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) GetCustomClass(ctx context.Context, in *GetCustomClassRequest, opts ...grpc.CallOption) (*CustomClass, error) {
	out := new(CustomClass)
	err := c.cc.Invoke(ctx, Speech_GetCustomClass_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) UpdateCustomClass(ctx context.Context, in *UpdateCustomClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Speech_UpdateCustomClass_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) DeleteCustomClass(ctx context.Context, in *DeleteCustomClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Speech_DeleteCustomClass_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) UndeleteCustomClass(ctx context.Context, in *UndeleteCustomClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Speech_UndeleteCustomClass_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) CreatePhraseSet(ctx context.Context, in *CreatePhraseSetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Speech_CreatePhraseSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) ListPhraseSets(ctx context.Context, in *ListPhraseSetsRequest, opts ...grpc.CallOption) (*ListPhraseSetsResponse, error) {
	out := new(ListPhraseSetsResponse)
	err := c.cc.Invoke(ctx, Speech_ListPhraseSets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) GetPhraseSet(ctx context.Context, in *GetPhraseSetRequest, opts ...grpc.CallOption) (*PhraseSet, error) {
	out := new(PhraseSet)
	err := c.cc.Invoke(ctx, Speech_GetPhraseSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) UpdatePhraseSet(ctx context.Context, in *UpdatePhraseSetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Speech_UpdatePhraseSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) DeletePhraseSet(ctx context.Context, in *DeletePhraseSetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Speech_DeletePhraseSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) UndeletePhraseSet(ctx context.Context, in *UndeletePhraseSetRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Speech_UndeletePhraseSet_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SpeechServer is the server API for Speech service.
// All implementations should embed UnimplementedSpeechServer
// for forward compatibility
type SpeechServer interface {
	// Creates a [Recognizer][google.cloud.speech.v2.Recognizer].
	CreateRecognizer(context.Context, *CreateRecognizerRequest) (*longrunningpb.Operation, error)
	// Lists Recognizers.
	ListRecognizers(context.Context, *ListRecognizersRequest) (*ListRecognizersResponse, error)
	// Returns the requested
	// [Recognizer][google.cloud.speech.v2.Recognizer]. Fails with
	// [NOT_FOUND][google.rpc.Code.NOT_FOUND] if the requested Recognizer doesn't
	// exist.
	GetRecognizer(context.Context, *GetRecognizerRequest) (*Recognizer, error)
	// Updates the [Recognizer][google.cloud.speech.v2.Recognizer].
	UpdateRecognizer(context.Context, *UpdateRecognizerRequest) (*longrunningpb.Operation, error)
	// Deletes the [Recognizer][google.cloud.speech.v2.Recognizer].
	DeleteRecognizer(context.Context, *DeleteRecognizerRequest) (*longrunningpb.Operation, error)
	// Undeletes the [Recognizer][google.cloud.speech.v2.Recognizer].
	UndeleteRecognizer(context.Context, *UndeleteRecognizerRequest) (*longrunningpb.Operation, error)
	// Performs synchronous Speech recognition: receive results after all audio
	// has been sent and processed.
	Recognize(context.Context, *RecognizeRequest) (*RecognizeResponse, error)
	// Performs bidirectional streaming speech recognition: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingRecognize(Speech_StreamingRecognizeServer) error
	// Performs batch asynchronous speech recognition: send a request with N
	// audio files and receive a long running operation that can be polled to see
	// when the transcriptions are finished.
	BatchRecognize(context.Context, *BatchRecognizeRequest) (*longrunningpb.Operation, error)
	// Returns the requested [Config][google.cloud.speech.v2.Config].
	GetConfig(context.Context, *GetConfigRequest) (*Config, error)
	// Updates the [Config][google.cloud.speech.v2.Config].
	UpdateConfig(context.Context, *UpdateConfigRequest) (*Config, error)
	// Creates a [CustomClass][google.cloud.speech.v2.CustomClass].
	CreateCustomClass(context.Context, *CreateCustomClassRequest) (*longrunningpb.Operation, error)
	// Lists CustomClasses.
	ListCustomClasses(context.Context, *ListCustomClassesRequest) (*ListCustomClassesResponse, error)
	// Returns the requested
	// [CustomClass][google.cloud.speech.v2.CustomClass].
	GetCustomClass(context.Context, *GetCustomClassRequest) (*CustomClass, error)
	// Updates the [CustomClass][google.cloud.speech.v2.CustomClass].
	UpdateCustomClass(context.Context, *UpdateCustomClassRequest) (*longrunningpb.Operation, error)
	// Deletes the [CustomClass][google.cloud.speech.v2.CustomClass].
	DeleteCustomClass(context.Context, *DeleteCustomClassRequest) (*longrunningpb.Operation, error)
	// Undeletes the [CustomClass][google.cloud.speech.v2.CustomClass].
	UndeleteCustomClass(context.Context, *UndeleteCustomClassRequest) (*longrunningpb.Operation, error)
	// Creates a [PhraseSet][google.cloud.speech.v2.PhraseSet].
	CreatePhraseSet(context.Context, *CreatePhraseSetRequest) (*longrunningpb.Operation, error)
	// Lists PhraseSets.
	ListPhraseSets(context.Context, *ListPhraseSetsRequest) (*ListPhraseSetsResponse, error)
	// Returns the requested
	// [PhraseSet][google.cloud.speech.v2.PhraseSet].
	GetPhraseSet(context.Context, *GetPhraseSetRequest) (*PhraseSet, error)
	// Updates the [PhraseSet][google.cloud.speech.v2.PhraseSet].
	UpdatePhraseSet(context.Context, *UpdatePhraseSetRequest) (*longrunningpb.Operation, error)
	// Deletes the [PhraseSet][google.cloud.speech.v2.PhraseSet].
	DeletePhraseSet(context.Context, *DeletePhraseSetRequest) (*longrunningpb.Operation, error)
	// Undeletes the [PhraseSet][google.cloud.speech.v2.PhraseSet].
	UndeletePhraseSet(context.Context, *UndeletePhraseSetRequest) (*longrunningpb.Operation, error)
}

// UnimplementedSpeechServer should be embedded to have forward compatible implementations.
type UnimplementedSpeechServer struct {
}

func (UnimplementedSpeechServer) CreateRecognizer(context.Context, *CreateRecognizerRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRecognizer not implemented")
}
func (UnimplementedSpeechServer) ListRecognizers(context.Context, *ListRecognizersRequest) (*ListRecognizersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRecognizers not implemented")
}
func (UnimplementedSpeechServer) GetRecognizer(context.Context, *GetRecognizerRequest) (*Recognizer, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRecognizer not implemented")
}
func (UnimplementedSpeechServer) UpdateRecognizer(context.Context, *UpdateRecognizerRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRecognizer not implemented")
}
func (UnimplementedSpeechServer) DeleteRecognizer(context.Context, *DeleteRecognizerRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRecognizer not implemented")
}
func (UnimplementedSpeechServer) UndeleteRecognizer(context.Context, *UndeleteRecognizerRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteRecognizer not implemented")
}
func (UnimplementedSpeechServer) Recognize(context.Context, *RecognizeRequest) (*RecognizeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Recognize not implemented")
}
func (UnimplementedSpeechServer) StreamingRecognize(Speech_StreamingRecognizeServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingRecognize not implemented")
}
func (UnimplementedSpeechServer) BatchRecognize(context.Context, *BatchRecognizeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchRecognize not implemented")
}
func (UnimplementedSpeechServer) GetConfig(context.Context, *GetConfigRequest) (*Config, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConfig not implemented")
}
func (UnimplementedSpeechServer) UpdateConfig(context.Context, *UpdateConfigRequest) (*Config, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateConfig not implemented")
}
func (UnimplementedSpeechServer) CreateCustomClass(context.Context, *CreateCustomClassRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCustomClass not implemented")
}
func (UnimplementedSpeechServer) ListCustomClasses(context.Context, *ListCustomClassesRequest) (*ListCustomClassesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCustomClasses not implemented")
}
func (UnimplementedSpeechServer) GetCustomClass(context.Context, *GetCustomClassRequest) (*CustomClass, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCustomClass not implemented")
}
func (UnimplementedSpeechServer) UpdateCustomClass(context.Context, *UpdateCustomClassRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCustomClass not implemented")
}
func (UnimplementedSpeechServer) DeleteCustomClass(context.Context, *DeleteCustomClassRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCustomClass not implemented")
}
func (UnimplementedSpeechServer) UndeleteCustomClass(context.Context, *UndeleteCustomClassRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeleteCustomClass not implemented")
}
func (UnimplementedSpeechServer) CreatePhraseSet(context.Context, *CreatePhraseSetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePhraseSet not implemented")
}
func (UnimplementedSpeechServer) ListPhraseSets(context.Context, *ListPhraseSetsRequest) (*ListPhraseSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPhraseSets not implemented")
}
func (UnimplementedSpeechServer) GetPhraseSet(context.Context, *GetPhraseSetRequest) (*PhraseSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPhraseSet not implemented")
}
func (UnimplementedSpeechServer) UpdatePhraseSet(context.Context, *UpdatePhraseSetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePhraseSet not implemented")
}
func (UnimplementedSpeechServer) DeletePhraseSet(context.Context, *DeletePhraseSetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePhraseSet not implemented")
}
func (UnimplementedSpeechServer) UndeletePhraseSet(context.Context, *UndeletePhraseSetRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UndeletePhraseSet not implemented")
}

// UnsafeSpeechServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to SpeechServer will
// result in compilation errors.
type UnsafeSpeechServer interface {
	mustEmbedUnimplementedSpeechServer()
}

func RegisterSpeechServer(s grpc.ServiceRegistrar, srv SpeechServer) {
	s.RegisterService(&Speech_ServiceDesc, srv)
}

func _Speech_CreateRecognizer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRecognizerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).CreateRecognizer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_CreateRecognizer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).CreateRecognizer(ctx, req.(*CreateRecognizerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_ListRecognizers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRecognizersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).ListRecognizers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_ListRecognizers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).ListRecognizers(ctx, req.(*ListRecognizersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_GetRecognizer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRecognizerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).GetRecognizer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_GetRecognizer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).GetRecognizer(ctx, req.(*GetRecognizerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_UpdateRecognizer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRecognizerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).UpdateRecognizer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_UpdateRecognizer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).UpdateRecognizer(ctx, req.(*UpdateRecognizerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_DeleteRecognizer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRecognizerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).DeleteRecognizer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_DeleteRecognizer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).DeleteRecognizer(ctx, req.(*DeleteRecognizerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_UndeleteRecognizer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteRecognizerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).UndeleteRecognizer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_UndeleteRecognizer_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).UndeleteRecognizer(ctx, req.(*UndeleteRecognizerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_Recognize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecognizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).Recognize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_Recognize_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).Recognize(ctx, req.(*RecognizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_StreamingRecognize_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SpeechServer).StreamingRecognize(&speechStreamingRecognizeServer{stream})
}

type Speech_StreamingRecognizeServer interface {
	Send(*StreamingRecognizeResponse) error
	Recv() (*StreamingRecognizeRequest, error)
	grpc.ServerStream
}

type speechStreamingRecognizeServer struct {
	grpc.ServerStream
}

func (x *speechStreamingRecognizeServer) Send(m *StreamingRecognizeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *speechStreamingRecognizeServer) Recv() (*StreamingRecognizeRequest, error) {
	m := new(StreamingRecognizeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _Speech_BatchRecognize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchRecognizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).BatchRecognize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_BatchRecognize_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).BatchRecognize(ctx, req.(*BatchRecognizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_GetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).GetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_GetConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).GetConfig(ctx, req.(*GetConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_UpdateConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).UpdateConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_UpdateConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).UpdateConfig(ctx, req.(*UpdateConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_CreateCustomClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCustomClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).CreateCustomClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_CreateCustomClass_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).CreateCustomClass(ctx, req.(*CreateCustomClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_ListCustomClasses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCustomClassesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).ListCustomClasses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_ListCustomClasses_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).ListCustomClasses(ctx, req.(*ListCustomClassesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_GetCustomClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCustomClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).GetCustomClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_GetCustomClass_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).GetCustomClass(ctx, req.(*GetCustomClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_UpdateCustomClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCustomClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).UpdateCustomClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_UpdateCustomClass_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).UpdateCustomClass(ctx, req.(*UpdateCustomClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_DeleteCustomClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCustomClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).DeleteCustomClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_DeleteCustomClass_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).DeleteCustomClass(ctx, req.(*DeleteCustomClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_UndeleteCustomClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeleteCustomClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).UndeleteCustomClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_UndeleteCustomClass_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).UndeleteCustomClass(ctx, req.(*UndeleteCustomClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_CreatePhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).CreatePhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_CreatePhraseSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).CreatePhraseSet(ctx, req.(*CreatePhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_ListPhraseSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPhraseSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).ListPhraseSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_ListPhraseSets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).ListPhraseSets(ctx, req.(*ListPhraseSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_GetPhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).GetPhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_GetPhraseSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).GetPhraseSet(ctx, req.(*GetPhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_UpdatePhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).UpdatePhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_UpdatePhraseSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).UpdatePhraseSet(ctx, req.(*UpdatePhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_DeletePhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).DeletePhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_DeletePhraseSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).DeletePhraseSet(ctx, req.(*DeletePhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_UndeletePhraseSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UndeletePhraseSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).UndeletePhraseSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Speech_UndeletePhraseSet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).UndeletePhraseSet(ctx, req.(*UndeletePhraseSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Speech_ServiceDesc is the grpc.ServiceDesc for Speech service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Speech_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.speech.v2.Speech",
	HandlerType: (*SpeechServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateRecognizer",
			Handler:    _Speech_CreateRecognizer_Handler,
		},
		{
			MethodName: "ListRecognizers",
			Handler:    _Speech_ListRecognizers_Handler,
		},
		{
			MethodName: "GetRecognizer",
			Handler:    _Speech_GetRecognizer_Handler,
		},
		{
			MethodName: "UpdateRecognizer",
			Handler:    _Speech_UpdateRecognizer_Handler,
		},
		{
			MethodName: "DeleteRecognizer",
			Handler:    _Speech_DeleteRecognizer_Handler,
		},
		{
			MethodName: "UndeleteRecognizer",
			Handler:    _Speech_UndeleteRecognizer_Handler,
		},
		{
			MethodName: "Recognize",
			Handler:    _Speech_Recognize_Handler,
		},
		{
			MethodName: "BatchRecognize",
			Handler:    _Speech_BatchRecognize_Handler,
		},
		{
			MethodName: "GetConfig",
			Handler:    _Speech_GetConfig_Handler,
		},
		{
			MethodName: "UpdateConfig",
			Handler:    _Speech_UpdateConfig_Handler,
		},
		{
			MethodName: "CreateCustomClass",
			Handler:    _Speech_CreateCustomClass_Handler,
		},
		{
			MethodName: "ListCustomClasses",
			Handler:    _Speech_ListCustomClasses_Handler,
		},
		{
			MethodName: "GetCustomClass",
			Handler:    _Speech_GetCustomClass_Handler,
		},
		{
			MethodName: "UpdateCustomClass",
			Handler:    _Speech_UpdateCustomClass_Handler,
		},
		{
			MethodName: "DeleteCustomClass",
			Handler:    _Speech_DeleteCustomClass_Handler,
		},
		{
			MethodName: "UndeleteCustomClass",
			Handler:    _Speech_UndeleteCustomClass_Handler,
		},
		{
			MethodName: "CreatePhraseSet",
			Handler:    _Speech_CreatePhraseSet_Handler,
		},
		{
			MethodName: "ListPhraseSets",
			Handler:    _Speech_ListPhraseSets_Handler,
		},
		{
			MethodName: "GetPhraseSet",
			Handler:    _Speech_GetPhraseSet_Handler,
		},
		{
			MethodName: "UpdatePhraseSet",
			Handler:    _Speech_UpdatePhraseSet_Handler,
		},
		{
			MethodName: "DeletePhraseSet",
			Handler:    _Speech_DeletePhraseSet_Handler,
		},
		{
			MethodName: "UndeletePhraseSet",
			Handler:    _Speech_UndeletePhraseSet_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingRecognize",
			Handler:       _Speech_StreamingRecognize_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/speech/v2/cloud_speech.proto",
}
