// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/vmmigration/v1/vmmigration.proto

package vmmigrationpb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	errdetails "google.golang.org/genproto/googleapis/rpc/errdetails"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Types of disks supported for Compute Engine VM.
type ComputeEngineDiskType int32

const (
	// An unspecified disk type. Will be used as STANDARD.
	ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_UNSPECIFIED ComputeEngineDiskType = 0
	// A Standard disk type.
	ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_STANDARD ComputeEngineDiskType = 1
	// SSD hard disk type.
	ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_SSD ComputeEngineDiskType = 2
	// An alternative to SSD persistent disks that balance performance and
	// cost.
	ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_BALANCED ComputeEngineDiskType = 3
	// Hyperdisk balanced disk type.
	ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_HYPERDISK_BALANCED ComputeEngineDiskType = 4
)

// Enum value maps for ComputeEngineDiskType.
var (
	ComputeEngineDiskType_name = map[int32]string{
		0: "COMPUTE_ENGINE_DISK_TYPE_UNSPECIFIED",
		1: "COMPUTE_ENGINE_DISK_TYPE_STANDARD",
		2: "COMPUTE_ENGINE_DISK_TYPE_SSD",
		3: "COMPUTE_ENGINE_DISK_TYPE_BALANCED",
		4: "COMPUTE_ENGINE_DISK_TYPE_HYPERDISK_BALANCED",
	}
	ComputeEngineDiskType_value = map[string]int32{
		"COMPUTE_ENGINE_DISK_TYPE_UNSPECIFIED":        0,
		"COMPUTE_ENGINE_DISK_TYPE_STANDARD":           1,
		"COMPUTE_ENGINE_DISK_TYPE_SSD":                2,
		"COMPUTE_ENGINE_DISK_TYPE_BALANCED":           3,
		"COMPUTE_ENGINE_DISK_TYPE_HYPERDISK_BALANCED": 4,
	}
)

func (x ComputeEngineDiskType) Enum() *ComputeEngineDiskType {
	p := new(ComputeEngineDiskType)
	*p = x
	return p
}

func (x ComputeEngineDiskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeEngineDiskType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[0].Descriptor()
}

func (ComputeEngineDiskType) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[0]
}

func (x ComputeEngineDiskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeEngineDiskType.Descriptor instead.
func (ComputeEngineDiskType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{0}
}

// Types of licenses used in OS adaptation.
type ComputeEngineLicenseType int32

const (
	// The license type is the default for the OS.
	ComputeEngineLicenseType_COMPUTE_ENGINE_LICENSE_TYPE_DEFAULT ComputeEngineLicenseType = 0
	// The license type is Pay As You Go license type.
	ComputeEngineLicenseType_COMPUTE_ENGINE_LICENSE_TYPE_PAYG ComputeEngineLicenseType = 1
	// The license type is Bring Your Own License type.
	ComputeEngineLicenseType_COMPUTE_ENGINE_LICENSE_TYPE_BYOL ComputeEngineLicenseType = 2
)

// Enum value maps for ComputeEngineLicenseType.
var (
	ComputeEngineLicenseType_name = map[int32]string{
		0: "COMPUTE_ENGINE_LICENSE_TYPE_DEFAULT",
		1: "COMPUTE_ENGINE_LICENSE_TYPE_PAYG",
		2: "COMPUTE_ENGINE_LICENSE_TYPE_BYOL",
	}
	ComputeEngineLicenseType_value = map[string]int32{
		"COMPUTE_ENGINE_LICENSE_TYPE_DEFAULT": 0,
		"COMPUTE_ENGINE_LICENSE_TYPE_PAYG":    1,
		"COMPUTE_ENGINE_LICENSE_TYPE_BYOL":    2,
	}
)

func (x ComputeEngineLicenseType) Enum() *ComputeEngineLicenseType {
	p := new(ComputeEngineLicenseType)
	*p = x
	return p
}

func (x ComputeEngineLicenseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeEngineLicenseType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[1].Descriptor()
}

func (ComputeEngineLicenseType) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[1]
}

func (x ComputeEngineLicenseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeEngineLicenseType.Descriptor instead.
func (ComputeEngineLicenseType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{1}
}

// Possible values for vm boot option.
type ComputeEngineBootOption int32

const (
	// The boot option is unknown.
	ComputeEngineBootOption_COMPUTE_ENGINE_BOOT_OPTION_UNSPECIFIED ComputeEngineBootOption = 0
	// The boot option is EFI.
	ComputeEngineBootOption_COMPUTE_ENGINE_BOOT_OPTION_EFI ComputeEngineBootOption = 1
	// The boot option is BIOS.
	ComputeEngineBootOption_COMPUTE_ENGINE_BOOT_OPTION_BIOS ComputeEngineBootOption = 2
)

// Enum value maps for ComputeEngineBootOption.
var (
	ComputeEngineBootOption_name = map[int32]string{
		0: "COMPUTE_ENGINE_BOOT_OPTION_UNSPECIFIED",
		1: "COMPUTE_ENGINE_BOOT_OPTION_EFI",
		2: "COMPUTE_ENGINE_BOOT_OPTION_BIOS",
	}
	ComputeEngineBootOption_value = map[string]int32{
		"COMPUTE_ENGINE_BOOT_OPTION_UNSPECIFIED": 0,
		"COMPUTE_ENGINE_BOOT_OPTION_EFI":         1,
		"COMPUTE_ENGINE_BOOT_OPTION_BIOS":        2,
	}
)

func (x ComputeEngineBootOption) Enum() *ComputeEngineBootOption {
	p := new(ComputeEngineBootOption)
	*p = x
	return p
}

func (x ComputeEngineBootOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeEngineBootOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[2].Descriptor()
}

func (ComputeEngineBootOption) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[2]
}

func (x ComputeEngineBootOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeEngineBootOption.Descriptor instead.
func (ComputeEngineBootOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{2}
}

// VM operating system (OS) capabilities needed for determining compatibility
// with Compute Engine features supported by the migration.
type OsCapability int32

const (
	// This is for API compatibility only and is not in use.
	OsCapability_OS_CAPABILITY_UNSPECIFIED OsCapability = 0
	// NVMe driver installed and the VM can use NVMe PD or local SSD.
	OsCapability_OS_CAPABILITY_NVME_STORAGE_ACCESS OsCapability = 1
	// gVNIC virtual NIC driver supported.
	OsCapability_OS_CAPABILITY_GVNIC_NETWORK_INTERFACE OsCapability = 2
	// IDPF virtual NIC driver supported.
	OsCapability_OS_CAPABILITY_IDPF_NETWORK_INTERFACE OsCapability = 3
)

// Enum value maps for OsCapability.
var (
	OsCapability_name = map[int32]string{
		0: "OS_CAPABILITY_UNSPECIFIED",
		1: "OS_CAPABILITY_NVME_STORAGE_ACCESS",
		2: "OS_CAPABILITY_GVNIC_NETWORK_INTERFACE",
		3: "OS_CAPABILITY_IDPF_NETWORK_INTERFACE",
	}
	OsCapability_value = map[string]int32{
		"OS_CAPABILITY_UNSPECIFIED":             0,
		"OS_CAPABILITY_NVME_STORAGE_ACCESS":     1,
		"OS_CAPABILITY_GVNIC_NETWORK_INTERFACE": 2,
		"OS_CAPABILITY_IDPF_NETWORK_INTERFACE":  3,
	}
)

func (x OsCapability) Enum() *OsCapability {
	p := new(OsCapability)
	*p = x
	return p
}

func (x OsCapability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (OsCapability) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[3].Descriptor()
}

func (OsCapability) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[3]
}

func (x OsCapability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use OsCapability.Descriptor instead.
func (OsCapability) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{3}
}

// Possible boot options conversions.
type BootConversion int32

const (
	// Unspecified conversion type.
	BootConversion_BOOT_CONVERSION_UNSPECIFIED BootConversion = 0
	// No conversion.
	BootConversion_NONE BootConversion = 1
	// Convert from BIOS to EFI.
	BootConversion_BIOS_TO_EFI BootConversion = 2
)

// Enum value maps for BootConversion.
var (
	BootConversion_name = map[int32]string{
		0: "BOOT_CONVERSION_UNSPECIFIED",
		1: "NONE",
		2: "BIOS_TO_EFI",
	}
	BootConversion_value = map[string]int32{
		"BOOT_CONVERSION_UNSPECIFIED": 0,
		"NONE":                        1,
		"BIOS_TO_EFI":                 2,
	}
)

func (x BootConversion) Enum() *BootConversion {
	p := new(BootConversion)
	*p = x
	return p
}

func (x BootConversion) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (BootConversion) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[4].Descriptor()
}

func (BootConversion) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[4]
}

func (x BootConversion) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use BootConversion.Descriptor instead.
func (BootConversion) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{4}
}

// Controls the level of details of a Utilization Report.
type UtilizationReportView int32

const (
	// The default / unset value.
	// The API will default to FULL on single report request and BASIC for
	// multiple reports request.
	UtilizationReportView_UTILIZATION_REPORT_VIEW_UNSPECIFIED UtilizationReportView = 0
	// Get the report metadata, without the list of VMs and their utilization
	// info.
	UtilizationReportView_BASIC UtilizationReportView = 1
	// Include everything.
	UtilizationReportView_FULL UtilizationReportView = 2
)

// Enum value maps for UtilizationReportView.
var (
	UtilizationReportView_name = map[int32]string{
		0: "UTILIZATION_REPORT_VIEW_UNSPECIFIED",
		1: "BASIC",
		2: "FULL",
	}
	UtilizationReportView_value = map[string]int32{
		"UTILIZATION_REPORT_VIEW_UNSPECIFIED": 0,
		"BASIC":                               1,
		"FULL":                                2,
	}
)

func (x UtilizationReportView) Enum() *UtilizationReportView {
	p := new(UtilizationReportView)
	*p = x
	return p
}

func (x UtilizationReportView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UtilizationReportView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[5].Descriptor()
}

func (UtilizationReportView) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[5]
}

func (x UtilizationReportView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UtilizationReportView.Descriptor instead.
func (UtilizationReportView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{5}
}

// Controls the level of details of a Migrating VM.
type MigratingVmView int32

const (
	// View is unspecified. The API will fallback to the default value.
	MigratingVmView_MIGRATING_VM_VIEW_UNSPECIFIED MigratingVmView = 0
	// Get the migrating VM basic details.
	// The basic details do not include the recent clone jobs and recent cutover
	// jobs lists.
	MigratingVmView_MIGRATING_VM_VIEW_BASIC MigratingVmView = 1
	// Include everything.
	MigratingVmView_MIGRATING_VM_VIEW_FULL MigratingVmView = 2
)

// Enum value maps for MigratingVmView.
var (
	MigratingVmView_name = map[int32]string{
		0: "MIGRATING_VM_VIEW_UNSPECIFIED",
		1: "MIGRATING_VM_VIEW_BASIC",
		2: "MIGRATING_VM_VIEW_FULL",
	}
	MigratingVmView_value = map[string]int32{
		"MIGRATING_VM_VIEW_UNSPECIFIED": 0,
		"MIGRATING_VM_VIEW_BASIC":       1,
		"MIGRATING_VM_VIEW_FULL":        2,
	}
)

func (x MigratingVmView) Enum() *MigratingVmView {
	p := new(MigratingVmView)
	*p = x
	return p
}

func (x MigratingVmView) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigratingVmView) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[6].Descriptor()
}

func (MigratingVmView) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[6]
}

func (x MigratingVmView) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigratingVmView.Descriptor instead.
func (MigratingVmView) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{6}
}

// Possible values for the VM architecture.
type VmArchitecture int32

const (
	// The architecture is unknown.
	VmArchitecture_VM_ARCHITECTURE_UNSPECIFIED VmArchitecture = 0
	// The architecture is one of the x86 architectures.
	VmArchitecture_VM_ARCHITECTURE_X86_FAMILY VmArchitecture = 1
	// The architecture is ARM64.
	VmArchitecture_VM_ARCHITECTURE_ARM64 VmArchitecture = 2
)

// Enum value maps for VmArchitecture.
var (
	VmArchitecture_name = map[int32]string{
		0: "VM_ARCHITECTURE_UNSPECIFIED",
		1: "VM_ARCHITECTURE_X86_FAMILY",
		2: "VM_ARCHITECTURE_ARM64",
	}
	VmArchitecture_value = map[string]int32{
		"VM_ARCHITECTURE_UNSPECIFIED": 0,
		"VM_ARCHITECTURE_X86_FAMILY":  1,
		"VM_ARCHITECTURE_ARM64":       2,
	}
)

func (x VmArchitecture) Enum() *VmArchitecture {
	p := new(VmArchitecture)
	*p = x
	return p
}

func (x VmArchitecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmArchitecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[7].Descriptor()
}

func (VmArchitecture) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[7]
}

func (x VmArchitecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmArchitecture.Descriptor instead.
func (VmArchitecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{7}
}

// Describes the networking tier used for configuring network access
// configuration.
type ComputeEngineNetworkTier int32

const (
	// An unspecified network tier. Will be used as PREMIUM.
	ComputeEngineNetworkTier_COMPUTE_ENGINE_NETWORK_TIER_UNSPECIFIED ComputeEngineNetworkTier = 0
	// A standard network tier.
	ComputeEngineNetworkTier_NETWORK_TIER_STANDARD ComputeEngineNetworkTier = 1
	// A premium network tier.
	ComputeEngineNetworkTier_NETWORK_TIER_PREMIUM ComputeEngineNetworkTier = 2
)

// Enum value maps for ComputeEngineNetworkTier.
var (
	ComputeEngineNetworkTier_name = map[int32]string{
		0: "COMPUTE_ENGINE_NETWORK_TIER_UNSPECIFIED",
		1: "NETWORK_TIER_STANDARD",
		2: "NETWORK_TIER_PREMIUM",
	}
	ComputeEngineNetworkTier_value = map[string]int32{
		"COMPUTE_ENGINE_NETWORK_TIER_UNSPECIFIED": 0,
		"NETWORK_TIER_STANDARD":                   1,
		"NETWORK_TIER_PREMIUM":                    2,
	}
)

func (x ComputeEngineNetworkTier) Enum() *ComputeEngineNetworkTier {
	p := new(ComputeEngineNetworkTier)
	*p = x
	return p
}

func (x ComputeEngineNetworkTier) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeEngineNetworkTier) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[8].Descriptor()
}

func (ComputeEngineNetworkTier) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[8]
}

func (x ComputeEngineNetworkTier) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeEngineNetworkTier.Descriptor instead.
func (ComputeEngineNetworkTier) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{8}
}

// Possible states of a replication cycle.
type ReplicationCycle_State int32

const (
	// The state is unknown. This is used for API compatibility only and is not
	// used by the system.
	ReplicationCycle_STATE_UNSPECIFIED ReplicationCycle_State = 0
	// The replication cycle is running.
	ReplicationCycle_RUNNING ReplicationCycle_State = 1
	// The replication cycle is paused.
	ReplicationCycle_PAUSED ReplicationCycle_State = 2
	// The replication cycle finished with errors.
	ReplicationCycle_FAILED ReplicationCycle_State = 3
	// The replication cycle finished successfully.
	ReplicationCycle_SUCCEEDED ReplicationCycle_State = 4
)

// Enum value maps for ReplicationCycle_State.
var (
	ReplicationCycle_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "PAUSED",
		3: "FAILED",
		4: "SUCCEEDED",
	}
	ReplicationCycle_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"PAUSED":            2,
		"FAILED":            3,
		"SUCCEEDED":         4,
	}
)

func (x ReplicationCycle_State) Enum() *ReplicationCycle_State {
	p := new(ReplicationCycle_State)
	*p = x
	return p
}

func (x ReplicationCycle_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ReplicationCycle_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[9].Descriptor()
}

func (ReplicationCycle_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[9]
}

func (x ReplicationCycle_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ReplicationCycle_State.Descriptor instead.
func (ReplicationCycle_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{0, 0}
}

// The possible values of the state/health of source VM.
type MigratingVm_State int32

const (
	// The state was not sampled by the health checks yet.
	MigratingVm_STATE_UNSPECIFIED MigratingVm_State = 0
	// The VM in the source is being verified.
	MigratingVm_PENDING MigratingVm_State = 1
	// The source VM was verified, and it's ready to start replication.
	MigratingVm_READY MigratingVm_State = 2
	// Migration is going through the first sync cycle.
	MigratingVm_FIRST_SYNC MigratingVm_State = 3
	// The replication is active, and it's running or scheduled to run.
	MigratingVm_ACTIVE MigratingVm_State = 4
	// The source VM is being turned off, and a final replication is currently
	// running.
	MigratingVm_CUTTING_OVER MigratingVm_State = 7
	// The source VM was stopped and replicated. The replication is currently
	// paused.
	MigratingVm_CUTOVER MigratingVm_State = 8
	// A cutover job is active and replication cycle is running the final sync.
	MigratingVm_FINAL_SYNC MigratingVm_State = 9
	// The replication was paused by the user and no cycles are scheduled to
	// run.
	MigratingVm_PAUSED MigratingVm_State = 10
	// The migrating VM is being finalized and migration resources are being
	// removed.
	MigratingVm_FINALIZING MigratingVm_State = 11
	// The replication process is done. The migrating VM is finalized and no
	// longer consumes billable resources.
	MigratingVm_FINALIZED MigratingVm_State = 12
	// The replication process encountered an unrecoverable error and was
	// aborted.
	MigratingVm_ERROR MigratingVm_State = 13
	// The migrating VM has passed its expiration date. It might be possible to
	// bring it back to "Active" state by updating the TTL field. For more
	// information, see the documentation.
	MigratingVm_EXPIRED MigratingVm_State = 14
	// The migrating VM's has been finalized and migration resources have been
	// removed.
	MigratingVm_FINALIZED_EXPIRED MigratingVm_State = 17
)

// Enum value maps for MigratingVm_State.
var (
	MigratingVm_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "PENDING",
		2:  "READY",
		3:  "FIRST_SYNC",
		4:  "ACTIVE",
		7:  "CUTTING_OVER",
		8:  "CUTOVER",
		9:  "FINAL_SYNC",
		10: "PAUSED",
		11: "FINALIZING",
		12: "FINALIZED",
		13: "ERROR",
		14: "EXPIRED",
		17: "FINALIZED_EXPIRED",
	}
	MigratingVm_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"READY":             2,
		"FIRST_SYNC":        3,
		"ACTIVE":            4,
		"CUTTING_OVER":      7,
		"CUTOVER":           8,
		"FINAL_SYNC":        9,
		"PAUSED":            10,
		"FINALIZING":        11,
		"FINALIZED":         12,
		"ERROR":             13,
		"EXPIRED":           14,
		"FINALIZED_EXPIRED": 17,
	}
)

func (x MigratingVm_State) Enum() *MigratingVm_State {
	p := new(MigratingVm_State)
	*p = x
	return p
}

func (x MigratingVm_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigratingVm_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[10].Descriptor()
}

func (MigratingVm_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[10]
}

func (x MigratingVm_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigratingVm_State.Descriptor instead.
func (MigratingVm_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{6, 0}
}

// Possible states of the clone job.
type CloneJob_State int32

const (
	// The state is unknown. This is used for API compatibility only and is not
	// used by the system.
	CloneJob_STATE_UNSPECIFIED CloneJob_State = 0
	// The clone job has not yet started.
	CloneJob_PENDING CloneJob_State = 1
	// The clone job is active and running.
	CloneJob_ACTIVE CloneJob_State = 2
	// The clone job finished with errors.
	CloneJob_FAILED CloneJob_State = 3
	// The clone job finished successfully.
	CloneJob_SUCCEEDED CloneJob_State = 4
	// The clone job was cancelled.
	CloneJob_CANCELLED CloneJob_State = 5
	// The clone job is being cancelled.
	CloneJob_CANCELLING CloneJob_State = 6
	// OS adaptation is running as part of the clone job to generate license.
	CloneJob_ADAPTING_OS CloneJob_State = 7
)

// Enum value maps for CloneJob_State.
var (
	CloneJob_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "ACTIVE",
		3: "FAILED",
		4: "SUCCEEDED",
		5: "CANCELLED",
		6: "CANCELLING",
		7: "ADAPTING_OS",
	}
	CloneJob_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"ACTIVE":            2,
		"FAILED":            3,
		"SUCCEEDED":         4,
		"CANCELLED":         5,
		"CANCELLING":        6,
		"ADAPTING_OS":       7,
	}
)

func (x CloneJob_State) Enum() *CloneJob_State {
	p := new(CloneJob_State)
	*p = x
	return p
}

func (x CloneJob_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CloneJob_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[11].Descriptor()
}

func (CloneJob_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[11]
}

func (x CloneJob_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CloneJob_State.Descriptor instead.
func (CloneJob_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{8, 0}
}

// Possible states of the cutover job.
type CutoverJob_State int32

const (
	// The state is unknown. This is used for API compatibility only and is not
	// used by the system.
	CutoverJob_STATE_UNSPECIFIED CutoverJob_State = 0
	// The cutover job has not yet started.
	CutoverJob_PENDING CutoverJob_State = 1
	// The cutover job finished with errors.
	CutoverJob_FAILED CutoverJob_State = 2
	// The cutover job finished successfully.
	CutoverJob_SUCCEEDED CutoverJob_State = 3
	// The cutover job was cancelled.
	CutoverJob_CANCELLED CutoverJob_State = 4
	// The cutover job is being cancelled.
	CutoverJob_CANCELLING CutoverJob_State = 5
	// The cutover job is active and running.
	CutoverJob_ACTIVE CutoverJob_State = 6
	// OS adaptation is running as part of the cutover job to generate license.
	CutoverJob_ADAPTING_OS CutoverJob_State = 7
)

// Enum value maps for CutoverJob_State.
var (
	CutoverJob_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "FAILED",
		3: "SUCCEEDED",
		4: "CANCELLED",
		5: "CANCELLING",
		6: "ACTIVE",
		7: "ADAPTING_OS",
	}
	CutoverJob_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"FAILED":            2,
		"SUCCEEDED":         3,
		"CANCELLED":         4,
		"CANCELLING":        5,
		"ACTIVE":            6,
		"ADAPTING_OS":       7,
	}
)

func (x CutoverJob_State) Enum() *CutoverJob_State {
	p := new(CutoverJob_State)
	*p = x
	return p
}

func (x CutoverJob_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (CutoverJob_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[12].Descriptor()
}

func (CutoverJob_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[12]
}

func (x CutoverJob_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use CutoverJob_State.Descriptor instead.
func (CutoverJob_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{13, 0}
}

// The possible values of the state.
type AwsSourceDetails_State int32

const (
	// The state is unknown. This is used for API compatibility only and is not
	// used by the system.
	AwsSourceDetails_STATE_UNSPECIFIED AwsSourceDetails_State = 0
	// The state was not sampled by the health checks yet.
	AwsSourceDetails_PENDING AwsSourceDetails_State = 1
	// The source is available but might not be usable yet due to invalid
	// credentials or another reason.
	// The error message will contain further details.
	AwsSourceDetails_FAILED AwsSourceDetails_State = 2
	// The source exists and its credentials were verified.
	AwsSourceDetails_ACTIVE AwsSourceDetails_State = 3
)

// Enum value maps for AwsSourceDetails_State.
var (
	AwsSourceDetails_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "FAILED",
		3: "ACTIVE",
	}
	AwsSourceDetails_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"FAILED":            2,
		"ACTIVE":            3,
	}
)

func (x AwsSourceDetails_State) Enum() *AwsSourceDetails_State {
	p := new(AwsSourceDetails_State)
	*p = x
	return p
}

func (x AwsSourceDetails_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsSourceDetails_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[13].Descriptor()
}

func (AwsSourceDetails_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[13]
}

func (x AwsSourceDetails_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsSourceDetails_State.Descriptor instead.
func (AwsSourceDetails_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{25, 0}
}

// The possible values of the state.
type AzureSourceDetails_State int32

const (
	// The state is unknown. This is used for API compatibility only and is not
	// used by the system.
	AzureSourceDetails_STATE_UNSPECIFIED AzureSourceDetails_State = 0
	// The state was not sampled by the health checks yet.
	AzureSourceDetails_PENDING AzureSourceDetails_State = 1
	// The source is available but might not be usable yet due to invalid
	// credentials or another reason.
	// The error message will contain further details.
	AzureSourceDetails_FAILED AzureSourceDetails_State = 2
	// The source exists and its credentials were verified.
	AzureSourceDetails_ACTIVE AzureSourceDetails_State = 3
)

// Enum value maps for AzureSourceDetails_State.
var (
	AzureSourceDetails_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "FAILED",
		3: "ACTIVE",
	}
	AzureSourceDetails_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"FAILED":            2,
		"ACTIVE":            3,
	}
)

func (x AzureSourceDetails_State) Enum() *AzureSourceDetails_State {
	p := new(AzureSourceDetails_State)
	*p = x
	return p
}

func (x AzureSourceDetails_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AzureSourceDetails_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[14].Descriptor()
}

func (AzureSourceDetails_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[14]
}

func (x AzureSourceDetails_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AzureSourceDetails_State.Descriptor instead.
func (AzureSourceDetails_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{26, 0}
}

// The possible values of the state.
type DatacenterConnector_State int32

const (
	// The state is unknown. This is used for API compatibility only and is not
	// used by the system.
	DatacenterConnector_STATE_UNSPECIFIED DatacenterConnector_State = 0
	// The state was not sampled by the health checks yet.
	DatacenterConnector_PENDING DatacenterConnector_State = 1
	// The source was sampled by health checks and is not available.
	DatacenterConnector_OFFLINE DatacenterConnector_State = 2
	// The source is available but might not be usable yet due to unvalidated
	// credentials or another reason. The credentials referred to are the ones
	// to the Source. The error message will contain further details.
	DatacenterConnector_FAILED DatacenterConnector_State = 3
	// The source exists and its credentials were verified.
	DatacenterConnector_ACTIVE DatacenterConnector_State = 4
)

// Enum value maps for DatacenterConnector_State.
var (
	DatacenterConnector_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "OFFLINE",
		3: "FAILED",
		4: "ACTIVE",
	}
	DatacenterConnector_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"OFFLINE":           2,
		"FAILED":            3,
		"ACTIVE":            4,
	}
)

func (x DatacenterConnector_State) Enum() *DatacenterConnector_State {
	p := new(DatacenterConnector_State)
	*p = x
	return p
}

func (x DatacenterConnector_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DatacenterConnector_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[15].Descriptor()
}

func (DatacenterConnector_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[15]
}

func (x DatacenterConnector_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DatacenterConnector_State.Descriptor instead.
func (DatacenterConnector_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{27, 0}
}

// The possible values of the state.
type UpgradeStatus_State int32

const (
	// The state was not sampled by the health checks yet.
	UpgradeStatus_STATE_UNSPECIFIED UpgradeStatus_State = 0
	// The upgrade has started.
	UpgradeStatus_RUNNING UpgradeStatus_State = 1
	// The upgrade failed.
	UpgradeStatus_FAILED UpgradeStatus_State = 2
	// The upgrade finished successfully.
	UpgradeStatus_SUCCEEDED UpgradeStatus_State = 3
)

// Enum value maps for UpgradeStatus_State.
var (
	UpgradeStatus_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "RUNNING",
		2: "FAILED",
		3: "SUCCEEDED",
	}
	UpgradeStatus_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"RUNNING":           1,
		"FAILED":            2,
		"SUCCEEDED":         3,
	}
)

func (x UpgradeStatus_State) Enum() *UpgradeStatus_State {
	p := new(UpgradeStatus_State)
	*p = x
	return p
}

func (x UpgradeStatus_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UpgradeStatus_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[16].Descriptor()
}

func (UpgradeStatus_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[16]
}

func (x UpgradeStatus_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UpgradeStatus_State.Descriptor instead.
func (UpgradeStatus_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{28, 0}
}

// Possible values for the power state of the VM.
type VmwareVmDetails_PowerState int32

const (
	// Power state is not specified.
	VmwareVmDetails_POWER_STATE_UNSPECIFIED VmwareVmDetails_PowerState = 0
	// The VM is turned ON.
	VmwareVmDetails_ON VmwareVmDetails_PowerState = 1
	// The VM is turned OFF.
	VmwareVmDetails_OFF VmwareVmDetails_PowerState = 2
	// The VM is suspended. This is similar to hibernation or sleep mode.
	VmwareVmDetails_SUSPENDED VmwareVmDetails_PowerState = 3
)

// Enum value maps for VmwareVmDetails_PowerState.
var (
	VmwareVmDetails_PowerState_name = map[int32]string{
		0: "POWER_STATE_UNSPECIFIED",
		1: "ON",
		2: "OFF",
		3: "SUSPENDED",
	}
	VmwareVmDetails_PowerState_value = map[string]int32{
		"POWER_STATE_UNSPECIFIED": 0,
		"ON":                      1,
		"OFF":                     2,
		"SUSPENDED":               3,
	}
)

func (x VmwareVmDetails_PowerState) Enum() *VmwareVmDetails_PowerState {
	p := new(VmwareVmDetails_PowerState)
	*p = x
	return p
}

func (x VmwareVmDetails_PowerState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareVmDetails_PowerState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[17].Descriptor()
}

func (VmwareVmDetails_PowerState) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[17]
}

func (x VmwareVmDetails_PowerState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareVmDetails_PowerState.Descriptor instead.
func (VmwareVmDetails_PowerState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{38, 0}
}

// Possible values for vm boot option.
type VmwareVmDetails_BootOption int32

const (
	// The boot option is unknown.
	VmwareVmDetails_BOOT_OPTION_UNSPECIFIED VmwareVmDetails_BootOption = 0
	// The boot option is EFI.
	VmwareVmDetails_EFI VmwareVmDetails_BootOption = 1
	// The boot option is BIOS.
	VmwareVmDetails_BIOS VmwareVmDetails_BootOption = 2
)

// Enum value maps for VmwareVmDetails_BootOption.
var (
	VmwareVmDetails_BootOption_name = map[int32]string{
		0: "BOOT_OPTION_UNSPECIFIED",
		1: "EFI",
		2: "BIOS",
	}
	VmwareVmDetails_BootOption_value = map[string]int32{
		"BOOT_OPTION_UNSPECIFIED": 0,
		"EFI":                     1,
		"BIOS":                    2,
	}
)

func (x VmwareVmDetails_BootOption) Enum() *VmwareVmDetails_BootOption {
	p := new(VmwareVmDetails_BootOption)
	*p = x
	return p
}

func (x VmwareVmDetails_BootOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareVmDetails_BootOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[18].Descriptor()
}

func (VmwareVmDetails_BootOption) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[18]
}

func (x VmwareVmDetails_BootOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareVmDetails_BootOption.Descriptor instead.
func (VmwareVmDetails_BootOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{38, 1}
}

// Possible values for the VM architecture.
type VmwareVmDetails_VmArchitecture int32

const (
	// The architecture is unknown.
	VmwareVmDetails_VM_ARCHITECTURE_UNSPECIFIED VmwareVmDetails_VmArchitecture = 0
	// The architecture is one of the x86 architectures.
	VmwareVmDetails_VM_ARCHITECTURE_X86_FAMILY VmwareVmDetails_VmArchitecture = 1
	// The architecture is ARM64.
	VmwareVmDetails_VM_ARCHITECTURE_ARM64 VmwareVmDetails_VmArchitecture = 2
)

// Enum value maps for VmwareVmDetails_VmArchitecture.
var (
	VmwareVmDetails_VmArchitecture_name = map[int32]string{
		0: "VM_ARCHITECTURE_UNSPECIFIED",
		1: "VM_ARCHITECTURE_X86_FAMILY",
		2: "VM_ARCHITECTURE_ARM64",
	}
	VmwareVmDetails_VmArchitecture_value = map[string]int32{
		"VM_ARCHITECTURE_UNSPECIFIED": 0,
		"VM_ARCHITECTURE_X86_FAMILY":  1,
		"VM_ARCHITECTURE_ARM64":       2,
	}
)

func (x VmwareVmDetails_VmArchitecture) Enum() *VmwareVmDetails_VmArchitecture {
	p := new(VmwareVmDetails_VmArchitecture)
	*p = x
	return p
}

func (x VmwareVmDetails_VmArchitecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareVmDetails_VmArchitecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[19].Descriptor()
}

func (VmwareVmDetails_VmArchitecture) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[19]
}

func (x VmwareVmDetails_VmArchitecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareVmDetails_VmArchitecture.Descriptor instead.
func (VmwareVmDetails_VmArchitecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{38, 2}
}

// Possible values for the power state of the VM.
type AwsVmDetails_PowerState int32

const (
	// Power state is not specified.
	AwsVmDetails_POWER_STATE_UNSPECIFIED AwsVmDetails_PowerState = 0
	// The VM is turned on.
	AwsVmDetails_ON AwsVmDetails_PowerState = 1
	// The VM is turned off.
	AwsVmDetails_OFF AwsVmDetails_PowerState = 2
	// The VM is suspended. This is similar to hibernation or sleep
	// mode.
	AwsVmDetails_SUSPENDED AwsVmDetails_PowerState = 3
	// The VM is starting.
	AwsVmDetails_PENDING AwsVmDetails_PowerState = 4
)

// Enum value maps for AwsVmDetails_PowerState.
var (
	AwsVmDetails_PowerState_name = map[int32]string{
		0: "POWER_STATE_UNSPECIFIED",
		1: "ON",
		2: "OFF",
		3: "SUSPENDED",
		4: "PENDING",
	}
	AwsVmDetails_PowerState_value = map[string]int32{
		"POWER_STATE_UNSPECIFIED": 0,
		"ON":                      1,
		"OFF":                     2,
		"SUSPENDED":               3,
		"PENDING":                 4,
	}
)

func (x AwsVmDetails_PowerState) Enum() *AwsVmDetails_PowerState {
	p := new(AwsVmDetails_PowerState)
	*p = x
	return p
}

func (x AwsVmDetails_PowerState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsVmDetails_PowerState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[20].Descriptor()
}

func (AwsVmDetails_PowerState) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[20]
}

func (x AwsVmDetails_PowerState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsVmDetails_PowerState.Descriptor instead.
func (AwsVmDetails_PowerState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{39, 0}
}

// The possible values for the vm boot option.
type AwsVmDetails_BootOption int32

const (
	// The boot option is unknown.
	AwsVmDetails_BOOT_OPTION_UNSPECIFIED AwsVmDetails_BootOption = 0
	// The boot option is UEFI.
	AwsVmDetails_EFI AwsVmDetails_BootOption = 1
	// The boot option is LEGACY-BIOS.
	AwsVmDetails_BIOS AwsVmDetails_BootOption = 2
)

// Enum value maps for AwsVmDetails_BootOption.
var (
	AwsVmDetails_BootOption_name = map[int32]string{
		0: "BOOT_OPTION_UNSPECIFIED",
		1: "EFI",
		2: "BIOS",
	}
	AwsVmDetails_BootOption_value = map[string]int32{
		"BOOT_OPTION_UNSPECIFIED": 0,
		"EFI":                     1,
		"BIOS":                    2,
	}
)

func (x AwsVmDetails_BootOption) Enum() *AwsVmDetails_BootOption {
	p := new(AwsVmDetails_BootOption)
	*p = x
	return p
}

func (x AwsVmDetails_BootOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsVmDetails_BootOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[21].Descriptor()
}

func (AwsVmDetails_BootOption) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[21]
}

func (x AwsVmDetails_BootOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsVmDetails_BootOption.Descriptor instead.
func (AwsVmDetails_BootOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{39, 1}
}

// Possible values for the virtualization types of the VM.
type AwsVmDetails_VmVirtualizationType int32

const (
	// The virtualization type is unknown.
	AwsVmDetails_VM_VIRTUALIZATION_TYPE_UNSPECIFIED AwsVmDetails_VmVirtualizationType = 0
	// The virtualziation type is HVM.
	AwsVmDetails_HVM AwsVmDetails_VmVirtualizationType = 1
	// The virtualziation type is PARAVIRTUAL.
	AwsVmDetails_PARAVIRTUAL AwsVmDetails_VmVirtualizationType = 2
)

// Enum value maps for AwsVmDetails_VmVirtualizationType.
var (
	AwsVmDetails_VmVirtualizationType_name = map[int32]string{
		0: "VM_VIRTUALIZATION_TYPE_UNSPECIFIED",
		1: "HVM",
		2: "PARAVIRTUAL",
	}
	AwsVmDetails_VmVirtualizationType_value = map[string]int32{
		"VM_VIRTUALIZATION_TYPE_UNSPECIFIED": 0,
		"HVM":                                1,
		"PARAVIRTUAL":                        2,
	}
)

func (x AwsVmDetails_VmVirtualizationType) Enum() *AwsVmDetails_VmVirtualizationType {
	p := new(AwsVmDetails_VmVirtualizationType)
	*p = x
	return p
}

func (x AwsVmDetails_VmVirtualizationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsVmDetails_VmVirtualizationType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[22].Descriptor()
}

func (AwsVmDetails_VmVirtualizationType) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[22]
}

func (x AwsVmDetails_VmVirtualizationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsVmDetails_VmVirtualizationType.Descriptor instead.
func (AwsVmDetails_VmVirtualizationType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{39, 2}
}

// Possible values for the architectures of the VM.
type AwsVmDetails_VmArchitecture int32

const (
	// The architecture is unknown.
	AwsVmDetails_VM_ARCHITECTURE_UNSPECIFIED AwsVmDetails_VmArchitecture = 0
	// The architecture is I386.
	AwsVmDetails_I386 AwsVmDetails_VmArchitecture = 1
	// The architecture is X86_64.
	AwsVmDetails_X86_64 AwsVmDetails_VmArchitecture = 2
	// The architecture is ARM64.
	AwsVmDetails_ARM64 AwsVmDetails_VmArchitecture = 3
	// The architecture is X86_64_MAC.
	AwsVmDetails_X86_64_MAC AwsVmDetails_VmArchitecture = 4
)

// Enum value maps for AwsVmDetails_VmArchitecture.
var (
	AwsVmDetails_VmArchitecture_name = map[int32]string{
		0: "VM_ARCHITECTURE_UNSPECIFIED",
		1: "I386",
		2: "X86_64",
		3: "ARM64",
		4: "X86_64_MAC",
	}
	AwsVmDetails_VmArchitecture_value = map[string]int32{
		"VM_ARCHITECTURE_UNSPECIFIED": 0,
		"I386":                        1,
		"X86_64":                      2,
		"ARM64":                       3,
		"X86_64_MAC":                  4,
	}
)

func (x AwsVmDetails_VmArchitecture) Enum() *AwsVmDetails_VmArchitecture {
	p := new(AwsVmDetails_VmArchitecture)
	*p = x
	return p
}

func (x AwsVmDetails_VmArchitecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsVmDetails_VmArchitecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[23].Descriptor()
}

func (AwsVmDetails_VmArchitecture) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[23]
}

func (x AwsVmDetails_VmArchitecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsVmDetails_VmArchitecture.Descriptor instead.
func (AwsVmDetails_VmArchitecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{39, 3}
}

// Possible values for the power state of the VM.
type AzureVmDetails_PowerState int32

const (
	// Power state is not specified.
	AzureVmDetails_POWER_STATE_UNSPECIFIED AzureVmDetails_PowerState = 0
	// The VM is starting.
	AzureVmDetails_STARTING AzureVmDetails_PowerState = 1
	// The VM is running.
	AzureVmDetails_RUNNING AzureVmDetails_PowerState = 2
	// The VM is stopping.
	AzureVmDetails_STOPPING AzureVmDetails_PowerState = 3
	// The VM is stopped.
	AzureVmDetails_STOPPED AzureVmDetails_PowerState = 4
	// The VM is deallocating.
	AzureVmDetails_DEALLOCATING AzureVmDetails_PowerState = 5
	// The VM is deallocated.
	AzureVmDetails_DEALLOCATED AzureVmDetails_PowerState = 6
	// The VM's power state is unknown.
	AzureVmDetails_UNKNOWN AzureVmDetails_PowerState = 7
)

// Enum value maps for AzureVmDetails_PowerState.
var (
	AzureVmDetails_PowerState_name = map[int32]string{
		0: "POWER_STATE_UNSPECIFIED",
		1: "STARTING",
		2: "RUNNING",
		3: "STOPPING",
		4: "STOPPED",
		5: "DEALLOCATING",
		6: "DEALLOCATED",
		7: "UNKNOWN",
	}
	AzureVmDetails_PowerState_value = map[string]int32{
		"POWER_STATE_UNSPECIFIED": 0,
		"STARTING":                1,
		"RUNNING":                 2,
		"STOPPING":                3,
		"STOPPED":                 4,
		"DEALLOCATING":            5,
		"DEALLOCATED":             6,
		"UNKNOWN":                 7,
	}
)

func (x AzureVmDetails_PowerState) Enum() *AzureVmDetails_PowerState {
	p := new(AzureVmDetails_PowerState)
	*p = x
	return p
}

func (x AzureVmDetails_PowerState) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AzureVmDetails_PowerState) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[24].Descriptor()
}

func (AzureVmDetails_PowerState) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[24]
}

func (x AzureVmDetails_PowerState) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AzureVmDetails_PowerState.Descriptor instead.
func (AzureVmDetails_PowerState) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{41, 0}
}

// The possible values for the vm boot option.
type AzureVmDetails_BootOption int32

const (
	// The boot option is unknown.
	AzureVmDetails_BOOT_OPTION_UNSPECIFIED AzureVmDetails_BootOption = 0
	// The boot option is UEFI.
	AzureVmDetails_EFI AzureVmDetails_BootOption = 1
	// The boot option is BIOS.
	AzureVmDetails_BIOS AzureVmDetails_BootOption = 2
)

// Enum value maps for AzureVmDetails_BootOption.
var (
	AzureVmDetails_BootOption_name = map[int32]string{
		0: "BOOT_OPTION_UNSPECIFIED",
		1: "EFI",
		2: "BIOS",
	}
	AzureVmDetails_BootOption_value = map[string]int32{
		"BOOT_OPTION_UNSPECIFIED": 0,
		"EFI":                     1,
		"BIOS":                    2,
	}
)

func (x AzureVmDetails_BootOption) Enum() *AzureVmDetails_BootOption {
	p := new(AzureVmDetails_BootOption)
	*p = x
	return p
}

func (x AzureVmDetails_BootOption) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AzureVmDetails_BootOption) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[25].Descriptor()
}

func (AzureVmDetails_BootOption) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[25]
}

func (x AzureVmDetails_BootOption) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AzureVmDetails_BootOption.Descriptor instead.
func (AzureVmDetails_BootOption) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{41, 1}
}

// Possible values for the VM architecture.
type AzureVmDetails_VmArchitecture int32

const (
	// The architecture is unknown.
	AzureVmDetails_VM_ARCHITECTURE_UNSPECIFIED AzureVmDetails_VmArchitecture = 0
	// The architecture is one of the x86 architectures.
	AzureVmDetails_VM_ARCHITECTURE_X86_FAMILY AzureVmDetails_VmArchitecture = 1
	// The architecture is ARM64.
	AzureVmDetails_VM_ARCHITECTURE_ARM64 AzureVmDetails_VmArchitecture = 2
)

// Enum value maps for AzureVmDetails_VmArchitecture.
var (
	AzureVmDetails_VmArchitecture_name = map[int32]string{
		0: "VM_ARCHITECTURE_UNSPECIFIED",
		1: "VM_ARCHITECTURE_X86_FAMILY",
		2: "VM_ARCHITECTURE_ARM64",
	}
	AzureVmDetails_VmArchitecture_value = map[string]int32{
		"VM_ARCHITECTURE_UNSPECIFIED": 0,
		"VM_ARCHITECTURE_X86_FAMILY":  1,
		"VM_ARCHITECTURE_ARM64":       2,
	}
)

func (x AzureVmDetails_VmArchitecture) Enum() *AzureVmDetails_VmArchitecture {
	p := new(AzureVmDetails_VmArchitecture)
	*p = x
	return p
}

func (x AzureVmDetails_VmArchitecture) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AzureVmDetails_VmArchitecture) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[26].Descriptor()
}

func (AzureVmDetails_VmArchitecture) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[26]
}

func (x AzureVmDetails_VmArchitecture) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AzureVmDetails_VmArchitecture.Descriptor instead.
func (AzureVmDetails_VmArchitecture) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{41, 2}
}

// The type of the storage inventory to fetch.
type FetchStorageInventoryRequest_StorageType int32

const (
	// The type is unspecified.
	FetchStorageInventoryRequest_STORAGE_TYPE_UNSPECIFIED FetchStorageInventoryRequest_StorageType = 0
	// The type is disks.
	FetchStorageInventoryRequest_DISKS FetchStorageInventoryRequest_StorageType = 1
	// The type is snapshots.
	FetchStorageInventoryRequest_SNAPSHOTS FetchStorageInventoryRequest_StorageType = 2
)

// Enum value maps for FetchStorageInventoryRequest_StorageType.
var (
	FetchStorageInventoryRequest_StorageType_name = map[int32]string{
		0: "STORAGE_TYPE_UNSPECIFIED",
		1: "DISKS",
		2: "SNAPSHOTS",
	}
	FetchStorageInventoryRequest_StorageType_value = map[string]int32{
		"STORAGE_TYPE_UNSPECIFIED": 0,
		"DISKS":                    1,
		"SNAPSHOTS":                2,
	}
)

func (x FetchStorageInventoryRequest_StorageType) Enum() *FetchStorageInventoryRequest_StorageType {
	p := new(FetchStorageInventoryRequest_StorageType)
	*p = x
	return p
}

func (x FetchStorageInventoryRequest_StorageType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FetchStorageInventoryRequest_StorageType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[27].Descriptor()
}

func (FetchStorageInventoryRequest_StorageType) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[27]
}

func (x FetchStorageInventoryRequest_StorageType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FetchStorageInventoryRequest_StorageType.Descriptor instead.
func (FetchStorageInventoryRequest_StorageType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{46, 0}
}

// Utilization report state.
type UtilizationReport_State int32

const (
	// The state is unknown. This value is not in use.
	UtilizationReport_STATE_UNSPECIFIED UtilizationReport_State = 0
	// The report is in the making.
	UtilizationReport_CREATING UtilizationReport_State = 1
	// Report creation completed successfully.
	UtilizationReport_SUCCEEDED UtilizationReport_State = 2
	// Report creation failed.
	UtilizationReport_FAILED UtilizationReport_State = 3
)

// Enum value maps for UtilizationReport_State.
var (
	UtilizationReport_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "SUCCEEDED",
		3: "FAILED",
	}
	UtilizationReport_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"SUCCEEDED":         2,
		"FAILED":            3,
	}
)

func (x UtilizationReport_State) Enum() *UtilizationReport_State {
	p := new(UtilizationReport_State)
	*p = x
	return p
}

func (x UtilizationReport_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UtilizationReport_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[28].Descriptor()
}

func (UtilizationReport_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[28]
}

func (x UtilizationReport_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UtilizationReport_State.Descriptor instead.
func (UtilizationReport_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{49, 0}
}

// Report time frame options.
type UtilizationReport_TimeFrame int32

const (
	// The time frame was not specified and will default to WEEK.
	UtilizationReport_TIME_FRAME_UNSPECIFIED UtilizationReport_TimeFrame = 0
	// One week.
	UtilizationReport_WEEK UtilizationReport_TimeFrame = 1
	// One month.
	UtilizationReport_MONTH UtilizationReport_TimeFrame = 2
	// One year.
	UtilizationReport_YEAR UtilizationReport_TimeFrame = 3
)

// Enum value maps for UtilizationReport_TimeFrame.
var (
	UtilizationReport_TimeFrame_name = map[int32]string{
		0: "TIME_FRAME_UNSPECIFIED",
		1: "WEEK",
		2: "MONTH",
		3: "YEAR",
	}
	UtilizationReport_TimeFrame_value = map[string]int32{
		"TIME_FRAME_UNSPECIFIED": 0,
		"WEEK":                   1,
		"MONTH":                  2,
		"YEAR":                   3,
	}
)

func (x UtilizationReport_TimeFrame) Enum() *UtilizationReport_TimeFrame {
	p := new(UtilizationReport_TimeFrame)
	*p = x
	return p
}

func (x UtilizationReport_TimeFrame) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (UtilizationReport_TimeFrame) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[29].Descriptor()
}

func (UtilizationReport_TimeFrame) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[29]
}

func (x UtilizationReport_TimeFrame) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use UtilizationReport_TimeFrame.Descriptor instead.
func (UtilizationReport_TimeFrame) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{49, 1}
}

// License types used in OS adaptation.
type AppliedLicense_Type int32

const (
	// Unspecified license for the OS.
	AppliedLicense_TYPE_UNSPECIFIED AppliedLicense_Type = 0
	// No license available for the OS.
	AppliedLicense_NONE AppliedLicense_Type = 1
	// The license type is Pay As You Go license type.
	AppliedLicense_PAYG AppliedLicense_Type = 2
	// The license type is Bring Your Own License type.
	AppliedLicense_BYOL AppliedLicense_Type = 3
)

// Enum value maps for AppliedLicense_Type.
var (
	AppliedLicense_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "NONE",
		2: "PAYG",
		3: "BYOL",
	}
	AppliedLicense_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"NONE":             1,
		"PAYG":             2,
		"BYOL":             3,
	}
)

func (x AppliedLicense_Type) Enum() *AppliedLicense_Type {
	p := new(AppliedLicense_Type)
	*p = x
	return p
}

func (x AppliedLicense_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AppliedLicense_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[30].Descriptor()
}

func (AppliedLicense_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[30]
}

func (x AppliedLicense_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AppliedLicense_Type.Descriptor instead.
func (AppliedLicense_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{67, 0}
}

// Possible types of node selection operators. Valid operators are IN for
// affinity and NOT_IN for anti-affinity.
type SchedulingNodeAffinity_Operator int32

const (
	// An unknown, unexpected behavior.
	SchedulingNodeAffinity_OPERATOR_UNSPECIFIED SchedulingNodeAffinity_Operator = 0
	// The node resource group should be in these resources affinity.
	SchedulingNodeAffinity_IN SchedulingNodeAffinity_Operator = 1
	// The node resource group should not be in these resources affinity.
	SchedulingNodeAffinity_NOT_IN SchedulingNodeAffinity_Operator = 2
)

// Enum value maps for SchedulingNodeAffinity_Operator.
var (
	SchedulingNodeAffinity_Operator_name = map[int32]string{
		0: "OPERATOR_UNSPECIFIED",
		1: "IN",
		2: "NOT_IN",
	}
	SchedulingNodeAffinity_Operator_value = map[string]int32{
		"OPERATOR_UNSPECIFIED": 0,
		"IN":                   1,
		"NOT_IN":               2,
	}
)

func (x SchedulingNodeAffinity_Operator) Enum() *SchedulingNodeAffinity_Operator {
	p := new(SchedulingNodeAffinity_Operator)
	*p = x
	return p
}

func (x SchedulingNodeAffinity_Operator) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SchedulingNodeAffinity_Operator) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[31].Descriptor()
}

func (SchedulingNodeAffinity_Operator) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[31]
}

func (x SchedulingNodeAffinity_Operator) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SchedulingNodeAffinity_Operator.Descriptor instead.
func (SchedulingNodeAffinity_Operator) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{68, 0}
}

type ComputeScheduling_OnHostMaintenance int32

const (
	// An unknown, unexpected behavior.
	ComputeScheduling_ON_HOST_MAINTENANCE_UNSPECIFIED ComputeScheduling_OnHostMaintenance = 0
	// Terminate the instance when the host machine undergoes maintenance.
	ComputeScheduling_TERMINATE ComputeScheduling_OnHostMaintenance = 1
	// Migrate the instance when the host machine undergoes maintenance.
	ComputeScheduling_MIGRATE ComputeScheduling_OnHostMaintenance = 2
)

// Enum value maps for ComputeScheduling_OnHostMaintenance.
var (
	ComputeScheduling_OnHostMaintenance_name = map[int32]string{
		0: "ON_HOST_MAINTENANCE_UNSPECIFIED",
		1: "TERMINATE",
		2: "MIGRATE",
	}
	ComputeScheduling_OnHostMaintenance_value = map[string]int32{
		"ON_HOST_MAINTENANCE_UNSPECIFIED": 0,
		"TERMINATE":                       1,
		"MIGRATE":                         2,
	}
)

func (x ComputeScheduling_OnHostMaintenance) Enum() *ComputeScheduling_OnHostMaintenance {
	p := new(ComputeScheduling_OnHostMaintenance)
	*p = x
	return p
}

func (x ComputeScheduling_OnHostMaintenance) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeScheduling_OnHostMaintenance) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[32].Descriptor()
}

func (ComputeScheduling_OnHostMaintenance) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[32]
}

func (x ComputeScheduling_OnHostMaintenance) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeScheduling_OnHostMaintenance.Descriptor instead.
func (ComputeScheduling_OnHostMaintenance) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{69, 0}
}

// Defines whether the Instance should be automatically restarted whenever
// it is terminated by Compute Engine (not terminated by user).
type ComputeScheduling_RestartType int32

const (
	// Unspecified behavior. This will use the default.
	ComputeScheduling_RESTART_TYPE_UNSPECIFIED ComputeScheduling_RestartType = 0
	// The Instance should be automatically restarted whenever it is
	// terminated by Compute Engine.
	ComputeScheduling_AUTOMATIC_RESTART ComputeScheduling_RestartType = 1
	// The Instance isn't automatically restarted whenever it is
	// terminated by Compute Engine.
	ComputeScheduling_NO_AUTOMATIC_RESTART ComputeScheduling_RestartType = 2
)

// Enum value maps for ComputeScheduling_RestartType.
var (
	ComputeScheduling_RestartType_name = map[int32]string{
		0: "RESTART_TYPE_UNSPECIFIED",
		1: "AUTOMATIC_RESTART",
		2: "NO_AUTOMATIC_RESTART",
	}
	ComputeScheduling_RestartType_value = map[string]int32{
		"RESTART_TYPE_UNSPECIFIED": 0,
		"AUTOMATIC_RESTART":        1,
		"NO_AUTOMATIC_RESTART":     2,
	}
)

func (x ComputeScheduling_RestartType) Enum() *ComputeScheduling_RestartType {
	p := new(ComputeScheduling_RestartType)
	*p = x
	return p
}

func (x ComputeScheduling_RestartType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ComputeScheduling_RestartType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[33].Descriptor()
}

func (ComputeScheduling_RestartType) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[33]
}

func (x ComputeScheduling_RestartType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ComputeScheduling_RestartType.Descriptor instead.
func (ComputeScheduling_RestartType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{69, 1}
}

// The possible types of the group.
type Group_MigrationTargetType int32

const (
	// Group type is not specified. This defaults to Compute Engine targets.
	Group_MIGRATION_TARGET_TYPE_UNSPECIFIED Group_MigrationTargetType = 0
	// All MigratingVMs in the group must have Compute Engine targets.
	Group_MIGRATION_TARGET_TYPE_GCE Group_MigrationTargetType = 1
	// All MigratingVMs in the group must have Compute Engine Disks targets.
	Group_MIGRATION_TARGET_TYPE_DISKS Group_MigrationTargetType = 2
)

// Enum value maps for Group_MigrationTargetType.
var (
	Group_MigrationTargetType_name = map[int32]string{
		0: "MIGRATION_TARGET_TYPE_UNSPECIFIED",
		1: "MIGRATION_TARGET_TYPE_GCE",
		2: "MIGRATION_TARGET_TYPE_DISKS",
	}
	Group_MigrationTargetType_value = map[string]int32{
		"MIGRATION_TARGET_TYPE_UNSPECIFIED": 0,
		"MIGRATION_TARGET_TYPE_GCE":         1,
		"MIGRATION_TARGET_TYPE_DISKS":       2,
	}
)

func (x Group_MigrationTargetType) Enum() *Group_MigrationTargetType {
	p := new(Group_MigrationTargetType)
	*p = x
	return p
}

func (x Group_MigrationTargetType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Group_MigrationTargetType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[34].Descriptor()
}

func (Group_MigrationTargetType) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[34]
}

func (x Group_MigrationTargetType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Group_MigrationTargetType.Descriptor instead.
func (Group_MigrationTargetType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{104, 0}
}

// Represents resource error codes.
type MigrationError_ErrorCode int32

const (
	// Default value. This value is not used.
	MigrationError_ERROR_CODE_UNSPECIFIED MigrationError_ErrorCode = 0
	// Migrate to Virtual Machines encountered an unknown error.
	MigrationError_UNKNOWN_ERROR MigrationError_ErrorCode = 1
	// Migrate to Virtual Machines encountered an error while validating
	// replication source health.
	MigrationError_SOURCE_VALIDATION_ERROR MigrationError_ErrorCode = 2
	// Migrate to Virtual Machines encountered an error during source data
	// operation.
	MigrationError_SOURCE_REPLICATION_ERROR MigrationError_ErrorCode = 3
	// Migrate to Virtual Machines encountered an error during target data
	// operation.
	MigrationError_TARGET_REPLICATION_ERROR MigrationError_ErrorCode = 4
	// Migrate to Virtual Machines encountered an error during OS adaptation.
	MigrationError_OS_ADAPTATION_ERROR MigrationError_ErrorCode = 5
	// Migrate to Virtual Machines encountered an error in clone operation.
	MigrationError_CLONE_ERROR MigrationError_ErrorCode = 6
	// Migrate to Virtual Machines encountered an error in cutover operation.
	MigrationError_CUTOVER_ERROR MigrationError_ErrorCode = 7
	// Migrate to Virtual Machines encountered an error during utilization
	// report creation.
	MigrationError_UTILIZATION_REPORT_ERROR MigrationError_ErrorCode = 8
	// Migrate to Virtual Machines encountered an error during appliance
	// upgrade.
	MigrationError_APPLIANCE_UPGRADE_ERROR MigrationError_ErrorCode = 9
	// Migrate to Virtual Machines encountered an error in image import
	// operation.
	MigrationError_IMAGE_IMPORT_ERROR MigrationError_ErrorCode = 10
	// Migrate to Virtual Machines encountered an error in disk migration
	// operation.
	MigrationError_DISK_MIGRATION_ERROR MigrationError_ErrorCode = 11
)

// Enum value maps for MigrationError_ErrorCode.
var (
	MigrationError_ErrorCode_name = map[int32]string{
		0:  "ERROR_CODE_UNSPECIFIED",
		1:  "UNKNOWN_ERROR",
		2:  "SOURCE_VALIDATION_ERROR",
		3:  "SOURCE_REPLICATION_ERROR",
		4:  "TARGET_REPLICATION_ERROR",
		5:  "OS_ADAPTATION_ERROR",
		6:  "CLONE_ERROR",
		7:  "CUTOVER_ERROR",
		8:  "UTILIZATION_REPORT_ERROR",
		9:  "APPLIANCE_UPGRADE_ERROR",
		10: "IMAGE_IMPORT_ERROR",
		11: "DISK_MIGRATION_ERROR",
	}
	MigrationError_ErrorCode_value = map[string]int32{
		"ERROR_CODE_UNSPECIFIED":   0,
		"UNKNOWN_ERROR":            1,
		"SOURCE_VALIDATION_ERROR":  2,
		"SOURCE_REPLICATION_ERROR": 3,
		"TARGET_REPLICATION_ERROR": 4,
		"OS_ADAPTATION_ERROR":      5,
		"CLONE_ERROR":              6,
		"CUTOVER_ERROR":            7,
		"UTILIZATION_REPORT_ERROR": 8,
		"APPLIANCE_UPGRADE_ERROR":  9,
		"IMAGE_IMPORT_ERROR":       10,
		"DISK_MIGRATION_ERROR":     11,
	}
)

func (x MigrationError_ErrorCode) Enum() *MigrationError_ErrorCode {
	p := new(MigrationError_ErrorCode)
	*p = x
	return p
}

func (x MigrationError_ErrorCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigrationError_ErrorCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[35].Descriptor()
}

func (MigrationError_ErrorCode) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[35]
}

func (x MigrationError_ErrorCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigrationError_ErrorCode.Descriptor instead.
func (MigrationError_ErrorCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{122, 0}
}

// Represents possible warning codes.
type MigrationWarning_WarningCode int32

const (
	// Default value. This value is not used.
	MigrationWarning_WARNING_CODE_UNSPECIFIED MigrationWarning_WarningCode = 0
	// A warning originated from OS Adaptation.
	MigrationWarning_ADAPTATION_WARNING MigrationWarning_WarningCode = 1
)

// Enum value maps for MigrationWarning_WarningCode.
var (
	MigrationWarning_WarningCode_name = map[int32]string{
		0: "WARNING_CODE_UNSPECIFIED",
		1: "ADAPTATION_WARNING",
	}
	MigrationWarning_WarningCode_value = map[string]int32{
		"WARNING_CODE_UNSPECIFIED": 0,
		"ADAPTATION_WARNING":       1,
	}
)

func (x MigrationWarning_WarningCode) Enum() *MigrationWarning_WarningCode {
	p := new(MigrationWarning_WarningCode)
	*p = x
	return p
}

func (x MigrationWarning_WarningCode) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MigrationWarning_WarningCode) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[36].Descriptor()
}

func (MigrationWarning_WarningCode) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[36]
}

func (x MigrationWarning_WarningCode) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MigrationWarning_WarningCode.Descriptor instead.
func (MigrationWarning_WarningCode) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{123, 0}
}

// Possible values for Vmware VM firmware.
type VmwareSourceVmDetails_Firmware int32

const (
	// The firmware is unknown.
	VmwareSourceVmDetails_FIRMWARE_UNSPECIFIED VmwareSourceVmDetails_Firmware = 0
	// The firmware is EFI.
	VmwareSourceVmDetails_EFI VmwareSourceVmDetails_Firmware = 1
	// The firmware is BIOS.
	VmwareSourceVmDetails_BIOS VmwareSourceVmDetails_Firmware = 2
)

// Enum value maps for VmwareSourceVmDetails_Firmware.
var (
	VmwareSourceVmDetails_Firmware_name = map[int32]string{
		0: "FIRMWARE_UNSPECIFIED",
		1: "EFI",
		2: "BIOS",
	}
	VmwareSourceVmDetails_Firmware_value = map[string]int32{
		"FIRMWARE_UNSPECIFIED": 0,
		"EFI":                  1,
		"BIOS":                 2,
	}
)

func (x VmwareSourceVmDetails_Firmware) Enum() *VmwareSourceVmDetails_Firmware {
	p := new(VmwareSourceVmDetails_Firmware)
	*p = x
	return p
}

func (x VmwareSourceVmDetails_Firmware) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VmwareSourceVmDetails_Firmware) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[37].Descriptor()
}

func (VmwareSourceVmDetails_Firmware) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[37]
}

func (x VmwareSourceVmDetails_Firmware) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VmwareSourceVmDetails_Firmware.Descriptor instead.
func (VmwareSourceVmDetails_Firmware) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{124, 0}
}

// Possible values for AWS VM firmware.
type AwsSourceVmDetails_Firmware int32

const (
	// The firmware is unknown.
	AwsSourceVmDetails_FIRMWARE_UNSPECIFIED AwsSourceVmDetails_Firmware = 0
	// The firmware is EFI.
	AwsSourceVmDetails_EFI AwsSourceVmDetails_Firmware = 1
	// The firmware is BIOS.
	AwsSourceVmDetails_BIOS AwsSourceVmDetails_Firmware = 2
)

// Enum value maps for AwsSourceVmDetails_Firmware.
var (
	AwsSourceVmDetails_Firmware_name = map[int32]string{
		0: "FIRMWARE_UNSPECIFIED",
		1: "EFI",
		2: "BIOS",
	}
	AwsSourceVmDetails_Firmware_value = map[string]int32{
		"FIRMWARE_UNSPECIFIED": 0,
		"EFI":                  1,
		"BIOS":                 2,
	}
)

func (x AwsSourceVmDetails_Firmware) Enum() *AwsSourceVmDetails_Firmware {
	p := new(AwsSourceVmDetails_Firmware)
	*p = x
	return p
}

func (x AwsSourceVmDetails_Firmware) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsSourceVmDetails_Firmware) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[38].Descriptor()
}

func (AwsSourceVmDetails_Firmware) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[38]
}

func (x AwsSourceVmDetails_Firmware) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsSourceVmDetails_Firmware.Descriptor instead.
func (AwsSourceVmDetails_Firmware) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{125, 0}
}

// Possible values for Azure VM firmware.
type AzureSourceVmDetails_Firmware int32

const (
	// The firmware is unknown.
	AzureSourceVmDetails_FIRMWARE_UNSPECIFIED AzureSourceVmDetails_Firmware = 0
	// The firmware is EFI.
	AzureSourceVmDetails_EFI AzureSourceVmDetails_Firmware = 1
	// The firmware is BIOS.
	AzureSourceVmDetails_BIOS AzureSourceVmDetails_Firmware = 2
)

// Enum value maps for AzureSourceVmDetails_Firmware.
var (
	AzureSourceVmDetails_Firmware_name = map[int32]string{
		0: "FIRMWARE_UNSPECIFIED",
		1: "EFI",
		2: "BIOS",
	}
	AzureSourceVmDetails_Firmware_value = map[string]int32{
		"FIRMWARE_UNSPECIFIED": 0,
		"EFI":                  1,
		"BIOS":                 2,
	}
)

func (x AzureSourceVmDetails_Firmware) Enum() *AzureSourceVmDetails_Firmware {
	p := new(AzureSourceVmDetails_Firmware)
	*p = x
	return p
}

func (x AzureSourceVmDetails_Firmware) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AzureSourceVmDetails_Firmware) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[39].Descriptor()
}

func (AzureSourceVmDetails_Firmware) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[39]
}

func (x AzureSourceVmDetails_Firmware) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AzureSourceVmDetails_Firmware.Descriptor instead.
func (AzureSourceVmDetails_Firmware) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{126, 0}
}

// Possible states of the image import.
type ImageImportJob_State int32

const (
	// The state is unknown.
	ImageImportJob_STATE_UNSPECIFIED ImageImportJob_State = 0
	// The image import has not yet started.
	ImageImportJob_PENDING ImageImportJob_State = 1
	// The image import is active and running.
	ImageImportJob_RUNNING ImageImportJob_State = 2
	// The image import has finished successfully.
	ImageImportJob_SUCCEEDED ImageImportJob_State = 3
	// The image import has finished with errors.
	ImageImportJob_FAILED ImageImportJob_State = 4
	// The image import is being cancelled.
	ImageImportJob_CANCELLING ImageImportJob_State = 5
	// The image import was cancelled.
	ImageImportJob_CANCELLED ImageImportJob_State = 6
)

// Enum value maps for ImageImportJob_State.
var (
	ImageImportJob_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "PENDING",
		2: "RUNNING",
		3: "SUCCEEDED",
		4: "FAILED",
		5: "CANCELLING",
		6: "CANCELLED",
	}
	ImageImportJob_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"PENDING":           1,
		"RUNNING":           2,
		"SUCCEEDED":         3,
		"FAILED":            4,
		"CANCELLING":        5,
		"CANCELLED":         6,
	}
)

func (x ImageImportJob_State) Enum() *ImageImportJob_State {
	p := new(ImageImportJob_State)
	*p = x
	return p
}

func (x ImageImportJob_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImageImportJob_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[40].Descriptor()
}

func (ImageImportJob_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[40]
}

func (x ImageImportJob_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImageImportJob_State.Descriptor instead.
func (ImageImportJob_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{132, 0}
}

// Possible values for secure boot.
type ShieldedInstanceConfig_SecureBoot int32

const (
	// No explicit value is selected. Will use the configuration of the source
	// (if exists, otherwise the default will be false).
	ShieldedInstanceConfig_SECURE_BOOT_UNSPECIFIED ShieldedInstanceConfig_SecureBoot = 0
	// Use secure boot. This can be set to true only if the image boot option is
	// EFI.
	ShieldedInstanceConfig_TRUE ShieldedInstanceConfig_SecureBoot = 1
	// Do not use secure boot.
	ShieldedInstanceConfig_FALSE ShieldedInstanceConfig_SecureBoot = 2
)

// Enum value maps for ShieldedInstanceConfig_SecureBoot.
var (
	ShieldedInstanceConfig_SecureBoot_name = map[int32]string{
		0: "SECURE_BOOT_UNSPECIFIED",
		1: "TRUE",
		2: "FALSE",
	}
	ShieldedInstanceConfig_SecureBoot_value = map[string]int32{
		"SECURE_BOOT_UNSPECIFIED": 0,
		"TRUE":                    1,
		"FALSE":                   2,
	}
)

func (x ShieldedInstanceConfig_SecureBoot) Enum() *ShieldedInstanceConfig_SecureBoot {
	p := new(ShieldedInstanceConfig_SecureBoot)
	*p = x
	return p
}

func (x ShieldedInstanceConfig_SecureBoot) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ShieldedInstanceConfig_SecureBoot) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[41].Descriptor()
}

func (ShieldedInstanceConfig_SecureBoot) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[41]
}

func (x ShieldedInstanceConfig_SecureBoot) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ShieldedInstanceConfig_SecureBoot.Descriptor instead.
func (ShieldedInstanceConfig_SecureBoot) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{140, 0}
}

// The possible values of the state/health of DiskMigrationJob.
type DiskMigrationJob_State int32

const (
	// The state is unspecified. This is not in use.
	DiskMigrationJob_STATE_UNSPECIFIED DiskMigrationJob_State = 0
	// The initial state of the disk migration.
	// In this state the customers can update the target details.
	DiskMigrationJob_READY DiskMigrationJob_State = 1
	// The migration is active, and it's running or scheduled to run.
	DiskMigrationJob_RUNNING DiskMigrationJob_State = 3
	// The migration completed successfully.
	DiskMigrationJob_SUCCEEDED DiskMigrationJob_State = 4
	// Migration cancellation was initiated.
	DiskMigrationJob_CANCELLING DiskMigrationJob_State = 5
	// The migration was cancelled.
	DiskMigrationJob_CANCELLED DiskMigrationJob_State = 6
	// The migration process encountered an unrecoverable error and was aborted.
	DiskMigrationJob_FAILED DiskMigrationJob_State = 7
)

// Enum value maps for DiskMigrationJob_State.
var (
	DiskMigrationJob_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "READY",
		3: "RUNNING",
		4: "SUCCEEDED",
		5: "CANCELLING",
		6: "CANCELLED",
		7: "FAILED",
	}
	DiskMigrationJob_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"READY":             1,
		"RUNNING":           3,
		"SUCCEEDED":         4,
		"CANCELLING":        5,
		"CANCELLED":         6,
		"FAILED":            7,
	}
)

func (x DiskMigrationJob_State) Enum() *DiskMigrationJob_State {
	p := new(DiskMigrationJob_State)
	*p = x
	return p
}

func (x DiskMigrationJob_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DiskMigrationJob_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[42].Descriptor()
}

func (DiskMigrationJob_State) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[42]
}

func (x DiskMigrationJob_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DiskMigrationJob_State.Descriptor instead.
func (DiskMigrationJob_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{155, 0}
}

// Possible values for disk types.
type AwsSourceDiskDetails_Type int32

const (
	// Unspecified AWS disk type. Should not be used.
	AwsSourceDiskDetails_TYPE_UNSPECIFIED AwsSourceDiskDetails_Type = 0
	// GP2 disk type.
	AwsSourceDiskDetails_GP2 AwsSourceDiskDetails_Type = 1
	// GP3 disk type.
	AwsSourceDiskDetails_GP3 AwsSourceDiskDetails_Type = 2
	// IO1 disk type.
	AwsSourceDiskDetails_IO1 AwsSourceDiskDetails_Type = 3
	// IO2 disk type.
	AwsSourceDiskDetails_IO2 AwsSourceDiskDetails_Type = 4
	// ST1 disk type.
	AwsSourceDiskDetails_ST1 AwsSourceDiskDetails_Type = 5
	// SC1 disk type.
	AwsSourceDiskDetails_SC1 AwsSourceDiskDetails_Type = 6
	// Standard disk type.
	AwsSourceDiskDetails_STANDARD AwsSourceDiskDetails_Type = 7
)

// Enum value maps for AwsSourceDiskDetails_Type.
var (
	AwsSourceDiskDetails_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "GP2",
		2: "GP3",
		3: "IO1",
		4: "IO2",
		5: "ST1",
		6: "SC1",
		7: "STANDARD",
	}
	AwsSourceDiskDetails_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"GP2":              1,
		"GP3":              2,
		"IO1":              3,
		"IO2":              4,
		"ST1":              5,
		"SC1":              6,
		"STANDARD":         7,
	}
)

func (x AwsSourceDiskDetails_Type) Enum() *AwsSourceDiskDetails_Type {
	p := new(AwsSourceDiskDetails_Type)
	*p = x
	return p
}

func (x AwsSourceDiskDetails_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AwsSourceDiskDetails_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[43].Descriptor()
}

func (AwsSourceDiskDetails_Type) Type() protoreflect.EnumType {
	return &file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes[43]
}

func (x AwsSourceDiskDetails_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AwsSourceDiskDetails_Type.Descriptor instead.
func (AwsSourceDiskDetails_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{162, 0}
}

// ReplicationCycle contains information about the current replication cycle
// status.
type ReplicationCycle struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The identifier of the ReplicationCycle.
	Name string `protobuf:"bytes,13,opt,name=name,proto3" json:"name,omitempty"`
	// The cycle's ordinal number.
	CycleNumber int32 `protobuf:"varint,10,opt,name=cycle_number,json=cycleNumber,proto3" json:"cycle_number,omitempty"`
	// The time the replication cycle has started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the replication cycle has ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The accumulated duration the replication cycle was paused.
	TotalPauseDuration *durationpb.Duration `protobuf:"bytes,7,opt,name=total_pause_duration,json=totalPauseDuration,proto3" json:"total_pause_duration,omitempty"`
	// The current progress in percentage of this cycle.
	// Was replaced by 'steps' field, which breaks down the cycle progression more
	// accurately.
	//
	// Deprecated: Marked as deprecated in google/cloud/vmmigration/v1/vmmigration.proto.
	ProgressPercent int32 `protobuf:"varint,5,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// The cycle's steps list representing its progress.
	Steps []*CycleStep `protobuf:"bytes,9,rep,name=steps,proto3" json:"steps,omitempty"`
	// State of the ReplicationCycle.
	State ReplicationCycle_State `protobuf:"varint,11,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.ReplicationCycle_State" json:"state,omitempty"`
	// Output only. Provides details on the state of the cycle in case of an
	// error.
	Error *status.Status `protobuf:"bytes,12,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. Warnings that occurred during the cycle.
	Warnings []*MigrationWarning `protobuf:"bytes,14,rep,name=warnings,proto3" json:"warnings,omitempty"`
}

func (x *ReplicationCycle) Reset() {
	*x = ReplicationCycle{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicationCycle) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationCycle) ProtoMessage() {}

func (x *ReplicationCycle) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationCycle.ProtoReflect.Descriptor instead.
func (*ReplicationCycle) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{0}
}

func (x *ReplicationCycle) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ReplicationCycle) GetCycleNumber() int32 {
	if x != nil {
		return x.CycleNumber
	}
	return 0
}

func (x *ReplicationCycle) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ReplicationCycle) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ReplicationCycle) GetTotalPauseDuration() *durationpb.Duration {
	if x != nil {
		return x.TotalPauseDuration
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/vmmigration/v1/vmmigration.proto.
func (x *ReplicationCycle) GetProgressPercent() int32 {
	if x != nil {
		return x.ProgressPercent
	}
	return 0
}

func (x *ReplicationCycle) GetSteps() []*CycleStep {
	if x != nil {
		return x.Steps
	}
	return nil
}

func (x *ReplicationCycle) GetState() ReplicationCycle_State {
	if x != nil {
		return x.State
	}
	return ReplicationCycle_STATE_UNSPECIFIED
}

func (x *ReplicationCycle) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *ReplicationCycle) GetWarnings() []*MigrationWarning {
	if x != nil {
		return x.Warnings
	}
	return nil
}

// CycleStep holds information about a step progress.
type CycleStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Step:
	//
	//	*CycleStep_InitializingReplication
	//	*CycleStep_Replicating
	//	*CycleStep_PostProcessing
	Step isCycleStep_Step `protobuf_oneof:"step"`
	// The time the cycle step has started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the cycle step has ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *CycleStep) Reset() {
	*x = CycleStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CycleStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CycleStep) ProtoMessage() {}

func (x *CycleStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CycleStep.ProtoReflect.Descriptor instead.
func (*CycleStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{1}
}

func (m *CycleStep) GetStep() isCycleStep_Step {
	if m != nil {
		return m.Step
	}
	return nil
}

func (x *CycleStep) GetInitializingReplication() *InitializingReplicationStep {
	if x, ok := x.GetStep().(*CycleStep_InitializingReplication); ok {
		return x.InitializingReplication
	}
	return nil
}

func (x *CycleStep) GetReplicating() *ReplicatingStep {
	if x, ok := x.GetStep().(*CycleStep_Replicating); ok {
		return x.Replicating
	}
	return nil
}

func (x *CycleStep) GetPostProcessing() *PostProcessingStep {
	if x, ok := x.GetStep().(*CycleStep_PostProcessing); ok {
		return x.PostProcessing
	}
	return nil
}

func (x *CycleStep) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CycleStep) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isCycleStep_Step interface {
	isCycleStep_Step()
}

type CycleStep_InitializingReplication struct {
	// Initializing replication step.
	InitializingReplication *InitializingReplicationStep `protobuf:"bytes,3,opt,name=initializing_replication,json=initializingReplication,proto3,oneof"`
}

type CycleStep_Replicating struct {
	// Replicating step.
	Replicating *ReplicatingStep `protobuf:"bytes,4,opt,name=replicating,proto3,oneof"`
}

type CycleStep_PostProcessing struct {
	// Post processing step.
	PostProcessing *PostProcessingStep `protobuf:"bytes,5,opt,name=post_processing,json=postProcessing,proto3,oneof"`
}

func (*CycleStep_InitializingReplication) isCycleStep_Step() {}

func (*CycleStep_Replicating) isCycleStep_Step() {}

func (*CycleStep_PostProcessing) isCycleStep_Step() {}

// InitializingReplicationStep contains specific step details.
type InitializingReplicationStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *InitializingReplicationStep) Reset() {
	*x = InitializingReplicationStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InitializingReplicationStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitializingReplicationStep) ProtoMessage() {}

func (x *InitializingReplicationStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitializingReplicationStep.ProtoReflect.Descriptor instead.
func (*InitializingReplicationStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{2}
}

// ReplicatingStep contains specific step details.
type ReplicatingStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Total bytes to be handled in the step.
	TotalBytes int64 `protobuf:"varint,1,opt,name=total_bytes,json=totalBytes,proto3" json:"total_bytes,omitempty"`
	// Replicated bytes in the step.
	ReplicatedBytes int64 `protobuf:"varint,2,opt,name=replicated_bytes,json=replicatedBytes,proto3" json:"replicated_bytes,omitempty"`
	// The source disks replication rate for the last 2 minutes in bytes per
	// second.
	LastTwoMinutesAverageBytesPerSecond int64 `protobuf:"varint,3,opt,name=last_two_minutes_average_bytes_per_second,json=lastTwoMinutesAverageBytesPerSecond,proto3" json:"last_two_minutes_average_bytes_per_second,omitempty"`
	// The source disks replication rate for the last 30 minutes in bytes per
	// second.
	LastThirtyMinutesAverageBytesPerSecond int64 `protobuf:"varint,4,opt,name=last_thirty_minutes_average_bytes_per_second,json=lastThirtyMinutesAverageBytesPerSecond,proto3" json:"last_thirty_minutes_average_bytes_per_second,omitempty"`
}

func (x *ReplicatingStep) Reset() {
	*x = ReplicatingStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicatingStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicatingStep) ProtoMessage() {}

func (x *ReplicatingStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicatingStep.ProtoReflect.Descriptor instead.
func (*ReplicatingStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{3}
}

func (x *ReplicatingStep) GetTotalBytes() int64 {
	if x != nil {
		return x.TotalBytes
	}
	return 0
}

func (x *ReplicatingStep) GetReplicatedBytes() int64 {
	if x != nil {
		return x.ReplicatedBytes
	}
	return 0
}

func (x *ReplicatingStep) GetLastTwoMinutesAverageBytesPerSecond() int64 {
	if x != nil {
		return x.LastTwoMinutesAverageBytesPerSecond
	}
	return 0
}

func (x *ReplicatingStep) GetLastThirtyMinutesAverageBytesPerSecond() int64 {
	if x != nil {
		return x.LastThirtyMinutesAverageBytesPerSecond
	}
	return 0
}

// PostProcessingStep contains specific step details.
type PostProcessingStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PostProcessingStep) Reset() {
	*x = PostProcessingStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PostProcessingStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PostProcessingStep) ProtoMessage() {}

func (x *PostProcessingStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PostProcessingStep.ProtoReflect.Descriptor instead.
func (*PostProcessingStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{4}
}

// ReplicationSync contain information about the last replica sync to the cloud.
type ReplicationSync struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The most updated snapshot created time in the source that finished
	// replication.
	LastSyncTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=last_sync_time,json=lastSyncTime,proto3" json:"last_sync_time,omitempty"`
}

func (x *ReplicationSync) Reset() {
	*x = ReplicationSync{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReplicationSync) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReplicationSync) ProtoMessage() {}

func (x *ReplicationSync) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReplicationSync.ProtoReflect.Descriptor instead.
func (*ReplicationSync) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{5}
}

func (x *ReplicationSync) GetLastSyncTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastSyncTime
	}
	return nil
}

// MigratingVm describes the VM that will be migrated from a Source environment
// and its replication state.
type MigratingVm struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The default configuration of the target VM that will be created in Google
	// Cloud as a result of the migration.
	//
	// Types that are assignable to TargetVmDefaults:
	//
	//	*MigratingVm_ComputeEngineTargetDefaults
	//	*MigratingVm_ComputeEngineDisksTargetDefaults
	TargetVmDefaults isMigratingVm_TargetVmDefaults `protobuf_oneof:"target_vm_defaults"`
	// Details about the source VM.
	//
	// Types that are assignable to SourceVmDetails:
	//
	//	*MigratingVm_VmwareSourceVmDetails
	//	*MigratingVm_AwsSourceVmDetails
	//	*MigratingVm_AzureSourceVmDetails
	SourceVmDetails isMigratingVm_SourceVmDetails `protobuf_oneof:"source_vm_details"`
	// Output only. The identifier of the MigratingVm.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The unique ID of the VM in the source.
	// The VM's name in vSphere can be changed, so this is not the VM's name but
	// rather its moRef id. This id is of the form vm-<num>.
	SourceVmId string `protobuf:"bytes,2,opt,name=source_vm_id,json=sourceVmId,proto3" json:"source_vm_id,omitempty"`
	// The display name attached to the MigratingVm by the user.
	DisplayName string `protobuf:"bytes,18,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The description attached to the migrating VM by the user.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// The replication schedule policy.
	Policy *SchedulePolicy `protobuf:"bytes,8,opt,name=policy,proto3" json:"policy,omitempty"`
	// Output only. The time the migrating VM was created (this refers to this
	// resource and not to the time it was installed in the source).
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last time the migrating VM resource was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The most updated snapshot created time in the source that
	// finished replication.
	LastSync *ReplicationSync `protobuf:"bytes,11,opt,name=last_sync,json=lastSync,proto3" json:"last_sync,omitempty"`
	// Output only. State of the MigratingVm.
	State MigratingVm_State `protobuf:"varint,23,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.MigratingVm_State" json:"state,omitempty"`
	// Output only. The last time the migrating VM state was updated.
	StateTime *timestamppb.Timestamp `protobuf:"bytes,22,opt,name=state_time,json=stateTime,proto3" json:"state_time,omitempty"`
	// Output only. Details of the current running replication cycle.
	CurrentSyncInfo *ReplicationCycle `protobuf:"bytes,13,opt,name=current_sync_info,json=currentSyncInfo,proto3" json:"current_sync_info,omitempty"`
	// Output only. Details of the last replication cycle. This will be updated
	// whenever a replication cycle is finished and is not to be confused with
	// last_sync which is only updated on successful replication cycles.
	LastReplicationCycle *ReplicationCycle `protobuf:"bytes,32,opt,name=last_replication_cycle,json=lastReplicationCycle,proto3" json:"last_replication_cycle,omitempty"`
	// Output only. The group this migrating vm is included in, if any. The group
	// is represented by the full path of the appropriate
	// [Group][google.cloud.vmmigration.v1.Group] resource.
	Group string `protobuf:"bytes,15,opt,name=group,proto3" json:"group,omitempty"`
	// The labels of the migrating VM.
	Labels map[string]string `protobuf:"bytes,16,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The recent [clone jobs][google.cloud.vmmigration.v1.CloneJob]
	// performed on the migrating VM. This field holds the vm's last completed
	// clone job and the vm's running clone job, if one exists.
	// Note: To have this field populated you need to explicitly request it via
	// the "view" parameter of the Get/List request.
	RecentCloneJobs []*CloneJob `protobuf:"bytes,17,rep,name=recent_clone_jobs,json=recentCloneJobs,proto3" json:"recent_clone_jobs,omitempty"`
	// Output only. Provides details on the state of the Migrating VM in case of
	// an error in replication.
	Error *status.Status `protobuf:"bytes,19,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. The recent cutover jobs performed on the migrating VM.
	// This field holds the vm's last completed cutover job and the vm's
	// running cutover job, if one exists.
	// Note: To have this field populated you need to explicitly request it via
	// the "view" parameter of the Get/List request.
	RecentCutoverJobs []*CutoverJob `protobuf:"bytes,20,rep,name=recent_cutover_jobs,json=recentCutoverJobs,proto3" json:"recent_cutover_jobs,omitempty"`
	// Output only. Provides details of future CutoverJobs of a MigratingVm.
	// Set to empty when cutover forecast is unavailable.
	CutoverForecast *CutoverForecast `protobuf:"bytes,33,opt,name=cutover_forecast,json=cutoverForecast,proto3" json:"cutover_forecast,omitempty"`
	// Output only. Provides details about the expiration state of the migrating
	// VM.
	Expiration *MigratingVm_Expiration `protobuf:"bytes,37,opt,name=expiration,proto3" json:"expiration,omitempty"`
}

func (x *MigratingVm) Reset() {
	*x = MigratingVm{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MigratingVm) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigratingVm) ProtoMessage() {}

func (x *MigratingVm) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigratingVm.ProtoReflect.Descriptor instead.
func (*MigratingVm) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{6}
}

func (m *MigratingVm) GetTargetVmDefaults() isMigratingVm_TargetVmDefaults {
	if m != nil {
		return m.TargetVmDefaults
	}
	return nil
}

func (x *MigratingVm) GetComputeEngineTargetDefaults() *ComputeEngineTargetDefaults {
	if x, ok := x.GetTargetVmDefaults().(*MigratingVm_ComputeEngineTargetDefaults); ok {
		return x.ComputeEngineTargetDefaults
	}
	return nil
}

func (x *MigratingVm) GetComputeEngineDisksTargetDefaults() *ComputeEngineDisksTargetDefaults {
	if x, ok := x.GetTargetVmDefaults().(*MigratingVm_ComputeEngineDisksTargetDefaults); ok {
		return x.ComputeEngineDisksTargetDefaults
	}
	return nil
}

func (m *MigratingVm) GetSourceVmDetails() isMigratingVm_SourceVmDetails {
	if m != nil {
		return m.SourceVmDetails
	}
	return nil
}

func (x *MigratingVm) GetVmwareSourceVmDetails() *VmwareSourceVmDetails {
	if x, ok := x.GetSourceVmDetails().(*MigratingVm_VmwareSourceVmDetails); ok {
		return x.VmwareSourceVmDetails
	}
	return nil
}

func (x *MigratingVm) GetAwsSourceVmDetails() *AwsSourceVmDetails {
	if x, ok := x.GetSourceVmDetails().(*MigratingVm_AwsSourceVmDetails); ok {
		return x.AwsSourceVmDetails
	}
	return nil
}

func (x *MigratingVm) GetAzureSourceVmDetails() *AzureSourceVmDetails {
	if x, ok := x.GetSourceVmDetails().(*MigratingVm_AzureSourceVmDetails); ok {
		return x.AzureSourceVmDetails
	}
	return nil
}

func (x *MigratingVm) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MigratingVm) GetSourceVmId() string {
	if x != nil {
		return x.SourceVmId
	}
	return ""
}

func (x *MigratingVm) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *MigratingVm) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *MigratingVm) GetPolicy() *SchedulePolicy {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *MigratingVm) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *MigratingVm) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *MigratingVm) GetLastSync() *ReplicationSync {
	if x != nil {
		return x.LastSync
	}
	return nil
}

func (x *MigratingVm) GetState() MigratingVm_State {
	if x != nil {
		return x.State
	}
	return MigratingVm_STATE_UNSPECIFIED
}

func (x *MigratingVm) GetStateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StateTime
	}
	return nil
}

func (x *MigratingVm) GetCurrentSyncInfo() *ReplicationCycle {
	if x != nil {
		return x.CurrentSyncInfo
	}
	return nil
}

func (x *MigratingVm) GetLastReplicationCycle() *ReplicationCycle {
	if x != nil {
		return x.LastReplicationCycle
	}
	return nil
}

func (x *MigratingVm) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *MigratingVm) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *MigratingVm) GetRecentCloneJobs() []*CloneJob {
	if x != nil {
		return x.RecentCloneJobs
	}
	return nil
}

func (x *MigratingVm) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *MigratingVm) GetRecentCutoverJobs() []*CutoverJob {
	if x != nil {
		return x.RecentCutoverJobs
	}
	return nil
}

func (x *MigratingVm) GetCutoverForecast() *CutoverForecast {
	if x != nil {
		return x.CutoverForecast
	}
	return nil
}

func (x *MigratingVm) GetExpiration() *MigratingVm_Expiration {
	if x != nil {
		return x.Expiration
	}
	return nil
}

type isMigratingVm_TargetVmDefaults interface {
	isMigratingVm_TargetVmDefaults()
}

type MigratingVm_ComputeEngineTargetDefaults struct {
	// Details of the target VM in Compute Engine.
	ComputeEngineTargetDefaults *ComputeEngineTargetDefaults `protobuf:"bytes,26,opt,name=compute_engine_target_defaults,json=computeEngineTargetDefaults,proto3,oneof"`
}

type MigratingVm_ComputeEngineDisksTargetDefaults struct {
	// Details of the target Persistent Disks in Compute Engine.
	ComputeEngineDisksTargetDefaults *ComputeEngineDisksTargetDefaults `protobuf:"bytes,34,opt,name=compute_engine_disks_target_defaults,json=computeEngineDisksTargetDefaults,proto3,oneof"`
}

func (*MigratingVm_ComputeEngineTargetDefaults) isMigratingVm_TargetVmDefaults() {}

func (*MigratingVm_ComputeEngineDisksTargetDefaults) isMigratingVm_TargetVmDefaults() {}

type isMigratingVm_SourceVmDetails interface {
	isMigratingVm_SourceVmDetails()
}

type MigratingVm_VmwareSourceVmDetails struct {
	// Output only. Details of the VM from a Vmware source.
	VmwareSourceVmDetails *VmwareSourceVmDetails `protobuf:"bytes,28,opt,name=vmware_source_vm_details,json=vmwareSourceVmDetails,proto3,oneof"`
}

type MigratingVm_AwsSourceVmDetails struct {
	// Output only. Details of the VM from an AWS source.
	AwsSourceVmDetails *AwsSourceVmDetails `protobuf:"bytes,29,opt,name=aws_source_vm_details,json=awsSourceVmDetails,proto3,oneof"`
}

type MigratingVm_AzureSourceVmDetails struct {
	// Output only. Details of the VM from an Azure source.
	AzureSourceVmDetails *AzureSourceVmDetails `protobuf:"bytes,30,opt,name=azure_source_vm_details,json=azureSourceVmDetails,proto3,oneof"`
}

func (*MigratingVm_VmwareSourceVmDetails) isMigratingVm_SourceVmDetails() {}

func (*MigratingVm_AwsSourceVmDetails) isMigratingVm_SourceVmDetails() {}

func (*MigratingVm_AzureSourceVmDetails) isMigratingVm_SourceVmDetails() {}

// CutoverForecast holds information about future CutoverJobs of a MigratingVm.
type CutoverForecast struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Estimation of the CutoverJob duration.
	EstimatedCutoverJobDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=estimated_cutover_job_duration,json=estimatedCutoverJobDuration,proto3" json:"estimated_cutover_job_duration,omitempty"`
}

func (x *CutoverForecast) Reset() {
	*x = CutoverForecast{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CutoverForecast) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CutoverForecast) ProtoMessage() {}

func (x *CutoverForecast) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CutoverForecast.ProtoReflect.Descriptor instead.
func (*CutoverForecast) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{7}
}

func (x *CutoverForecast) GetEstimatedCutoverJobDuration() *durationpb.Duration {
	if x != nil {
		return x.EstimatedCutoverJobDuration
	}
	return nil
}

// CloneJob describes the process of creating a clone of a
// [MigratingVM][google.cloud.vmmigration.v1.MigratingVm] to the
// requested target based on the latest successful uploaded snapshots.
// While the migration cycles of a MigratingVm take place, it is possible to
// verify the uploaded VM can be started in the cloud, by creating a clone. The
// clone can be created without any downtime, and it is created using the latest
// snapshots which are already in the cloud. The cloneJob is only responsible
// for its work, not its products, which means once it is finished, it will
// never touch the instance it created. It will only delete it in case of the
// CloneJob being cancelled or upon failure to clone.
type CloneJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details of the VM to create as the target of this clone job.
	//
	// Types that are assignable to TargetVmDetails:
	//
	//	*CloneJob_ComputeEngineTargetDetails
	//	*CloneJob_ComputeEngineDisksTargetDetails
	TargetVmDetails isCloneJob_TargetVmDetails `protobuf_oneof:"target_vm_details"`
	// Output only. The time the clone job was created (as an API call, not when
	// it was actually created in the target).
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the clone job was ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,22,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The name of the clone.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. State of the clone job.
	State CloneJob_State `protobuf:"varint,12,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.CloneJob_State" json:"state,omitempty"`
	// Output only. The time the state was last updated.
	StateTime *timestamppb.Timestamp `protobuf:"bytes,14,opt,name=state_time,json=stateTime,proto3" json:"state_time,omitempty"`
	// Output only. Provides details for the errors that led to the Clone Job's
	// state.
	Error *status.Status `protobuf:"bytes,17,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. The clone steps list representing its progress.
	Steps []*CloneStep `protobuf:"bytes,23,rep,name=steps,proto3" json:"steps,omitempty"`
}

func (x *CloneJob) Reset() {
	*x = CloneJob{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloneJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloneJob) ProtoMessage() {}

func (x *CloneJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloneJob.ProtoReflect.Descriptor instead.
func (*CloneJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{8}
}

func (m *CloneJob) GetTargetVmDetails() isCloneJob_TargetVmDetails {
	if m != nil {
		return m.TargetVmDetails
	}
	return nil
}

func (x *CloneJob) GetComputeEngineTargetDetails() *ComputeEngineTargetDetails {
	if x, ok := x.GetTargetVmDetails().(*CloneJob_ComputeEngineTargetDetails); ok {
		return x.ComputeEngineTargetDetails
	}
	return nil
}

func (x *CloneJob) GetComputeEngineDisksTargetDetails() *ComputeEngineDisksTargetDetails {
	if x, ok := x.GetTargetVmDetails().(*CloneJob_ComputeEngineDisksTargetDetails); ok {
		return x.ComputeEngineDisksTargetDetails
	}
	return nil
}

func (x *CloneJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CloneJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CloneJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CloneJob) GetState() CloneJob_State {
	if x != nil {
		return x.State
	}
	return CloneJob_STATE_UNSPECIFIED
}

func (x *CloneJob) GetStateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StateTime
	}
	return nil
}

func (x *CloneJob) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *CloneJob) GetSteps() []*CloneStep {
	if x != nil {
		return x.Steps
	}
	return nil
}

type isCloneJob_TargetVmDetails interface {
	isCloneJob_TargetVmDetails()
}

type CloneJob_ComputeEngineTargetDetails struct {
	// Output only. Details of the target VM in Compute Engine.
	ComputeEngineTargetDetails *ComputeEngineTargetDetails `protobuf:"bytes,20,opt,name=compute_engine_target_details,json=computeEngineTargetDetails,proto3,oneof"`
}

type CloneJob_ComputeEngineDisksTargetDetails struct {
	// Output only. Details of the target Persistent Disks in Compute Engine.
	ComputeEngineDisksTargetDetails *ComputeEngineDisksTargetDetails `protobuf:"bytes,25,opt,name=compute_engine_disks_target_details,json=computeEngineDisksTargetDetails,proto3,oneof"`
}

func (*CloneJob_ComputeEngineTargetDetails) isCloneJob_TargetVmDetails() {}

func (*CloneJob_ComputeEngineDisksTargetDetails) isCloneJob_TargetVmDetails() {}

// CloneStep holds information about the clone step progress.
type CloneStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Step:
	//
	//	*CloneStep_AdaptingOs
	//	*CloneStep_PreparingVmDisks
	//	*CloneStep_InstantiatingMigratedVm
	Step isCloneStep_Step `protobuf_oneof:"step"`
	// The time the step has started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the step has ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *CloneStep) Reset() {
	*x = CloneStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CloneStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloneStep) ProtoMessage() {}

func (x *CloneStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloneStep.ProtoReflect.Descriptor instead.
func (*CloneStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{9}
}

func (m *CloneStep) GetStep() isCloneStep_Step {
	if m != nil {
		return m.Step
	}
	return nil
}

func (x *CloneStep) GetAdaptingOs() *AdaptingOSStep {
	if x, ok := x.GetStep().(*CloneStep_AdaptingOs); ok {
		return x.AdaptingOs
	}
	return nil
}

func (x *CloneStep) GetPreparingVmDisks() *PreparingVMDisksStep {
	if x, ok := x.GetStep().(*CloneStep_PreparingVmDisks); ok {
		return x.PreparingVmDisks
	}
	return nil
}

func (x *CloneStep) GetInstantiatingMigratedVm() *InstantiatingMigratedVMStep {
	if x, ok := x.GetStep().(*CloneStep_InstantiatingMigratedVm); ok {
		return x.InstantiatingMigratedVm
	}
	return nil
}

func (x *CloneStep) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CloneStep) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isCloneStep_Step interface {
	isCloneStep_Step()
}

type CloneStep_AdaptingOs struct {
	// Adapting OS step.
	AdaptingOs *AdaptingOSStep `protobuf:"bytes,3,opt,name=adapting_os,json=adaptingOs,proto3,oneof"`
}

type CloneStep_PreparingVmDisks struct {
	// Preparing VM disks step.
	PreparingVmDisks *PreparingVMDisksStep `protobuf:"bytes,4,opt,name=preparing_vm_disks,json=preparingVmDisks,proto3,oneof"`
}

type CloneStep_InstantiatingMigratedVm struct {
	// Instantiating migrated VM step.
	InstantiatingMigratedVm *InstantiatingMigratedVMStep `protobuf:"bytes,5,opt,name=instantiating_migrated_vm,json=instantiatingMigratedVm,proto3,oneof"`
}

func (*CloneStep_AdaptingOs) isCloneStep_Step() {}

func (*CloneStep_PreparingVmDisks) isCloneStep_Step() {}

func (*CloneStep_InstantiatingMigratedVm) isCloneStep_Step() {}

// AdaptingOSStep contains specific step details.
type AdaptingOSStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AdaptingOSStep) Reset() {
	*x = AdaptingOSStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdaptingOSStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdaptingOSStep) ProtoMessage() {}

func (x *AdaptingOSStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdaptingOSStep.ProtoReflect.Descriptor instead.
func (*AdaptingOSStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{10}
}

// PreparingVMDisksStep contains specific step details.
type PreparingVMDisksStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PreparingVMDisksStep) Reset() {
	*x = PreparingVMDisksStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PreparingVMDisksStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PreparingVMDisksStep) ProtoMessage() {}

func (x *PreparingVMDisksStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PreparingVMDisksStep.ProtoReflect.Descriptor instead.
func (*PreparingVMDisksStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{11}
}

// InstantiatingMigratedVMStep contains specific step details.
type InstantiatingMigratedVMStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *InstantiatingMigratedVMStep) Reset() {
	*x = InstantiatingMigratedVMStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InstantiatingMigratedVMStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InstantiatingMigratedVMStep) ProtoMessage() {}

func (x *InstantiatingMigratedVMStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InstantiatingMigratedVMStep.ProtoReflect.Descriptor instead.
func (*InstantiatingMigratedVMStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{12}
}

// CutoverJob message describes a cutover of a migrating VM. The CutoverJob is
// the operation of shutting down the VM, creating a snapshot and
// cloning the VM using the replicated snapshot.
type CutoverJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details of the VM to create as the target of this cutover job.
	//
	// Types that are assignable to TargetVmDetails:
	//
	//	*CutoverJob_ComputeEngineTargetDetails
	//	*CutoverJob_ComputeEngineDisksTargetDetails
	TargetVmDetails isCutoverJob_TargetVmDetails `protobuf_oneof:"target_vm_details"`
	// Output only. The time the cutover job was created (as an API call, not when
	// it was actually created in the target).
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the cutover job had finished.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,16,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The name of the cutover job.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. State of the cutover job.
	State CutoverJob_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.CutoverJob_State" json:"state,omitempty"`
	// Output only. The time the state was last updated.
	StateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=state_time,json=stateTime,proto3" json:"state_time,omitempty"`
	// Output only. The current progress in percentage of the cutover job.
	ProgressPercent int32 `protobuf:"varint,13,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Output only. Provides details for the errors that led to the Cutover Job's
	// state.
	Error *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. A message providing possible extra details about the current
	// state.
	StateMessage string `protobuf:"bytes,10,opt,name=state_message,json=stateMessage,proto3" json:"state_message,omitempty"`
	// Output only. The cutover steps list representing its progress.
	Steps []*CutoverStep `protobuf:"bytes,17,rep,name=steps,proto3" json:"steps,omitempty"`
}

func (x *CutoverJob) Reset() {
	*x = CutoverJob{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CutoverJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CutoverJob) ProtoMessage() {}

func (x *CutoverJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CutoverJob.ProtoReflect.Descriptor instead.
func (*CutoverJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{13}
}

func (m *CutoverJob) GetTargetVmDetails() isCutoverJob_TargetVmDetails {
	if m != nil {
		return m.TargetVmDetails
	}
	return nil
}

func (x *CutoverJob) GetComputeEngineTargetDetails() *ComputeEngineTargetDetails {
	if x, ok := x.GetTargetVmDetails().(*CutoverJob_ComputeEngineTargetDetails); ok {
		return x.ComputeEngineTargetDetails
	}
	return nil
}

func (x *CutoverJob) GetComputeEngineDisksTargetDetails() *ComputeEngineDisksTargetDetails {
	if x, ok := x.GetTargetVmDetails().(*CutoverJob_ComputeEngineDisksTargetDetails); ok {
		return x.ComputeEngineDisksTargetDetails
	}
	return nil
}

func (x *CutoverJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *CutoverJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *CutoverJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CutoverJob) GetState() CutoverJob_State {
	if x != nil {
		return x.State
	}
	return CutoverJob_STATE_UNSPECIFIED
}

func (x *CutoverJob) GetStateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StateTime
	}
	return nil
}

func (x *CutoverJob) GetProgressPercent() int32 {
	if x != nil {
		return x.ProgressPercent
	}
	return 0
}

func (x *CutoverJob) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *CutoverJob) GetStateMessage() string {
	if x != nil {
		return x.StateMessage
	}
	return ""
}

func (x *CutoverJob) GetSteps() []*CutoverStep {
	if x != nil {
		return x.Steps
	}
	return nil
}

type isCutoverJob_TargetVmDetails interface {
	isCutoverJob_TargetVmDetails()
}

type CutoverJob_ComputeEngineTargetDetails struct {
	// Output only. Details of the target VM in Compute Engine.
	ComputeEngineTargetDetails *ComputeEngineTargetDetails `protobuf:"bytes,14,opt,name=compute_engine_target_details,json=computeEngineTargetDetails,proto3,oneof"`
}

type CutoverJob_ComputeEngineDisksTargetDetails struct {
	// Output only. Details of the target Persistent Disks in Compute Engine.
	ComputeEngineDisksTargetDetails *ComputeEngineDisksTargetDetails `protobuf:"bytes,20,opt,name=compute_engine_disks_target_details,json=computeEngineDisksTargetDetails,proto3,oneof"`
}

func (*CutoverJob_ComputeEngineTargetDetails) isCutoverJob_TargetVmDetails() {}

func (*CutoverJob_ComputeEngineDisksTargetDetails) isCutoverJob_TargetVmDetails() {}

// CutoverStep holds information about the cutover step progress.
type CutoverStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Step:
	//
	//	*CutoverStep_PreviousReplicationCycle
	//	*CutoverStep_ShuttingDownSourceVm
	//	*CutoverStep_FinalSync
	//	*CutoverStep_PreparingVmDisks
	//	*CutoverStep_InstantiatingMigratedVm
	Step isCutoverStep_Step `protobuf_oneof:"step"`
	// The time the step has started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the step has ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *CutoverStep) Reset() {
	*x = CutoverStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CutoverStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CutoverStep) ProtoMessage() {}

func (x *CutoverStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CutoverStep.ProtoReflect.Descriptor instead.
func (*CutoverStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{14}
}

func (m *CutoverStep) GetStep() isCutoverStep_Step {
	if m != nil {
		return m.Step
	}
	return nil
}

func (x *CutoverStep) GetPreviousReplicationCycle() *ReplicationCycle {
	if x, ok := x.GetStep().(*CutoverStep_PreviousReplicationCycle); ok {
		return x.PreviousReplicationCycle
	}
	return nil
}

func (x *CutoverStep) GetShuttingDownSourceVm() *ShuttingDownSourceVMStep {
	if x, ok := x.GetStep().(*CutoverStep_ShuttingDownSourceVm); ok {
		return x.ShuttingDownSourceVm
	}
	return nil
}

func (x *CutoverStep) GetFinalSync() *ReplicationCycle {
	if x, ok := x.GetStep().(*CutoverStep_FinalSync); ok {
		return x.FinalSync
	}
	return nil
}

func (x *CutoverStep) GetPreparingVmDisks() *PreparingVMDisksStep {
	if x, ok := x.GetStep().(*CutoverStep_PreparingVmDisks); ok {
		return x.PreparingVmDisks
	}
	return nil
}

func (x *CutoverStep) GetInstantiatingMigratedVm() *InstantiatingMigratedVMStep {
	if x, ok := x.GetStep().(*CutoverStep_InstantiatingMigratedVm); ok {
		return x.InstantiatingMigratedVm
	}
	return nil
}

func (x *CutoverStep) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *CutoverStep) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isCutoverStep_Step interface {
	isCutoverStep_Step()
}

type CutoverStep_PreviousReplicationCycle struct {
	// A replication cycle prior cutover step.
	PreviousReplicationCycle *ReplicationCycle `protobuf:"bytes,3,opt,name=previous_replication_cycle,json=previousReplicationCycle,proto3,oneof"`
}

type CutoverStep_ShuttingDownSourceVm struct {
	// Shutting down VM step.
	ShuttingDownSourceVm *ShuttingDownSourceVMStep `protobuf:"bytes,4,opt,name=shutting_down_source_vm,json=shuttingDownSourceVm,proto3,oneof"`
}

type CutoverStep_FinalSync struct {
	// Final sync step.
	FinalSync *ReplicationCycle `protobuf:"bytes,5,opt,name=final_sync,json=finalSync,proto3,oneof"`
}

type CutoverStep_PreparingVmDisks struct {
	// Preparing VM disks step.
	PreparingVmDisks *PreparingVMDisksStep `protobuf:"bytes,6,opt,name=preparing_vm_disks,json=preparingVmDisks,proto3,oneof"`
}

type CutoverStep_InstantiatingMigratedVm struct {
	// Instantiating migrated VM step.
	InstantiatingMigratedVm *InstantiatingMigratedVMStep `protobuf:"bytes,7,opt,name=instantiating_migrated_vm,json=instantiatingMigratedVm,proto3,oneof"`
}

func (*CutoverStep_PreviousReplicationCycle) isCutoverStep_Step() {}

func (*CutoverStep_ShuttingDownSourceVm) isCutoverStep_Step() {}

func (*CutoverStep_FinalSync) isCutoverStep_Step() {}

func (*CutoverStep_PreparingVmDisks) isCutoverStep_Step() {}

func (*CutoverStep_InstantiatingMigratedVm) isCutoverStep_Step() {}

// ShuttingDownSourceVMStep contains specific step details.
type ShuttingDownSourceVMStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ShuttingDownSourceVMStep) Reset() {
	*x = ShuttingDownSourceVMStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShuttingDownSourceVMStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShuttingDownSourceVMStep) ProtoMessage() {}

func (x *ShuttingDownSourceVMStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShuttingDownSourceVMStep.ProtoReflect.Descriptor instead.
func (*ShuttingDownSourceVMStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{15}
}

// Request message for 'CreateCloneJob' request.
type CreateCloneJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Clone's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The clone job identifier.
	CloneJobId string `protobuf:"bytes,2,opt,name=clone_job_id,json=cloneJobId,proto3" json:"clone_job_id,omitempty"`
	// Required. The clone request body.
	CloneJob *CloneJob `protobuf:"bytes,3,opt,name=clone_job,json=cloneJob,proto3" json:"clone_job,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateCloneJobRequest) Reset() {
	*x = CreateCloneJobRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCloneJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCloneJobRequest) ProtoMessage() {}

func (x *CreateCloneJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCloneJobRequest.ProtoReflect.Descriptor instead.
func (*CreateCloneJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{16}
}

func (x *CreateCloneJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCloneJobRequest) GetCloneJobId() string {
	if x != nil {
		return x.CloneJobId
	}
	return ""
}

func (x *CreateCloneJobRequest) GetCloneJob() *CloneJob {
	if x != nil {
		return x.CloneJob
	}
	return nil
}

func (x *CreateCloneJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'CancelCloneJob' request.
type CancelCloneJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The clone job id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelCloneJobRequest) Reset() {
	*x = CancelCloneJobRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelCloneJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelCloneJobRequest) ProtoMessage() {}

func (x *CancelCloneJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelCloneJobRequest.ProtoReflect.Descriptor instead.
func (*CancelCloneJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{17}
}

func (x *CancelCloneJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for 'CancelCloneJob' request.
type CancelCloneJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CancelCloneJobResponse) Reset() {
	*x = CancelCloneJobResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelCloneJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelCloneJobResponse) ProtoMessage() {}

func (x *CancelCloneJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelCloneJobResponse.ProtoReflect.Descriptor instead.
func (*CancelCloneJobResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{18}
}

// Request message for 'ListCloneJobsRequest' request.
type ListCloneJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of source VMs.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of clone jobs to return. The service may
	// return fewer than this value. If unspecified, at most 500 clone jobs will
	// be returned. The maximum value is 1000; values above 1000 will be coerced
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListCloneJobs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCloneJobs` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListCloneJobsRequest) Reset() {
	*x = ListCloneJobsRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCloneJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloneJobsRequest) ProtoMessage() {}

func (x *ListCloneJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloneJobsRequest.ProtoReflect.Descriptor instead.
func (*ListCloneJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{19}
}

func (x *ListCloneJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCloneJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCloneJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCloneJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCloneJobsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListCloneJobs' request.
type ListCloneJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of clone jobs response.
	CloneJobs []*CloneJob `protobuf:"bytes,1,rep,name=clone_jobs,json=cloneJobs,proto3" json:"clone_jobs,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListCloneJobsResponse) Reset() {
	*x = ListCloneJobsResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCloneJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCloneJobsResponse) ProtoMessage() {}

func (x *ListCloneJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCloneJobsResponse.ProtoReflect.Descriptor instead.
func (*ListCloneJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{20}
}

func (x *ListCloneJobsResponse) GetCloneJobs() []*CloneJob {
	if x != nil {
		return x.CloneJobs
	}
	return nil
}

func (x *ListCloneJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCloneJobsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetCloneJob' request.
type GetCloneJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CloneJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCloneJobRequest) Reset() {
	*x = GetCloneJobRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCloneJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCloneJobRequest) ProtoMessage() {}

func (x *GetCloneJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCloneJobRequest.ProtoReflect.Descriptor instead.
func (*GetCloneJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{21}
}

func (x *GetCloneJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Source message describes a specific vm migration Source resource. It contains
// the source environment information.
type Source struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SourceDetails:
	//
	//	*Source_Vmware
	//	*Source_Aws
	//	*Source_Azure
	SourceDetails isSource_SourceDetails `protobuf_oneof:"source_details"`
	// Output only. The Source name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The create time timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The labels of the source.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// User-provided description of the source.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Immutable. The encryption details of the source data stored by
	// the service.
	Encryption *Encryption `protobuf:"bytes,14,opt,name=encryption,proto3" json:"encryption,omitempty"`
}

func (x *Source) Reset() {
	*x = Source{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Source) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Source) ProtoMessage() {}

func (x *Source) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Source.ProtoReflect.Descriptor instead.
func (*Source) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{22}
}

func (m *Source) GetSourceDetails() isSource_SourceDetails {
	if m != nil {
		return m.SourceDetails
	}
	return nil
}

func (x *Source) GetVmware() *VmwareSourceDetails {
	if x, ok := x.GetSourceDetails().(*Source_Vmware); ok {
		return x.Vmware
	}
	return nil
}

func (x *Source) GetAws() *AwsSourceDetails {
	if x, ok := x.GetSourceDetails().(*Source_Aws); ok {
		return x.Aws
	}
	return nil
}

func (x *Source) GetAzure() *AzureSourceDetails {
	if x, ok := x.GetSourceDetails().(*Source_Azure); ok {
		return x.Azure
	}
	return nil
}

func (x *Source) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Source) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Source) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Source) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Source) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Source) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

type isSource_SourceDetails interface {
	isSource_SourceDetails()
}

type Source_Vmware struct {
	// Vmware type source details.
	Vmware *VmwareSourceDetails `protobuf:"bytes,10,opt,name=vmware,proto3,oneof"`
}

type Source_Aws struct {
	// AWS type source details.
	Aws *AwsSourceDetails `protobuf:"bytes,12,opt,name=aws,proto3,oneof"`
}

type Source_Azure struct {
	// Azure type source details.
	Azure *AzureSourceDetails `protobuf:"bytes,13,opt,name=azure,proto3,oneof"`
}

func (*Source_Vmware) isSource_SourceDetails() {}

func (*Source_Aws) isSource_SourceDetails() {}

func (*Source_Azure) isSource_SourceDetails() {}

// Encryption message describes the details of the applied encryption.
type Encryption struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the encryption key that is stored in Google Cloud
	// KMS.
	KmsKey string `protobuf:"bytes,1,opt,name=kms_key,json=kmsKey,proto3" json:"kms_key,omitempty"`
}

func (x *Encryption) Reset() {
	*x = Encryption{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Encryption) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Encryption) ProtoMessage() {}

func (x *Encryption) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Encryption.ProtoReflect.Descriptor instead.
func (*Encryption) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{23}
}

func (x *Encryption) GetKmsKey() string {
	if x != nil {
		return x.KmsKey
	}
	return ""
}

// VmwareSourceDetails message describes a specific source details for the
// vmware source type.
type VmwareSourceDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The credentials username.
	Username string `protobuf:"bytes,1,opt,name=username,proto3" json:"username,omitempty"`
	// Input only. The credentials password. This is write only and can not be
	// read in a GET operation.
	Password string `protobuf:"bytes,2,opt,name=password,proto3" json:"password,omitempty"`
	// The ip address of the vcenter this Source represents.
	VcenterIp string `protobuf:"bytes,3,opt,name=vcenter_ip,json=vcenterIp,proto3" json:"vcenter_ip,omitempty"`
	// The thumbprint representing the certificate for the vcenter.
	Thumbprint string `protobuf:"bytes,4,opt,name=thumbprint,proto3" json:"thumbprint,omitempty"`
	// The hostname of the vcenter.
	ResolvedVcenterHost string `protobuf:"bytes,5,opt,name=resolved_vcenter_host,json=resolvedVcenterHost,proto3" json:"resolved_vcenter_host,omitempty"`
}

func (x *VmwareSourceDetails) Reset() {
	*x = VmwareSourceDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VmwareSourceDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareSourceDetails) ProtoMessage() {}

func (x *VmwareSourceDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareSourceDetails.ProtoReflect.Descriptor instead.
func (*VmwareSourceDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{24}
}

func (x *VmwareSourceDetails) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *VmwareSourceDetails) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *VmwareSourceDetails) GetVcenterIp() string {
	if x != nil {
		return x.VcenterIp
	}
	return ""
}

func (x *VmwareSourceDetails) GetThumbprint() string {
	if x != nil {
		return x.Thumbprint
	}
	return ""
}

func (x *VmwareSourceDetails) GetResolvedVcenterHost() string {
	if x != nil {
		return x.ResolvedVcenterHost
	}
	return ""
}

// AwsSourceDetails message describes a specific source details for the
// AWS source type.
type AwsSourceDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to CredentialsType:
	//
	//	*AwsSourceDetails_AccessKeyCreds
	CredentialsType isAwsSourceDetails_CredentialsType `protobuf_oneof:"credentials_type"`
	// Immutable. The AWS region that the source VMs will be migrated from.
	AwsRegion string `protobuf:"bytes,3,opt,name=aws_region,json=awsRegion,proto3" json:"aws_region,omitempty"`
	// Output only. State of the source as determined by the health check.
	State AwsSourceDetails_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.AwsSourceDetails_State" json:"state,omitempty"`
	// Output only. Provides details on the state of the Source in case of an
	// error.
	Error *status.Status `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	// AWS resource tags to limit the scope of the source inventory.
	InventoryTagList []*AwsSourceDetails_Tag `protobuf:"bytes,10,rep,name=inventory_tag_list,json=inventoryTagList,proto3" json:"inventory_tag_list,omitempty"`
	// AWS security group names to limit the scope of the source
	// inventory.
	InventorySecurityGroupNames []string `protobuf:"bytes,7,rep,name=inventory_security_group_names,json=inventorySecurityGroupNames,proto3" json:"inventory_security_group_names,omitempty"`
	// User specified tags to add to every M2VM generated resource in AWS.
	// These tags will be set in addition to the default tags that are set as part
	// of the migration process. The tags must not begin with the reserved prefix
	// `m2vm`.
	MigrationResourcesUserTags map[string]string `protobuf:"bytes,8,rep,name=migration_resources_user_tags,json=migrationResourcesUserTags,proto3" json:"migration_resources_user_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The source's public IP. All communication initiated by this
	// source will originate from this IP.
	PublicIp string `protobuf:"bytes,9,opt,name=public_ip,json=publicIp,proto3" json:"public_ip,omitempty"`
}

func (x *AwsSourceDetails) Reset() {
	*x = AwsSourceDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AwsSourceDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsSourceDetails) ProtoMessage() {}

func (x *AwsSourceDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsSourceDetails.ProtoReflect.Descriptor instead.
func (*AwsSourceDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{25}
}

func (m *AwsSourceDetails) GetCredentialsType() isAwsSourceDetails_CredentialsType {
	if m != nil {
		return m.CredentialsType
	}
	return nil
}

func (x *AwsSourceDetails) GetAccessKeyCreds() *AwsSourceDetails_AccessKeyCredentials {
	if x, ok := x.GetCredentialsType().(*AwsSourceDetails_AccessKeyCreds); ok {
		return x.AccessKeyCreds
	}
	return nil
}

func (x *AwsSourceDetails) GetAwsRegion() string {
	if x != nil {
		return x.AwsRegion
	}
	return ""
}

func (x *AwsSourceDetails) GetState() AwsSourceDetails_State {
	if x != nil {
		return x.State
	}
	return AwsSourceDetails_STATE_UNSPECIFIED
}

func (x *AwsSourceDetails) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *AwsSourceDetails) GetInventoryTagList() []*AwsSourceDetails_Tag {
	if x != nil {
		return x.InventoryTagList
	}
	return nil
}

func (x *AwsSourceDetails) GetInventorySecurityGroupNames() []string {
	if x != nil {
		return x.InventorySecurityGroupNames
	}
	return nil
}

func (x *AwsSourceDetails) GetMigrationResourcesUserTags() map[string]string {
	if x != nil {
		return x.MigrationResourcesUserTags
	}
	return nil
}

func (x *AwsSourceDetails) GetPublicIp() string {
	if x != nil {
		return x.PublicIp
	}
	return ""
}

type isAwsSourceDetails_CredentialsType interface {
	isAwsSourceDetails_CredentialsType()
}

type AwsSourceDetails_AccessKeyCreds struct {
	// AWS Credentials using access key id and secret.
	AccessKeyCreds *AwsSourceDetails_AccessKeyCredentials `protobuf:"bytes,11,opt,name=access_key_creds,json=accessKeyCreds,proto3,oneof"`
}

func (*AwsSourceDetails_AccessKeyCreds) isAwsSourceDetails_CredentialsType() {}

// AzureSourceDetails message describes a specific source details for the
// Azure source type.
type AzureSourceDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to CredentialsType:
	//
	//	*AzureSourceDetails_ClientSecretCreds
	CredentialsType isAzureSourceDetails_CredentialsType `protobuf_oneof:"credentials_type"`
	// Immutable. Azure subscription ID.
	SubscriptionId string `protobuf:"bytes,1,opt,name=subscription_id,json=subscriptionId,proto3" json:"subscription_id,omitempty"`
	// Immutable. The Azure location (region) that the source VMs will be migrated
	// from.
	AzureLocation string `protobuf:"bytes,5,opt,name=azure_location,json=azureLocation,proto3" json:"azure_location,omitempty"`
	// Output only. State of the source as determined by the health check.
	State AzureSourceDetails_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.AzureSourceDetails_State" json:"state,omitempty"`
	// Output only. Provides details on the state of the Source in case of an
	// error.
	Error *status.Status `protobuf:"bytes,7,opt,name=error,proto3" json:"error,omitempty"`
	// User specified tags to add to every M2VM generated resource in Azure.
	// These tags will be set in addition to the default tags that are set as part
	// of the migration process. The tags must not begin with the reserved prefix
	// `m4ce` or `m2vm`.
	MigrationResourcesUserTags map[string]string `protobuf:"bytes,8,rep,name=migration_resources_user_tags,json=migrationResourcesUserTags,proto3" json:"migration_resources_user_tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The ID of the Azure resource group that contains all resources
	// related to the migration process of this source.
	ResourceGroupId string `protobuf:"bytes,10,opt,name=resource_group_id,json=resourceGroupId,proto3" json:"resource_group_id,omitempty"`
}

func (x *AzureSourceDetails) Reset() {
	*x = AzureSourceDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AzureSourceDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureSourceDetails) ProtoMessage() {}

func (x *AzureSourceDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureSourceDetails.ProtoReflect.Descriptor instead.
func (*AzureSourceDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{26}
}

func (m *AzureSourceDetails) GetCredentialsType() isAzureSourceDetails_CredentialsType {
	if m != nil {
		return m.CredentialsType
	}
	return nil
}

func (x *AzureSourceDetails) GetClientSecretCreds() *AzureSourceDetails_ClientSecretCredentials {
	if x, ok := x.GetCredentialsType().(*AzureSourceDetails_ClientSecretCreds); ok {
		return x.ClientSecretCreds
	}
	return nil
}

func (x *AzureSourceDetails) GetSubscriptionId() string {
	if x != nil {
		return x.SubscriptionId
	}
	return ""
}

func (x *AzureSourceDetails) GetAzureLocation() string {
	if x != nil {
		return x.AzureLocation
	}
	return ""
}

func (x *AzureSourceDetails) GetState() AzureSourceDetails_State {
	if x != nil {
		return x.State
	}
	return AzureSourceDetails_STATE_UNSPECIFIED
}

func (x *AzureSourceDetails) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *AzureSourceDetails) GetMigrationResourcesUserTags() map[string]string {
	if x != nil {
		return x.MigrationResourcesUserTags
	}
	return nil
}

func (x *AzureSourceDetails) GetResourceGroupId() string {
	if x != nil {
		return x.ResourceGroupId
	}
	return ""
}

type isAzureSourceDetails_CredentialsType interface {
	isAzureSourceDetails_CredentialsType()
}

type AzureSourceDetails_ClientSecretCreds struct {
	// Azure Credentials using tenant ID, client ID and secret.
	ClientSecretCreds *AzureSourceDetails_ClientSecretCredentials `protobuf:"bytes,9,opt,name=client_secret_creds,json=clientSecretCreds,proto3,oneof"`
}

func (*AzureSourceDetails_ClientSecretCreds) isAzureSourceDetails_CredentialsType() {}

// DatacenterConnector message describes a connector between the Source and
// Google Cloud, which is installed on a vmware datacenter (an OVA vm installed
// by the user) to connect the Datacenter to Google Cloud and support vm
// migration data transfer.
type DatacenterConnector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the connector was created (as an API call, not when
	// it was actually installed).
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last time the connector was updated with an API call.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. The connector's name.
	Name string `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	// Immutable. A unique key for this connector. This key is internal to the OVA
	// connector and is supplied with its creation during the registration process
	// and can not be modified.
	RegistrationId string `protobuf:"bytes,12,opt,name=registration_id,json=registrationId,proto3" json:"registration_id,omitempty"`
	// The service account to use in the connector when communicating with the
	// cloud.
	ServiceAccount string `protobuf:"bytes,5,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// The version running in the DatacenterConnector. This is supplied by the OVA
	// connector during the registration process and can not be modified.
	Version string `protobuf:"bytes,6,opt,name=version,proto3" json:"version,omitempty"`
	// Output only. The communication channel between the datacenter connector and
	// Google Cloud.
	Bucket string `protobuf:"bytes,10,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Output only. State of the DatacenterConnector, as determined by the health
	// checks.
	State DatacenterConnector_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.DatacenterConnector_State" json:"state,omitempty"`
	// Output only. The time the state was last set.
	StateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=state_time,json=stateTime,proto3" json:"state_time,omitempty"`
	// Output only. Provides details on the state of the Datacenter Connector in
	// case of an error.
	Error *status.Status `protobuf:"bytes,11,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. Appliance OVA version.
	// This is the OVA which is manually installed by the user and contains the
	// infrastructure for the automatically updatable components on the appliance.
	ApplianceInfrastructureVersion string `protobuf:"bytes,13,opt,name=appliance_infrastructure_version,json=applianceInfrastructureVersion,proto3" json:"appliance_infrastructure_version,omitempty"`
	// Output only. Appliance last installed update bundle version.
	// This is the version of the automatically updatable components on the
	// appliance.
	ApplianceSoftwareVersion string `protobuf:"bytes,14,opt,name=appliance_software_version,json=applianceSoftwareVersion,proto3" json:"appliance_software_version,omitempty"`
	// Output only. The available versions for updating this appliance.
	AvailableVersions *AvailableUpdates `protobuf:"bytes,15,opt,name=available_versions,json=availableVersions,proto3" json:"available_versions,omitempty"`
	// Output only. The status of the current / last upgradeAppliance operation.
	UpgradeStatus *UpgradeStatus `protobuf:"bytes,16,opt,name=upgrade_status,json=upgradeStatus,proto3" json:"upgrade_status,omitempty"`
}

func (x *DatacenterConnector) Reset() {
	*x = DatacenterConnector{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DatacenterConnector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DatacenterConnector) ProtoMessage() {}

func (x *DatacenterConnector) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DatacenterConnector.ProtoReflect.Descriptor instead.
func (*DatacenterConnector) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{27}
}

func (x *DatacenterConnector) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DatacenterConnector) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DatacenterConnector) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DatacenterConnector) GetRegistrationId() string {
	if x != nil {
		return x.RegistrationId
	}
	return ""
}

func (x *DatacenterConnector) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *DatacenterConnector) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *DatacenterConnector) GetBucket() string {
	if x != nil {
		return x.Bucket
	}
	return ""
}

func (x *DatacenterConnector) GetState() DatacenterConnector_State {
	if x != nil {
		return x.State
	}
	return DatacenterConnector_STATE_UNSPECIFIED
}

func (x *DatacenterConnector) GetStateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StateTime
	}
	return nil
}

func (x *DatacenterConnector) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *DatacenterConnector) GetApplianceInfrastructureVersion() string {
	if x != nil {
		return x.ApplianceInfrastructureVersion
	}
	return ""
}

func (x *DatacenterConnector) GetApplianceSoftwareVersion() string {
	if x != nil {
		return x.ApplianceSoftwareVersion
	}
	return ""
}

func (x *DatacenterConnector) GetAvailableVersions() *AvailableUpdates {
	if x != nil {
		return x.AvailableVersions
	}
	return nil
}

func (x *DatacenterConnector) GetUpgradeStatus() *UpgradeStatus {
	if x != nil {
		return x.UpgradeStatus
	}
	return nil
}

// UpgradeStatus contains information about upgradeAppliance operation.
type UpgradeStatus struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The version to upgrade to.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// The state of the upgradeAppliance operation.
	State UpgradeStatus_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.UpgradeStatus_State" json:"state,omitempty"`
	// Output only. Provides details on the state of the upgrade operation in case
	// of an error.
	Error *status.Status `protobuf:"bytes,3,opt,name=error,proto3" json:"error,omitempty"`
	// The time the operation was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The version from which we upgraded.
	PreviousVersion string `protobuf:"bytes,5,opt,name=previous_version,json=previousVersion,proto3" json:"previous_version,omitempty"`
}

func (x *UpgradeStatus) Reset() {
	*x = UpgradeStatus{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeStatus) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeStatus) ProtoMessage() {}

func (x *UpgradeStatus) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeStatus.ProtoReflect.Descriptor instead.
func (*UpgradeStatus) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{28}
}

func (x *UpgradeStatus) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *UpgradeStatus) GetState() UpgradeStatus_State {
	if x != nil {
		return x.State
	}
	return UpgradeStatus_STATE_UNSPECIFIED
}

func (x *UpgradeStatus) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *UpgradeStatus) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *UpgradeStatus) GetPreviousVersion() string {
	if x != nil {
		return x.PreviousVersion
	}
	return ""
}

// Holds information about the available versions for upgrade.
type AvailableUpdates struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The newest deployable version of the appliance.
	// The current appliance can't be updated into this version, and the owner
	// must manually deploy this OVA to a new appliance.
	NewDeployableAppliance *ApplianceVersion `protobuf:"bytes,1,opt,name=new_deployable_appliance,json=newDeployableAppliance,proto3" json:"new_deployable_appliance,omitempty"`
	// The latest version for in place update.
	// The current appliance can be updated to this version using the API or m4c
	// CLI.
	InPlaceUpdate *ApplianceVersion `protobuf:"bytes,2,opt,name=in_place_update,json=inPlaceUpdate,proto3" json:"in_place_update,omitempty"`
}

func (x *AvailableUpdates) Reset() {
	*x = AvailableUpdates{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AvailableUpdates) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AvailableUpdates) ProtoMessage() {}

func (x *AvailableUpdates) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AvailableUpdates.ProtoReflect.Descriptor instead.
func (*AvailableUpdates) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{29}
}

func (x *AvailableUpdates) GetNewDeployableAppliance() *ApplianceVersion {
	if x != nil {
		return x.NewDeployableAppliance
	}
	return nil
}

func (x *AvailableUpdates) GetInPlaceUpdate() *ApplianceVersion {
	if x != nil {
		return x.InPlaceUpdate
	}
	return nil
}

// Describes an appliance version.
type ApplianceVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The appliance version.
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// A link for downloading the version.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Determine whether it's critical to upgrade the appliance to this version.
	Critical bool `protobuf:"varint,3,opt,name=critical,proto3" json:"critical,omitempty"`
	// Link to a page that contains the version release notes.
	ReleaseNotesUri string `protobuf:"bytes,4,opt,name=release_notes_uri,json=releaseNotesUri,proto3" json:"release_notes_uri,omitempty"`
}

func (x *ApplianceVersion) Reset() {
	*x = ApplianceVersion{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApplianceVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplianceVersion) ProtoMessage() {}

func (x *ApplianceVersion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplianceVersion.ProtoReflect.Descriptor instead.
func (*ApplianceVersion) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{30}
}

func (x *ApplianceVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *ApplianceVersion) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *ApplianceVersion) GetCritical() bool {
	if x != nil {
		return x.Critical
	}
	return false
}

func (x *ApplianceVersion) GetReleaseNotesUri() string {
	if x != nil {
		return x.ReleaseNotesUri
	}
	return ""
}

// Request message for 'ListSources' request.
type ListSourcesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of sources.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of sources to return. The service may return
	// fewer than this value. If unspecified, at most 500 sources will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListSources` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListSources` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListSourcesRequest) Reset() {
	*x = ListSourcesRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSourcesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSourcesRequest) ProtoMessage() {}

func (x *ListSourcesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSourcesRequest.ProtoReflect.Descriptor instead.
func (*ListSourcesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{31}
}

func (x *ListSourcesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSourcesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSourcesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSourcesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListSourcesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListSources' request.
type ListSourcesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of sources response.
	Sources []*Source `protobuf:"bytes,1,rep,name=sources,proto3" json:"sources,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListSourcesResponse) Reset() {
	*x = ListSourcesResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSourcesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSourcesResponse) ProtoMessage() {}

func (x *ListSourcesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSourcesResponse.ProtoReflect.Descriptor instead.
func (*ListSourcesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{32}
}

func (x *ListSourcesResponse) GetSources() []*Source {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *ListSourcesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListSourcesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetSource' request.
type GetSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Source name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSourceRequest) Reset() {
	*x = GetSourceRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSourceRequest) ProtoMessage() {}

func (x *GetSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSourceRequest.ProtoReflect.Descriptor instead.
func (*GetSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{33}
}

func (x *GetSourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'CreateSource' request.
type CreateSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Source's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The source identifier.
	SourceId string `protobuf:"bytes,2,opt,name=source_id,json=sourceId,proto3" json:"source_id,omitempty"`
	// Required. The create request body.
	Source *Source `protobuf:"bytes,3,opt,name=source,proto3" json:"source,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateSourceRequest) Reset() {
	*x = CreateSourceRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSourceRequest) ProtoMessage() {}

func (x *CreateSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSourceRequest.ProtoReflect.Descriptor instead.
func (*CreateSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{34}
}

func (x *CreateSourceRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSourceRequest) GetSourceId() string {
	if x != nil {
		return x.SourceId
	}
	return ""
}

func (x *CreateSourceRequest) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *CreateSourceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Update message for 'UpdateSources' request.
type UpdateSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Field mask is used to specify the fields to be overwritten in the
	// Source resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The update request body.
	Source *Source `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateSourceRequest) Reset() {
	*x = UpdateSourceRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSourceRequest) ProtoMessage() {}

func (x *UpdateSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSourceRequest.ProtoReflect.Descriptor instead.
func (*UpdateSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{35}
}

func (x *UpdateSourceRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateSourceRequest) GetSource() *Source {
	if x != nil {
		return x.Source
	}
	return nil
}

func (x *UpdateSourceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteSource' request.
type DeleteSourceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Source name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteSourceRequest) Reset() {
	*x = DeleteSourceRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteSourceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSourceRequest) ProtoMessage() {}

func (x *DeleteSourceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSourceRequest.ProtoReflect.Descriptor instead.
func (*DeleteSourceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{36}
}

func (x *DeleteSourceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteSourceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for
// [fetchInventory][google.cloud.vmmigration.v1.VmMigration.FetchInventory].
type FetchInventoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Source.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// If this flag is set to true, the source will be queried instead of using
	// cached results. Using this flag will make the call slower.
	ForceRefresh bool `protobuf:"varint,2,opt,name=force_refresh,json=forceRefresh,proto3" json:"force_refresh,omitempty"`
}

func (x *FetchInventoryRequest) Reset() {
	*x = FetchInventoryRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchInventoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchInventoryRequest) ProtoMessage() {}

func (x *FetchInventoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchInventoryRequest.ProtoReflect.Descriptor instead.
func (*FetchInventoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{37}
}

func (x *FetchInventoryRequest) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *FetchInventoryRequest) GetForceRefresh() bool {
	if x != nil {
		return x.ForceRefresh
	}
	return false
}

// VmwareVmDetails describes a VM in vCenter.
type VmwareVmDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The VM's id in the source (note that this is not the MigratingVm's id).
	// This is the moref id of the VM.
	VmId string `protobuf:"bytes,1,opt,name=vm_id,json=vmId,proto3" json:"vm_id,omitempty"`
	// The id of the vCenter's datacenter this VM is contained in.
	DatacenterId string `protobuf:"bytes,2,opt,name=datacenter_id,json=datacenterId,proto3" json:"datacenter_id,omitempty"`
	// The descriptive name of the vCenter's datacenter this VM is contained in.
	DatacenterDescription string `protobuf:"bytes,3,opt,name=datacenter_description,json=datacenterDescription,proto3" json:"datacenter_description,omitempty"`
	// The unique identifier of the VM in vCenter.
	Uuid string `protobuf:"bytes,4,opt,name=uuid,proto3" json:"uuid,omitempty"`
	// The display name of the VM. Note that this is not necessarily unique.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The power state of the VM at the moment list was taken.
	PowerState VmwareVmDetails_PowerState `protobuf:"varint,6,opt,name=power_state,json=powerState,proto3,enum=google.cloud.vmmigration.v1.VmwareVmDetails_PowerState" json:"power_state,omitempty"`
	// The number of cpus in the VM.
	CpuCount int32 `protobuf:"varint,7,opt,name=cpu_count,json=cpuCount,proto3" json:"cpu_count,omitempty"`
	// The size of the memory of the VM in MB.
	MemoryMb int32 `protobuf:"varint,8,opt,name=memory_mb,json=memoryMb,proto3" json:"memory_mb,omitempty"`
	// The number of disks the VM has.
	DiskCount int32 `protobuf:"varint,9,opt,name=disk_count,json=diskCount,proto3" json:"disk_count,omitempty"`
	// The total size of the storage allocated to the VM in MB.
	CommittedStorageMb int64 `protobuf:"varint,12,opt,name=committed_storage_mb,json=committedStorageMb,proto3" json:"committed_storage_mb,omitempty"`
	// The VM's OS. See for example
	// https://vdc-repo.vmware.com/vmwb-repository/dcr-public/da47f910-60ac-438b-8b9b-6122f4d14524/16b7274a-bf8b-4b4c-a05e-746f2aa93c8c/doc/vim.vm.GuestOsDescriptor.GuestOsIdentifier.html
	// for types of strings this might hold.
	GuestDescription string `protobuf:"bytes,11,opt,name=guest_description,json=guestDescription,proto3" json:"guest_description,omitempty"`
	// Output only. The VM Boot Option.
	BootOption VmwareVmDetails_BootOption `protobuf:"varint,13,opt,name=boot_option,json=bootOption,proto3,enum=google.cloud.vmmigration.v1.VmwareVmDetails_BootOption" json:"boot_option,omitempty"`
	// Output only. The CPU architecture.
	Architecture VmwareVmDetails_VmArchitecture `protobuf:"varint,14,opt,name=architecture,proto3,enum=google.cloud.vmmigration.v1.VmwareVmDetails_VmArchitecture" json:"architecture,omitempty"`
}

func (x *VmwareVmDetails) Reset() {
	*x = VmwareVmDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VmwareVmDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareVmDetails) ProtoMessage() {}

func (x *VmwareVmDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareVmDetails.ProtoReflect.Descriptor instead.
func (*VmwareVmDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{38}
}

func (x *VmwareVmDetails) GetVmId() string {
	if x != nil {
		return x.VmId
	}
	return ""
}

func (x *VmwareVmDetails) GetDatacenterId() string {
	if x != nil {
		return x.DatacenterId
	}
	return ""
}

func (x *VmwareVmDetails) GetDatacenterDescription() string {
	if x != nil {
		return x.DatacenterDescription
	}
	return ""
}

func (x *VmwareVmDetails) GetUuid() string {
	if x != nil {
		return x.Uuid
	}
	return ""
}

func (x *VmwareVmDetails) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *VmwareVmDetails) GetPowerState() VmwareVmDetails_PowerState {
	if x != nil {
		return x.PowerState
	}
	return VmwareVmDetails_POWER_STATE_UNSPECIFIED
}

func (x *VmwareVmDetails) GetCpuCount() int32 {
	if x != nil {
		return x.CpuCount
	}
	return 0
}

func (x *VmwareVmDetails) GetMemoryMb() int32 {
	if x != nil {
		return x.MemoryMb
	}
	return 0
}

func (x *VmwareVmDetails) GetDiskCount() int32 {
	if x != nil {
		return x.DiskCount
	}
	return 0
}

func (x *VmwareVmDetails) GetCommittedStorageMb() int64 {
	if x != nil {
		return x.CommittedStorageMb
	}
	return 0
}

func (x *VmwareVmDetails) GetGuestDescription() string {
	if x != nil {
		return x.GuestDescription
	}
	return ""
}

func (x *VmwareVmDetails) GetBootOption() VmwareVmDetails_BootOption {
	if x != nil {
		return x.BootOption
	}
	return VmwareVmDetails_BOOT_OPTION_UNSPECIFIED
}

func (x *VmwareVmDetails) GetArchitecture() VmwareVmDetails_VmArchitecture {
	if x != nil {
		return x.Architecture
	}
	return VmwareVmDetails_VM_ARCHITECTURE_UNSPECIFIED
}

// AwsVmDetails describes a VM in AWS.
type AwsVmDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The VM ID in AWS.
	VmId string `protobuf:"bytes,1,opt,name=vm_id,json=vmId,proto3" json:"vm_id,omitempty"`
	// The display name of the VM. Note that this value is not necessarily unique.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// The id of the AWS's source this VM is connected to.
	SourceId string `protobuf:"bytes,3,opt,name=source_id,json=sourceId,proto3" json:"source_id,omitempty"`
	// The descriptive name of the AWS's source this VM is connected to.
	SourceDescription string `protobuf:"bytes,4,opt,name=source_description,json=sourceDescription,proto3" json:"source_description,omitempty"`
	// Output only. The power state of the VM at the moment list was taken.
	PowerState AwsVmDetails_PowerState `protobuf:"varint,5,opt,name=power_state,json=powerState,proto3,enum=google.cloud.vmmigration.v1.AwsVmDetails_PowerState" json:"power_state,omitempty"`
	// The number of CPU cores the VM has.
	CpuCount int32 `protobuf:"varint,6,opt,name=cpu_count,json=cpuCount,proto3" json:"cpu_count,omitempty"`
	// The memory size of the VM in MB.
	MemoryMb int32 `protobuf:"varint,7,opt,name=memory_mb,json=memoryMb,proto3" json:"memory_mb,omitempty"`
	// The number of disks the VM has.
	DiskCount int32 `protobuf:"varint,8,opt,name=disk_count,json=diskCount,proto3" json:"disk_count,omitempty"`
	// The total size of the storage allocated to the VM in MB.
	CommittedStorageMb int64 `protobuf:"varint,9,opt,name=committed_storage_mb,json=committedStorageMb,proto3" json:"committed_storage_mb,omitempty"`
	// The VM's OS.
	OsDescription string `protobuf:"bytes,10,opt,name=os_description,json=osDescription,proto3" json:"os_description,omitempty"`
	// The VM Boot Option.
	BootOption AwsVmDetails_BootOption `protobuf:"varint,11,opt,name=boot_option,json=bootOption,proto3,enum=google.cloud.vmmigration.v1.AwsVmDetails_BootOption" json:"boot_option,omitempty"`
	// The instance type of the VM.
	InstanceType string `protobuf:"bytes,12,opt,name=instance_type,json=instanceType,proto3" json:"instance_type,omitempty"`
	// The VPC ID the VM belongs to.
	VpcId string `protobuf:"bytes,13,opt,name=vpc_id,json=vpcId,proto3" json:"vpc_id,omitempty"`
	// The security groups the VM belongs to.
	SecurityGroups []*AwsSecurityGroup `protobuf:"bytes,14,rep,name=security_groups,json=securityGroups,proto3" json:"security_groups,omitempty"`
	// The tags of the VM.
	Tags map[string]string `protobuf:"bytes,15,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The AWS zone of the VM.
	Zone string `protobuf:"bytes,16,opt,name=zone,proto3" json:"zone,omitempty"`
	// The virtualization type.
	VirtualizationType AwsVmDetails_VmVirtualizationType `protobuf:"varint,17,opt,name=virtualization_type,json=virtualizationType,proto3,enum=google.cloud.vmmigration.v1.AwsVmDetails_VmVirtualizationType" json:"virtualization_type,omitempty"`
	// The CPU architecture.
	Architecture AwsVmDetails_VmArchitecture `protobuf:"varint,18,opt,name=architecture,proto3,enum=google.cloud.vmmigration.v1.AwsVmDetails_VmArchitecture" json:"architecture,omitempty"`
	// The number of vCPUs the VM has. It is calculated as the
	// number of CPU cores * threads per CPU the VM has.
	VcpuCount int32 `protobuf:"varint,19,opt,name=vcpu_count,json=vcpuCount,proto3" json:"vcpu_count,omitempty"`
}

func (x *AwsVmDetails) Reset() {
	*x = AwsVmDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AwsVmDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsVmDetails) ProtoMessage() {}

func (x *AwsVmDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsVmDetails.ProtoReflect.Descriptor instead.
func (*AwsVmDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{39}
}

func (x *AwsVmDetails) GetVmId() string {
	if x != nil {
		return x.VmId
	}
	return ""
}

func (x *AwsVmDetails) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *AwsVmDetails) GetSourceId() string {
	if x != nil {
		return x.SourceId
	}
	return ""
}

func (x *AwsVmDetails) GetSourceDescription() string {
	if x != nil {
		return x.SourceDescription
	}
	return ""
}

func (x *AwsVmDetails) GetPowerState() AwsVmDetails_PowerState {
	if x != nil {
		return x.PowerState
	}
	return AwsVmDetails_POWER_STATE_UNSPECIFIED
}

func (x *AwsVmDetails) GetCpuCount() int32 {
	if x != nil {
		return x.CpuCount
	}
	return 0
}

func (x *AwsVmDetails) GetMemoryMb() int32 {
	if x != nil {
		return x.MemoryMb
	}
	return 0
}

func (x *AwsVmDetails) GetDiskCount() int32 {
	if x != nil {
		return x.DiskCount
	}
	return 0
}

func (x *AwsVmDetails) GetCommittedStorageMb() int64 {
	if x != nil {
		return x.CommittedStorageMb
	}
	return 0
}

func (x *AwsVmDetails) GetOsDescription() string {
	if x != nil {
		return x.OsDescription
	}
	return ""
}

func (x *AwsVmDetails) GetBootOption() AwsVmDetails_BootOption {
	if x != nil {
		return x.BootOption
	}
	return AwsVmDetails_BOOT_OPTION_UNSPECIFIED
}

func (x *AwsVmDetails) GetInstanceType() string {
	if x != nil {
		return x.InstanceType
	}
	return ""
}

func (x *AwsVmDetails) GetVpcId() string {
	if x != nil {
		return x.VpcId
	}
	return ""
}

func (x *AwsVmDetails) GetSecurityGroups() []*AwsSecurityGroup {
	if x != nil {
		return x.SecurityGroups
	}
	return nil
}

func (x *AwsVmDetails) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *AwsVmDetails) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *AwsVmDetails) GetVirtualizationType() AwsVmDetails_VmVirtualizationType {
	if x != nil {
		return x.VirtualizationType
	}
	return AwsVmDetails_VM_VIRTUALIZATION_TYPE_UNSPECIFIED
}

func (x *AwsVmDetails) GetArchitecture() AwsVmDetails_VmArchitecture {
	if x != nil {
		return x.Architecture
	}
	return AwsVmDetails_VM_ARCHITECTURE_UNSPECIFIED
}

func (x *AwsVmDetails) GetVcpuCount() int32 {
	if x != nil {
		return x.VcpuCount
	}
	return 0
}

// AwsSecurityGroup describes a security group of an AWS VM.
type AwsSecurityGroup struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The AWS security group id.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The AWS security group name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *AwsSecurityGroup) Reset() {
	*x = AwsSecurityGroup{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AwsSecurityGroup) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsSecurityGroup) ProtoMessage() {}

func (x *AwsSecurityGroup) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsSecurityGroup.ProtoReflect.Descriptor instead.
func (*AwsSecurityGroup) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{40}
}

func (x *AwsSecurityGroup) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *AwsSecurityGroup) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// AzureVmDetails describes a VM in Azure.
type AzureVmDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The VM full path in Azure.
	VmId string `protobuf:"bytes,1,opt,name=vm_id,json=vmId,proto3" json:"vm_id,omitempty"`
	// The power state of the VM at the moment list was taken.
	PowerState AzureVmDetails_PowerState `protobuf:"varint,2,opt,name=power_state,json=powerState,proto3,enum=google.cloud.vmmigration.v1.AzureVmDetails_PowerState" json:"power_state,omitempty"`
	// VM size as configured in Azure. Determines the VM's hardware spec.
	VmSize string `protobuf:"bytes,3,opt,name=vm_size,json=vmSize,proto3" json:"vm_size,omitempty"`
	// The number of cpus the VM has.
	CpuCount int32 `protobuf:"varint,4,opt,name=cpu_count,json=cpuCount,proto3" json:"cpu_count,omitempty"`
	// The memory size of the VM in MB.
	MemoryMb int32 `protobuf:"varint,5,opt,name=memory_mb,json=memoryMb,proto3" json:"memory_mb,omitempty"`
	// The number of disks the VM has, including OS disk.
	DiskCount int32 `protobuf:"varint,6,opt,name=disk_count,json=diskCount,proto3" json:"disk_count,omitempty"`
	// The total size of the storage allocated to the VM in MB.
	CommittedStorageMb int64 `protobuf:"varint,7,opt,name=committed_storage_mb,json=committedStorageMb,proto3" json:"committed_storage_mb,omitempty"`
	// Description of the OS disk.
	OsDisk *AzureVmDetails_OSDisk `protobuf:"bytes,8,opt,name=os_disk,json=osDisk,proto3" json:"os_disk,omitempty"`
	// Description of the data disks.
	Disks []*AzureVmDetails_Disk `protobuf:"bytes,9,rep,name=disks,proto3" json:"disks,omitempty"`
	// Description of the OS.
	OsDescription *AzureVmDetails_OSDescription `protobuf:"bytes,10,opt,name=os_description,json=osDescription,proto3" json:"os_description,omitempty"`
	// The VM Boot Option.
	BootOption AzureVmDetails_BootOption `protobuf:"varint,11,opt,name=boot_option,json=bootOption,proto3,enum=google.cloud.vmmigration.v1.AzureVmDetails_BootOption" json:"boot_option,omitempty"`
	// The tags of the VM.
	Tags map[string]string `protobuf:"bytes,12,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The VM's ComputerName.
	ComputerName string `protobuf:"bytes,13,opt,name=computer_name,json=computerName,proto3" json:"computer_name,omitempty"`
	// The CPU architecture.
	Architecture AzureVmDetails_VmArchitecture `protobuf:"varint,14,opt,name=architecture,proto3,enum=google.cloud.vmmigration.v1.AzureVmDetails_VmArchitecture" json:"architecture,omitempty"`
}

func (x *AzureVmDetails) Reset() {
	*x = AzureVmDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AzureVmDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureVmDetails) ProtoMessage() {}

func (x *AzureVmDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureVmDetails.ProtoReflect.Descriptor instead.
func (*AzureVmDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{41}
}

func (x *AzureVmDetails) GetVmId() string {
	if x != nil {
		return x.VmId
	}
	return ""
}

func (x *AzureVmDetails) GetPowerState() AzureVmDetails_PowerState {
	if x != nil {
		return x.PowerState
	}
	return AzureVmDetails_POWER_STATE_UNSPECIFIED
}

func (x *AzureVmDetails) GetVmSize() string {
	if x != nil {
		return x.VmSize
	}
	return ""
}

func (x *AzureVmDetails) GetCpuCount() int32 {
	if x != nil {
		return x.CpuCount
	}
	return 0
}

func (x *AzureVmDetails) GetMemoryMb() int32 {
	if x != nil {
		return x.MemoryMb
	}
	return 0
}

func (x *AzureVmDetails) GetDiskCount() int32 {
	if x != nil {
		return x.DiskCount
	}
	return 0
}

func (x *AzureVmDetails) GetCommittedStorageMb() int64 {
	if x != nil {
		return x.CommittedStorageMb
	}
	return 0
}

func (x *AzureVmDetails) GetOsDisk() *AzureVmDetails_OSDisk {
	if x != nil {
		return x.OsDisk
	}
	return nil
}

func (x *AzureVmDetails) GetDisks() []*AzureVmDetails_Disk {
	if x != nil {
		return x.Disks
	}
	return nil
}

func (x *AzureVmDetails) GetOsDescription() *AzureVmDetails_OSDescription {
	if x != nil {
		return x.OsDescription
	}
	return nil
}

func (x *AzureVmDetails) GetBootOption() AzureVmDetails_BootOption {
	if x != nil {
		return x.BootOption
	}
	return AzureVmDetails_BOOT_OPTION_UNSPECIFIED
}

func (x *AzureVmDetails) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *AzureVmDetails) GetComputerName() string {
	if x != nil {
		return x.ComputerName
	}
	return ""
}

func (x *AzureVmDetails) GetArchitecture() AzureVmDetails_VmArchitecture {
	if x != nil {
		return x.Architecture
	}
	return AzureVmDetails_VM_ARCHITECTURE_UNSPECIFIED
}

// VmwareVmsDetails describes VMs in vCenter.
type VmwareVmsDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The details of the vmware VMs.
	Details []*VmwareVmDetails `protobuf:"bytes,1,rep,name=details,proto3" json:"details,omitempty"`
}

func (x *VmwareVmsDetails) Reset() {
	*x = VmwareVmsDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VmwareVmsDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareVmsDetails) ProtoMessage() {}

func (x *VmwareVmsDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareVmsDetails.ProtoReflect.Descriptor instead.
func (*VmwareVmsDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{42}
}

func (x *VmwareVmsDetails) GetDetails() []*VmwareVmDetails {
	if x != nil {
		return x.Details
	}
	return nil
}

// AWSVmsDetails describes VMs in AWS.
type AwsVmsDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The details of the AWS VMs.
	Details []*AwsVmDetails `protobuf:"bytes,1,rep,name=details,proto3" json:"details,omitempty"`
}

func (x *AwsVmsDetails) Reset() {
	*x = AwsVmsDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AwsVmsDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsVmsDetails) ProtoMessage() {}

func (x *AwsVmsDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsVmsDetails.ProtoReflect.Descriptor instead.
func (*AwsVmsDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{43}
}

func (x *AwsVmsDetails) GetDetails() []*AwsVmDetails {
	if x != nil {
		return x.Details
	}
	return nil
}

// AzureVmsDetails describes VMs in Azure.
type AzureVmsDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The details of the Azure VMs.
	Details []*AzureVmDetails `protobuf:"bytes,1,rep,name=details,proto3" json:"details,omitempty"`
}

func (x *AzureVmsDetails) Reset() {
	*x = AzureVmsDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AzureVmsDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureVmsDetails) ProtoMessage() {}

func (x *AzureVmsDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureVmsDetails.ProtoReflect.Descriptor instead.
func (*AzureVmsDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{44}
}

func (x *AzureVmsDetails) GetDetails() []*AzureVmDetails {
	if x != nil {
		return x.Details
	}
	return nil
}

// Response message for
// [fetchInventory][google.cloud.vmmigration.v1.VmMigration.FetchInventory].
type FetchInventoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to SourceVms:
	//
	//	*FetchInventoryResponse_VmwareVms
	//	*FetchInventoryResponse_AwsVms
	//	*FetchInventoryResponse_AzureVms
	SourceVms isFetchInventoryResponse_SourceVms `protobuf_oneof:"SourceVms"`
	// Output only. The timestamp when the source was last queried (if the result
	// is from the cache).
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *FetchInventoryResponse) Reset() {
	*x = FetchInventoryResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchInventoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchInventoryResponse) ProtoMessage() {}

func (x *FetchInventoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchInventoryResponse.ProtoReflect.Descriptor instead.
func (*FetchInventoryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{45}
}

func (m *FetchInventoryResponse) GetSourceVms() isFetchInventoryResponse_SourceVms {
	if m != nil {
		return m.SourceVms
	}
	return nil
}

func (x *FetchInventoryResponse) GetVmwareVms() *VmwareVmsDetails {
	if x, ok := x.GetSourceVms().(*FetchInventoryResponse_VmwareVms); ok {
		return x.VmwareVms
	}
	return nil
}

func (x *FetchInventoryResponse) GetAwsVms() *AwsVmsDetails {
	if x, ok := x.GetSourceVms().(*FetchInventoryResponse_AwsVms); ok {
		return x.AwsVms
	}
	return nil
}

func (x *FetchInventoryResponse) GetAzureVms() *AzureVmsDetails {
	if x, ok := x.GetSourceVms().(*FetchInventoryResponse_AzureVms); ok {
		return x.AzureVms
	}
	return nil
}

func (x *FetchInventoryResponse) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

type isFetchInventoryResponse_SourceVms interface {
	isFetchInventoryResponse_SourceVms()
}

type FetchInventoryResponse_VmwareVms struct {
	// The description of the VMs in a Source of type Vmware.
	VmwareVms *VmwareVmsDetails `protobuf:"bytes,1,opt,name=vmware_vms,json=vmwareVms,proto3,oneof"`
}

type FetchInventoryResponse_AwsVms struct {
	// The description of the VMs in a Source of type AWS.
	AwsVms *AwsVmsDetails `protobuf:"bytes,3,opt,name=aws_vms,json=awsVms,proto3,oneof"`
}

type FetchInventoryResponse_AzureVms struct {
	// The description of the VMs in a Source of type Azure.
	AzureVms *AzureVmsDetails `protobuf:"bytes,5,opt,name=azure_vms,json=azureVms,proto3,oneof"`
}

func (*FetchInventoryResponse_VmwareVms) isFetchInventoryResponse_SourceVms() {}

func (*FetchInventoryResponse_AwsVms) isFetchInventoryResponse_SourceVms() {}

func (*FetchInventoryResponse_AzureVms) isFetchInventoryResponse_SourceVms() {}

// Request message for
// [fetchStorageInventory][google.cloud.vmmigration.v1.VmMigration.FetchStorageInventory].
type FetchStorageInventoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Source.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Required. The type of the storage inventory to fetch.
	Type FetchStorageInventoryRequest_StorageType `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.vmmigration.v1.FetchStorageInventoryRequest_StorageType" json:"type,omitempty"`
	// Optional. If this flag is set to true, the source will be queried instead
	// of using cached results. Using this flag will make the call slower.
	ForceRefresh bool `protobuf:"varint,3,opt,name=force_refresh,json=forceRefresh,proto3" json:"force_refresh,omitempty"`
	// Optional. The maximum number of VMs to return. The service may return
	// fewer than this value.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `FetchStorageInventory`
	// call. Provide this to retrieve the subsequent page. When paginating, all
	// other parameters provided to `FetchStorageInventory` must match the call
	// that provided the page token.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *FetchStorageInventoryRequest) Reset() {
	*x = FetchStorageInventoryRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchStorageInventoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchStorageInventoryRequest) ProtoMessage() {}

func (x *FetchStorageInventoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchStorageInventoryRequest.ProtoReflect.Descriptor instead.
func (*FetchStorageInventoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{46}
}

func (x *FetchStorageInventoryRequest) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *FetchStorageInventoryRequest) GetType() FetchStorageInventoryRequest_StorageType {
	if x != nil {
		return x.Type
	}
	return FetchStorageInventoryRequest_STORAGE_TYPE_UNSPECIFIED
}

func (x *FetchStorageInventoryRequest) GetForceRefresh() bool {
	if x != nil {
		return x.ForceRefresh
	}
	return false
}

func (x *FetchStorageInventoryRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *FetchStorageInventoryRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for
// [fetchStorageInventory][google.cloud.vmmigration.v1.VmMigration.FetchStorageInventory].
type FetchStorageInventoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of storage resources in the source.
	Resources []*SourceStorageResource `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	// Output only. The timestamp when the source was last queried (if the result
	// is from the cache).
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *FetchStorageInventoryResponse) Reset() {
	*x = FetchStorageInventoryResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FetchStorageInventoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FetchStorageInventoryResponse) ProtoMessage() {}

func (x *FetchStorageInventoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FetchStorageInventoryResponse.ProtoReflect.Descriptor instead.
func (*FetchStorageInventoryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{47}
}

func (x *FetchStorageInventoryResponse) GetResources() []*SourceStorageResource {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *FetchStorageInventoryResponse) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *FetchStorageInventoryResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// SourceStorageResource describes a storage resource in the source.
type SourceStorageResource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source storage resource details.
	//
	// Types that are assignable to StorageResource:
	//
	//	*SourceStorageResource_AwsDiskDetails
	StorageResource isSourceStorageResource_StorageResource `protobuf_oneof:"StorageResource"`
}

func (x *SourceStorageResource) Reset() {
	*x = SourceStorageResource{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SourceStorageResource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SourceStorageResource) ProtoMessage() {}

func (x *SourceStorageResource) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SourceStorageResource.ProtoReflect.Descriptor instead.
func (*SourceStorageResource) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{48}
}

func (m *SourceStorageResource) GetStorageResource() isSourceStorageResource_StorageResource {
	if m != nil {
		return m.StorageResource
	}
	return nil
}

func (x *SourceStorageResource) GetAwsDiskDetails() *AwsSourceDiskDetails {
	if x, ok := x.GetStorageResource().(*SourceStorageResource_AwsDiskDetails); ok {
		return x.AwsDiskDetails
	}
	return nil
}

type isSourceStorageResource_StorageResource interface {
	isSourceStorageResource_StorageResource()
}

type SourceStorageResource_AwsDiskDetails struct {
	// Source AWS volume details.
	AwsDiskDetails *AwsSourceDiskDetails `protobuf:"bytes,1,opt,name=aws_disk_details,json=awsDiskDetails,proto3,oneof"`
}

func (*SourceStorageResource_AwsDiskDetails) isSourceStorageResource_StorageResource() {}

// Utilization report details the utilization (CPU, memory, etc.) of selected
// source VMs.
type UtilizationReport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The report unique name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The report display name, as assigned by the user.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Output only. Current state of the report.
	State UtilizationReport_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.UtilizationReport_State" json:"state,omitempty"`
	// Output only. The time the state was last set.
	StateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=state_time,json=stateTime,proto3" json:"state_time,omitempty"`
	// Output only. Provides details on the state of the report in case of an
	// error.
	Error *status.Status `protobuf:"bytes,5,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. The time the report was created (this refers to the time of
	// the request, not the time the report creation completed).
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Time frame of the report.
	TimeFrame UtilizationReport_TimeFrame `protobuf:"varint,7,opt,name=time_frame,json=timeFrame,proto3,enum=google.cloud.vmmigration.v1.UtilizationReport_TimeFrame" json:"time_frame,omitempty"`
	// Output only. The point in time when the time frame ends. Notice that the
	// time frame is counted backwards. For instance if the "frame_end_time" value
	// is 2021/01/20 and the time frame is WEEK then the report covers the week
	// between 2021/01/20 and 2021/01/14.
	FrameEndTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=frame_end_time,json=frameEndTime,proto3" json:"frame_end_time,omitempty"`
	// Output only. Total number of VMs included in the report.
	VmCount int32 `protobuf:"varint,9,opt,name=vm_count,json=vmCount,proto3" json:"vm_count,omitempty"`
	// List of utilization information per VM.
	// When sent as part of the request, the "vm_id" field is used in order to
	// specify which VMs to include in the report. In that case all other fields
	// are ignored.
	Vms []*VmUtilizationInfo `protobuf:"bytes,10,rep,name=vms,proto3" json:"vms,omitempty"`
}

func (x *UtilizationReport) Reset() {
	*x = UtilizationReport{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[49]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UtilizationReport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UtilizationReport) ProtoMessage() {}

func (x *UtilizationReport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[49]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UtilizationReport.ProtoReflect.Descriptor instead.
func (*UtilizationReport) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{49}
}

func (x *UtilizationReport) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UtilizationReport) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *UtilizationReport) GetState() UtilizationReport_State {
	if x != nil {
		return x.State
	}
	return UtilizationReport_STATE_UNSPECIFIED
}

func (x *UtilizationReport) GetStateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StateTime
	}
	return nil
}

func (x *UtilizationReport) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *UtilizationReport) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *UtilizationReport) GetTimeFrame() UtilizationReport_TimeFrame {
	if x != nil {
		return x.TimeFrame
	}
	return UtilizationReport_TIME_FRAME_UNSPECIFIED
}

func (x *UtilizationReport) GetFrameEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.FrameEndTime
	}
	return nil
}

func (x *UtilizationReport) GetVmCount() int32 {
	if x != nil {
		return x.VmCount
	}
	return 0
}

func (x *UtilizationReport) GetVms() []*VmUtilizationInfo {
	if x != nil {
		return x.Vms
	}
	return nil
}

// Utilization information of a single VM.
type VmUtilizationInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to VmDetails:
	//
	//	*VmUtilizationInfo_VmwareVmDetails
	VmDetails isVmUtilizationInfo_VmDetails `protobuf_oneof:"VmDetails"`
	// The VM's ID in the source.
	VmId string `protobuf:"bytes,3,opt,name=vm_id,json=vmId,proto3" json:"vm_id,omitempty"`
	// Utilization metrics for this VM.
	Utilization *VmUtilizationMetrics `protobuf:"bytes,2,opt,name=utilization,proto3" json:"utilization,omitempty"`
}

func (x *VmUtilizationInfo) Reset() {
	*x = VmUtilizationInfo{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[50]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VmUtilizationInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmUtilizationInfo) ProtoMessage() {}

func (x *VmUtilizationInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[50]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmUtilizationInfo.ProtoReflect.Descriptor instead.
func (*VmUtilizationInfo) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{50}
}

func (m *VmUtilizationInfo) GetVmDetails() isVmUtilizationInfo_VmDetails {
	if m != nil {
		return m.VmDetails
	}
	return nil
}

func (x *VmUtilizationInfo) GetVmwareVmDetails() *VmwareVmDetails {
	if x, ok := x.GetVmDetails().(*VmUtilizationInfo_VmwareVmDetails); ok {
		return x.VmwareVmDetails
	}
	return nil
}

func (x *VmUtilizationInfo) GetVmId() string {
	if x != nil {
		return x.VmId
	}
	return ""
}

func (x *VmUtilizationInfo) GetUtilization() *VmUtilizationMetrics {
	if x != nil {
		return x.Utilization
	}
	return nil
}

type isVmUtilizationInfo_VmDetails interface {
	isVmUtilizationInfo_VmDetails()
}

type VmUtilizationInfo_VmwareVmDetails struct {
	// The description of the VM in a Source of type Vmware.
	VmwareVmDetails *VmwareVmDetails `protobuf:"bytes,1,opt,name=vmware_vm_details,json=vmwareVmDetails,proto3,oneof"`
}

func (*VmUtilizationInfo_VmwareVmDetails) isVmUtilizationInfo_VmDetails() {}

// Utilization metrics values for a single VM.
type VmUtilizationMetrics struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Max CPU usage, percent.
	CpuMaxPercent int32 `protobuf:"varint,9,opt,name=cpu_max_percent,json=cpuMaxPercent,proto3" json:"cpu_max_percent,omitempty"`
	// Average CPU usage, percent.
	CpuAveragePercent int32 `protobuf:"varint,10,opt,name=cpu_average_percent,json=cpuAveragePercent,proto3" json:"cpu_average_percent,omitempty"`
	// Max memory usage, percent.
	MemoryMaxPercent int32 `protobuf:"varint,11,opt,name=memory_max_percent,json=memoryMaxPercent,proto3" json:"memory_max_percent,omitempty"`
	// Average memory usage, percent.
	MemoryAveragePercent int32 `protobuf:"varint,12,opt,name=memory_average_percent,json=memoryAveragePercent,proto3" json:"memory_average_percent,omitempty"`
	// Max disk IO rate, in kilobytes per second.
	DiskIoRateMaxKbps int64 `protobuf:"varint,13,opt,name=disk_io_rate_max_kbps,json=diskIoRateMaxKbps,proto3" json:"disk_io_rate_max_kbps,omitempty"`
	// Average disk IO rate, in kilobytes per second.
	DiskIoRateAverageKbps int64 `protobuf:"varint,14,opt,name=disk_io_rate_average_kbps,json=diskIoRateAverageKbps,proto3" json:"disk_io_rate_average_kbps,omitempty"`
	// Max network throughput (combined transmit-rates and receive-rates), in
	// kilobytes per second.
	NetworkThroughputMaxKbps int64 `protobuf:"varint,15,opt,name=network_throughput_max_kbps,json=networkThroughputMaxKbps,proto3" json:"network_throughput_max_kbps,omitempty"`
	// Average network throughput (combined transmit-rates and receive-rates), in
	// kilobytes per second.
	NetworkThroughputAverageKbps int64 `protobuf:"varint,16,opt,name=network_throughput_average_kbps,json=networkThroughputAverageKbps,proto3" json:"network_throughput_average_kbps,omitempty"`
}

func (x *VmUtilizationMetrics) Reset() {
	*x = VmUtilizationMetrics{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[51]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VmUtilizationMetrics) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmUtilizationMetrics) ProtoMessage() {}

func (x *VmUtilizationMetrics) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[51]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmUtilizationMetrics.ProtoReflect.Descriptor instead.
func (*VmUtilizationMetrics) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{51}
}

func (x *VmUtilizationMetrics) GetCpuMaxPercent() int32 {
	if x != nil {
		return x.CpuMaxPercent
	}
	return 0
}

func (x *VmUtilizationMetrics) GetCpuAveragePercent() int32 {
	if x != nil {
		return x.CpuAveragePercent
	}
	return 0
}

func (x *VmUtilizationMetrics) GetMemoryMaxPercent() int32 {
	if x != nil {
		return x.MemoryMaxPercent
	}
	return 0
}

func (x *VmUtilizationMetrics) GetMemoryAveragePercent() int32 {
	if x != nil {
		return x.MemoryAveragePercent
	}
	return 0
}

func (x *VmUtilizationMetrics) GetDiskIoRateMaxKbps() int64 {
	if x != nil {
		return x.DiskIoRateMaxKbps
	}
	return 0
}

func (x *VmUtilizationMetrics) GetDiskIoRateAverageKbps() int64 {
	if x != nil {
		return x.DiskIoRateAverageKbps
	}
	return 0
}

func (x *VmUtilizationMetrics) GetNetworkThroughputMaxKbps() int64 {
	if x != nil {
		return x.NetworkThroughputMaxKbps
	}
	return 0
}

func (x *VmUtilizationMetrics) GetNetworkThroughputAverageKbps() int64 {
	if x != nil {
		return x.NetworkThroughputAverageKbps
	}
	return 0
}

// Request message for 'ListUtilizationReports' request.
type ListUtilizationReportsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Utilization Reports parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The level of details of each report.
	// Defaults to BASIC.
	View UtilizationReportView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.vmmigration.v1.UtilizationReportView" json:"view,omitempty"`
	// Optional. The maximum number of reports to return. The service may return
	// fewer than this value. If unspecified, at most 500 reports will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListUtilizationReports`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListUtilizationReports`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,6,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListUtilizationReportsRequest) Reset() {
	*x = ListUtilizationReportsRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[52]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListUtilizationReportsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUtilizationReportsRequest) ProtoMessage() {}

func (x *ListUtilizationReportsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[52]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUtilizationReportsRequest.ProtoReflect.Descriptor instead.
func (*ListUtilizationReportsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{52}
}

func (x *ListUtilizationReportsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListUtilizationReportsRequest) GetView() UtilizationReportView {
	if x != nil {
		return x.View
	}
	return UtilizationReportView_UTILIZATION_REPORT_VIEW_UNSPECIFIED
}

func (x *ListUtilizationReportsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListUtilizationReportsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListUtilizationReportsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListUtilizationReportsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListUtilizationReports' request.
type ListUtilizationReportsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of reports.
	UtilizationReports []*UtilizationReport `protobuf:"bytes,1,rep,name=utilization_reports,json=utilizationReports,proto3" json:"utilization_reports,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListUtilizationReportsResponse) Reset() {
	*x = ListUtilizationReportsResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[53]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListUtilizationReportsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListUtilizationReportsResponse) ProtoMessage() {}

func (x *ListUtilizationReportsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[53]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListUtilizationReportsResponse.ProtoReflect.Descriptor instead.
func (*ListUtilizationReportsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{53}
}

func (x *ListUtilizationReportsResponse) GetUtilizationReports() []*UtilizationReport {
	if x != nil {
		return x.UtilizationReports
	}
	return nil
}

func (x *ListUtilizationReportsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListUtilizationReportsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetUtilizationReport' request.
type GetUtilizationReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Utilization Report name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The level of details of the report.
	// Defaults to FULL
	View UtilizationReportView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.vmmigration.v1.UtilizationReportView" json:"view,omitempty"`
}

func (x *GetUtilizationReportRequest) Reset() {
	*x = GetUtilizationReportRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[54]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetUtilizationReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetUtilizationReportRequest) ProtoMessage() {}

func (x *GetUtilizationReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[54]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetUtilizationReportRequest.ProtoReflect.Descriptor instead.
func (*GetUtilizationReportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{54}
}

func (x *GetUtilizationReportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetUtilizationReportRequest) GetView() UtilizationReportView {
	if x != nil {
		return x.View
	}
	return UtilizationReportView_UTILIZATION_REPORT_VIEW_UNSPECIFIED
}

// Request message for 'CreateUtilizationReport' request.
type CreateUtilizationReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Utilization Report's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The report to create.
	UtilizationReport *UtilizationReport `protobuf:"bytes,2,opt,name=utilization_report,json=utilizationReport,proto3" json:"utilization_report,omitempty"`
	// Required. The ID to use for the report, which will become the final
	// component of the reports's resource name.
	//
	// This value maximum length is 63 characters, and valid characters
	// are /[a-z][0-9]-/. It must start with an english letter and must not
	// end with a hyphen.
	UtilizationReportId string `protobuf:"bytes,3,opt,name=utilization_report_id,json=utilizationReportId,proto3" json:"utilization_report_id,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateUtilizationReportRequest) Reset() {
	*x = CreateUtilizationReportRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[55]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateUtilizationReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateUtilizationReportRequest) ProtoMessage() {}

func (x *CreateUtilizationReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[55]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateUtilizationReportRequest.ProtoReflect.Descriptor instead.
func (*CreateUtilizationReportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{55}
}

func (x *CreateUtilizationReportRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateUtilizationReportRequest) GetUtilizationReport() *UtilizationReport {
	if x != nil {
		return x.UtilizationReport
	}
	return nil
}

func (x *CreateUtilizationReportRequest) GetUtilizationReportId() string {
	if x != nil {
		return x.UtilizationReportId
	}
	return ""
}

func (x *CreateUtilizationReportRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteUtilizationReport' request.
type DeleteUtilizationReportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Utilization Report name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteUtilizationReportRequest) Reset() {
	*x = DeleteUtilizationReportRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[56]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteUtilizationReportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteUtilizationReportRequest) ProtoMessage() {}

func (x *DeleteUtilizationReportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[56]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteUtilizationReportRequest.ProtoReflect.Descriptor instead.
func (*DeleteUtilizationReportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{56}
}

func (x *DeleteUtilizationReportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteUtilizationReportRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Response message for 'ListDatacenterConnectors' request.
type ListDatacenterConnectorsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of sources response.
	DatacenterConnectors []*DatacenterConnector `protobuf:"bytes,1,rep,name=datacenter_connectors,json=datacenterConnectors,proto3" json:"datacenter_connectors,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListDatacenterConnectorsResponse) Reset() {
	*x = ListDatacenterConnectorsResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[57]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDatacenterConnectorsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDatacenterConnectorsResponse) ProtoMessage() {}

func (x *ListDatacenterConnectorsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[57]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDatacenterConnectorsResponse.ProtoReflect.Descriptor instead.
func (*ListDatacenterConnectorsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{57}
}

func (x *ListDatacenterConnectorsResponse) GetDatacenterConnectors() []*DatacenterConnector {
	if x != nil {
		return x.DatacenterConnectors
	}
	return nil
}

func (x *ListDatacenterConnectorsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDatacenterConnectorsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetDatacenterConnector' request.
type GetDatacenterConnectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DatacenterConnector.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDatacenterConnectorRequest) Reset() {
	*x = GetDatacenterConnectorRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[58]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDatacenterConnectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDatacenterConnectorRequest) ProtoMessage() {}

func (x *GetDatacenterConnectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[58]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDatacenterConnectorRequest.ProtoReflect.Descriptor instead.
func (*GetDatacenterConnectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{58}
}

func (x *GetDatacenterConnectorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'CreateDatacenterConnector' request.
type CreateDatacenterConnectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The DatacenterConnector's parent.
	// Required. The Source in where the new DatacenterConnector will be created.
	// For example:
	// `projects/my-project/locations/us-central1/sources/my-source`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The datacenterConnector identifier.
	DatacenterConnectorId string `protobuf:"bytes,2,opt,name=datacenter_connector_id,json=datacenterConnectorId,proto3" json:"datacenter_connector_id,omitempty"`
	// Required. The create request body.
	DatacenterConnector *DatacenterConnector `protobuf:"bytes,3,opt,name=datacenter_connector,json=datacenterConnector,proto3" json:"datacenter_connector,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateDatacenterConnectorRequest) Reset() {
	*x = CreateDatacenterConnectorRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[59]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDatacenterConnectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDatacenterConnectorRequest) ProtoMessage() {}

func (x *CreateDatacenterConnectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[59]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDatacenterConnectorRequest.ProtoReflect.Descriptor instead.
func (*CreateDatacenterConnectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{59}
}

func (x *CreateDatacenterConnectorRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDatacenterConnectorRequest) GetDatacenterConnectorId() string {
	if x != nil {
		return x.DatacenterConnectorId
	}
	return ""
}

func (x *CreateDatacenterConnectorRequest) GetDatacenterConnector() *DatacenterConnector {
	if x != nil {
		return x.DatacenterConnector
	}
	return nil
}

func (x *CreateDatacenterConnectorRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteDatacenterConnector' request.
type DeleteDatacenterConnectorRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The DatacenterConnector name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteDatacenterConnectorRequest) Reset() {
	*x = DeleteDatacenterConnectorRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[60]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDatacenterConnectorRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDatacenterConnectorRequest) ProtoMessage() {}

func (x *DeleteDatacenterConnectorRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[60]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDatacenterConnectorRequest.ProtoReflect.Descriptor instead.
func (*DeleteDatacenterConnectorRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{60}
}

func (x *DeleteDatacenterConnectorRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteDatacenterConnectorRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'UpgradeAppliance' request.
type UpgradeApplianceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The DatacenterConnector name.
	DatacenterConnector string `protobuf:"bytes,1,opt,name=datacenter_connector,json=datacenterConnector,proto3" json:"datacenter_connector,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpgradeApplianceRequest) Reset() {
	*x = UpgradeApplianceRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[61]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeApplianceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeApplianceRequest) ProtoMessage() {}

func (x *UpgradeApplianceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[61]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeApplianceRequest.ProtoReflect.Descriptor instead.
func (*UpgradeApplianceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{61}
}

func (x *UpgradeApplianceRequest) GetDatacenterConnector() string {
	if x != nil {
		return x.DatacenterConnector
	}
	return ""
}

func (x *UpgradeApplianceRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Response message for 'UpgradeAppliance' request.
type UpgradeApplianceResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *UpgradeApplianceResponse) Reset() {
	*x = UpgradeApplianceResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[62]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpgradeApplianceResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpgradeApplianceResponse) ProtoMessage() {}

func (x *UpgradeApplianceResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[62]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpgradeApplianceResponse.ProtoReflect.Descriptor instead.
func (*UpgradeApplianceResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{62}
}

// Request message for 'ListDatacenterConnectors' request.
type ListDatacenterConnectorsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of connectors.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of connectors to return. The service may
	// return fewer than this value. If unspecified, at most 500 sources will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListDatacenterConnectors`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListDatacenterConnectors` must match the call that provided the page
	// token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDatacenterConnectorsRequest) Reset() {
	*x = ListDatacenterConnectorsRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[63]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDatacenterConnectorsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDatacenterConnectorsRequest) ProtoMessage() {}

func (x *ListDatacenterConnectorsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[63]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDatacenterConnectorsRequest.ProtoReflect.Descriptor instead.
func (*ListDatacenterConnectorsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{63}
}

func (x *ListDatacenterConnectorsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDatacenterConnectorsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDatacenterConnectorsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDatacenterConnectorsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDatacenterConnectorsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// ComputeEngineTargetDefaults is a collection of details for creating a VM in a
// target Compute Engine project.
type ComputeEngineTargetDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the VM to create.
	VmName string `protobuf:"bytes,1,opt,name=vm_name,json=vmName,proto3" json:"vm_name,omitempty"`
	// The full path of the resource of type TargetProject which represents the
	// Compute Engine project in which to create this VM.
	TargetProject string `protobuf:"bytes,2,opt,name=target_project,json=targetProject,proto3" json:"target_project,omitempty"`
	// The zone in which to create the VM.
	Zone string `protobuf:"bytes,3,opt,name=zone,proto3" json:"zone,omitempty"`
	// The machine type series to create the VM with.
	MachineTypeSeries string `protobuf:"bytes,4,opt,name=machine_type_series,json=machineTypeSeries,proto3" json:"machine_type_series,omitempty"`
	// The machine type to create the VM with.
	MachineType string `protobuf:"bytes,5,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// A list of network tags to associate with the VM.
	NetworkTags []string `protobuf:"bytes,6,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// List of NICs connected to this VM.
	NetworkInterfaces []*NetworkInterface `protobuf:"bytes,7,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
	// Optional. The service account to associate the VM with.
	ServiceAccount string `protobuf:"bytes,8,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// The disk type to use in the VM.
	DiskType ComputeEngineDiskType `protobuf:"varint,9,opt,name=disk_type,json=diskType,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineDiskType" json:"disk_type,omitempty"`
	// A map of labels to associate with the VM.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The license type to use in OS adaptation.
	LicenseType ComputeEngineLicenseType `protobuf:"varint,11,opt,name=license_type,json=licenseType,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineLicenseType" json:"license_type,omitempty"`
	// Output only. The OS license returned from the adaptation module report.
	AppliedLicense *AppliedLicense `protobuf:"bytes,12,opt,name=applied_license,json=appliedLicense,proto3" json:"applied_license,omitempty"`
	// Compute instance scheduling information (if empty default is used).
	ComputeScheduling *ComputeScheduling `protobuf:"bytes,13,opt,name=compute_scheduling,json=computeScheduling,proto3" json:"compute_scheduling,omitempty"`
	// Defines whether the instance has Secure Boot enabled.
	// This can be set to true only if the VM boot option is EFI.
	SecureBoot bool `protobuf:"varint,14,opt,name=secure_boot,json=secureBoot,proto3" json:"secure_boot,omitempty"`
	// Optional. Defines whether the instance has vTPM enabled.
	// This can be set to true only if the VM boot option is EFI.
	EnableVtpm bool `protobuf:"varint,21,opt,name=enable_vtpm,json=enableVtpm,proto3" json:"enable_vtpm,omitempty"`
	// Optional. Defines whether the instance has integrity monitoring enabled.
	// This can be set to true only if the VM boot option is EFI, and vTPM is
	// enabled.
	EnableIntegrityMonitoring bool `protobuf:"varint,22,opt,name=enable_integrity_monitoring,json=enableIntegrityMonitoring,proto3" json:"enable_integrity_monitoring,omitempty"`
	// Output only. The VM Boot Option, as set in the source VM.
	BootOption ComputeEngineBootOption `protobuf:"varint,15,opt,name=boot_option,json=bootOption,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineBootOption" json:"boot_option,omitempty"`
	// The metadata key/value pairs to assign to the VM.
	Metadata map[string]string `protobuf:"bytes,16,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Additional licenses to assign to the VM.
	AdditionalLicenses []string `protobuf:"bytes,17,rep,name=additional_licenses,json=additionalLicenses,proto3" json:"additional_licenses,omitempty"`
	// The hostname to assign to the VM.
	Hostname string `protobuf:"bytes,18,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Optional. Immutable. The encryption to apply to the VM disks.
	Encryption *Encryption `protobuf:"bytes,19,opt,name=encryption,proto3" json:"encryption,omitempty"`
	// Optional. By default the virtual machine will keep its existing boot
	// option. Setting this property will trigger an internal process which will
	// convert the virtual machine from using the existing boot option to another.
	BootConversion BootConversion `protobuf:"varint,20,opt,name=boot_conversion,json=bootConversion,proto3,enum=google.cloud.vmmigration.v1.BootConversion" json:"boot_conversion,omitempty"`
	// Optional. Additional replica zones of the target regional disks.
	// If this list is not empty a regional disk will be created. The first
	// supported zone would be the one stated in the
	// [zone][google.cloud.vmmigration.v1.ComputeEngineTargetDefaults.zone] field.
	// The rest are taken from this list. Please refer to the [regional disk
	// creation
	// API](https://cloud.google.com/compute/docs/regions-zones/global-regional-zonal-resources)
	// for further details about regional vs zonal disks. If not specified, a
	// zonal disk will be created in the same zone the VM is created.
	DiskReplicaZones []string `protobuf:"bytes,24,rep,name=disk_replica_zones,json=diskReplicaZones,proto3" json:"disk_replica_zones,omitempty"`
}

func (x *ComputeEngineTargetDefaults) Reset() {
	*x = ComputeEngineTargetDefaults{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[64]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeEngineTargetDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeEngineTargetDefaults) ProtoMessage() {}

func (x *ComputeEngineTargetDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[64]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeEngineTargetDefaults.ProtoReflect.Descriptor instead.
func (*ComputeEngineTargetDefaults) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{64}
}

func (x *ComputeEngineTargetDefaults) GetVmName() string {
	if x != nil {
		return x.VmName
	}
	return ""
}

func (x *ComputeEngineTargetDefaults) GetTargetProject() string {
	if x != nil {
		return x.TargetProject
	}
	return ""
}

func (x *ComputeEngineTargetDefaults) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *ComputeEngineTargetDefaults) GetMachineTypeSeries() string {
	if x != nil {
		return x.MachineTypeSeries
	}
	return ""
}

func (x *ComputeEngineTargetDefaults) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *ComputeEngineTargetDefaults) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetNetworkInterfaces() []*NetworkInterface {
	if x != nil {
		return x.NetworkInterfaces
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *ComputeEngineTargetDefaults) GetDiskType() ComputeEngineDiskType {
	if x != nil {
		return x.DiskType
	}
	return ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_UNSPECIFIED
}

func (x *ComputeEngineTargetDefaults) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetLicenseType() ComputeEngineLicenseType {
	if x != nil {
		return x.LicenseType
	}
	return ComputeEngineLicenseType_COMPUTE_ENGINE_LICENSE_TYPE_DEFAULT
}

func (x *ComputeEngineTargetDefaults) GetAppliedLicense() *AppliedLicense {
	if x != nil {
		return x.AppliedLicense
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetComputeScheduling() *ComputeScheduling {
	if x != nil {
		return x.ComputeScheduling
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetSecureBoot() bool {
	if x != nil {
		return x.SecureBoot
	}
	return false
}

func (x *ComputeEngineTargetDefaults) GetEnableVtpm() bool {
	if x != nil {
		return x.EnableVtpm
	}
	return false
}

func (x *ComputeEngineTargetDefaults) GetEnableIntegrityMonitoring() bool {
	if x != nil {
		return x.EnableIntegrityMonitoring
	}
	return false
}

func (x *ComputeEngineTargetDefaults) GetBootOption() ComputeEngineBootOption {
	if x != nil {
		return x.BootOption
	}
	return ComputeEngineBootOption_COMPUTE_ENGINE_BOOT_OPTION_UNSPECIFIED
}

func (x *ComputeEngineTargetDefaults) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetAdditionalLicenses() []string {
	if x != nil {
		return x.AdditionalLicenses
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *ComputeEngineTargetDefaults) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

func (x *ComputeEngineTargetDefaults) GetBootConversion() BootConversion {
	if x != nil {
		return x.BootConversion
	}
	return BootConversion_BOOT_CONVERSION_UNSPECIFIED
}

func (x *ComputeEngineTargetDefaults) GetDiskReplicaZones() []string {
	if x != nil {
		return x.DiskReplicaZones
	}
	return nil
}

// ComputeEngineTargetDetails is a collection of details for creating a VM in a
// target Compute Engine project.
type ComputeEngineTargetDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the VM to create.
	VmName string `protobuf:"bytes,1,opt,name=vm_name,json=vmName,proto3" json:"vm_name,omitempty"`
	// The Google Cloud target project ID or project name.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// The zone in which to create the VM.
	Zone string `protobuf:"bytes,3,opt,name=zone,proto3" json:"zone,omitempty"`
	// The machine type series to create the VM with.
	MachineTypeSeries string `protobuf:"bytes,4,opt,name=machine_type_series,json=machineTypeSeries,proto3" json:"machine_type_series,omitempty"`
	// The machine type to create the VM with.
	MachineType string `protobuf:"bytes,5,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// A list of network tags to associate with the VM.
	NetworkTags []string `protobuf:"bytes,6,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// List of NICs connected to this VM.
	NetworkInterfaces []*NetworkInterface `protobuf:"bytes,7,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
	// The service account to associate the VM with.
	ServiceAccount string `protobuf:"bytes,8,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// The disk type to use in the VM.
	DiskType ComputeEngineDiskType `protobuf:"varint,9,opt,name=disk_type,json=diskType,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineDiskType" json:"disk_type,omitempty"`
	// A map of labels to associate with the VM.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The license type to use in OS adaptation.
	LicenseType ComputeEngineLicenseType `protobuf:"varint,11,opt,name=license_type,json=licenseType,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineLicenseType" json:"license_type,omitempty"`
	// The OS license returned from the adaptation module report.
	AppliedLicense *AppliedLicense `protobuf:"bytes,12,opt,name=applied_license,json=appliedLicense,proto3" json:"applied_license,omitempty"`
	// Compute instance scheduling information (if empty default is used).
	ComputeScheduling *ComputeScheduling `protobuf:"bytes,13,opt,name=compute_scheduling,json=computeScheduling,proto3" json:"compute_scheduling,omitempty"`
	// Defines whether the instance has Secure Boot enabled.
	// This can be set to true only if the VM boot option is EFI.
	SecureBoot bool `protobuf:"varint,14,opt,name=secure_boot,json=secureBoot,proto3" json:"secure_boot,omitempty"`
	// Optional. Defines whether the instance has vTPM enabled.
	EnableVtpm bool `protobuf:"varint,21,opt,name=enable_vtpm,json=enableVtpm,proto3" json:"enable_vtpm,omitempty"`
	// Optional. Defines whether the instance has integrity monitoring enabled.
	EnableIntegrityMonitoring bool `protobuf:"varint,22,opt,name=enable_integrity_monitoring,json=enableIntegrityMonitoring,proto3" json:"enable_integrity_monitoring,omitempty"`
	// The VM Boot Option, as set in the source VM.
	BootOption ComputeEngineBootOption `protobuf:"varint,15,opt,name=boot_option,json=bootOption,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineBootOption" json:"boot_option,omitempty"`
	// The metadata key/value pairs to assign to the VM.
	Metadata map[string]string `protobuf:"bytes,16,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Additional licenses to assign to the VM.
	AdditionalLicenses []string `protobuf:"bytes,17,rep,name=additional_licenses,json=additionalLicenses,proto3" json:"additional_licenses,omitempty"`
	// The hostname to assign to the VM.
	Hostname string `protobuf:"bytes,18,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Optional. The encryption to apply to the VM disks.
	Encryption *Encryption `protobuf:"bytes,19,opt,name=encryption,proto3" json:"encryption,omitempty"`
	// Optional. By default the virtual machine will keep its existing boot
	// option. Setting this property will trigger an internal process which will
	// convert the virtual machine from using the existing boot option to another.
	BootConversion BootConversion `protobuf:"varint,20,opt,name=boot_conversion,json=bootConversion,proto3,enum=google.cloud.vmmigration.v1.BootConversion" json:"boot_conversion,omitempty"`
	// Optional. Additional replica zones of the target regional disks.
	// If this list is not empty a regional disk will be created. The first
	// supported zone would be the one stated in the
	// [zone][google.cloud.vmmigration.v1.ComputeEngineTargetDetails.zone] field.
	// The rest are taken from this list. Please refer to the [regional disk
	// creation
	// API](https://cloud.google.com/compute/docs/regions-zones/global-regional-zonal-resources)
	// for further details about regional vs zonal disks. If not specified, a
	// zonal disk will be created in the same zone the VM is created.
	DiskReplicaZones []string `protobuf:"bytes,24,rep,name=disk_replica_zones,json=diskReplicaZones,proto3" json:"disk_replica_zones,omitempty"`
}

func (x *ComputeEngineTargetDetails) Reset() {
	*x = ComputeEngineTargetDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[65]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeEngineTargetDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeEngineTargetDetails) ProtoMessage() {}

func (x *ComputeEngineTargetDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[65]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeEngineTargetDetails.ProtoReflect.Descriptor instead.
func (*ComputeEngineTargetDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{65}
}

func (x *ComputeEngineTargetDetails) GetVmName() string {
	if x != nil {
		return x.VmName
	}
	return ""
}

func (x *ComputeEngineTargetDetails) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *ComputeEngineTargetDetails) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *ComputeEngineTargetDetails) GetMachineTypeSeries() string {
	if x != nil {
		return x.MachineTypeSeries
	}
	return ""
}

func (x *ComputeEngineTargetDetails) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *ComputeEngineTargetDetails) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetNetworkInterfaces() []*NetworkInterface {
	if x != nil {
		return x.NetworkInterfaces
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *ComputeEngineTargetDetails) GetDiskType() ComputeEngineDiskType {
	if x != nil {
		return x.DiskType
	}
	return ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_UNSPECIFIED
}

func (x *ComputeEngineTargetDetails) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetLicenseType() ComputeEngineLicenseType {
	if x != nil {
		return x.LicenseType
	}
	return ComputeEngineLicenseType_COMPUTE_ENGINE_LICENSE_TYPE_DEFAULT
}

func (x *ComputeEngineTargetDetails) GetAppliedLicense() *AppliedLicense {
	if x != nil {
		return x.AppliedLicense
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetComputeScheduling() *ComputeScheduling {
	if x != nil {
		return x.ComputeScheduling
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetSecureBoot() bool {
	if x != nil {
		return x.SecureBoot
	}
	return false
}

func (x *ComputeEngineTargetDetails) GetEnableVtpm() bool {
	if x != nil {
		return x.EnableVtpm
	}
	return false
}

func (x *ComputeEngineTargetDetails) GetEnableIntegrityMonitoring() bool {
	if x != nil {
		return x.EnableIntegrityMonitoring
	}
	return false
}

func (x *ComputeEngineTargetDetails) GetBootOption() ComputeEngineBootOption {
	if x != nil {
		return x.BootOption
	}
	return ComputeEngineBootOption_COMPUTE_ENGINE_BOOT_OPTION_UNSPECIFIED
}

func (x *ComputeEngineTargetDetails) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetAdditionalLicenses() []string {
	if x != nil {
		return x.AdditionalLicenses
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *ComputeEngineTargetDetails) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

func (x *ComputeEngineTargetDetails) GetBootConversion() BootConversion {
	if x != nil {
		return x.BootConversion
	}
	return BootConversion_BOOT_CONVERSION_UNSPECIFIED
}

func (x *ComputeEngineTargetDetails) GetDiskReplicaZones() []string {
	if x != nil {
		return x.DiskReplicaZones
	}
	return nil
}

// NetworkInterface represents a NIC of a VM.
type NetworkInterface struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The network to connect the NIC to.
	Network string `protobuf:"bytes,1,opt,name=network,proto3" json:"network,omitempty"`
	// Optional. The subnetwork to connect the NIC to.
	Subnetwork string `protobuf:"bytes,2,opt,name=subnetwork,proto3" json:"subnetwork,omitempty"`
	// Optional. The internal IP to define in the NIC.
	// The formats accepted are: `ephemeral` \ ipv4 address \ a named address
	// resource full path.
	InternalIp string `protobuf:"bytes,3,opt,name=internal_ip,json=internalIp,proto3" json:"internal_ip,omitempty"`
	// Optional. The external IP to define in the NIC.
	ExternalIp string `protobuf:"bytes,4,opt,name=external_ip,json=externalIp,proto3" json:"external_ip,omitempty"`
	// Optional. The networking tier used for optimizing connectivity between
	// instances and systems on the internet. Applies only for external ephemeral
	// IP addresses. If left empty, will default to PREMIUM.
	NetworkTier ComputeEngineNetworkTier `protobuf:"varint,5,opt,name=network_tier,json=networkTier,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineNetworkTier" json:"network_tier,omitempty"`
}

func (x *NetworkInterface) Reset() {
	*x = NetworkInterface{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[66]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NetworkInterface) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NetworkInterface) ProtoMessage() {}

func (x *NetworkInterface) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[66]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NetworkInterface.ProtoReflect.Descriptor instead.
func (*NetworkInterface) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{66}
}

func (x *NetworkInterface) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *NetworkInterface) GetSubnetwork() string {
	if x != nil {
		return x.Subnetwork
	}
	return ""
}

func (x *NetworkInterface) GetInternalIp() string {
	if x != nil {
		return x.InternalIp
	}
	return ""
}

func (x *NetworkInterface) GetExternalIp() string {
	if x != nil {
		return x.ExternalIp
	}
	return ""
}

func (x *NetworkInterface) GetNetworkTier() ComputeEngineNetworkTier {
	if x != nil {
		return x.NetworkTier
	}
	return ComputeEngineNetworkTier_COMPUTE_ENGINE_NETWORK_TIER_UNSPECIFIED
}

// AppliedLicense holds the license data returned by adaptation module report.
type AppliedLicense struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The license type that was used in OS adaptation.
	Type AppliedLicense_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.vmmigration.v1.AppliedLicense_Type" json:"type,omitempty"`
	// The OS license returned from the adaptation module's report.
	OsLicense string `protobuf:"bytes,2,opt,name=os_license,json=osLicense,proto3" json:"os_license,omitempty"`
}

func (x *AppliedLicense) Reset() {
	*x = AppliedLicense{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[67]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AppliedLicense) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppliedLicense) ProtoMessage() {}

func (x *AppliedLicense) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[67]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppliedLicense.ProtoReflect.Descriptor instead.
func (*AppliedLicense) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{67}
}

func (x *AppliedLicense) GetType() AppliedLicense_Type {
	if x != nil {
		return x.Type
	}
	return AppliedLicense_TYPE_UNSPECIFIED
}

func (x *AppliedLicense) GetOsLicense() string {
	if x != nil {
		return x.OsLicense
	}
	return ""
}

// Node Affinity: the configuration of desired nodes onto which this Instance
// could be scheduled. Based on
// https://cloud.google.com/compute/docs/reference/rest/v1/instances/setScheduling
type SchedulingNodeAffinity struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The label key of Node resource to reference.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The operator to use for the node resources specified in the `values`
	// parameter.
	Operator SchedulingNodeAffinity_Operator `protobuf:"varint,2,opt,name=operator,proto3,enum=google.cloud.vmmigration.v1.SchedulingNodeAffinity_Operator" json:"operator,omitempty"`
	// Corresponds to the label values of Node resource.
	Values []string `protobuf:"bytes,3,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *SchedulingNodeAffinity) Reset() {
	*x = SchedulingNodeAffinity{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[68]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SchedulingNodeAffinity) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchedulingNodeAffinity) ProtoMessage() {}

func (x *SchedulingNodeAffinity) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[68]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchedulingNodeAffinity.ProtoReflect.Descriptor instead.
func (*SchedulingNodeAffinity) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{68}
}

func (x *SchedulingNodeAffinity) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *SchedulingNodeAffinity) GetOperator() SchedulingNodeAffinity_Operator {
	if x != nil {
		return x.Operator
	}
	return SchedulingNodeAffinity_OPERATOR_UNSPECIFIED
}

func (x *SchedulingNodeAffinity) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// Scheduling information for VM on maintenance/restart behaviour and
// node allocation in sole tenant nodes.
// Options for instance behavior when the host machine undergoes
// maintenance that may temporarily impact instance performance.
type ComputeScheduling struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// How the instance should behave when the host machine undergoes
	// maintenance that may temporarily impact instance performance.
	OnHostMaintenance ComputeScheduling_OnHostMaintenance `protobuf:"varint,1,opt,name=on_host_maintenance,json=onHostMaintenance,proto3,enum=google.cloud.vmmigration.v1.ComputeScheduling_OnHostMaintenance" json:"on_host_maintenance,omitempty"`
	// Whether the Instance should be automatically restarted whenever it is
	// terminated by Compute Engine (not terminated by user).
	// This configuration is identical to `automaticRestart` field in Compute
	// Engine create instance under scheduling.
	// It was changed to an enum (instead of a boolean) to match the default
	// value in Compute Engine which is automatic restart.
	RestartType ComputeScheduling_RestartType `protobuf:"varint,5,opt,name=restart_type,json=restartType,proto3,enum=google.cloud.vmmigration.v1.ComputeScheduling_RestartType" json:"restart_type,omitempty"`
	// A set of node affinity and anti-affinity configurations for sole tenant
	// nodes.
	NodeAffinities []*SchedulingNodeAffinity `protobuf:"bytes,3,rep,name=node_affinities,json=nodeAffinities,proto3" json:"node_affinities,omitempty"`
	// The minimum number of virtual CPUs this instance will consume when
	// running on a sole-tenant node. Ignored if no node_affinites are
	// configured.
	MinNodeCpus int32 `protobuf:"varint,4,opt,name=min_node_cpus,json=minNodeCpus,proto3" json:"min_node_cpus,omitempty"`
}

func (x *ComputeScheduling) Reset() {
	*x = ComputeScheduling{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[69]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeScheduling) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeScheduling) ProtoMessage() {}

func (x *ComputeScheduling) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[69]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeScheduling.ProtoReflect.Descriptor instead.
func (*ComputeScheduling) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{69}
}

func (x *ComputeScheduling) GetOnHostMaintenance() ComputeScheduling_OnHostMaintenance {
	if x != nil {
		return x.OnHostMaintenance
	}
	return ComputeScheduling_ON_HOST_MAINTENANCE_UNSPECIFIED
}

func (x *ComputeScheduling) GetRestartType() ComputeScheduling_RestartType {
	if x != nil {
		return x.RestartType
	}
	return ComputeScheduling_RESTART_TYPE_UNSPECIFIED
}

func (x *ComputeScheduling) GetNodeAffinities() []*SchedulingNodeAffinity {
	if x != nil {
		return x.NodeAffinities
	}
	return nil
}

func (x *ComputeScheduling) GetMinNodeCpus() int32 {
	if x != nil {
		return x.MinNodeCpus
	}
	return 0
}

// ComputeEngineDisksTargetDefaults is a collection of details for creating
// Persistent Disks in a target Compute Engine project.
type ComputeEngineDisksTargetDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Location:
	//
	//	*ComputeEngineDisksTargetDefaults_Zone
	Location isComputeEngineDisksTargetDefaults_Location `protobuf_oneof:"location"`
	// Details of the VM to attach the disks to as the target of this migration.
	//
	// Types that are assignable to VmTarget:
	//
	//	*ComputeEngineDisksTargetDefaults_DisksTargetDefaults
	//	*ComputeEngineDisksTargetDefaults_VmTargetDefaults
	VmTarget isComputeEngineDisksTargetDefaults_VmTarget `protobuf_oneof:"vm_target"`
	// The full path of the resource of type TargetProject which represents the
	// Compute Engine project in which to create the Persistent Disks.
	TargetProject string `protobuf:"bytes,1,opt,name=target_project,json=targetProject,proto3" json:"target_project,omitempty"`
	// The details of each Persistent Disk to create.
	Disks []*PersistentDiskDefaults `protobuf:"bytes,4,rep,name=disks,proto3" json:"disks,omitempty"`
}

func (x *ComputeEngineDisksTargetDefaults) Reset() {
	*x = ComputeEngineDisksTargetDefaults{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[70]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeEngineDisksTargetDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeEngineDisksTargetDefaults) ProtoMessage() {}

func (x *ComputeEngineDisksTargetDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[70]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeEngineDisksTargetDefaults.ProtoReflect.Descriptor instead.
func (*ComputeEngineDisksTargetDefaults) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{70}
}

func (m *ComputeEngineDisksTargetDefaults) GetLocation() isComputeEngineDisksTargetDefaults_Location {
	if m != nil {
		return m.Location
	}
	return nil
}

func (x *ComputeEngineDisksTargetDefaults) GetZone() string {
	if x, ok := x.GetLocation().(*ComputeEngineDisksTargetDefaults_Zone); ok {
		return x.Zone
	}
	return ""
}

func (m *ComputeEngineDisksTargetDefaults) GetVmTarget() isComputeEngineDisksTargetDefaults_VmTarget {
	if m != nil {
		return m.VmTarget
	}
	return nil
}

func (x *ComputeEngineDisksTargetDefaults) GetDisksTargetDefaults() *DisksMigrationDisksTargetDefaults {
	if x, ok := x.GetVmTarget().(*ComputeEngineDisksTargetDefaults_DisksTargetDefaults); ok {
		return x.DisksTargetDefaults
	}
	return nil
}

func (x *ComputeEngineDisksTargetDefaults) GetVmTargetDefaults() *DisksMigrationVmTargetDefaults {
	if x, ok := x.GetVmTarget().(*ComputeEngineDisksTargetDefaults_VmTargetDefaults); ok {
		return x.VmTargetDefaults
	}
	return nil
}

func (x *ComputeEngineDisksTargetDefaults) GetTargetProject() string {
	if x != nil {
		return x.TargetProject
	}
	return ""
}

func (x *ComputeEngineDisksTargetDefaults) GetDisks() []*PersistentDiskDefaults {
	if x != nil {
		return x.Disks
	}
	return nil
}

type isComputeEngineDisksTargetDefaults_Location interface {
	isComputeEngineDisksTargetDefaults_Location()
}

type ComputeEngineDisksTargetDefaults_Zone struct {
	// The zone in which to create the Persistent Disks.
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3,oneof"`
}

func (*ComputeEngineDisksTargetDefaults_Zone) isComputeEngineDisksTargetDefaults_Location() {}

type isComputeEngineDisksTargetDefaults_VmTarget interface {
	isComputeEngineDisksTargetDefaults_VmTarget()
}

type ComputeEngineDisksTargetDefaults_DisksTargetDefaults struct {
	// Details of the disk only migration target.
	DisksTargetDefaults *DisksMigrationDisksTargetDefaults `protobuf:"bytes,5,opt,name=disks_target_defaults,json=disksTargetDefaults,proto3,oneof"`
}

type ComputeEngineDisksTargetDefaults_VmTargetDefaults struct {
	// Details of the VM migration target.
	VmTargetDefaults *DisksMigrationVmTargetDefaults `protobuf:"bytes,6,opt,name=vm_target_defaults,json=vmTargetDefaults,proto3,oneof"`
}

func (*ComputeEngineDisksTargetDefaults_DisksTargetDefaults) isComputeEngineDisksTargetDefaults_VmTarget() {
}

func (*ComputeEngineDisksTargetDefaults_VmTargetDefaults) isComputeEngineDisksTargetDefaults_VmTarget() {
}

// Details for creation of a Persistent Disk.
type PersistentDiskDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ordinal number of the source VM disk.
	SourceDiskNumber int32 `protobuf:"varint,1,opt,name=source_disk_number,json=sourceDiskNumber,proto3" json:"source_disk_number,omitempty"`
	// Optional. The name of the Persistent Disk to create.
	DiskName string `protobuf:"bytes,2,opt,name=disk_name,json=diskName,proto3" json:"disk_name,omitempty"`
	// The disk type to use.
	DiskType ComputeEngineDiskType `protobuf:"varint,3,opt,name=disk_type,json=diskType,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineDiskType" json:"disk_type,omitempty"`
	// A map of labels to associate with the Persistent Disk.
	AdditionalLabels map[string]string `protobuf:"bytes,4,rep,name=additional_labels,json=additionalLabels,proto3" json:"additional_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The encryption to apply to the disk.
	Encryption *Encryption `protobuf:"bytes,5,opt,name=encryption,proto3" json:"encryption,omitempty"`
	// Optional. Details for attachment of the disk to a VM.
	// Used when the disk is set to be attached to a target VM.
	VmAttachmentDetails *VmAttachmentDetails `protobuf:"bytes,6,opt,name=vm_attachment_details,json=vmAttachmentDetails,proto3" json:"vm_attachment_details,omitempty"`
}

func (x *PersistentDiskDefaults) Reset() {
	*x = PersistentDiskDefaults{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[71]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PersistentDiskDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersistentDiskDefaults) ProtoMessage() {}

func (x *PersistentDiskDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[71]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersistentDiskDefaults.ProtoReflect.Descriptor instead.
func (*PersistentDiskDefaults) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{71}
}

func (x *PersistentDiskDefaults) GetSourceDiskNumber() int32 {
	if x != nil {
		return x.SourceDiskNumber
	}
	return 0
}

func (x *PersistentDiskDefaults) GetDiskName() string {
	if x != nil {
		return x.DiskName
	}
	return ""
}

func (x *PersistentDiskDefaults) GetDiskType() ComputeEngineDiskType {
	if x != nil {
		return x.DiskType
	}
	return ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_UNSPECIFIED
}

func (x *PersistentDiskDefaults) GetAdditionalLabels() map[string]string {
	if x != nil {
		return x.AdditionalLabels
	}
	return nil
}

func (x *PersistentDiskDefaults) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

func (x *PersistentDiskDefaults) GetVmAttachmentDetails() *VmAttachmentDetails {
	if x != nil {
		return x.VmAttachmentDetails
	}
	return nil
}

// Details for attachment of the disk to a VM.
type VmAttachmentDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Specifies a unique device name of your choice that is reflected
	// into the /dev/disk/by-id/google-* tree of a Linux operating system running
	// within the instance. If not specified, the server chooses a default device
	// name to apply to this disk, in the form persistent-disk-x, where x is a
	// number assigned by Google Compute Engine. This field is only applicable for
	// persistent disks.
	DeviceName string `protobuf:"bytes,1,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
}

func (x *VmAttachmentDetails) Reset() {
	*x = VmAttachmentDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[72]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VmAttachmentDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmAttachmentDetails) ProtoMessage() {}

func (x *VmAttachmentDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[72]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmAttachmentDetails.ProtoReflect.Descriptor instead.
func (*VmAttachmentDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{72}
}

func (x *VmAttachmentDetails) GetDeviceName() string {
	if x != nil {
		return x.DeviceName
	}
	return ""
}

// Details for a disk only migration.
type DisksMigrationDisksTargetDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DisksMigrationDisksTargetDefaults) Reset() {
	*x = DisksMigrationDisksTargetDefaults{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[73]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisksMigrationDisksTargetDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisksMigrationDisksTargetDefaults) ProtoMessage() {}

func (x *DisksMigrationDisksTargetDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[73]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisksMigrationDisksTargetDefaults.ProtoReflect.Descriptor instead.
func (*DisksMigrationDisksTargetDefaults) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{73}
}

// Details for creation of a VM that migrated data disks will be attached to.
type DisksMigrationVmTargetDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the VM to create.
	VmName string `protobuf:"bytes,1,opt,name=vm_name,json=vmName,proto3" json:"vm_name,omitempty"`
	// Optional. The machine type series to create the VM with.
	// For presentation only.
	MachineTypeSeries string `protobuf:"bytes,2,opt,name=machine_type_series,json=machineTypeSeries,proto3" json:"machine_type_series,omitempty"`
	// Required. The machine type to create the VM with.
	MachineType string `protobuf:"bytes,3,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
	// Optional. A list of network tags to associate with the VM.
	NetworkTags []string `protobuf:"bytes,4,rep,name=network_tags,json=networkTags,proto3" json:"network_tags,omitempty"`
	// Optional. NICs to attach to the VM.
	NetworkInterfaces []*NetworkInterface `protobuf:"bytes,5,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
	// Optional. The service account to associate the VM with.
	ServiceAccount string `protobuf:"bytes,6,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. Compute instance scheduling information (if empty default is
	// used).
	ComputeScheduling *ComputeScheduling `protobuf:"bytes,7,opt,name=compute_scheduling,json=computeScheduling,proto3" json:"compute_scheduling,omitempty"`
	// Optional. Defines whether the instance has Secure Boot enabled.
	// This can be set to true only if the VM boot option is EFI.
	SecureBoot bool `protobuf:"varint,8,opt,name=secure_boot,json=secureBoot,proto3" json:"secure_boot,omitempty"`
	// Optional. Defines whether the instance has vTPM enabled.
	EnableVtpm bool `protobuf:"varint,16,opt,name=enable_vtpm,json=enableVtpm,proto3" json:"enable_vtpm,omitempty"`
	// Optional. Defines whether the instance has integrity monitoring enabled.
	EnableIntegrityMonitoring bool `protobuf:"varint,17,opt,name=enable_integrity_monitoring,json=enableIntegrityMonitoring,proto3" json:"enable_integrity_monitoring,omitempty"`
	// Optional. The metadata key/value pairs to assign to the VM.
	Metadata map[string]string `protobuf:"bytes,10,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Additional licenses to assign to the VM.
	AdditionalLicenses []string `protobuf:"bytes,11,rep,name=additional_licenses,json=additionalLicenses,proto3" json:"additional_licenses,omitempty"`
	// Optional. The hostname to assign to the VM.
	Hostname string `protobuf:"bytes,12,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// Optional. A map of labels to associate with the VM.
	Labels map[string]string `protobuf:"bytes,13,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Details of the boot disk of the VM.
	BootDiskDefaults *BootDiskDefaults `protobuf:"bytes,14,opt,name=boot_disk_defaults,json=bootDiskDefaults,proto3" json:"boot_disk_defaults,omitempty"`
	// Optional. The encryption to apply to the VM.
	Encryption *Encryption `protobuf:"bytes,15,opt,name=encryption,proto3" json:"encryption,omitempty"`
}

func (x *DisksMigrationVmTargetDefaults) Reset() {
	*x = DisksMigrationVmTargetDefaults{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[74]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisksMigrationVmTargetDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisksMigrationVmTargetDefaults) ProtoMessage() {}

func (x *DisksMigrationVmTargetDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[74]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisksMigrationVmTargetDefaults.ProtoReflect.Descriptor instead.
func (*DisksMigrationVmTargetDefaults) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{74}
}

func (x *DisksMigrationVmTargetDefaults) GetVmName() string {
	if x != nil {
		return x.VmName
	}
	return ""
}

func (x *DisksMigrationVmTargetDefaults) GetMachineTypeSeries() string {
	if x != nil {
		return x.MachineTypeSeries
	}
	return ""
}

func (x *DisksMigrationVmTargetDefaults) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

func (x *DisksMigrationVmTargetDefaults) GetNetworkTags() []string {
	if x != nil {
		return x.NetworkTags
	}
	return nil
}

func (x *DisksMigrationVmTargetDefaults) GetNetworkInterfaces() []*NetworkInterface {
	if x != nil {
		return x.NetworkInterfaces
	}
	return nil
}

func (x *DisksMigrationVmTargetDefaults) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *DisksMigrationVmTargetDefaults) GetComputeScheduling() *ComputeScheduling {
	if x != nil {
		return x.ComputeScheduling
	}
	return nil
}

func (x *DisksMigrationVmTargetDefaults) GetSecureBoot() bool {
	if x != nil {
		return x.SecureBoot
	}
	return false
}

func (x *DisksMigrationVmTargetDefaults) GetEnableVtpm() bool {
	if x != nil {
		return x.EnableVtpm
	}
	return false
}

func (x *DisksMigrationVmTargetDefaults) GetEnableIntegrityMonitoring() bool {
	if x != nil {
		return x.EnableIntegrityMonitoring
	}
	return false
}

func (x *DisksMigrationVmTargetDefaults) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *DisksMigrationVmTargetDefaults) GetAdditionalLicenses() []string {
	if x != nil {
		return x.AdditionalLicenses
	}
	return nil
}

func (x *DisksMigrationVmTargetDefaults) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *DisksMigrationVmTargetDefaults) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DisksMigrationVmTargetDefaults) GetBootDiskDefaults() *BootDiskDefaults {
	if x != nil {
		return x.BootDiskDefaults
	}
	return nil
}

func (x *DisksMigrationVmTargetDefaults) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

// BootDiskDefaults hold information about the boot disk of a VM.
type BootDiskDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Source:
	//
	//	*BootDiskDefaults_Image
	Source isBootDiskDefaults_Source `protobuf_oneof:"source"`
	// Optional. The name of the disk.
	DiskName string `protobuf:"bytes,1,opt,name=disk_name,json=diskName,proto3" json:"disk_name,omitempty"`
	// Optional. The type of disk provisioning to use for the VM.
	DiskType ComputeEngineDiskType `protobuf:"varint,2,opt,name=disk_type,json=diskType,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineDiskType" json:"disk_type,omitempty"`
	// Optional. Specifies a unique device name of your choice that is reflected
	// into the /dev/disk/by-id/google-* tree of a Linux operating system running
	// within the instance. If not specified, the server chooses a default device
	// name to apply to this disk, in the form persistent-disk-x, where x is a
	// number assigned by Google Compute Engine. This field is only applicable for
	// persistent disks.
	DeviceName string `protobuf:"bytes,4,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
	// Optional. The encryption to apply to the boot disk.
	Encryption *Encryption `protobuf:"bytes,5,opt,name=encryption,proto3" json:"encryption,omitempty"`
}

func (x *BootDiskDefaults) Reset() {
	*x = BootDiskDefaults{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[75]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BootDiskDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BootDiskDefaults) ProtoMessage() {}

func (x *BootDiskDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[75]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BootDiskDefaults.ProtoReflect.Descriptor instead.
func (*BootDiskDefaults) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{75}
}

func (m *BootDiskDefaults) GetSource() isBootDiskDefaults_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *BootDiskDefaults) GetImage() *BootDiskDefaults_DiskImageDefaults {
	if x, ok := x.GetSource().(*BootDiskDefaults_Image); ok {
		return x.Image
	}
	return nil
}

func (x *BootDiskDefaults) GetDiskName() string {
	if x != nil {
		return x.DiskName
	}
	return ""
}

func (x *BootDiskDefaults) GetDiskType() ComputeEngineDiskType {
	if x != nil {
		return x.DiskType
	}
	return ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_UNSPECIFIED
}

func (x *BootDiskDefaults) GetDeviceName() string {
	if x != nil {
		return x.DeviceName
	}
	return ""
}

func (x *BootDiskDefaults) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

type isBootDiskDefaults_Source interface {
	isBootDiskDefaults_Source()
}

type BootDiskDefaults_Image struct {
	// The image to use when creating the disk.
	Image *BootDiskDefaults_DiskImageDefaults `protobuf:"bytes,3,opt,name=image,proto3,oneof"`
}

func (*BootDiskDefaults_Image) isBootDiskDefaults_Source() {}

// ComputeEngineDisksTargetDetails is a collection of created Persistent Disks
// details.
type ComputeEngineDisksTargetDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details of the VM the disks are attached to.
	//
	// Types that are assignable to VmTarget:
	//
	//	*ComputeEngineDisksTargetDetails_DisksTargetDetails
	//	*ComputeEngineDisksTargetDetails_VmTargetDetails
	VmTarget isComputeEngineDisksTargetDetails_VmTarget `protobuf_oneof:"vm_target"`
	// The details of each created Persistent Disk.
	Disks []*PersistentDisk `protobuf:"bytes,1,rep,name=disks,proto3" json:"disks,omitempty"`
}

func (x *ComputeEngineDisksTargetDetails) Reset() {
	*x = ComputeEngineDisksTargetDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[76]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeEngineDisksTargetDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeEngineDisksTargetDetails) ProtoMessage() {}

func (x *ComputeEngineDisksTargetDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[76]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeEngineDisksTargetDetails.ProtoReflect.Descriptor instead.
func (*ComputeEngineDisksTargetDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{76}
}

func (m *ComputeEngineDisksTargetDetails) GetVmTarget() isComputeEngineDisksTargetDetails_VmTarget {
	if m != nil {
		return m.VmTarget
	}
	return nil
}

func (x *ComputeEngineDisksTargetDetails) GetDisksTargetDetails() *DisksMigrationDisksTargetDetails {
	if x, ok := x.GetVmTarget().(*ComputeEngineDisksTargetDetails_DisksTargetDetails); ok {
		return x.DisksTargetDetails
	}
	return nil
}

func (x *ComputeEngineDisksTargetDetails) GetVmTargetDetails() *DisksMigrationVmTargetDetails {
	if x, ok := x.GetVmTarget().(*ComputeEngineDisksTargetDetails_VmTargetDetails); ok {
		return x.VmTargetDetails
	}
	return nil
}

func (x *ComputeEngineDisksTargetDetails) GetDisks() []*PersistentDisk {
	if x != nil {
		return x.Disks
	}
	return nil
}

type isComputeEngineDisksTargetDetails_VmTarget interface {
	isComputeEngineDisksTargetDetails_VmTarget()
}

type ComputeEngineDisksTargetDetails_DisksTargetDetails struct {
	// Details of the disks-only migration target.
	DisksTargetDetails *DisksMigrationDisksTargetDetails `protobuf:"bytes,5,opt,name=disks_target_details,json=disksTargetDetails,proto3,oneof"`
}

type ComputeEngineDisksTargetDetails_VmTargetDetails struct {
	// Details for the VM the migrated data disks are attached to.
	VmTargetDetails *DisksMigrationVmTargetDetails `protobuf:"bytes,6,opt,name=vm_target_details,json=vmTargetDetails,proto3,oneof"`
}

func (*ComputeEngineDisksTargetDetails_DisksTargetDetails) isComputeEngineDisksTargetDetails_VmTarget() {
}

func (*ComputeEngineDisksTargetDetails_VmTargetDetails) isComputeEngineDisksTargetDetails_VmTarget() {
}

// Details of a created Persistent Disk.
type PersistentDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ordinal number of the source VM disk.
	SourceDiskNumber int32 `protobuf:"varint,1,opt,name=source_disk_number,json=sourceDiskNumber,proto3" json:"source_disk_number,omitempty"`
	// The URI of the Persistent Disk.
	DiskUri string `protobuf:"bytes,2,opt,name=disk_uri,json=diskUri,proto3" json:"disk_uri,omitempty"`
}

func (x *PersistentDisk) Reset() {
	*x = PersistentDisk{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[77]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PersistentDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PersistentDisk) ProtoMessage() {}

func (x *PersistentDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[77]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PersistentDisk.ProtoReflect.Descriptor instead.
func (*PersistentDisk) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{77}
}

func (x *PersistentDisk) GetSourceDiskNumber() int32 {
	if x != nil {
		return x.SourceDiskNumber
	}
	return 0
}

func (x *PersistentDisk) GetDiskUri() string {
	if x != nil {
		return x.DiskUri
	}
	return ""
}

// Details for a disks-only migration.
type DisksMigrationDisksTargetDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DisksMigrationDisksTargetDetails) Reset() {
	*x = DisksMigrationDisksTargetDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[78]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisksMigrationDisksTargetDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisksMigrationDisksTargetDetails) ProtoMessage() {}

func (x *DisksMigrationDisksTargetDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[78]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisksMigrationDisksTargetDetails.ProtoReflect.Descriptor instead.
func (*DisksMigrationDisksTargetDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{78}
}

// Details for the VM created VM as part of disks migration.
type DisksMigrationVmTargetDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The URI of the Compute Engine VM.
	VmUri string `protobuf:"bytes,1,opt,name=vm_uri,json=vmUri,proto3" json:"vm_uri,omitempty"`
}

func (x *DisksMigrationVmTargetDetails) Reset() {
	*x = DisksMigrationVmTargetDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[79]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisksMigrationVmTargetDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisksMigrationVmTargetDetails) ProtoMessage() {}

func (x *DisksMigrationVmTargetDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[79]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DisksMigrationVmTargetDetails.ProtoReflect.Descriptor instead.
func (*DisksMigrationVmTargetDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{79}
}

func (x *DisksMigrationVmTargetDetails) GetVmUri() string {
	if x != nil {
		return x.VmUri
	}
	return ""
}

// A policy for scheduling replications.
type SchedulePolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The idle duration between replication stages.
	IdleDuration *durationpb.Duration `protobuf:"bytes,1,opt,name=idle_duration,json=idleDuration,proto3" json:"idle_duration,omitempty"`
	// A flag to indicate whether to skip OS adaptation during the replication
	// sync. OS adaptation is a process where the VM's operating system undergoes
	// changes and adaptations to fully function on Compute Engine.
	SkipOsAdaptation bool `protobuf:"varint,2,opt,name=skip_os_adaptation,json=skipOsAdaptation,proto3" json:"skip_os_adaptation,omitempty"`
}

func (x *SchedulePolicy) Reset() {
	*x = SchedulePolicy{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[80]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SchedulePolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SchedulePolicy) ProtoMessage() {}

func (x *SchedulePolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[80]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SchedulePolicy.ProtoReflect.Descriptor instead.
func (*SchedulePolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{80}
}

func (x *SchedulePolicy) GetIdleDuration() *durationpb.Duration {
	if x != nil {
		return x.IdleDuration
	}
	return nil
}

func (x *SchedulePolicy) GetSkipOsAdaptation() bool {
	if x != nil {
		return x.SkipOsAdaptation
	}
	return false
}

// Request message for 'CreateMigratingVm' request.
type CreateMigratingVmRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The MigratingVm's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The migratingVm identifier.
	MigratingVmId string `protobuf:"bytes,2,opt,name=migrating_vm_id,json=migratingVmId,proto3" json:"migrating_vm_id,omitempty"`
	// Required. The create request body.
	MigratingVm *MigratingVm `protobuf:"bytes,3,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateMigratingVmRequest) Reset() {
	*x = CreateMigratingVmRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[81]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateMigratingVmRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMigratingVmRequest) ProtoMessage() {}

func (x *CreateMigratingVmRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[81]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMigratingVmRequest.ProtoReflect.Descriptor instead.
func (*CreateMigratingVmRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{81}
}

func (x *CreateMigratingVmRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMigratingVmRequest) GetMigratingVmId() string {
	if x != nil {
		return x.MigratingVmId
	}
	return ""
}

func (x *CreateMigratingVmRequest) GetMigratingVm() *MigratingVm {
	if x != nil {
		return x.MigratingVm
	}
	return nil
}

func (x *CreateMigratingVmRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'LisMigratingVmsRequest' request.
type ListMigratingVmsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of MigratingVms.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of migrating VMs to return. The service may
	// return fewer than this value. If unspecified, at most 500 migrating VMs
	// will be returned. The maximum value is 1000; values above 1000 will be
	// coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListMigratingVms` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListMigratingVms`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. The level of details of each migrating VM.
	View MigratingVmView `protobuf:"varint,6,opt,name=view,proto3,enum=google.cloud.vmmigration.v1.MigratingVmView" json:"view,omitempty"`
}

func (x *ListMigratingVmsRequest) Reset() {
	*x = ListMigratingVmsRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[82]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMigratingVmsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMigratingVmsRequest) ProtoMessage() {}

func (x *ListMigratingVmsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[82]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMigratingVmsRequest.ProtoReflect.Descriptor instead.
func (*ListMigratingVmsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{82}
}

func (x *ListMigratingVmsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMigratingVmsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMigratingVmsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListMigratingVmsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListMigratingVmsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListMigratingVmsRequest) GetView() MigratingVmView {
	if x != nil {
		return x.View
	}
	return MigratingVmView_MIGRATING_VM_VIEW_UNSPECIFIED
}

// Response message for 'ListMigratingVms' request.
type ListMigratingVmsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of Migrating VMs response.
	MigratingVms []*MigratingVm `protobuf:"bytes,1,rep,name=migrating_vms,json=migratingVms,proto3" json:"migrating_vms,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListMigratingVmsResponse) Reset() {
	*x = ListMigratingVmsResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[83]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListMigratingVmsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMigratingVmsResponse) ProtoMessage() {}

func (x *ListMigratingVmsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[83]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMigratingVmsResponse.ProtoReflect.Descriptor instead.
func (*ListMigratingVmsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{83}
}

func (x *ListMigratingVmsResponse) GetMigratingVms() []*MigratingVm {
	if x != nil {
		return x.MigratingVms
	}
	return nil
}

func (x *ListMigratingVmsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListMigratingVmsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetMigratingVm' request.
type GetMigratingVmRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MigratingVm.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The level of details of the migrating VM.
	View MigratingVmView `protobuf:"varint,2,opt,name=view,proto3,enum=google.cloud.vmmigration.v1.MigratingVmView" json:"view,omitempty"`
}

func (x *GetMigratingVmRequest) Reset() {
	*x = GetMigratingVmRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[84]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetMigratingVmRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMigratingVmRequest) ProtoMessage() {}

func (x *GetMigratingVmRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[84]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMigratingVmRequest.ProtoReflect.Descriptor instead.
func (*GetMigratingVmRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{84}
}

func (x *GetMigratingVmRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *GetMigratingVmRequest) GetView() MigratingVmView {
	if x != nil {
		return x.View
	}
	return MigratingVmView_MIGRATING_VM_VIEW_UNSPECIFIED
}

// Request message for 'UpdateMigratingVm' request.
type UpdateMigratingVmRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Field mask is used to specify the fields to be overwritten in the
	// MigratingVm resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The update request body.
	MigratingVm *MigratingVm `protobuf:"bytes,2,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateMigratingVmRequest) Reset() {
	*x = UpdateMigratingVmRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[85]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateMigratingVmRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateMigratingVmRequest) ProtoMessage() {}

func (x *UpdateMigratingVmRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[85]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateMigratingVmRequest.ProtoReflect.Descriptor instead.
func (*UpdateMigratingVmRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{85}
}

func (x *UpdateMigratingVmRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateMigratingVmRequest) GetMigratingVm() *MigratingVm {
	if x != nil {
		return x.MigratingVm
	}
	return nil
}

func (x *UpdateMigratingVmRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteMigratingVm' request.
type DeleteMigratingVmRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MigratingVm.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteMigratingVmRequest) Reset() {
	*x = DeleteMigratingVmRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[86]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteMigratingVmRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteMigratingVmRequest) ProtoMessage() {}

func (x *DeleteMigratingVmRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[86]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteMigratingVmRequest.ProtoReflect.Descriptor instead.
func (*DeleteMigratingVmRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{86}
}

func (x *DeleteMigratingVmRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'StartMigrationRequest' request.
type StartMigrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MigratingVm.
	MigratingVm string `protobuf:"bytes,1,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
}

func (x *StartMigrationRequest) Reset() {
	*x = StartMigrationRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[87]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartMigrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartMigrationRequest) ProtoMessage() {}

func (x *StartMigrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[87]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartMigrationRequest.ProtoReflect.Descriptor instead.
func (*StartMigrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{87}
}

func (x *StartMigrationRequest) GetMigratingVm() string {
	if x != nil {
		return x.MigratingVm
	}
	return ""
}

// Response message for 'StartMigration' request.
type StartMigrationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *StartMigrationResponse) Reset() {
	*x = StartMigrationResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[88]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StartMigrationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartMigrationResponse) ProtoMessage() {}

func (x *StartMigrationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[88]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartMigrationResponse.ProtoReflect.Descriptor instead.
func (*StartMigrationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{88}
}

// Request message for 'PauseMigration' request.
type PauseMigrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MigratingVm.
	MigratingVm string `protobuf:"bytes,1,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
}

func (x *PauseMigrationRequest) Reset() {
	*x = PauseMigrationRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[89]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PauseMigrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseMigrationRequest) ProtoMessage() {}

func (x *PauseMigrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[89]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseMigrationRequest.ProtoReflect.Descriptor instead.
func (*PauseMigrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{89}
}

func (x *PauseMigrationRequest) GetMigratingVm() string {
	if x != nil {
		return x.MigratingVm
	}
	return ""
}

// Response message for 'PauseMigration' request.
type PauseMigrationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *PauseMigrationResponse) Reset() {
	*x = PauseMigrationResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[90]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PauseMigrationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PauseMigrationResponse) ProtoMessage() {}

func (x *PauseMigrationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[90]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PauseMigrationResponse.ProtoReflect.Descriptor instead.
func (*PauseMigrationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{90}
}

// Request message for 'ResumeMigration' request.
type ResumeMigrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MigratingVm.
	MigratingVm string `protobuf:"bytes,1,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
}

func (x *ResumeMigrationRequest) Reset() {
	*x = ResumeMigrationRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[91]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResumeMigrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumeMigrationRequest) ProtoMessage() {}

func (x *ResumeMigrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[91]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumeMigrationRequest.ProtoReflect.Descriptor instead.
func (*ResumeMigrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{91}
}

func (x *ResumeMigrationRequest) GetMigratingVm() string {
	if x != nil {
		return x.MigratingVm
	}
	return ""
}

// Response message for 'ResumeMigration' request.
type ResumeMigrationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ResumeMigrationResponse) Reset() {
	*x = ResumeMigrationResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[92]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ResumeMigrationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ResumeMigrationResponse) ProtoMessage() {}

func (x *ResumeMigrationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[92]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ResumeMigrationResponse.ProtoReflect.Descriptor instead.
func (*ResumeMigrationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{92}
}

// Request message for 'FinalizeMigration' request.
type FinalizeMigrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MigratingVm.
	MigratingVm string `protobuf:"bytes,1,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
}

func (x *FinalizeMigrationRequest) Reset() {
	*x = FinalizeMigrationRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[93]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FinalizeMigrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeMigrationRequest) ProtoMessage() {}

func (x *FinalizeMigrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[93]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeMigrationRequest.ProtoReflect.Descriptor instead.
func (*FinalizeMigrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{93}
}

func (x *FinalizeMigrationRequest) GetMigratingVm() string {
	if x != nil {
		return x.MigratingVm
	}
	return ""
}

// Request message for 'ExtendMigrationRequest' request.
type ExtendMigrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the MigratingVm.
	MigratingVm string `protobuf:"bytes,1,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
}

func (x *ExtendMigrationRequest) Reset() {
	*x = ExtendMigrationRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[94]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExtendMigrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtendMigrationRequest) ProtoMessage() {}

func (x *ExtendMigrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[94]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtendMigrationRequest.ProtoReflect.Descriptor instead.
func (*ExtendMigrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{94}
}

func (x *ExtendMigrationRequest) GetMigratingVm() string {
	if x != nil {
		return x.MigratingVm
	}
	return ""
}

// Response message for 'ExtendMigration' request.
type ExtendMigrationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ExtendMigrationResponse) Reset() {
	*x = ExtendMigrationResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[95]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExtendMigrationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExtendMigrationResponse) ProtoMessage() {}

func (x *ExtendMigrationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[95]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExtendMigrationResponse.ProtoReflect.Descriptor instead.
func (*ExtendMigrationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{95}
}

// Response message for 'FinalizeMigration' request.
type FinalizeMigrationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *FinalizeMigrationResponse) Reset() {
	*x = FinalizeMigrationResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[96]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FinalizeMigrationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FinalizeMigrationResponse) ProtoMessage() {}

func (x *FinalizeMigrationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[96]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FinalizeMigrationResponse.ProtoReflect.Descriptor instead.
func (*FinalizeMigrationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{96}
}

// TargetProject message represents a target Compute Engine project for a
// migration or a clone.
type TargetProject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the target project.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The target project ID (number) or project name.
	Project string `protobuf:"bytes,2,opt,name=project,proto3" json:"project,omitempty"`
	// The target project's description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. The time this target project resource was created (not related
	// to when the Compute Engine project it points to was created).
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last time the target project resource was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
}

func (x *TargetProject) Reset() {
	*x = TargetProject{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[97]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TargetProject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TargetProject) ProtoMessage() {}

func (x *TargetProject) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[97]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TargetProject.ProtoReflect.Descriptor instead.
func (*TargetProject) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{97}
}

func (x *TargetProject) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TargetProject) GetProject() string {
	if x != nil {
		return x.Project
	}
	return ""
}

func (x *TargetProject) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TargetProject) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TargetProject) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

// Request message for 'GetTargetProject' call.
type GetTargetProjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The TargetProject name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTargetProjectRequest) Reset() {
	*x = GetTargetProjectRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[98]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTargetProjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTargetProjectRequest) ProtoMessage() {}

func (x *GetTargetProjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[98]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTargetProjectRequest.ProtoReflect.Descriptor instead.
func (*GetTargetProjectRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{98}
}

func (x *GetTargetProjectRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'ListTargetProjects' call.
type ListTargetProjectsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of targets.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of targets to return. The service may return
	// fewer than this value. If unspecified, at most 500 targets will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListTargets` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListTargets` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListTargetProjectsRequest) Reset() {
	*x = ListTargetProjectsRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[99]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTargetProjectsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTargetProjectsRequest) ProtoMessage() {}

func (x *ListTargetProjectsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[99]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTargetProjectsRequest.ProtoReflect.Descriptor instead.
func (*ListTargetProjectsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{99}
}

func (x *ListTargetProjectsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTargetProjectsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTargetProjectsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListTargetProjectsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListTargetProjectsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListTargetProjects' call.
type ListTargetProjectsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of target response.
	TargetProjects []*TargetProject `protobuf:"bytes,1,rep,name=target_projects,json=targetProjects,proto3" json:"target_projects,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListTargetProjectsResponse) Reset() {
	*x = ListTargetProjectsResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[100]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTargetProjectsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTargetProjectsResponse) ProtoMessage() {}

func (x *ListTargetProjectsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[100]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTargetProjectsResponse.ProtoReflect.Descriptor instead.
func (*ListTargetProjectsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{100}
}

func (x *ListTargetProjectsResponse) GetTargetProjects() []*TargetProject {
	if x != nil {
		return x.TargetProjects
	}
	return nil
}

func (x *ListTargetProjectsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListTargetProjectsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'CreateTargetProject' request.
type CreateTargetProjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The TargetProject's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The target_project identifier.
	TargetProjectId string `protobuf:"bytes,2,opt,name=target_project_id,json=targetProjectId,proto3" json:"target_project_id,omitempty"`
	// Required. The create request body.
	TargetProject *TargetProject `protobuf:"bytes,3,opt,name=target_project,json=targetProject,proto3" json:"target_project,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateTargetProjectRequest) Reset() {
	*x = CreateTargetProjectRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[101]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateTargetProjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTargetProjectRequest) ProtoMessage() {}

func (x *CreateTargetProjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[101]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTargetProjectRequest.ProtoReflect.Descriptor instead.
func (*CreateTargetProjectRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{101}
}

func (x *CreateTargetProjectRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTargetProjectRequest) GetTargetProjectId() string {
	if x != nil {
		return x.TargetProjectId
	}
	return ""
}

func (x *CreateTargetProjectRequest) GetTargetProject() *TargetProject {
	if x != nil {
		return x.TargetProject
	}
	return nil
}

func (x *CreateTargetProjectRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Update message for 'UpdateTargetProject' request.
type UpdateTargetProjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Field mask is used to specify the fields to be overwritten in the
	// TargetProject resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The update request body.
	TargetProject *TargetProject `protobuf:"bytes,2,opt,name=target_project,json=targetProject,proto3" json:"target_project,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateTargetProjectRequest) Reset() {
	*x = UpdateTargetProjectRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[102]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateTargetProjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTargetProjectRequest) ProtoMessage() {}

func (x *UpdateTargetProjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[102]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTargetProjectRequest.ProtoReflect.Descriptor instead.
func (*UpdateTargetProjectRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{102}
}

func (x *UpdateTargetProjectRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTargetProjectRequest) GetTargetProject() *TargetProject {
	if x != nil {
		return x.TargetProject
	}
	return nil
}

func (x *UpdateTargetProjectRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteTargetProject' request.
type DeleteTargetProjectRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The TargetProject name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteTargetProjectRequest) Reset() {
	*x = DeleteTargetProjectRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[103]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTargetProjectRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTargetProjectRequest) ProtoMessage() {}

func (x *DeleteTargetProjectRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[103]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTargetProjectRequest.ProtoReflect.Descriptor instead.
func (*DeleteTargetProjectRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{103}
}

func (x *DeleteTargetProjectRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteTargetProjectRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Describes message for 'Group' resource. The Group is a collections of several
// MigratingVms.
type Group struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The Group name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The create time timestamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The update time timestamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// User-provided description of the group.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Display name is a user defined name for this group which can be updated.
	DisplayName string `protobuf:"bytes,5,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Immutable. The target type of this group.
	MigrationTargetType Group_MigrationTargetType `protobuf:"varint,6,opt,name=migration_target_type,json=migrationTargetType,proto3,enum=google.cloud.vmmigration.v1.Group_MigrationTargetType" json:"migration_target_type,omitempty"`
}

func (x *Group) Reset() {
	*x = Group{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[104]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Group) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Group) ProtoMessage() {}

func (x *Group) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[104]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Group.ProtoReflect.Descriptor instead.
func (*Group) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{104}
}

func (x *Group) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Group) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Group) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Group) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *Group) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *Group) GetMigrationTargetType() Group_MigrationTargetType {
	if x != nil {
		return x.MigrationTargetType
	}
	return Group_MIGRATION_TARGET_TYPE_UNSPECIFIED
}

// Request message for 'ListGroups' request.
type ListGroupsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of groups.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of groups to return. The service may return
	// fewer than this value. If unspecified, at most 500 groups will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListGroups` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListGroups` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListGroupsRequest) Reset() {
	*x = ListGroupsRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[105]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGroupsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGroupsRequest) ProtoMessage() {}

func (x *ListGroupsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[105]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGroupsRequest.ProtoReflect.Descriptor instead.
func (*ListGroupsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{105}
}

func (x *ListGroupsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGroupsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGroupsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListGroupsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListGroupsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListGroups' request.
type ListGroupsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of groups response.
	Groups []*Group `protobuf:"bytes,1,rep,name=groups,proto3" json:"groups,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListGroupsResponse) Reset() {
	*x = ListGroupsResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[106]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGroupsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGroupsResponse) ProtoMessage() {}

func (x *ListGroupsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[106]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGroupsResponse.ProtoReflect.Descriptor instead.
func (*ListGroupsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{106}
}

func (x *ListGroupsResponse) GetGroups() []*Group {
	if x != nil {
		return x.Groups
	}
	return nil
}

func (x *ListGroupsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListGroupsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetGroup' request.
type GetGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The group name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGroupRequest) Reset() {
	*x = GetGroupRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[107]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGroupRequest) ProtoMessage() {}

func (x *GetGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[107]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGroupRequest.ProtoReflect.Descriptor instead.
func (*GetGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{107}
}

func (x *GetGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'CreateGroup' request.
type CreateGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Group's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The group identifier.
	GroupId string `protobuf:"bytes,2,opt,name=group_id,json=groupId,proto3" json:"group_id,omitempty"`
	// Required. The create request body.
	Group *Group `protobuf:"bytes,3,opt,name=group,proto3" json:"group,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateGroupRequest) Reset() {
	*x = CreateGroupRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[108]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGroupRequest) ProtoMessage() {}

func (x *CreateGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[108]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGroupRequest.ProtoReflect.Descriptor instead.
func (*CreateGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{108}
}

func (x *CreateGroupRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGroupRequest) GetGroupId() string {
	if x != nil {
		return x.GroupId
	}
	return ""
}

func (x *CreateGroupRequest) GetGroup() *Group {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *CreateGroupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Update message for 'UpdateGroups' request.
type UpdateGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Field mask is used to specify the fields to be overwritten in the
	// Group resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The update request body.
	Group *Group `protobuf:"bytes,2,opt,name=group,proto3" json:"group,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateGroupRequest) Reset() {
	*x = UpdateGroupRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[109]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateGroupRequest) ProtoMessage() {}

func (x *UpdateGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[109]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateGroupRequest.ProtoReflect.Descriptor instead.
func (*UpdateGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{109}
}

func (x *UpdateGroupRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateGroupRequest) GetGroup() *Group {
	if x != nil {
		return x.Group
	}
	return nil
}

func (x *UpdateGroupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteGroup' request.
type DeleteGroupRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Group name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteGroupRequest) Reset() {
	*x = DeleteGroupRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[110]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteGroupRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteGroupRequest) ProtoMessage() {}

func (x *DeleteGroupRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[110]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteGroupRequest.ProtoReflect.Descriptor instead.
func (*DeleteGroupRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{110}
}

func (x *DeleteGroupRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteGroupRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'AddGroupMigration' request.
type AddGroupMigrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The full path name of the Group to add to.
	Group string `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// The full path name of the MigratingVm to add.
	MigratingVm string `protobuf:"bytes,2,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
}

func (x *AddGroupMigrationRequest) Reset() {
	*x = AddGroupMigrationRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[111]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddGroupMigrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddGroupMigrationRequest) ProtoMessage() {}

func (x *AddGroupMigrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[111]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddGroupMigrationRequest.ProtoReflect.Descriptor instead.
func (*AddGroupMigrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{111}
}

func (x *AddGroupMigrationRequest) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *AddGroupMigrationRequest) GetMigratingVm() string {
	if x != nil {
		return x.MigratingVm
	}
	return ""
}

// Response message for 'AddGroupMigration' request.
type AddGroupMigrationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *AddGroupMigrationResponse) Reset() {
	*x = AddGroupMigrationResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[112]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AddGroupMigrationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AddGroupMigrationResponse) ProtoMessage() {}

func (x *AddGroupMigrationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[112]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AddGroupMigrationResponse.ProtoReflect.Descriptor instead.
func (*AddGroupMigrationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{112}
}

// Request message for 'RemoveMigration' request.
type RemoveGroupMigrationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Group.
	Group string `protobuf:"bytes,1,opt,name=group,proto3" json:"group,omitempty"`
	// The MigratingVm to remove.
	MigratingVm string `protobuf:"bytes,2,opt,name=migrating_vm,json=migratingVm,proto3" json:"migrating_vm,omitempty"`
}

func (x *RemoveGroupMigrationRequest) Reset() {
	*x = RemoveGroupMigrationRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[113]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveGroupMigrationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveGroupMigrationRequest) ProtoMessage() {}

func (x *RemoveGroupMigrationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[113]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveGroupMigrationRequest.ProtoReflect.Descriptor instead.
func (*RemoveGroupMigrationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{113}
}

func (x *RemoveGroupMigrationRequest) GetGroup() string {
	if x != nil {
		return x.Group
	}
	return ""
}

func (x *RemoveGroupMigrationRequest) GetMigratingVm() string {
	if x != nil {
		return x.MigratingVm
	}
	return ""
}

// Response message for 'RemoveMigration' request.
type RemoveGroupMigrationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RemoveGroupMigrationResponse) Reset() {
	*x = RemoveGroupMigrationResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[114]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RemoveGroupMigrationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RemoveGroupMigrationResponse) ProtoMessage() {}

func (x *RemoveGroupMigrationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[114]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RemoveGroupMigrationResponse.ProtoReflect.Descriptor instead.
func (*RemoveGroupMigrationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{114}
}

// Request message for 'CreateCutoverJob' request.
type CreateCutoverJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Cutover's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The cutover job identifier.
	CutoverJobId string `protobuf:"bytes,2,opt,name=cutover_job_id,json=cutoverJobId,proto3" json:"cutover_job_id,omitempty"`
	// Required. The cutover request body.
	CutoverJob *CutoverJob `protobuf:"bytes,3,opt,name=cutover_job,json=cutoverJob,proto3" json:"cutover_job,omitempty"`
	// A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateCutoverJobRequest) Reset() {
	*x = CreateCutoverJobRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[115]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateCutoverJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCutoverJobRequest) ProtoMessage() {}

func (x *CreateCutoverJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[115]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCutoverJobRequest.ProtoReflect.Descriptor instead.
func (*CreateCutoverJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{115}
}

func (x *CreateCutoverJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateCutoverJobRequest) GetCutoverJobId() string {
	if x != nil {
		return x.CutoverJobId
	}
	return ""
}

func (x *CreateCutoverJobRequest) GetCutoverJob() *CutoverJob {
	if x != nil {
		return x.CutoverJob
	}
	return nil
}

func (x *CreateCutoverJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'CancelCutoverJob' request.
type CancelCutoverJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The cutover job id
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelCutoverJobRequest) Reset() {
	*x = CancelCutoverJobRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[116]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelCutoverJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelCutoverJobRequest) ProtoMessage() {}

func (x *CancelCutoverJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[116]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelCutoverJobRequest.ProtoReflect.Descriptor instead.
func (*CancelCutoverJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{116}
}

func (x *CancelCutoverJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for 'CancelCutoverJob' request.
type CancelCutoverJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CancelCutoverJobResponse) Reset() {
	*x = CancelCutoverJobResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[117]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelCutoverJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelCutoverJobResponse) ProtoMessage() {}

func (x *CancelCutoverJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[117]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelCutoverJobResponse.ProtoReflect.Descriptor instead.
func (*CancelCutoverJobResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{117}
}

// Request message for 'ListCutoverJobsRequest' request.
type ListCutoverJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of migrating VMs.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of cutover jobs to return. The service may
	// return fewer than this value. If unspecified, at most 500 cutover jobs will
	// be returned. The maximum value is 1000; values above 1000 will be coerced
	// to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListCutoverJobs` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListCutoverJobs` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListCutoverJobsRequest) Reset() {
	*x = ListCutoverJobsRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[118]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCutoverJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCutoverJobsRequest) ProtoMessage() {}

func (x *ListCutoverJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[118]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCutoverJobsRequest.ProtoReflect.Descriptor instead.
func (*ListCutoverJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{118}
}

func (x *ListCutoverJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListCutoverJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListCutoverJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListCutoverJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListCutoverJobsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListCutoverJobs' request.
type ListCutoverJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of cutover jobs response.
	CutoverJobs []*CutoverJob `protobuf:"bytes,1,rep,name=cutover_jobs,json=cutoverJobs,proto3" json:"cutover_jobs,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListCutoverJobsResponse) Reset() {
	*x = ListCutoverJobsResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[119]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListCutoverJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListCutoverJobsResponse) ProtoMessage() {}

func (x *ListCutoverJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[119]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListCutoverJobsResponse.ProtoReflect.Descriptor instead.
func (*ListCutoverJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{119}
}

func (x *ListCutoverJobsResponse) GetCutoverJobs() []*CutoverJob {
	if x != nil {
		return x.CutoverJobs
	}
	return nil
}

func (x *ListCutoverJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListCutoverJobsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetCutoverJob' request.
type GetCutoverJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the CutoverJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetCutoverJobRequest) Reset() {
	*x = GetCutoverJobRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[120]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetCutoverJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCutoverJobRequest) ProtoMessage() {}

func (x *GetCutoverJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[120]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCutoverJobRequest.ProtoReflect.Descriptor instead.
func (*GetCutoverJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{120}
}

func (x *GetCutoverJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have successfully been cancelled
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[121]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[121]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{121}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Represents migration resource error information that can be used with
// google.rpc.Status message. MigrationError is used to present the user with
// error information in migration operations.
type MigrationError struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The error code.
	Code MigrationError_ErrorCode `protobuf:"varint,1,opt,name=code,proto3,enum=google.cloud.vmmigration.v1.MigrationError_ErrorCode" json:"code,omitempty"`
	// Output only. The localized error message.
	ErrorMessage *errdetails.LocalizedMessage `protobuf:"bytes,2,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Output only. Suggested action for solving the error.
	ActionItem *errdetails.LocalizedMessage `protobuf:"bytes,3,opt,name=action_item,json=actionItem,proto3" json:"action_item,omitempty"`
	// Output only. URL(s) pointing to additional information on handling the
	// current error.
	HelpLinks []*errdetails.Help_Link `protobuf:"bytes,4,rep,name=help_links,json=helpLinks,proto3" json:"help_links,omitempty"`
	// Output only. The time the error occurred.
	ErrorTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=error_time,json=errorTime,proto3" json:"error_time,omitempty"`
}

func (x *MigrationError) Reset() {
	*x = MigrationError{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[122]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MigrationError) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrationError) ProtoMessage() {}

func (x *MigrationError) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[122]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrationError.ProtoReflect.Descriptor instead.
func (*MigrationError) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{122}
}

func (x *MigrationError) GetCode() MigrationError_ErrorCode {
	if x != nil {
		return x.Code
	}
	return MigrationError_ERROR_CODE_UNSPECIFIED
}

func (x *MigrationError) GetErrorMessage() *errdetails.LocalizedMessage {
	if x != nil {
		return x.ErrorMessage
	}
	return nil
}

func (x *MigrationError) GetActionItem() *errdetails.LocalizedMessage {
	if x != nil {
		return x.ActionItem
	}
	return nil
}

func (x *MigrationError) GetHelpLinks() []*errdetails.Help_Link {
	if x != nil {
		return x.HelpLinks
	}
	return nil
}

func (x *MigrationError) GetErrorTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ErrorTime
	}
	return nil
}

// Represents migration resource warning information that can be used with
// google.rpc.Status message. MigrationWarning is used to present the user with
// warning information in migration operations.
type MigrationWarning struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The warning code.
	Code MigrationWarning_WarningCode `protobuf:"varint,1,opt,name=code,proto3,enum=google.cloud.vmmigration.v1.MigrationWarning_WarningCode" json:"code,omitempty"`
	// Output only. The localized warning message.
	WarningMessage *errdetails.LocalizedMessage `protobuf:"bytes,2,opt,name=warning_message,json=warningMessage,proto3" json:"warning_message,omitempty"`
	// Output only. Suggested action for solving the warning.
	ActionItem *errdetails.LocalizedMessage `protobuf:"bytes,3,opt,name=action_item,json=actionItem,proto3" json:"action_item,omitempty"`
	// Output only. URL(s) pointing to additional information on handling the
	// current warning.
	HelpLinks []*errdetails.Help_Link `protobuf:"bytes,4,rep,name=help_links,json=helpLinks,proto3" json:"help_links,omitempty"`
	// The time the warning occurred.
	WarningTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=warning_time,json=warningTime,proto3" json:"warning_time,omitempty"`
}

func (x *MigrationWarning) Reset() {
	*x = MigrationWarning{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[123]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MigrationWarning) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigrationWarning) ProtoMessage() {}

func (x *MigrationWarning) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[123]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigrationWarning.ProtoReflect.Descriptor instead.
func (*MigrationWarning) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{123}
}

func (x *MigrationWarning) GetCode() MigrationWarning_WarningCode {
	if x != nil {
		return x.Code
	}
	return MigrationWarning_WARNING_CODE_UNSPECIFIED
}

func (x *MigrationWarning) GetWarningMessage() *errdetails.LocalizedMessage {
	if x != nil {
		return x.WarningMessage
	}
	return nil
}

func (x *MigrationWarning) GetActionItem() *errdetails.LocalizedMessage {
	if x != nil {
		return x.ActionItem
	}
	return nil
}

func (x *MigrationWarning) GetHelpLinks() []*errdetails.Help_Link {
	if x != nil {
		return x.HelpLinks
	}
	return nil
}

func (x *MigrationWarning) GetWarningTime() *timestamppb.Timestamp {
	if x != nil {
		return x.WarningTime
	}
	return nil
}

// Represent the source Vmware VM details.
type VmwareSourceVmDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The firmware type of the source VM.
	Firmware VmwareSourceVmDetails_Firmware `protobuf:"varint,1,opt,name=firmware,proto3,enum=google.cloud.vmmigration.v1.VmwareSourceVmDetails_Firmware" json:"firmware,omitempty"`
	// Output only. The total size of the disks being migrated in bytes.
	CommittedStorageBytes int64 `protobuf:"varint,2,opt,name=committed_storage_bytes,json=committedStorageBytes,proto3" json:"committed_storage_bytes,omitempty"`
	// Output only. The disks attached to the source VM.
	Disks []*VmwareSourceVmDetails_VmwareDiskDetails `protobuf:"bytes,3,rep,name=disks,proto3" json:"disks,omitempty"`
	// Output only. Information about VM capabilities needed for some Compute
	// Engine features.
	VmCapabilitiesInfo *VmCapabilities `protobuf:"bytes,5,opt,name=vm_capabilities_info,json=vmCapabilitiesInfo,proto3" json:"vm_capabilities_info,omitempty"`
	// Output only. The VM architecture.
	Architecture VmArchitecture `protobuf:"varint,6,opt,name=architecture,proto3,enum=google.cloud.vmmigration.v1.VmArchitecture" json:"architecture,omitempty"`
}

func (x *VmwareSourceVmDetails) Reset() {
	*x = VmwareSourceVmDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[124]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VmwareSourceVmDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareSourceVmDetails) ProtoMessage() {}

func (x *VmwareSourceVmDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[124]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareSourceVmDetails.ProtoReflect.Descriptor instead.
func (*VmwareSourceVmDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{124}
}

func (x *VmwareSourceVmDetails) GetFirmware() VmwareSourceVmDetails_Firmware {
	if x != nil {
		return x.Firmware
	}
	return VmwareSourceVmDetails_FIRMWARE_UNSPECIFIED
}

func (x *VmwareSourceVmDetails) GetCommittedStorageBytes() int64 {
	if x != nil {
		return x.CommittedStorageBytes
	}
	return 0
}

func (x *VmwareSourceVmDetails) GetDisks() []*VmwareSourceVmDetails_VmwareDiskDetails {
	if x != nil {
		return x.Disks
	}
	return nil
}

func (x *VmwareSourceVmDetails) GetVmCapabilitiesInfo() *VmCapabilities {
	if x != nil {
		return x.VmCapabilitiesInfo
	}
	return nil
}

func (x *VmwareSourceVmDetails) GetArchitecture() VmArchitecture {
	if x != nil {
		return x.Architecture
	}
	return VmArchitecture_VM_ARCHITECTURE_UNSPECIFIED
}

// Represent the source AWS VM details.
type AwsSourceVmDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The firmware type of the source VM.
	Firmware AwsSourceVmDetails_Firmware `protobuf:"varint,1,opt,name=firmware,proto3,enum=google.cloud.vmmigration.v1.AwsSourceVmDetails_Firmware" json:"firmware,omitempty"`
	// Output only. The total size of the disks being migrated in bytes.
	CommittedStorageBytes int64 `protobuf:"varint,2,opt,name=committed_storage_bytes,json=committedStorageBytes,proto3" json:"committed_storage_bytes,omitempty"`
	// Output only. The disks attached to the source VM.
	Disks []*AwsSourceVmDetails_AwsDiskDetails `protobuf:"bytes,3,rep,name=disks,proto3" json:"disks,omitempty"`
	// Output only. Information about VM capabilities needed for some Compute
	// Engine features.
	VmCapabilitiesInfo *VmCapabilities `protobuf:"bytes,5,opt,name=vm_capabilities_info,json=vmCapabilitiesInfo,proto3" json:"vm_capabilities_info,omitempty"`
	// Output only. The VM architecture.
	Architecture VmArchitecture `protobuf:"varint,6,opt,name=architecture,proto3,enum=google.cloud.vmmigration.v1.VmArchitecture" json:"architecture,omitempty"`
}

func (x *AwsSourceVmDetails) Reset() {
	*x = AwsSourceVmDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[125]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AwsSourceVmDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsSourceVmDetails) ProtoMessage() {}

func (x *AwsSourceVmDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[125]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsSourceVmDetails.ProtoReflect.Descriptor instead.
func (*AwsSourceVmDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{125}
}

func (x *AwsSourceVmDetails) GetFirmware() AwsSourceVmDetails_Firmware {
	if x != nil {
		return x.Firmware
	}
	return AwsSourceVmDetails_FIRMWARE_UNSPECIFIED
}

func (x *AwsSourceVmDetails) GetCommittedStorageBytes() int64 {
	if x != nil {
		return x.CommittedStorageBytes
	}
	return 0
}

func (x *AwsSourceVmDetails) GetDisks() []*AwsSourceVmDetails_AwsDiskDetails {
	if x != nil {
		return x.Disks
	}
	return nil
}

func (x *AwsSourceVmDetails) GetVmCapabilitiesInfo() *VmCapabilities {
	if x != nil {
		return x.VmCapabilitiesInfo
	}
	return nil
}

func (x *AwsSourceVmDetails) GetArchitecture() VmArchitecture {
	if x != nil {
		return x.Architecture
	}
	return VmArchitecture_VM_ARCHITECTURE_UNSPECIFIED
}

// Represent the source Azure VM details.
type AzureSourceVmDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The firmware type of the source VM.
	Firmware AzureSourceVmDetails_Firmware `protobuf:"varint,1,opt,name=firmware,proto3,enum=google.cloud.vmmigration.v1.AzureSourceVmDetails_Firmware" json:"firmware,omitempty"`
	// Output only. The total size of the disks being migrated in bytes.
	CommittedStorageBytes int64 `protobuf:"varint,2,opt,name=committed_storage_bytes,json=committedStorageBytes,proto3" json:"committed_storage_bytes,omitempty"`
	// Output only. The disks attached to the source VM.
	Disks []*AzureSourceVmDetails_AzureDiskDetails `protobuf:"bytes,3,rep,name=disks,proto3" json:"disks,omitempty"`
	// Output only. Information about VM capabilities needed for some Compute
	// Engine features.
	VmCapabilitiesInfo *VmCapabilities `protobuf:"bytes,5,opt,name=vm_capabilities_info,json=vmCapabilitiesInfo,proto3" json:"vm_capabilities_info,omitempty"`
	// Output only. The VM architecture.
	Architecture VmArchitecture `protobuf:"varint,6,opt,name=architecture,proto3,enum=google.cloud.vmmigration.v1.VmArchitecture" json:"architecture,omitempty"`
}

func (x *AzureSourceVmDetails) Reset() {
	*x = AzureSourceVmDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[126]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AzureSourceVmDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureSourceVmDetails) ProtoMessage() {}

func (x *AzureSourceVmDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[126]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureSourceVmDetails.ProtoReflect.Descriptor instead.
func (*AzureSourceVmDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{126}
}

func (x *AzureSourceVmDetails) GetFirmware() AzureSourceVmDetails_Firmware {
	if x != nil {
		return x.Firmware
	}
	return AzureSourceVmDetails_FIRMWARE_UNSPECIFIED
}

func (x *AzureSourceVmDetails) GetCommittedStorageBytes() int64 {
	if x != nil {
		return x.CommittedStorageBytes
	}
	return 0
}

func (x *AzureSourceVmDetails) GetDisks() []*AzureSourceVmDetails_AzureDiskDetails {
	if x != nil {
		return x.Disks
	}
	return nil
}

func (x *AzureSourceVmDetails) GetVmCapabilitiesInfo() *VmCapabilities {
	if x != nil {
		return x.VmCapabilitiesInfo
	}
	return nil
}

func (x *AzureSourceVmDetails) GetArchitecture() VmArchitecture {
	if x != nil {
		return x.Architecture
	}
	return VmArchitecture_VM_ARCHITECTURE_UNSPECIFIED
}

// Request message for 'LisReplicationCyclesRequest' request.
type ListReplicationCyclesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of ReplicationCycles.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of replication cycles to return. The service
	// may return fewer than this value. If unspecified, at most 100 migrating VMs
	// will be returned. The maximum value is 100; values above 100 will be
	// coerced to 100.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Required. A page token, received from a previous `ListReplicationCycles`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListReplicationCycles`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. the order by fields for the result.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListReplicationCyclesRequest) Reset() {
	*x = ListReplicationCyclesRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[127]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListReplicationCyclesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReplicationCyclesRequest) ProtoMessage() {}

func (x *ListReplicationCyclesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[127]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReplicationCyclesRequest.ProtoReflect.Descriptor instead.
func (*ListReplicationCyclesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{127}
}

func (x *ListReplicationCyclesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListReplicationCyclesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReplicationCyclesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListReplicationCyclesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListReplicationCyclesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListReplicationCycles' request.
type ListReplicationCyclesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of replication cycles response.
	ReplicationCycles []*ReplicationCycle `protobuf:"bytes,1,rep,name=replication_cycles,json=replicationCycles,proto3" json:"replication_cycles,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListReplicationCyclesResponse) Reset() {
	*x = ListReplicationCyclesResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[128]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListReplicationCyclesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReplicationCyclesResponse) ProtoMessage() {}

func (x *ListReplicationCyclesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[128]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReplicationCyclesResponse.ProtoReflect.Descriptor instead.
func (*ListReplicationCyclesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{128}
}

func (x *ListReplicationCyclesResponse) GetReplicationCycles() []*ReplicationCycle {
	if x != nil {
		return x.ReplicationCycles
	}
	return nil
}

func (x *ListReplicationCyclesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListReplicationCyclesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetReplicationCycle' request.
type GetReplicationCycleRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the ReplicationCycle.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetReplicationCycleRequest) Reset() {
	*x = GetReplicationCycleRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[129]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetReplicationCycleRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetReplicationCycleRequest) ProtoMessage() {}

func (x *GetReplicationCycleRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[129]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetReplicationCycleRequest.ProtoReflect.Descriptor instead.
func (*GetReplicationCycleRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{129}
}

func (x *GetReplicationCycleRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Migrating VM source information about the VM capabilities needed for some
// Compute Engine features.
type VmCapabilities struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Unordered list. List of certain VM OS capabilities needed for
	// some Compute Engine features.
	OsCapabilities []OsCapability `protobuf:"varint,1,rep,packed,name=os_capabilities,json=osCapabilities,proto3,enum=google.cloud.vmmigration.v1.OsCapability" json:"os_capabilities,omitempty"`
	// Output only. The last time OS capabilities list was updated.
	LastOsCapabilitiesUpdateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=last_os_capabilities_update_time,json=lastOsCapabilitiesUpdateTime,proto3" json:"last_os_capabilities_update_time,omitempty"`
}

func (x *VmCapabilities) Reset() {
	*x = VmCapabilities{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[130]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VmCapabilities) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmCapabilities) ProtoMessage() {}

func (x *VmCapabilities) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[130]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmCapabilities.ProtoReflect.Descriptor instead.
func (*VmCapabilities) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{130}
}

func (x *VmCapabilities) GetOsCapabilities() []OsCapability {
	if x != nil {
		return x.OsCapabilities
	}
	return nil
}

func (x *VmCapabilities) GetLastOsCapabilitiesUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.LastOsCapabilitiesUpdateTime
	}
	return nil
}

// ImageImport describes the configuration of the image import to run.
type ImageImport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Source:
	//
	//	*ImageImport_CloudStorageUri
	Source isImageImport_Source `protobuf_oneof:"source"`
	// The configuration of the resources that will be created in GCP as a result
	// of the ImageImport.
	//
	// Types that are assignable to TargetDefaults:
	//
	//	*ImageImport_DiskImageTargetDefaults
	//	*ImageImport_MachineImageTargetDefaults
	TargetDefaults isImageImport_TargetDefaults `protobuf_oneof:"target_defaults"`
	// Output only. The resource path of the ImageImport.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time the image import was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The result of the most recent runs for this ImageImport. All
	// jobs for this ImageImport can be listed via ListImageImportJobs.
	RecentImageImportJobs []*ImageImportJob `protobuf:"bytes,5,rep,name=recent_image_import_jobs,json=recentImageImportJobs,proto3" json:"recent_image_import_jobs,omitempty"`
	// Immutable. The encryption details used by the image import process during
	// the image adaptation for Compute Engine.
	Encryption *Encryption `protobuf:"bytes,6,opt,name=encryption,proto3" json:"encryption,omitempty"`
}

func (x *ImageImport) Reset() {
	*x = ImageImport{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[131]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageImport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageImport) ProtoMessage() {}

func (x *ImageImport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[131]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageImport.ProtoReflect.Descriptor instead.
func (*ImageImport) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{131}
}

func (m *ImageImport) GetSource() isImageImport_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImageImport) GetCloudStorageUri() string {
	if x, ok := x.GetSource().(*ImageImport_CloudStorageUri); ok {
		return x.CloudStorageUri
	}
	return ""
}

func (m *ImageImport) GetTargetDefaults() isImageImport_TargetDefaults {
	if m != nil {
		return m.TargetDefaults
	}
	return nil
}

func (x *ImageImport) GetDiskImageTargetDefaults() *DiskImageTargetDetails {
	if x, ok := x.GetTargetDefaults().(*ImageImport_DiskImageTargetDefaults); ok {
		return x.DiskImageTargetDefaults
	}
	return nil
}

func (x *ImageImport) GetMachineImageTargetDefaults() *MachineImageTargetDetails {
	if x, ok := x.GetTargetDefaults().(*ImageImport_MachineImageTargetDefaults); ok {
		return x.MachineImageTargetDefaults
	}
	return nil
}

func (x *ImageImport) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ImageImport) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ImageImport) GetRecentImageImportJobs() []*ImageImportJob {
	if x != nil {
		return x.RecentImageImportJobs
	}
	return nil
}

func (x *ImageImport) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

type isImageImport_Source interface {
	isImageImport_Source()
}

type ImageImport_CloudStorageUri struct {
	// Immutable. The path to the Cloud Storage file from which the image should
	// be imported.
	CloudStorageUri string `protobuf:"bytes,2,opt,name=cloud_storage_uri,json=cloudStorageUri,proto3,oneof"`
}

func (*ImageImport_CloudStorageUri) isImageImport_Source() {}

type isImageImport_TargetDefaults interface {
	isImageImport_TargetDefaults()
}

type ImageImport_DiskImageTargetDefaults struct {
	// Immutable. Target details for importing a disk image, will be used by
	// ImageImportJob.
	DiskImageTargetDefaults *DiskImageTargetDetails `protobuf:"bytes,4,opt,name=disk_image_target_defaults,json=diskImageTargetDefaults,proto3,oneof"`
}

type ImageImport_MachineImageTargetDefaults struct {
	// Immutable. Target details for importing a machine image, will be used by
	// ImageImportJob.
	MachineImageTargetDefaults *MachineImageTargetDetails `protobuf:"bytes,7,opt,name=machine_image_target_defaults,json=machineImageTargetDefaults,proto3,oneof"`
}

func (*ImageImport_DiskImageTargetDefaults) isImageImport_TargetDefaults() {}

func (*ImageImport_MachineImageTargetDefaults) isImageImport_TargetDefaults() {}

// ImageImportJob describes the progress and result of an image import.
type ImageImportJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Source:
	//
	//	*ImageImportJob_CloudStorageUri
	Source isImageImportJob_Source `protobuf_oneof:"source"`
	// The configuration of the resources that were created in GCP as a result of
	// the image import.
	//
	// Types that are assignable to TargetDetails:
	//
	//	*ImageImportJob_DiskImageTargetDetails
	//	*ImageImportJob_MachineImageTargetDetails
	TargetDetails isImageImportJob_TargetDetails `protobuf_oneof:"target_details"`
	// Output only. The resource path of the ImageImportJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The resource paths of the resources created by the image
	// import job.
	CreatedResources []string `protobuf:"bytes,2,rep,name=created_resources,json=createdResources,proto3" json:"created_resources,omitempty"`
	// Output only. The state of the image import.
	State ImageImportJob_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.ImageImportJob_State" json:"state,omitempty"`
	// Output only. The time the image import was created (as an API call, not
	// when it was actually created in the target).
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the image import was ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Provides details on the error that led to the image import
	// state in case of an error.
	Errors []*status.Status `protobuf:"bytes,7,rep,name=errors,proto3" json:"errors,omitempty"`
	// Output only. Warnings that occurred during the image import.
	Warnings []*MigrationWarning `protobuf:"bytes,8,rep,name=warnings,proto3" json:"warnings,omitempty"`
	// Output only. The image import steps list representing its progress.
	Steps []*ImageImportStep `protobuf:"bytes,9,rep,name=steps,proto3" json:"steps,omitempty"`
}

func (x *ImageImportJob) Reset() {
	*x = ImageImportJob{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[132]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageImportJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageImportJob) ProtoMessage() {}

func (x *ImageImportJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[132]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageImportJob.ProtoReflect.Descriptor instead.
func (*ImageImportJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{132}
}

func (m *ImageImportJob) GetSource() isImageImportJob_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ImageImportJob) GetCloudStorageUri() string {
	if x, ok := x.GetSource().(*ImageImportJob_CloudStorageUri); ok {
		return x.CloudStorageUri
	}
	return ""
}

func (m *ImageImportJob) GetTargetDetails() isImageImportJob_TargetDetails {
	if m != nil {
		return m.TargetDetails
	}
	return nil
}

func (x *ImageImportJob) GetDiskImageTargetDetails() *DiskImageTargetDetails {
	if x, ok := x.GetTargetDetails().(*ImageImportJob_DiskImageTargetDetails); ok {
		return x.DiskImageTargetDetails
	}
	return nil
}

func (x *ImageImportJob) GetMachineImageTargetDetails() *MachineImageTargetDetails {
	if x, ok := x.GetTargetDetails().(*ImageImportJob_MachineImageTargetDetails); ok {
		return x.MachineImageTargetDetails
	}
	return nil
}

func (x *ImageImportJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ImageImportJob) GetCreatedResources() []string {
	if x != nil {
		return x.CreatedResources
	}
	return nil
}

func (x *ImageImportJob) GetState() ImageImportJob_State {
	if x != nil {
		return x.State
	}
	return ImageImportJob_STATE_UNSPECIFIED
}

func (x *ImageImportJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ImageImportJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *ImageImportJob) GetErrors() []*status.Status {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *ImageImportJob) GetWarnings() []*MigrationWarning {
	if x != nil {
		return x.Warnings
	}
	return nil
}

func (x *ImageImportJob) GetSteps() []*ImageImportStep {
	if x != nil {
		return x.Steps
	}
	return nil
}

type isImageImportJob_Source interface {
	isImageImportJob_Source()
}

type ImageImportJob_CloudStorageUri struct {
	// Output only. The path to the Cloud Storage file from which the image
	// should be imported.
	CloudStorageUri string `protobuf:"bytes,10,opt,name=cloud_storage_uri,json=cloudStorageUri,proto3,oneof"`
}

func (*ImageImportJob_CloudStorageUri) isImageImportJob_Source() {}

type isImageImportJob_TargetDetails interface {
	isImageImportJob_TargetDetails()
}

type ImageImportJob_DiskImageTargetDetails struct {
	// Output only. Target details used to import a disk image.
	DiskImageTargetDetails *DiskImageTargetDetails `protobuf:"bytes,3,opt,name=disk_image_target_details,json=diskImageTargetDetails,proto3,oneof"`
}

type ImageImportJob_MachineImageTargetDetails struct {
	// Output only. Target details used to import a machine image.
	MachineImageTargetDetails *MachineImageTargetDetails `protobuf:"bytes,11,opt,name=machine_image_target_details,json=machineImageTargetDetails,proto3,oneof"`
}

func (*ImageImportJob_DiskImageTargetDetails) isImageImportJob_TargetDetails() {}

func (*ImageImportJob_MachineImageTargetDetails) isImageImportJob_TargetDetails() {}

// ImageImportStep holds information about the image import step progress.
type ImageImportStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Step:
	//
	//	*ImageImportStep_Initializing
	//	*ImageImportStep_LoadingSourceFiles
	//	*ImageImportStep_AdaptingOs
	//	*ImageImportStep_CreatingImage
	Step isImageImportStep_Step `protobuf_oneof:"step"`
	// Output only. The time the step has started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The time the step has ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *ImageImportStep) Reset() {
	*x = ImageImportStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[133]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageImportStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageImportStep) ProtoMessage() {}

func (x *ImageImportStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[133]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageImportStep.ProtoReflect.Descriptor instead.
func (*ImageImportStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{133}
}

func (m *ImageImportStep) GetStep() isImageImportStep_Step {
	if m != nil {
		return m.Step
	}
	return nil
}

func (x *ImageImportStep) GetInitializing() *InitializingImageImportStep {
	if x, ok := x.GetStep().(*ImageImportStep_Initializing); ok {
		return x.Initializing
	}
	return nil
}

func (x *ImageImportStep) GetLoadingSourceFiles() *LoadingImageSourceFilesStep {
	if x, ok := x.GetStep().(*ImageImportStep_LoadingSourceFiles); ok {
		return x.LoadingSourceFiles
	}
	return nil
}

func (x *ImageImportStep) GetAdaptingOs() *AdaptingOSStep {
	if x, ok := x.GetStep().(*ImageImportStep_AdaptingOs); ok {
		return x.AdaptingOs
	}
	return nil
}

func (x *ImageImportStep) GetCreatingImage() *CreatingImageStep {
	if x, ok := x.GetStep().(*ImageImportStep_CreatingImage); ok {
		return x.CreatingImage
	}
	return nil
}

func (x *ImageImportStep) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *ImageImportStep) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isImageImportStep_Step interface {
	isImageImportStep_Step()
}

type ImageImportStep_Initializing struct {
	// Initializing step.
	Initializing *InitializingImageImportStep `protobuf:"bytes,3,opt,name=initializing,proto3,oneof"`
}

type ImageImportStep_LoadingSourceFiles struct {
	// Loading source files step.
	LoadingSourceFiles *LoadingImageSourceFilesStep `protobuf:"bytes,4,opt,name=loading_source_files,json=loadingSourceFiles,proto3,oneof"`
}

type ImageImportStep_AdaptingOs struct {
	// Adapting OS step.
	AdaptingOs *AdaptingOSStep `protobuf:"bytes,5,opt,name=adapting_os,json=adaptingOs,proto3,oneof"`
}

type ImageImportStep_CreatingImage struct {
	// Creating image step.
	CreatingImage *CreatingImageStep `protobuf:"bytes,6,opt,name=creating_image,json=creatingImage,proto3,oneof"`
}

func (*ImageImportStep_Initializing) isImageImportStep_Step() {}

func (*ImageImportStep_LoadingSourceFiles) isImageImportStep_Step() {}

func (*ImageImportStep_AdaptingOs) isImageImportStep_Step() {}

func (*ImageImportStep_CreatingImage) isImageImportStep_Step() {}

// InitializingImageImportStep contains specific step details.
type InitializingImageImportStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *InitializingImageImportStep) Reset() {
	*x = InitializingImageImportStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[134]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *InitializingImageImportStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InitializingImageImportStep) ProtoMessage() {}

func (x *InitializingImageImportStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[134]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InitializingImageImportStep.ProtoReflect.Descriptor instead.
func (*InitializingImageImportStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{134}
}

// LoadingImageSourceFilesStep contains specific step details.
type LoadingImageSourceFilesStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *LoadingImageSourceFilesStep) Reset() {
	*x = LoadingImageSourceFilesStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[135]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LoadingImageSourceFilesStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LoadingImageSourceFilesStep) ProtoMessage() {}

func (x *LoadingImageSourceFilesStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[135]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LoadingImageSourceFilesStep.ProtoReflect.Descriptor instead.
func (*LoadingImageSourceFilesStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{135}
}

// CreatingImageStep contains specific step details.
type CreatingImageStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreatingImageStep) Reset() {
	*x = CreatingImageStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[136]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatingImageStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatingImageStep) ProtoMessage() {}

func (x *CreatingImageStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[136]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatingImageStep.ProtoReflect.Descriptor instead.
func (*CreatingImageStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{136}
}

// The target details of the image resource that will be created by the import
// job.
type DiskImageTargetDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to OsAdaptationConfig:
	//
	//	*DiskImageTargetDetails_OsAdaptationParameters
	//	*DiskImageTargetDetails_DataDiskImageImport
	OsAdaptationConfig isDiskImageTargetDetails_OsAdaptationConfig `protobuf_oneof:"os_adaptation_config"`
	// Required. The name of the image to be created.
	ImageName string `protobuf:"bytes,1,opt,name=image_name,json=imageName,proto3" json:"image_name,omitempty"`
	// Required. Reference to the TargetProject resource that represents the
	// target project in which the imported image will be created.
	TargetProject string `protobuf:"bytes,2,opt,name=target_project,json=targetProject,proto3" json:"target_project,omitempty"`
	// Optional. An optional description of the image.
	Description string `protobuf:"bytes,5,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The name of the image family to which the new image belongs.
	FamilyName string `protobuf:"bytes,6,opt,name=family_name,json=familyName,proto3" json:"family_name,omitempty"`
	// Optional. A map of labels to associate with the image.
	Labels map[string]string `protobuf:"bytes,7,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Additional licenses to assign to the image.
	// Format:
	// https://www.googleapis.com/compute/v1/projects/PROJECT_ID/global/licenses/LICENSE_NAME
	// Or
	// https://www.googleapis.com/compute/beta/projects/PROJECT_ID/global/licenses/LICENSE_NAME
	AdditionalLicenses []string `protobuf:"bytes,8,rep,name=additional_licenses,json=additionalLicenses,proto3" json:"additional_licenses,omitempty"`
	// Optional. Set to true to set the image storageLocations to the single
	// region of the import job. When false, the closest multi-region is selected.
	SingleRegionStorage bool `protobuf:"varint,9,opt,name=single_region_storage,json=singleRegionStorage,proto3" json:"single_region_storage,omitempty"`
	// Immutable. The encryption to apply to the image.
	Encryption *Encryption `protobuf:"bytes,10,opt,name=encryption,proto3" json:"encryption,omitempty"`
}

func (x *DiskImageTargetDetails) Reset() {
	*x = DiskImageTargetDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[137]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiskImageTargetDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskImageTargetDetails) ProtoMessage() {}

func (x *DiskImageTargetDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[137]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskImageTargetDetails.ProtoReflect.Descriptor instead.
func (*DiskImageTargetDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{137}
}

func (m *DiskImageTargetDetails) GetOsAdaptationConfig() isDiskImageTargetDetails_OsAdaptationConfig {
	if m != nil {
		return m.OsAdaptationConfig
	}
	return nil
}

func (x *DiskImageTargetDetails) GetOsAdaptationParameters() *ImageImportOsAdaptationParameters {
	if x, ok := x.GetOsAdaptationConfig().(*DiskImageTargetDetails_OsAdaptationParameters); ok {
		return x.OsAdaptationParameters
	}
	return nil
}

func (x *DiskImageTargetDetails) GetDataDiskImageImport() *DataDiskImageImport {
	if x, ok := x.GetOsAdaptationConfig().(*DiskImageTargetDetails_DataDiskImageImport); ok {
		return x.DataDiskImageImport
	}
	return nil
}

func (x *DiskImageTargetDetails) GetImageName() string {
	if x != nil {
		return x.ImageName
	}
	return ""
}

func (x *DiskImageTargetDetails) GetTargetProject() string {
	if x != nil {
		return x.TargetProject
	}
	return ""
}

func (x *DiskImageTargetDetails) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *DiskImageTargetDetails) GetFamilyName() string {
	if x != nil {
		return x.FamilyName
	}
	return ""
}

func (x *DiskImageTargetDetails) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DiskImageTargetDetails) GetAdditionalLicenses() []string {
	if x != nil {
		return x.AdditionalLicenses
	}
	return nil
}

func (x *DiskImageTargetDetails) GetSingleRegionStorage() bool {
	if x != nil {
		return x.SingleRegionStorage
	}
	return false
}

func (x *DiskImageTargetDetails) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

type isDiskImageTargetDetails_OsAdaptationConfig interface {
	isDiskImageTargetDetails_OsAdaptationConfig()
}

type DiskImageTargetDetails_OsAdaptationParameters struct {
	// Optional. Use to set the parameters relevant for the OS adaptation
	// process.
	OsAdaptationParameters *ImageImportOsAdaptationParameters `protobuf:"bytes,11,opt,name=os_adaptation_parameters,json=osAdaptationParameters,proto3,oneof"`
}

type DiskImageTargetDetails_DataDiskImageImport struct {
	// Optional. Use to skip OS adaptation process.
	DataDiskImageImport *DataDiskImageImport `protobuf:"bytes,12,opt,name=data_disk_image_import,json=dataDiskImageImport,proto3,oneof"`
}

func (*DiskImageTargetDetails_OsAdaptationParameters) isDiskImageTargetDetails_OsAdaptationConfig() {}

func (*DiskImageTargetDetails_DataDiskImageImport) isDiskImageTargetDetails_OsAdaptationConfig() {}

// The target details of the machine image resource that will be created by the
// image import job.
type MachineImageTargetDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to OsAdaptationConfig:
	//
	//	*MachineImageTargetDetails_OsAdaptationParameters
	//	*MachineImageTargetDetails_SkipOsAdaptation
	OsAdaptationConfig isMachineImageTargetDetails_OsAdaptationConfig `protobuf_oneof:"os_adaptation_config"`
	// Required. The name of the machine image to be created.
	MachineImageName string `protobuf:"bytes,1,opt,name=machine_image_name,json=machineImageName,proto3" json:"machine_image_name,omitempty"`
	// Required. Reference to the TargetProject resource that represents the
	// target project in which the imported machine image will be created.
	TargetProject string `protobuf:"bytes,2,opt,name=target_project,json=targetProject,proto3" json:"target_project,omitempty"`
	// Optional. An optional description of the machine image.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Set to true to set the machine image storageLocations to the
	// single region of the import job. When false, the closest multi-region is
	// selected.
	SingleRegionStorage bool `protobuf:"varint,5,opt,name=single_region_storage,json=singleRegionStorage,proto3" json:"single_region_storage,omitempty"`
	// Immutable. The encryption to apply to the machine image.
	// If the Image Import resource has an encryption, this field must be set to
	// the same encryption key.
	Encryption *Encryption `protobuf:"bytes,6,opt,name=encryption,proto3" json:"encryption,omitempty"`
	// Optional. Parameters overriding decisions based on the source machine image
	// configurations.
	MachineImageParametersOverrides *MachineImageParametersOverrides `protobuf:"bytes,7,opt,name=machine_image_parameters_overrides,json=machineImageParametersOverrides,proto3" json:"machine_image_parameters_overrides,omitempty"`
	// Optional. The service account to assign to the instance created by the
	// machine image.
	ServiceAccount *ServiceAccount `protobuf:"bytes,8,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Optional. Additional licenses to assign to the instance created by the
	// machine image. Format:
	// https://www.googleapis.com/compute/v1/projects/PROJECT_ID/global/licenses/LICENSE_NAME
	// Or
	// https://www.googleapis.com/compute/beta/projects/PROJECT_ID/global/licenses/LICENSE_NAME
	AdditionalLicenses []string `protobuf:"bytes,9,rep,name=additional_licenses,json=additionalLicenses,proto3" json:"additional_licenses,omitempty"`
	// Optional. The labels to apply to the instance created by the machine image.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The tags to apply to the instance created by the machine image.
	Tags []string `protobuf:"bytes,11,rep,name=tags,proto3" json:"tags,omitempty"`
	// Optional. Shielded instance configuration.
	ShieldedInstanceConfig *ShieldedInstanceConfig `protobuf:"bytes,12,opt,name=shielded_instance_config,json=shieldedInstanceConfig,proto3" json:"shielded_instance_config,omitempty"`
	// Optional. The network interfaces to create with the instance created by the
	// machine image. Internal and external IP addresses, and network tiers are
	// ignored for machine image import.
	NetworkInterfaces []*NetworkInterface `protobuf:"bytes,13,rep,name=network_interfaces,json=networkInterfaces,proto3" json:"network_interfaces,omitempty"`
}

func (x *MachineImageTargetDetails) Reset() {
	*x = MachineImageTargetDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[138]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MachineImageTargetDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MachineImageTargetDetails) ProtoMessage() {}

func (x *MachineImageTargetDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[138]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MachineImageTargetDetails.ProtoReflect.Descriptor instead.
func (*MachineImageTargetDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{138}
}

func (m *MachineImageTargetDetails) GetOsAdaptationConfig() isMachineImageTargetDetails_OsAdaptationConfig {
	if m != nil {
		return m.OsAdaptationConfig
	}
	return nil
}

func (x *MachineImageTargetDetails) GetOsAdaptationParameters() *ImageImportOsAdaptationParameters {
	if x, ok := x.GetOsAdaptationConfig().(*MachineImageTargetDetails_OsAdaptationParameters); ok {
		return x.OsAdaptationParameters
	}
	return nil
}

func (x *MachineImageTargetDetails) GetSkipOsAdaptation() *SkipOsAdaptation {
	if x, ok := x.GetOsAdaptationConfig().(*MachineImageTargetDetails_SkipOsAdaptation); ok {
		return x.SkipOsAdaptation
	}
	return nil
}

func (x *MachineImageTargetDetails) GetMachineImageName() string {
	if x != nil {
		return x.MachineImageName
	}
	return ""
}

func (x *MachineImageTargetDetails) GetTargetProject() string {
	if x != nil {
		return x.TargetProject
	}
	return ""
}

func (x *MachineImageTargetDetails) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *MachineImageTargetDetails) GetSingleRegionStorage() bool {
	if x != nil {
		return x.SingleRegionStorage
	}
	return false
}

func (x *MachineImageTargetDetails) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

func (x *MachineImageTargetDetails) GetMachineImageParametersOverrides() *MachineImageParametersOverrides {
	if x != nil {
		return x.MachineImageParametersOverrides
	}
	return nil
}

func (x *MachineImageTargetDetails) GetServiceAccount() *ServiceAccount {
	if x != nil {
		return x.ServiceAccount
	}
	return nil
}

func (x *MachineImageTargetDetails) GetAdditionalLicenses() []string {
	if x != nil {
		return x.AdditionalLicenses
	}
	return nil
}

func (x *MachineImageTargetDetails) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *MachineImageTargetDetails) GetTags() []string {
	if x != nil {
		return x.Tags
	}
	return nil
}

func (x *MachineImageTargetDetails) GetShieldedInstanceConfig() *ShieldedInstanceConfig {
	if x != nil {
		return x.ShieldedInstanceConfig
	}
	return nil
}

func (x *MachineImageTargetDetails) GetNetworkInterfaces() []*NetworkInterface {
	if x != nil {
		return x.NetworkInterfaces
	}
	return nil
}

type isMachineImageTargetDetails_OsAdaptationConfig interface {
	isMachineImageTargetDetails_OsAdaptationConfig()
}

type MachineImageTargetDetails_OsAdaptationParameters struct {
	// Optional. Use to set the parameters relevant for the OS adaptation
	// process.
	OsAdaptationParameters *ImageImportOsAdaptationParameters `protobuf:"bytes,3,opt,name=os_adaptation_parameters,json=osAdaptationParameters,proto3,oneof"`
}

type MachineImageTargetDetails_SkipOsAdaptation struct {
	// Optional. Use to skip OS adaptation process.
	SkipOsAdaptation *SkipOsAdaptation `protobuf:"bytes,16,opt,name=skip_os_adaptation,json=skipOsAdaptation,proto3,oneof"`
}

func (*MachineImageTargetDetails_OsAdaptationParameters) isMachineImageTargetDetails_OsAdaptationConfig() {
}

func (*MachineImageTargetDetails_SkipOsAdaptation) isMachineImageTargetDetails_OsAdaptationConfig() {}

// Service account to assign to the instance created by the machine image.
type ServiceAccount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The email address of the service account.
	Email string `protobuf:"bytes,1,opt,name=email,proto3" json:"email,omitempty"`
	// Optional. The list of scopes to be made available for this service account.
	Scopes []string `protobuf:"bytes,2,rep,name=scopes,proto3" json:"scopes,omitempty"`
}

func (x *ServiceAccount) Reset() {
	*x = ServiceAccount{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[139]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ServiceAccount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServiceAccount) ProtoMessage() {}

func (x *ServiceAccount) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[139]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServiceAccount.ProtoReflect.Descriptor instead.
func (*ServiceAccount) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{139}
}

func (x *ServiceAccount) GetEmail() string {
	if x != nil {
		return x.Email
	}
	return ""
}

func (x *ServiceAccount) GetScopes() []string {
	if x != nil {
		return x.Scopes
	}
	return nil
}

// Shielded instance configuration.
type ShieldedInstanceConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Defines whether the instance created by the machine image has
	// Secure Boot enabled. This can be set to true only if the image boot option
	// is EFI.
	SecureBoot ShieldedInstanceConfig_SecureBoot `protobuf:"varint,1,opt,name=secure_boot,json=secureBoot,proto3,enum=google.cloud.vmmigration.v1.ShieldedInstanceConfig_SecureBoot" json:"secure_boot,omitempty"`
	// Optional. Defines whether the instance created by the machine image has
	// vTPM enabled. This can be set to true only if the image boot option is EFI.
	EnableVtpm bool `protobuf:"varint,2,opt,name=enable_vtpm,json=enableVtpm,proto3" json:"enable_vtpm,omitempty"`
	// Optional. Defines whether the instance created by the machine image has
	// integrity monitoring enabled. This can be set to true only if the image
	// boot option is EFI, and vTPM is enabled.
	EnableIntegrityMonitoring bool `protobuf:"varint,3,opt,name=enable_integrity_monitoring,json=enableIntegrityMonitoring,proto3" json:"enable_integrity_monitoring,omitempty"`
}

func (x *ShieldedInstanceConfig) Reset() {
	*x = ShieldedInstanceConfig{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[140]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ShieldedInstanceConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ShieldedInstanceConfig) ProtoMessage() {}

func (x *ShieldedInstanceConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[140]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ShieldedInstanceConfig.ProtoReflect.Descriptor instead.
func (*ShieldedInstanceConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{140}
}

func (x *ShieldedInstanceConfig) GetSecureBoot() ShieldedInstanceConfig_SecureBoot {
	if x != nil {
		return x.SecureBoot
	}
	return ShieldedInstanceConfig_SECURE_BOOT_UNSPECIFIED
}

func (x *ShieldedInstanceConfig) GetEnableVtpm() bool {
	if x != nil {
		return x.EnableVtpm
	}
	return false
}

func (x *ShieldedInstanceConfig) GetEnableIntegrityMonitoring() bool {
	if x != nil {
		return x.EnableIntegrityMonitoring
	}
	return false
}

// Parameters overriding decisions based on the source machine image
// configurations.
type MachineImageParametersOverrides struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The machine type to create the MachineImage with.
	// If empty, the service will choose a relevant machine type based on the
	// information from the source image.
	// For more information about machine types, please refer to
	// https://cloud.google.com/compute/docs/machine-resource.
	MachineType string `protobuf:"bytes,1,opt,name=machine_type,json=machineType,proto3" json:"machine_type,omitempty"`
}

func (x *MachineImageParametersOverrides) Reset() {
	*x = MachineImageParametersOverrides{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[141]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MachineImageParametersOverrides) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MachineImageParametersOverrides) ProtoMessage() {}

func (x *MachineImageParametersOverrides) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[141]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MachineImageParametersOverrides.ProtoReflect.Descriptor instead.
func (*MachineImageParametersOverrides) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{141}
}

func (x *MachineImageParametersOverrides) GetMachineType() string {
	if x != nil {
		return x.MachineType
	}
	return ""
}

// Parameters affecting the OS adaptation process.
type ImageImportOsAdaptationParameters struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Set to true in order to generalize the imported image.
	// The generalization process enables co-existence of multiple VMs created
	// from the same image.
	// For Windows, generalizing the image removes computer-specific information
	// such as installed drivers and the computer security identifier (SID).
	Generalize bool `protobuf:"varint,1,opt,name=generalize,proto3" json:"generalize,omitempty"`
	// Optional. Choose which type of license to apply to the imported image.
	LicenseType ComputeEngineLicenseType `protobuf:"varint,2,opt,name=license_type,json=licenseType,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineLicenseType" json:"license_type,omitempty"`
	// Optional. By default the image will keep its existing boot option. Setting
	// this property will trigger an internal process which will convert the
	// image from using the existing boot option to another.
	// The size of the boot disk might be increased to allow the conversion
	BootConversion BootConversion `protobuf:"varint,3,opt,name=boot_conversion,json=bootConversion,proto3,enum=google.cloud.vmmigration.v1.BootConversion" json:"boot_conversion,omitempty"`
}

func (x *ImageImportOsAdaptationParameters) Reset() {
	*x = ImageImportOsAdaptationParameters{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[142]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ImageImportOsAdaptationParameters) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageImportOsAdaptationParameters) ProtoMessage() {}

func (x *ImageImportOsAdaptationParameters) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[142]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageImportOsAdaptationParameters.ProtoReflect.Descriptor instead.
func (*ImageImportOsAdaptationParameters) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{142}
}

func (x *ImageImportOsAdaptationParameters) GetGeneralize() bool {
	if x != nil {
		return x.Generalize
	}
	return false
}

func (x *ImageImportOsAdaptationParameters) GetLicenseType() ComputeEngineLicenseType {
	if x != nil {
		return x.LicenseType
	}
	return ComputeEngineLicenseType_COMPUTE_ENGINE_LICENSE_TYPE_DEFAULT
}

func (x *ImageImportOsAdaptationParameters) GetBootConversion() BootConversion {
	if x != nil {
		return x.BootConversion
	}
	return BootConversion_BOOT_CONVERSION_UNSPECIFIED
}

// Mentions that the image import is not using OS adaptation process.
type DataDiskImageImport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *DataDiskImageImport) Reset() {
	*x = DataDiskImageImport{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[143]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DataDiskImageImport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DataDiskImageImport) ProtoMessage() {}

func (x *DataDiskImageImport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[143]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DataDiskImageImport.ProtoReflect.Descriptor instead.
func (*DataDiskImageImport) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{143}
}

// Mentions that the machine image import is not using OS adaptation process.
type SkipOsAdaptation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *SkipOsAdaptation) Reset() {
	*x = SkipOsAdaptation{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[144]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SkipOsAdaptation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SkipOsAdaptation) ProtoMessage() {}

func (x *SkipOsAdaptation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[144]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SkipOsAdaptation.ProtoReflect.Descriptor instead.
func (*SkipOsAdaptation) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{144}
}

// Request message for 'GetImageImport' call.
type GetImageImportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ImageImport name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetImageImportRequest) Reset() {
	*x = GetImageImportRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[145]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetImageImportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetImageImportRequest) ProtoMessage() {}

func (x *GetImageImportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[145]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetImageImportRequest.ProtoReflect.Descriptor instead.
func (*GetImageImportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{145}
}

func (x *GetImageImportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'ListImageImports' call.
type ListImageImportsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of targets.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of targets to return. The service may return
	// fewer than this value. If unspecified, at most 500 targets will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListImageImports` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListImageImports` must
	// match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request (according to <a
	// href="https://google.aip.dev/160" target="_blank">AIP-160</a>).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The order by fields for the result (according to <a
	// href="https://google.aip.dev/132#ordering" target="_blank">AIP-132</a>).
	// Currently ordering is only possible by "name" field.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListImageImportsRequest) Reset() {
	*x = ListImageImportsRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[146]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListImageImportsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImageImportsRequest) ProtoMessage() {}

func (x *ListImageImportsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[146]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImageImportsRequest.ProtoReflect.Descriptor instead.
func (*ListImageImportsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{146}
}

func (x *ListImageImportsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListImageImportsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListImageImportsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListImageImportsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListImageImportsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListImageImports' call.
type ListImageImportsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of target response.
	ImageImports []*ImageImport `protobuf:"bytes,1,rep,name=image_imports,json=imageImports,proto3" json:"image_imports,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListImageImportsResponse) Reset() {
	*x = ListImageImportsResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[147]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListImageImportsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImageImportsResponse) ProtoMessage() {}

func (x *ListImageImportsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[147]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImageImportsResponse.ProtoReflect.Descriptor instead.
func (*ListImageImportsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{147}
}

func (x *ListImageImportsResponse) GetImageImports() []*ImageImport {
	if x != nil {
		return x.ImageImports
	}
	return nil
}

func (x *ListImageImportsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListImageImportsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'CreateImageImport' request.
type CreateImageImportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ImageImport's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The image import identifier.
	// This value maximum length is 63 characters, and valid characters are
	// /[a-z][0-9]-/. It must start with an english letter and must not end with a
	// hyphen.
	ImageImportId string `protobuf:"bytes,2,opt,name=image_import_id,json=imageImportId,proto3" json:"image_import_id,omitempty"`
	// Required. The create request body.
	ImageImport *ImageImport `protobuf:"bytes,3,opt,name=image_import,json=imageImport,proto3" json:"image_import,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateImageImportRequest) Reset() {
	*x = CreateImageImportRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[148]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateImageImportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateImageImportRequest) ProtoMessage() {}

func (x *CreateImageImportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[148]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateImageImportRequest.ProtoReflect.Descriptor instead.
func (*CreateImageImportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{148}
}

func (x *CreateImageImportRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateImageImportRequest) GetImageImportId() string {
	if x != nil {
		return x.ImageImportId
	}
	return ""
}

func (x *CreateImageImportRequest) GetImageImport() *ImageImport {
	if x != nil {
		return x.ImageImport
	}
	return nil
}

func (x *CreateImageImportRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteImageImport' request.
type DeleteImageImportRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ImageImport name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and t
	// he request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *DeleteImageImportRequest) Reset() {
	*x = DeleteImageImportRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[149]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteImageImportRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteImageImportRequest) ProtoMessage() {}

func (x *DeleteImageImportRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[149]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteImageImportRequest.ProtoReflect.Descriptor instead.
func (*DeleteImageImportRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{149}
}

func (x *DeleteImageImportRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteImageImportRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'GetImageImportJob' call.
type GetImageImportJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ImageImportJob name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetImageImportJobRequest) Reset() {
	*x = GetImageImportJobRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[150]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetImageImportJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetImageImportJobRequest) ProtoMessage() {}

func (x *GetImageImportJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[150]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetImageImportJobRequest.ProtoReflect.Descriptor instead.
func (*GetImageImportJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{150}
}

func (x *GetImageImportJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'ListImageImportJobs' call.
type ListImageImportJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of targets.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of targets to return. The service may return
	// fewer than this value. If unspecified, at most 500 targets will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListImageImportJobs`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListImageImportJobs`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request (according to <a
	// href="https://google.aip.dev/160" target="_blank">AIP-160</a>).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. The order by fields for the result (according to <a
	// href="https://google.aip.dev/132#ordering" target="_blank">AIP-132</a>).
	// Currently ordering is only possible by "name" field.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListImageImportJobsRequest) Reset() {
	*x = ListImageImportJobsRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[151]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListImageImportJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImageImportJobsRequest) ProtoMessage() {}

func (x *ListImageImportJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[151]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImageImportJobsRequest.ProtoReflect.Descriptor instead.
func (*ListImageImportJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{151}
}

func (x *ListImageImportJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListImageImportJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListImageImportJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListImageImportJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListImageImportJobsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListImageImportJobs' call.
type ListImageImportJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of target response.
	ImageImportJobs []*ImageImportJob `protobuf:"bytes,1,rep,name=image_import_jobs,json=imageImportJobs,proto3" json:"image_import_jobs,omitempty"`
	// Output only. A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListImageImportJobsResponse) Reset() {
	*x = ListImageImportJobsResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[152]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListImageImportJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListImageImportJobsResponse) ProtoMessage() {}

func (x *ListImageImportJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[152]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListImageImportJobsResponse.ProtoReflect.Descriptor instead.
func (*ListImageImportJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{152}
}

func (x *ListImageImportJobsResponse) GetImageImportJobs() []*ImageImportJob {
	if x != nil {
		return x.ImageImportJobs
	}
	return nil
}

func (x *ListImageImportJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListImageImportJobsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'CancelImageImportJob' request.
type CancelImageImportJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The image import job id.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelImageImportJobRequest) Reset() {
	*x = CancelImageImportJobRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[153]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelImageImportJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelImageImportJobRequest) ProtoMessage() {}

func (x *CancelImageImportJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[153]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelImageImportJobRequest.ProtoReflect.Descriptor instead.
func (*CancelImageImportJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{153}
}

func (x *CancelImageImportJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for 'CancelImageImportJob' request.
type CancelImageImportJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CancelImageImportJobResponse) Reset() {
	*x = CancelImageImportJobResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[154]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelImageImportJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelImageImportJobResponse) ProtoMessage() {}

func (x *CancelImageImportJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[154]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelImageImportJobResponse.ProtoReflect.Descriptor instead.
func (*CancelImageImportJobResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{154}
}

// Describes the disk which will be migrated from the source environment.
// The source disk has to be unattached.
type DiskMigrationJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unattached source disk details.
	//
	// Types that are assignable to SourceDiskDetails:
	//
	//	*DiskMigrationJob_AwsSourceDiskDetails
	SourceDiskDetails isDiskMigrationJob_SourceDiskDetails `protobuf_oneof:"source_disk_details"`
	// Output only. Identifier. The identifier of the DiskMigrationJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Details of the target Disk in Compute Engine.
	TargetDetails *DiskMigrationJobTargetDetails `protobuf:"bytes,3,opt,name=target_details,json=targetDetails,proto3" json:"target_details,omitempty"`
	// Output only. The time the DiskMigrationJob resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last time the DiskMigrationJob resource was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. State of the DiskMigrationJob.
	State DiskMigrationJob_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.vmmigration.v1.DiskMigrationJob_State" json:"state,omitempty"`
	// Output only. Provides details on the errors that led to the disk migration
	// job's state in case of an error.
	Errors []*status.Status `protobuf:"bytes,7,rep,name=errors,proto3" json:"errors,omitempty"`
	// Output only. The disk migration steps list representing its progress.
	Steps []*DiskMigrationStep `protobuf:"bytes,8,rep,name=steps,proto3" json:"steps,omitempty"`
}

func (x *DiskMigrationJob) Reset() {
	*x = DiskMigrationJob{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[155]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiskMigrationJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskMigrationJob) ProtoMessage() {}

func (x *DiskMigrationJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[155]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskMigrationJob.ProtoReflect.Descriptor instead.
func (*DiskMigrationJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{155}
}

func (m *DiskMigrationJob) GetSourceDiskDetails() isDiskMigrationJob_SourceDiskDetails {
	if m != nil {
		return m.SourceDiskDetails
	}
	return nil
}

func (x *DiskMigrationJob) GetAwsSourceDiskDetails() *AwsSourceDiskDetails {
	if x, ok := x.GetSourceDiskDetails().(*DiskMigrationJob_AwsSourceDiskDetails); ok {
		return x.AwsSourceDiskDetails
	}
	return nil
}

func (x *DiskMigrationJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DiskMigrationJob) GetTargetDetails() *DiskMigrationJobTargetDetails {
	if x != nil {
		return x.TargetDetails
	}
	return nil
}

func (x *DiskMigrationJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *DiskMigrationJob) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *DiskMigrationJob) GetState() DiskMigrationJob_State {
	if x != nil {
		return x.State
	}
	return DiskMigrationJob_STATE_UNSPECIFIED
}

func (x *DiskMigrationJob) GetErrors() []*status.Status {
	if x != nil {
		return x.Errors
	}
	return nil
}

func (x *DiskMigrationJob) GetSteps() []*DiskMigrationStep {
	if x != nil {
		return x.Steps
	}
	return nil
}

type isDiskMigrationJob_SourceDiskDetails interface {
	isDiskMigrationJob_SourceDiskDetails()
}

type DiskMigrationJob_AwsSourceDiskDetails struct {
	// Details of the unattached AWS source disk.
	AwsSourceDiskDetails *AwsSourceDiskDetails `protobuf:"bytes,2,opt,name=aws_source_disk_details,json=awsSourceDiskDetails,proto3,oneof"`
}

func (*DiskMigrationJob_AwsSourceDiskDetails) isDiskMigrationJob_SourceDiskDetails() {}

// Details of the target disk in Compute Engine.
type DiskMigrationJobTargetDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The target storage.
	//
	// Types that are assignable to TargetStorage:
	//
	//	*DiskMigrationJobTargetDetails_TargetDisk
	TargetStorage isDiskMigrationJobTargetDetails_TargetStorage `protobuf_oneof:"target_storage"`
	// Required. The name of the resource of type TargetProject which represents
	// the Compute Engine project in which to create the disk. Should be of the
	// form: projects/{project}/locations/global/targetProjects/{target-project}
	TargetProject string `protobuf:"bytes,2,opt,name=target_project,json=targetProject,proto3" json:"target_project,omitempty"`
	// Optional. A map of labels to associate with the disk.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The encryption to apply to the disk.
	// If the DiskMigrationJob parent Source resource has an encryption, this
	// field must be set to the same encryption key.
	Encryption *Encryption `protobuf:"bytes,7,opt,name=encryption,proto3" json:"encryption,omitempty"`
}

func (x *DiskMigrationJobTargetDetails) Reset() {
	*x = DiskMigrationJobTargetDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[156]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiskMigrationJobTargetDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskMigrationJobTargetDetails) ProtoMessage() {}

func (x *DiskMigrationJobTargetDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[156]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskMigrationJobTargetDetails.ProtoReflect.Descriptor instead.
func (*DiskMigrationJobTargetDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{156}
}

func (m *DiskMigrationJobTargetDetails) GetTargetStorage() isDiskMigrationJobTargetDetails_TargetStorage {
	if m != nil {
		return m.TargetStorage
	}
	return nil
}

func (x *DiskMigrationJobTargetDetails) GetTargetDisk() *ComputeEngineDisk {
	if x, ok := x.GetTargetStorage().(*DiskMigrationJobTargetDetails_TargetDisk); ok {
		return x.TargetDisk
	}
	return nil
}

func (x *DiskMigrationJobTargetDetails) GetTargetProject() string {
	if x != nil {
		return x.TargetProject
	}
	return ""
}

func (x *DiskMigrationJobTargetDetails) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *DiskMigrationJobTargetDetails) GetEncryption() *Encryption {
	if x != nil {
		return x.Encryption
	}
	return nil
}

type isDiskMigrationJobTargetDetails_TargetStorage interface {
	isDiskMigrationJobTargetDetails_TargetStorage()
}

type DiskMigrationJobTargetDetails_TargetDisk struct {
	// Required. The target disk.
	TargetDisk *ComputeEngineDisk `protobuf:"bytes,8,opt,name=target_disk,json=targetDisk,proto3,oneof"`
}

func (*DiskMigrationJobTargetDetails_TargetDisk) isDiskMigrationJobTargetDetails_TargetStorage() {}

// DiskMigrationStep holds information about the disk migration step progress.
type DiskMigrationStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The step details.
	//
	// Types that are assignable to Step:
	//
	//	*DiskMigrationStep_CreatingSourceDiskSnapshot
	//	*DiskMigrationStep_CopyingSourceDiskSnapshot
	//	*DiskMigrationStep_ProvisioningTargetDisk
	Step isDiskMigrationStep_Step `protobuf_oneof:"step"`
	// Output only. The time the step has started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. The time the step has ended.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *DiskMigrationStep) Reset() {
	*x = DiskMigrationStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[157]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DiskMigrationStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DiskMigrationStep) ProtoMessage() {}

func (x *DiskMigrationStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[157]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DiskMigrationStep.ProtoReflect.Descriptor instead.
func (*DiskMigrationStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{157}
}

func (m *DiskMigrationStep) GetStep() isDiskMigrationStep_Step {
	if m != nil {
		return m.Step
	}
	return nil
}

func (x *DiskMigrationStep) GetCreatingSourceDiskSnapshot() *CreatingSourceDiskSnapshotStep {
	if x, ok := x.GetStep().(*DiskMigrationStep_CreatingSourceDiskSnapshot); ok {
		return x.CreatingSourceDiskSnapshot
	}
	return nil
}

func (x *DiskMigrationStep) GetCopyingSourceDiskSnapshot() *CopyingSourceDiskSnapshotStep {
	if x, ok := x.GetStep().(*DiskMigrationStep_CopyingSourceDiskSnapshot); ok {
		return x.CopyingSourceDiskSnapshot
	}
	return nil
}

func (x *DiskMigrationStep) GetProvisioningTargetDisk() *ProvisioningTargetDiskStep {
	if x, ok := x.GetStep().(*DiskMigrationStep_ProvisioningTargetDisk); ok {
		return x.ProvisioningTargetDisk
	}
	return nil
}

func (x *DiskMigrationStep) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *DiskMigrationStep) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

type isDiskMigrationStep_Step interface {
	isDiskMigrationStep_Step()
}

type DiskMigrationStep_CreatingSourceDiskSnapshot struct {
	// Creating source disk snapshot step.
	CreatingSourceDiskSnapshot *CreatingSourceDiskSnapshotStep `protobuf:"bytes,3,opt,name=creating_source_disk_snapshot,json=creatingSourceDiskSnapshot,proto3,oneof"`
}

type DiskMigrationStep_CopyingSourceDiskSnapshot struct {
	// Copying source disk snapshot step.
	CopyingSourceDiskSnapshot *CopyingSourceDiskSnapshotStep `protobuf:"bytes,4,opt,name=copying_source_disk_snapshot,json=copyingSourceDiskSnapshot,proto3,oneof"`
}

type DiskMigrationStep_ProvisioningTargetDisk struct {
	// Creating target disk step.
	ProvisioningTargetDisk *ProvisioningTargetDiskStep `protobuf:"bytes,5,opt,name=provisioning_target_disk,json=provisioningTargetDisk,proto3,oneof"`
}

func (*DiskMigrationStep_CreatingSourceDiskSnapshot) isDiskMigrationStep_Step() {}

func (*DiskMigrationStep_CopyingSourceDiskSnapshot) isDiskMigrationStep_Step() {}

func (*DiskMigrationStep_ProvisioningTargetDisk) isDiskMigrationStep_Step() {}

// CreatingSourceDiskSnapshotStep contains specific step details.
type CreatingSourceDiskSnapshotStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CreatingSourceDiskSnapshotStep) Reset() {
	*x = CreatingSourceDiskSnapshotStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[158]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatingSourceDiskSnapshotStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatingSourceDiskSnapshotStep) ProtoMessage() {}

func (x *CreatingSourceDiskSnapshotStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[158]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatingSourceDiskSnapshotStep.ProtoReflect.Descriptor instead.
func (*CreatingSourceDiskSnapshotStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{158}
}

// CopyingSourceDiskSnapshotStep contains specific step details.
type CopyingSourceDiskSnapshotStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CopyingSourceDiskSnapshotStep) Reset() {
	*x = CopyingSourceDiskSnapshotStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[159]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CopyingSourceDiskSnapshotStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CopyingSourceDiskSnapshotStep) ProtoMessage() {}

func (x *CopyingSourceDiskSnapshotStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[159]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CopyingSourceDiskSnapshotStep.ProtoReflect.Descriptor instead.
func (*CopyingSourceDiskSnapshotStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{159}
}

// ProvisioningTargetDiskStep contains specific step details.
type ProvisioningTargetDiskStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ProvisioningTargetDiskStep) Reset() {
	*x = ProvisioningTargetDiskStep{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[160]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ProvisioningTargetDiskStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ProvisioningTargetDiskStep) ProtoMessage() {}

func (x *ProvisioningTargetDiskStep) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[160]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ProvisioningTargetDiskStep.ProtoReflect.Descriptor instead.
func (*ProvisioningTargetDiskStep) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{160}
}

// Compute Engine disk target details.
type ComputeEngineDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Target Compute Engine Disk ID.
	// This is the resource ID segment of the Compute Engine Disk to create.
	// In the resource name compute/v1/projects/{project}/zones/{zone}/disks/disk1
	// "disk1" is the resource ID for the disk.
	DiskId string `protobuf:"bytes,1,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	// Required. The Compute Engine zone in which to create the disk. Should be of
	// the form: projects/{target-project}/locations/{zone}
	Zone string `protobuf:"bytes,2,opt,name=zone,proto3" json:"zone,omitempty"`
	// Optional. Replication zones of the regional disk. Should be of the form:
	// projects/{target-project}/locations/{replica-zone}
	// Currently only one replica zone is supported.
	ReplicaZones []string `protobuf:"bytes,3,rep,name=replica_zones,json=replicaZones,proto3" json:"replica_zones,omitempty"`
	// Required. The disk type to use.
	DiskType ComputeEngineDiskType `protobuf:"varint,4,opt,name=disk_type,json=diskType,proto3,enum=google.cloud.vmmigration.v1.ComputeEngineDiskType" json:"disk_type,omitempty"`
}

func (x *ComputeEngineDisk) Reset() {
	*x = ComputeEngineDisk{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[161]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ComputeEngineDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ComputeEngineDisk) ProtoMessage() {}

func (x *ComputeEngineDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[161]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ComputeEngineDisk.ProtoReflect.Descriptor instead.
func (*ComputeEngineDisk) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{161}
}

func (x *ComputeEngineDisk) GetDiskId() string {
	if x != nil {
		return x.DiskId
	}
	return ""
}

func (x *ComputeEngineDisk) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *ComputeEngineDisk) GetReplicaZones() []string {
	if x != nil {
		return x.ReplicaZones
	}
	return nil
}

func (x *ComputeEngineDisk) GetDiskType() ComputeEngineDiskType {
	if x != nil {
		return x.DiskType
	}
	return ComputeEngineDiskType_COMPUTE_ENGINE_DISK_TYPE_UNSPECIFIED
}

// Represents the source AWS Disk details.
type AwsSourceDiskDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. AWS volume ID.
	VolumeId string `protobuf:"bytes,1,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// Output only. Size in GiB.
	SizeGib int64 `protobuf:"varint,2,opt,name=size_gib,json=sizeGib,proto3" json:"size_gib,omitempty"`
	// Optional. Output only. Disk type.
	DiskType AwsSourceDiskDetails_Type `protobuf:"varint,3,opt,name=disk_type,json=diskType,proto3,enum=google.cloud.vmmigration.v1.AwsSourceDiskDetails_Type" json:"disk_type,omitempty"`
	// Optional. Output only. A map of AWS volume tags.
	Tags map[string]string `protobuf:"bytes,4,rep,name=tags,proto3" json:"tags,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *AwsSourceDiskDetails) Reset() {
	*x = AwsSourceDiskDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[162]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AwsSourceDiskDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsSourceDiskDetails) ProtoMessage() {}

func (x *AwsSourceDiskDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[162]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsSourceDiskDetails.ProtoReflect.Descriptor instead.
func (*AwsSourceDiskDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{162}
}

func (x *AwsSourceDiskDetails) GetVolumeId() string {
	if x != nil {
		return x.VolumeId
	}
	return ""
}

func (x *AwsSourceDiskDetails) GetSizeGib() int64 {
	if x != nil {
		return x.SizeGib
	}
	return 0
}

func (x *AwsSourceDiskDetails) GetDiskType() AwsSourceDiskDetails_Type {
	if x != nil {
		return x.DiskType
	}
	return AwsSourceDiskDetails_TYPE_UNSPECIFIED
}

func (x *AwsSourceDiskDetails) GetTags() map[string]string {
	if x != nil {
		return x.Tags
	}
	return nil
}

// Request message for 'CreateDiskMigrationJob' request.
type CreateDiskMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The DiskMigrationJob's parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The DiskMigrationJob identifier.
	// The maximum length of this value is 63 characters.
	// Valid characters are lower case Latin letters, digits and hyphen.
	// It must start with a Latin letter and must not end with a hyphen.
	DiskMigrationJobId string `protobuf:"bytes,2,opt,name=disk_migration_job_id,json=diskMigrationJobId,proto3" json:"disk_migration_job_id,omitempty"`
	// Required. The create request body.
	DiskMigrationJob *DiskMigrationJob `protobuf:"bytes,3,opt,name=disk_migration_job,json=diskMigrationJob,proto3" json:"disk_migration_job,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request timed out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateDiskMigrationJobRequest) Reset() {
	*x = CreateDiskMigrationJobRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[163]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateDiskMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDiskMigrationJobRequest) ProtoMessage() {}

func (x *CreateDiskMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[163]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDiskMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*CreateDiskMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{163}
}

func (x *CreateDiskMigrationJobRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDiskMigrationJobRequest) GetDiskMigrationJobId() string {
	if x != nil {
		return x.DiskMigrationJobId
	}
	return ""
}

func (x *CreateDiskMigrationJobRequest) GetDiskMigrationJob() *DiskMigrationJob {
	if x != nil {
		return x.DiskMigrationJob
	}
	return nil
}

func (x *CreateDiskMigrationJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'ListDiskMigrationJobsRequest' request.
type ListDiskMigrationJobsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of DiskMigrationJobs.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of disk migration jobs to return. The service
	// may return fewer than this value. If unspecified, at most 500
	// disk migration jobs will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous `ListDiskMigrationJobs`
	// call. Provide this to retrieve the subsequent page.
	//
	// When paginating, all parameters provided to `ListDiskMigrationJobs`
	// except `page_size` must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. The filter request (according to <a
	// href="https://google.aip.dev/160" target="_blank">AIP-160</a>).
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Ordering of the result list.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListDiskMigrationJobsRequest) Reset() {
	*x = ListDiskMigrationJobsRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[164]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDiskMigrationJobsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDiskMigrationJobsRequest) ProtoMessage() {}

func (x *ListDiskMigrationJobsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[164]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDiskMigrationJobsRequest.ProtoReflect.Descriptor instead.
func (*ListDiskMigrationJobsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{164}
}

func (x *ListDiskMigrationJobsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDiskMigrationJobsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDiskMigrationJobsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListDiskMigrationJobsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListDiskMigrationJobsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Response message for 'ListDiskMigrationJobs' request.
type ListDiskMigrationJobsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The list of the disk migration jobs.
	DiskMigrationJobs []*DiskMigrationJob `protobuf:"bytes,1,rep,name=disk_migration_jobs,json=diskMigrationJobs,proto3" json:"disk_migration_jobs,omitempty"`
	// Optional. Output only. A token, which can be sent as `page_token` to
	// retrieve the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Output only. Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListDiskMigrationJobsResponse) Reset() {
	*x = ListDiskMigrationJobsResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[165]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListDiskMigrationJobsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDiskMigrationJobsResponse) ProtoMessage() {}

func (x *ListDiskMigrationJobsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[165]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDiskMigrationJobsResponse.ProtoReflect.Descriptor instead.
func (*ListDiskMigrationJobsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{165}
}

func (x *ListDiskMigrationJobsResponse) GetDiskMigrationJobs() []*DiskMigrationJob {
	if x != nil {
		return x.DiskMigrationJobs
	}
	return nil
}

func (x *ListDiskMigrationJobsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListDiskMigrationJobsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for 'GetDiskMigrationJob' request.
type GetDiskMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DiskMigrationJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDiskMigrationJobRequest) Reset() {
	*x = GetDiskMigrationJobRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[166]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetDiskMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDiskMigrationJobRequest) ProtoMessage() {}

func (x *GetDiskMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[166]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDiskMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*GetDiskMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{166}
}

func (x *GetDiskMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'UpdateDiskMigrationJob' request.
type UpdateDiskMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// DiskMigrationJob resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask, then a mask equivalent to all fields that are
	// populated (have a non-empty value), will be implied.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The update request body.
	DiskMigrationJob *DiskMigrationJob `protobuf:"bytes,2,opt,name=disk_migration_job,json=diskMigrationJob,proto3" json:"disk_migration_job,omitempty"`
	// Optional. A request ID to identify requests. Specify a unique request ID
	// so that if you must retry your request, the server will know to ignore
	// the request if it has already been completed. The server will guarantee
	// that for at least 60 minutes since the first request.
	//
	// For example, consider a situation where you make an initial request and
	// the request timed out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, will ignore the second request. This prevents
	// clients from accidentally creating duplicate commitments.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *UpdateDiskMigrationJobRequest) Reset() {
	*x = UpdateDiskMigrationJobRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[167]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateDiskMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDiskMigrationJobRequest) ProtoMessage() {}

func (x *UpdateDiskMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[167]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDiskMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*UpdateDiskMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{167}
}

func (x *UpdateDiskMigrationJobRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateDiskMigrationJobRequest) GetDiskMigrationJob() *DiskMigrationJob {
	if x != nil {
		return x.DiskMigrationJob
	}
	return nil
}

func (x *UpdateDiskMigrationJobRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Request message for 'DeleteDiskMigrationJob' request.
type DeleteDiskMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DiskMigrationJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDiskMigrationJobRequest) Reset() {
	*x = DeleteDiskMigrationJobRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[168]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteDiskMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDiskMigrationJobRequest) ProtoMessage() {}

func (x *DeleteDiskMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[168]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDiskMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*DeleteDiskMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{168}
}

func (x *DeleteDiskMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for 'RunDiskMigrationJobRequest' request.
type RunDiskMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DiskMigrationJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *RunDiskMigrationJobRequest) Reset() {
	*x = RunDiskMigrationJobRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[169]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RunDiskMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunDiskMigrationJobRequest) ProtoMessage() {}

func (x *RunDiskMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[169]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunDiskMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*RunDiskMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{169}
}

func (x *RunDiskMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for 'RunDiskMigrationJob' request.
type RunDiskMigrationJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RunDiskMigrationJobResponse) Reset() {
	*x = RunDiskMigrationJobResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[170]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RunDiskMigrationJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RunDiskMigrationJobResponse) ProtoMessage() {}

func (x *RunDiskMigrationJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[170]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RunDiskMigrationJobResponse.ProtoReflect.Descriptor instead.
func (*RunDiskMigrationJobResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{170}
}

// Request message for 'CancelDiskMigrationJob' request.
type CancelDiskMigrationJobRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the DiskMigrationJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *CancelDiskMigrationJobRequest) Reset() {
	*x = CancelDiskMigrationJobRequest{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[171]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelDiskMigrationJobRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelDiskMigrationJobRequest) ProtoMessage() {}

func (x *CancelDiskMigrationJobRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[171]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelDiskMigrationJobRequest.ProtoReflect.Descriptor instead.
func (*CancelDiskMigrationJobRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{171}
}

func (x *CancelDiskMigrationJobRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Response message for 'CancelDiskMigrationJob' request.
type CancelDiskMigrationJobResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *CancelDiskMigrationJobResponse) Reset() {
	*x = CancelDiskMigrationJobResponse{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[172]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CancelDiskMigrationJobResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CancelDiskMigrationJobResponse) ProtoMessage() {}

func (x *CancelDiskMigrationJobResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[172]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CancelDiskMigrationJobResponse.ProtoReflect.Descriptor instead.
func (*CancelDiskMigrationJobResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{172}
}

// Expiration holds information about the expiration of a MigratingVm.
type MigratingVm_Expiration struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Timestamp of when this resource is considered expired.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
	// Output only. The number of times expiration was extended.
	ExtensionCount int32 `protobuf:"varint,2,opt,name=extension_count,json=extensionCount,proto3" json:"extension_count,omitempty"`
	// Output only. Describes whether the expiration can be extended.
	Extendable bool `protobuf:"varint,3,opt,name=extendable,proto3" json:"extendable,omitempty"`
}

func (x *MigratingVm_Expiration) Reset() {
	*x = MigratingVm_Expiration{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[173]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MigratingVm_Expiration) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MigratingVm_Expiration) ProtoMessage() {}

func (x *MigratingVm_Expiration) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[173]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MigratingVm_Expiration.ProtoReflect.Descriptor instead.
func (*MigratingVm_Expiration) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{6, 0}
}

func (x *MigratingVm_Expiration) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

func (x *MigratingVm_Expiration) GetExtensionCount() int32 {
	if x != nil {
		return x.ExtensionCount
	}
	return 0
}

func (x *MigratingVm_Expiration) GetExtendable() bool {
	if x != nil {
		return x.Extendable
	}
	return false
}

// Message describing AWS Credentials using access key id and secret.
type AwsSourceDetails_AccessKeyCredentials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// AWS access key ID.
	AccessKeyId string `protobuf:"bytes,1,opt,name=access_key_id,json=accessKeyId,proto3" json:"access_key_id,omitempty"`
	// Input only. AWS secret access key.
	SecretAccessKey string `protobuf:"bytes,2,opt,name=secret_access_key,json=secretAccessKey,proto3" json:"secret_access_key,omitempty"`
	// Input only. AWS session token.
	// Used only when AWS security token service (STS) is responsible for
	// creating the temporary credentials.
	SessionToken string `protobuf:"bytes,3,opt,name=session_token,json=sessionToken,proto3" json:"session_token,omitempty"`
}

func (x *AwsSourceDetails_AccessKeyCredentials) Reset() {
	*x = AwsSourceDetails_AccessKeyCredentials{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[176]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AwsSourceDetails_AccessKeyCredentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsSourceDetails_AccessKeyCredentials) ProtoMessage() {}

func (x *AwsSourceDetails_AccessKeyCredentials) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[176]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsSourceDetails_AccessKeyCredentials.ProtoReflect.Descriptor instead.
func (*AwsSourceDetails_AccessKeyCredentials) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{25, 0}
}

func (x *AwsSourceDetails_AccessKeyCredentials) GetAccessKeyId() string {
	if x != nil {
		return x.AccessKeyId
	}
	return ""
}

func (x *AwsSourceDetails_AccessKeyCredentials) GetSecretAccessKey() string {
	if x != nil {
		return x.SecretAccessKey
	}
	return ""
}

func (x *AwsSourceDetails_AccessKeyCredentials) GetSessionToken() string {
	if x != nil {
		return x.SessionToken
	}
	return ""
}

// Tag is an AWS tag representation.
type AwsSourceDetails_Tag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Key of tag.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Required. Value of tag.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *AwsSourceDetails_Tag) Reset() {
	*x = AwsSourceDetails_Tag{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[177]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AwsSourceDetails_Tag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsSourceDetails_Tag) ProtoMessage() {}

func (x *AwsSourceDetails_Tag) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[177]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsSourceDetails_Tag.ProtoReflect.Descriptor instead.
func (*AwsSourceDetails_Tag) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{25, 1}
}

func (x *AwsSourceDetails_Tag) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *AwsSourceDetails_Tag) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

// Message describing Azure Credentials using tenant ID, client ID and secret.
type AzureSourceDetails_ClientSecretCredentials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Azure tenant ID.
	TenantId string `protobuf:"bytes,1,opt,name=tenant_id,json=tenantId,proto3" json:"tenant_id,omitempty"`
	// Azure client ID.
	ClientId string `protobuf:"bytes,2,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Input only. Azure client secret.
	ClientSecret string `protobuf:"bytes,3,opt,name=client_secret,json=clientSecret,proto3" json:"client_secret,omitempty"`
}

func (x *AzureSourceDetails_ClientSecretCredentials) Reset() {
	*x = AzureSourceDetails_ClientSecretCredentials{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[179]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AzureSourceDetails_ClientSecretCredentials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureSourceDetails_ClientSecretCredentials) ProtoMessage() {}

func (x *AzureSourceDetails_ClientSecretCredentials) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[179]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureSourceDetails_ClientSecretCredentials.ProtoReflect.Descriptor instead.
func (*AzureSourceDetails_ClientSecretCredentials) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{26, 0}
}

func (x *AzureSourceDetails_ClientSecretCredentials) GetTenantId() string {
	if x != nil {
		return x.TenantId
	}
	return ""
}

func (x *AzureSourceDetails_ClientSecretCredentials) GetClientId() string {
	if x != nil {
		return x.ClientId
	}
	return ""
}

func (x *AzureSourceDetails_ClientSecretCredentials) GetClientSecret() string {
	if x != nil {
		return x.ClientSecret
	}
	return ""
}

// A message describing the OS disk.
type AzureVmDetails_OSDisk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The disk's type.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// The disk's full name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The disk's size in GB.
	SizeGb int32 `protobuf:"varint,3,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
}

func (x *AzureVmDetails_OSDisk) Reset() {
	*x = AzureVmDetails_OSDisk{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[182]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AzureVmDetails_OSDisk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureVmDetails_OSDisk) ProtoMessage() {}

func (x *AzureVmDetails_OSDisk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[182]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureVmDetails_OSDisk.ProtoReflect.Descriptor instead.
func (*AzureVmDetails_OSDisk) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{41, 0}
}

func (x *AzureVmDetails_OSDisk) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *AzureVmDetails_OSDisk) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AzureVmDetails_OSDisk) GetSizeGb() int32 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

// A message describing a data disk.
type AzureVmDetails_Disk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The disk name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The disk size in GB.
	SizeGb int32 `protobuf:"varint,2,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
	// The disk's Logical Unit Number (LUN).
	Lun int32 `protobuf:"varint,3,opt,name=lun,proto3" json:"lun,omitempty"`
}

func (x *AzureVmDetails_Disk) Reset() {
	*x = AzureVmDetails_Disk{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[183]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AzureVmDetails_Disk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureVmDetails_Disk) ProtoMessage() {}

func (x *AzureVmDetails_Disk) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[183]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureVmDetails_Disk.ProtoReflect.Descriptor instead.
func (*AzureVmDetails_Disk) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{41, 1}
}

func (x *AzureVmDetails_Disk) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AzureVmDetails_Disk) GetSizeGb() int32 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

func (x *AzureVmDetails_Disk) GetLun() int32 {
	if x != nil {
		return x.Lun
	}
	return 0
}

// A message describing the VM's OS. Including OS, Publisher, Offer and Plan
// if applicable.
type AzureVmDetails_OSDescription struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// OS type.
	Type string `protobuf:"bytes,1,opt,name=type,proto3" json:"type,omitempty"`
	// OS publisher.
	Publisher string `protobuf:"bytes,2,opt,name=publisher,proto3" json:"publisher,omitempty"`
	// OS offer.
	Offer string `protobuf:"bytes,3,opt,name=offer,proto3" json:"offer,omitempty"`
	// OS plan.
	Plan string `protobuf:"bytes,4,opt,name=plan,proto3" json:"plan,omitempty"`
}

func (x *AzureVmDetails_OSDescription) Reset() {
	*x = AzureVmDetails_OSDescription{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[184]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AzureVmDetails_OSDescription) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureVmDetails_OSDescription) ProtoMessage() {}

func (x *AzureVmDetails_OSDescription) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[184]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureVmDetails_OSDescription.ProtoReflect.Descriptor instead.
func (*AzureVmDetails_OSDescription) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{41, 2}
}

func (x *AzureVmDetails_OSDescription) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *AzureVmDetails_OSDescription) GetPublisher() string {
	if x != nil {
		return x.Publisher
	}
	return ""
}

func (x *AzureVmDetails_OSDescription) GetOffer() string {
	if x != nil {
		return x.Offer
	}
	return ""
}

func (x *AzureVmDetails_OSDescription) GetPlan() string {
	if x != nil {
		return x.Plan
	}
	return ""
}

// Contains details about the image source used to create the disk.
type BootDiskDefaults_DiskImageDefaults struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The Image resource used when creating the disk.
	SourceImage string `protobuf:"bytes,1,opt,name=source_image,json=sourceImage,proto3" json:"source_image,omitempty"`
}

func (x *BootDiskDefaults_DiskImageDefaults) Reset() {
	*x = BootDiskDefaults_DiskImageDefaults{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[193]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BootDiskDefaults_DiskImageDefaults) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BootDiskDefaults_DiskImageDefaults) ProtoMessage() {}

func (x *BootDiskDefaults_DiskImageDefaults) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[193]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use BootDiskDefaults_DiskImageDefaults.ProtoReflect.Descriptor instead.
func (*BootDiskDefaults_DiskImageDefaults) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{75, 0}
}

func (x *BootDiskDefaults_DiskImageDefaults) GetSourceImage() string {
	if x != nil {
		return x.SourceImage
	}
	return ""
}

// The details of a Vmware VM disk.
type VmwareSourceVmDetails_VmwareDiskDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ordinal number of the disk.
	DiskNumber int32 `protobuf:"varint,1,opt,name=disk_number,json=diskNumber,proto3" json:"disk_number,omitempty"`
	// Output only. Size in GB.
	SizeGb int64 `protobuf:"varint,2,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
	// Output only. The disk label.
	Label string `protobuf:"bytes,3,opt,name=label,proto3" json:"label,omitempty"`
}

func (x *VmwareSourceVmDetails_VmwareDiskDetails) Reset() {
	*x = VmwareSourceVmDetails_VmwareDiskDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[194]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *VmwareSourceVmDetails_VmwareDiskDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VmwareSourceVmDetails_VmwareDiskDetails) ProtoMessage() {}

func (x *VmwareSourceVmDetails_VmwareDiskDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[194]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VmwareSourceVmDetails_VmwareDiskDetails.ProtoReflect.Descriptor instead.
func (*VmwareSourceVmDetails_VmwareDiskDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{124, 0}
}

func (x *VmwareSourceVmDetails_VmwareDiskDetails) GetDiskNumber() int32 {
	if x != nil {
		return x.DiskNumber
	}
	return 0
}

func (x *VmwareSourceVmDetails_VmwareDiskDetails) GetSizeGb() int64 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

func (x *VmwareSourceVmDetails_VmwareDiskDetails) GetLabel() string {
	if x != nil {
		return x.Label
	}
	return ""
}

// The details of an AWS instance disk.
type AwsSourceVmDetails_AwsDiskDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ordinal number of the disk.
	DiskNumber int32 `protobuf:"varint,1,opt,name=disk_number,json=diskNumber,proto3" json:"disk_number,omitempty"`
	// Output only. AWS volume ID.
	VolumeId string `protobuf:"bytes,2,opt,name=volume_id,json=volumeId,proto3" json:"volume_id,omitempty"`
	// Output only. Size in GB.
	SizeGb int64 `protobuf:"varint,3,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
}

func (x *AwsSourceVmDetails_AwsDiskDetails) Reset() {
	*x = AwsSourceVmDetails_AwsDiskDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[195]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AwsSourceVmDetails_AwsDiskDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AwsSourceVmDetails_AwsDiskDetails) ProtoMessage() {}

func (x *AwsSourceVmDetails_AwsDiskDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[195]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AwsSourceVmDetails_AwsDiskDetails.ProtoReflect.Descriptor instead.
func (*AwsSourceVmDetails_AwsDiskDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{125, 0}
}

func (x *AwsSourceVmDetails_AwsDiskDetails) GetDiskNumber() int32 {
	if x != nil {
		return x.DiskNumber
	}
	return 0
}

func (x *AwsSourceVmDetails_AwsDiskDetails) GetVolumeId() string {
	if x != nil {
		return x.VolumeId
	}
	return ""
}

func (x *AwsSourceVmDetails_AwsDiskDetails) GetSizeGb() int64 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

// The details of an Azure VM disk.
type AzureSourceVmDetails_AzureDiskDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The ordinal number of the disk.
	DiskNumber int32 `protobuf:"varint,1,opt,name=disk_number,json=diskNumber,proto3" json:"disk_number,omitempty"`
	// Output only. Azure disk ID.
	DiskId string `protobuf:"bytes,2,opt,name=disk_id,json=diskId,proto3" json:"disk_id,omitempty"`
	// Output only. Size in GB.
	SizeGb int64 `protobuf:"varint,3,opt,name=size_gb,json=sizeGb,proto3" json:"size_gb,omitempty"`
}

func (x *AzureSourceVmDetails_AzureDiskDetails) Reset() {
	*x = AzureSourceVmDetails_AzureDiskDetails{}
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[196]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AzureSourceVmDetails_AzureDiskDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AzureSourceVmDetails_AzureDiskDetails) ProtoMessage() {}

func (x *AzureSourceVmDetails_AzureDiskDetails) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes[196]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AzureSourceVmDetails_AzureDiskDetails.ProtoReflect.Descriptor instead.
func (*AzureSourceVmDetails_AzureDiskDetails) Descriptor() ([]byte, []int) {
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP(), []int{126, 0}
}

func (x *AzureSourceVmDetails_AzureDiskDetails) GetDiskNumber() int32 {
	if x != nil {
		return x.DiskNumber
	}
	return 0
}

func (x *AzureSourceVmDetails_AzureDiskDetails) GetDiskId() string {
	if x != nil {
		return x.DiskId
	}
	return ""
}

func (x *AzureSourceVmDetails_AzureDiskDetails) GetSizeGb() int64 {
	if x != nil {
		return x.SizeGb
	}
	return 0
}

var File_google_cloud_vmmigration_v1_vmmigration_proto protoreflect.FileDescriptor

var file_google_cloud_vmmigration_v1_vmmigration_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc3, 0x06, 0x0a, 0x10, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x5f, 0x6e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x63, 0x79, 0x63, 0x6c, 0x65,
	0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x14, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x5f, 0x70, 0x61, 0x75, 0x73, 0x65, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x12, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x50, 0x61, 0x75, 0x73, 0x65, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2d, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x02, 0x18, 0x01, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x65, 0x72,
	0x63, 0x65, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x09, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x65, 0x70, 0x52, 0x05, 0x73, 0x74, 0x65,
	0x70, 0x73, 0x12, 0x49, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2d, 0x0a,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x4e, 0x0a, 0x08,
	0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x08, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x22, 0x52, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07,
	0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x50, 0x41, 0x55,
	0x53, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04,
	0x3a, 0xad, 0x01, 0xea, 0x41, 0xa9, 0x01, 0x0a, 0x2b, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x79, 0x63, 0x6c, 0x65, 0x12, 0x7a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x7b, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x2f, 0x7b, 0x72, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x7d,
	0x22, 0xaa, 0x03, 0x0a, 0x09, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x53, 0x74, 0x65, 0x70, 0x12, 0x75,
	0x0a, 0x18, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x5f, 0x72,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49,
	0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x17, 0x69, 0x6e,
	0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x5a, 0x0a, 0x0f, 0x70, 0x6f, 0x73, 0x74, 0x5f,
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x65,
	0x70, 0x48, 0x00, 0x52, 0x0e, 0x70, 0x6f, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e,
	0x64, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x73, 0x74, 0x65, 0x70, 0x22, 0x1d, 0x0a,
	0x1b, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x65, 0x70, 0x22, 0x93, 0x02, 0x0a,
	0x0f, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x65, 0x70,
	0x12, 0x1f, 0x0a, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x79, 0x74, 0x65,
	0x73, 0x12, 0x29, 0x0a, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x0f, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x56, 0x0a, 0x29,
	0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x77, 0x6f, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73,
	0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70,
	0x65, 0x72, 0x5f, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x23, 0x6c, 0x61, 0x73, 0x74, 0x54, 0x77, 0x6f, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x41,
	0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x12, 0x5c, 0x0a, 0x2c, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x74, 0x68, 0x69,
	0x72, 0x74, 0x79, 0x5f, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x5f, 0x61, 0x76, 0x65, 0x72,
	0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x5f, 0x73, 0x65,
	0x63, 0x6f, 0x6e, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03, 0x52, 0x26, 0x6c, 0x61, 0x73, 0x74,
	0x54, 0x68, 0x69, 0x72, 0x74, 0x79, 0x4d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x41, 0x76, 0x65,
	0x72, 0x61, 0x67, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x50, 0x65, 0x72, 0x53, 0x65, 0x63, 0x6f,
	0x6e, 0x64, 0x22, 0x14, 0x0a, 0x12, 0x50, 0x6f, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x73,
	0x73, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x65, 0x70, 0x22, 0x53, 0x0a, 0x0f, 0x52, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x40, 0x0a, 0x0e, 0x6c,
	0x61, 0x73, 0x74, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x0c, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x79, 0x6e, 0x63, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xf5, 0x13,
	0x0a, 0x0b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x12, 0x7f, 0x0a,
	0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x1a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x48,
	0x00, 0x52, 0x1b, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x8f,
	0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x48, 0x00, 0x52, 0x20,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x44, 0x69, 0x73,
	0x6b, 0x73, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x12, 0x72, 0x0a, 0x18, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x76, 0x6d, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x1c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x15, 0x76,
	0x6d, 0x77, 0x61, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x69, 0x0a, 0x15, 0x61, 0x77, 0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x76, 0x6d, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x1d, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x12, 0x61, 0x77, 0x73,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x6f, 0x0a, 0x17, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x76, 0x6d, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x14, 0x61, 0x7a, 0x75, 0x72,
	0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x76, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x20,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x43, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4e, 0x0a, 0x09, 0x6c, 0x61, 0x73,
	0x74, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x79, 0x6e, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x08, 0x6c, 0x61, 0x73, 0x74, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x49, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x17, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x56, 0x6d, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x5e, 0x0a, 0x11, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x5f,
	0x73, 0x79, 0x6e, 0x63, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x53, 0x79, 0x6e, 0x63,
	0x49, 0x6e, 0x66, 0x6f, 0x12, 0x68, 0x0a, 0x16, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x72, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x20,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79,
	0x63, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14, 0x6c, 0x61, 0x73, 0x74, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x3e,
	0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0,
	0x41, 0x03, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x4c,
	0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x56, 0x0a, 0x11,
	0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62,
	0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x6f, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x73, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x13, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x12, 0x5c, 0x0a, 0x13, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x63, 0x75,
	0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x14, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11,
	0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62,
	0x73, 0x12, 0x5c, 0x0a, 0x10, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x66, 0x6f, 0x72,
	0x65, 0x63, 0x61, 0x73, 0x74, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65,
	0x72, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f,
	0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x12,
	0x58, 0x0a, 0x0a, 0x65, 0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x25, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x2e, 0x45, 0x78,
	0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xa1, 0x01, 0x0a, 0x0a, 0x45, 0x78,
	0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69,
	0x72, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x65, 0x78,
	0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0a, 0x65, 0x78, 0x74, 0x65,
	0x6e, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xdb, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e,
	0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10,
	0x02, 0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x49, 0x52, 0x53, 0x54, 0x5f, 0x53, 0x59, 0x4e, 0x43, 0x10,
	0x03, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x04, 0x12, 0x10, 0x0a,
	0x0c, 0x43, 0x55, 0x54, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x56, 0x45, 0x52, 0x10, 0x07, 0x12,
	0x0b, 0x0a, 0x07, 0x43, 0x55, 0x54, 0x4f, 0x56, 0x45, 0x52, 0x10, 0x08, 0x12, 0x0e, 0x0a, 0x0a,
	0x46, 0x49, 0x4e, 0x41, 0x4c, 0x5f, 0x53, 0x59, 0x4e, 0x43, 0x10, 0x09, 0x12, 0x0a, 0x0a, 0x06,
	0x50, 0x41, 0x55, 0x53, 0x45, 0x44, 0x10, 0x0a, 0x12, 0x0e, 0x0a, 0x0a, 0x46, 0x49, 0x4e, 0x41,
	0x4c, 0x49, 0x5a, 0x49, 0x4e, 0x47, 0x10, 0x0b, 0x12, 0x0d, 0x0a, 0x09, 0x46, 0x49, 0x4e, 0x41,
	0x4c, 0x49, 0x5a, 0x45, 0x44, 0x10, 0x0c, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x0d, 0x12, 0x0b, 0x0a, 0x07, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x0e, 0x12,
	0x15, 0x0a, 0x11, 0x46, 0x49, 0x4e, 0x41, 0x4c, 0x49, 0x5a, 0x45, 0x44, 0x5f, 0x45, 0x58, 0x50,
	0x49, 0x52, 0x45, 0x44, 0x10, 0x11, 0x3a, 0x81, 0x01, 0xea, 0x41, 0x7e, 0x0a, 0x26, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x56, 0x6d, 0x12, 0x54, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x7b, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x7d, 0x42, 0x14, 0x0a, 0x12, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x76, 0x6d, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x42, 0x13, 0x0a, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x6d, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x76, 0x0a, 0x0f, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72,
	0x46, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x12, 0x63, 0x0a, 0x1e, 0x65, 0x73, 0x74, 0x69,
	0x6d, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f,
	0x62, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x1b, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x43, 0x75, 0x74, 0x6f, 0x76,
	0x65, 0x72, 0x4a, 0x6f, 0x62, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe5, 0x07,
	0x0a, 0x08, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x81, 0x01, 0x0a, 0x1d, 0x63,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x14, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x48, 0x00, 0x52, 0x1a, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x91,
	0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x19, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48,
	0x00, 0x52, 0x1f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x44, 0x69, 0x73, 0x6b, 0x73, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x12, 0x41, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x17, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c,
	0x6f, 0x6e, 0x65, 0x53, 0x74, 0x65, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x65, 0x70, 0x73, 0x22, 0x82, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a,
	0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43,
	0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45,
	0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x06, 0x12, 0x0f, 0x0a, 0x0b, 0x41, 0x44, 0x41, 0x50, 0x54,
	0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x53, 0x10, 0x07, 0x3a, 0x95, 0x01, 0xea, 0x41, 0x91, 0x01, 0x0a,
	0x23, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x12, 0x6a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x7b, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x7d, 0x2f, 0x63, 0x6c, 0x6f, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x7d,
	0x42, 0x13, 0x0a, 0x11, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x76, 0x6d, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xb0, 0x03, 0x0a, 0x09, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x53,
	0x74, 0x65, 0x70, 0x12, 0x4e, 0x0a, 0x0b, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x6f, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x64, 0x61, 0x70, 0x74, 0x69, 0x6e, 0x67, 0x4f,
	0x53, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x0a, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x6e,
	0x67, 0x4f, 0x73, 0x12, 0x61, 0x0a, 0x12, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x69, 0x6e, 0x67,
	0x5f, 0x76, 0x6d, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x65, 0x70, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x4d, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x53, 0x74,
	0x65, 0x70, 0x48, 0x00, 0x52, 0x10, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x6d, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x12, 0x76, 0x0a, 0x19, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x74, 0x69, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x76, 0x6d, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x56, 0x4d, 0x53,
	0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x17, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x56, 0x6d, 0x12, 0x39,
	0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x42, 0x06, 0x0a, 0x04, 0x73, 0x74, 0x65, 0x70, 0x22, 0x10, 0x0a, 0x0e, 0x41, 0x64, 0x61, 0x70,
	0x74, 0x69, 0x6e, 0x67, 0x4f, 0x53, 0x53, 0x74, 0x65, 0x70, 0x22, 0x16, 0x0a, 0x14, 0x50, 0x72,
	0x65, 0x70, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x4d, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x53, 0x74,
	0x65, 0x70, 0x22, 0x1d, 0x0a, 0x1b, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x56, 0x4d, 0x53, 0x74, 0x65,
	0x70, 0x22, 0xcb, 0x08, 0x0a, 0x0a, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62,
	0x12, 0x81, 0x01, 0x0a, 0x1d, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1a, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x91, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x5f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x5f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x14, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x44, 0x69,
	0x73, 0x6b, 0x73, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x1f, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65,
	0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x74,
	0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x4d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x12, 0x43, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x53, 0x74, 0x65, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x22, 0x82, 0x01, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44,
	0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10,
	0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03,
	0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12,
	0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12,
	0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x06, 0x12, 0x0f, 0x0a, 0x0b, 0x41,
	0x44, 0x41, 0x50, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x4f, 0x53, 0x10, 0x07, 0x3a, 0x9b, 0x01, 0xea,
	0x41, 0x97, 0x01, 0x0a, 0x25, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12, 0x6e, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x7d, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d,
	0x73, 0x2f, 0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x7d,
	0x2f, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x63, 0x75,
	0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x7d, 0x42, 0x13, 0x0a, 0x11, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x76, 0x6d, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22,
	0x91, 0x05, 0x0a, 0x0b, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x53, 0x74, 0x65, 0x70, 0x12,
	0x6d, 0x0a, 0x1a, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63,
	0x6c, 0x65, 0x48, 0x00, 0x52, 0x18, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x12, 0x6e,
	0x0a, 0x17, 0x73, 0x68, 0x75, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x6f, 0x77, 0x6e, 0x5f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x76, 0x6d, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68,
	0x75, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x44, 0x6f, 0x77, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x56, 0x4d, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x14, 0x73, 0x68, 0x75, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x44, 0x6f, 0x77, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x12, 0x4e,
	0x0a, 0x0a, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x73, 0x79, 0x6e, 0x63, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c,
	0x65, 0x48, 0x00, 0x52, 0x09, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x53, 0x79, 0x6e, 0x63, 0x12, 0x61,
	0x0a, 0x12, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x5f, 0x64,
	0x69, 0x73, 0x6b, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x70, 0x61, 0x72, 0x69,
	0x6e, 0x67, 0x56, 0x4d, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52,
	0x10, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x44, 0x69, 0x73, 0x6b,
	0x73, 0x12, 0x76, 0x0a, 0x19, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x76, 0x6d, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x56, 0x4d, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00,
	0x52, 0x17, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64, 0x56, 0x6d, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x35, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x73,
	0x74, 0x65, 0x70, 0x22, 0x1a, 0x0a, 0x18, 0x53, 0x68, 0x75, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x44,
	0x6f, 0x77, 0x6e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x4d, 0x53, 0x74, 0x65, 0x70, 0x22,
	0xeb, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x25, 0x12, 0x23, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c,
	0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x25,
	0x0a, 0x0c, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63, 0x6c, 0x6f, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x47, 0x0a, 0x09, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x6a,
	0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x1d,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x58, 0x0a,
	0x15, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f,
	0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x18, 0x0a, 0x16, 0x43, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xde, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a,
	0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x25, 0x12, 0x23, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43,
	0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a,
	0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x42, 0x79, 0x22, 0xb6, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x6f, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x49, 0x0a, 0x0a,
	0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x63, 0x6c,
	0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61,
	0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x55, 0x0a, 0x12, 0x47,
	0x65, 0x74, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x3f, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2b, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x22, 0xe8, 0x05, 0x0a, 0x06, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x4a, 0x0a,
	0x06, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48,
	0x00, 0x52, 0x06, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x12, 0x41, 0x0a, 0x03, 0x61, 0x77, 0x73,
	0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x03, 0x61, 0x77, 0x73, 0x12, 0x47, 0x0a, 0x05,
	0x61, 0x7a, 0x75, 0x72, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x05,
	0x61, 0x7a, 0x75, 0x72, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40,
	0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x47, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a,
	0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0e, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0,
	0x41, 0x05, 0x52, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39,
	0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x60, 0xea, 0x41, 0x5d, 0x0a, 0x21,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x38, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x42, 0x10, 0x0a, 0x0e, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x50, 0x0a,
	0x0a, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x07, 0x6b,
	0x6d, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x52, 0x06, 0x6b, 0x6d, 0x73, 0x4b, 0x65, 0x79, 0x22,
	0xc5, 0x01, 0x0a, 0x13, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73,
	0x77, 0x6f, 0x72, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x76, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f,
	0x69, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x76, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x49, 0x70, 0x12, 0x1e, 0x0a, 0x0a, 0x74, 0x68, 0x75, 0x6d, 0x62, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x74, 0x68, 0x75, 0x6d, 0x62, 0x70, 0x72,
	0x69, 0x6e, 0x74, 0x12, 0x32, 0x0a, 0x15, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x5f,
	0x76, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x13, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x56, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x48, 0x6f, 0x73, 0x74, 0x22, 0xf9, 0x07, 0x0a, 0x10, 0x41, 0x77, 0x73, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6e, 0x0a, 0x10,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x63, 0x72, 0x65, 0x64, 0x73,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x43,
	0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x0e, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x43, 0x72, 0x65, 0x64, 0x73, 0x12, 0x22, 0x0a, 0x0a,
	0x61, 0x77, 0x73, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x09, 0x61, 0x77, 0x73, 0x52, 0x65, 0x67, 0x69, 0x6f, 0x6e,
	0x12, 0x4e, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77,
	0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12,
	0x5f, 0x0a, 0x12, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x74, 0x61, 0x67,
	0x5f, 0x6c, 0x69, 0x73, 0x74, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x54, 0x61, 0x67, 0x52, 0x10,
	0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x54, 0x61, 0x67, 0x4c, 0x69, 0x73, 0x74,
	0x12, 0x43, 0x0a, 0x1e, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x1b, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x79, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x90, 0x01, 0x0a, 0x1d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5f, 0x75, 0x73,
	0x65, 0x72, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x55,
	0x73, 0x65, 0x72, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x1a, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x55, 0x73, 0x65, 0x72, 0x54, 0x61, 0x67, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c,
	0x69, 0x63, 0x5f, 0x69, 0x70, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x08, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x49, 0x70, 0x1a, 0x95, 0x01, 0x0a, 0x14, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x61, 0x6c, 0x73, 0x12, 0x22, 0x0a, 0x0d, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b, 0x65,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x4b, 0x65, 0x79, 0x49, 0x64, 0x12, 0x2f, 0x0a, 0x11, 0x73, 0x65, 0x63, 0x72, 0x65,
	0x74, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6b, 0x65, 0x79, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x4b, 0x65, 0x79, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x04, 0x52, 0x0c, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x1a, 0x37, 0x0a, 0x03, 0x54, 0x61, 0x67, 0x12, 0x15, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x19, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x1a, 0x4d, 0x0a, 0x1f, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x55, 0x73, 0x65, 0x72, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x43, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45,
	0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45,
	0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x42,
	0x12, 0x0a, 0x10, 0x63, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x22, 0xd7, 0x06, 0x0a, 0x12, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x79, 0x0a, 0x13, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x5f, 0x63, 0x72, 0x65, 0x64,
	0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73,
	0x48, 0x00, 0x52, 0x11, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74,
	0x43, 0x72, 0x65, 0x64, 0x73, 0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x05, 0x52, 0x0e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x0e, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x0d, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x50, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75,
	0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x12, 0x92, 0x01, 0x0a, 0x1d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x74, 0x61,
	0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x55, 0x73, 0x65, 0x72,
	0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x1a, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x55, 0x73, 0x65,
	0x72, 0x54, 0x61, 0x67, 0x73, 0x12, 0x2f, 0x0a, 0x11, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x1a, 0x7d, 0x0a, 0x17, 0x43, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x43, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c,
	0x73, 0x12, 0x1b, 0x0a, 0x09, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x1b,
	0x0a, 0x09, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x49, 0x64, 0x12, 0x28, 0x0a, 0x0d, 0x63,
	0x6c, 0x69, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x04, 0x52, 0x0c, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x63, 0x72, 0x65, 0x74, 0x1a, 0x4d, 0x0a, 0x1f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x55, 0x73, 0x65, 0x72, 0x54,
	0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x43, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a,
	0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a,
	0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x03, 0x42, 0x12, 0x0a, 0x10, 0x63, 0x72, 0x65,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xbe, 0x08,
	0x0a, 0x13, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x2c, 0x0a, 0x0f, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05,
	0x52, 0x0e, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64,
	0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x62, 0x75, 0x63, 0x6b, 0x65, 0x74,
	0x12, 0x51, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61,
	0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x0b, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72,
	0x6f, 0x72, 0x12, 0x4d, 0x0a, 0x20, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f,
	0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x1e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x66, 0x72,
	0x61, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x12, 0x41, 0x0a, 0x1a, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x73,
	0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x18, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x61, 0x6e, 0x63, 0x65, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x12, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x56, 0x0a, 0x0e, 0x75, 0x70, 0x67, 0x72, 0x61,
	0x64, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70,
	0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0d, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x22,
	0x50, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07,
	0x4f, 0x46, 0x46, 0x4c, 0x49, 0x4e, 0x45, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49,
	0x4c, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x41, 0x43, 0x54, 0x49, 0x56, 0x45, 0x10,
	0x04, 0x3a, 0x9a, 0x01, 0xea, 0x41, 0x96, 0x01, 0x0a, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x64, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x7d, 0x22, 0xce,
	0x02, 0x0a, 0x0d, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x29, 0x0a, 0x10,
	0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x46, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49,
	0x4e, 0x47, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x02,
	0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x22,
	0xd2, 0x01, 0x0a, 0x10, 0x41, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x73, 0x12, 0x67, 0x0a, 0x18, 0x6e, 0x65, 0x77, 0x5f, 0x64, 0x65, 0x70, 0x6c,
	0x6f, 0x79, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x16, 0x6e, 0x65, 0x77, 0x44, 0x65, 0x70, 0x6c, 0x6f, 0x79,
	0x61, 0x62, 0x6c, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x55, 0x0a,
	0x0f, 0x69, 0x6e, 0x5f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x69, 0x6e, 0x50, 0x6c, 0x61, 0x63, 0x65, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x22, 0x86, 0x01, 0x0a, 0x10, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e,
	0x63, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x1a, 0x0a, 0x08, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61,
	0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61,
	0x6c, 0x12, 0x2a, 0x0a, 0x11, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x5f, 0x6e, 0x6f, 0x74,
	0x65, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x72, 0x65,
	0x6c, 0x65, 0x61, 0x73, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x73, 0x55, 0x72, 0x69, 0x22, 0xda, 0x01,
	0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xad, 0x01, 0x0a, 0x13, 0x4c,
	0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x42, 0x0a, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x51, 0x0a, 0x10, 0x47, 0x65,
	0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xdb, 0x01,
	0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x40, 0x0a, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xb3, 0x01, 0x0a, 0x13,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x12, 0x40, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49,
	0x64, 0x22, 0x78, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x7f, 0x0a, 0x15, 0x46,
	0x65, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52,
	0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x5f, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0c,
	0x66, 0x6f, 0x72, 0x63, 0x65, 0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x22, 0x87, 0x07, 0x0a,
	0x0f, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x13, 0x0a, 0x05, 0x76, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x76, 0x6d, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x49, 0x64, 0x12, 0x35, 0x0a, 0x16, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x15, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x12, 0x0a, 0x04, 0x75, 0x75, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x75, 0x75, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73,
	0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0b, 0x70, 0x6f, 0x77, 0x65,
	0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x50, 0x6f, 0x77, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x63, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x1b, 0x0a, 0x09, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6d, 0x62, 0x18, 0x08, 0x20, 0x01,
	0x28, 0x05, 0x52, 0x08, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4d, 0x62, 0x12, 0x1d, 0x0a, 0x0a,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05,
	0x52, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x6d, 0x62, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x74, 0x65, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4d, 0x62, 0x12, 0x2b, 0x0a,
	0x11, 0x67, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x67, 0x75, 0x65, 0x73, 0x74, 0x44,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x0b, 0x62, 0x6f,
	0x6f, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x42, 0x6f,
	0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x62,
	0x6f, 0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x64, 0x0a, 0x0c, 0x61, 0x72, 0x63,
	0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d,
	0x77, 0x61, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x56, 0x6d,
	0x41, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x22,
	0x49, 0x0a, 0x0a, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a,
	0x17, 0x50, 0x4f, 0x57, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x4f, 0x4e,
	0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4f, 0x46, 0x46, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53,
	0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10, 0x03, 0x22, 0x3c, 0x0a, 0x0a, 0x42, 0x6f,
	0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b, 0x0a, 0x17, 0x42, 0x4f, 0x4f, 0x54,
	0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x45, 0x46, 0x49, 0x10, 0x01, 0x12, 0x08,
	0x0a, 0x04, 0x42, 0x49, 0x4f, 0x53, 0x10, 0x02, 0x22, 0x6c, 0x0a, 0x0e, 0x56, 0x6d, 0x41, 0x72,
	0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x56, 0x4d,
	0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x54, 0x45, 0x43, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x56,
	0x4d, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x54, 0x45, 0x43, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x58,
	0x38, 0x36, 0x5f, 0x46, 0x41, 0x4d, 0x49, 0x4c, 0x59, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x56,
	0x4d, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x54, 0x45, 0x43, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x41,
	0x52, 0x4d, 0x36, 0x34, 0x10, 0x02, 0x22, 0xe3, 0x0a, 0x0a, 0x0c, 0x41, 0x77, 0x73, 0x56, 0x6d,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x13, 0x0a, 0x05, 0x76, 0x6d, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x76, 0x6d, 0x49, 0x64, 0x12, 0x21, 0x0a, 0x0c,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x1b, 0x0a, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x08, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x64, 0x12, 0x2d, 0x0a, 0x12,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5a, 0x0a, 0x0b, 0x70,
	0x6f, 0x77, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x77, 0x73, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x50, 0x6f, 0x77, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x70, 0x6f, 0x77,
	0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x63, 0x70, 0x75, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x63, 0x70, 0x75, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6d,
	0x62, 0x18, 0x07, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4d,
	0x62, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x12, 0x30, 0x0a, 0x14, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6d, 0x62, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12,
	0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x4d, 0x62, 0x12, 0x25, 0x0a, 0x0e, 0x6f, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6f, 0x73, 0x44, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x0b, 0x62, 0x6f, 0x6f,
	0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73,
	0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x74, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x62, 0x6f, 0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x76, 0x70, 0x63, 0x5f, 0x69, 0x64, 0x18,
	0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x70, 0x63, 0x49, 0x64, 0x12, 0x56, 0x0a, 0x0f,
	0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x18,
	0x0e, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x47,
	0x72, 0x6f, 0x75, 0x70, 0x52, 0x0e, 0x73, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x73, 0x12, 0x47, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x0f, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x77, 0x73, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x54, 0x61,
	0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x12, 0x0a,
	0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e,
	0x65, 0x12, 0x6f, 0x0a, 0x13, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73,
	0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x56, 0x6d, 0x56, 0x69, 0x72, 0x74,
	0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x12,
	0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x5c, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x2e, 0x56, 0x6d, 0x41, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x76, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x13,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x76, 0x63, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a,
	0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x56, 0x0a, 0x0a, 0x50, 0x6f, 0x77, 0x65,
	0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x1b, 0x0a, 0x17, 0x50, 0x4f, 0x57, 0x45, 0x52, 0x5f,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4f,
	0x46, 0x46, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x53, 0x50, 0x45, 0x4e, 0x44, 0x45,
	0x44, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x04,
	0x22, 0x3c, 0x0a, 0x0a, 0x42, 0x6f, 0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1b,
	0x0a, 0x17, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x45,
	0x46, 0x49, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x49, 0x4f, 0x53, 0x10, 0x02, 0x22, 0x58,
	0x0a, 0x14, 0x56, 0x6d, 0x56, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x22, 0x56, 0x4d, 0x5f, 0x56, 0x49, 0x52,
	0x54, 0x55, 0x41, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07,
	0x0a, 0x03, 0x48, 0x56, 0x4d, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x50, 0x41, 0x52, 0x41, 0x56,
	0x49, 0x52, 0x54, 0x55, 0x41, 0x4c, 0x10, 0x02, 0x22, 0x62, 0x0a, 0x0e, 0x56, 0x6d, 0x41, 0x72,
	0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x56, 0x4d,
	0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x54, 0x45, 0x43, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x49,
	0x33, 0x38, 0x36, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x58, 0x38, 0x36, 0x5f, 0x36, 0x34, 0x10,
	0x02, 0x12, 0x09, 0x0a, 0x05, 0x41, 0x52, 0x4d, 0x36, 0x34, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a,
	0x58, 0x38, 0x36, 0x5f, 0x36, 0x34, 0x5f, 0x4d, 0x41, 0x43, 0x10, 0x04, 0x22, 0x36, 0x0a, 0x10,
	0x41, 0x77, 0x73, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64,
	0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb8, 0x0b, 0x0a, 0x0e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x56, 0x6d,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x13, 0x0a, 0x05, 0x76, 0x6d, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x76, 0x6d, 0x49, 0x64, 0x12, 0x57, 0x0a, 0x0b,
	0x70, 0x6f, 0x77, 0x65, 0x72, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x50,
	0x6f, 0x77, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x0a, 0x70, 0x6f, 0x77, 0x65, 0x72,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x76, 0x6d, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1b,
	0x0a, 0x09, 0x63, 0x70, 0x75, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x63, 0x70, 0x75, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6d, 0x62, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08,
	0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4d, 0x62, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x69, 0x73, 0x6b,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x05, 0x52, 0x09, 0x64, 0x69,
	0x73, 0x6b, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x30, 0x0a, 0x14, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6d, 0x62, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64,
	0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x4d, 0x62, 0x12, 0x4b, 0x0a, 0x07, 0x6f, 0x73, 0x5f,
	0x64, 0x69, 0x73, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x56, 0x6d,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4f, 0x53, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x06,
	0x6f, 0x73, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x46, 0x0a, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x52, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x12, 0x60,
	0x0a, 0x0e, 0x6f, 0x73, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x2e, 0x4f, 0x53, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x0d, 0x6f, 0x73, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x57, 0x0a, 0x0b, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x2e, 0x42, 0x6f, 0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x62,
	0x6f, 0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x49, 0x0a, 0x04, 0x74, 0x61, 0x67,
	0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x2e, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04,
	0x74, 0x61, 0x67, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x72,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x63, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x72, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x5e, 0x0a, 0x0c, 0x61, 0x72, 0x63,
	0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a,
	0x75, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x56, 0x6d, 0x41,
	0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x52, 0x0c, 0x61, 0x72, 0x63,
	0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x1a, 0x49, 0x0a, 0x06, 0x4f, 0x53, 0x44,
	0x69, 0x73, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x07, 0x73,
	0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x06, 0x73, 0x69,
	0x7a, 0x65, 0x47, 0x62, 0x1a, 0x45, 0x0a, 0x04, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x12, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x17, 0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x12, 0x10, 0x0a, 0x03, 0x6c, 0x75, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x03, 0x6c, 0x75, 0x6e, 0x1a, 0x6b, 0x0a, 0x0d, 0x4f,
	0x53, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x1c, 0x0a, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x12, 0x14,
	0x0a, 0x05, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x6f,
	0x66, 0x66, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x6c, 0x61, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x70, 0x6c, 0x61, 0x6e, 0x1a, 0x37, 0x0a, 0x09, 0x54, 0x61, 0x67, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x8f, 0x01, 0x0a, 0x0a, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x1b, 0x0a, 0x17, 0x50, 0x4f, 0x57, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x53, 0x54, 0x41, 0x52, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52,
	0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50,
	0x50, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x4f, 0x50, 0x50, 0x45,
	0x44, 0x10, 0x04, 0x12, 0x10, 0x0a, 0x0c, 0x44, 0x45, 0x41, 0x4c, 0x4c, 0x4f, 0x43, 0x41, 0x54,
	0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x44, 0x45, 0x41, 0x4c, 0x4c, 0x4f, 0x43,
	0x41, 0x54, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x07, 0x22, 0x3c, 0x0a, 0x0a, 0x42, 0x6f, 0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1b, 0x0a, 0x17, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07,
	0x0a, 0x03, 0x45, 0x46, 0x49, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x49, 0x4f, 0x53, 0x10,
	0x02, 0x22, 0x6c, 0x0a, 0x0e, 0x56, 0x6d, 0x41, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x12, 0x1f, 0x0a, 0x1b, 0x56, 0x4d, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x54,
	0x45, 0x43, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x1e, 0x0a, 0x1a, 0x56, 0x4d, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49,
	0x54, 0x45, 0x43, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x58, 0x38, 0x36, 0x5f, 0x46, 0x41, 0x4d, 0x49,
	0x4c, 0x59, 0x10, 0x01, 0x12, 0x19, 0x0a, 0x15, 0x56, 0x4d, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49,
	0x54, 0x45, 0x43, 0x54, 0x55, 0x52, 0x45, 0x5f, 0x41, 0x52, 0x4d, 0x36, 0x34, 0x10, 0x02, 0x22,
	0x5a, 0x0a, 0x10, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x6d, 0x73, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x46, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x54, 0x0a, 0x0d, 0x41,
	0x77, 0x73, 0x56, 0x6d, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x43, 0x0a, 0x07,
	0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x56,
	0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x22, 0x58, 0x0a, 0x0f, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x56, 0x6d, 0x73, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x45, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xcb, 0x02, 0x0a, 0x16,
	0x46, 0x65, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4e, 0x0a, 0x0a, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x5f, 0x76, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56,
	0x6d, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x09, 0x76, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x56, 0x6d, 0x73, 0x12, 0x45, 0x0a, 0x07, 0x61, 0x77, 0x73, 0x5f, 0x76, 0x6d,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x56, 0x6d, 0x73, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x06, 0x61, 0x77, 0x73, 0x56, 0x6d, 0x73, 0x12, 0x4b, 0x0a,
	0x09, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x5f, 0x76, 0x6d, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x56, 0x6d, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00,
	0x52, 0x08, 0x61, 0x7a, 0x75, 0x72, 0x65, 0x56, 0x6d, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x0b, 0x0a, 0x09,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x73, 0x22, 0xf8, 0x02, 0x0a, 0x1c, 0x46, 0x65,
	0x74, 0x63, 0x68, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x23, 0x0a, 0x21, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x5e, 0x0a,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a,
	0x0d, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x66, 0x6f, 0x72, 0x63, 0x65,
	0x52, 0x65, 0x66, 0x72, 0x65, 0x73, 0x68, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x45, 0x0a,
	0x0b, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18,
	0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x44, 0x49,
	0x53, 0x4b, 0x53, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x4e, 0x41, 0x50, 0x53, 0x48, 0x4f,
	0x54, 0x53, 0x10, 0x02, 0x22, 0xe0, 0x01, 0x0a, 0x1d, 0x46, 0x65, 0x74, 0x63, 0x68, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x50, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x09, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x89, 0x01, 0x0a, 0x15, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x5d, 0x0a, 0x10, 0x61, 0x77, 0x73, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00,
	0x52, 0x0e, 0x61, 0x77, 0x73, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x42, 0x11, 0x0a, 0x0f, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x22, 0xfb, 0x06, 0x0a, 0x11, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
	0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2d, 0x0a, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0a, 0x74, 0x69, 0x6d, 0x65, 0x5f,
	0x66, 0x72, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x46, 0x72, 0x61, 0x6d, 0x65, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x46, 0x72, 0x61, 0x6d, 0x65,
	0x12, 0x45, 0x0a, 0x0e, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x66, 0x72, 0x61, 0x6d, 0x65,
	0x45, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x76, 0x6d, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x76, 0x6d, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x03, 0x76, 0x6d, 0x73, 0x18, 0x0a,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x6d, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x49, 0x6e, 0x66, 0x6f, 0x52, 0x03, 0x76, 0x6d, 0x73, 0x22, 0x47, 0x0a, 0x05, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45,
	0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45,
	0x45, 0x44, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x03, 0x22, 0x46, 0x0a, 0x09, 0x54, 0x69, 0x6d, 0x65, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x12,
	0x1a, 0x0a, 0x16, 0x54, 0x49, 0x4d, 0x45, 0x5f, 0x46, 0x52, 0x41, 0x4d, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x57,
	0x45, 0x45, 0x4b, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x4f, 0x4e, 0x54, 0x48, 0x10, 0x02,
	0x12, 0x08, 0x0a, 0x04, 0x59, 0x45, 0x41, 0x52, 0x10, 0x03, 0x3a, 0x94, 0x01, 0xea, 0x41, 0x90,
	0x01, 0x0a, 0x2c, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x74,
	0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12,
	0x60, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x7b, 0x75, 0x74,
	0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x7d, 0x22, 0xe6, 0x01, 0x0a, 0x11, 0x56, 0x6d, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x5a, 0x0a, 0x11, 0x76, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x5f, 0x76, 0x6d, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x48, 0x00, 0x52, 0x0f, 0x76, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x13, 0x0a, 0x05, 0x76, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x76, 0x6d, 0x49, 0x64, 0x12, 0x53, 0x0a, 0x0b, 0x75, 0x74, 0x69, 0x6c,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x55, 0x74,
	0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x73,
	0x52, 0x0b, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0b, 0x0a,
	0x09, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xc4, 0x03, 0x0a, 0x14, 0x56,
	0x6d, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x72,
	0x69, 0x63, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x63, 0x70, 0x75, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x70,
	0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0d, 0x63, 0x70,
	0x75, 0x4d, 0x61, 0x78, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x2e, 0x0a, 0x13, 0x63,
	0x70, 0x75, 0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65,
	0x6e, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x05, 0x52, 0x11, 0x63, 0x70, 0x75, 0x41, 0x76, 0x65,
	0x72, 0x61, 0x67, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x2c, 0x0a, 0x12, 0x6d,
	0x65, 0x6d, 0x6f, 0x72, 0x79, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x79, 0x4d,
	0x61, 0x78, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x6d, 0x65, 0x6d,
	0x6f, 0x72, 0x79, 0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x63,
	0x65, 0x6e, 0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x6d, 0x65, 0x6d, 0x6f, 0x72,
	0x79, 0x41, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x50, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x12,
	0x30, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x69, 0x6f, 0x5f, 0x72, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x78, 0x5f, 0x6b, 0x62, 0x70, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x03, 0x52, 0x11,
	0x64, 0x69, 0x73, 0x6b, 0x49, 0x6f, 0x52, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x78, 0x4b, 0x62, 0x70,
	0x73, 0x12, 0x38, 0x0a, 0x19, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x69, 0x6f, 0x5f, 0x72, 0x61, 0x74,
	0x65, 0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6b, 0x62, 0x70, 0x73, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x49, 0x6f, 0x52, 0x61, 0x74, 0x65,
	0x41, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x4b, 0x62, 0x70, 0x73, 0x12, 0x3d, 0x0a, 0x1b, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x70, 0x75,
	0x74, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x6b, 0x62, 0x70, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x18, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68,
	0x70, 0x75, 0x74, 0x4d, 0x61, 0x78, 0x4b, 0x62, 0x70, 0x73, 0x12, 0x45, 0x0a, 0x1f, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x70, 0x75, 0x74,
	0x5f, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x6b, 0x62, 0x70, 0x73, 0x18, 0x10, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x1c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x68, 0x72, 0x6f,
	0x75, 0x67, 0x68, 0x70, 0x75, 0x74, 0x41, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x4b, 0x62, 0x70,
	0x73, 0x22, 0xbd, 0x02, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x4b, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x74,
	0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x56,
	0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42,
	0x79, 0x22, 0xda, 0x01, 0x0a, 0x1e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x64, 0x0a, 0x13, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xb4,
	0x01, 0x0a, 0x1b, 0x47, 0x65, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4b, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xaa, 0x02, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e,
	0x12, 0x2c, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x74, 0x69,
	0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x62, 0x0a, 0x12, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x37, 0x0a, 0x15, 0x75, 0x74,
	0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13,
	0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x49, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0x8e, 0x01, 0x0a, 0x1e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x74, 0x69,
	0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xe2, 0x01, 0x0a, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x6a, 0x0a, 0x15, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x14,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x6b, 0x0a, 0x1d, 0x47, 0x65, 0x74, 0x44,
	0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xb8, 0x02, 0x0a, 0x20, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x30, 0x12, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x17, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x15, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x49, 0x64, 0x12, 0x68, 0x0a, 0x14, 0x64, 0x61, 0x74, 0x61, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x13, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0x8d, 0x01, 0x0a, 0x20, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64,
	0x22, 0xa3, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x69, 0x0a, 0x14,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x30, 0x0a, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x52, 0x13, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x1a, 0x0a, 0x18, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64,
	0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0xf4, 0x01, 0x0a, 0x1f, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x12, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xd5, 0x0c, 0x0a, 0x1b, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x76, 0x6d, 0x5f,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x76, 0x6d, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x54, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a,
	0x28, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x2e, 0x0a, 0x13,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c,
	0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x61,
	0x67, 0x73, 0x12, 0x5c, 0x0a, 0x12, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x52, 0x11, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73,
	0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4f,
	0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x44, 0x69, 0x73,
	0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x5c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x58, 0x0a,
	0x0c, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4c,
	0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x6c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x59, 0x0a, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x65, 0x64, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x12, 0x5d, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x73, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x11,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e,
	0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6f, 0x6f, 0x74,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x6f,
	0x6f, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x74, 0x70,
	0x6d, 0x18, 0x15, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x56, 0x74, 0x70, 0x6d, 0x12, 0x43, 0x0a, 0x1b, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72,
	0x69, 0x74, 0x79, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x5a, 0x0a,
	0x0b, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x42, 0x6f,
	0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x62,
	0x6f, 0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x62, 0x0a, 0x08, 0x6d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66,
	0x61, 0x75, 0x6c, 0x74, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2f, 0x0a,
	0x13, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x73, 0x18, 0x11, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x61, 0x64, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x1a,
	0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4f, 0x0a, 0x0a, 0x65, 0x6e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x05, 0x52,
	0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x0f, 0x62,
	0x6f, 0x6f, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x14,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x42, 0x6f, 0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x6f, 0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x12, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x72,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x18, 0x18, 0x20, 0x03,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x64, 0x69, 0x73, 0x6b, 0x52, 0x65, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x5a, 0x6f, 0x6e, 0x65, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x22, 0x84, 0x0c, 0x0a, 0x1a, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x17, 0x0a, 0x07, 0x76, 0x6d, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x06, 0x76, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x2e, 0x0a, 0x13, 0x6d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x21, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x61, 0x67, 0x73, 0x12, 0x5c, 0x0a,
	0x12, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61,
	0x63, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x52, 0x11, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4f, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x64, 0x69, 0x73,
	0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x58, 0x0a, 0x0c, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x0b, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x54, 0x0a, 0x0f,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x52, 0x0e, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x12, 0x5d, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x73, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x75, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x52, 0x11,
	0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e,
	0x67, 0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6f, 0x6f, 0x74,
	0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x6f,
	0x6f, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x74, 0x70,
	0x6d, 0x18, 0x15, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x56, 0x74, 0x70, 0x6d, 0x12, 0x43, 0x0a, 0x1b, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x16, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72,
	0x69, 0x74, 0x79, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x55, 0x0a,
	0x0b, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x42, 0x6f,
	0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x62, 0x6f, 0x6f, 0x74, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x10, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2f, 0x0a, 0x13, 0x61, 0x64, 0x64, 0x69, 0x74,
	0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x11,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4c, 0x0a, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x13, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x0f, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x14, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x6f, 0x74, 0x43, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62,
	0x6f, 0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a,
	0x12, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x7a, 0x6f,
	0x6e, 0x65, 0x73, 0x18, 0x18, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10,
	0x64, 0x69, 0x73, 0x6b, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5a, 0x6f, 0x6e, 0x65, 0x73,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x81, 0x02, 0x0a, 0x10, 0x4e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x12, 0x1d, 0x0a,
	0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x23, 0x0a, 0x0a,
	0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x73, 0x75, 0x62, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x12, 0x24, 0x0a, 0x0b, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x69, 0x6e, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x5f, 0x69, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x49, 0x70, 0x12, 0x5d, 0x0a,
	0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x69, 0x65, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x69, 0x65, 0x72, 0x22, 0xb1, 0x01, 0x0a,
	0x0e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x12,
	0x44, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c,
	0x69, 0x65, 0x64, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x2e, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x6f, 0x73, 0x5f, 0x6c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x6f, 0x73, 0x4c, 0x69, 0x63,
	0x65, 0x6e, 0x73, 0x65, 0x22, 0x3a, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04,
	0x50, 0x41, 0x59, 0x47, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x42, 0x59, 0x4f, 0x4c, 0x10, 0x03,
	0x22, 0xd6, 0x01, 0x0a, 0x16, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x4e,
	0x6f, 0x64, 0x65, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b,
	0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x58, 0x0a,
	0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63,
	0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x4e, 0x6f, 0x64, 0x65, 0x41, 0x66, 0x66, 0x69,
	0x6e, 0x69, 0x74, 0x79, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x52, 0x08, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x16, 0x0a, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x22,
	0x38, 0x0a, 0x08, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x14, 0x4f,
	0x50, 0x45, 0x52, 0x41, 0x54, 0x4f, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x06, 0x0a, 0x02, 0x49, 0x4e, 0x10, 0x01, 0x12, 0x0a, 0x0a,
	0x06, 0x4e, 0x4f, 0x54, 0x5f, 0x49, 0x4e, 0x10, 0x02, 0x22, 0x9a, 0x04, 0x0a, 0x11, 0x43, 0x6f,
	0x6d, 0x70, 0x75, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x12,
	0x70, 0x0a, 0x13, 0x6f, 0x6e, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x6d, 0x61, 0x69, 0x6e, 0x74,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x6e, 0x48,
	0x6f, 0x73, 0x74, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x11,
	0x6f, 0x6e, 0x48, 0x6f, 0x73, 0x74, 0x4d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x12, 0x5d, 0x0a, 0x0c, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x53, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x52, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x52, 0x0b, 0x72, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x5c, 0x0a, 0x0f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x61, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74,
	0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69,
	0x6e, 0x67, 0x4e, 0x6f, 0x64, 0x65, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x79, 0x52, 0x0e,
	0x6e, 0x6f, 0x64, 0x65, 0x41, 0x66, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x22,
	0x0a, 0x0d, 0x6d, 0x69, 0x6e, 0x5f, 0x6e, 0x6f, 0x64, 0x65, 0x5f, 0x63, 0x70, 0x75, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0b, 0x6d, 0x69, 0x6e, 0x4e, 0x6f, 0x64, 0x65, 0x43, 0x70,
	0x75, 0x73, 0x22, 0x54, 0x0a, 0x11, 0x4f, 0x6e, 0x48, 0x6f, 0x73, 0x74, 0x4d, 0x61, 0x69, 0x6e,
	0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x1f, 0x4f, 0x4e, 0x5f, 0x48, 0x4f,
	0x53, 0x54, 0x5f, 0x4d, 0x41, 0x49, 0x4e, 0x54, 0x45, 0x4e, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x54, 0x45, 0x52, 0x4d, 0x49, 0x4e, 0x41, 0x54, 0x45, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x4d,
	0x49, 0x47, 0x52, 0x41, 0x54, 0x45, 0x10, 0x02, 0x22, 0x5c, 0x0a, 0x0b, 0x52, 0x65, 0x73, 0x74,
	0x61, 0x72, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x45, 0x53, 0x54, 0x41,
	0x52, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54,
	0x49, 0x43, 0x5f, 0x52, 0x45, 0x53, 0x54, 0x41, 0x52, 0x54, 0x10, 0x01, 0x12, 0x18, 0x0a, 0x14,
	0x4e, 0x4f, 0x5f, 0x41, 0x55, 0x54, 0x4f, 0x4d, 0x41, 0x54, 0x49, 0x43, 0x5f, 0x52, 0x45, 0x53,
	0x54, 0x41, 0x52, 0x54, 0x10, 0x02, 0x22, 0xd5, 0x03, 0x0a, 0x20, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x14, 0x0a, 0x04, 0x7a,
	0x6f, 0x6e, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04, 0x7a, 0x6f, 0x6e,
	0x65, 0x12, 0x74, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x69, 0x73, 0x6b, 0x73, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x73,
	0x6b, 0x73, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x48, 0x01, 0x52, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x6b, 0x0a, 0x12, 0x76, 0x6d, 0x5f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x56, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73,
	0x48, 0x01, 0x52, 0x10, 0x76, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61,
	0x75, 0x6c, 0x74, 0x73, 0x12, 0x54, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x0d, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x49, 0x0a, 0x05, 0x64, 0x69,
	0x73, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65,
	0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x52, 0x05,
	0x64, 0x69, 0x73, 0x6b, 0x73, 0x42, 0x0a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x0b, 0x0a, 0x09, 0x76, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0xb4,
	0x04, 0x0a, 0x16, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73,
	0x6b, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x31, 0x0a, 0x12, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x4f,
	0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x44, 0x69, 0x73,
	0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x76, 0x0a, 0x11, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74,
	0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x2e,
	0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x10, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x4c, 0x0a, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x69, 0x0a, 0x15, 0x76, 0x6d, 0x5f, 0x61, 0x74, 0x74, 0x61,
	0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x6d, 0x41, 0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x76, 0x6d, 0x41,
	0x74, 0x74, 0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x1a, 0x43, 0x0a, 0x15, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x3b, 0x0a, 0x13, 0x56, 0x6d, 0x41, 0x74, 0x74, 0x61, 0x63,
	0x68, 0x6d, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x24, 0x0a, 0x0b,
	0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0x23, 0x0a, 0x21, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x22, 0x9a, 0x09, 0x0a, 0x1e, 0x44, 0x69, 0x73, 0x6b,
	0x73, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x6d, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x1c, 0x0a, 0x07, 0x76, 0x6d,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x06, 0x76, 0x6d, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x13, 0x6d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a,
	0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x5f, 0x74, 0x61, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x54, 0x61, 0x67, 0x73, 0x12, 0x61, 0x0a,
	0x12, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61,
	0x63, 0x65, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49,
	0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73,
	0x12, 0x2c, 0x0a, 0x0f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x62,
	0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x69, 0x6e, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65,
	0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x11, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x69,
	0x6e, 0x67, 0x12, 0x24, 0x0a, 0x0b, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6f, 0x6f,
	0x74, 0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x65, 0x42, 0x6f, 0x6f, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x6e, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x76, 0x74, 0x70, 0x6d, 0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x56, 0x74, 0x70, 0x6d, 0x12, 0x43,
	0x0a, 0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69,
	0x74, 0x79, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x11, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65,
	0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
	0x69, 0x6e, 0x67, 0x12, 0x6a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x56, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x34, 0x0a, 0x13, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x69,
	0x63, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x12, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4c, 0x69, 0x63,
	0x65, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x1f, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x68, 0x6f,
	0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x64, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x56, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x60, 0x0a, 0x12,
	0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c,
	0x74, 0x73, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x62, 0x6f,
	0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x4c,
	0x0a, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x3b, 0x0a, 0x0d,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0xbf, 0x03, 0x0a, 0x10, 0x42, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73,
	0x6b, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x57, 0x0a, 0x05, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x6f, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x44,
	0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x48, 0x00, 0x52, 0x05, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b,
	0x4e, 0x61, 0x6d, 0x65, 0x12, 0x54, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x65,
	0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x12, 0x4c, 0x0a, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x5c,
	0x0a, 0x11, 0x44, 0x69, 0x73, 0x6b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x44, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x73, 0x12, 0x47, 0x0a, 0x0c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x24, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x1e, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x52,
	0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x42, 0x08, 0x0a, 0x06,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0xce, 0x02, 0x0a, 0x1f, 0x43, 0x6f, 0x6d, 0x70, 0x75,
	0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x71, 0x0a, 0x14, 0x64, 0x69,
	0x73, 0x6b, 0x73, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x12, 0x64, 0x69, 0x73, 0x6b, 0x73,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x68, 0x0a,
	0x11, 0x76, 0x6d, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x48, 0x00, 0x52, 0x0f, 0x76, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x41, 0x0a, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x44,
	0x69, 0x73, 0x6b, 0x52, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x42, 0x0b, 0x0a, 0x09, 0x76, 0x6d,
	0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x22, 0x59, 0x0a, 0x0e, 0x50, 0x65, 0x72, 0x73, 0x69,
	0x73, 0x74, 0x65, 0x6e, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x73,
	0x6b, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x64, 0x69, 0x73, 0x6b, 0x55,
	0x72, 0x69, 0x22, 0x22, 0x0a, 0x20, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x3b, 0x0a, 0x1d, 0x44, 0x69, 0x73, 0x6b, 0x73, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x56, 0x6d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1a, 0x0a, 0x06, 0x76, 0x6d, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x76, 0x6d,
	0x55, 0x72, 0x69, 0x22, 0x7e, 0x0a, 0x0e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x3e, 0x0a, 0x0d, 0x69, 0x64, 0x6c, 0x65, 0x5f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x69, 0x64, 0x6c, 0x65, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2c, 0x0a, 0x12, 0x73, 0x6b, 0x69, 0x70, 0x5f, 0x6f, 0x73,
	0x5f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x10, 0x73, 0x6b, 0x69, 0x70, 0x4f, 0x73, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0x80, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x56, 0x6d, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xab, 0x02, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x56, 0x6d, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x12, 0x45, 0x0a,
	0x04, 0x76, 0x69, 0x65, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x6d, 0x56, 0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04,
	0x76, 0x69, 0x65, 0x77, 0x22, 0xc2, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x52, 0x0a, 0x0d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76,
	0x6d, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x56, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x56, 0x6d, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xa2, 0x01, 0x0a, 0x15, 0x47, 0x65,
	0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56,
	0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x45, 0x0a, 0x04, 0x76, 0x69, 0x65, 0x77, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x56,
	0x69, 0x65, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x76, 0x69, 0x65, 0x77, 0x22, 0xc8,
	0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x56, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x50, 0x0a, 0x0c, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x5e, 0x0a, 0x18, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x56, 0x6d, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x6a, 0x0a, 0x15, 0x53, 0x74, 0x61,
	0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x51, 0x0a, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x76, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28,
	0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x0b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x6d, 0x22, 0x18, 0x0a, 0x16, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x6a, 0x0a, 0x15, 0x50, 0x61, 0x75, 0x73, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x0c, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x0b,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x22, 0x18, 0x0a, 0x16, 0x50,
	0x61, 0x75, 0x73, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6b, 0x0a, 0x16, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x51, 0x0a, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x0b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x56, 0x6d, 0x22, 0x19, 0x0a, 0x17, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x6d, 0x0a,
	0x18, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x0c, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52,
	0x0b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x22, 0x6b, 0x0a, 0x16,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x51, 0x0a, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x0b, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x22, 0x19, 0x0a, 0x17, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x64, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1b, 0x0a, 0x19, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xe5, 0x02, 0x0a, 0x0d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x07,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x07, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x20, 0x0a, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x3a, 0x76, 0xea, 0x41, 0x73, 0x0a, 0x28, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x12, 0x47, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x22, 0x5f, 0x0a, 0x17, 0x47, 0x65, 0x74,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe8, 0x01, 0x0a, 0x19, 0x4c,
	0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a,
	0x12, 0x28, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62,
	0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72,
	0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xca, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x2b,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75,
	0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x22, 0x8e, 0x02, 0x0a, 0x1a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x12, 0x28, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x56, 0x0a, 0x0e,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x49, 0x64, 0x22, 0xd0, 0x01, 0x0a, 0x1a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73,
	0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d,
	0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12,
	0x56, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x86, 0x01, 0x0a, 0x1a, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x44, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22,
	0xb7, 0x04, 0x0a, 0x05, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x6f, 0x0a, 0x15, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x13, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0x7c, 0x0a, 0x13,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x21, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e,
	0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x4d, 0x49,
	0x47, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x47, 0x43, 0x45, 0x10, 0x01, 0x12, 0x1f, 0x0a, 0x1b, 0x4d, 0x49, 0x47,
	0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x54, 0x59,
	0x50, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x53, 0x10, 0x02, 0x3a, 0x5d, 0xea, 0x41, 0x5a, 0x0a,
	0x20, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x12, 0x36, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x2f, 0x7b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x7d, 0x22, 0xd8, 0x01, 0x0a, 0x11, 0x4c, 0x69,
	0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x12, 0x20, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53,
	0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x22, 0xa9, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3f, 0x0a, 0x06, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x2b, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x4f, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xd4, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22,
	0x12, 0x20, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1e, 0x0a, 0x08, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x07, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x05, 0x67, 0x72,
	0x6f, 0x75, 0x70, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xaf, 0x01, 0x0a, 0x12, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b,
	0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x3d, 0x0a, 0x05,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x1d, 0x0a, 0x0a, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x76, 0x0a, 0x12, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22,
	0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x49, 0x64, 0x22, 0xaa, 0x01, 0x0a, 0x18, 0x41, 0x64, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x3e, 0x0a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x22, 0x0a, 0x20, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12,
	0x4e, 0x0a, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2b, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x56, 0x6d, 0x52, 0x0b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x22,
	0x1b, 0x0a, 0x19, 0x41, 0x64, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xad, 0x01, 0x0a,
	0x1b, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3e, 0x0a, 0x05,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x28, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x22, 0x0a, 0x20, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x4e, 0x0a, 0x0c,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2b, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52,
	0x0b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x22, 0x1e, 0x0a, 0x1c,
	0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xf9, 0x01, 0x0a,
	0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27,
	0x12, 0x25, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x74,
	0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x29, 0x0a, 0x0e, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x63, 0x75,
	0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x0b, 0x63, 0x75,
	0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75,
	0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x63,
	0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x5c, 0x0a, 0x17, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x1a, 0x0a, 0x18, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0xe2, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x74, 0x6f, 0x76,
	0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72,
	0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07,
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xbe, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74,
	0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0c, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a,
	0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a,
	0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72,
	0x4a, 0x6f, 0x62, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x59, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x43,
	0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62, 0x12, 0x2a, 0x0a,
	0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0xa7, 0x05, 0x0a, 0x0e,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x4e,
	0x0a, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x2e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43,
	0x6f, 0x64, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x46,
	0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72,
	0x70, 0x63, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x4d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x42, 0x0a, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x74, 0x65, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x39, 0x0a, 0x0a, 0x68, 0x65,
	0x6c, 0x70, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x48, 0x65, 0x6c, 0x70,
	0x2e, 0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x68, 0x65, 0x6c, 0x70,
	0x4c, 0x69, 0x6e, 0x6b, 0x73, 0x12, 0x3e, 0x0a, 0x0a, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xbd, 0x02, 0x0a, 0x09, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x43,
	0x6f, 0x64, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x5f, 0x43, 0x4f, 0x44,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x11, 0x0a, 0x0d, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52,
	0x10, 0x01, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x56, 0x41, 0x4c,
	0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x02, 0x12,
	0x1c, 0x0a, 0x18, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x12, 0x1c, 0x0a,
	0x18, 0x54, 0x41, 0x52, 0x47, 0x45, 0x54, 0x5f, 0x52, 0x45, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54,
	0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x04, 0x12, 0x17, 0x0a, 0x13, 0x4f,
	0x53, 0x5f, 0x41, 0x44, 0x41, 0x50, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x52, 0x52,
	0x4f, 0x52, 0x10, 0x05, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x4c, 0x4f, 0x4e, 0x45, 0x5f, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x06, 0x12, 0x11, 0x0a, 0x0d, 0x43, 0x55, 0x54, 0x4f, 0x56, 0x45, 0x52,
	0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x07, 0x12, 0x1c, 0x0a, 0x18, 0x55, 0x54, 0x49, 0x4c,
	0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x45,
	0x52, 0x52, 0x4f, 0x52, 0x10, 0x08, 0x12, 0x1b, 0x0a, 0x17, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x41,
	0x4e, 0x43, 0x45, 0x5f, 0x55, 0x50, 0x47, 0x52, 0x41, 0x44, 0x45, 0x5f, 0x45, 0x52, 0x52, 0x4f,
	0x52, 0x10, 0x09, 0x12, 0x16, 0x0a, 0x12, 0x49, 0x4d, 0x41, 0x47, 0x45, 0x5f, 0x49, 0x4d, 0x50,
	0x4f, 0x52, 0x54, 0x5f, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x0a, 0x12, 0x18, 0x0a, 0x14, 0x44,
	0x49, 0x53, 0x4b, 0x5f, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x52,
	0x52, 0x4f, 0x52, 0x10, 0x0b, 0x22, 0xb0, 0x03, 0x0a, 0x10, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x4d, 0x0a, 0x04, 0x63, 0x6f,
	0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x43,
	0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x4a, 0x0a, 0x0f, 0x77, 0x61, 0x72,
	0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e,
	0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x42, 0x0a, 0x0b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x69, 0x74, 0x65, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x4c, 0x6f, 0x63, 0x61, 0x6c, 0x69, 0x7a, 0x65,
	0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x39, 0x0a, 0x0a, 0x68, 0x65, 0x6c,
	0x70, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x48, 0x65, 0x6c, 0x70, 0x2e,
	0x4c, 0x69, 0x6e, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x68, 0x65, 0x6c, 0x70, 0x4c,
	0x69, 0x6e, 0x6b, 0x73, 0x12, 0x3d, 0x0a, 0x0c, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0b, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x54,
	0x69, 0x6d, 0x65, 0x22, 0x43, 0x0a, 0x0b, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x43, 0x6f,
	0x64, 0x65, 0x12, 0x1c, 0x0a, 0x18, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x4f,
	0x44, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x16, 0x0a, 0x12, 0x41, 0x44, 0x41, 0x50, 0x54, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x57,
	0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x22, 0xfa, 0x04, 0x0a, 0x15, 0x56, 0x6d, 0x77,
	0x61, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x5c, 0x0a, 0x08, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56,
	0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x12, 0x3b, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65,
	0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x5f, 0x0a,
	0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x44, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x2e, 0x56, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x12, 0x62,
	0x0a, 0x14, 0x76, 0x6d, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x43, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12,
	0x76, 0x6d, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x49, 0x6e,
	0x66, 0x6f, 0x12, 0x54, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75,
	0x72, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x41, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65,
	0x63, 0x74, 0x75, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68,
	0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x1a, 0x72, 0x0a, 0x11, 0x56, 0x6d, 0x77, 0x61,
	0x72, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x24, 0x0a,
	0x0b, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x4e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x12, 0x1c, 0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47,
	0x62, 0x12, 0x19, 0x0a, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x37, 0x0a, 0x08,
	0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x46, 0x49, 0x52, 0x4d,
	0x57, 0x41, 0x52, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x45, 0x46, 0x49, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x42,
	0x49, 0x4f, 0x53, 0x10, 0x02, 0x22, 0xf2, 0x04, 0x0a, 0x12, 0x41, 0x77, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x59, 0x0a, 0x08,
	0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e,
	0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x66,
	0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x12, 0x3b, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x69,
	0x74, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74,
	0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x63,
	0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42,
	0x79, 0x74, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x18, 0x03, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x2e, 0x41, 0x77, 0x73, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x12,
	0x62, 0x0a, 0x14, 0x76, 0x6d, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69,
	0x65, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x43, 0x61,
	0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x12, 0x76, 0x6d, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x54, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x41, 0x72, 0x63, 0x68, 0x69, 0x74,
	0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x61, 0x72, 0x63,
	0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x1a, 0x76, 0x0a, 0x0e, 0x41, 0x77, 0x73,
	0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x64,
	0x69, 0x73, 0x6b, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x4e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x12, 0x20, 0x0a, 0x09, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x76, 0x6f, 0x6c, 0x75, 0x6d,
	0x65, 0x49, 0x64, 0x12, 0x1c, 0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47,
	0x62, 0x22, 0x37, 0x0a, 0x08, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x12, 0x18, 0x0a,
	0x14, 0x46, 0x49, 0x52, 0x4d, 0x57, 0x41, 0x52, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x45, 0x46, 0x49, 0x10, 0x01,
	0x12, 0x08, 0x0a, 0x04, 0x42, 0x49, 0x4f, 0x53, 0x10, 0x02, 0x22, 0xf8, 0x04, 0x0a, 0x14, 0x41,
	0x7a, 0x75, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x12, 0x5b, 0x0a, 0x08, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56,
	0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x66, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65,
	0x12, 0x3b, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65,
	0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x42, 0x79, 0x74, 0x65, 0x73, 0x12, 0x5d, 0x0a,
	0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x7a, 0x75, 0x72, 0x65,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x56, 0x6d, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e,
	0x41, 0x7a, 0x75, 0x72, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x64, 0x69, 0x73, 0x6b, 0x73, 0x12, 0x62, 0x0a, 0x14,
	0x76, 0x6d, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f,
	0x69, 0x6e, 0x66, 0x6f, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x43, 0x61, 0x70, 0x61, 0x62,
	0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x76, 0x6d,
	0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x49, 0x6e, 0x66, 0x6f,
	0x12, 0x54, 0x0a, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6d, 0x41, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74,
	0x75, 0x72, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74,
	0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x1a, 0x74, 0x0a, 0x10, 0x41, 0x7a, 0x75, 0x72, 0x65, 0x44,
	0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x24, 0x0a, 0x0b, 0x64, 0x69,
	0x73, 0x6b, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x12, 0x1c, 0x0a, 0x07, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x64, 0x69, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x1c,
	0x0a, 0x07, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x73, 0x69, 0x7a, 0x65, 0x47, 0x62, 0x22, 0x37, 0x0a, 0x08,
	0x46, 0x69, 0x72, 0x6d, 0x77, 0x61, 0x72, 0x65, 0x12, 0x18, 0x0a, 0x14, 0x46, 0x49, 0x52, 0x4d,
	0x57, 0x41, 0x52, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x45, 0x46, 0x49, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x42,
	0x49, 0x4f, 0x53, 0x10, 0x02, 0x22, 0xee, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x52, 0x65, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67,
	0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f,
	0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xd6, 0x01, 0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x61, 0x0a, 0x12, 0x72, 0x65, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79,
	0x63, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0x65, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd5, 0x01, 0x0a, 0x0e, 0x56, 0x6d, 0x43, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x5a, 0x0a, 0x0f, 0x6f, 0x73, 0x5f,
	0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x4f, 0x73, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x06, 0xe0,
	0x41, 0x03, 0xe0, 0x41, 0x06, 0x52, 0x0e, 0x6f, 0x73, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c,
	0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x67, 0x0a, 0x20, 0x6c, 0x61, 0x73, 0x74, 0x5f, 0x6f, 0x73,
	0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x5f, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x1c, 0x6c, 0x61, 0x73, 0x74, 0x4f, 0x73, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69,
	0x74, 0x69, 0x65, 0x73, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xf2,
	0x05, 0x0a, 0x0b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x31,
	0x0a, 0x11, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f,
	0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48, 0x00,
	0x52, 0x0f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x72,
	0x69, 0x12, 0x77, 0x0a, 0x1a, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48,
	0x01, 0x52, 0x17, 0x64, 0x69, 0x73, 0x6b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x80, 0x01, 0x0a, 0x1d, 0x6d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x48,
	0x01, 0x52, 0x1a, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x73, 0x12, 0x17, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x69, 0x0a, 0x18, 0x72, 0x65, 0x63, 0x65,
	0x6e, 0x74, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f,
	0x6a, 0x6f, 0x62, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x15, 0x72, 0x65,
	0x63, 0x65, 0x6e, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a,
	0x6f, 0x62, 0x73, 0x12, 0x4c, 0x0a, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x3a, 0x82, 0x01, 0xea, 0x41, 0x7f, 0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12,
	0x3a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x7b, 0x6a, 0x6f, 0x62, 0x7d, 0x2a, 0x0c, 0x69, 0x6d, 0x61,
	0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x32, 0x0b, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x08, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x42, 0x11, 0x0a, 0x0f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x66, 0x61, 0x75,
	0x6c, 0x74, 0x73, 0x22, 0xd3, 0x08, 0x0a, 0x0e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x31, 0x0a, 0x11, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x0a, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x55, 0x72, 0x69, 0x12, 0x75, 0x0a, 0x19, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x16, 0x64, 0x69, 0x73, 0x6b, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x7e, 0x0a, 0x1c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x48, 0x01, 0x52, 0x19, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73,
	0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x30, 0x0a, 0x11, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x4c, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65,
	0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07,
	0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2f, 0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12, 0x4e, 0x0a, 0x08, 0x77, 0x61, 0x72, 0x6e,
	0x69, 0x6e, 0x67, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x57, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x47, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70,
	0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x53, 0x74, 0x65, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70,
	0x73, 0x22, 0x72, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54,
	0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0b, 0x0a, 0x07, 0x50, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0b,
	0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x53,
	0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c,
	0x4c, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c,
	0x4c, 0x45, 0x44, 0x10, 0x06, 0x3a, 0xa5, 0x01, 0xea, 0x41, 0xa1, 0x01, 0x0a, 0x29, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x7b, 0x6a,
	0x6f, 0x62, 0x7d, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a,
	0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x7d, 0x2a, 0x0f, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x32, 0x0e, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x42, 0x08, 0x0a,
	0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x10, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x8c, 0x04, 0x0a, 0x0f, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x65, 0x70, 0x12, 0x5e, 0x0a,
	0x0c, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52,
	0x0c, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x12, 0x6c, 0x0a,
	0x14, 0x6c, 0x6f, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f,
	0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x6f, 0x61, 0x64, 0x69, 0x6e,
	0x67, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65,
	0x73, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x12, 0x6c, 0x6f, 0x61, 0x64, 0x69, 0x6e, 0x67,
	0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c, 0x65, 0x73, 0x12, 0x4e, 0x0a, 0x0b, 0x61,
	0x64, 0x61, 0x70, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x6f, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x64, 0x61, 0x70, 0x74, 0x69, 0x6e, 0x67, 0x4f, 0x53, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52,
	0x0a, 0x61, 0x64, 0x61, 0x70, 0x74, 0x69, 0x6e, 0x67, 0x4f, 0x73, 0x12, 0x57, 0x0a, 0x0e, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53,
	0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65,
	0x42, 0x06, 0x0a, 0x04, 0x73, 0x74, 0x65, 0x70, 0x22, 0x1d, 0x0a, 0x1b, 0x49, 0x6e, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x69, 0x7a, 0x69, 0x6e, 0x67, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x53, 0x74, 0x65, 0x70, 0x22, 0x1d, 0x0a, 0x1b, 0x4c, 0x6f, 0x61, 0x64, 0x69,
	0x6e, 0x67, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x46, 0x69, 0x6c,
	0x65, 0x73, 0x53, 0x74, 0x65, 0x70, 0x22, 0x13, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x53, 0x74, 0x65, 0x70, 0x22, 0xbf, 0x06, 0x0a, 0x16,
	0x44, 0x69, 0x73, 0x6b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x7f, 0x0a, 0x18, 0x6f, 0x73, 0x5f, 0x61, 0x64, 0x61,
	0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x4f, 0x73, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52,
	0x16, 0x6f, 0x73, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x6c, 0x0a, 0x16, 0x64, 0x61, 0x74, 0x61, 0x5f,
	0x64, 0x69, 0x73, 0x6b, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x13, 0x64, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0e, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x66, 0x61, 0x6d,
	0x69, 0x6c, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x0a, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x5c, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69,
	0x73, 0x6b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x34, 0x0a,
	0x13, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x12, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4c, 0x69, 0x63, 0x65, 0x6e,
	0x73, 0x65, 0x73, 0x12, 0x37, 0x0a, 0x15, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x52,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x4c, 0x0a, 0x0a,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0a,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x16, 0x0a, 0x14, 0x6f, 0x73, 0x5f, 0x61, 0x64, 0x61, 0x70,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x80, 0x0a,
	0x0a, 0x19, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x7f, 0x0a, 0x18, 0x6f,
	0x73, 0x5f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x73, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x48, 0x00, 0x52, 0x16, 0x6f, 0x73, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x62, 0x0a, 0x12,
	0x73, 0x6b, 0x69, 0x70, 0x5f, 0x6f, 0x73, 0x5f, 0x61, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6b, 0x69, 0x70, 0x4f, 0x73, 0x41, 0x64, 0x61,
	0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10,
	0x73, 0x6b, 0x69, 0x70, 0x4f, 0x73, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x31, 0x0a, 0x12, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x10, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x57, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x0d, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x25, 0x0a, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x37, 0x0a, 0x15, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x5f, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x52,
	0x65, 0x67, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x12, 0x4c, 0x0a, 0x0a,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x05, 0x52, 0x0a,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8e, 0x01, 0x0a, 0x22, 0x6d,
	0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x4f, 0x76, 0x65, 0x72,
	0x72, 0x69, 0x64, 0x65, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1f, 0x6d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12, 0x59, 0x0a, 0x0f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41,
	0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x13, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x18, 0x09, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x12, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x61, 0x6c, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x12, 0x5f, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x63, 0x68, 0x69,
	0x6e, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x17, 0x0a,
	0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x12, 0x72, 0x0a, 0x18, 0x73, 0x68, 0x69, 0x65, 0x6c, 0x64,
	0x65, 0x64, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x16, 0x73, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x61, 0x0a, 0x12, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73,
	0x18, 0x0d, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65,
	0x72, 0x66, 0x61, 0x63, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x1a, 0x39, 0x0a,
	0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x16, 0x0a, 0x14, 0x6f, 0x73, 0x5f, 0x61,
	0x64, 0x61, 0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x22, 0x6e, 0x0a, 0x0e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x05, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x69, 0x61, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x05, 0x65, 0x6d,
	0x61, 0x69, 0x6c, 0x12, 0x1b, 0x0a, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x73,
	0x22, 0xa9, 0x02, 0x0a, 0x16, 0x53, 0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x64, 0x0a, 0x0b, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x65, 0x5f, 0x62, 0x6f, 0x6f, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x68, 0x69, 0x65, 0x6c, 0x64, 0x65, 0x64, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x53, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x6f, 0x6f, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x6f, 0x6f,
	0x74, 0x12, 0x24, 0x0a, 0x0b, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x74, 0x70, 0x6d,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65, 0x6e, 0x61,
	0x62, 0x6c, 0x65, 0x56, 0x74, 0x70, 0x6d, 0x12, 0x43, 0x0a, 0x1b, 0x65, 0x6e, 0x61, 0x62, 0x6c,
	0x65, 0x5f, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x19, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x69,
	0x74, 0x79, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x22, 0x3e, 0x0a, 0x0a,
	0x53, 0x65, 0x63, 0x75, 0x72, 0x65, 0x42, 0x6f, 0x6f, 0x74, 0x12, 0x1b, 0x0a, 0x17, 0x53, 0x45,
	0x43, 0x55, 0x52, 0x45, 0x5f, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x54, 0x52, 0x55, 0x45, 0x10,
	0x01, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x41, 0x4c, 0x53, 0x45, 0x10, 0x02, 0x22, 0x49, 0x0a, 0x1f,
	0x4d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x73, 0x12,
	0x26, 0x0a, 0x0c, 0x6d, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6d, 0x61, 0x63, 0x68,
	0x69, 0x6e, 0x65, 0x54, 0x79, 0x70, 0x65, 0x22, 0x82, 0x02, 0x0a, 0x21, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4f, 0x73, 0x41, 0x64, 0x61, 0x70, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x23, 0x0a,
	0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x69,
	0x7a, 0x65, 0x12, 0x5d, 0x0a, 0x0c, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x59, 0x0a, 0x0f, 0x62, 0x6f, 0x6f, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x42, 0x6f, 0x6f, 0x74, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x62, 0x6f,
	0x6f, 0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x15, 0x0a, 0x13,
	0x44, 0x61, 0x74, 0x61, 0x44, 0x69, 0x73, 0x6b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x22, 0x12, 0x0a, 0x10, 0x53, 0x6b, 0x69, 0x70, 0x4f, 0x73, 0x41, 0x64, 0x61,
	0x70, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x5b, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xe4, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x46, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b,
	0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a, 0x08, 0x6f,
	0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc2, 0x01, 0x0a, 0x18,
	0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d,
	0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x2b, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72,
	0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x85, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x28, 0x12, 0x26, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x0d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x49, 0x64, 0x12, 0x50, 0x0a, 0x0c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f,
	0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x82, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x42, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x61, 0x0a,
	0x18, 0x47, 0x65, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x0a,
	0x29, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x61, 0x67,
	0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x22, 0xea, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x49, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x31, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a,
	0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xcf, 0x01,
	0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5c, 0x0a,
	0x11, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x6a, 0x6f,
	0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f,
	0x72, 0x74, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e,
	0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x25, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65,
	0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22,
	0x64, 0x0a, 0x1b, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x31, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x1e, 0x0a, 0x1c, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x95, 0x07, 0x0a, 0x10, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x6a, 0x0a, 0x17, 0x61, 0x77,
	0x73, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x48, 0x00,
	0x52, 0x14, 0x61, 0x77, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x08, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x66, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4e,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x33, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x2e, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x2f,
	0x0a, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x73, 0x12,
	0x49, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73,
	0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x65, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x22, 0x70, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45,
	0x41, 0x44, 0x59, 0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x55, 0x4e, 0x4e, 0x49, 0x4e, 0x47,
	0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10,
	0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x49, 0x4e, 0x47, 0x10,
	0x05, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x06,
	0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x3a, 0xb7, 0x01, 0xea,
	0x41, 0xb3, 0x01, 0x0a, 0x2b, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x12, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x6b, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x64, 0x69,
	0x73, 0x6b, 0x5f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62,
	0x7d, 0x2a, 0x11, 0x64, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x73, 0x32, 0x10, 0x64, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x42, 0x15, 0x0a, 0x13, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xd0, 0x03,
	0x0a, 0x1d, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12,
	0x56, 0x0a, 0x0b, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x44, 0x69, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x48, 0x00, 0x52, 0x0a, 0x74, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x57, 0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x0d, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x12, 0x63, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x4c, 0x0a, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x10,
	0x0a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x22, 0x8e, 0x04, 0x0a, 0x11, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x74, 0x65, 0x70, 0x12, 0x80, 0x01, 0x0a, 0x1d, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x6b, 0x5f,
	0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x1a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x73,
	0x6b, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x7d, 0x0a, 0x1c, 0x63, 0x6f, 0x70,
	0x79, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x6b,
	0x5f, 0x73, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f,
	0x70, 0x79, 0x69, 0x6e, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x53,
	0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x19, 0x63,
	0x6f, 0x70, 0x79, 0x69, 0x6e, 0x67, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x73, 0x6b,
	0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x12, 0x73, 0x0a, 0x18, 0x70, 0x72, 0x6f, 0x76,
	0x69, 0x73, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f,
	0x64, 0x69, 0x73, 0x6b, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69,
	0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x53,
	0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x16, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
	0x69, 0x6e, 0x67, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x3e, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x42, 0x06, 0x0a, 0x04, 0x73, 0x74, 0x65,
	0x70, 0x22, 0x20, 0x0a, 0x1e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74, 0x53,
	0x74, 0x65, 0x70, 0x22, 0x1f, 0x0a, 0x1d, 0x43, 0x6f, 0x70, 0x79, 0x69, 0x6e, 0x67, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x6e, 0x61, 0x70, 0x73, 0x68, 0x6f, 0x74,
	0x53, 0x74, 0x65, 0x70, 0x22, 0x1c, 0x0a, 0x1a, 0x50, 0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f,
	0x6e, 0x69, 0x6e, 0x67, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x53, 0x74,
	0x65, 0x70, 0x22, 0x96, 0x02, 0x0a, 0x11, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x12, 0x1c, 0x0a, 0x07, 0x64, 0x69, 0x73, 0x6b,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x64, 0x69, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x3d, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x4e, 0x0a, 0x0d, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41,
	0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x5a, 0x6f, 0x6e, 0x65, 0x73, 0x12, 0x54, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x22, 0xa9, 0x03, 0x0a, 0x14,
	0x41, 0x77, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x76, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x49, 0x64, 0x12, 0x1e, 0x0a, 0x08, 0x73, 0x69, 0x7a, 0x65, 0x5f, 0x67,
	0x69, 0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x73,
	0x69, 0x7a, 0x65, 0x47, 0x69, 0x62, 0x12, 0x5b, 0x0a, 0x09, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x77, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x42, 0x06, 0xe0, 0x41, 0x01, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x64, 0x69, 0x73, 0x6b, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x57, 0x0a, 0x04, 0x74, 0x61, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x77, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x73, 0x2e, 0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x06,
	0xe0, 0x41, 0x01, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x74, 0x61, 0x67, 0x73, 0x1a, 0x37, 0x0a, 0x09,
	0x54, 0x61, 0x67, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x60, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a,
	0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x47, 0x50, 0x32, 0x10, 0x01, 0x12, 0x07, 0x0a, 0x03,
	0x47, 0x50, 0x33, 0x10, 0x02, 0x12, 0x07, 0x0a, 0x03, 0x49, 0x4f, 0x31, 0x10, 0x03, 0x12, 0x07,
	0x0a, 0x03, 0x49, 0x4f, 0x32, 0x10, 0x04, 0x12, 0x07, 0x0a, 0x03, 0x53, 0x54, 0x31, 0x10, 0x05,
	0x12, 0x07, 0x0a, 0x03, 0x53, 0x43, 0x31, 0x10, 0x06, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41,
	0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x07, 0x22, 0xb2, 0x02, 0x0a, 0x1d, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2d, 0x12, 0x2b, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69,
	0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x36, 0x0a, 0x15, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x64, 0x69, 0x73, 0x6b,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x60,
	0x0a, 0x12, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x6a, 0x6f, 0x62, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10,
	0x64, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62,
	0x12, 0x2a, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08,
	0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xee, 0x01, 0x0a,
	0x1c, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4b, 0x0a,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x2d, 0x12, 0x2b, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0x80, 0x02,
	0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x62, 0x0a, 0x13, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x11, 0x64, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x73, 0x12, 0x2e, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x4b, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x03, 0xfa, 0x41, 0x23,
	0x0a, 0x21, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65,
	0x22, 0x65, 0x0a, 0x1a, 0x47, 0x65, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xef, 0x01, 0x0a, 0x1d, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x60, 0x0a, 0x12, 0x64,
	0x69, 0x73, 0x6b, 0x5f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f,
	0x62, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x64, 0x69, 0x73,
	0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x2a, 0x0a,
	0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x0b, 0xe0, 0x41, 0x01, 0xe2, 0x8c, 0xcf, 0xd7, 0x08, 0x02, 0x08, 0x01, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0x68, 0x0a, 0x1d, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x0a, 0x2b, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73,
	0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x65, 0x0a, 0x1a, 0x52, 0x75, 0x6e, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x1d, 0x0a, 0x1b, 0x52, 0x75,
	0x6e, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x68, 0x0a, 0x1d, 0x43, 0x61, 0x6e,
	0x63, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x33, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2d,
	0x0a, 0x2b, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x69, 0x73,
	0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x20, 0x0a, 0x1e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x44, 0x69, 0x73,
	0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2a, 0xe2, 0x01, 0x0a, 0x15, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x28, 0x0a, 0x24, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e,
	0x45, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x25, 0x0a, 0x21, 0x43, 0x4f, 0x4d,
	0x50, 0x55, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x4b,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x01,
	0x12, 0x20, 0x0a, 0x1c, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49,
	0x4e, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x53, 0x44,
	0x10, 0x02, 0x12, 0x25, 0x0a, 0x21, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x45, 0x4e,
	0x47, 0x49, 0x4e, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x42,
	0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x44, 0x10, 0x03, 0x12, 0x2f, 0x0a, 0x2b, 0x43, 0x4f, 0x4d,
	0x50, 0x55, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x44, 0x49, 0x53, 0x4b,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x48, 0x59, 0x50, 0x45, 0x52, 0x44, 0x49, 0x53, 0x4b, 0x5f,
	0x42, 0x41, 0x4c, 0x41, 0x4e, 0x43, 0x45, 0x44, 0x10, 0x04, 0x2a, 0x8f, 0x01, 0x0a, 0x18, 0x43,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4c, 0x69, 0x63, 0x65,
	0x6e, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x23, 0x43, 0x4f, 0x4d, 0x50, 0x55,
	0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x45, 0x46, 0x41, 0x55, 0x4c, 0x54, 0x10, 0x00,
	0x12, 0x24, 0x0a, 0x20, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49,
	0x4e, 0x45, 0x5f, 0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x50, 0x41, 0x59, 0x47, 0x10, 0x01, 0x12, 0x24, 0x0a, 0x20, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54,
	0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x4c, 0x49, 0x43, 0x45, 0x4e, 0x53, 0x45,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x42, 0x59, 0x4f, 0x4c, 0x10, 0x02, 0x2a, 0x8e, 0x01, 0x0a,
	0x17, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x42, 0x6f,
	0x6f, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x2a, 0x0a, 0x26, 0x43, 0x4f, 0x4d, 0x50,
	0x55, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x42, 0x4f, 0x4f, 0x54, 0x5f,
	0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x22, 0x0a, 0x1e, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x5f,
	0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x4f, 0x50, 0x54, 0x49,
	0x4f, 0x4e, 0x5f, 0x45, 0x46, 0x49, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x43, 0x4f, 0x4d, 0x50,
	0x55, 0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x42, 0x4f, 0x4f, 0x54, 0x5f,
	0x4f, 0x50, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x42, 0x49, 0x4f, 0x53, 0x10, 0x02, 0x2a, 0xa9, 0x01,
	0x0a, 0x0c, 0x4f, 0x73, 0x43, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1d,
	0x0a, 0x19, 0x4f, 0x53, 0x5f, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x25, 0x0a,
	0x21, 0x4f, 0x53, 0x5f, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x4e,
	0x56, 0x4d, 0x45, 0x5f, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x5f, 0x41, 0x43, 0x43, 0x45,
	0x53, 0x53, 0x10, 0x01, 0x12, 0x29, 0x0a, 0x25, 0x4f, 0x53, 0x5f, 0x43, 0x41, 0x50, 0x41, 0x42,
	0x49, 0x4c, 0x49, 0x54, 0x59, 0x5f, 0x47, 0x56, 0x4e, 0x49, 0x43, 0x5f, 0x4e, 0x45, 0x54, 0x57,
	0x4f, 0x52, 0x4b, 0x5f, 0x49, 0x4e, 0x54, 0x45, 0x52, 0x46, 0x41, 0x43, 0x45, 0x10, 0x02, 0x12,
	0x28, 0x0a, 0x24, 0x4f, 0x53, 0x5f, 0x43, 0x41, 0x50, 0x41, 0x42, 0x49, 0x4c, 0x49, 0x54, 0x59,
	0x5f, 0x49, 0x44, 0x50, 0x46, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x49, 0x4e,
	0x54, 0x45, 0x52, 0x46, 0x41, 0x43, 0x45, 0x10, 0x03, 0x2a, 0x4c, 0x0a, 0x0e, 0x42, 0x6f, 0x6f,
	0x74, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x1b, 0x42,
	0x4f, 0x4f, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x56, 0x45, 0x52, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04,
	0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x42, 0x49, 0x4f, 0x53, 0x5f, 0x54,
	0x4f, 0x5f, 0x45, 0x46, 0x49, 0x10, 0x02, 0x2a, 0x55, 0x0a, 0x15, 0x55, 0x74, 0x69, 0x6c, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x56, 0x69, 0x65, 0x77,
	0x12, 0x27, 0x0a, 0x23, 0x55, 0x54, 0x49, 0x4c, 0x49, 0x5a, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x52, 0x45, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50,
	0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x42, 0x41, 0x53,
	0x49, 0x43, 0x10, 0x01, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x2a, 0x6d,
	0x0a, 0x0f, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x56, 0x69, 0x65,
	0x77, 0x12, 0x21, 0x0a, 0x1d, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x56,
	0x4d, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x5f, 0x56, 0x4d, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x42, 0x41, 0x53, 0x49, 0x43, 0x10,
	0x01, 0x12, 0x1a, 0x0a, 0x16, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x5f, 0x56,
	0x4d, 0x5f, 0x56, 0x49, 0x45, 0x57, 0x5f, 0x46, 0x55, 0x4c, 0x4c, 0x10, 0x02, 0x2a, 0x6c, 0x0a,
	0x0e, 0x56, 0x6d, 0x41, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x12,
	0x1f, 0x0a, 0x1b, 0x56, 0x4d, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x54, 0x45, 0x43, 0x54, 0x55,
	0x52, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x1e, 0x0a, 0x1a, 0x56, 0x4d, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x54, 0x45, 0x43, 0x54,
	0x55, 0x52, 0x45, 0x5f, 0x58, 0x38, 0x36, 0x5f, 0x46, 0x41, 0x4d, 0x49, 0x4c, 0x59, 0x10, 0x01,
	0x12, 0x19, 0x0a, 0x15, 0x56, 0x4d, 0x5f, 0x41, 0x52, 0x43, 0x48, 0x49, 0x54, 0x45, 0x43, 0x54,
	0x55, 0x52, 0x45, 0x5f, 0x41, 0x52, 0x4d, 0x36, 0x34, 0x10, 0x02, 0x2a, 0x7c, 0x0a, 0x18, 0x43,
	0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x4e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x54, 0x69, 0x65, 0x72, 0x12, 0x2b, 0x0a, 0x27, 0x43, 0x4f, 0x4d, 0x50, 0x55,
	0x54, 0x45, 0x5f, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52,
	0x4b, 0x5f, 0x54, 0x49, 0x45, 0x52, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f,
	0x54, 0x49, 0x45, 0x52, 0x5f, 0x53, 0x54, 0x41, 0x4e, 0x44, 0x41, 0x52, 0x44, 0x10, 0x01, 0x12,
	0x18, 0x0a, 0x14, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x5f, 0x54, 0x49, 0x45, 0x52, 0x5f,
	0x50, 0x52, 0x45, 0x4d, 0x49, 0x55, 0x4d, 0x10, 0x02, 0x32, 0xeb, 0x70, 0x0a, 0x0b, 0x56, 0x6d,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xae, 0x01, 0x0a, 0x0b, 0x4c, 0x69,
	0x73, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3c, 0xda, 0x41,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x9b, 0x01, 0x0a, 0x09, 0x47,
	0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x22, 0x3a, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x12, 0x2b, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd4, 0x01, 0x0a, 0x0c, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x73, 0xca, 0x41, 0x1b, 0x0a,
	0x06, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x3a, 0x06, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x22, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12,
	0xd6, 0x01, 0x0a, 0x0c, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x75, 0xca, 0x41, 0x1b, 0x0a, 0x06, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x12, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x3a, 0x06, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x32, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc8, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x67, 0xca, 0x41, 0x2a, 0x0a,
	0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2d, 0x2a, 0x2b, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x12, 0xc8, 0x01, 0x0a, 0x0e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x49, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x4d, 0xda, 0x41, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e,
	0x12, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x66, 0x65, 0x74, 0x63, 0x68, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0xe9,
	0x01, 0x0a, 0x15, 0x46, 0x65, 0x74, 0x63, 0x68, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x53, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x46, 0x65, 0x74, 0x63, 0x68, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x49, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x59, 0xda, 0x41, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x74, 0x79, 0x70, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x45, 0x12, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x65, 0x74, 0x63, 0x68, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0xe4, 0x01, 0x0a, 0x16, 0x4c,
	0x69, 0x73, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x51,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x12,
	0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75,
	0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x73, 0x12, 0xd1, 0x01, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x55, 0x74, 0x69, 0x6c,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x22, 0x4f, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x42, 0x12, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f,
	0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xaf, 0x02, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72,
	0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb7, 0x01,
	0xca, 0x41, 0x26, 0x0a, 0x11, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x2f, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x2c, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x56, 0x3a, 0x12, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0xf3, 0x01, 0x0a, 0x17, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70,
	0x6f, 0x72, 0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x55, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x7c, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x2a, 0x40, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xec, 0x01,
	0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x61, 0x74, 0x61, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x53, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74,
	0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x12, 0xd9, 0x01, 0x0a,
	0x16, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e,
	0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x22, 0x51, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xbd, 0x02, 0x0a, 0x19, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xc1, 0x01, 0xca, 0x41, 0x28, 0x0a, 0x13, 0x44, 0x61, 0x74, 0x61,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x33, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x2c, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5a, 0x3a, 0x14,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x22, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x12, 0xf9, 0x01, 0x0a, 0x19, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e,
	0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x61, 0x74, 0x61, 0x63,
	0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7e, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44,
	0x2a, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x88, 0x02, 0x0a, 0x10, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65,
	0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41,
	0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9e,
	0x01, 0xca, 0x41, 0x2d, 0x0a, 0x18, 0x55, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x70, 0x70,
	0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x68, 0x3a, 0x01, 0x2a, 0x22, 0x63, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x75,
	0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x12,
	0x85, 0x02, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x6d, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01, 0xca, 0x41,
	0x20, 0x0a, 0x0b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x2c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x5f, 0x76, 0x6d, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x3a, 0x0c, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x22, 0x3a, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x12, 0xcc, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x12, 0x34, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4b, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x12, 0xb9, 0x01, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x4d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x22, 0x49, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3c, 0x12, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0x87, 0x02, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9b,
	0x01, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56,
	0x6d, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x18, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x76, 0x6d, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x57, 0x3a, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x5f, 0x76, 0x6d, 0x32, 0x47, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xe1, 0x01, 0x0a,
	0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x56, 0x6d, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x56, 0x6d, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x76, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x3c, 0x2a, 0x3a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a,
	0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xff, 0x01, 0x0a, 0x0e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01, 0xca, 0x41, 0x2b, 0x0a, 0x16, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0c, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x3a, 0x01, 0x2a, 0x22,
	0x51, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f,
	0x76, 0x6d, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0xf4, 0x01, 0x0a, 0x0f, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8c, 0x01, 0xca, 0x41, 0x2c,
	0x0a, 0x17, 0x52, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x57, 0x3a, 0x01, 0x2a, 0x22, 0x52, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xf0, 0x01, 0x0a, 0x0e, 0x50, 0x61,
	0x75, 0x73, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x32, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x61, 0x75, 0x73, 0x65,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x8a, 0x01, 0xca, 0x41, 0x2b, 0x0a, 0x16, 0x50, 0x61, 0x75, 0x73, 0x65, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x56, 0x3a, 0x01, 0x2a, 0x22, 0x51, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x61,
	0x75, 0x73, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x8b, 0x02, 0x0a,
	0x11, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9f, 0x01, 0xca, 0x41, 0x2e, 0x0a, 0x19,
	0x46, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x0c, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x59, 0x3a, 0x01, 0x2a, 0x22, 0x54, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x7a,
	0x65, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xf4, 0x01, 0x0a, 0x0f, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x64, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x33,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x64, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x8c, 0x01, 0xca, 0x41, 0x2c, 0x0a, 0x17, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x64,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x57, 0x3a, 0x01, 0x2a, 0x22, 0x52, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x6d,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0xff, 0x01, 0x0a, 0x0e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x6e,
	0x65, 0x4a, 0x6f, 0x62, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f,
	0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01, 0xca, 0x41, 0x1d, 0x0a, 0x08, 0x43,
	0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1d, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x2c, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x2c, 0x63, 0x6c,
	0x6f, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x53,
	0x3a, 0x09, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x5f, 0x6a, 0x6f, 0x62, 0x22, 0x46, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x4a,
	0x6f, 0x62, 0x73, 0x12, 0xf3, 0x01, 0x0a, 0x0e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x43, 0x6c,
	0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x43, 0x6c, 0x6f, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8d, 0x01, 0xca, 0x41, 0x2b, 0x0a,
	0x16, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x52, 0x3a, 0x01, 0x2a, 0x22, 0x4d, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x12, 0xcf, 0x01, 0x0a, 0x0d, 0x4c, 0x69,
	0x73, 0x74, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43, 0x6c,
	0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x57, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f,
	0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x63, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0xbc, 0x01, 0x0a, 0x0b,
	0x47, 0x65, 0x74, 0x43, 0x6c, 0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x12, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x6c, 0x6f,
	0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x6e, 0x65,
	0x4a, 0x6f, 0x62, 0x22, 0x55, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x48, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6c,
	0x6f, 0x6e, 0x65, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8d, 0x02, 0x0a, 0x10, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa3, 0x01, 0xca, 0x41, 0x1f, 0x0a, 0x0a, 0x43, 0x75, 0x74, 0x6f,
	0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x2c, 0x63,
	0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x57, 0x3a, 0x0b, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x6a, 0x6f, 0x62,
	0x22, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63,
	0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0xfb, 0x01, 0x0a, 0x10, 0x43,
	0x61, 0x6e, 0x63, 0x65, 0x6c, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x12,
	0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c,
	0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x22, 0x91, 0x01, 0xca, 0x41, 0x2d, 0x0a, 0x18, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x54, 0x3a, 0x01, 0x2a, 0x22, 0x4f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x12, 0xd7, 0x01, 0x0a, 0x0f, 0x4c, 0x69, 0x73,
	0x74, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x43,
	0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x59, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x12, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f,
	0x62, 0x73, 0x12, 0xc4, 0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65,
	0x72, 0x4a, 0x6f, 0x62, 0x12, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x75, 0x74, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x6f, 0x62,
	0x22, 0x57, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x12,
	0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x75, 0x74, 0x6f, 0x76,
	0x65, 0x72, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xaa, 0x01, 0x0a, 0x0a, 0x4c, 0x69,
	0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x3b, 0xda, 0x41, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x12, 0x97, 0x01, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x47, 0x72,
	0x6f, 0x75, 0x70, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x39, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x2c, 0x12, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d,
	0x12, 0xcd, 0x01, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x6e, 0xca, 0x41, 0x1a, 0x0a, 0x05, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x15, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x3a, 0x05, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x22, 0x2a, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73,
	0x12, 0xcf, 0x01, 0x0a, 0x0b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0x70, 0xca, 0x41, 0x1a, 0x0a, 0x05, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x11, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda,
	0x41, 0x11, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x39, 0x3a, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x32, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x2e, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f,
	0x2a, 0x7d, 0x12, 0xc5, 0x01, 0x0a, 0x0b, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x12, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0x66, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2c, 0x2a, 0x2a,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xed, 0x01, 0x0a, 0x11, 0x41,
	0x64, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x64, 0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x81, 0x01, 0xca, 0x41, 0x2e, 0x0a, 0x19, 0x41, 0x64,
	0x64, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x05, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67,
	0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x64, 0x64, 0x47, 0x72, 0x6f, 0x75,
	0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xf9, 0x01, 0x0a, 0x14, 0x52,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x12, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01, 0xca,
	0x41, 0x31, 0x0a, 0x1c, 0x52, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x05, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x45, 0x3a, 0x01, 0x2a, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xca, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x43,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12,
	0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x12, 0xb7, 0x01, 0x0a, 0x10, 0x47, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d,
	0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x72,
	0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x41, 0xda, 0x41, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x34, 0x12, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x89, 0x02,
	0x0a, 0x13, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74,
	0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x99, 0x01,
	0xca, 0x41, 0x22, 0x0a, 0x0d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x27, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x74,
	0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x2c, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x22, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x12, 0x8b, 0x02, 0x0a, 0x13, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x9b, 0x01, 0xca, 0x41, 0x22, 0x0a,
	0x0d, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x1a, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x53, 0x3a, 0x0e, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x5f, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x32, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x74, 0x61, 0x72, 0x67, 0x65,
	0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdd, 0x01, 0x0a, 0x13, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6e, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d,
	0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x34, 0x2a, 0x32, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x50, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xef, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74,
	0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65,
	0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x79, 0x63, 0x6c, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x52,
	0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x5f, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x12, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e,
	0x67, 0x56, 0x6d, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x73, 0x12, 0xdc, 0x01, 0x0a, 0x13, 0x47, 0x65,
	0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c,
	0x65, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79,
	0x63, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x79, 0x63, 0x6c, 0x65, 0x22, 0x5d, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x50, 0x12, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x56, 0x6d,
	0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x79, 0x63, 0x6c, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xc2, 0x01, 0x0a, 0x10, 0x4c, 0x69, 0x73,
	0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0x34, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x41, 0xda, 0x41, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0xaf, 0x01,
	0x0a, 0x0e, 0x47, 0x65, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74,
	0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x65, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x3f,
	0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x32, 0x12, 0x30, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xfb, 0x01, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49,
	0x6d, 0x70, 0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8f, 0x01, 0xca, 0x41,
	0x20, 0x0a, 0x0b, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x11,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0xda, 0x41, 0x23, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x69, 0x6d, 0x61, 0x67, 0x65,
	0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x2c, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x40, 0x3a, 0x0c, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x5f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x30, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x12, 0xd7, 0x01,
	0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x12, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x6c, 0xca, 0x41, 0x2a, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x32, 0x2a, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xdd, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x12,
	0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x73, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x49, 0x6d, 0x61, 0x67, 0x65,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x53, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x44, 0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0xca, 0x01, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f,
	0x62, 0x22, 0x51, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44,
	0x12, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x81, 0x02, 0x0a, 0x14, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x49,
	0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x12, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x8f, 0x01, 0xca, 0x41, 0x31, 0x0a, 0x1c, 0x43, 0x61,
	0x6e, 0x63, 0x65, 0x6c, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a,
	0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4e, 0x3a, 0x01, 0x2a, 0x22, 0x49, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x69, 0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x69,
	0x6d, 0x61, 0x67, 0x65, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x12, 0xab, 0x02, 0x0a, 0x16, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb5,
	0x01, 0xca, 0x41, 0x25, 0x0a, 0x10, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x2f, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x2c, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x2c, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x55, 0x3a, 0x12, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0xe0, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x44,
	0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73,
	0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x69,
	0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x50, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x12, 0xcd, 0x01, 0x0a, 0x13, 0x47, 0x65,
	0x74, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f,
	0x62, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x74, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x22, 0x4e, 0xda, 0x41, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x12, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xad, 0x02, 0x0a, 0x16, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0xb7, 0x01, 0xca, 0x41, 0x25, 0x0a, 0x10, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1e, 0x64, 0x69, 0x73,
	0x6b, 0x5f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x2c,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x68, 0x3a, 0x12, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x32, 0x52, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x64, 0x69, 0x73, 0x6b,
	0x5f, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x6e,
	0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf0, 0x01, 0x0a, 0x16, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75,
	0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22,
	0x7b, 0xca, 0x41, 0x2a, 0x0a, 0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x41, 0x2a, 0x3f, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xf8, 0x01, 0x0a,
	0x13, 0x52, 0x75, 0x6e, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x4a, 0x6f, 0x62, 0x12, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x88, 0x01, 0xca,
	0x41, 0x30, 0x0a, 0x1b, 0x52, 0x75, 0x6e, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x48, 0x3a,
	0x01, 0x2a, 0x22, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x75, 0x6e, 0x12, 0xfd, 0x01, 0x0a, 0x16, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a,
	0x6f, 0x62, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x87, 0x01,
	0xca, 0x41, 0x33, 0x0a, 0x1e, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x6b, 0x4d,
	0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4b, 0x3a, 0x01, 0x2a, 0x22,
	0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x69, 0x73, 0x6b,
	0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x1a, 0x4e, 0xca, 0x41, 0x1a, 0x76, 0x6d, 0x6d, 0x69,
	0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
	0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0xf7, 0x03, 0xea, 0x41, 0x78, 0x0a, 0x21, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x6b, 0x6d, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79,
	0x12, 0x53, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6b, 0x65, 0x79, 0x52, 0x69, 0x6e,
	0x67, 0x73, 0x2f, 0x7b, 0x6b, 0x65, 0x79, 0x5f, 0x72, 0x69, 0x6e, 0x67, 0x7d, 0x2f, 0x63, 0x72,
	0x79, 0x70, 0x74, 0x6f, 0x4b, 0x65, 0x79, 0x73, 0x2f, 0x7b, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f,
	0x5f, 0x6b, 0x65, 0x79, 0x7d, 0xea, 0x41, 0x59, 0x0a, 0x21, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x2f,
	0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x7d, 0xea, 0x41, 0x48, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x49, 0x6d, 0x61,
	0x67, 0x65, 0x12, 0x28, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x2f, 0x69, 0x6d,
	0x61, 0x67, 0x65, 0x73, 0x2f, 0x7b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x7d, 0x0a, 0x1f, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x56,
	0x6d, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x41, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x70, 0x62, 0x3b, 0x76, 0x6d, 0x6d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x70, 0x62, 0xaa, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x56, 0x4d, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x56, 0x31, 0xca, 0x02, 0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x56, 0x4d, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x56, 0x4d, 0x4d, 0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x3a, 0x56,
	0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescOnce sync.Once
	file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescData = file_google_cloud_vmmigration_v1_vmmigration_proto_rawDesc
)

func file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescGZIP() []byte {
	file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescOnce.Do(func() {
		file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescData)
	})
	return file_google_cloud_vmmigration_v1_vmmigration_proto_rawDescData
}

var file_google_cloud_vmmigration_v1_vmmigration_proto_enumTypes = make([]protoimpl.EnumInfo, 44)
var file_google_cloud_vmmigration_v1_vmmigration_proto_msgTypes = make([]protoimpl.MessageInfo, 201)
var file_google_cloud_vmmigration_v1_vmmigration_proto_goTypes = []any{
	(ComputeEngineDiskType)(0),                         // 0: google.cloud.vmmigration.v1.ComputeEngineDiskType
	(ComputeEngineLicenseType)(0),                      // 1: google.cloud.vmmigration.v1.ComputeEngineLicenseType
	(ComputeEngineBootOption)(0),                       // 2: google.cloud.vmmigration.v1.ComputeEngineBootOption
	(OsCapability)(0),                                  // 3: google.cloud.vmmigration.v1.OsCapability
	(BootConversion)(0),                                // 4: google.cloud.vmmigration.v1.BootConversion
	(UtilizationReportView)(0),                         // 5: google.cloud.vmmigration.v1.UtilizationReportView
	(MigratingVmView)(0),                               // 6: google.cloud.vmmigration.v1.MigratingVmView
	(VmArchitecture)(0),                                // 7: google.cloud.vmmigration.v1.VmArchitecture
	(ComputeEngineNetworkTier)(0),                      // 8: google.cloud.vmmigration.v1.ComputeEngineNetworkTier
	(ReplicationCycle_State)(0),                        // 9: google.cloud.vmmigration.v1.ReplicationCycle.State
	(MigratingVm_State)(0),                             // 10: google.cloud.vmmigration.v1.MigratingVm.State
	(CloneJob_State)(0),                                // 11: google.cloud.vmmigration.v1.CloneJob.State
	(CutoverJob_State)(0),                              // 12: google.cloud.vmmigration.v1.CutoverJob.State
	(AwsSourceDetails_State)(0),                        // 13: google.cloud.vmmigration.v1.AwsSourceDetails.State
	(AzureSourceDetails_State)(0),                      // 14: google.cloud.vmmigration.v1.AzureSourceDetails.State
	(DatacenterConnector_State)(0),                     // 15: google.cloud.vmmigration.v1.DatacenterConnector.State
	(UpgradeStatus_State)(0),                           // 16: google.cloud.vmmigration.v1.UpgradeStatus.State
	(VmwareVmDetails_PowerState)(0),                    // 17: google.cloud.vmmigration.v1.VmwareVmDetails.PowerState
	(VmwareVmDetails_BootOption)(0),                    // 18: google.cloud.vmmigration.v1.VmwareVmDetails.BootOption
	(VmwareVmDetails_VmArchitecture)(0),                // 19: google.cloud.vmmigration.v1.VmwareVmDetails.VmArchitecture
	(AwsVmDetails_PowerState)(0),                       // 20: google.cloud.vmmigration.v1.AwsVmDetails.PowerState
	(AwsVmDetails_BootOption)(0),                       // 21: google.cloud.vmmigration.v1.AwsVmDetails.BootOption
	(AwsVmDetails_VmVirtualizationType)(0),             // 22: google.cloud.vmmigration.v1.AwsVmDetails.VmVirtualizationType
	(AwsVmDetails_VmArchitecture)(0),                   // 23: google.cloud.vmmigration.v1.AwsVmDetails.VmArchitecture
	(AzureVmDetails_PowerState)(0),                     // 24: google.cloud.vmmigration.v1.AzureVmDetails.PowerState
	(AzureVmDetails_BootOption)(0),                     // 25: google.cloud.vmmigration.v1.AzureVmDetails.BootOption
	(AzureVmDetails_VmArchitecture)(0),                 // 26: google.cloud.vmmigration.v1.AzureVmDetails.VmArchitecture
	(FetchStorageInventoryRequest_StorageType)(0),      // 27: google.cloud.vmmigration.v1.FetchStorageInventoryRequest.StorageType
	(UtilizationReport_State)(0),                       // 28: google.cloud.vmmigration.v1.UtilizationReport.State
	(UtilizationReport_TimeFrame)(0),                   // 29: google.cloud.vmmigration.v1.UtilizationReport.TimeFrame
	(AppliedLicense_Type)(0),                           // 30: google.cloud.vmmigration.v1.AppliedLicense.Type
	(SchedulingNodeAffinity_Operator)(0),               // 31: google.cloud.vmmigration.v1.SchedulingNodeAffinity.Operator
	(ComputeScheduling_OnHostMaintenance)(0),           // 32: google.cloud.vmmigration.v1.ComputeScheduling.OnHostMaintenance
	(ComputeScheduling_RestartType)(0),                 // 33: google.cloud.vmmigration.v1.ComputeScheduling.RestartType
	(Group_MigrationTargetType)(0),                     // 34: google.cloud.vmmigration.v1.Group.MigrationTargetType
	(MigrationError_ErrorCode)(0),                      // 35: google.cloud.vmmigration.v1.MigrationError.ErrorCode
	(MigrationWarning_WarningCode)(0),                  // 36: google.cloud.vmmigration.v1.MigrationWarning.WarningCode
	(VmwareSourceVmDetails_Firmware)(0),                // 37: google.cloud.vmmigration.v1.VmwareSourceVmDetails.Firmware
	(AwsSourceVmDetails_Firmware)(0),                   // 38: google.cloud.vmmigration.v1.AwsSourceVmDetails.Firmware
	(AzureSourceVmDetails_Firmware)(0),                 // 39: google.cloud.vmmigration.v1.AzureSourceVmDetails.Firmware
	(ImageImportJob_State)(0),                          // 40: google.cloud.vmmigration.v1.ImageImportJob.State
	(ShieldedInstanceConfig_SecureBoot)(0),             // 41: google.cloud.vmmigration.v1.ShieldedInstanceConfig.SecureBoot
	(DiskMigrationJob_State)(0),                        // 42: google.cloud.vmmigration.v1.DiskMigrationJob.State
	(AwsSourceDiskDetails_Type)(0),                     // 43: google.cloud.vmmigration.v1.AwsSourceDiskDetails.Type
	(*ReplicationCycle)(nil),                           // 44: google.cloud.vmmigration.v1.ReplicationCycle
	(*CycleStep)(nil),                                  // 45: google.cloud.vmmigration.v1.CycleStep
	(*InitializingReplicationStep)(nil),                // 46: google.cloud.vmmigration.v1.InitializingReplicationStep
	(*ReplicatingStep)(nil),                            // 47: google.cloud.vmmigration.v1.ReplicatingStep
	(*PostProcessingStep)(nil),                         // 48: google.cloud.vmmigration.v1.PostProcessingStep
	(*ReplicationSync)(nil),                            // 49: google.cloud.vmmigration.v1.ReplicationSync
	(*MigratingVm)(nil),                                // 50: google.cloud.vmmigration.v1.MigratingVm
	(*CutoverForecast)(nil),                            // 51: google.cloud.vmmigration.v1.CutoverForecast
	(*CloneJob)(nil),                                   // 52: google.cloud.vmmigration.v1.CloneJob
	(*CloneStep)(nil),                                  // 53: google.cloud.vmmigration.v1.CloneStep
	(*AdaptingOSStep)(nil),                             // 54: google.cloud.vmmigration.v1.AdaptingOSStep
	(*PreparingVMDisksStep)(nil),                       // 55: google.cloud.vmmigration.v1.PreparingVMDisksStep
	(*InstantiatingMigratedVMStep)(nil),                // 56: google.cloud.vmmigration.v1.InstantiatingMigratedVMStep
	(*CutoverJob)(nil),                                 // 57: google.cloud.vmmigration.v1.CutoverJob
	(*CutoverStep)(nil),                                // 58: google.cloud.vmmigration.v1.CutoverStep
	(*ShuttingDownSourceVMStep)(nil),                   // 59: google.cloud.vmmigration.v1.ShuttingDownSourceVMStep
	(*CreateCloneJobRequest)(nil),                      // 60: google.cloud.vmmigration.v1.CreateCloneJobRequest
	(*CancelCloneJobRequest)(nil),                      // 61: google.cloud.vmmigration.v1.CancelCloneJobRequest
	(*CancelCloneJobResponse)(nil),                     // 62: google.cloud.vmmigration.v1.CancelCloneJobResponse
	(*ListCloneJobsRequest)(nil),                       // 63: google.cloud.vmmigration.v1.ListCloneJobsRequest
	(*ListCloneJobsResponse)(nil),                      // 64: google.cloud.vmmigration.v1.ListCloneJobsResponse
	(*GetCloneJobRequest)(nil),                         // 65: google.cloud.vmmigration.v1.GetCloneJobRequest
	(*Source)(nil),                                     // 66: google.cloud.vmmigration.v1.Source
	(*Encryption)(nil),                                 // 67: google.cloud.vmmigration.v1.Encryption
	(*VmwareSourceDetails)(nil),                        // 68: google.cloud.vmmigration.v1.VmwareSourceDetails
	(*AwsSourceDetails)(nil),                           // 69: google.cloud.vmmigration.v1.AwsSourceDetails
	(*AzureSourceDetails)(nil),                         // 70: google.cloud.vmmigration.v1.AzureSourceDetails
	(*DatacenterConnector)(nil),                        // 71: google.cloud.vmmigration.v1.DatacenterConnector
	(*UpgradeStatus)(nil),                              // 72: google.cloud.vmmigration.v1.UpgradeStatus
	(*AvailableUpdates)(nil),                           // 73: google.cloud.vmmigration.v1.AvailableUpdates
	(*ApplianceVersion)(nil),                           // 74: google.cloud.vmmigration.v1.ApplianceVersion
	(*ListSourcesRequest)(nil),                         // 75: google.cloud.vmmigration.v1.ListSourcesRequest
	(*ListSourcesResponse)(nil),                        // 76: google.cloud.vmmigration.v1.ListSourcesResponse
	(*GetSourceRequest)(nil),                           // 77: google.cloud.vmmigration.v1.GetSourceRequest
	(*CreateSourceRequest)(nil),                        // 78: google.cloud.vmmigration.v1.CreateSourceRequest
	(*UpdateSourceRequest)(nil),                        // 79: google.cloud.vmmigration.v1.UpdateSourceRequest
	(*DeleteSourceRequest)(nil),                        // 80: google.cloud.vmmigration.v1.DeleteSourceRequest
	(*FetchInventoryRequest)(nil),                      // 81: google.cloud.vmmigration.v1.FetchInventoryRequest
	(*VmwareVmDetails)(nil),                            // 82: google.cloud.vmmigration.v1.VmwareVmDetails
	(*AwsVmDetails)(nil),                               // 83: google.cloud.vmmigration.v1.AwsVmDetails
	(*AwsSecurityGroup)(nil),                           // 84: google.cloud.vmmigration.v1.AwsSecurityGroup
	(*AzureVmDetails)(nil),                             // 85: google.cloud.vmmigration.v1.AzureVmDetails
	(*VmwareVmsDetails)(nil),                           // 86: google.cloud.vmmigration.v1.VmwareVmsDetails
	(*AwsVmsDetails)(nil),                              // 87: google.cloud.vmmigration.v1.AwsVmsDetails
	(*AzureVmsDetails)(nil),                            // 88: google.cloud.vmmigration.v1.AzureVmsDetails
	(*FetchInventoryResponse)(nil),                     // 89: google.cloud.vmmigration.v1.FetchInventoryResponse
	(*FetchStorageInventoryRequest)(nil),               // 90: google.cloud.vmmigration.v1.FetchStorageInventoryRequest
	(*FetchStorageInventoryResponse)(nil),              // 91: google.cloud.vmmigration.v1.FetchStorageInventoryResponse
	(*SourceStorageResource)(nil),                      // 92: google.cloud.vmmigration.v1.SourceStorageResource
	(*UtilizationReport)(nil),                          // 93: google.cloud.vmmigration.v1.UtilizationReport
	(*VmUtilizationInfo)(nil),                          // 94: google.cloud.vmmigration.v1.VmUtilizationInfo
	(*VmUtilizationMetrics)(nil),                       // 95: google.cloud.vmmigration.v1.VmUtilizationMetrics
	(*ListUtilizationReportsRequest)(nil),              // 96: google.cloud.vmmigration.v1.ListUtilizationReportsRequest
	(*ListUtilizationReportsResponse)(nil),             // 97: google.cloud.vmmigration.v1.ListUtilizationReportsResponse
	(*GetUtilizationReportRequest)(nil),                // 98: google.cloud.vmmigration.v1.GetUtilizationReportRequest
	(*CreateUtilizationReportRequest)(nil),             // 99: google.cloud.vmmigration.v1.CreateUtilizationReportRequest
	(*DeleteUtilizationReportRequest)(nil),             // 100: google.cloud.vmmigration.v1.DeleteUtilizationReportRequest
	(*ListDatacenterConnectorsResponse)(nil),           // 101: google.cloud.vmmigration.v1.ListDatacenterConnectorsResponse
	(*GetDatacenterConnectorRequest)(nil),              // 102: google.cloud.vmmigration.v1.GetDatacenterConnectorRequest
	(*CreateDatacenterConnectorRequest)(nil),           // 103: google.cloud.vmmigration.v1.CreateDatacenterConnectorRequest
	(*DeleteDatacenterConnectorRequest)(nil),           // 104: google.cloud.vmmigration.v1.DeleteDatacenterConnectorRequest
	(*UpgradeApplianceRequest)(nil),                    // 105: google.cloud.vmmigration.v1.UpgradeApplianceRequest
	(*UpgradeApplianceResponse)(nil),                   // 106: google.cloud.vmmigration.v1.UpgradeApplianceResponse
	(*ListDatacenterConnectorsRequest)(nil),            // 107: google.cloud.vmmigration.v1.ListDatacenterConnectorsRequest
	(*ComputeEngineTargetDefaults)(nil),                // 108: google.cloud.vmmigration.v1.ComputeEngineTargetDefaults
	(*ComputeEngineTargetDetails)(nil),                 // 109: google.cloud.vmmigration.v1.ComputeEngineTargetDetails
	(*NetworkInterface)(nil),                           // 110: google.cloud.vmmigration.v1.NetworkInterface
	(*AppliedLicense)(nil),                             // 111: google.cloud.vmmigration.v1.AppliedLicense
	(*SchedulingNodeAffinity)(nil),                     // 112: google.cloud.vmmigration.v1.SchedulingNodeAffinity
	(*ComputeScheduling)(nil),                          // 113: google.cloud.vmmigration.v1.ComputeScheduling
	(*ComputeEngineDisksTargetDefaults)(nil),           // 114: google.cloud.vmmigration.v1.ComputeEngineDisksTargetDefaults
	(*PersistentDiskDefaults)(nil),                     // 115: google.cloud.vmmigration.v1.PersistentDiskDefaults
	(*VmAttachmentDetails)(nil),                        // 116: google.cloud.vmmigration.v1.VmAttachmentDetails
	(*DisksMigrationDisksTargetDefaults)(nil),          // 117: google.cloud.vmmigration.v1.DisksMigrationDisksTargetDefaults
	(*DisksMigrationVmTargetDefaults)(nil),             // 118: google.cloud.vmmigration.v1.DisksMigrationVmTargetDefaults
	(*BootDiskDefaults)(nil),                           // 119: google.cloud.vmmigration.v1.BootDiskDefaults
	(*ComputeEngineDisksTargetDetails)(nil),            // 120: google.cloud.vmmigration.v1.ComputeEngineDisksTargetDetails
	(*PersistentDisk)(nil),                             // 121: google.cloud.vmmigration.v1.PersistentDisk
	(*DisksMigrationDisksTargetDetails)(nil),           // 122: google.cloud.vmmigration.v1.DisksMigrationDisksTargetDetails
	(*DisksMigrationVmTargetDetails)(nil),              // 123: google.cloud.vmmigration.v1.DisksMigrationVmTargetDetails
	(*SchedulePolicy)(nil),                             // 124: google.cloud.vmmigration.v1.SchedulePolicy
	(*CreateMigratingVmRequest)(nil),                   // 125: google.cloud.vmmigration.v1.CreateMigratingVmRequest
	(*ListMigratingVmsRequest)(nil),                    // 126: google.cloud.vmmigration.v1.ListMigratingVmsRequest
	(*ListMigratingVmsResponse)(nil),                   // 127: google.cloud.vmmigration.v1.ListMigratingVmsResponse
	(*GetMigratingVmRequest)(nil),                      // 128: google.cloud.vmmigration.v1.GetMigratingVmRequest
	(*UpdateMigratingVmRequest)(nil),                   // 129: google.cloud.vmmigration.v1.UpdateMigratingVmRequest
	(*DeleteMigratingVmRequest)(nil),                   // 130: google.cloud.vmmigration.v1.DeleteMigratingVmRequest
	(*StartMigrationRequest)(nil),                      // 131: google.cloud.vmmigration.v1.StartMigrationRequest
	(*StartMigrationResponse)(nil),                     // 132: google.cloud.vmmigration.v1.StartMigrationResponse
	(*PauseMigrationRequest)(nil),                      // 133: google.cloud.vmmigration.v1.PauseMigrationRequest
	(*PauseMigrationResponse)(nil),                     // 134: google.cloud.vmmigration.v1.PauseMigrationResponse
	(*ResumeMigrationRequest)(nil),                     // 135: google.cloud.vmmigration.v1.ResumeMigrationRequest
	(*ResumeMigrationResponse)(nil),                    // 136: google.cloud.vmmigration.v1.ResumeMigrationResponse
	(*FinalizeMigrationRequest)(nil),                   // 137: google.cloud.vmmigration.v1.FinalizeMigrationRequest
	(*ExtendMigrationRequest)(nil),                     // 138: google.cloud.vmmigration.v1.ExtendMigrationRequest
	(*ExtendMigrationResponse)(nil),                    // 139: google.cloud.vmmigration.v1.ExtendMigrationResponse
	(*FinalizeMigrationResponse)(nil),                  // 140: google.cloud.vmmigration.v1.FinalizeMigrationResponse
	(*TargetProject)(nil),                              // 141: google.cloud.vmmigration.v1.TargetProject
	(*GetTargetProjectRequest)(nil),                    // 142: google.cloud.vmmigration.v1.GetTargetProjectRequest
	(*ListTargetProjectsRequest)(nil),                  // 143: google.cloud.vmmigration.v1.ListTargetProjectsRequest
	(*ListTargetProjectsResponse)(nil),                 // 144: google.cloud.vmmigration.v1.ListTargetProjectsResponse
	(*CreateTargetProjectRequest)(nil),                 // 145: google.cloud.vmmigration.v1.CreateTargetProjectRequest
	(*UpdateTargetProjectRequest)(nil),                 // 146: google.cloud.vmmigration.v1.UpdateTargetProjectRequest
	(*DeleteTargetProjectRequest)(nil),                 // 147: google.cloud.vmmigration.v1.DeleteTargetProjectRequest
	(*Group)(nil),                                      // 148: google.cloud.vmmigration.v1.Group
	(*ListGroupsRequest)(nil),                          // 149: google.cloud.vmmigration.v1.ListGroupsRequest
	(*ListGroupsResponse)(nil),                         // 150: google.cloud.vmmigration.v1.ListGroupsResponse
	(*GetGroupRequest)(nil),                            // 151: google.cloud.vmmigration.v1.GetGroupRequest
	(*CreateGroupRequest)(nil),                         // 152: google.cloud.vmmigration.v1.CreateGroupRequest
	(*UpdateGroupRequest)(nil),                         // 153: google.cloud.vmmigration.v1.UpdateGroupRequest
	(*DeleteGroupRequest)(nil),                         // 154: google.cloud.vmmigration.v1.DeleteGroupRequest
	(*AddGroupMigrationRequest)(nil),                   // 155: google.cloud.vmmigration.v1.AddGroupMigrationRequest
	(*AddGroupMigrationResponse)(nil),                  // 156: google.cloud.vmmigration.v1.AddGroupMigrationResponse
	(*RemoveGroupMigrationRequest)(nil),                // 157: google.cloud.vmmigration.v1.RemoveGroupMigrationRequest
	(*RemoveGroupMigrationResponse)(nil),               // 158: google.cloud.vmmigration.v1.RemoveGroupMigrationResponse
	(*CreateCutoverJobRequest)(nil),                    // 159: google.cloud.vmmigration.v1.CreateCutoverJobRequest
	(*CancelCutoverJobRequest)(nil),                    // 160: google.cloud.vmmigration.v1.CancelCutoverJobRequest
	(*CancelCutoverJobResponse)(nil),                   // 161: google.cloud.vmmigration.v1.CancelCutoverJobResponse
	(*ListCutoverJobsRequest)(nil),                     // 162: google.cloud.vmmigration.v1.ListCutoverJobsRequest
	(*ListCutoverJobsResponse)(nil),                    // 163: google.cloud.vmmigration.v1.ListCutoverJobsResponse
	(*GetCutoverJobRequest)(nil),                       // 164: google.cloud.vmmigration.v1.GetCutoverJobRequest
	(*OperationMetadata)(nil),                          // 165: google.cloud.vmmigration.v1.OperationMetadata
	(*MigrationError)(nil),                             // 166: google.cloud.vmmigration.v1.MigrationError
	(*MigrationWarning)(nil),                           // 167: google.cloud.vmmigration.v1.MigrationWarning
	(*VmwareSourceVmDetails)(nil),                      // 168: google.cloud.vmmigration.v1.VmwareSourceVmDetails
	(*AwsSourceVmDetails)(nil),                         // 169: google.cloud.vmmigration.v1.AwsSourceVmDetails
	(*AzureSourceVmDetails)(nil),                       // 170: google.cloud.vmmigration.v1.AzureSourceVmDetails
	(*ListReplicationCyclesRequest)(nil),               // 171: google.cloud.vmmigration.v1.ListReplicationCyclesRequest
	(*ListReplicationCyclesResponse)(nil),              // 172: google.cloud.vmmigration.v1.ListReplicationCyclesResponse
	(*GetReplicationCycleRequest)(nil),                 // 173: google.cloud.vmmigration.v1.GetReplicationCycleRequest
	(*VmCapabilities)(nil),                             // 174: google.cloud.vmmigration.v1.VmCapabilities
	(*ImageImport)(nil),                                // 175: google.cloud.vmmigration.v1.ImageImport
	(*ImageImportJob)(nil),                             // 176: google.cloud.vmmigration.v1.ImageImportJob
	(*ImageImportStep)(nil),                            // 177: google.cloud.vmmigration.v1.ImageImportStep
	(*InitializingImageImportStep)(nil),                // 178: google.cloud.vmmigration.v1.InitializingImageImportStep
	(*LoadingImageSourceFilesStep)(nil),                // 179: google.cloud.vmmigration.v1.LoadingImageSourceFilesStep
	(*CreatingImageStep)(nil),                          // 180: google.cloud.vmmigration.v1.CreatingImageStep
	(*DiskImageTargetDetails)(nil),                     // 181: google.cloud.vmmigration.v1.DiskImageTargetDetails
	(*MachineImageTargetDetails)(nil),                  // 182: google.cloud.vmmigration.v1.MachineImageTargetDetails
	(*ServiceAccount)(nil),                             // 183: google.cloud.vmmigration.v1.ServiceAccount
	(*ShieldedInstanceConfig)(nil),                     // 184: google.cloud.vmmigration.v1.ShieldedInstanceConfig
	(*MachineImageParametersOverrides)(nil),            // 185: google.cloud.vmmigration.v1.MachineImageParametersOverrides
	(*ImageImportOsAdaptationParameters)(nil),          // 186: google.cloud.vmmigration.v1.ImageImportOsAdaptationParameters
	(*DataDiskImageImport)(nil),                        // 187: google.cloud.vmmigration.v1.DataDiskImageImport
	(*SkipOsAdaptation)(nil),                           // 188: google.cloud.vmmigration.v1.SkipOsAdaptation
	(*GetImageImportRequest)(nil),                      // 189: google.cloud.vmmigration.v1.GetImageImportRequest
	(*ListImageImportsRequest)(nil),                    // 190: google.cloud.vmmigration.v1.ListImageImportsRequest
	(*ListImageImportsResponse)(nil),                   // 191: google.cloud.vmmigration.v1.ListImageImportsResponse
	(*CreateImageImportRequest)(nil),                   // 192: google.cloud.vmmigration.v1.CreateImageImportRequest
	(*DeleteImageImportRequest)(nil),                   // 193: google.cloud.vmmigration.v1.DeleteImageImportRequest
	(*GetImageImportJobRequest)(nil),                   // 194: google.cloud.vmmigration.v1.GetImageImportJobRequest
	(*ListImageImportJobsRequest)(nil),                 // 195: google.cloud.vmmigration.v1.ListImageImportJobsRequest
	(*ListImageImportJobsResponse)(nil),                // 196: google.cloud.vmmigration.v1.ListImageImportJobsResponse
	(*CancelImageImportJobRequest)(nil),                // 197: google.cloud.vmmigration.v1.CancelImageImportJobRequest
	(*CancelImageImportJobResponse)(nil),               // 198: google.cloud.vmmigration.v1.CancelImageImportJobResponse
	(*DiskMigrationJob)(nil),                           // 199: google.cloud.vmmigration.v1.DiskMigrationJob
	(*DiskMigrationJobTargetDetails)(nil),              // 200: google.cloud.vmmigration.v1.DiskMigrationJobTargetDetails
	(*DiskMigrationStep)(nil),                          // 201: google.cloud.vmmigration.v1.DiskMigrationStep
	(*CreatingSourceDiskSnapshotStep)(nil),             // 202: google.cloud.vmmigration.v1.CreatingSourceDiskSnapshotStep
	(*CopyingSourceDiskSnapshotStep)(nil),              // 203: google.cloud.vmmigration.v1.CopyingSourceDiskSnapshotStep
	(*ProvisioningTargetDiskStep)(nil),                 // 204: google.cloud.vmmigration.v1.ProvisioningTargetDiskStep
	(*ComputeEngineDisk)(nil),                          // 205: google.cloud.vmmigration.v1.ComputeEngineDisk
	(*AwsSourceDiskDetails)(nil),                       // 206: google.cloud.vmmigration.v1.AwsSourceDiskDetails
	(*CreateDiskMigrationJobRequest)(nil),              // 207: google.cloud.vmmigration.v1.CreateDiskMigrationJobRequest
	(*ListDiskMigrationJobsRequest)(nil),               // 208: google.cloud.vmmigration.v1.ListDiskMigrationJobsRequest
	(*ListDiskMigrationJobsResponse)(nil),              // 209: google.cloud.vmmigration.v1.ListDiskMigrationJobsResponse
	(*GetDiskMigrationJobRequest)(nil),                 // 210: google.cloud.vmmigration.v1.GetDiskMigrationJobRequest
	(*UpdateDiskMigrationJobR