// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package bucket

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// BucketInfoOKCode is the HTTP code returned for type BucketInfoOK
const BucketInfoOKCode int = 200

/*
BucketInfoOK A successful response.

swagger:response bucketInfoOK
*/
type BucketInfoOK struct {

	/*
	  In: Body
	*/
	Payload *models.Bucket `json:"body,omitempty"`
}

// NewBucketInfoOK creates BucketInfoOK with default headers values
func NewBucketInfoOK() *BucketInfoOK {

	return &BucketInfoOK{}
}

// WithPayload adds the payload to the bucket info o k response
func (o *BucketInfoOK) WithPayload(payload *models.Bucket) *BucketInfoOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the bucket info o k response
func (o *BucketInfoOK) SetPayload(payload *models.Bucket) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *BucketInfoOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
BucketInfoDefault Generic error response.

swagger:response bucketInfoDefault
*/
type BucketInfoDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.APIError `json:"body,omitempty"`
}

// NewBucketInfoDefault creates BucketInfoDefault with default headers values
func NewBucketInfoDefault(code int) *BucketInfoDefault {
	if code <= 0 {
		code = 500
	}

	return &BucketInfoDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the bucket info default response
func (o *BucketInfoDefault) WithStatusCode(code int) *BucketInfoDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the bucket info default response
func (o *BucketInfoDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the bucket info default response
func (o *BucketInfoDefault) WithPayload(payload *models.APIError) *BucketInfoDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the bucket info default response
func (o *BucketInfoDefault) SetPayload(payload *models.APIError) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *BucketInfoDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
