/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.caret;

import java.awt.Graphics;
import java.awt.Point;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.caret.CaretInfo;
import org.netbeans.api.editor.caret.CaretTransaction;
import org.netbeans.api.editor.caret.EditorCaret;
import org.netbeans.api.editor.caret.MoveCaretsOrigin;
import org.netbeans.spi.editor.caret.NavigationFilterBypass;
import org.openide.util.Exceptions;

class FilterBypassImpl
extends NavigationFilterBypass {
    private final CaretTransaction transaction;
    private final CaretInfo item;
    private final Document doc;
    private Caret itemCaret;
    private boolean result;

    public FilterBypassImpl(CaretTransaction transaction, CaretInfo item, Document doc) {
        this.transaction = transaction;
        this.item = item;
        this.doc = doc;
    }

    @Override
    public CaretInfo getCaretItem() {
        return this.item;
    }

    @Override
    public EditorCaret getEditorCaret() {
        return this.transaction.getCaret();
    }

    @Override
    public Caret getCaret() {
        if (this.itemCaret == null) {
            this.itemCaret = new ItemCaret();
        }
        return this.itemCaret;
    }

    @Override
    public MoveCaretsOrigin getOrigin() {
        return this.transaction.getOrigin();
    }

    boolean getResult() {
        return this.result;
    }

    @Override
    public void setDot(int dot, Position.Bias dotBias) {
        Position dotPos = this.createPosition(dot);
        this.result = this.transaction.setDotAndMark(this.item.getCaretItem(), dotPos, dotBias, dotPos, dotBias);
    }

    private Position createPosition(final int dot) {
        final Position[] p = new Position[1];
        this.doc.render(new Runnable(){

            @Override
            public void run() {
                p[0] = FilterBypassImpl.this.createPosition0(dot);
            }
        });
        return p[0];
    }

    private Position createPosition0(int dot) {
        try {
            if (dot < 0) {
                return this.doc.createPosition(0);
            }
            if (dot > this.doc.getLength()) {
                return this.doc.createPosition(this.doc.getLength());
            }
            return this.doc.createPosition(dot);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return this.item.getDotPosition();
        }
    }

    @Override
    public void moveDot(int dot, Position.Bias dotBias) {
        this.result = this.transaction.setDotAndMark(this.item.getCaretItem(), this.createPosition(dot), dotBias, this.item.getMarkPosition(), this.item.getMarkBias());
    }

    private class ItemCaret
    implements Caret {
        private ItemCaret() {
        }

        private void notPermitted() {
            throw new UnsupportedOperationException("Disallowed in NavigationFilter");
        }

        @Override
        public void install(JTextComponent c) {
            this.notPermitted();
        }

        @Override
        public void deinstall(JTextComponent c) {
            this.notPermitted();
        }

        @Override
        public void paint(Graphics g) {
            this.notPermitted();
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            FilterBypassImpl.this.transaction.getCaret().addChangeListener(l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            FilterBypassImpl.this.transaction.getCaret().removeChangeListener(l);
        }

        @Override
        public boolean isVisible() {
            return FilterBypassImpl.this.transaction.getCaret().isVisible();
        }

        @Override
        public void setVisible(boolean v) {
            FilterBypassImpl.this.transaction.getCaret().setVisible(v);
        }

        @Override
        public boolean isSelectionVisible() {
            return FilterBypassImpl.this.transaction.getCaret().isSelectionVisible();
        }

        @Override
        public void setSelectionVisible(boolean v) {
            FilterBypassImpl.this.transaction.getCaret().setSelectionVisible(v);
        }

        @Override
        public void setMagicCaretPosition(Point p) {
            FilterBypassImpl.this.transaction.setMagicCaretPosition(FilterBypassImpl.this.item.getCaretItem(), p);
        }

        @Override
        public Point getMagicCaretPosition() {
            return FilterBypassImpl.this.item.getMagicCaretPosition();
        }

        @Override
        public void setBlinkRate(int rate) {
            FilterBypassImpl.this.transaction.getCaret().setBlinkRate(rate);
        }

        @Override
        public int getBlinkRate() {
            return FilterBypassImpl.this.transaction.getCaret().getBlinkRate();
        }

        @Override
        public int getDot() {
            return FilterBypassImpl.this.item.getDot();
        }

        @Override
        public int getMark() {
            return FilterBypassImpl.this.item.getMark();
        }

        @Override
        public void setDot(int dot) {
            FilterBypassImpl.this.setDot(dot, Position.Bias.Forward);
        }

        @Override
        public void moveDot(int dot) {
            FilterBypassImpl.this.moveDot(dot, Position.Bias.Forward);
        }
    }
}

