/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.j2seproject.api.J2SEProjectPlatform;
import org.netbeans.modules.java.j2seproject.api.J2SEPropertyEvaluator;
import org.netbeans.modules.javafx2.platform.api.JavaFXPlatformUtils;
import org.netbeans.modules.javafx2.project.Bundle;
import org.netbeans.modules.javafx2.project.ChooseOtherPlatformPanel;
import org.netbeans.modules.javafx2.project.JFXPlatformUpdater;
import org.netbeans.modules.javafx2.project.JFXProjectUtils;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class JFXProjectProblems
implements ProjectProblemsProvider,
PropertyChangeListener {
    private static final String PLATFORM_ACTIVE = "platform.active";
    private final ProjectProblemsProviderSupport problemsProviderSupport = new ProjectProblemsProviderSupport((Object)this);
    private static final Logger LOGGER = Logger.getLogger("javafx");
    private static final RequestProcessor RP = new RequestProcessor(JFXProjectProblems.class);
    private AtomicReference<RequestProcessor.Task> updateClassPathExtensionTask = new AtomicReference();
    private AtomicBoolean testedCorrectClassPathExtension = new AtomicBoolean(false);
    private AtomicBoolean updatedClassPathExtension = new AtomicBoolean(false);
    private final Project prj;
    private final J2SEPropertyEvaluator eval;
    private final J2SEProjectPlatform platformSetter;
    private JFXPlatformUpdater updater = null;

    public JFXProjectProblems(Lookup lkp) {
        Parameters.notNull((CharSequence)"lkp", (Object)lkp);
        this.prj = (Project)lkp.lookup(Project.class);
        Parameters.notNull((CharSequence)"prj", (Object)this.prj);
        this.eval = (J2SEPropertyEvaluator)lkp.lookup(J2SEPropertyEvaluator.class);
        Parameters.notNull((CharSequence)"eval", (Object)this.eval);
        this.platformSetter = (J2SEProjectPlatform)lkp.lookup(J2SEProjectPlatform.class);
        Parameters.notNull((CharSequence)"platformSetter", (Object)this.platformSetter);
        this.eval.evaluator().addPropertyChangeListener((PropertyChangeListener)this);
        this.platformSetter.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.problemsProviderSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.problemsProviderSupport.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        if (this.updater == null) {
            this.updater = (JFXPlatformUpdater)this.prj.getLookup().lookup(JFXPlatformUpdater.class);
            if (this.updater != null) {
                this.updater.addListener(this);
            }
        }
        if (this.updater != null) {
            if (!this.updater.hasUpdated()) {
                return Collections.emptySet();
            }
        } else {
            return Collections.emptySet();
        }
        if ((this.updater == null || this.updater.hasUpdated()) && !this.testedCorrectClassPathExtension.get()) {
            if (this.updateClassPathExtensionTask.get() == null || this.updateClassPathExtensionTask.get().isFinished()) {
                this.updateClassPathExtensionTask.set(RP.create(new Runnable(){

                    @Override
                    public void run() {
                        JFXProjectProblems.this.updatedClassPathExtension.set(false);
                        try {
                            if (!JFXProjectUtils.hasCorrectClassPathExtension(JFXProjectProblems.this.prj)) {
                                JFXProjectUtils.updateClassPathExtension(JFXProjectProblems.this.prj);
                                JFXProjectProblems.this.updatedClassPathExtension.set(true);
                            }
                            JFXProjectProblems.this.testedCorrectClassPathExtension.set(true);
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.WARNING, "Can't access project properties: {0}", ex);
                        }
                    }
                }));
                this.updateClassPathExtensionTask.get().addTaskListener(new TaskListener(){

                    public void taskFinished(Task task) {
                        if (JFXProjectProblems.this.updatedClassPathExtension.get()) {
                            JFXProjectProblems.this.problemsProviderSupport.fireProblemsChange();
                        }
                    }
                });
                this.updateClassPathExtensionTask.get().schedule(0);
            }
            return Collections.emptySet();
        }
        this.testedCorrectClassPathExtension.set(false);
        if (!JFXProjectProblems.isFXProject(this.eval)) {
            return Collections.emptySet();
        }
        return this.problemsProviderSupport.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){

            public Collection<? extends ProjectProblemsProvider.ProjectProblem> collectProblems() {
                Collection currentProblems = (Collection)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Collection<? extends ProjectProblemsProvider.ProjectProblem>>(){

                    public Collection<? extends ProjectProblemsProvider.ProjectProblem> run() {
                        JavaPlatform activePlatform = JFXProjectProblems.this.platformSetter.getProjectPlatform();
                        boolean hasFXProblem = activePlatform != null && !JavaFXPlatformUtils.isJavaFXEnabled((JavaPlatform)activePlatform);
                        return !hasFXProblem ? Collections.emptySet() : Collections.singleton(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.LBL_FX_Not_Supported_By_JDK(), (String)Bundle.HINT_FX_Not_Supported_By_JDK(), (ProjectProblemResolver)new NonFXPlatformResolver(JFXProjectProblems.this.prj, JFXProjectProblems.this.platformSetter, null, JavaPlatform.getDefault().getSpecification().getName())));
                    }
                });
                return currentProblems;
            }
        });
    }

    private static boolean isFXProject(@NonNull J2SEPropertyEvaluator eval) {
        if (eval == null) {
            return false;
        }
        return JFXProjectProblems.isTrue(eval.evaluator().getProperty("javafx.enabled"));
    }

    private static boolean isTrue(@NullAllowed String value) {
        return value != null && ("true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value) || "on".equalsIgnoreCase(value));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName == null || PLATFORM_ACTIVE.equals(propName)) {
            this.problemsProviderSupport.fireProblemsChange();
        }
    }

    private static final class Done
    implements Future<ProjectProblemsProvider.Result> {
        private final ProjectProblemsProvider.Result result;

        Done(@NonNull ProjectProblemsProvider.Result result) {
            Parameters.notNull((CharSequence)"result", (Object)result);
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public ProjectProblemsProvider.Result get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public ProjectProblemsProvider.Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }

    private static class NonFXPlatformResolver
    implements ProjectProblemResolver {
        private final Project project;
        private final String type;
        private final BrokenReferencesSupport.PlatformUpdatedCallBack hook;
        private final J2SEProjectPlatform platformSetter;

        NonFXPlatformResolver(@NonNull Project project, @NonNull J2SEProjectPlatform platformSetter, @NullAllowed BrokenReferencesSupport.PlatformUpdatedCallBack hook, @NonNull String type) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"type", (Object)type);
            Parameters.notNull((CharSequence)"platformSetter", (Object)platformSetter);
            this.project = project;
            this.platformSetter = platformSetter;
            this.hook = hook;
            this.type = type;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            final ChooseOtherPlatformPanel choosePlatform = new ChooseOtherPlatformPanel(this.type);
            DialogDescriptor dd = new DialogDescriptor((Object)choosePlatform, Bundle.LBL_ResolveFXJDK(ProjectUtils.getInformation((Project)this.project).getDisplayName()));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION) {
                Callable<ProjectProblemsProvider.Result> resultFnc = new Callable<ProjectProblemsProvider.Result>(){

                    @Override
                    public ProjectProblemsProvider.Result call() throws Exception {
                        final JavaPlatform jp = choosePlatform.getSelectedPlatform();
                        if (jp != null) {
                            try {
                                ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                                    public Void run() throws IOException {
                                        platformSetter.setProjectPlatform(jp);
                                        JFXProjectUtils.updateClassPathExtension(project);
                                        return null;
                                    }
                                });
                            }
                            catch (MutexException e) {
                                throw (IOException)e.getCause();
                            }
                            LOGGER.info("Set platform.active to platform " + jp);
                            return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
                        }
                        return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED);
                    }
                };
                FutureTask<ProjectProblemsProvider.Result> result = new FutureTask<ProjectProblemsProvider.Result>(resultFnc);
                RP.post(result);
                return result;
            }
            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED));
        }

        public boolean equals(Object other) {
            return other instanceof NonFXPlatformResolver;
        }

        public int hashCode() {
            return 29;
        }
    }
}

