/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.modules.java.project.ui.Bundle;
import org.netbeans.modules.java.project.ui.ProfileProblemsProviderImpl;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class FixProfile
extends JPanel {
    private final JButton okOption;
    private final LibsModel libsModel;
    private SourceLevelQuery.Profile reqProfile;
    private JList brokenLibs;
    private JCheckBox changeProfile;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JComboBox profiles;
    private JButton remove;

    FixProfile(@NonNull JButton okOption, @NonNull SourceLevelQuery.Profile currentProfile, @NonNull Collection<? extends ProfileProblemsProviderImpl.Reference> state) {
        assert (okOption != null);
        assert (currentProfile != null);
        assert (state != null);
        this.okOption = okOption;
        this.libsModel = new LibsModel(currentProfile, state);
        this.libsModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent lde) {
                FixProfile.this.checkOkOption();
            }

            @Override
            public void intervalRemoved(ListDataEvent lde) {
                FixProfile.this.checkOkOption();
            }

            @Override
            public void contentsChanged(ListDataEvent lde) {
                FixProfile.this.checkOkOption();
            }
        });
        this.reqProfile = ProfileProblemsProviderImpl.requiredProfile(state, currentProfile);
        this.initComponents();
        this.remove.setEnabled(false);
        this.brokenLibs.setModel(this.libsModel);
        this.brokenLibs.setCellRenderer(new LibsRenderer(this.brokenLibs));
        this.brokenLibs.setSelectionMode(2);
        this.brokenLibs.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                FixProfile.this.remove.setEnabled(FixProfile.this.brokenLibs.getSelectedIndex() != -1);
            }
        });
        this.brokenLibs.setSelectedIndex(0);
        this.profiles.setRenderer(new ProfilesRenderer());
        this.changeProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FixProfile.this.libsModel.updateProfile(FixProfile.this.changeProfile.isSelected());
                FixProfile.this.checkOkOption();
            }
        });
        this.updateProfiles();
        this.checkOkOption();
    }

    boolean shouldUpdateProfile() {
        return this.changeProfile.isSelected();
    }

    @CheckForNull
    SourceLevelQuery.Profile getProfile() {
        Object selObj = this.profiles.getSelectedItem();
        if (selObj instanceof SourceLevelQuery.Profile) {
            return (SourceLevelQuery.Profile)selObj;
        }
        return null;
    }

    @NonNull
    Collection<? extends ProfileProblemsProviderImpl.Reference> getRootsToRemove() {
        return this.libsModel.getRemovedRooots();
    }

    private void updateProfiles() {
        this.profiles.removeAllItems();
        for (SourceLevelQuery.Profile profile : SourceLevelQuery.Profile.values()) {
            if (profile.compareTo((Enum)this.reqProfile) < 0) continue;
            this.profiles.addItem(profile);
        }
        this.profiles.setSelectedItem(this.reqProfile);
    }

    private void checkOkOption() {
        this.okOption.setEnabled(this.libsModel.getSize() == 0);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.remove = new JButton();
        this.changeProfile = new JCheckBox();
        this.profiles = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.brokenLibs = new JList();
        this.jLabel1.setLabelFor(this.brokenLibs);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(FixProfile.class, (String)"LBL_FixProfile_BrokenLibs"));
        Mnemonics.setLocalizedText((AbstractButton)this.remove, (String)NbBundle.getMessage(FixProfile.class, (String)"LBL_FixProfile_remove"));
        this.remove.setToolTipText(NbBundle.getMessage(FixProfile.class, (String)"TIP_FixProfile_Remove"));
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FixProfile.this.removeLibrary(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.changeProfile, (String)NbBundle.getMessage(FixProfile.class, (String)"LBL_FixProfile_changeProfile"));
        this.jScrollPane1.setViewportView(this.brokenLibs);
        this.brokenLibs.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FixProfile.class, (String)"AD_FixProfile_BrokenLibs"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 202, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.changeProfile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.profiles, 0, -1, Short.MAX_VALUE)).addComponent(this.jScrollPane1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.remove))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.remove).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -1, 212, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.changeProfile).addComponent(this.profiles, -2, -1, -2)).addContainerGap()));
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FixProfile.class, (String)"FixProfile.jLabel1.AccessibleContext.accessibleName"));
        this.changeProfile.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FixProfile.class, (String)"AD_FixProfile_changeProfile"));
        this.profiles.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FixProfile.class, (String)"AN_FixProfile_Profiles"));
        this.profiles.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FixProfile.class, (String)"AD_FixProfile_Profiles"));
    }

    private void removeLibrary(ActionEvent evt) {
        Object[] selection = this.brokenLibs.getSelectedValues();
        HashSet<ProfileProblemsProviderImpl.Reference> rootsToRemove = new HashSet<ProfileProblemsProviderImpl.Reference>();
        for (Object e : selection) {
            rootsToRemove.add((ProfileProblemsProviderImpl.Reference)e);
        }
        this.libsModel.removeRoots(rootsToRemove);
        if (this.libsModel.getSize() > 0) {
            this.brokenLibs.setSelectedIndex(0);
        }
        this.reqProfile = this.libsModel.requiredProfile();
        this.updateProfiles();
    }

    private static final class LibsModel
    extends AbstractListModel {
        private final SourceLevelQuery.Profile currentProfile;
        private final Collection<? extends ProfileProblemsProviderImpl.Reference> state;
        private final Set<ProfileProblemsProviderImpl.Reference> toRemove;
        private final List<ProfileProblemsProviderImpl.Reference> data;
        private boolean updated;

        LibsModel(@NonNull SourceLevelQuery.Profile currentProfile, @NonNull Collection<? extends ProfileProblemsProviderImpl.Reference> state) {
            this.currentProfile = currentProfile;
            this.state = state;
            this.toRemove = new HashSet<ProfileProblemsProviderImpl.Reference>();
            this.data = new ArrayList<ProfileProblemsProviderImpl.Reference>();
            this.refresh();
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public Object getElementAt(int i) {
            if (i < 0 || i >= this.data.size()) {
                throw new IndexOutOfBoundsException(String.format("Index: %d, Size: %d", i, this.data.size()));
            }
            return this.data.get(i);
        }

        void removeRoots(@NonNull Collection<? extends ProfileProblemsProviderImpl.Reference> roots) {
            int oldSize = this.getSize();
            this.toRemove.addAll(roots);
            this.refresh();
            int newSize = this.getSize();
            this.fireContentsChanged(this, 0, Math.max(oldSize, newSize));
        }

        @NonNull
        SourceLevelQuery.Profile requiredProfile() {
            return ProfileProblemsProviderImpl.requiredProfile(this.data, this.currentProfile);
        }

        void updateProfile(boolean update) {
            int oldSize = this.getSize();
            this.updated = update;
            this.refresh();
            int newSize = this.getSize();
            this.fireContentsChanged(this, 0, Math.max(oldSize, newSize));
        }

        @NonNull
        Collection<? extends ProfileProblemsProviderImpl.Reference> getRemovedRooots() {
            return Collections.unmodifiableCollection(this.toRemove);
        }

        private void refresh() {
            this.data.clear();
            for (ProfileProblemsProviderImpl.Reference reference : this.state) {
                if (this.toRemove.contains(reference) || this.updated && reference.getRequiredProfile() != null) continue;
                this.data.add(reference);
            }
        }
    }

    private static final class LibsRenderer
    extends DefaultListCellRenderer {
        private static final int LIGHTER_COLOR_COMPONENT = 80;
        private final JLabel root = new JLabel();
        private final JLabel profile;
        private final JPanel container;
        private Color fgColor;
        private Color fgColorLighter;
        private Color bgColor;
        private Color bgSelectionColor;
        private Color fgSelectionColor;

        LibsRenderer(@NonNull JList list) {
            this.root.setHorizontalAlignment(2);
            this.root.setOpaque(false);
            this.root.setFont(list.getFont());
            this.profile = new JLabel();
            this.profile.setHorizontalAlignment(4);
            this.profile.setOpaque(false);
            this.profile.setFont(list.getFont());
            this.container = new JPanel();
            this.container.setLayout(new BorderLayout());
            this.container.add((Component)this.root, "West");
            this.container.add((Component)this.profile, "East");
            this.fgColor = list.getForeground();
            this.fgColorLighter = new Color(Math.min(255, this.fgColor.getRed() + 80), Math.min(255, this.fgColor.getGreen() + 80), Math.min(255, this.fgColor.getBlue() + 80));
            this.bgColor = new Color(list.getBackground().getRGB());
            this.bgSelectionColor = list.getSelectionBackground();
            this.fgSelectionColor = list.getSelectionForeground();
        }

        @Override
        public Component getListCellRendererComponent(@NonNull JList jlist, @NullAllowed Object o, int i, boolean isSelected, boolean hasFocus) {
            if (isSelected) {
                this.root.setForeground(this.fgSelectionColor);
                this.profile.setForeground(this.fgSelectionColor);
                this.container.setBackground(this.bgSelectionColor);
            } else {
                this.root.setForeground(this.fgColor);
                this.profile.setForeground(this.fgColorLighter);
                this.container.setBackground(this.bgColor);
            }
            if (o instanceof ProfileProblemsProviderImpl.Reference) {
                ProfileProblemsProviderImpl.Reference e = (ProfileProblemsProviderImpl.Reference)o;
                this.root.setText(e.getDisplayName());
                this.root.setIcon(e.getIcon());
                SourceLevelQuery.Profile requiredProfile = e.getRequiredProfile();
                if (requiredProfile == null) {
                    this.profile.setText(String.format("<html><font color=\"#A40000\">%s", Bundle.MSG_InvalidProfile()));
                } else {
                    this.profile.setText(requiredProfile.getDisplayName());
                }
                this.container.setToolTipText(e.getToolTipText());
            } else {
                this.root.setText("");
                this.root.setIcon(null);
                this.profile.setText("");
                this.container.setToolTipText(null);
            }
            return this.container;
        }
    }

    private static final class ProfilesRenderer
    extends DefaultListCellRenderer {
        private ProfilesRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(@NonNull JList jlist, @NullAllowed Object o, int i, boolean bln, boolean bln1) {
            if (o instanceof SourceLevelQuery.Profile) {
                o = ((SourceLevelQuery.Profile)o).getDisplayName();
            }
            return super.getListCellRendererComponent((JList<?>)jlist, o, i, bln, bln1);
        }
    }
}

