/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.samples.wizard.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.web.client.samples.wizard.ui.OnlineSampleVisualPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

class SampleVisualPanel
extends JPanel {
    private static final long serialVersionUID = 6783546871135477L;
    private final List<ChangeListener> listeners;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;

    public SampleVisualPanel(WizardDescriptor descriptor) {
        this.initComponents();
        this.initProjectNameAndLocation(descriptor);
        this.listeners = new CopyOnWriteArrayList<ChangeListener>();
    }

    private void initProjectNameAndLocation(WizardDescriptor descriptor) {
        String projectName;
        File projectLocation = ProjectChooser.getProjectsFolder();
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        FileObject template = Templates.getTemplate((WizardDescriptor)descriptor);
        String templateName = projectName = template.getName();
        int index = 0;
        while (new File(projectLocation, projectName).exists()) {
            projectName = templateName + ++index;
        }
        this.projectNameTextField.setText(projectName);
        this.projectNameTextField.selectAll();
        this.updateProjectFolder();
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.projectNameTextField.getDocument().addDocumentListener(documentListener);
        this.projectLocationTextField.getDocument().addDocumentListener(documentListener);
        this.setName(NbBundle.getMessage(OnlineSampleVisualPanel.class, (String)"LBL_NameAndLocation"));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.projectNameTextField.requestFocus();
    }

    public String getProjectName() {
        return this.projectNameTextField.getText().trim();
    }

    public String getProjectLocation() {
        return this.projectLocationTextField.getText().trim();
    }

    public File getProjectDirectory() {
        return FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()));
    }

    final void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    final void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    String getErrorMessage() {
        String error = this.validateProjectName();
        if (error != null) {
            return error;
        }
        error = this.validateProjectLocation();
        if (error != null) {
            return error;
        }
        return null;
    }

    private String validateProjectName() {
        String projectName = this.getProjectName();
        if (projectName.isEmpty()) {
            return NbBundle.getMessage(SampleVisualPanel.class, (String)"ERR_NameMissing");
        }
        return null;
    }

    private String validateProjectLocation() {
        File projLoc;
        File projectLocation = FileUtil.normalizeFile((File)new File(this.getProjectLocation()).getAbsoluteFile());
        if (!projectLocation.isDirectory()) {
            return NbBundle.getMessage(SampleVisualPanel.class, (String)"ERR_LocationInvalid");
        }
        File destFolder = this.getProjectDirectory();
        try {
            destFolder.getCanonicalPath();
        }
        catch (IOException e) {
            return NbBundle.getMessage(SampleVisualPanel.class, (String)"ERR_LocationNotWritable");
        }
        for (projLoc = destFolder; projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
        }
        if (projLoc == null || !projLoc.canWrite()) {
            return NbBundle.getMessage(SampleVisualPanel.class, (String)"ERR_LocationNotWritable");
        }
        if (FileUtil.toFileObject((File)projLoc) == null) {
            return NbBundle.getMessage(SampleVisualPanel.class, (String)"ERR_LocationInvalid");
        }
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            return NbBundle.getMessage(SampleVisualPanel.class, (String)"ERR_LocationNotEmpty");
        }
        return null;
    }

    private void updateProjectFolder() {
        this.createdFolderTextField.setText(this.getProjectLocation() + File.separatorChar + this.getProjectName());
    }

    private void fireChange() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(SampleVisualPanel.class, (String)"LBL_ProjectName"));
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(SampleVisualPanel.class, (String)"LBL_ProjectLocation"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(SampleVisualPanel.class, (String)"LBL_Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SampleVisualPanel.this.browseButtonActionPerformed(evt);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(SampleVisualPanel.class, (String)"LBL_ProjectFolder"));
        this.createdFolderTextField.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectNameLabel).addComponent(this.projectLocationLabel).addComponent(this.createdFolderLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectNameTextField, GroupLayout.Alignment.TRAILING, -1, 307, Short.MAX_VALUE).addComponent(this.projectLocationTextField, GroupLayout.Alignment.TRAILING).addComponent(this.createdFolderTextField, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameLabel).addComponent(this.projectNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLocationLabel).addComponent(this.projectLocationTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createdFolderLabel).addComponent(this.createdFolderTextField, -2, -1, -2))));
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SampleVisualPanel.class, (String)"SampleVisualPanel.projectNameLabel.AccessibleContext.accessibleName"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SampleVisualPanel.class, (String)"SampleVisualPanel.projectLocationLabel.AccessibleContext.accessibleName"));
        this.browseButton.getAccessibleContext().setAccessibleName("Browse button");
        this.createdFolderLabel.getAccessibleContext().setAccessibleName("Project folder");
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(SampleVisualPanel.class, (String)"LBL_ProjectLocation"));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File projectDir;
        File projDir;
        File workDir = null;
        String projectLocation = this.getProjectLocation();
        if (projectLocation != null && !projectLocation.isEmpty() && (projDir = new File(projectLocation)).isDirectory()) {
            workDir = projDir;
        }
        if (workDir == null) {
            workDir = ProjectChooser.getProjectsFolder();
        }
        if ((projectDir = new FileChooserBuilder(SampleVisualPanel.class).setTitle(NbBundle.getMessage(SampleVisualPanel.class, (String)"TTL_DialogLocation")).setDirectoriesOnly(true).setDefaultWorkingDirectory(workDir).forceUseOfDefaultWorkingDirectory(true).showOpenDialog()) != null) {
            this.projectLocationTextField.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            SampleVisualPanel.this.updateProjectFolder();
            SampleVisualPanel.this.fireChange();
        }
    }
}

