/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.projectimport.eclipse.core;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class UserLibraryParser {
    private UserLibraryParser() {
    }

    static boolean getJars(String libName, String xmlDoc, List<String> jars, List<String> javadocs, List<String> sources) throws IOException {
        Document xml;
        assert (jars.size() == 0 && javadocs.size() == 0 && sources.size() == 0);
        UserLibraryParser parser = new UserLibraryParser();
        try {
            xml = XMLUtil.parse((InputSource)new InputSource(new StringReader(xmlDoc)), (boolean)false, (boolean)true, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
        }
        catch (SAXException e) {
            IOException ioe = (IOException)new IOException("Library '" + libName + "' cannot be parsed: " + e.toString()).initCause(e);
            throw ioe;
        }
        Element root = xml.getDocumentElement();
        if (!"userlibrary".equals(root.getLocalName())) {
            return false;
        }
        for (Element el : XMLUtil.findSubElements((Element)root)) {
            Element el2;
            if (!el.getNodeName().equals("archive")) continue;
            jars.add(el.getAttribute("path"));
            String src = el.getAttribute("sourceattachment");
            if (src.length() > 0) {
                sources.add(src);
            }
            if ((el2 = XMLUtil.findElement((Element)el, (String)"attributes", null)) == null) continue;
            for (Element el3 : XMLUtil.findSubElements((Element)el2)) {
                String javadoc;
                if (!el3.getNodeName().equals("attribute") || !"javadoc_location".equals(el3.getAttribute("name")) || (javadoc = el3.getAttribute("value")) == null) continue;
                javadocs.add(javadoc);
            }
        }
        return jars.size() > 0;
    }
}

