/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.groovy;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.spi.nodes.AbstractMavenNodeList;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;

public class GroovySourcesNodeFactory
implements NodeFactory {
    private static final String PROP_PROJECT = "MavenProject";
    private static final String PROP_RESOURCE = "RESOURCES";
    private static final String MAIN_GROOVY = "src/main/groovy";
    private static final String TEST_GROOVY = "src/test/groovy";

    public NodeList<?> createNodes(Project project) {
        return new GroovyNodeList(project);
    }

    private static class GroovyNodeList
    extends AbstractMavenNodeList<SourceGroup>
    implements FileChangeListener,
    PropertyChangeListener {
        private final FileChangeListener changeListener = FileUtil.weakFileChangeListener((FileChangeListener)this, null);
        private final Project project;
        private final Sources sources;

        private GroovyNodeList(Project project) {
            this.project = project;
            this.sources = ProjectUtils.getSources((Project)project);
        }

        public List<SourceGroup> keys() {
            Set<FileObject> javaRoots = this.getJavaRoots();
            ArrayList<SourceGroup> groovySourceGroups = new ArrayList<SourceGroup>();
            for (SourceGroup sourceGroup : this.sources.getSourceGroups("groovy")) {
                if (javaRoots.contains(sourceGroup.getRootFolder())) continue;
                groovySourceGroups.add(sourceGroup);
            }
            return groovySourceGroups;
        }

        private Set<FileObject> getJavaRoots() {
            HashSet<FileObject> javaRoots = new HashSet<FileObject>();
            for (SourceGroup sourceGroup : this.sources.getSourceGroups("java")) {
                javaRoots.add(sourceGroup.getRootFolder());
            }
            return javaRoots;
        }

        public Node node(SourceGroup group) {
            return PackageView.createPackageView((SourceGroup)group);
        }

        public void addNotify() {
            NbMavenProject watch = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            watch.addWatchedPath(GroovySourcesNodeFactory.MAIN_GROOVY);
            watch.addWatchedPath(GroovySourcesNodeFactory.TEST_GROOVY);
            this.checkFileObject(GroovySourcesNodeFactory.MAIN_GROOVY);
            this.checkFileObject(GroovySourcesNodeFactory.TEST_GROOVY);
        }

        private void checkFileObject(String path) {
            FileObject fo = this.project.getProjectDirectory().getFileObject(path);
            if (fo != null) {
                fo.removeFileChangeListener(this.changeListener);
                fo.addFileChangeListener(this.changeListener);
            }
        }

        public void removeNotify() {
            NbMavenProject watch = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            watch.removeWatchedPath(GroovySourcesNodeFactory.MAIN_GROOVY);
            watch.removeWatchedPath(GroovySourcesNodeFactory.TEST_GROOVY);
            this.removeListener(GroovySourcesNodeFactory.MAIN_GROOVY);
            this.removeListener(GroovySourcesNodeFactory.TEST_GROOVY);
        }

        private void removeListener(String rootPath) {
            FileObject fo = this.project.getProjectDirectory().getFileObject(rootPath);
            if (fo != null) {
                fo.removeFileChangeListener(this.changeListener);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            Object newValue = evt.getNewValue();
            if ((GroovySourcesNodeFactory.PROP_PROJECT.equals(propertyName) || GroovySourcesNodeFactory.PROP_RESOURCE.equals(propertyName)) && newValue != null) {
                if (newValue.toString().contains(GroovySourcesNodeFactory.MAIN_GROOVY)) {
                    this.fireChange();
                    this.checkFileObject(GroovySourcesNodeFactory.MAIN_GROOVY);
                } else if (newValue.toString().contains(GroovySourcesNodeFactory.TEST_GROOVY)) {
                    this.fireChange();
                    this.checkFileObject(GroovySourcesNodeFactory.TEST_GROOVY);
                }
            }
        }

        public void fileFolderCreated(FileEvent fe) {
            this.fireChange();
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            this.fireChange();
            fe.getFile().removeFileChangeListener((FileChangeListener)this);
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.fireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }
    }
}

