/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.project.ui.actions.BuildExecutionSupportImpl;
import org.netbeans.modules.project.ui.actions.StopBuildingAlert;
import org.netbeans.spi.project.ui.support.BuildExecutionSupport;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.SystemAction;

public final class StopBuildingAction
extends CallableSystemAction
implements ChangeListener {
    public StopBuildingAction() {
        BuildExecutionSupportImpl.getInstance().addChangeListener(WeakListeners.change((ChangeListener)this, (Object)BuildExecutionSupportImpl.getInstance()));
    }

    public void performAction() {
        List<BuildExecutionSupport.Item> toStop = BuildExecutionSupportImpl.getInstance().getRunningItems();
        if (toStop.size() > 1) {
            toStop = StopBuildingAlert.selectProcessToKill(toStop);
        }
        for (BuildExecutionSupport.Item t : toStop) {
            if (t == null) continue;
            t.stopRunning();
        }
    }

    public String getName() {
        return NbBundle.getMessage(StopBuildingAction.class, (String)"LBL_stop_building");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected void initialize() {
        super.initialize();
        this.setEnabled(false);
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getMenuPresenter() {
        class SpecialMenuItem
        extends JMenuItem
        implements DynamicMenuContent {
            public SpecialMenuItem() {
                super((Action)((Object)StopBuildingAction.this));
            }

            public JComponent[] getMenuPresenters() {
                String label = NbBundle.getMessage(StopBuildingAction.class, (String)"LBL_stop_building");
                List items = BuildExecutionSupportImpl.getInstance().getRunningItems();
                switch (items.size()) {
                    case 0: {
                        label = NbBundle.getMessage(StopBuildingAction.class, (String)"LBL_stop_building");
                        break;
                    }
                    case 1: {
                        label = NbBundle.getMessage(StopBuildingAction.class, (String)"LBL_stop_building_one", (Object)((BuildExecutionSupport.Item)items.iterator().next()).getDisplayName());
                        break;
                    }
                    default: {
                        label = NbBundle.getMessage(StopBuildingAction.class, (String)"LBL_stop_building_many");
                    }
                }
                Mnemonics.setLocalizedText((AbstractButton)this, (String)label);
                return new JComponent[]{this};
            }

            public JComponent[] synchMenuPresenters(JComponent[] items) {
                return this.getMenuPresenters();
            }
        }
        return new SpecialMenuItem();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        final List items = BuildExecutionSupportImpl.getInstance().getRunningItems();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((StopBuildingAction)SystemAction.get(StopBuildingAction.class)).setEnabled(items.size() > 0);
            }
        });
    }
}

