/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.dataobject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JSeparator;
import org.netbeans.modules.languages.dataobject.LanguagesDataObject;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;

public class LanguagesDataNode
extends DataNode {
    private Map<String, Action[]> mimeTypeToActions = new HashMap<String, Action[]>();

    public LanguagesDataNode(LanguagesDataObject obj) {
        super((DataObject)obj, Children.LEAF);
        String mimeType = obj.getPrimaryFile().getMIMEType();
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Editors/" + mimeType + "/language.nbs");
        String icon = (String)fo.getAttribute("icon");
        if (icon == null) {
            icon = "org/netbeans/modules/languages/resources/defaultIcon.png";
        }
        this.setIconBaseWithExtension(icon);
    }

    public Action[] getActions(boolean context) {
        String mimeType = this.getDataObject().getPrimaryFile().getMIMEType();
        if (!this.mimeTypeToActions.containsKey(mimeType)) {
            ArrayList<Action> actions = new ArrayList<Action>();
            try {
                FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("Loaders/" + mimeType + "/Actions");
                if (fo != null) {
                    DataFolder df = DataFolder.findFolder((FileObject)fo);
                    DataObject[] dob = df.getChildren();
                    int k = dob.length;
                    for (int i = 0; i < k; ++i) {
                        InstanceCookie ic = (InstanceCookie)dob[i].getCookie(InstanceCookie.class);
                        Class clazz = ic.instanceClass();
                        if (JSeparator.class.isAssignableFrom(clazz)) {
                            actions.add(null);
                            continue;
                        }
                        actions.add((Action)ic.instanceCreate());
                    }
                }
            }
            catch (ClassNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            if (!actions.isEmpty()) {
                this.mimeTypeToActions.put(mimeType, actions.toArray(new Action[0]));
            } else {
                this.mimeTypeToActions.put(mimeType, super.getActions(context));
            }
        }
        return this.mimeTypeToActions.get(mimeType);
    }
}

