/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetComputeCapacityReservationRequest
extends BmcRequest<Void> {
    private String capacityReservationId;
    private String opcRequestId;

    public String getCapacityReservationId() {
        return this.capacityReservationId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().capacityReservationId(this.capacityReservationId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",capacityReservationId=").append(String.valueOf(this.capacityReservationId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetComputeCapacityReservationRequest)) {
            return false;
        }
        GetComputeCapacityReservationRequest other = (GetComputeCapacityReservationRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.capacityReservationId, other.capacityReservationId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.capacityReservationId == null ? 43 : this.capacityReservationId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetComputeCapacityReservationRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String capacityReservationId = null;
        private String opcRequestId = null;

        public Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetComputeCapacityReservationRequest o) {
            this.capacityReservationId(o.getCapacityReservationId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetComputeCapacityReservationRequest build() {
            GetComputeCapacityReservationRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetComputeCapacityReservationRequest buildWithoutInvocationCallback() {
            GetComputeCapacityReservationRequest request = new GetComputeCapacityReservationRequest();
            request.capacityReservationId = this.capacityReservationId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

