package dagjose

// Code generated by go-ipld-prime gengo.  DO NOT EDIT.

import (
	"github.com/ipld/go-ipld-prime/datamodel"
	"github.com/ipld/go-ipld-prime/node/mixins"
	"github.com/ipld/go-ipld-prime/schema"
)

func (n _Any) AsInterface() _Any__iface {
	return n.x
}

type _Any__Maybe struct {
	m schema.Maybe
	v Any
}
type MaybeAny = *_Any__Maybe

func (m MaybeAny) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeAny) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeAny) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeAny) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeAny) Must() Any {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	memberName__Any_String = _String{"String"}
	memberName__Any_Bytes  = _String{"Bytes"}
	memberName__Any_Int    = _String{"Int"}
	memberName__Any_Float  = _String{"Float"}
	memberName__Any_Map    = _String{"Map"}
	memberName__Any_List   = _String{"List"}
)
var _ datamodel.Node = (Any)(&_Any{})
var _ schema.TypedNode = (Any)(&_Any{})

func (Any) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n Any) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "String":
		if n2, ok := n.x.(String); ok {
			return n2, nil
		} else {
			return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
	case "Bytes":
		if n2, ok := n.x.(Bytes); ok {
			return n2, nil
		} else {
			return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
	case "Int":
		if n2, ok := n.x.(Int); ok {
			return n2, nil
		} else {
			return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
	case "Float":
		if n2, ok := n.x.(Float); ok {
			return n2, nil
		} else {
			return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
	case "Map":
		if n2, ok := n.x.(Map); ok {
			return n2, nil
		} else {
			return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
	case "List":
		if n2, ok := n.x.(List); ok {
			return n2, nil
		} else {
			return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n Any) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (Any) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.Any"}.LookupByIndex(0)
}
func (n Any) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n Any) MapIterator() datamodel.MapIterator {
	return &_Any__MapItr{n, false}
}

type _Any__MapItr struct {
	n    Any
	done bool
}

func (itr *_Any__MapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
	if itr.done {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch n2 := itr.n.x.(type) {
	case String:
		k, v = &memberName__Any_String, n2
	case Bytes:
		k, v = &memberName__Any_Bytes, n2
	case Int:
		k, v = &memberName__Any_Int, n2
	case Float:
		k, v = &memberName__Any_Float, n2
	case Map:
		k, v = &memberName__Any_Map, n2
	case List:
		k, v = &memberName__Any_List, n2
	default:
		panic("unreachable")
	}
	itr.done = true
	return
}
func (itr *_Any__MapItr) Done() bool {
	return itr.done
}

func (Any) ListIterator() datamodel.ListIterator {
	return nil
}
func (Any) Length() int64 {
	return 1
}
func (Any) IsAbsent() bool {
	return false
}
func (Any) IsNull() bool {
	return false
}
func (Any) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.Any"}.AsBool()
}
func (Any) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.Any"}.AsInt()
}
func (Any) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.Any"}.AsFloat()
}
func (Any) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.Any"}.AsString()
}
func (Any) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.Any"}.AsBytes()
}
func (Any) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.Any"}.AsLink()
}
func (Any) Prototype() datamodel.NodePrototype {
	return _Any__Prototype{}
}

type _Any__Prototype struct{}

func (_Any__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Any__Builder
	nb.Reset()
	return &nb
}

type _Any__Builder struct {
	_Any__Assembler
}

func (nb *_Any__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Any__Builder) Reset() {
	var w _Any
	var m schema.Maybe
	*nb = _Any__Builder{_Any__Assembler{w: &w, m: &m}}
}

type _Any__Assembler struct {
	w     *_Any
	m     *schema.Maybe
	state maState

	cm  schema.Maybe
	ca1 *_String__Assembler

	ca2 *_Bytes__Assembler

	ca3 *_Int__Assembler

	ca4 *_Float__Assembler

	ca5 *_Map__Assembler

	ca6 *_List__Assembler
	ca  uint
}

func (na *_Any__Assembler) reset() {
	na.state = maState_initial
	switch na.ca {
	case 0:
		return
	case 1:
		na.ca1.reset()

	case 2:
		na.ca2.reset()

	case 3:
		na.ca3.reset()

	case 4:
		na.ca4.reset()

	case 5:
		na.ca5.reset()

	case 6:
		na.ca6.reset()
	default:
		panic("unreachable")
	}
	na.ca = 0
	na.cm = schema.Maybe_Absent
}
func (na *_Any__Assembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_Any{}
	}
	return na, nil
}
func (_Any__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.Any"}.BeginList(0)
}
func (na *_Any__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.Any"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Any__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.Any"}.AssignBool(false)
}
func (_Any__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.Any"}.AssignInt(0)
}
func (_Any__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.Any"}.AssignFloat(0)
}
func (_Any__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.Any"}.AssignString("")
}
func (_Any__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.Any"}.AssignBytes(nil)
}
func (_Any__Assembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.Any"}.AssignLink(nil)
}
func (na *_Any__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Any); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.Any", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Any__Assembler) Prototype() datamodel.NodePrototype {
	return _Any__Prototype{}
}
func (ma *_Any__Assembler) valueFinishTidy() bool {
	switch ma.cm {
	case schema.Maybe_Value:
		ma.state = maState_initial
		return true
	default:
		return false
	}
}
func (ma *_Any__Assembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on for the moment, but we'll still be erroring shortly.
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	if ma.ca != 0 {
		return nil, schema.ErrNotUnionStructure{TypeName: "dagjose.Any", Detail: "cannot add another entry -- a union can only contain one thing!"}
	}
	switch k {
	case "String":
		ma.state = maState_midValue
		ma.ca = 1
		x := &_String{}
		ma.w.x = x
		if ma.ca1 == nil {
			ma.ca1 = &_String__Assembler{}
		}
		ma.ca1.w = x
		ma.ca1.m = &ma.cm
		return ma.ca1, nil
	case "Bytes":
		ma.state = maState_midValue
		ma.ca = 2
		x := &_Bytes{}
		ma.w.x = x
		if ma.ca2 == nil {
			ma.ca2 = &_Bytes__Assembler{}
		}
		ma.ca2.w = x
		ma.ca2.m = &ma.cm
		return ma.ca2, nil
	case "Int":
		ma.state = maState_midValue
		ma.ca = 3
		x := &_Int{}
		ma.w.x = x
		if ma.ca3 == nil {
			ma.ca3 = &_Int__Assembler{}
		}
		ma.ca3.w = x
		ma.ca3.m = &ma.cm
		return ma.ca3, nil
	case "Float":
		ma.state = maState_midValue
		ma.ca = 4
		x := &_Float{}
		ma.w.x = x
		if ma.ca4 == nil {
			ma.ca4 = &_Float__Assembler{}
		}
		ma.ca4.w = x
		ma.ca4.m = &ma.cm
		return ma.ca4, nil
	case "Map":
		ma.state = maState_midValue
		ma.ca = 5
		x := &_Map{}
		ma.w.x = x
		if ma.ca5 == nil {
			ma.ca5 = &_Map__Assembler{}
		}
		ma.ca5.w = x
		ma.ca5.m = &ma.cm
		return ma.ca5, nil
	case "List":
		ma.state = maState_midValue
		ma.ca = 6
		x := &_List{}
		ma.w.x = x
		if ma.ca6 == nil {
			ma.ca6 = &_List__Assembler{}
		}
		ma.ca6.w = x
		ma.ca6.m = &ma.cm
		return ma.ca6, nil
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.Any", Key: &_String{k}}
}
func (ma *_Any__Assembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on for the moment, but we'll still be erroring shortly... or rather, the keyassembler will be.
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_Any__KeyAssembler)(ma)
}
func (ma *_Any__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.ca {
	case 1:
		x := &_String{}
		ma.w.x = x
		if ma.ca1 == nil {
			ma.ca1 = &_String__Assembler{}
		}
		ma.ca1.w = x
		ma.ca1.m = &ma.cm
		return ma.ca1
	case 2:
		x := &_Bytes{}
		ma.w.x = x
		if ma.ca2 == nil {
			ma.ca2 = &_Bytes__Assembler{}
		}
		ma.ca2.w = x
		ma.ca2.m = &ma.cm
		return ma.ca2
	case 3:
		x := &_Int{}
		ma.w.x = x
		if ma.ca3 == nil {
			ma.ca3 = &_Int__Assembler{}
		}
		ma.ca3.w = x
		ma.ca3.m = &ma.cm
		return ma.ca3
	case 4:
		x := &_Float{}
		ma.w.x = x
		if ma.ca4 == nil {
			ma.ca4 = &_Float__Assembler{}
		}
		ma.ca4.w = x
		ma.ca4.m = &ma.cm
		return ma.ca4
	case 5:
		x := &_Map{}
		ma.w.x = x
		if ma.ca5 == nil {
			ma.ca5 = &_Map__Assembler{}
		}
		ma.ca5.w = x
		ma.ca5.m = &ma.cm
		return ma.ca5
	case 6:
		x := &_List{}
		ma.w.x = x
		if ma.ca6 == nil {
			ma.ca6 = &_List__Assembler{}
		}
		ma.ca6.w = x
		ma.ca6.m = &ma.cm
		return ma.ca6
	default:
		panic("unreachable")
	}
}
func (ma *_Any__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.ca == 0 {
		return schema.ErrNotUnionStructure{TypeName: "dagjose.Any", Detail: "a union must have exactly one entry (not none)!"}
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_Any__Assembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_Any__Assembler) ValuePrototype(k string) datamodel.NodePrototype {
	switch k {
	case "String":
		return _String__Prototype{}
	case "Bytes":
		return _Bytes__Prototype{}
	case "Int":
		return _Int__Prototype{}
	case "Float":
		return _Float__Prototype{}
	case "Map":
		return _Map__Prototype{}
	case "List":
		return _List__Prototype{}
	default:
		return nil
	}
}

type _Any__KeyAssembler _Any__Assembler

func (_Any__KeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.Any.KeyAssembler"}.BeginMap(0)
}
func (_Any__KeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.Any.KeyAssembler"}.BeginList(0)
}
func (na *_Any__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.Any.KeyAssembler"}.AssignNull()
}
func (_Any__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.Any.KeyAssembler"}.AssignBool(false)
}
func (_Any__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.Any.KeyAssembler"}.AssignInt(0)
}
func (_Any__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.Any.KeyAssembler"}.AssignFloat(0)
}
func (ka *_Any__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	if ka.ca != 0 {
		return schema.ErrNotUnionStructure{TypeName: "dagjose.Any", Detail: "cannot add another entry -- a union can only contain one thing!"}
	}
	switch k {
	case "String":
		ka.ca = 1
		ka.state = maState_expectValue
		return nil
	case "Bytes":
		ka.ca = 2
		ka.state = maState_expectValue
		return nil
	case "Int":
		ka.ca = 3
		ka.state = maState_expectValue
		return nil
	case "Float":
		ka.ca = 4
		ka.state = maState_expectValue
		return nil
	case "Map":
		ka.ca = 5
		ka.state = maState_expectValue
		return nil
	case "List":
		ka.ca = 6
		ka.state = maState_expectValue
		return nil
	}
	return schema.ErrInvalidKey{TypeName: "dagjose.Any", Key: &_String{k}} // TODO: error quality: ErrInvalidUnionDiscriminant ?
}
func (_Any__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.Any.KeyAssembler"}.AssignBytes(nil)
}
func (_Any__KeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.Any.KeyAssembler"}.AssignLink(nil)
}
func (ka *_Any__KeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_Any__KeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (Any) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Any) Representation() datamodel.Node {
	return (*_Any__Repr)(n)
}

type _Any__Repr _Any

var _ datamodel.Node = &_Any__Repr{}

func (n *_Any__Repr) Kind() datamodel.Kind {
	switch n.x.(type) {
	case String:
		return datamodel.Kind_String
	case Bytes:
		return datamodel.Kind_Bytes
	case Int:
		return datamodel.Kind_Int
	case Float:
		return datamodel.Kind_Float
	case Map:
		return datamodel.Kind_Map
	case List:
		return datamodel.Kind_List
	default:
		panic("unreachable")
	}
}
func (n *_Any__Repr) LookupByString(key string) (datamodel.Node, error) {
	switch n2 := n.x.(type) {
	case Map:
		return n2.Representation().LookupByString(key)
	default:
		return nil, datamodel.ErrWrongKind{TypeName: "dagjose.Any.Repr", MethodName: "LookupByString", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: n.Kind()}
	}
}
func (n *_Any__Repr) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	switch n2 := n.x.(type) {
	case Map:
		return n2.Representation().LookupByNode(key)
	case List:
		return n2.Representation().LookupByNode(key)
	default:
		return nil, datamodel.ErrWrongKind{TypeName: "dagjose.Any.Repr", MethodName: "LookupByNode", AppropriateKind: datamodel.KindSet_Recursive, ActualKind: n.Kind()}
	}
}
func (n *_Any__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	switch n2 := n.x.(type) {
	case List:
		return n2.Representation().LookupByIndex(idx)
	default:
		return nil, datamodel.ErrWrongKind{TypeName: "dagjose.Any.Repr", MethodName: "LookupByIndex", AppropriateKind: datamodel.KindSet_JustList, ActualKind: n.Kind()}
	}
}
func (n *_Any__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	switch n2 := n.x.(type) {
	case Map:
		return n2.Representation().LookupBySegment(seg)
	case List:
		return n2.Representation().LookupBySegment(seg)
	default:
		return nil, datamodel.ErrWrongKind{TypeName: "dagjose.Any.Repr", MethodName: "LookupBySegment", AppropriateKind: datamodel.KindSet_Recursive, ActualKind: n.Kind()}
	}
}
func (n *_Any__Repr) MapIterator() datamodel.MapIterator {
	switch n2 := n.x.(type) {
	case Map:
		return n2.Representation().MapIterator()
	default:
		return nil
	}
}
func (n *_Any__Repr) ListIterator() datamodel.ListIterator {
	switch n2 := n.x.(type) {
	case List:
		return n2.Representation().ListIterator()
	default:
		return nil
	}
}
func (n *_Any__Repr) Length() int64 {
	switch n2 := n.x.(type) {
	case Map:
		return n2.Representation().Length()
	case List:
		return n2.Representation().Length()
	default:
		return -1
	}
}
func (n *_Any__Repr) IsAbsent() bool {
	return false
}
func (n *_Any__Repr) IsNull() bool {
	return false
}
func (n *_Any__Repr) AsBool() (bool, error) {
	return false, datamodel.ErrWrongKind{TypeName: "dagjose.Any.Repr", MethodName: "AsBool", AppropriateKind: datamodel.KindSet_JustBool, ActualKind: n.Kind()}
}
func (n *_Any__Repr) AsInt() (int64, error) {
	switch n2 := n.x.(type) {
	case Int:
		return n2.Representation().AsInt()
	default:
		return 0, datamodel.ErrWrongKind{TypeName: "dagjose.Any.Repr", MethodName: "AsInt", AppropriateKind: datamodel.KindSet_JustInt, ActualKind: n.Kind()}
	}
}
func (n *_Any__Repr) AsFloat() (float64, error) {
	switch n2 := n.x.(type) {
	case Float:
		return n2.Representation().AsFloat()
	default:
		return 0, datamodel.ErrWrongKind{TypeName: "dagjose.Any.Repr", MethodName: "AsFloat", AppropriateKind: datamodel.KindSet_JustFloat, ActualKind: n.Kind()}
	}
}
func (n *_Any__Repr) AsString() (string, error) {
	switch n2 := n.x.(type) {
	case String:
		return n2.Representation().AsString()
	default:
		return "", datamodel.ErrWrongKind{TypeName: "dagjose.Any.Repr", MethodName: "AsString", AppropriateKind: datamodel.KindSet_JustString, ActualKind: n.Kind()}
	}
}
func (n *_Any__Repr) AsBytes() ([]byte, error) {
	switch n2 := n.x.(type) {
	case Bytes:
		return n2.Representation().AsBytes()
	default:
		return nil, datamodel.ErrWrongKind{TypeName: "dagjose.Any.Repr", MethodName: "AsBytes", AppropriateKind: datamodel.KindSet_JustBytes, ActualKind: n.Kind()}
	}
}
func (n *_Any__Repr) AsLink() (datamodel.Link, error) {
	return nil, datamodel.ErrWrongKind{TypeName: "dagjose.Any.Repr", MethodName: "AsLink", AppropriateKind: datamodel.KindSet_JustLink, ActualKind: n.Kind()}
}
func (_Any__Repr) Prototype() datamodel.NodePrototype {
	return _Any__ReprPrototype{}
}

type _Any__ReprPrototype struct{}

func (_Any__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Any__ReprBuilder
	nb.Reset()
	return &nb
}

type _Any__ReprBuilder struct {
	_Any__ReprAssembler
}

func (nb *_Any__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Any__ReprBuilder) Reset() {
	var w _Any
	var m schema.Maybe
	*nb = _Any__ReprBuilder{_Any__ReprAssembler{w: &w, m: &m}}
}

type _Any__ReprAssembler struct {
	w   *_Any
	m   *schema.Maybe
	ca1 *_String__ReprAssembler
	ca2 *_Bytes__ReprAssembler
	ca3 *_Int__ReprAssembler
	ca4 *_Float__ReprAssembler
	ca5 *_Map__ReprAssembler
	ca6 *_List__ReprAssembler
	ca  uint
}

func (na *_Any__ReprAssembler) reset() {
	switch na.ca {
	case 0:
		return
	case 1:
		na.ca1.reset()
	case 2:
		na.ca2.reset()
	case 3:
		na.ca3.reset()
	case 4:
		na.ca4.reset()
	case 5:
		na.ca5.reset()
	case 6:
		na.ca6.reset()
	default:
		panic("unreachable")
	}
	na.ca = 0
}
func (na *_Any__ReprAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign into assembler that's already working on a larger structure!")
	}
	if na.w == nil {
		na.w = &_Any{}
	}
	na.ca = 5
	x := &_Map{}
	na.w.x = x
	if na.ca5 == nil {
		na.ca5 = &_Map__ReprAssembler{}
	}
	na.ca5.w = x
	na.ca5.m = na.m
	return na.ca5.BeginMap(sizeHint)
}
func (na *_Any__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign into assembler that's already working on a larger structure!")
	}
	if na.w == nil {
		na.w = &_Any{}
	}
	na.ca = 6
	x := &_List{}
	na.w.x = x
	if na.ca6 == nil {
		na.ca6 = &_List__ReprAssembler{}
	}
	na.ca6.w = x
	na.ca6.m = na.m
	return na.ca6.BeginList(sizeHint)
}
func (na *_Any__ReprAssembler) AssignNull() error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign into assembler that's already working on a larger structure!")
	}
	return schema.ErrNotUnionStructure{TypeName: "dagjose.Any.Repr", Detail: "AssignNull called but is not valid for any of the kinds that are valid members of this union"}
}
func (na *_Any__ReprAssembler) AssignBool(v bool) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign into assembler that's already working on a larger structure!")
	}
	return schema.ErrNotUnionStructure{TypeName: "dagjose.Any.Repr", Detail: "AssignBool called but is not valid for any of the kinds that are valid members of this union"}
}
func (na *_Any__ReprAssembler) AssignInt(v int64) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign into assembler that's already working on a larger structure!")
	}
	if na.w == nil {
		na.w = &_Any{}
	}
	na.ca = 3
	x := &_Int{}
	na.w.x = x
	if na.ca3 == nil {
		na.ca3 = &_Int__ReprAssembler{}
	}
	na.ca3.w = x
	na.ca3.m = na.m
	return na.ca3.AssignInt(v)
}
func (na *_Any__ReprAssembler) AssignFloat(v float64) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign into assembler that's already working on a larger structure!")
	}
	if na.w == nil {
		na.w = &_Any{}
	}
	na.ca = 4
	x := &_Float{}
	na.w.x = x
	if na.ca4 == nil {
		na.ca4 = &_Float__ReprAssembler{}
	}
	na.ca4.w = x
	na.ca4.m = na.m
	return na.ca4.AssignFloat(v)
}
func (na *_Any__ReprAssembler) AssignString(v string) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign into assembler that's already working on a larger structure!")
	}
	if na.w == nil {
		na.w = &_Any{}
	}
	na.ca = 1
	x := &_String{}
	na.w.x = x
	if na.ca1 == nil {
		na.ca1 = &_String__ReprAssembler{}
	}
	na.ca1.w = x
	na.ca1.m = na.m
	return na.ca1.AssignString(v)
}
func (na *_Any__ReprAssembler) AssignBytes(v []byte) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign into assembler that's already working on a larger structure!")
	}
	if na.w == nil {
		na.w = &_Any{}
	}
	na.ca = 2
	x := &_Bytes{}
	na.w.x = x
	if na.ca2 == nil {
		na.ca2 = &_Bytes__ReprAssembler{}
	}
	na.ca2.w = x
	na.ca2.m = na.m
	return na.ca2.AssignBytes(v)
}
func (na *_Any__ReprAssembler) AssignLink(v datamodel.Link) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign into assembler that's already working on a larger structure!")
	}
	return schema.ErrNotUnionStructure{TypeName: "dagjose.Any.Repr", Detail: "AssignLink called but is not valid for any of the kinds that are valid members of this union"}
}
func (na *_Any__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Any); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	switch v.Kind() {
	case datamodel.Kind_Bool:
		v2, _ := v.AsBool()
		return na.AssignBool(v2)
	case datamodel.Kind_Int:
		v2, _ := v.AsInt()
		return na.AssignInt(v2)
	case datamodel.Kind_Float:
		v2, _ := v.AsFloat()
		return na.AssignFloat(v2)
	case datamodel.Kind_String:
		v2, _ := v.AsString()
		return na.AssignString(v2)
	case datamodel.Kind_Bytes:
		v2, _ := v.AsBytes()
		return na.AssignBytes(v2)
	case datamodel.Kind_Map:
		na, err := na.BeginMap(v.Length())
		if err != nil {
			return err
		}
		itr := v.MapIterator()
		for !itr.Done() {
			k, v, err := itr.Next()
			if err != nil {
				return err
			}
			if err := na.AssembleKey().AssignNode(k); err != nil {
				return err
			}
			if err := na.AssembleValue().AssignNode(v); err != nil {
				return err
			}
		}
		return na.Finish()
	case datamodel.Kind_List:
		na, err := na.BeginList(v.Length())
		if err != nil {
			return err
		}
		itr := v.ListIterator()
		for !itr.Done() {
			_, v, err := itr.Next()
			if err != nil {
				return err
			}
			if err := na.AssembleValue().AssignNode(v); err != nil {
				return err
			}
		}
		return na.Finish()
	case datamodel.Kind_Link:
		v2, _ := v.AsLink()
		return na.AssignLink(v2)
	default:
		panic("unreachable")
	}
}
func (na *_Any__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _Any__ReprPrototype{}
}

func (n Bytes) Bytes() []byte {
	return n.x
}
func (_Bytes__Prototype) FromBytes(v []byte) (Bytes, error) {
	n := _Bytes{v}
	return &n, nil
}

type _Bytes__Maybe struct {
	m schema.Maybe
	v _Bytes
}
type MaybeBytes = *_Bytes__Maybe

func (m MaybeBytes) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeBytes) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeBytes) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeBytes) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeBytes) Must() Bytes {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (Bytes)(&_Bytes{})
var _ schema.TypedNode = (Bytes)(&_Bytes{})

func (Bytes) Kind() datamodel.Kind {
	return datamodel.Kind_Bytes
}
func (Bytes) LookupByString(string) (datamodel.Node, error) {
	return mixins.Bytes{TypeName: "dagjose.Bytes"}.LookupByString("")
}
func (Bytes) LookupByNode(datamodel.Node) (datamodel.Node, error) {
	return mixins.Bytes{TypeName: "dagjose.Bytes"}.LookupByNode(nil)
}
func (Bytes) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Bytes{TypeName: "dagjose.Bytes"}.LookupByIndex(0)
}
func (Bytes) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return mixins.Bytes{TypeName: "dagjose.Bytes"}.LookupBySegment(seg)
}
func (Bytes) MapIterator() datamodel.MapIterator {
	return nil
}
func (Bytes) ListIterator() datamodel.ListIterator {
	return nil
}
func (Bytes) Length() int64 {
	return -1
}
func (Bytes) IsAbsent() bool {
	return false
}
func (Bytes) IsNull() bool {
	return false
}
func (Bytes) AsBool() (bool, error) {
	return mixins.Bytes{TypeName: "dagjose.Bytes"}.AsBool()
}
func (Bytes) AsInt() (int64, error) {
	return mixins.Bytes{TypeName: "dagjose.Bytes"}.AsInt()
}
func (Bytes) AsFloat() (float64, error) {
	return mixins.Bytes{TypeName: "dagjose.Bytes"}.AsFloat()
}
func (Bytes) AsString() (string, error) {
	return mixins.Bytes{TypeName: "dagjose.Bytes"}.AsString()
}
func (n Bytes) AsBytes() ([]byte, error) {
	return n.x, nil
}
func (Bytes) AsLink() (datamodel.Link, error) {
	return mixins.Bytes{TypeName: "dagjose.Bytes"}.AsLink()
}
func (Bytes) Prototype() datamodel.NodePrototype {
	return _Bytes__Prototype{}
}

type _Bytes__Prototype struct{}

func (_Bytes__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Bytes__Builder
	nb.Reset()
	return &nb
}

type _Bytes__Builder struct {
	_Bytes__Assembler
}

func (nb *_Bytes__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Bytes__Builder) Reset() {
	var w _Bytes
	var m schema.Maybe
	*nb = _Bytes__Builder{_Bytes__Assembler{w: &w, m: &m}}
}

type _Bytes__Assembler struct {
	w *_Bytes
	m *schema.Maybe
}

func (na *_Bytes__Assembler) reset() {}
func (_Bytes__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.BytesAssembler{TypeName: "dagjose.Bytes"}.BeginMap(0)
}
func (_Bytes__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.BytesAssembler{TypeName: "dagjose.Bytes"}.BeginList(0)
}
func (na *_Bytes__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.BytesAssembler{TypeName: "dagjose.Bytes"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Bytes__Assembler) AssignBool(bool) error {
	return mixins.BytesAssembler{TypeName: "dagjose.Bytes"}.AssignBool(false)
}
func (_Bytes__Assembler) AssignInt(int64) error {
	return mixins.BytesAssembler{TypeName: "dagjose.Bytes"}.AssignInt(0)
}
func (_Bytes__Assembler) AssignFloat(float64) error {
	return mixins.BytesAssembler{TypeName: "dagjose.Bytes"}.AssignFloat(0)
}
func (_Bytes__Assembler) AssignString(string) error {
	return mixins.BytesAssembler{TypeName: "dagjose.Bytes"}.AssignString("")
}
func (na *_Bytes__Assembler) AssignBytes(v []byte) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_Bytes__Assembler) AssignLink(datamodel.Link) error {
	return mixins.BytesAssembler{TypeName: "dagjose.Bytes"}.AssignLink(nil)
}
func (na *_Bytes__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Bytes); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsBytes(); err != nil {
		return err
	} else {
		return na.AssignBytes(v2)
	}
}
func (_Bytes__Assembler) Prototype() datamodel.NodePrototype {
	return _Bytes__Prototype{}
}
func (Bytes) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Bytes) Representation() datamodel.Node {
	return (*_Bytes__Repr)(n)
}

type _Bytes__Repr = _Bytes

var _ datamodel.Node = &_Bytes__Repr{}

type _Bytes__ReprPrototype = _Bytes__Prototype
type _Bytes__ReprAssembler = _Bytes__Assembler

func (n _DecodedJWE) FieldAad() MaybeBase64Url {
	return &n.aad
}
func (n _DecodedJWE) FieldCiphertext() Base64Url {
	return &n.ciphertext
}
func (n _DecodedJWE) FieldIv() MaybeBase64Url {
	return &n.iv
}
func (n _DecodedJWE) FieldProtected() MaybeBase64Url {
	return &n.protected
}
func (n _DecodedJWE) FieldRecipients() MaybeDecodedRecipients {
	return &n.recipients
}
func (n _DecodedJWE) FieldTag() MaybeBase64Url {
	return &n.tag
}
func (n _DecodedJWE) FieldUnprotected() MaybeAny {
	return &n.unprotected
}

type _DecodedJWE__Maybe struct {
	m schema.Maybe
	v DecodedJWE
}
type MaybeDecodedJWE = *_DecodedJWE__Maybe

func (m MaybeDecodedJWE) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeDecodedJWE) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeDecodedJWE) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeDecodedJWE) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeDecodedJWE) Must() DecodedJWE {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__DecodedJWE_Aad         = _String{"aad"}
	fieldName__DecodedJWE_Ciphertext  = _String{"ciphertext"}
	fieldName__DecodedJWE_Iv          = _String{"iv"}
	fieldName__DecodedJWE_Protected   = _String{"protected"}
	fieldName__DecodedJWE_Recipients  = _String{"recipients"}
	fieldName__DecodedJWE_Tag         = _String{"tag"}
	fieldName__DecodedJWE_Unprotected = _String{"unprotected"}
)
var _ datamodel.Node = (DecodedJWE)(&_DecodedJWE{})
var _ schema.TypedNode = (DecodedJWE)(&_DecodedJWE{})

func (DecodedJWE) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n DecodedJWE) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "aad":
		if n.aad.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.aad.v, nil
	case "ciphertext":
		return &n.ciphertext, nil
	case "iv":
		if n.iv.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.iv.v, nil
	case "protected":
		if n.protected.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.protected.v, nil
	case "recipients":
		if n.recipients.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.recipients.v, nil
	case "tag":
		if n.tag.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.tag.v, nil
	case "unprotected":
		if n.unprotected.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return n.unprotected.v, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n DecodedJWE) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (DecodedJWE) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWE"}.LookupByIndex(0)
}
func (n DecodedJWE) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n DecodedJWE) MapIterator() datamodel.MapIterator {
	return &_DecodedJWE__MapItr{n, 0}
}

type _DecodedJWE__MapItr struct {
	n   DecodedJWE
	idx int
}

func (itr *_DecodedJWE__MapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
	if itr.idx >= 7 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__DecodedJWE_Aad
		if itr.n.aad.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.aad.v
	case 1:
		k = &fieldName__DecodedJWE_Ciphertext
		v = &itr.n.ciphertext
	case 2:
		k = &fieldName__DecodedJWE_Iv
		if itr.n.iv.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.iv.v
	case 3:
		k = &fieldName__DecodedJWE_Protected
		if itr.n.protected.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.protected.v
	case 4:
		k = &fieldName__DecodedJWE_Recipients
		if itr.n.recipients.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.recipients.v
	case 5:
		k = &fieldName__DecodedJWE_Tag
		if itr.n.tag.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.tag.v
	case 6:
		k = &fieldName__DecodedJWE_Unprotected
		if itr.n.unprotected.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = itr.n.unprotected.v
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_DecodedJWE__MapItr) Done() bool {
	return itr.idx >= 7
}

func (DecodedJWE) ListIterator() datamodel.ListIterator {
	return nil
}
func (DecodedJWE) Length() int64 {
	return 7
}
func (DecodedJWE) IsAbsent() bool {
	return false
}
func (DecodedJWE) IsNull() bool {
	return false
}
func (DecodedJWE) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWE"}.AsBool()
}
func (DecodedJWE) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWE"}.AsInt()
}
func (DecodedJWE) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWE"}.AsFloat()
}
func (DecodedJWE) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWE"}.AsString()
}
func (DecodedJWE) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWE"}.AsBytes()
}
func (DecodedJWE) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWE"}.AsLink()
}
func (DecodedJWE) Prototype() datamodel.NodePrototype {
	return _DecodedJWE__Prototype{}
}

type _DecodedJWE__Prototype struct{}

func (_DecodedJWE__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _DecodedJWE__Builder
	nb.Reset()
	return &nb
}

type _DecodedJWE__Builder struct {
	_DecodedJWE__Assembler
}

func (nb *_DecodedJWE__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_DecodedJWE__Builder) Reset() {
	var w _DecodedJWE
	var m schema.Maybe
	*nb = _DecodedJWE__Builder{_DecodedJWE__Assembler{w: &w, m: &m}}
}

type _DecodedJWE__Assembler struct {
	w     *_DecodedJWE
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm             schema.Maybe
	ca_aad         _Base64Url__Assembler
	ca_ciphertext  _Base64Url__Assembler
	ca_iv          _Base64Url__Assembler
	ca_protected   _Base64Url__Assembler
	ca_recipients  _DecodedRecipients__Assembler
	ca_tag         _Base64Url__Assembler
	ca_unprotected _Any__Assembler
}

func (na *_DecodedJWE__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_aad.reset()
	na.ca_ciphertext.reset()
	na.ca_iv.reset()
	na.ca_protected.reset()
	na.ca_recipients.reset()
	na.ca_tag.reset()
	na.ca_unprotected.reset()
}

var (
	fieldBit__DecodedJWE_Aad         = 1 << 0
	fieldBit__DecodedJWE_Ciphertext  = 1 << 1
	fieldBit__DecodedJWE_Iv          = 1 << 2
	fieldBit__DecodedJWE_Protected   = 1 << 3
	fieldBit__DecodedJWE_Recipients  = 1 << 4
	fieldBit__DecodedJWE_Tag         = 1 << 5
	fieldBit__DecodedJWE_Unprotected = 1 << 6
	fieldBits__DecodedJWE_sufficient = 0 + 1<<1
)

func (na *_DecodedJWE__Assembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_DecodedJWE{}
	}
	return na, nil
}
func (_DecodedJWE__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE"}.BeginList(0)
}
func (na *_DecodedJWE__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_DecodedJWE__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE"}.AssignBool(false)
}
func (_DecodedJWE__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE"}.AssignInt(0)
}
func (_DecodedJWE__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE"}.AssignFloat(0)
}
func (_DecodedJWE__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE"}.AssignString("")
}
func (_DecodedJWE__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE"}.AssignBytes(nil)
}
func (_DecodedJWE__Assembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE"}.AssignLink(nil)
}
func (na *_DecodedJWE__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_DecodedJWE); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.DecodedJWE", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_DecodedJWE__Assembler) Prototype() datamodel.NodePrototype {
	return _DecodedJWE__Prototype{}
}
func (ma *_DecodedJWE__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.aad.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_ciphertext.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.w.iv.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 3:
		switch ma.w.protected.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 4:
		switch ma.w.recipients.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 5:
		switch ma.w.tag.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 6:
		switch ma.w.unprotected.m {
		case schema.Maybe_Value:
			ma.w.unprotected.v = ma.ca_unprotected.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedJWE__Assembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "aad":
		if ma.s&fieldBit__DecodedJWE_Aad != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Aad}
		}
		ma.s += fieldBit__DecodedJWE_Aad
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_aad.w = &ma.w.aad.v
		ma.ca_aad.m = &ma.w.aad.m
		return &ma.ca_aad, nil
	case "ciphertext":
		if ma.s&fieldBit__DecodedJWE_Ciphertext != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Ciphertext}
		}
		ma.s += fieldBit__DecodedJWE_Ciphertext
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_ciphertext.w = &ma.w.ciphertext
		ma.ca_ciphertext.m = &ma.cm
		return &ma.ca_ciphertext, nil
	case "iv":
		if ma.s&fieldBit__DecodedJWE_Iv != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Iv}
		}
		ma.s += fieldBit__DecodedJWE_Iv
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_iv.w = &ma.w.iv.v
		ma.ca_iv.m = &ma.w.iv.m
		return &ma.ca_iv, nil
	case "protected":
		if ma.s&fieldBit__DecodedJWE_Protected != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Protected}
		}
		ma.s += fieldBit__DecodedJWE_Protected
		ma.state = maState_midValue
		ma.f = 3
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m
		return &ma.ca_protected, nil
	case "recipients":
		if ma.s&fieldBit__DecodedJWE_Recipients != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Recipients}
		}
		ma.s += fieldBit__DecodedJWE_Recipients
		ma.state = maState_midValue
		ma.f = 4
		ma.ca_recipients.w = &ma.w.recipients.v
		ma.ca_recipients.m = &ma.w.recipients.m
		return &ma.ca_recipients, nil
	case "tag":
		if ma.s&fieldBit__DecodedJWE_Tag != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Tag}
		}
		ma.s += fieldBit__DecodedJWE_Tag
		ma.state = maState_midValue
		ma.f = 5
		ma.ca_tag.w = &ma.w.tag.v
		ma.ca_tag.m = &ma.w.tag.m
		return &ma.ca_tag, nil
	case "unprotected":
		if ma.s&fieldBit__DecodedJWE_Unprotected != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Unprotected}
		}
		ma.s += fieldBit__DecodedJWE_Unprotected
		ma.state = maState_midValue
		ma.f = 6
		ma.ca_unprotected.w = ma.w.unprotected.v
		ma.ca_unprotected.m = &ma.w.unprotected.m
		return &ma.ca_unprotected, nil
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.DecodedJWE", Key: &_String{k}}
}
func (ma *_DecodedJWE__Assembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_DecodedJWE__KeyAssembler)(ma)
}
func (ma *_DecodedJWE__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_aad.w = &ma.w.aad.v
		ma.ca_aad.m = &ma.w.aad.m
		return &ma.ca_aad
	case 1:
		ma.ca_ciphertext.w = &ma.w.ciphertext
		ma.ca_ciphertext.m = &ma.cm
		return &ma.ca_ciphertext
	case 2:
		ma.ca_iv.w = &ma.w.iv.v
		ma.ca_iv.m = &ma.w.iv.m
		return &ma.ca_iv
	case 3:
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m
		return &ma.ca_protected
	case 4:
		ma.ca_recipients.w = &ma.w.recipients.v
		ma.ca_recipients.m = &ma.w.recipients.m
		return &ma.ca_recipients
	case 5:
		ma.ca_tag.w = &ma.w.tag.v
		ma.ca_tag.m = &ma.w.tag.m
		return &ma.ca_tag
	case 6:
		ma.ca_unprotected.w = ma.w.unprotected.v
		ma.ca_unprotected.m = &ma.w.unprotected.m
		return &ma.ca_unprotected
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedJWE__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__DecodedJWE_sufficient != fieldBits__DecodedJWE_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__DecodedJWE_Ciphertext == 0 {
			err.Missing = append(err.Missing, "ciphertext")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_DecodedJWE__Assembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_DecodedJWE__Assembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _DecodedJWE__KeyAssembler _DecodedJWE__Assembler

func (_DecodedJWE__KeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.KeyAssembler"}.BeginMap(0)
}
func (_DecodedJWE__KeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.KeyAssembler"}.BeginList(0)
}
func (na *_DecodedJWE__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.KeyAssembler"}.AssignNull()
}
func (_DecodedJWE__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.KeyAssembler"}.AssignBool(false)
}
func (_DecodedJWE__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.KeyAssembler"}.AssignInt(0)
}
func (_DecodedJWE__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.KeyAssembler"}.AssignFloat(0)
}
func (ka *_DecodedJWE__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "aad":
		if ka.s&fieldBit__DecodedJWE_Aad != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Aad}
		}
		ka.s += fieldBit__DecodedJWE_Aad
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "ciphertext":
		if ka.s&fieldBit__DecodedJWE_Ciphertext != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Ciphertext}
		}
		ka.s += fieldBit__DecodedJWE_Ciphertext
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "iv":
		if ka.s&fieldBit__DecodedJWE_Iv != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Iv}
		}
		ka.s += fieldBit__DecodedJWE_Iv
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	case "protected":
		if ka.s&fieldBit__DecodedJWE_Protected != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Protected}
		}
		ka.s += fieldBit__DecodedJWE_Protected
		ka.state = maState_expectValue
		ka.f = 3
		return nil
	case "recipients":
		if ka.s&fieldBit__DecodedJWE_Recipients != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Recipients}
		}
		ka.s += fieldBit__DecodedJWE_Recipients
		ka.state = maState_expectValue
		ka.f = 4
		return nil
	case "tag":
		if ka.s&fieldBit__DecodedJWE_Tag != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Tag}
		}
		ka.s += fieldBit__DecodedJWE_Tag
		ka.state = maState_expectValue
		ka.f = 5
		return nil
	case "unprotected":
		if ka.s&fieldBit__DecodedJWE_Unprotected != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Unprotected}
		}
		ka.s += fieldBit__DecodedJWE_Unprotected
		ka.state = maState_expectValue
		ka.f = 6
		return nil
	default:
		return schema.ErrInvalidKey{TypeName: "dagjose.DecodedJWE", Key: &_String{k}}
	}
}
func (_DecodedJWE__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.KeyAssembler"}.AssignBytes(nil)
}
func (_DecodedJWE__KeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.KeyAssembler"}.AssignLink(nil)
}
func (ka *_DecodedJWE__KeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_DecodedJWE__KeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (DecodedJWE) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n DecodedJWE) Representation() datamodel.Node {
	return (*_DecodedJWE__Repr)(n)
}

type _DecodedJWE__Repr _DecodedJWE

var (
	fieldName__DecodedJWE_Aad_serial         = _String{"aad"}
	fieldName__DecodedJWE_Ciphertext_serial  = _String{"ciphertext"}
	fieldName__DecodedJWE_Iv_serial          = _String{"iv"}
	fieldName__DecodedJWE_Protected_serial   = _String{"protected"}
	fieldName__DecodedJWE_Recipients_serial  = _String{"recipients"}
	fieldName__DecodedJWE_Tag_serial         = _String{"tag"}
	fieldName__DecodedJWE_Unprotected_serial = _String{"unprotected"}
)
var _ datamodel.Node = &_DecodedJWE__Repr{}

func (_DecodedJWE__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n *_DecodedJWE__Repr) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "aad":
		if n.aad.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.aad.v.Representation(), nil
	case "ciphertext":
		return n.ciphertext.Representation(), nil
	case "iv":
		if n.iv.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.iv.v.Representation(), nil
	case "protected":
		if n.protected.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.protected.v.Representation(), nil
	case "recipients":
		if n.recipients.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.recipients.v.Representation(), nil
	case "tag":
		if n.tag.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.tag.v.Representation(), nil
	case "unprotected":
		if n.unprotected.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.unprotected.v.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n *_DecodedJWE__Repr) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_DecodedJWE__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWE.Repr"}.LookupByIndex(0)
}
func (n _DecodedJWE__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_DecodedJWE__Repr) MapIterator() datamodel.MapIterator {
	end := 7
	if n.unprotected.m == schema.Maybe_Absent {
		end = 6
	} else {
		goto done
	}
	if n.tag.m == schema.Maybe_Absent {
		end = 5
	} else {
		goto done
	}
	if n.recipients.m == schema.Maybe_Absent {
		end = 4
	} else {
		goto done
	}
	if n.protected.m == schema.Maybe_Absent {
		end = 3
	} else {
		goto done
	}
	if n.iv.m == schema.Maybe_Absent {
		end = 2
	} else {
		goto done
	}
done:
	return &_DecodedJWE__ReprMapItr{n, 0, end}
}

type _DecodedJWE__ReprMapItr struct {
	n   *_DecodedJWE__Repr
	idx int
	end int
}

func (itr *_DecodedJWE__ReprMapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
advance:
	if itr.idx >= 7 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__DecodedJWE_Aad_serial
		if itr.n.aad.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.aad.v.Representation()
	case 1:
		k = &fieldName__DecodedJWE_Ciphertext_serial
		v = itr.n.ciphertext.Representation()
	case 2:
		k = &fieldName__DecodedJWE_Iv_serial
		if itr.n.iv.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.iv.v.Representation()
	case 3:
		k = &fieldName__DecodedJWE_Protected_serial
		if itr.n.protected.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.protected.v.Representation()
	case 4:
		k = &fieldName__DecodedJWE_Recipients_serial
		if itr.n.recipients.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.recipients.v.Representation()
	case 5:
		k = &fieldName__DecodedJWE_Tag_serial
		if itr.n.tag.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.tag.v.Representation()
	case 6:
		k = &fieldName__DecodedJWE_Unprotected_serial
		if itr.n.unprotected.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.unprotected.v.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_DecodedJWE__ReprMapItr) Done() bool {
	return itr.idx >= itr.end
}
func (_DecodedJWE__Repr) ListIterator() datamodel.ListIterator {
	return nil
}
func (rn *_DecodedJWE__Repr) Length() int64 {
	l := 7
	if rn.aad.m == schema.Maybe_Absent {
		l--
	}
	if rn.iv.m == schema.Maybe_Absent {
		l--
	}
	if rn.protected.m == schema.Maybe_Absent {
		l--
	}
	if rn.recipients.m == schema.Maybe_Absent {
		l--
	}
	if rn.tag.m == schema.Maybe_Absent {
		l--
	}
	if rn.unprotected.m == schema.Maybe_Absent {
		l--
	}
	return int64(l)
}
func (_DecodedJWE__Repr) IsAbsent() bool {
	return false
}
func (_DecodedJWE__Repr) IsNull() bool {
	return false
}
func (_DecodedJWE__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWE.Repr"}.AsBool()
}
func (_DecodedJWE__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWE.Repr"}.AsInt()
}
func (_DecodedJWE__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWE.Repr"}.AsFloat()
}
func (_DecodedJWE__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWE.Repr"}.AsString()
}
func (_DecodedJWE__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWE.Repr"}.AsBytes()
}
func (_DecodedJWE__Repr) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWE.Repr"}.AsLink()
}
func (_DecodedJWE__Repr) Prototype() datamodel.NodePrototype {
	return _DecodedJWE__ReprPrototype{}
}

type _DecodedJWE__ReprPrototype struct{}

func (_DecodedJWE__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _DecodedJWE__ReprBuilder
	nb.Reset()
	return &nb
}

type _DecodedJWE__ReprBuilder struct {
	_DecodedJWE__ReprAssembler
}

func (nb *_DecodedJWE__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_DecodedJWE__ReprBuilder) Reset() {
	var w _DecodedJWE
	var m schema.Maybe
	*nb = _DecodedJWE__ReprBuilder{_DecodedJWE__ReprAssembler{w: &w, m: &m}}
}

type _DecodedJWE__ReprAssembler struct {
	w     *_DecodedJWE
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm             schema.Maybe
	ca_aad         _Base64Url__ReprAssembler
	ca_ciphertext  _Base64Url__ReprAssembler
	ca_iv          _Base64Url__ReprAssembler
	ca_protected   _Base64Url__ReprAssembler
	ca_recipients  _DecodedRecipients__ReprAssembler
	ca_tag         _Base64Url__ReprAssembler
	ca_unprotected _Any__ReprAssembler
}

func (na *_DecodedJWE__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_aad.reset()
	na.ca_ciphertext.reset()
	na.ca_iv.reset()
	na.ca_protected.reset()
	na.ca_recipients.reset()
	na.ca_tag.reset()
	na.ca_unprotected.reset()
}
func (na *_DecodedJWE__ReprAssembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_DecodedJWE{}
	}
	return na, nil
}
func (_DecodedJWE__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE.Repr"}.BeginList(0)
}
func (na *_DecodedJWE__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_DecodedJWE__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE.Repr"}.AssignBool(false)
}
func (_DecodedJWE__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE.Repr"}.AssignInt(0)
}
func (_DecodedJWE__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE.Repr"}.AssignFloat(0)
}
func (_DecodedJWE__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE.Repr"}.AssignString("")
}
func (_DecodedJWE__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE.Repr"}.AssignBytes(nil)
}
func (_DecodedJWE__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWE.Repr"}.AssignLink(nil)
}
func (na *_DecodedJWE__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_DecodedJWE); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.DecodedJWE.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_DecodedJWE__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _DecodedJWE__ReprPrototype{}
}
func (ma *_DecodedJWE__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.aad.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.w.iv.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 3:
		switch ma.w.protected.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 4:
		switch ma.w.recipients.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 5:
		switch ma.w.tag.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 6:
		switch ma.w.unprotected.m {
		case schema.Maybe_Value:
			ma.w.unprotected.v = ma.ca_unprotected.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedJWE__ReprAssembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "aad":
		if ma.s&fieldBit__DecodedJWE_Aad != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Aad_serial}
		}
		ma.s += fieldBit__DecodedJWE_Aad
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_aad.w = &ma.w.aad.v
		ma.ca_aad.m = &ma.w.aad.m

		return &ma.ca_aad, nil
	case "ciphertext":
		if ma.s&fieldBit__DecodedJWE_Ciphertext != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Ciphertext_serial}
		}
		ma.s += fieldBit__DecodedJWE_Ciphertext
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_ciphertext.w = &ma.w.ciphertext
		ma.ca_ciphertext.m = &ma.cm
		return &ma.ca_ciphertext, nil
	case "iv":
		if ma.s&fieldBit__DecodedJWE_Iv != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Iv_serial}
		}
		ma.s += fieldBit__DecodedJWE_Iv
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_iv.w = &ma.w.iv.v
		ma.ca_iv.m = &ma.w.iv.m

		return &ma.ca_iv, nil
	case "protected":
		if ma.s&fieldBit__DecodedJWE_Protected != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Protected_serial}
		}
		ma.s += fieldBit__DecodedJWE_Protected
		ma.state = maState_midValue
		ma.f = 3
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m

		return &ma.ca_protected, nil
	case "recipients":
		if ma.s&fieldBit__DecodedJWE_Recipients != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Recipients_serial}
		}
		ma.s += fieldBit__DecodedJWE_Recipients
		ma.state = maState_midValue
		ma.f = 4
		ma.ca_recipients.w = &ma.w.recipients.v
		ma.ca_recipients.m = &ma.w.recipients.m

		return &ma.ca_recipients, nil
	case "tag":
		if ma.s&fieldBit__DecodedJWE_Tag != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Tag_serial}
		}
		ma.s += fieldBit__DecodedJWE_Tag
		ma.state = maState_midValue
		ma.f = 5
		ma.ca_tag.w = &ma.w.tag.v
		ma.ca_tag.m = &ma.w.tag.m

		return &ma.ca_tag, nil
	case "unprotected":
		if ma.s&fieldBit__DecodedJWE_Unprotected != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Unprotected_serial}
		}
		ma.s += fieldBit__DecodedJWE_Unprotected
		ma.state = maState_midValue
		ma.f = 6
		ma.ca_unprotected.w = ma.w.unprotected.v
		ma.ca_unprotected.m = &ma.w.unprotected.m

		return &ma.ca_unprotected, nil
	default:
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.DecodedJWE.Repr", Key: &_String{k}}
}
func (ma *_DecodedJWE__ReprAssembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_DecodedJWE__ReprKeyAssembler)(ma)
}
func (ma *_DecodedJWE__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_aad.w = &ma.w.aad.v
		ma.ca_aad.m = &ma.w.aad.m

		return &ma.ca_aad
	case 1:
		ma.ca_ciphertext.w = &ma.w.ciphertext
		ma.ca_ciphertext.m = &ma.cm
		return &ma.ca_ciphertext
	case 2:
		ma.ca_iv.w = &ma.w.iv.v
		ma.ca_iv.m = &ma.w.iv.m

		return &ma.ca_iv
	case 3:
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m

		return &ma.ca_protected
	case 4:
		ma.ca_recipients.w = &ma.w.recipients.v
		ma.ca_recipients.m = &ma.w.recipients.m

		return &ma.ca_recipients
	case 5:
		ma.ca_tag.w = &ma.w.tag.v
		ma.ca_tag.m = &ma.w.tag.m

		return &ma.ca_tag
	case 6:
		ma.ca_unprotected.w = ma.w.unprotected.v
		ma.ca_unprotected.m = &ma.w.unprotected.m

		return &ma.ca_unprotected
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedJWE__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__DecodedJWE_sufficient != fieldBits__DecodedJWE_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__DecodedJWE_Ciphertext == 0 {
			err.Missing = append(err.Missing, "ciphertext")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_DecodedJWE__ReprAssembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_DecodedJWE__ReprAssembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _DecodedJWE__ReprKeyAssembler _DecodedJWE__ReprAssembler

func (_DecodedJWE__ReprKeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.Repr.KeyAssembler"}.BeginMap(0)
}
func (_DecodedJWE__ReprKeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_DecodedJWE__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.Repr.KeyAssembler"}.AssignNull()
}
func (_DecodedJWE__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.Repr.KeyAssembler"}.AssignBool(false)
}
func (_DecodedJWE__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.Repr.KeyAssembler"}.AssignInt(0)
}
func (_DecodedJWE__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_DecodedJWE__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "aad":
		if ka.s&fieldBit__DecodedJWE_Aad != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Aad_serial}
		}
		ka.s += fieldBit__DecodedJWE_Aad
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "ciphertext":
		if ka.s&fieldBit__DecodedJWE_Ciphertext != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Ciphertext_serial}
		}
		ka.s += fieldBit__DecodedJWE_Ciphertext
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "iv":
		if ka.s&fieldBit__DecodedJWE_Iv != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Iv_serial}
		}
		ka.s += fieldBit__DecodedJWE_Iv
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	case "protected":
		if ka.s&fieldBit__DecodedJWE_Protected != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Protected_serial}
		}
		ka.s += fieldBit__DecodedJWE_Protected
		ka.state = maState_expectValue
		ka.f = 3
		return nil
	case "recipients":
		if ka.s&fieldBit__DecodedJWE_Recipients != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Recipients_serial}
		}
		ka.s += fieldBit__DecodedJWE_Recipients
		ka.state = maState_expectValue
		ka.f = 4
		return nil
	case "tag":
		if ka.s&fieldBit__DecodedJWE_Tag != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Tag_serial}
		}
		ka.s += fieldBit__DecodedJWE_Tag
		ka.state = maState_expectValue
		ka.f = 5
		return nil
	case "unprotected":
		if ka.s&fieldBit__DecodedJWE_Unprotected != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWE_Unprotected_serial}
		}
		ka.s += fieldBit__DecodedJWE_Unprotected
		ka.state = maState_expectValue
		ka.f = 6
		return nil
	}
	return schema.ErrInvalidKey{TypeName: "dagjose.DecodedJWE.Repr", Key: &_String{k}}
}
func (_DecodedJWE__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_DecodedJWE__ReprKeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWE.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_DecodedJWE__ReprKeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_DecodedJWE__ReprKeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}

func (n _DecodedJWS) FieldLink() MaybeLink {
	return &n.link
}
func (n _DecodedJWS) FieldPayload() Base64Url {
	return &n.payload
}
func (n _DecodedJWS) FieldSignatures() MaybeDecodedSignatures {
	return &n.signatures
}

type _DecodedJWS__Maybe struct {
	m schema.Maybe
	v DecodedJWS
}
type MaybeDecodedJWS = *_DecodedJWS__Maybe

func (m MaybeDecodedJWS) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeDecodedJWS) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeDecodedJWS) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeDecodedJWS) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeDecodedJWS) Must() DecodedJWS {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__DecodedJWS_Link       = _String{"link"}
	fieldName__DecodedJWS_Payload    = _String{"payload"}
	fieldName__DecodedJWS_Signatures = _String{"signatures"}
)
var _ datamodel.Node = (DecodedJWS)(&_DecodedJWS{})
var _ schema.TypedNode = (DecodedJWS)(&_DecodedJWS{})

func (DecodedJWS) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n DecodedJWS) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "link":
		if n.link.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.link.v, nil
	case "payload":
		return &n.payload, nil
	case "signatures":
		if n.signatures.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.signatures.v, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n DecodedJWS) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (DecodedJWS) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWS"}.LookupByIndex(0)
}
func (n DecodedJWS) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n DecodedJWS) MapIterator() datamodel.MapIterator {
	return &_DecodedJWS__MapItr{n, 0}
}

type _DecodedJWS__MapItr struct {
	n   DecodedJWS
	idx int
}

func (itr *_DecodedJWS__MapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
	if itr.idx >= 3 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__DecodedJWS_Link
		if itr.n.link.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.link.v
	case 1:
		k = &fieldName__DecodedJWS_Payload
		v = &itr.n.payload
	case 2:
		k = &fieldName__DecodedJWS_Signatures
		if itr.n.signatures.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.signatures.v
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_DecodedJWS__MapItr) Done() bool {
	return itr.idx >= 3
}

func (DecodedJWS) ListIterator() datamodel.ListIterator {
	return nil
}
func (DecodedJWS) Length() int64 {
	return 3
}
func (DecodedJWS) IsAbsent() bool {
	return false
}
func (DecodedJWS) IsNull() bool {
	return false
}
func (DecodedJWS) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWS"}.AsBool()
}
func (DecodedJWS) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWS"}.AsInt()
}
func (DecodedJWS) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWS"}.AsFloat()
}
func (DecodedJWS) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWS"}.AsString()
}
func (DecodedJWS) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWS"}.AsBytes()
}
func (DecodedJWS) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWS"}.AsLink()
}
func (DecodedJWS) Prototype() datamodel.NodePrototype {
	return _DecodedJWS__Prototype{}
}

type _DecodedJWS__Prototype struct{}

func (_DecodedJWS__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _DecodedJWS__Builder
	nb.Reset()
	return &nb
}

type _DecodedJWS__Builder struct {
	_DecodedJWS__Assembler
}

func (nb *_DecodedJWS__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_DecodedJWS__Builder) Reset() {
	var w _DecodedJWS
	var m schema.Maybe
	*nb = _DecodedJWS__Builder{_DecodedJWS__Assembler{w: &w, m: &m}}
}

type _DecodedJWS__Assembler struct {
	w     *_DecodedJWS
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm            schema.Maybe
	ca_link       _Link__Assembler
	ca_payload    _Base64Url__Assembler
	ca_signatures _DecodedSignatures__Assembler
}

func (na *_DecodedJWS__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_link.reset()
	na.ca_payload.reset()
	na.ca_signatures.reset()
}

var (
	fieldBit__DecodedJWS_Link        = 1 << 0
	fieldBit__DecodedJWS_Payload     = 1 << 1
	fieldBit__DecodedJWS_Signatures  = 1 << 2
	fieldBits__DecodedJWS_sufficient = 0 + 1<<1
)

func (na *_DecodedJWS__Assembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_DecodedJWS{}
	}
	return na, nil
}
func (_DecodedJWS__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS"}.BeginList(0)
}
func (na *_DecodedJWS__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_DecodedJWS__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS"}.AssignBool(false)
}
func (_DecodedJWS__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS"}.AssignInt(0)
}
func (_DecodedJWS__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS"}.AssignFloat(0)
}
func (_DecodedJWS__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS"}.AssignString("")
}
func (_DecodedJWS__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS"}.AssignBytes(nil)
}
func (_DecodedJWS__Assembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS"}.AssignLink(nil)
}
func (na *_DecodedJWS__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_DecodedJWS); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.DecodedJWS", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_DecodedJWS__Assembler) Prototype() datamodel.NodePrototype {
	return _DecodedJWS__Prototype{}
}
func (ma *_DecodedJWS__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.link.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_payload.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.w.signatures.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedJWS__Assembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "link":
		if ma.s&fieldBit__DecodedJWS_Link != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWS_Link}
		}
		ma.s += fieldBit__DecodedJWS_Link
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_link.w = &ma.w.link.v
		ma.ca_link.m = &ma.w.link.m
		return &ma.ca_link, nil
	case "payload":
		if ma.s&fieldBit__DecodedJWS_Payload != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWS_Payload}
		}
		ma.s += fieldBit__DecodedJWS_Payload
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_payload.w = &ma.w.payload
		ma.ca_payload.m = &ma.cm
		return &ma.ca_payload, nil
	case "signatures":
		if ma.s&fieldBit__DecodedJWS_Signatures != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWS_Signatures}
		}
		ma.s += fieldBit__DecodedJWS_Signatures
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_signatures.w = &ma.w.signatures.v
		ma.ca_signatures.m = &ma.w.signatures.m
		return &ma.ca_signatures, nil
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.DecodedJWS", Key: &_String{k}}
}
func (ma *_DecodedJWS__Assembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_DecodedJWS__KeyAssembler)(ma)
}
func (ma *_DecodedJWS__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_link.w = &ma.w.link.v
		ma.ca_link.m = &ma.w.link.m
		return &ma.ca_link
	case 1:
		ma.ca_payload.w = &ma.w.payload
		ma.ca_payload.m = &ma.cm
		return &ma.ca_payload
	case 2:
		ma.ca_signatures.w = &ma.w.signatures.v
		ma.ca_signatures.m = &ma.w.signatures.m
		return &ma.ca_signatures
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedJWS__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__DecodedJWS_sufficient != fieldBits__DecodedJWS_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__DecodedJWS_Payload == 0 {
			err.Missing = append(err.Missing, "payload")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_DecodedJWS__Assembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_DecodedJWS__Assembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _DecodedJWS__KeyAssembler _DecodedJWS__Assembler

func (_DecodedJWS__KeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.KeyAssembler"}.BeginMap(0)
}
func (_DecodedJWS__KeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.KeyAssembler"}.BeginList(0)
}
func (na *_DecodedJWS__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.KeyAssembler"}.AssignNull()
}
func (_DecodedJWS__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.KeyAssembler"}.AssignBool(false)
}
func (_DecodedJWS__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.KeyAssembler"}.AssignInt(0)
}
func (_DecodedJWS__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.KeyAssembler"}.AssignFloat(0)
}
func (ka *_DecodedJWS__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "link":
		if ka.s&fieldBit__DecodedJWS_Link != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWS_Link}
		}
		ka.s += fieldBit__DecodedJWS_Link
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "payload":
		if ka.s&fieldBit__DecodedJWS_Payload != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWS_Payload}
		}
		ka.s += fieldBit__DecodedJWS_Payload
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "signatures":
		if ka.s&fieldBit__DecodedJWS_Signatures != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWS_Signatures}
		}
		ka.s += fieldBit__DecodedJWS_Signatures
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	default:
		return schema.ErrInvalidKey{TypeName: "dagjose.DecodedJWS", Key: &_String{k}}
	}
}
func (_DecodedJWS__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.KeyAssembler"}.AssignBytes(nil)
}
func (_DecodedJWS__KeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.KeyAssembler"}.AssignLink(nil)
}
func (ka *_DecodedJWS__KeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_DecodedJWS__KeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (DecodedJWS) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n DecodedJWS) Representation() datamodel.Node {
	return (*_DecodedJWS__Repr)(n)
}

type _DecodedJWS__Repr _DecodedJWS

var (
	fieldName__DecodedJWS_Link_serial       = _String{"link"}
	fieldName__DecodedJWS_Payload_serial    = _String{"payload"}
	fieldName__DecodedJWS_Signatures_serial = _String{"signatures"}
)
var _ datamodel.Node = &_DecodedJWS__Repr{}

func (_DecodedJWS__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n *_DecodedJWS__Repr) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "link":
		if n.link.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.link.v.Representation(), nil
	case "payload":
		return n.payload.Representation(), nil
	case "signatures":
		if n.signatures.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.signatures.v.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n *_DecodedJWS__Repr) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_DecodedJWS__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWS.Repr"}.LookupByIndex(0)
}
func (n _DecodedJWS__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_DecodedJWS__Repr) MapIterator() datamodel.MapIterator {
	end := 3
	if n.signatures.m == schema.Maybe_Absent {
		end = 2
	} else {
		goto done
	}
done:
	return &_DecodedJWS__ReprMapItr{n, 0, end}
}

type _DecodedJWS__ReprMapItr struct {
	n   *_DecodedJWS__Repr
	idx int
	end int
}

func (itr *_DecodedJWS__ReprMapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
advance:
	if itr.idx >= 3 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__DecodedJWS_Link_serial
		if itr.n.link.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.link.v.Representation()
	case 1:
		k = &fieldName__DecodedJWS_Payload_serial
		v = itr.n.payload.Representation()
	case 2:
		k = &fieldName__DecodedJWS_Signatures_serial
		if itr.n.signatures.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.signatures.v.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_DecodedJWS__ReprMapItr) Done() bool {
	return itr.idx >= itr.end
}
func (_DecodedJWS__Repr) ListIterator() datamodel.ListIterator {
	return nil
}
func (rn *_DecodedJWS__Repr) Length() int64 {
	l := 3
	if rn.link.m == schema.Maybe_Absent {
		l--
	}
	if rn.signatures.m == schema.Maybe_Absent {
		l--
	}
	return int64(l)
}
func (_DecodedJWS__Repr) IsAbsent() bool {
	return false
}
func (_DecodedJWS__Repr) IsNull() bool {
	return false
}
func (_DecodedJWS__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWS.Repr"}.AsBool()
}
func (_DecodedJWS__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWS.Repr"}.AsInt()
}
func (_DecodedJWS__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWS.Repr"}.AsFloat()
}
func (_DecodedJWS__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWS.Repr"}.AsString()
}
func (_DecodedJWS__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWS.Repr"}.AsBytes()
}
func (_DecodedJWS__Repr) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.DecodedJWS.Repr"}.AsLink()
}
func (_DecodedJWS__Repr) Prototype() datamodel.NodePrototype {
	return _DecodedJWS__ReprPrototype{}
}

type _DecodedJWS__ReprPrototype struct{}

func (_DecodedJWS__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _DecodedJWS__ReprBuilder
	nb.Reset()
	return &nb
}

type _DecodedJWS__ReprBuilder struct {
	_DecodedJWS__ReprAssembler
}

func (nb *_DecodedJWS__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_DecodedJWS__ReprBuilder) Reset() {
	var w _DecodedJWS
	var m schema.Maybe
	*nb = _DecodedJWS__ReprBuilder{_DecodedJWS__ReprAssembler{w: &w, m: &m}}
}

type _DecodedJWS__ReprAssembler struct {
	w     *_DecodedJWS
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm            schema.Maybe
	ca_link       _Link__ReprAssembler
	ca_payload    _Base64Url__ReprAssembler
	ca_signatures _DecodedSignatures__ReprAssembler
}

func (na *_DecodedJWS__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_link.reset()
	na.ca_payload.reset()
	na.ca_signatures.reset()
}
func (na *_DecodedJWS__ReprAssembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_DecodedJWS{}
	}
	return na, nil
}
func (_DecodedJWS__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS.Repr"}.BeginList(0)
}
func (na *_DecodedJWS__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_DecodedJWS__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS.Repr"}.AssignBool(false)
}
func (_DecodedJWS__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS.Repr"}.AssignInt(0)
}
func (_DecodedJWS__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS.Repr"}.AssignFloat(0)
}
func (_DecodedJWS__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS.Repr"}.AssignString("")
}
func (_DecodedJWS__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS.Repr"}.AssignBytes(nil)
}
func (_DecodedJWS__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedJWS.Repr"}.AssignLink(nil)
}
func (na *_DecodedJWS__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_DecodedJWS); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.DecodedJWS.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_DecodedJWS__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _DecodedJWS__ReprPrototype{}
}
func (ma *_DecodedJWS__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.link.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.w.signatures.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedJWS__ReprAssembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "link":
		if ma.s&fieldBit__DecodedJWS_Link != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWS_Link_serial}
		}
		ma.s += fieldBit__DecodedJWS_Link
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_link.w = &ma.w.link.v
		ma.ca_link.m = &ma.w.link.m

		return &ma.ca_link, nil
	case "payload":
		if ma.s&fieldBit__DecodedJWS_Payload != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWS_Payload_serial}
		}
		ma.s += fieldBit__DecodedJWS_Payload
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_payload.w = &ma.w.payload
		ma.ca_payload.m = &ma.cm
		return &ma.ca_payload, nil
	case "signatures":
		if ma.s&fieldBit__DecodedJWS_Signatures != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWS_Signatures_serial}
		}
		ma.s += fieldBit__DecodedJWS_Signatures
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_signatures.w = &ma.w.signatures.v
		ma.ca_signatures.m = &ma.w.signatures.m

		return &ma.ca_signatures, nil
	default:
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.DecodedJWS.Repr", Key: &_String{k}}
}
func (ma *_DecodedJWS__ReprAssembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_DecodedJWS__ReprKeyAssembler)(ma)
}
func (ma *_DecodedJWS__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_link.w = &ma.w.link.v
		ma.ca_link.m = &ma.w.link.m

		return &ma.ca_link
	case 1:
		ma.ca_payload.w = &ma.w.payload
		ma.ca_payload.m = &ma.cm
		return &ma.ca_payload
	case 2:
		ma.ca_signatures.w = &ma.w.signatures.v
		ma.ca_signatures.m = &ma.w.signatures.m

		return &ma.ca_signatures
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedJWS__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__DecodedJWS_sufficient != fieldBits__DecodedJWS_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__DecodedJWS_Payload == 0 {
			err.Missing = append(err.Missing, "payload")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_DecodedJWS__ReprAssembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_DecodedJWS__ReprAssembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _DecodedJWS__ReprKeyAssembler _DecodedJWS__ReprAssembler

func (_DecodedJWS__ReprKeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.Repr.KeyAssembler"}.BeginMap(0)
}
func (_DecodedJWS__ReprKeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_DecodedJWS__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.Repr.KeyAssembler"}.AssignNull()
}
func (_DecodedJWS__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.Repr.KeyAssembler"}.AssignBool(false)
}
func (_DecodedJWS__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.Repr.KeyAssembler"}.AssignInt(0)
}
func (_DecodedJWS__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_DecodedJWS__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "link":
		if ka.s&fieldBit__DecodedJWS_Link != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWS_Link_serial}
		}
		ka.s += fieldBit__DecodedJWS_Link
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "payload":
		if ka.s&fieldBit__DecodedJWS_Payload != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWS_Payload_serial}
		}
		ka.s += fieldBit__DecodedJWS_Payload
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "signatures":
		if ka.s&fieldBit__DecodedJWS_Signatures != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedJWS_Signatures_serial}
		}
		ka.s += fieldBit__DecodedJWS_Signatures
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	}
	return schema.ErrInvalidKey{TypeName: "dagjose.DecodedJWS.Repr", Key: &_String{k}}
}
func (_DecodedJWS__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_DecodedJWS__ReprKeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedJWS.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_DecodedJWS__ReprKeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_DecodedJWS__ReprKeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}

func (n _DecodedRecipient) FieldHeader() MaybeAny {
	return &n.header
}
func (n _DecodedRecipient) FieldEncrypted_key() MaybeBase64Url {
	return &n.encrypted_key
}

type _DecodedRecipient__Maybe struct {
	m schema.Maybe
	v DecodedRecipient
}
type MaybeDecodedRecipient = *_DecodedRecipient__Maybe

func (m MaybeDecodedRecipient) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeDecodedRecipient) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeDecodedRecipient) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeDecodedRecipient) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeDecodedRecipient) Must() DecodedRecipient {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__DecodedRecipient_Header        = _String{"header"}
	fieldName__DecodedRecipient_Encrypted_key = _String{"encrypted_key"}
)
var _ datamodel.Node = (DecodedRecipient)(&_DecodedRecipient{})
var _ schema.TypedNode = (DecodedRecipient)(&_DecodedRecipient{})

func (DecodedRecipient) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n DecodedRecipient) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "header":
		if n.header.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return n.header.v, nil
	case "encrypted_key":
		if n.encrypted_key.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.encrypted_key.v, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n DecodedRecipient) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (DecodedRecipient) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.DecodedRecipient"}.LookupByIndex(0)
}
func (n DecodedRecipient) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n DecodedRecipient) MapIterator() datamodel.MapIterator {
	return &_DecodedRecipient__MapItr{n, 0}
}

type _DecodedRecipient__MapItr struct {
	n   DecodedRecipient
	idx int
}

func (itr *_DecodedRecipient__MapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
	if itr.idx >= 2 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__DecodedRecipient_Header
		if itr.n.header.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = itr.n.header.v
	case 1:
		k = &fieldName__DecodedRecipient_Encrypted_key
		if itr.n.encrypted_key.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.encrypted_key.v
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_DecodedRecipient__MapItr) Done() bool {
	return itr.idx >= 2
}

func (DecodedRecipient) ListIterator() datamodel.ListIterator {
	return nil
}
func (DecodedRecipient) Length() int64 {
	return 2
}
func (DecodedRecipient) IsAbsent() bool {
	return false
}
func (DecodedRecipient) IsNull() bool {
	return false
}
func (DecodedRecipient) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.DecodedRecipient"}.AsBool()
}
func (DecodedRecipient) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedRecipient"}.AsInt()
}
func (DecodedRecipient) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedRecipient"}.AsFloat()
}
func (DecodedRecipient) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.DecodedRecipient"}.AsString()
}
func (DecodedRecipient) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.DecodedRecipient"}.AsBytes()
}
func (DecodedRecipient) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.DecodedRecipient"}.AsLink()
}
func (DecodedRecipient) Prototype() datamodel.NodePrototype {
	return _DecodedRecipient__Prototype{}
}

type _DecodedRecipient__Prototype struct{}

func (_DecodedRecipient__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _DecodedRecipient__Builder
	nb.Reset()
	return &nb
}

type _DecodedRecipient__Builder struct {
	_DecodedRecipient__Assembler
}

func (nb *_DecodedRecipient__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_DecodedRecipient__Builder) Reset() {
	var w _DecodedRecipient
	var m schema.Maybe
	*nb = _DecodedRecipient__Builder{_DecodedRecipient__Assembler{w: &w, m: &m}}
}

type _DecodedRecipient__Assembler struct {
	w     *_DecodedRecipient
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm               schema.Maybe
	ca_header        _Any__Assembler
	ca_encrypted_key _Base64Url__Assembler
}

func (na *_DecodedRecipient__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_header.reset()
	na.ca_encrypted_key.reset()
}

var (
	fieldBit__DecodedRecipient_Header        = 1 << 0
	fieldBit__DecodedRecipient_Encrypted_key = 1 << 1
	fieldBits__DecodedRecipient_sufficient   = 0
)

func (na *_DecodedRecipient__Assembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_DecodedRecipient{}
	}
	return na, nil
}
func (_DecodedRecipient__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient"}.BeginList(0)
}
func (na *_DecodedRecipient__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_DecodedRecipient__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient"}.AssignBool(false)
}
func (_DecodedRecipient__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient"}.AssignInt(0)
}
func (_DecodedRecipient__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient"}.AssignFloat(0)
}
func (_DecodedRecipient__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient"}.AssignString("")
}
func (_DecodedRecipient__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient"}.AssignBytes(nil)
}
func (_DecodedRecipient__Assembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient"}.AssignLink(nil)
}
func (na *_DecodedRecipient__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_DecodedRecipient); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.DecodedRecipient", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_DecodedRecipient__Assembler) Prototype() datamodel.NodePrototype {
	return _DecodedRecipient__Prototype{}
}
func (ma *_DecodedRecipient__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.header.m {
		case schema.Maybe_Value:
			ma.w.header.v = ma.ca_header.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.encrypted_key.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedRecipient__Assembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "header":
		if ma.s&fieldBit__DecodedRecipient_Header != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedRecipient_Header}
		}
		ma.s += fieldBit__DecodedRecipient_Header
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m
		return &ma.ca_header, nil
	case "encrypted_key":
		if ma.s&fieldBit__DecodedRecipient_Encrypted_key != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedRecipient_Encrypted_key}
		}
		ma.s += fieldBit__DecodedRecipient_Encrypted_key
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_encrypted_key.w = &ma.w.encrypted_key.v
		ma.ca_encrypted_key.m = &ma.w.encrypted_key.m
		return &ma.ca_encrypted_key, nil
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.DecodedRecipient", Key: &_String{k}}
}
func (ma *_DecodedRecipient__Assembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_DecodedRecipient__KeyAssembler)(ma)
}
func (ma *_DecodedRecipient__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m
		return &ma.ca_header
	case 1:
		ma.ca_encrypted_key.w = &ma.w.encrypted_key.v
		ma.ca_encrypted_key.m = &ma.w.encrypted_key.m
		return &ma.ca_encrypted_key
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedRecipient__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__DecodedRecipient_sufficient != fieldBits__DecodedRecipient_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_DecodedRecipient__Assembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_DecodedRecipient__Assembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _DecodedRecipient__KeyAssembler _DecodedRecipient__Assembler

func (_DecodedRecipient__KeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.KeyAssembler"}.BeginMap(0)
}
func (_DecodedRecipient__KeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.KeyAssembler"}.BeginList(0)
}
func (na *_DecodedRecipient__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.KeyAssembler"}.AssignNull()
}
func (_DecodedRecipient__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.KeyAssembler"}.AssignBool(false)
}
func (_DecodedRecipient__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.KeyAssembler"}.AssignInt(0)
}
func (_DecodedRecipient__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.KeyAssembler"}.AssignFloat(0)
}
func (ka *_DecodedRecipient__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "header":
		if ka.s&fieldBit__DecodedRecipient_Header != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedRecipient_Header}
		}
		ka.s += fieldBit__DecodedRecipient_Header
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "encrypted_key":
		if ka.s&fieldBit__DecodedRecipient_Encrypted_key != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedRecipient_Encrypted_key}
		}
		ka.s += fieldBit__DecodedRecipient_Encrypted_key
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	default:
		return schema.ErrInvalidKey{TypeName: "dagjose.DecodedRecipient", Key: &_String{k}}
	}
}
func (_DecodedRecipient__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.KeyAssembler"}.AssignBytes(nil)
}
func (_DecodedRecipient__KeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.KeyAssembler"}.AssignLink(nil)
}
func (ka *_DecodedRecipient__KeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_DecodedRecipient__KeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (DecodedRecipient) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n DecodedRecipient) Representation() datamodel.Node {
	return (*_DecodedRecipient__Repr)(n)
}

type _DecodedRecipient__Repr _DecodedRecipient

var (
	fieldName__DecodedRecipient_Header_serial        = _String{"header"}
	fieldName__DecodedRecipient_Encrypted_key_serial = _String{"encrypted_key"}
)
var _ datamodel.Node = &_DecodedRecipient__Repr{}

func (_DecodedRecipient__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n *_DecodedRecipient__Repr) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "header":
		if n.header.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.header.v.Representation(), nil
	case "encrypted_key":
		if n.encrypted_key.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.encrypted_key.v.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n *_DecodedRecipient__Repr) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_DecodedRecipient__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.DecodedRecipient.Repr"}.LookupByIndex(0)
}
func (n _DecodedRecipient__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_DecodedRecipient__Repr) MapIterator() datamodel.MapIterator {
	end := 2
	if n.encrypted_key.m == schema.Maybe_Absent {
		end = 1
	} else {
		goto done
	}
	if n.header.m == schema.Maybe_Absent {
		end = 0
	} else {
		goto done
	}
done:
	return &_DecodedRecipient__ReprMapItr{n, 0, end}
}

type _DecodedRecipient__ReprMapItr struct {
	n   *_DecodedRecipient__Repr
	idx int
	end int
}

func (itr *_DecodedRecipient__ReprMapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
advance:
	if itr.idx >= 2 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__DecodedRecipient_Header_serial
		if itr.n.header.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.header.v.Representation()
	case 1:
		k = &fieldName__DecodedRecipient_Encrypted_key_serial
		if itr.n.encrypted_key.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.encrypted_key.v.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_DecodedRecipient__ReprMapItr) Done() bool {
	return itr.idx >= itr.end
}
func (_DecodedRecipient__Repr) ListIterator() datamodel.ListIterator {
	return nil
}
func (rn *_DecodedRecipient__Repr) Length() int64 {
	l := 2
	if rn.header.m == schema.Maybe_Absent {
		l--
	}
	if rn.encrypted_key.m == schema.Maybe_Absent {
		l--
	}
	return int64(l)
}
func (_DecodedRecipient__Repr) IsAbsent() bool {
	return false
}
func (_DecodedRecipient__Repr) IsNull() bool {
	return false
}
func (_DecodedRecipient__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.DecodedRecipient.Repr"}.AsBool()
}
func (_DecodedRecipient__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedRecipient.Repr"}.AsInt()
}
func (_DecodedRecipient__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedRecipient.Repr"}.AsFloat()
}
func (_DecodedRecipient__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.DecodedRecipient.Repr"}.AsString()
}
func (_DecodedRecipient__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.DecodedRecipient.Repr"}.AsBytes()
}
func (_DecodedRecipient__Repr) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.DecodedRecipient.Repr"}.AsLink()
}
func (_DecodedRecipient__Repr) Prototype() datamodel.NodePrototype {
	return _DecodedRecipient__ReprPrototype{}
}

type _DecodedRecipient__ReprPrototype struct{}

func (_DecodedRecipient__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _DecodedRecipient__ReprBuilder
	nb.Reset()
	return &nb
}

type _DecodedRecipient__ReprBuilder struct {
	_DecodedRecipient__ReprAssembler
}

func (nb *_DecodedRecipient__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_DecodedRecipient__ReprBuilder) Reset() {
	var w _DecodedRecipient
	var m schema.Maybe
	*nb = _DecodedRecipient__ReprBuilder{_DecodedRecipient__ReprAssembler{w: &w, m: &m}}
}

type _DecodedRecipient__ReprAssembler struct {
	w     *_DecodedRecipient
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm               schema.Maybe
	ca_header        _Any__ReprAssembler
	ca_encrypted_key _Base64Url__ReprAssembler
}

func (na *_DecodedRecipient__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_header.reset()
	na.ca_encrypted_key.reset()
}
func (na *_DecodedRecipient__ReprAssembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_DecodedRecipient{}
	}
	return na, nil
}
func (_DecodedRecipient__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient.Repr"}.BeginList(0)
}
func (na *_DecodedRecipient__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_DecodedRecipient__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient.Repr"}.AssignBool(false)
}
func (_DecodedRecipient__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient.Repr"}.AssignInt(0)
}
func (_DecodedRecipient__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient.Repr"}.AssignFloat(0)
}
func (_DecodedRecipient__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient.Repr"}.AssignString("")
}
func (_DecodedRecipient__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient.Repr"}.AssignBytes(nil)
}
func (_DecodedRecipient__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedRecipient.Repr"}.AssignLink(nil)
}
func (na *_DecodedRecipient__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_DecodedRecipient); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.DecodedRecipient.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_DecodedRecipient__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _DecodedRecipient__ReprPrototype{}
}
func (ma *_DecodedRecipient__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.header.m {
		case schema.Maybe_Value:
			ma.w.header.v = ma.ca_header.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.encrypted_key.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedRecipient__ReprAssembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "header":
		if ma.s&fieldBit__DecodedRecipient_Header != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedRecipient_Header_serial}
		}
		ma.s += fieldBit__DecodedRecipient_Header
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m

		return &ma.ca_header, nil
	case "encrypted_key":
		if ma.s&fieldBit__DecodedRecipient_Encrypted_key != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedRecipient_Encrypted_key_serial}
		}
		ma.s += fieldBit__DecodedRecipient_Encrypted_key
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_encrypted_key.w = &ma.w.encrypted_key.v
		ma.ca_encrypted_key.m = &ma.w.encrypted_key.m

		return &ma.ca_encrypted_key, nil
	default:
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.DecodedRecipient.Repr", Key: &_String{k}}
}
func (ma *_DecodedRecipient__ReprAssembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_DecodedRecipient__ReprKeyAssembler)(ma)
}
func (ma *_DecodedRecipient__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m

		return &ma.ca_header
	case 1:
		ma.ca_encrypted_key.w = &ma.w.encrypted_key.v
		ma.ca_encrypted_key.m = &ma.w.encrypted_key.m

		return &ma.ca_encrypted_key
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedRecipient__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__DecodedRecipient_sufficient != fieldBits__DecodedRecipient_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_DecodedRecipient__ReprAssembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_DecodedRecipient__ReprAssembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _DecodedRecipient__ReprKeyAssembler _DecodedRecipient__ReprAssembler

func (_DecodedRecipient__ReprKeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.Repr.KeyAssembler"}.BeginMap(0)
}
func (_DecodedRecipient__ReprKeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_DecodedRecipient__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.Repr.KeyAssembler"}.AssignNull()
}
func (_DecodedRecipient__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.Repr.KeyAssembler"}.AssignBool(false)
}
func (_DecodedRecipient__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.Repr.KeyAssembler"}.AssignInt(0)
}
func (_DecodedRecipient__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_DecodedRecipient__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "header":
		if ka.s&fieldBit__DecodedRecipient_Header != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedRecipient_Header_serial}
		}
		ka.s += fieldBit__DecodedRecipient_Header
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "encrypted_key":
		if ka.s&fieldBit__DecodedRecipient_Encrypted_key != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedRecipient_Encrypted_key_serial}
		}
		ka.s += fieldBit__DecodedRecipient_Encrypted_key
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	}
	return schema.ErrInvalidKey{TypeName: "dagjose.DecodedRecipient.Repr", Key: &_String{k}}
}
func (_DecodedRecipient__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_DecodedRecipient__ReprKeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedRecipient.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_DecodedRecipient__ReprKeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_DecodedRecipient__ReprKeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}

func (n *_DecodedRecipients) Lookup(idx int64) DecodedRecipient {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return v
}
func (n *_DecodedRecipients) LookupMaybe(idx int64) MaybeDecodedRecipient {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return &_DecodedRecipient__Maybe{
		m: schema.Maybe_Value,
		v: v,
	}
}

var _DecodedRecipients__valueAbsent = _DecodedRecipient__Maybe{m: schema.Maybe_Absent}

func (n DecodedRecipients) Iterator() *DecodedRecipients__Itr {
	return &DecodedRecipients__Itr{n, 0}
}

type DecodedRecipients__Itr struct {
	n   DecodedRecipients
	idx int
}

func (itr *DecodedRecipients__Itr) Next() (idx int64, v DecodedRecipient) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil
	}
	idx = int64(itr.idx)
	v = &itr.n.x[itr.idx]
	itr.idx++
	return
}
func (itr *DecodedRecipients__Itr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

type _DecodedRecipients__Maybe struct {
	m schema.Maybe
	v _DecodedRecipients
}
type MaybeDecodedRecipients = *_DecodedRecipients__Maybe

func (m MaybeDecodedRecipients) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeDecodedRecipients) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeDecodedRecipients) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeDecodedRecipients) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeDecodedRecipients) Must() DecodedRecipients {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (DecodedRecipients)(&_DecodedRecipients{})
var _ schema.TypedNode = (DecodedRecipients)(&_DecodedRecipients{})

func (DecodedRecipients) Kind() datamodel.Kind {
	return datamodel.Kind_List
}
func (DecodedRecipients) LookupByString(string) (datamodel.Node, error) {
	return mixins.List{TypeName: "dagjose.DecodedRecipients"}.LookupByString("")
}
func (n DecodedRecipients) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	idx, err := k.AsInt()
	if err != nil {
		return nil, err
	}
	return n.LookupByIndex(idx)
}
func (n DecodedRecipients) LookupByIndex(idx int64) (datamodel.Node, error) {
	if n.Length() <= idx {
		return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfInt(idx)}
	}
	v := &n.x[idx]
	return v, nil
}
func (n DecodedRecipients) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, datamodel.ErrInvalidSegmentForList{TypeName: "dagjose.DecodedRecipients", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (DecodedRecipients) MapIterator() datamodel.MapIterator {
	return nil
}
func (n DecodedRecipients) ListIterator() datamodel.ListIterator {
	return &_DecodedRecipients__ListItr{n, 0}
}

type _DecodedRecipients__ListItr struct {
	n   DecodedRecipients
	idx int
}

func (itr *_DecodedRecipients__ListItr) Next() (idx int64, v datamodel.Node, _ error) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil, datamodel.ErrIteratorOverread{}
	}
	idx = int64(itr.idx)
	x := &itr.n.x[itr.idx]
	v = x
	itr.idx++
	return
}
func (itr *_DecodedRecipients__ListItr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

func (n DecodedRecipients) Length() int64 {
	return int64(len(n.x))
}
func (DecodedRecipients) IsAbsent() bool {
	return false
}
func (DecodedRecipients) IsNull() bool {
	return false
}
func (DecodedRecipients) AsBool() (bool, error) {
	return mixins.List{TypeName: "dagjose.DecodedRecipients"}.AsBool()
}
func (DecodedRecipients) AsInt() (int64, error) {
	return mixins.List{TypeName: "dagjose.DecodedRecipients"}.AsInt()
}
func (DecodedRecipients) AsFloat() (float64, error) {
	return mixins.List{TypeName: "dagjose.DecodedRecipients"}.AsFloat()
}
func (DecodedRecipients) AsString() (string, error) {
	return mixins.List{TypeName: "dagjose.DecodedRecipients"}.AsString()
}
func (DecodedRecipients) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "dagjose.DecodedRecipients"}.AsBytes()
}
func (DecodedRecipients) AsLink() (datamodel.Link, error) {
	return mixins.List{TypeName: "dagjose.DecodedRecipients"}.AsLink()
}
func (DecodedRecipients) Prototype() datamodel.NodePrototype {
	return _DecodedRecipients__Prototype{}
}

type _DecodedRecipients__Prototype struct{}

func (_DecodedRecipients__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _DecodedRecipients__Builder
	nb.Reset()
	return &nb
}

type _DecodedRecipients__Builder struct {
	_DecodedRecipients__Assembler
}

func (nb *_DecodedRecipients__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_DecodedRecipients__Builder) Reset() {
	var w _DecodedRecipients
	var m schema.Maybe
	*nb = _DecodedRecipients__Builder{_DecodedRecipients__Assembler{w: &w, m: &m}}
}

type _DecodedRecipients__Assembler struct {
	w     *_DecodedRecipients
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _DecodedRecipient__Assembler
}

func (na *_DecodedRecipients__Assembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_DecodedRecipients__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients"}.BeginMap(0)
}
func (na *_DecodedRecipients__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_DecodedRecipient, 0, sizeHint)
	}
	return na, nil
}
func (na *_DecodedRecipients__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_DecodedRecipients__Assembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients"}.AssignBool(false)
}
func (_DecodedRecipients__Assembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients"}.AssignInt(0)
}
func (_DecodedRecipients__Assembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients"}.AssignFloat(0)
}
func (_DecodedRecipients__Assembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients"}.AssignString("")
}
func (_DecodedRecipients__Assembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients"}.AssignBytes(nil)
}
func (_DecodedRecipients__Assembler) AssignLink(datamodel.Link) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients"}.AssignLink(nil)
}
func (na *_DecodedRecipients__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_DecodedRecipients); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_List {
		return datamodel.ErrWrongKind{TypeName: "dagjose.DecodedRecipients", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_DecodedRecipients__Assembler) Prototype() datamodel.NodePrototype {
	return _DecodedRecipients__Prototype{}
}
func (la *_DecodedRecipients__Assembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_DecodedRecipients__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _DecodedRecipient{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_DecodedRecipients__Assembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_DecodedRecipients__Assembler) ValuePrototype(_ int64) datamodel.NodePrototype {
	return _DecodedRecipient__Prototype{}
}
func (DecodedRecipients) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n DecodedRecipients) Representation() datamodel.Node {
	return (*_DecodedRecipients__Repr)(n)
}

type _DecodedRecipients__Repr _DecodedRecipients

var _ datamodel.Node = &_DecodedRecipients__Repr{}

func (_DecodedRecipients__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_List
}
func (_DecodedRecipients__Repr) LookupByString(string) (datamodel.Node, error) {
	return mixins.List{TypeName: "dagjose.DecodedRecipients.Repr"}.LookupByString("")
}
func (nr *_DecodedRecipients__Repr) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	v, err := (DecodedRecipients)(nr).LookupByNode(k)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(DecodedRecipient).Representation(), nil
}
func (nr *_DecodedRecipients__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	v, err := (DecodedRecipients)(nr).LookupByIndex(idx)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(DecodedRecipient).Representation(), nil
}
func (n _DecodedRecipients__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, datamodel.ErrInvalidSegmentForList{TypeName: "dagjose.DecodedRecipients.Repr", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (_DecodedRecipients__Repr) MapIterator() datamodel.MapIterator {
	return nil
}
func (nr *_DecodedRecipients__Repr) ListIterator() datamodel.ListIterator {
	return &_DecodedRecipients__ReprListItr{(DecodedRecipients)(nr), 0}
}

type _DecodedRecipients__ReprListItr _DecodedRecipients__ListItr

func (itr *_DecodedRecipients__ReprListItr) Next() (idx int64, v datamodel.Node, err error) {
	idx, v, err = (*_DecodedRecipients__ListItr)(itr).Next()
	if err != nil || v == datamodel.Null {
		return
	}
	return idx, v.(DecodedRecipient).Representation(), nil
}
func (itr *_DecodedRecipients__ReprListItr) Done() bool {
	return (*_DecodedRecipients__ListItr)(itr).Done()
}

func (rn *_DecodedRecipients__Repr) Length() int64 {
	return int64(len(rn.x))
}
func (_DecodedRecipients__Repr) IsAbsent() bool {
	return false
}
func (_DecodedRecipients__Repr) IsNull() bool {
	return false
}
func (_DecodedRecipients__Repr) AsBool() (bool, error) {
	return mixins.List{TypeName: "dagjose.DecodedRecipients.Repr"}.AsBool()
}
func (_DecodedRecipients__Repr) AsInt() (int64, error) {
	return mixins.List{TypeName: "dagjose.DecodedRecipients.Repr"}.AsInt()
}
func (_DecodedRecipients__Repr) AsFloat() (float64, error) {
	return mixins.List{TypeName: "dagjose.DecodedRecipients.Repr"}.AsFloat()
}
func (_DecodedRecipients__Repr) AsString() (string, error) {
	return mixins.List{TypeName: "dagjose.DecodedRecipients.Repr"}.AsString()
}
func (_DecodedRecipients__Repr) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "dagjose.DecodedRecipients.Repr"}.AsBytes()
}
func (_DecodedRecipients__Repr) AsLink() (datamodel.Link, error) {
	return mixins.List{TypeName: "dagjose.DecodedRecipients.Repr"}.AsLink()
}
func (_DecodedRecipients__Repr) Prototype() datamodel.NodePrototype {
	return _DecodedRecipients__ReprPrototype{}
}

type _DecodedRecipients__ReprPrototype struct{}

func (_DecodedRecipients__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _DecodedRecipients__ReprBuilder
	nb.Reset()
	return &nb
}

type _DecodedRecipients__ReprBuilder struct {
	_DecodedRecipients__ReprAssembler
}

func (nb *_DecodedRecipients__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_DecodedRecipients__ReprBuilder) Reset() {
	var w _DecodedRecipients
	var m schema.Maybe
	*nb = _DecodedRecipients__ReprBuilder{_DecodedRecipients__ReprAssembler{w: &w, m: &m}}
}

type _DecodedRecipients__ReprAssembler struct {
	w     *_DecodedRecipients
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _DecodedRecipient__ReprAssembler
}

func (na *_DecodedRecipients__ReprAssembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_DecodedRecipients__ReprAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients.Repr"}.BeginMap(0)
}
func (na *_DecodedRecipients__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_DecodedRecipient, 0, sizeHint)
	}
	return na, nil
}
func (na *_DecodedRecipients__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_DecodedRecipients__ReprAssembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients.Repr"}.AssignBool(false)
}
func (_DecodedRecipients__ReprAssembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients.Repr"}.AssignInt(0)
}
func (_DecodedRecipients__ReprAssembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients.Repr"}.AssignFloat(0)
}
func (_DecodedRecipients__ReprAssembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients.Repr"}.AssignString("")
}
func (_DecodedRecipients__ReprAssembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients.Repr"}.AssignBytes(nil)
}
func (_DecodedRecipients__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedRecipients.Repr"}.AssignLink(nil)
}
func (na *_DecodedRecipients__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_DecodedRecipients); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_List {
		return datamodel.ErrWrongKind{TypeName: "dagjose.DecodedRecipients.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_DecodedRecipients__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _DecodedRecipients__ReprPrototype{}
}
func (la *_DecodedRecipients__ReprAssembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_DecodedRecipients__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _DecodedRecipient{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_DecodedRecipients__ReprAssembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_DecodedRecipients__ReprAssembler) ValuePrototype(_ int64) datamodel.NodePrototype {
	return _DecodedRecipient__ReprPrototype{}
}

func (n _DecodedSignature) FieldHeader() MaybeAny {
	return &n.header
}
func (n _DecodedSignature) FieldProtected() MaybeBase64Url {
	return &n.protected
}
func (n _DecodedSignature) FieldSignature() Base64Url {
	return &n.signature
}

type _DecodedSignature__Maybe struct {
	m schema.Maybe
	v DecodedSignature
}
type MaybeDecodedSignature = *_DecodedSignature__Maybe

func (m MaybeDecodedSignature) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeDecodedSignature) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeDecodedSignature) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeDecodedSignature) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeDecodedSignature) Must() DecodedSignature {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__DecodedSignature_Header    = _String{"header"}
	fieldName__DecodedSignature_Protected = _String{"protected"}
	fieldName__DecodedSignature_Signature = _String{"signature"}
)
var _ datamodel.Node = (DecodedSignature)(&_DecodedSignature{})
var _ schema.TypedNode = (DecodedSignature)(&_DecodedSignature{})

func (DecodedSignature) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n DecodedSignature) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "header":
		if n.header.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return n.header.v, nil
	case "protected":
		if n.protected.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.protected.v, nil
	case "signature":
		return &n.signature, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n DecodedSignature) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (DecodedSignature) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.DecodedSignature"}.LookupByIndex(0)
}
func (n DecodedSignature) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n DecodedSignature) MapIterator() datamodel.MapIterator {
	return &_DecodedSignature__MapItr{n, 0}
}

type _DecodedSignature__MapItr struct {
	n   DecodedSignature
	idx int
}

func (itr *_DecodedSignature__MapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
	if itr.idx >= 3 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__DecodedSignature_Header
		if itr.n.header.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = itr.n.header.v
	case 1:
		k = &fieldName__DecodedSignature_Protected
		if itr.n.protected.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.protected.v
	case 2:
		k = &fieldName__DecodedSignature_Signature
		v = &itr.n.signature
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_DecodedSignature__MapItr) Done() bool {
	return itr.idx >= 3
}

func (DecodedSignature) ListIterator() datamodel.ListIterator {
	return nil
}
func (DecodedSignature) Length() int64 {
	return 3
}
func (DecodedSignature) IsAbsent() bool {
	return false
}
func (DecodedSignature) IsNull() bool {
	return false
}
func (DecodedSignature) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.DecodedSignature"}.AsBool()
}
func (DecodedSignature) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedSignature"}.AsInt()
}
func (DecodedSignature) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedSignature"}.AsFloat()
}
func (DecodedSignature) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.DecodedSignature"}.AsString()
}
func (DecodedSignature) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.DecodedSignature"}.AsBytes()
}
func (DecodedSignature) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.DecodedSignature"}.AsLink()
}
func (DecodedSignature) Prototype() datamodel.NodePrototype {
	return _DecodedSignature__Prototype{}
}

type _DecodedSignature__Prototype struct{}

func (_DecodedSignature__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _DecodedSignature__Builder
	nb.Reset()
	return &nb
}

type _DecodedSignature__Builder struct {
	_DecodedSignature__Assembler
}

func (nb *_DecodedSignature__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_DecodedSignature__Builder) Reset() {
	var w _DecodedSignature
	var m schema.Maybe
	*nb = _DecodedSignature__Builder{_DecodedSignature__Assembler{w: &w, m: &m}}
}

type _DecodedSignature__Assembler struct {
	w     *_DecodedSignature
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm           schema.Maybe
	ca_header    _Any__Assembler
	ca_protected _Base64Url__Assembler
	ca_signature _Base64Url__Assembler
}

func (na *_DecodedSignature__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_header.reset()
	na.ca_protected.reset()
	na.ca_signature.reset()
}

var (
	fieldBit__DecodedSignature_Header      = 1 << 0
	fieldBit__DecodedSignature_Protected   = 1 << 1
	fieldBit__DecodedSignature_Signature   = 1 << 2
	fieldBits__DecodedSignature_sufficient = 0 + 1<<2
)

func (na *_DecodedSignature__Assembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_DecodedSignature{}
	}
	return na, nil
}
func (_DecodedSignature__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature"}.BeginList(0)
}
func (na *_DecodedSignature__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_DecodedSignature__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature"}.AssignBool(false)
}
func (_DecodedSignature__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature"}.AssignInt(0)
}
func (_DecodedSignature__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature"}.AssignFloat(0)
}
func (_DecodedSignature__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature"}.AssignString("")
}
func (_DecodedSignature__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature"}.AssignBytes(nil)
}
func (_DecodedSignature__Assembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature"}.AssignLink(nil)
}
func (na *_DecodedSignature__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_DecodedSignature); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.DecodedSignature", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_DecodedSignature__Assembler) Prototype() datamodel.NodePrototype {
	return _DecodedSignature__Prototype{}
}
func (ma *_DecodedSignature__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.header.m {
		case schema.Maybe_Value:
			ma.w.header.v = ma.ca_header.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.protected.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_signature.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedSignature__Assembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "header":
		if ma.s&fieldBit__DecodedSignature_Header != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedSignature_Header}
		}
		ma.s += fieldBit__DecodedSignature_Header
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m
		return &ma.ca_header, nil
	case "protected":
		if ma.s&fieldBit__DecodedSignature_Protected != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedSignature_Protected}
		}
		ma.s += fieldBit__DecodedSignature_Protected
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m
		return &ma.ca_protected, nil
	case "signature":
		if ma.s&fieldBit__DecodedSignature_Signature != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedSignature_Signature}
		}
		ma.s += fieldBit__DecodedSignature_Signature
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_signature.w = &ma.w.signature
		ma.ca_signature.m = &ma.cm
		return &ma.ca_signature, nil
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.DecodedSignature", Key: &_String{k}}
}
func (ma *_DecodedSignature__Assembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_DecodedSignature__KeyAssembler)(ma)
}
func (ma *_DecodedSignature__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m
		return &ma.ca_header
	case 1:
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m
		return &ma.ca_protected
	case 2:
		ma.ca_signature.w = &ma.w.signature
		ma.ca_signature.m = &ma.cm
		return &ma.ca_signature
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedSignature__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__DecodedSignature_sufficient != fieldBits__DecodedSignature_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__DecodedSignature_Signature == 0 {
			err.Missing = append(err.Missing, "signature")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_DecodedSignature__Assembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_DecodedSignature__Assembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _DecodedSignature__KeyAssembler _DecodedSignature__Assembler

func (_DecodedSignature__KeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.KeyAssembler"}.BeginMap(0)
}
func (_DecodedSignature__KeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.KeyAssembler"}.BeginList(0)
}
func (na *_DecodedSignature__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.KeyAssembler"}.AssignNull()
}
func (_DecodedSignature__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.KeyAssembler"}.AssignBool(false)
}
func (_DecodedSignature__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.KeyAssembler"}.AssignInt(0)
}
func (_DecodedSignature__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.KeyAssembler"}.AssignFloat(0)
}
func (ka *_DecodedSignature__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "header":
		if ka.s&fieldBit__DecodedSignature_Header != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedSignature_Header}
		}
		ka.s += fieldBit__DecodedSignature_Header
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "protected":
		if ka.s&fieldBit__DecodedSignature_Protected != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedSignature_Protected}
		}
		ka.s += fieldBit__DecodedSignature_Protected
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "signature":
		if ka.s&fieldBit__DecodedSignature_Signature != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedSignature_Signature}
		}
		ka.s += fieldBit__DecodedSignature_Signature
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	default:
		return schema.ErrInvalidKey{TypeName: "dagjose.DecodedSignature", Key: &_String{k}}
	}
}
func (_DecodedSignature__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.KeyAssembler"}.AssignBytes(nil)
}
func (_DecodedSignature__KeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.KeyAssembler"}.AssignLink(nil)
}
func (ka *_DecodedSignature__KeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_DecodedSignature__KeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (DecodedSignature) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n DecodedSignature) Representation() datamodel.Node {
	return (*_DecodedSignature__Repr)(n)
}

type _DecodedSignature__Repr _DecodedSignature

var (
	fieldName__DecodedSignature_Header_serial    = _String{"header"}
	fieldName__DecodedSignature_Protected_serial = _String{"protected"}
	fieldName__DecodedSignature_Signature_serial = _String{"signature"}
)
var _ datamodel.Node = &_DecodedSignature__Repr{}

func (_DecodedSignature__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n *_DecodedSignature__Repr) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "header":
		if n.header.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.header.v.Representation(), nil
	case "protected":
		if n.protected.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.protected.v.Representation(), nil
	case "signature":
		return n.signature.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n *_DecodedSignature__Repr) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_DecodedSignature__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.DecodedSignature.Repr"}.LookupByIndex(0)
}
func (n _DecodedSignature__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_DecodedSignature__Repr) MapIterator() datamodel.MapIterator {
	return &_DecodedSignature__ReprMapItr{n, 0}
}

type _DecodedSignature__ReprMapItr struct {
	n   *_DecodedSignature__Repr
	idx int
}

func (itr *_DecodedSignature__ReprMapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
advance:
	if itr.idx >= 3 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__DecodedSignature_Header_serial
		if itr.n.header.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.header.v.Representation()
	case 1:
		k = &fieldName__DecodedSignature_Protected_serial
		if itr.n.protected.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.protected.v.Representation()
	case 2:
		k = &fieldName__DecodedSignature_Signature_serial
		v = itr.n.signature.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_DecodedSignature__ReprMapItr) Done() bool {
	return itr.idx >= 3
}
func (_DecodedSignature__Repr) ListIterator() datamodel.ListIterator {
	return nil
}
func (rn *_DecodedSignature__Repr) Length() int64 {
	l := 3
	if rn.header.m == schema.Maybe_Absent {
		l--
	}
	if rn.protected.m == schema.Maybe_Absent {
		l--
	}
	return int64(l)
}
func (_DecodedSignature__Repr) IsAbsent() bool {
	return false
}
func (_DecodedSignature__Repr) IsNull() bool {
	return false
}
func (_DecodedSignature__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.DecodedSignature.Repr"}.AsBool()
}
func (_DecodedSignature__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedSignature.Repr"}.AsInt()
}
func (_DecodedSignature__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.DecodedSignature.Repr"}.AsFloat()
}
func (_DecodedSignature__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.DecodedSignature.Repr"}.AsString()
}
func (_DecodedSignature__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.DecodedSignature.Repr"}.AsBytes()
}
func (_DecodedSignature__Repr) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.DecodedSignature.Repr"}.AsLink()
}
func (_DecodedSignature__Repr) Prototype() datamodel.NodePrototype {
	return _DecodedSignature__ReprPrototype{}
}

type _DecodedSignature__ReprPrototype struct{}

func (_DecodedSignature__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _DecodedSignature__ReprBuilder
	nb.Reset()
	return &nb
}

type _DecodedSignature__ReprBuilder struct {
	_DecodedSignature__ReprAssembler
}

func (nb *_DecodedSignature__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_DecodedSignature__ReprBuilder) Reset() {
	var w _DecodedSignature
	var m schema.Maybe
	*nb = _DecodedSignature__ReprBuilder{_DecodedSignature__ReprAssembler{w: &w, m: &m}}
}

type _DecodedSignature__ReprAssembler struct {
	w     *_DecodedSignature
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm           schema.Maybe
	ca_header    _Any__ReprAssembler
	ca_protected _Base64Url__ReprAssembler
	ca_signature _Base64Url__ReprAssembler
}

func (na *_DecodedSignature__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_header.reset()
	na.ca_protected.reset()
	na.ca_signature.reset()
}
func (na *_DecodedSignature__ReprAssembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_DecodedSignature{}
	}
	return na, nil
}
func (_DecodedSignature__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature.Repr"}.BeginList(0)
}
func (na *_DecodedSignature__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_DecodedSignature__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature.Repr"}.AssignBool(false)
}
func (_DecodedSignature__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature.Repr"}.AssignInt(0)
}
func (_DecodedSignature__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature.Repr"}.AssignFloat(0)
}
func (_DecodedSignature__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature.Repr"}.AssignString("")
}
func (_DecodedSignature__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature.Repr"}.AssignBytes(nil)
}
func (_DecodedSignature__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.DecodedSignature.Repr"}.AssignLink(nil)
}
func (na *_DecodedSignature__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_DecodedSignature); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.DecodedSignature.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_DecodedSignature__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _DecodedSignature__ReprPrototype{}
}
func (ma *_DecodedSignature__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.header.m {
		case schema.Maybe_Value:
			ma.w.header.v = ma.ca_header.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.protected.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedSignature__ReprAssembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "header":
		if ma.s&fieldBit__DecodedSignature_Header != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedSignature_Header_serial}
		}
		ma.s += fieldBit__DecodedSignature_Header
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m

		return &ma.ca_header, nil
	case "protected":
		if ma.s&fieldBit__DecodedSignature_Protected != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedSignature_Protected_serial}
		}
		ma.s += fieldBit__DecodedSignature_Protected
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m

		return &ma.ca_protected, nil
	case "signature":
		if ma.s&fieldBit__DecodedSignature_Signature != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedSignature_Signature_serial}
		}
		ma.s += fieldBit__DecodedSignature_Signature
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_signature.w = &ma.w.signature
		ma.ca_signature.m = &ma.cm
		return &ma.ca_signature, nil
	default:
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.DecodedSignature.Repr", Key: &_String{k}}
}
func (ma *_DecodedSignature__ReprAssembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_DecodedSignature__ReprKeyAssembler)(ma)
}
func (ma *_DecodedSignature__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m

		return &ma.ca_header
	case 1:
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m

		return &ma.ca_protected
	case 2:
		ma.ca_signature.w = &ma.w.signature
		ma.ca_signature.m = &ma.cm
		return &ma.ca_signature
	default:
		panic("unreachable")
	}
}
func (ma *_DecodedSignature__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__DecodedSignature_sufficient != fieldBits__DecodedSignature_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__DecodedSignature_Signature == 0 {
			err.Missing = append(err.Missing, "signature")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_DecodedSignature__ReprAssembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_DecodedSignature__ReprAssembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _DecodedSignature__ReprKeyAssembler _DecodedSignature__ReprAssembler

func (_DecodedSignature__ReprKeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.Repr.KeyAssembler"}.BeginMap(0)
}
func (_DecodedSignature__ReprKeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_DecodedSignature__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.Repr.KeyAssembler"}.AssignNull()
}
func (_DecodedSignature__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.Repr.KeyAssembler"}.AssignBool(false)
}
func (_DecodedSignature__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.Repr.KeyAssembler"}.AssignInt(0)
}
func (_DecodedSignature__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_DecodedSignature__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "header":
		if ka.s&fieldBit__DecodedSignature_Header != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedSignature_Header_serial}
		}
		ka.s += fieldBit__DecodedSignature_Header
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "protected":
		if ka.s&fieldBit__DecodedSignature_Protected != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedSignature_Protected_serial}
		}
		ka.s += fieldBit__DecodedSignature_Protected
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "signature":
		if ka.s&fieldBit__DecodedSignature_Signature != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__DecodedSignature_Signature_serial}
		}
		ka.s += fieldBit__DecodedSignature_Signature
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	}
	return schema.ErrInvalidKey{TypeName: "dagjose.DecodedSignature.Repr", Key: &_String{k}}
}
func (_DecodedSignature__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_DecodedSignature__ReprKeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.DecodedSignature.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_DecodedSignature__ReprKeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_DecodedSignature__ReprKeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}

func (n *_DecodedSignatures) Lookup(idx int64) DecodedSignature {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return v
}
func (n *_DecodedSignatures) LookupMaybe(idx int64) MaybeDecodedSignature {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return &_DecodedSignature__Maybe{
		m: schema.Maybe_Value,
		v: v,
	}
}

var _DecodedSignatures__valueAbsent = _DecodedSignature__Maybe{m: schema.Maybe_Absent}

func (n DecodedSignatures) Iterator() *DecodedSignatures__Itr {
	return &DecodedSignatures__Itr{n, 0}
}

type DecodedSignatures__Itr struct {
	n   DecodedSignatures
	idx int
}

func (itr *DecodedSignatures__Itr) Next() (idx int64, v DecodedSignature) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil
	}
	idx = int64(itr.idx)
	v = &itr.n.x[itr.idx]
	itr.idx++
	return
}
func (itr *DecodedSignatures__Itr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

type _DecodedSignatures__Maybe struct {
	m schema.Maybe
	v _DecodedSignatures
}
type MaybeDecodedSignatures = *_DecodedSignatures__Maybe

func (m MaybeDecodedSignatures) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeDecodedSignatures) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeDecodedSignatures) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeDecodedSignatures) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeDecodedSignatures) Must() DecodedSignatures {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (DecodedSignatures)(&_DecodedSignatures{})
var _ schema.TypedNode = (DecodedSignatures)(&_DecodedSignatures{})

func (DecodedSignatures) Kind() datamodel.Kind {
	return datamodel.Kind_List
}
func (DecodedSignatures) LookupByString(string) (datamodel.Node, error) {
	return mixins.List{TypeName: "dagjose.DecodedSignatures"}.LookupByString("")
}
func (n DecodedSignatures) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	idx, err := k.AsInt()
	if err != nil {
		return nil, err
	}
	return n.LookupByIndex(idx)
}
func (n DecodedSignatures) LookupByIndex(idx int64) (datamodel.Node, error) {
	if n.Length() <= idx {
		return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfInt(idx)}
	}
	v := &n.x[idx]
	return v, nil
}
func (n DecodedSignatures) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, datamodel.ErrInvalidSegmentForList{TypeName: "dagjose.DecodedSignatures", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (DecodedSignatures) MapIterator() datamodel.MapIterator {
	return nil
}
func (n DecodedSignatures) ListIterator() datamodel.ListIterator {
	return &_DecodedSignatures__ListItr{n, 0}
}

type _DecodedSignatures__ListItr struct {
	n   DecodedSignatures
	idx int
}

func (itr *_DecodedSignatures__ListItr) Next() (idx int64, v datamodel.Node, _ error) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil, datamodel.ErrIteratorOverread{}
	}
	idx = int64(itr.idx)
	x := &itr.n.x[itr.idx]
	v = x
	itr.idx++
	return
}
func (itr *_DecodedSignatures__ListItr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

func (n DecodedSignatures) Length() int64 {
	return int64(len(n.x))
}
func (DecodedSignatures) IsAbsent() bool {
	return false
}
func (DecodedSignatures) IsNull() bool {
	return false
}
func (DecodedSignatures) AsBool() (bool, error) {
	return mixins.List{TypeName: "dagjose.DecodedSignatures"}.AsBool()
}
func (DecodedSignatures) AsInt() (int64, error) {
	return mixins.List{TypeName: "dagjose.DecodedSignatures"}.AsInt()
}
func (DecodedSignatures) AsFloat() (float64, error) {
	return mixins.List{TypeName: "dagjose.DecodedSignatures"}.AsFloat()
}
func (DecodedSignatures) AsString() (string, error) {
	return mixins.List{TypeName: "dagjose.DecodedSignatures"}.AsString()
}
func (DecodedSignatures) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "dagjose.DecodedSignatures"}.AsBytes()
}
func (DecodedSignatures) AsLink() (datamodel.Link, error) {
	return mixins.List{TypeName: "dagjose.DecodedSignatures"}.AsLink()
}
func (DecodedSignatures) Prototype() datamodel.NodePrototype {
	return _DecodedSignatures__Prototype{}
}

type _DecodedSignatures__Prototype struct{}

func (_DecodedSignatures__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _DecodedSignatures__Builder
	nb.Reset()
	return &nb
}

type _DecodedSignatures__Builder struct {
	_DecodedSignatures__Assembler
}

func (nb *_DecodedSignatures__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_DecodedSignatures__Builder) Reset() {
	var w _DecodedSignatures
	var m schema.Maybe
	*nb = _DecodedSignatures__Builder{_DecodedSignatures__Assembler{w: &w, m: &m}}
}

type _DecodedSignatures__Assembler struct {
	w     *_DecodedSignatures
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _DecodedSignature__Assembler
}

func (na *_DecodedSignatures__Assembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_DecodedSignatures__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures"}.BeginMap(0)
}
func (na *_DecodedSignatures__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_DecodedSignature, 0, sizeHint)
	}
	return na, nil
}
func (na *_DecodedSignatures__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_DecodedSignatures__Assembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures"}.AssignBool(false)
}
func (_DecodedSignatures__Assembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures"}.AssignInt(0)
}
func (_DecodedSignatures__Assembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures"}.AssignFloat(0)
}
func (_DecodedSignatures__Assembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures"}.AssignString("")
}
func (_DecodedSignatures__Assembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures"}.AssignBytes(nil)
}
func (_DecodedSignatures__Assembler) AssignLink(datamodel.Link) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures"}.AssignLink(nil)
}
func (na *_DecodedSignatures__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_DecodedSignatures); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_List {
		return datamodel.ErrWrongKind{TypeName: "dagjose.DecodedSignatures", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_DecodedSignatures__Assembler) Prototype() datamodel.NodePrototype {
	return _DecodedSignatures__Prototype{}
}
func (la *_DecodedSignatures__Assembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_DecodedSignatures__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _DecodedSignature{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_DecodedSignatures__Assembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_DecodedSignatures__Assembler) ValuePrototype(_ int64) datamodel.NodePrototype {
	return _DecodedSignature__Prototype{}
}
func (DecodedSignatures) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n DecodedSignatures) Representation() datamodel.Node {
	return (*_DecodedSignatures__Repr)(n)
}

type _DecodedSignatures__Repr _DecodedSignatures

var _ datamodel.Node = &_DecodedSignatures__Repr{}

func (_DecodedSignatures__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_List
}
func (_DecodedSignatures__Repr) LookupByString(string) (datamodel.Node, error) {
	return mixins.List{TypeName: "dagjose.DecodedSignatures.Repr"}.LookupByString("")
}
func (nr *_DecodedSignatures__Repr) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	v, err := (DecodedSignatures)(nr).LookupByNode(k)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(DecodedSignature).Representation(), nil
}
func (nr *_DecodedSignatures__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	v, err := (DecodedSignatures)(nr).LookupByIndex(idx)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(DecodedSignature).Representation(), nil
}
func (n _DecodedSignatures__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, datamodel.ErrInvalidSegmentForList{TypeName: "dagjose.DecodedSignatures.Repr", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (_DecodedSignatures__Repr) MapIterator() datamodel.MapIterator {
	return nil
}
func (nr *_DecodedSignatures__Repr) ListIterator() datamodel.ListIterator {
	return &_DecodedSignatures__ReprListItr{(DecodedSignatures)(nr), 0}
}

type _DecodedSignatures__ReprListItr _DecodedSignatures__ListItr

func (itr *_DecodedSignatures__ReprListItr) Next() (idx int64, v datamodel.Node, err error) {
	idx, v, err = (*_DecodedSignatures__ListItr)(itr).Next()
	if err != nil || v == datamodel.Null {
		return
	}
	return idx, v.(DecodedSignature).Representation(), nil
}
func (itr *_DecodedSignatures__ReprListItr) Done() bool {
	return (*_DecodedSignatures__ListItr)(itr).Done()
}

func (rn *_DecodedSignatures__Repr) Length() int64 {
	return int64(len(rn.x))
}
func (_DecodedSignatures__Repr) IsAbsent() bool {
	return false
}
func (_DecodedSignatures__Repr) IsNull() bool {
	return false
}
func (_DecodedSignatures__Repr) AsBool() (bool, error) {
	return mixins.List{TypeName: "dagjose.DecodedSignatures.Repr"}.AsBool()
}
func (_DecodedSignatures__Repr) AsInt() (int64, error) {
	return mixins.List{TypeName: "dagjose.DecodedSignatures.Repr"}.AsInt()
}
func (_DecodedSignatures__Repr) AsFloat() (float64, error) {
	return mixins.List{TypeName: "dagjose.DecodedSignatures.Repr"}.AsFloat()
}
func (_DecodedSignatures__Repr) AsString() (string, error) {
	return mixins.List{TypeName: "dagjose.DecodedSignatures.Repr"}.AsString()
}
func (_DecodedSignatures__Repr) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "dagjose.DecodedSignatures.Repr"}.AsBytes()
}
func (_DecodedSignatures__Repr) AsLink() (datamodel.Link, error) {
	return mixins.List{TypeName: "dagjose.DecodedSignatures.Repr"}.AsLink()
}
func (_DecodedSignatures__Repr) Prototype() datamodel.NodePrototype {
	return _DecodedSignatures__ReprPrototype{}
}

type _DecodedSignatures__ReprPrototype struct{}

func (_DecodedSignatures__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _DecodedSignatures__ReprBuilder
	nb.Reset()
	return &nb
}

type _DecodedSignatures__ReprBuilder struct {
	_DecodedSignatures__ReprAssembler
}

func (nb *_DecodedSignatures__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_DecodedSignatures__ReprBuilder) Reset() {
	var w _DecodedSignatures
	var m schema.Maybe
	*nb = _DecodedSignatures__ReprBuilder{_DecodedSignatures__ReprAssembler{w: &w, m: &m}}
}

type _DecodedSignatures__ReprAssembler struct {
	w     *_DecodedSignatures
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _DecodedSignature__ReprAssembler
}

func (na *_DecodedSignatures__ReprAssembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_DecodedSignatures__ReprAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures.Repr"}.BeginMap(0)
}
func (na *_DecodedSignatures__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_DecodedSignature, 0, sizeHint)
	}
	return na, nil
}
func (na *_DecodedSignatures__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_DecodedSignatures__ReprAssembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures.Repr"}.AssignBool(false)
}
func (_DecodedSignatures__ReprAssembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures.Repr"}.AssignInt(0)
}
func (_DecodedSignatures__ReprAssembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures.Repr"}.AssignFloat(0)
}
func (_DecodedSignatures__ReprAssembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures.Repr"}.AssignString("")
}
func (_DecodedSignatures__ReprAssembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures.Repr"}.AssignBytes(nil)
}
func (_DecodedSignatures__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.ListAssembler{TypeName: "dagjose.DecodedSignatures.Repr"}.AssignLink(nil)
}
func (na *_DecodedSignatures__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_DecodedSignatures); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_List {
		return datamodel.ErrWrongKind{TypeName: "dagjose.DecodedSignatures.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_DecodedSignatures__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _DecodedSignatures__ReprPrototype{}
}
func (la *_DecodedSignatures__ReprAssembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_DecodedSignatures__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _DecodedSignature{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_DecodedSignatures__ReprAssembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_DecodedSignatures__ReprAssembler) ValuePrototype(_ int64) datamodel.NodePrototype {
	return _DecodedSignature__ReprPrototype{}
}

func (n _EncodedJWE) FieldAad() MaybeRaw {
	return &n.aad
}
func (n _EncodedJWE) FieldCiphertext() Raw {
	return &n.ciphertext
}
func (n _EncodedJWE) FieldIv() MaybeRaw {
	return &n.iv
}
func (n _EncodedJWE) FieldProtected() MaybeRaw {
	return &n.protected
}
func (n _EncodedJWE) FieldRecipients() MaybeEncodedRecipients {
	return &n.recipients
}
func (n _EncodedJWE) FieldTag() MaybeRaw {
	return &n.tag
}
func (n _EncodedJWE) FieldUnprotected() MaybeAny {
	return &n.unprotected
}

type _EncodedJWE__Maybe struct {
	m schema.Maybe
	v EncodedJWE
}
type MaybeEncodedJWE = *_EncodedJWE__Maybe

func (m MaybeEncodedJWE) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeEncodedJWE) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeEncodedJWE) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeEncodedJWE) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeEncodedJWE) Must() EncodedJWE {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__EncodedJWE_Aad         = _String{"aad"}
	fieldName__EncodedJWE_Ciphertext  = _String{"ciphertext"}
	fieldName__EncodedJWE_Iv          = _String{"iv"}
	fieldName__EncodedJWE_Protected   = _String{"protected"}
	fieldName__EncodedJWE_Recipients  = _String{"recipients"}
	fieldName__EncodedJWE_Tag         = _String{"tag"}
	fieldName__EncodedJWE_Unprotected = _String{"unprotected"}
)
var _ datamodel.Node = (EncodedJWE)(&_EncodedJWE{})
var _ schema.TypedNode = (EncodedJWE)(&_EncodedJWE{})

func (EncodedJWE) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n EncodedJWE) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "aad":
		if n.aad.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.aad.v, nil
	case "ciphertext":
		return &n.ciphertext, nil
	case "iv":
		if n.iv.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.iv.v, nil
	case "protected":
		if n.protected.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.protected.v, nil
	case "recipients":
		if n.recipients.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.recipients.v, nil
	case "tag":
		if n.tag.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.tag.v, nil
	case "unprotected":
		if n.unprotected.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return n.unprotected.v, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n EncodedJWE) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (EncodedJWE) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWE"}.LookupByIndex(0)
}
func (n EncodedJWE) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n EncodedJWE) MapIterator() datamodel.MapIterator {
	return &_EncodedJWE__MapItr{n, 0}
}

type _EncodedJWE__MapItr struct {
	n   EncodedJWE
	idx int
}

func (itr *_EncodedJWE__MapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
	if itr.idx >= 7 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__EncodedJWE_Aad
		if itr.n.aad.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.aad.v
	case 1:
		k = &fieldName__EncodedJWE_Ciphertext
		v = &itr.n.ciphertext
	case 2:
		k = &fieldName__EncodedJWE_Iv
		if itr.n.iv.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.iv.v
	case 3:
		k = &fieldName__EncodedJWE_Protected
		if itr.n.protected.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.protected.v
	case 4:
		k = &fieldName__EncodedJWE_Recipients
		if itr.n.recipients.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.recipients.v
	case 5:
		k = &fieldName__EncodedJWE_Tag
		if itr.n.tag.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.tag.v
	case 6:
		k = &fieldName__EncodedJWE_Unprotected
		if itr.n.unprotected.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = itr.n.unprotected.v
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_EncodedJWE__MapItr) Done() bool {
	return itr.idx >= 7
}

func (EncodedJWE) ListIterator() datamodel.ListIterator {
	return nil
}
func (EncodedJWE) Length() int64 {
	return 7
}
func (EncodedJWE) IsAbsent() bool {
	return false
}
func (EncodedJWE) IsNull() bool {
	return false
}
func (EncodedJWE) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWE"}.AsBool()
}
func (EncodedJWE) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWE"}.AsInt()
}
func (EncodedJWE) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWE"}.AsFloat()
}
func (EncodedJWE) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWE"}.AsString()
}
func (EncodedJWE) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWE"}.AsBytes()
}
func (EncodedJWE) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWE"}.AsLink()
}
func (EncodedJWE) Prototype() datamodel.NodePrototype {
	return _EncodedJWE__Prototype{}
}

type _EncodedJWE__Prototype struct{}

func (_EncodedJWE__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _EncodedJWE__Builder
	nb.Reset()
	return &nb
}

type _EncodedJWE__Builder struct {
	_EncodedJWE__Assembler
}

func (nb *_EncodedJWE__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_EncodedJWE__Builder) Reset() {
	var w _EncodedJWE
	var m schema.Maybe
	*nb = _EncodedJWE__Builder{_EncodedJWE__Assembler{w: &w, m: &m}}
}

type _EncodedJWE__Assembler struct {
	w     *_EncodedJWE
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm             schema.Maybe
	ca_aad         _Raw__Assembler
	ca_ciphertext  _Raw__Assembler
	ca_iv          _Raw__Assembler
	ca_protected   _Raw__Assembler
	ca_recipients  _EncodedRecipients__Assembler
	ca_tag         _Raw__Assembler
	ca_unprotected _Any__Assembler
}

func (na *_EncodedJWE__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_aad.reset()
	na.ca_ciphertext.reset()
	na.ca_iv.reset()
	na.ca_protected.reset()
	na.ca_recipients.reset()
	na.ca_tag.reset()
	na.ca_unprotected.reset()
}

var (
	fieldBit__EncodedJWE_Aad         = 1 << 0
	fieldBit__EncodedJWE_Ciphertext  = 1 << 1
	fieldBit__EncodedJWE_Iv          = 1 << 2
	fieldBit__EncodedJWE_Protected   = 1 << 3
	fieldBit__EncodedJWE_Recipients  = 1 << 4
	fieldBit__EncodedJWE_Tag         = 1 << 5
	fieldBit__EncodedJWE_Unprotected = 1 << 6
	fieldBits__EncodedJWE_sufficient = 0 + 1<<1
)

func (na *_EncodedJWE__Assembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_EncodedJWE{}
	}
	return na, nil
}
func (_EncodedJWE__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE"}.BeginList(0)
}
func (na *_EncodedJWE__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_EncodedJWE__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE"}.AssignBool(false)
}
func (_EncodedJWE__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE"}.AssignInt(0)
}
func (_EncodedJWE__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE"}.AssignFloat(0)
}
func (_EncodedJWE__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE"}.AssignString("")
}
func (_EncodedJWE__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE"}.AssignBytes(nil)
}
func (_EncodedJWE__Assembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE"}.AssignLink(nil)
}
func (na *_EncodedJWE__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_EncodedJWE); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.EncodedJWE", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_EncodedJWE__Assembler) Prototype() datamodel.NodePrototype {
	return _EncodedJWE__Prototype{}
}
func (ma *_EncodedJWE__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.aad.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_ciphertext.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.w.iv.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 3:
		switch ma.w.protected.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 4:
		switch ma.w.recipients.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 5:
		switch ma.w.tag.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 6:
		switch ma.w.unprotected.m {
		case schema.Maybe_Value:
			ma.w.unprotected.v = ma.ca_unprotected.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedJWE__Assembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "aad":
		if ma.s&fieldBit__EncodedJWE_Aad != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Aad}
		}
		ma.s += fieldBit__EncodedJWE_Aad
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_aad.w = &ma.w.aad.v
		ma.ca_aad.m = &ma.w.aad.m
		return &ma.ca_aad, nil
	case "ciphertext":
		if ma.s&fieldBit__EncodedJWE_Ciphertext != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Ciphertext}
		}
		ma.s += fieldBit__EncodedJWE_Ciphertext
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_ciphertext.w = &ma.w.ciphertext
		ma.ca_ciphertext.m = &ma.cm
		return &ma.ca_ciphertext, nil
	case "iv":
		if ma.s&fieldBit__EncodedJWE_Iv != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Iv}
		}
		ma.s += fieldBit__EncodedJWE_Iv
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_iv.w = &ma.w.iv.v
		ma.ca_iv.m = &ma.w.iv.m
		return &ma.ca_iv, nil
	case "protected":
		if ma.s&fieldBit__EncodedJWE_Protected != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Protected}
		}
		ma.s += fieldBit__EncodedJWE_Protected
		ma.state = maState_midValue
		ma.f = 3
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m
		return &ma.ca_protected, nil
	case "recipients":
		if ma.s&fieldBit__EncodedJWE_Recipients != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Recipients}
		}
		ma.s += fieldBit__EncodedJWE_Recipients
		ma.state = maState_midValue
		ma.f = 4
		ma.ca_recipients.w = &ma.w.recipients.v
		ma.ca_recipients.m = &ma.w.recipients.m
		return &ma.ca_recipients, nil
	case "tag":
		if ma.s&fieldBit__EncodedJWE_Tag != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Tag}
		}
		ma.s += fieldBit__EncodedJWE_Tag
		ma.state = maState_midValue
		ma.f = 5
		ma.ca_tag.w = &ma.w.tag.v
		ma.ca_tag.m = &ma.w.tag.m
		return &ma.ca_tag, nil
	case "unprotected":
		if ma.s&fieldBit__EncodedJWE_Unprotected != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Unprotected}
		}
		ma.s += fieldBit__EncodedJWE_Unprotected
		ma.state = maState_midValue
		ma.f = 6
		ma.ca_unprotected.w = ma.w.unprotected.v
		ma.ca_unprotected.m = &ma.w.unprotected.m
		return &ma.ca_unprotected, nil
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.EncodedJWE", Key: &_String{k}}
}
func (ma *_EncodedJWE__Assembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_EncodedJWE__KeyAssembler)(ma)
}
func (ma *_EncodedJWE__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_aad.w = &ma.w.aad.v
		ma.ca_aad.m = &ma.w.aad.m
		return &ma.ca_aad
	case 1:
		ma.ca_ciphertext.w = &ma.w.ciphertext
		ma.ca_ciphertext.m = &ma.cm
		return &ma.ca_ciphertext
	case 2:
		ma.ca_iv.w = &ma.w.iv.v
		ma.ca_iv.m = &ma.w.iv.m
		return &ma.ca_iv
	case 3:
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m
		return &ma.ca_protected
	case 4:
		ma.ca_recipients.w = &ma.w.recipients.v
		ma.ca_recipients.m = &ma.w.recipients.m
		return &ma.ca_recipients
	case 5:
		ma.ca_tag.w = &ma.w.tag.v
		ma.ca_tag.m = &ma.w.tag.m
		return &ma.ca_tag
	case 6:
		ma.ca_unprotected.w = ma.w.unprotected.v
		ma.ca_unprotected.m = &ma.w.unprotected.m
		return &ma.ca_unprotected
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedJWE__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__EncodedJWE_sufficient != fieldBits__EncodedJWE_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__EncodedJWE_Ciphertext == 0 {
			err.Missing = append(err.Missing, "ciphertext")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_EncodedJWE__Assembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_EncodedJWE__Assembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _EncodedJWE__KeyAssembler _EncodedJWE__Assembler

func (_EncodedJWE__KeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.KeyAssembler"}.BeginMap(0)
}
func (_EncodedJWE__KeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.KeyAssembler"}.BeginList(0)
}
func (na *_EncodedJWE__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.KeyAssembler"}.AssignNull()
}
func (_EncodedJWE__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.KeyAssembler"}.AssignBool(false)
}
func (_EncodedJWE__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.KeyAssembler"}.AssignInt(0)
}
func (_EncodedJWE__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.KeyAssembler"}.AssignFloat(0)
}
func (ka *_EncodedJWE__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "aad":
		if ka.s&fieldBit__EncodedJWE_Aad != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Aad}
		}
		ka.s += fieldBit__EncodedJWE_Aad
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "ciphertext":
		if ka.s&fieldBit__EncodedJWE_Ciphertext != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Ciphertext}
		}
		ka.s += fieldBit__EncodedJWE_Ciphertext
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "iv":
		if ka.s&fieldBit__EncodedJWE_Iv != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Iv}
		}
		ka.s += fieldBit__EncodedJWE_Iv
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	case "protected":
		if ka.s&fieldBit__EncodedJWE_Protected != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Protected}
		}
		ka.s += fieldBit__EncodedJWE_Protected
		ka.state = maState_expectValue
		ka.f = 3
		return nil
	case "recipients":
		if ka.s&fieldBit__EncodedJWE_Recipients != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Recipients}
		}
		ka.s += fieldBit__EncodedJWE_Recipients
		ka.state = maState_expectValue
		ka.f = 4
		return nil
	case "tag":
		if ka.s&fieldBit__EncodedJWE_Tag != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Tag}
		}
		ka.s += fieldBit__EncodedJWE_Tag
		ka.state = maState_expectValue
		ka.f = 5
		return nil
	case "unprotected":
		if ka.s&fieldBit__EncodedJWE_Unprotected != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Unprotected}
		}
		ka.s += fieldBit__EncodedJWE_Unprotected
		ka.state = maState_expectValue
		ka.f = 6
		return nil
	default:
		return schema.ErrInvalidKey{TypeName: "dagjose.EncodedJWE", Key: &_String{k}}
	}
}
func (_EncodedJWE__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.KeyAssembler"}.AssignBytes(nil)
}
func (_EncodedJWE__KeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.KeyAssembler"}.AssignLink(nil)
}
func (ka *_EncodedJWE__KeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_EncodedJWE__KeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (EncodedJWE) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n EncodedJWE) Representation() datamodel.Node {
	return (*_EncodedJWE__Repr)(n)
}

type _EncodedJWE__Repr _EncodedJWE

var (
	fieldName__EncodedJWE_Aad_serial         = _String{"aad"}
	fieldName__EncodedJWE_Ciphertext_serial  = _String{"ciphertext"}
	fieldName__EncodedJWE_Iv_serial          = _String{"iv"}
	fieldName__EncodedJWE_Protected_serial   = _String{"protected"}
	fieldName__EncodedJWE_Recipients_serial  = _String{"recipients"}
	fieldName__EncodedJWE_Tag_serial         = _String{"tag"}
	fieldName__EncodedJWE_Unprotected_serial = _String{"unprotected"}
)
var _ datamodel.Node = &_EncodedJWE__Repr{}

func (_EncodedJWE__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n *_EncodedJWE__Repr) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "aad":
		if n.aad.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.aad.v.Representation(), nil
	case "ciphertext":
		return n.ciphertext.Representation(), nil
	case "iv":
		if n.iv.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.iv.v.Representation(), nil
	case "protected":
		if n.protected.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.protected.v.Representation(), nil
	case "recipients":
		if n.recipients.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.recipients.v.Representation(), nil
	case "tag":
		if n.tag.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.tag.v.Representation(), nil
	case "unprotected":
		if n.unprotected.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.unprotected.v.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n *_EncodedJWE__Repr) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_EncodedJWE__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWE.Repr"}.LookupByIndex(0)
}
func (n _EncodedJWE__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_EncodedJWE__Repr) MapIterator() datamodel.MapIterator {
	end := 7
	if n.unprotected.m == schema.Maybe_Absent {
		end = 6
	} else {
		goto done
	}
	if n.tag.m == schema.Maybe_Absent {
		end = 5
	} else {
		goto done
	}
	if n.recipients.m == schema.Maybe_Absent {
		end = 4
	} else {
		goto done
	}
	if n.protected.m == schema.Maybe_Absent {
		end = 3
	} else {
		goto done
	}
	if n.iv.m == schema.Maybe_Absent {
		end = 2
	} else {
		goto done
	}
done:
	return &_EncodedJWE__ReprMapItr{n, 0, end}
}

type _EncodedJWE__ReprMapItr struct {
	n   *_EncodedJWE__Repr
	idx int
	end int
}

func (itr *_EncodedJWE__ReprMapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
advance:
	if itr.idx >= 7 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__EncodedJWE_Aad_serial
		if itr.n.aad.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.aad.v.Representation()
	case 1:
		k = &fieldName__EncodedJWE_Ciphertext_serial
		v = itr.n.ciphertext.Representation()
	case 2:
		k = &fieldName__EncodedJWE_Iv_serial
		if itr.n.iv.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.iv.v.Representation()
	case 3:
		k = &fieldName__EncodedJWE_Protected_serial
		if itr.n.protected.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.protected.v.Representation()
	case 4:
		k = &fieldName__EncodedJWE_Recipients_serial
		if itr.n.recipients.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.recipients.v.Representation()
	case 5:
		k = &fieldName__EncodedJWE_Tag_serial
		if itr.n.tag.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.tag.v.Representation()
	case 6:
		k = &fieldName__EncodedJWE_Unprotected_serial
		if itr.n.unprotected.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.unprotected.v.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_EncodedJWE__ReprMapItr) Done() bool {
	return itr.idx >= itr.end
}
func (_EncodedJWE__Repr) ListIterator() datamodel.ListIterator {
	return nil
}
func (rn *_EncodedJWE__Repr) Length() int64 {
	l := 7
	if rn.aad.m == schema.Maybe_Absent {
		l--
	}
	if rn.iv.m == schema.Maybe_Absent {
		l--
	}
	if rn.protected.m == schema.Maybe_Absent {
		l--
	}
	if rn.recipients.m == schema.Maybe_Absent {
		l--
	}
	if rn.tag.m == schema.Maybe_Absent {
		l--
	}
	if rn.unprotected.m == schema.Maybe_Absent {
		l--
	}
	return int64(l)
}
func (_EncodedJWE__Repr) IsAbsent() bool {
	return false
}
func (_EncodedJWE__Repr) IsNull() bool {
	return false
}
func (_EncodedJWE__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWE.Repr"}.AsBool()
}
func (_EncodedJWE__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWE.Repr"}.AsInt()
}
func (_EncodedJWE__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWE.Repr"}.AsFloat()
}
func (_EncodedJWE__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWE.Repr"}.AsString()
}
func (_EncodedJWE__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWE.Repr"}.AsBytes()
}
func (_EncodedJWE__Repr) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWE.Repr"}.AsLink()
}
func (_EncodedJWE__Repr) Prototype() datamodel.NodePrototype {
	return _EncodedJWE__ReprPrototype{}
}

type _EncodedJWE__ReprPrototype struct{}

func (_EncodedJWE__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _EncodedJWE__ReprBuilder
	nb.Reset()
	return &nb
}

type _EncodedJWE__ReprBuilder struct {
	_EncodedJWE__ReprAssembler
}

func (nb *_EncodedJWE__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_EncodedJWE__ReprBuilder) Reset() {
	var w _EncodedJWE
	var m schema.Maybe
	*nb = _EncodedJWE__ReprBuilder{_EncodedJWE__ReprAssembler{w: &w, m: &m}}
}

type _EncodedJWE__ReprAssembler struct {
	w     *_EncodedJWE
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm             schema.Maybe
	ca_aad         _Raw__ReprAssembler
	ca_ciphertext  _Raw__ReprAssembler
	ca_iv          _Raw__ReprAssembler
	ca_protected   _Raw__ReprAssembler
	ca_recipients  _EncodedRecipients__ReprAssembler
	ca_tag         _Raw__ReprAssembler
	ca_unprotected _Any__ReprAssembler
}

func (na *_EncodedJWE__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_aad.reset()
	na.ca_ciphertext.reset()
	na.ca_iv.reset()
	na.ca_protected.reset()
	na.ca_recipients.reset()
	na.ca_tag.reset()
	na.ca_unprotected.reset()
}
func (na *_EncodedJWE__ReprAssembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_EncodedJWE{}
	}
	return na, nil
}
func (_EncodedJWE__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE.Repr"}.BeginList(0)
}
func (na *_EncodedJWE__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_EncodedJWE__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE.Repr"}.AssignBool(false)
}
func (_EncodedJWE__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE.Repr"}.AssignInt(0)
}
func (_EncodedJWE__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE.Repr"}.AssignFloat(0)
}
func (_EncodedJWE__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE.Repr"}.AssignString("")
}
func (_EncodedJWE__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE.Repr"}.AssignBytes(nil)
}
func (_EncodedJWE__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWE.Repr"}.AssignLink(nil)
}
func (na *_EncodedJWE__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_EncodedJWE); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.EncodedJWE.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_EncodedJWE__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _EncodedJWE__ReprPrototype{}
}
func (ma *_EncodedJWE__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.aad.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.w.iv.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 3:
		switch ma.w.protected.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 4:
		switch ma.w.recipients.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 5:
		switch ma.w.tag.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 6:
		switch ma.w.unprotected.m {
		case schema.Maybe_Value:
			ma.w.unprotected.v = ma.ca_unprotected.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedJWE__ReprAssembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "aad":
		if ma.s&fieldBit__EncodedJWE_Aad != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Aad_serial}
		}
		ma.s += fieldBit__EncodedJWE_Aad
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_aad.w = &ma.w.aad.v
		ma.ca_aad.m = &ma.w.aad.m

		return &ma.ca_aad, nil
	case "ciphertext":
		if ma.s&fieldBit__EncodedJWE_Ciphertext != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Ciphertext_serial}
		}
		ma.s += fieldBit__EncodedJWE_Ciphertext
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_ciphertext.w = &ma.w.ciphertext
		ma.ca_ciphertext.m = &ma.cm
		return &ma.ca_ciphertext, nil
	case "iv":
		if ma.s&fieldBit__EncodedJWE_Iv != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Iv_serial}
		}
		ma.s += fieldBit__EncodedJWE_Iv
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_iv.w = &ma.w.iv.v
		ma.ca_iv.m = &ma.w.iv.m

		return &ma.ca_iv, nil
	case "protected":
		if ma.s&fieldBit__EncodedJWE_Protected != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Protected_serial}
		}
		ma.s += fieldBit__EncodedJWE_Protected
		ma.state = maState_midValue
		ma.f = 3
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m

		return &ma.ca_protected, nil
	case "recipients":
		if ma.s&fieldBit__EncodedJWE_Recipients != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Recipients_serial}
		}
		ma.s += fieldBit__EncodedJWE_Recipients
		ma.state = maState_midValue
		ma.f = 4
		ma.ca_recipients.w = &ma.w.recipients.v
		ma.ca_recipients.m = &ma.w.recipients.m

		return &ma.ca_recipients, nil
	case "tag":
		if ma.s&fieldBit__EncodedJWE_Tag != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Tag_serial}
		}
		ma.s += fieldBit__EncodedJWE_Tag
		ma.state = maState_midValue
		ma.f = 5
		ma.ca_tag.w = &ma.w.tag.v
		ma.ca_tag.m = &ma.w.tag.m

		return &ma.ca_tag, nil
	case "unprotected":
		if ma.s&fieldBit__EncodedJWE_Unprotected != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Unprotected_serial}
		}
		ma.s += fieldBit__EncodedJWE_Unprotected
		ma.state = maState_midValue
		ma.f = 6
		ma.ca_unprotected.w = ma.w.unprotected.v
		ma.ca_unprotected.m = &ma.w.unprotected.m

		return &ma.ca_unprotected, nil
	default:
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.EncodedJWE.Repr", Key: &_String{k}}
}
func (ma *_EncodedJWE__ReprAssembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_EncodedJWE__ReprKeyAssembler)(ma)
}
func (ma *_EncodedJWE__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_aad.w = &ma.w.aad.v
		ma.ca_aad.m = &ma.w.aad.m

		return &ma.ca_aad
	case 1:
		ma.ca_ciphertext.w = &ma.w.ciphertext
		ma.ca_ciphertext.m = &ma.cm
		return &ma.ca_ciphertext
	case 2:
		ma.ca_iv.w = &ma.w.iv.v
		ma.ca_iv.m = &ma.w.iv.m

		return &ma.ca_iv
	case 3:
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m

		return &ma.ca_protected
	case 4:
		ma.ca_recipients.w = &ma.w.recipients.v
		ma.ca_recipients.m = &ma.w.recipients.m

		return &ma.ca_recipients
	case 5:
		ma.ca_tag.w = &ma.w.tag.v
		ma.ca_tag.m = &ma.w.tag.m

		return &ma.ca_tag
	case 6:
		ma.ca_unprotected.w = ma.w.unprotected.v
		ma.ca_unprotected.m = &ma.w.unprotected.m

		return &ma.ca_unprotected
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedJWE__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__EncodedJWE_sufficient != fieldBits__EncodedJWE_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__EncodedJWE_Ciphertext == 0 {
			err.Missing = append(err.Missing, "ciphertext")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_EncodedJWE__ReprAssembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_EncodedJWE__ReprAssembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _EncodedJWE__ReprKeyAssembler _EncodedJWE__ReprAssembler

func (_EncodedJWE__ReprKeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.Repr.KeyAssembler"}.BeginMap(0)
}
func (_EncodedJWE__ReprKeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_EncodedJWE__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.Repr.KeyAssembler"}.AssignNull()
}
func (_EncodedJWE__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.Repr.KeyAssembler"}.AssignBool(false)
}
func (_EncodedJWE__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.Repr.KeyAssembler"}.AssignInt(0)
}
func (_EncodedJWE__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_EncodedJWE__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "aad":
		if ka.s&fieldBit__EncodedJWE_Aad != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Aad_serial}
		}
		ka.s += fieldBit__EncodedJWE_Aad
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "ciphertext":
		if ka.s&fieldBit__EncodedJWE_Ciphertext != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Ciphertext_serial}
		}
		ka.s += fieldBit__EncodedJWE_Ciphertext
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "iv":
		if ka.s&fieldBit__EncodedJWE_Iv != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Iv_serial}
		}
		ka.s += fieldBit__EncodedJWE_Iv
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	case "protected":
		if ka.s&fieldBit__EncodedJWE_Protected != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Protected_serial}
		}
		ka.s += fieldBit__EncodedJWE_Protected
		ka.state = maState_expectValue
		ka.f = 3
		return nil
	case "recipients":
		if ka.s&fieldBit__EncodedJWE_Recipients != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Recipients_serial}
		}
		ka.s += fieldBit__EncodedJWE_Recipients
		ka.state = maState_expectValue
		ka.f = 4
		return nil
	case "tag":
		if ka.s&fieldBit__EncodedJWE_Tag != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Tag_serial}
		}
		ka.s += fieldBit__EncodedJWE_Tag
		ka.state = maState_expectValue
		ka.f = 5
		return nil
	case "unprotected":
		if ka.s&fieldBit__EncodedJWE_Unprotected != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWE_Unprotected_serial}
		}
		ka.s += fieldBit__EncodedJWE_Unprotected
		ka.state = maState_expectValue
		ka.f = 6
		return nil
	}
	return schema.ErrInvalidKey{TypeName: "dagjose.EncodedJWE.Repr", Key: &_String{k}}
}
func (_EncodedJWE__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_EncodedJWE__ReprKeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWE.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_EncodedJWE__ReprKeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_EncodedJWE__ReprKeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}

func (n _EncodedJWS) FieldPayload() Raw {
	return &n.payload
}
func (n _EncodedJWS) FieldSignatures() MaybeEncodedSignatures {
	return &n.signatures
}

type _EncodedJWS__Maybe struct {
	m schema.Maybe
	v EncodedJWS
}
type MaybeEncodedJWS = *_EncodedJWS__Maybe

func (m MaybeEncodedJWS) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeEncodedJWS) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeEncodedJWS) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeEncodedJWS) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeEncodedJWS) Must() EncodedJWS {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__EncodedJWS_Payload    = _String{"payload"}
	fieldName__EncodedJWS_Signatures = _String{"signatures"}
)
var _ datamodel.Node = (EncodedJWS)(&_EncodedJWS{})
var _ schema.TypedNode = (EncodedJWS)(&_EncodedJWS{})

func (EncodedJWS) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n EncodedJWS) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "payload":
		return &n.payload, nil
	case "signatures":
		if n.signatures.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.signatures.v, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n EncodedJWS) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (EncodedJWS) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWS"}.LookupByIndex(0)
}
func (n EncodedJWS) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n EncodedJWS) MapIterator() datamodel.MapIterator {
	return &_EncodedJWS__MapItr{n, 0}
}

type _EncodedJWS__MapItr struct {
	n   EncodedJWS
	idx int
}

func (itr *_EncodedJWS__MapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
	if itr.idx >= 2 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__EncodedJWS_Payload
		v = &itr.n.payload
	case 1:
		k = &fieldName__EncodedJWS_Signatures
		if itr.n.signatures.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.signatures.v
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_EncodedJWS__MapItr) Done() bool {
	return itr.idx >= 2
}

func (EncodedJWS) ListIterator() datamodel.ListIterator {
	return nil
}
func (EncodedJWS) Length() int64 {
	return 2
}
func (EncodedJWS) IsAbsent() bool {
	return false
}
func (EncodedJWS) IsNull() bool {
	return false
}
func (EncodedJWS) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWS"}.AsBool()
}
func (EncodedJWS) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWS"}.AsInt()
}
func (EncodedJWS) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWS"}.AsFloat()
}
func (EncodedJWS) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWS"}.AsString()
}
func (EncodedJWS) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWS"}.AsBytes()
}
func (EncodedJWS) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWS"}.AsLink()
}
func (EncodedJWS) Prototype() datamodel.NodePrototype {
	return _EncodedJWS__Prototype{}
}

type _EncodedJWS__Prototype struct{}

func (_EncodedJWS__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _EncodedJWS__Builder
	nb.Reset()
	return &nb
}

type _EncodedJWS__Builder struct {
	_EncodedJWS__Assembler
}

func (nb *_EncodedJWS__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_EncodedJWS__Builder) Reset() {
	var w _EncodedJWS
	var m schema.Maybe
	*nb = _EncodedJWS__Builder{_EncodedJWS__Assembler{w: &w, m: &m}}
}

type _EncodedJWS__Assembler struct {
	w     *_EncodedJWS
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm            schema.Maybe
	ca_payload    _Raw__Assembler
	ca_signatures _EncodedSignatures__Assembler
}

func (na *_EncodedJWS__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_payload.reset()
	na.ca_signatures.reset()
}

var (
	fieldBit__EncodedJWS_Payload     = 1 << 0
	fieldBit__EncodedJWS_Signatures  = 1 << 1
	fieldBits__EncodedJWS_sufficient = 0 + 1<<0
)

func (na *_EncodedJWS__Assembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_EncodedJWS{}
	}
	return na, nil
}
func (_EncodedJWS__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS"}.BeginList(0)
}
func (na *_EncodedJWS__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_EncodedJWS__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS"}.AssignBool(false)
}
func (_EncodedJWS__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS"}.AssignInt(0)
}
func (_EncodedJWS__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS"}.AssignFloat(0)
}
func (_EncodedJWS__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS"}.AssignString("")
}
func (_EncodedJWS__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS"}.AssignBytes(nil)
}
func (_EncodedJWS__Assembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS"}.AssignLink(nil)
}
func (na *_EncodedJWS__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_EncodedJWS); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.EncodedJWS", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_EncodedJWS__Assembler) Prototype() datamodel.NodePrototype {
	return _EncodedJWS__Prototype{}
}
func (ma *_EncodedJWS__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_payload.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.signatures.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedJWS__Assembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "payload":
		if ma.s&fieldBit__EncodedJWS_Payload != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWS_Payload}
		}
		ma.s += fieldBit__EncodedJWS_Payload
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_payload.w = &ma.w.payload
		ma.ca_payload.m = &ma.cm
		return &ma.ca_payload, nil
	case "signatures":
		if ma.s&fieldBit__EncodedJWS_Signatures != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWS_Signatures}
		}
		ma.s += fieldBit__EncodedJWS_Signatures
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_signatures.w = &ma.w.signatures.v
		ma.ca_signatures.m = &ma.w.signatures.m
		return &ma.ca_signatures, nil
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.EncodedJWS", Key: &_String{k}}
}
func (ma *_EncodedJWS__Assembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_EncodedJWS__KeyAssembler)(ma)
}
func (ma *_EncodedJWS__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_payload.w = &ma.w.payload
		ma.ca_payload.m = &ma.cm
		return &ma.ca_payload
	case 1:
		ma.ca_signatures.w = &ma.w.signatures.v
		ma.ca_signatures.m = &ma.w.signatures.m
		return &ma.ca_signatures
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedJWS__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__EncodedJWS_sufficient != fieldBits__EncodedJWS_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__EncodedJWS_Payload == 0 {
			err.Missing = append(err.Missing, "payload")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_EncodedJWS__Assembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_EncodedJWS__Assembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _EncodedJWS__KeyAssembler _EncodedJWS__Assembler

func (_EncodedJWS__KeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.KeyAssembler"}.BeginMap(0)
}
func (_EncodedJWS__KeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.KeyAssembler"}.BeginList(0)
}
func (na *_EncodedJWS__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.KeyAssembler"}.AssignNull()
}
func (_EncodedJWS__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.KeyAssembler"}.AssignBool(false)
}
func (_EncodedJWS__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.KeyAssembler"}.AssignInt(0)
}
func (_EncodedJWS__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.KeyAssembler"}.AssignFloat(0)
}
func (ka *_EncodedJWS__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "payload":
		if ka.s&fieldBit__EncodedJWS_Payload != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWS_Payload}
		}
		ka.s += fieldBit__EncodedJWS_Payload
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "signatures":
		if ka.s&fieldBit__EncodedJWS_Signatures != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWS_Signatures}
		}
		ka.s += fieldBit__EncodedJWS_Signatures
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	default:
		return schema.ErrInvalidKey{TypeName: "dagjose.EncodedJWS", Key: &_String{k}}
	}
}
func (_EncodedJWS__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.KeyAssembler"}.AssignBytes(nil)
}
func (_EncodedJWS__KeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.KeyAssembler"}.AssignLink(nil)
}
func (ka *_EncodedJWS__KeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_EncodedJWS__KeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (EncodedJWS) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n EncodedJWS) Representation() datamodel.Node {
	return (*_EncodedJWS__Repr)(n)
}

type _EncodedJWS__Repr _EncodedJWS

var (
	fieldName__EncodedJWS_Payload_serial    = _String{"payload"}
	fieldName__EncodedJWS_Signatures_serial = _String{"signatures"}
)
var _ datamodel.Node = &_EncodedJWS__Repr{}

func (_EncodedJWS__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n *_EncodedJWS__Repr) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "payload":
		return n.payload.Representation(), nil
	case "signatures":
		if n.signatures.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.signatures.v.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n *_EncodedJWS__Repr) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_EncodedJWS__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWS.Repr"}.LookupByIndex(0)
}
func (n _EncodedJWS__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_EncodedJWS__Repr) MapIterator() datamodel.MapIterator {
	end := 2
	if n.signatures.m == schema.Maybe_Absent {
		end = 1
	} else {
		goto done
	}
done:
	return &_EncodedJWS__ReprMapItr{n, 0, end}
}

type _EncodedJWS__ReprMapItr struct {
	n   *_EncodedJWS__Repr
	idx int
	end int
}

func (itr *_EncodedJWS__ReprMapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
advance:
	if itr.idx >= 2 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__EncodedJWS_Payload_serial
		v = itr.n.payload.Representation()
	case 1:
		k = &fieldName__EncodedJWS_Signatures_serial
		if itr.n.signatures.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.signatures.v.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_EncodedJWS__ReprMapItr) Done() bool {
	return itr.idx >= itr.end
}
func (_EncodedJWS__Repr) ListIterator() datamodel.ListIterator {
	return nil
}
func (rn *_EncodedJWS__Repr) Length() int64 {
	l := 2
	if rn.signatures.m == schema.Maybe_Absent {
		l--
	}
	return int64(l)
}
func (_EncodedJWS__Repr) IsAbsent() bool {
	return false
}
func (_EncodedJWS__Repr) IsNull() bool {
	return false
}
func (_EncodedJWS__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWS.Repr"}.AsBool()
}
func (_EncodedJWS__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWS.Repr"}.AsInt()
}
func (_EncodedJWS__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWS.Repr"}.AsFloat()
}
func (_EncodedJWS__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWS.Repr"}.AsString()
}
func (_EncodedJWS__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWS.Repr"}.AsBytes()
}
func (_EncodedJWS__Repr) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.EncodedJWS.Repr"}.AsLink()
}
func (_EncodedJWS__Repr) Prototype() datamodel.NodePrototype {
	return _EncodedJWS__ReprPrototype{}
}

type _EncodedJWS__ReprPrototype struct{}

func (_EncodedJWS__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _EncodedJWS__ReprBuilder
	nb.Reset()
	return &nb
}

type _EncodedJWS__ReprBuilder struct {
	_EncodedJWS__ReprAssembler
}

func (nb *_EncodedJWS__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_EncodedJWS__ReprBuilder) Reset() {
	var w _EncodedJWS
	var m schema.Maybe
	*nb = _EncodedJWS__ReprBuilder{_EncodedJWS__ReprAssembler{w: &w, m: &m}}
}

type _EncodedJWS__ReprAssembler struct {
	w     *_EncodedJWS
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm            schema.Maybe
	ca_payload    _Raw__ReprAssembler
	ca_signatures _EncodedSignatures__ReprAssembler
}

func (na *_EncodedJWS__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_payload.reset()
	na.ca_signatures.reset()
}
func (na *_EncodedJWS__ReprAssembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_EncodedJWS{}
	}
	return na, nil
}
func (_EncodedJWS__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS.Repr"}.BeginList(0)
}
func (na *_EncodedJWS__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_EncodedJWS__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS.Repr"}.AssignBool(false)
}
func (_EncodedJWS__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS.Repr"}.AssignInt(0)
}
func (_EncodedJWS__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS.Repr"}.AssignFloat(0)
}
func (_EncodedJWS__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS.Repr"}.AssignString("")
}
func (_EncodedJWS__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS.Repr"}.AssignBytes(nil)
}
func (_EncodedJWS__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedJWS.Repr"}.AssignLink(nil)
}
func (na *_EncodedJWS__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_EncodedJWS); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.EncodedJWS.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_EncodedJWS__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _EncodedJWS__ReprPrototype{}
}
func (ma *_EncodedJWS__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.signatures.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedJWS__ReprAssembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "payload":
		if ma.s&fieldBit__EncodedJWS_Payload != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWS_Payload_serial}
		}
		ma.s += fieldBit__EncodedJWS_Payload
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_payload.w = &ma.w.payload
		ma.ca_payload.m = &ma.cm
		return &ma.ca_payload, nil
	case "signatures":
		if ma.s&fieldBit__EncodedJWS_Signatures != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWS_Signatures_serial}
		}
		ma.s += fieldBit__EncodedJWS_Signatures
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_signatures.w = &ma.w.signatures.v
		ma.ca_signatures.m = &ma.w.signatures.m

		return &ma.ca_signatures, nil
	default:
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.EncodedJWS.Repr", Key: &_String{k}}
}
func (ma *_EncodedJWS__ReprAssembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_EncodedJWS__ReprKeyAssembler)(ma)
}
func (ma *_EncodedJWS__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_payload.w = &ma.w.payload
		ma.ca_payload.m = &ma.cm
		return &ma.ca_payload
	case 1:
		ma.ca_signatures.w = &ma.w.signatures.v
		ma.ca_signatures.m = &ma.w.signatures.m

		return &ma.ca_signatures
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedJWS__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__EncodedJWS_sufficient != fieldBits__EncodedJWS_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__EncodedJWS_Payload == 0 {
			err.Missing = append(err.Missing, "payload")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_EncodedJWS__ReprAssembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_EncodedJWS__ReprAssembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _EncodedJWS__ReprKeyAssembler _EncodedJWS__ReprAssembler

func (_EncodedJWS__ReprKeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.Repr.KeyAssembler"}.BeginMap(0)
}
func (_EncodedJWS__ReprKeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_EncodedJWS__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.Repr.KeyAssembler"}.AssignNull()
}
func (_EncodedJWS__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.Repr.KeyAssembler"}.AssignBool(false)
}
func (_EncodedJWS__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.Repr.KeyAssembler"}.AssignInt(0)
}
func (_EncodedJWS__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_EncodedJWS__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "payload":
		if ka.s&fieldBit__EncodedJWS_Payload != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWS_Payload_serial}
		}
		ka.s += fieldBit__EncodedJWS_Payload
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "signatures":
		if ka.s&fieldBit__EncodedJWS_Signatures != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedJWS_Signatures_serial}
		}
		ka.s += fieldBit__EncodedJWS_Signatures
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	}
	return schema.ErrInvalidKey{TypeName: "dagjose.EncodedJWS.Repr", Key: &_String{k}}
}
func (_EncodedJWS__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_EncodedJWS__ReprKeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedJWS.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_EncodedJWS__ReprKeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_EncodedJWS__ReprKeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}

func (n _EncodedRecipient) FieldHeader() MaybeAny {
	return &n.header
}
func (n _EncodedRecipient) FieldEncrypted_key() MaybeRaw {
	return &n.encrypted_key
}

type _EncodedRecipient__Maybe struct {
	m schema.Maybe
	v EncodedRecipient
}
type MaybeEncodedRecipient = *_EncodedRecipient__Maybe

func (m MaybeEncodedRecipient) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeEncodedRecipient) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeEncodedRecipient) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeEncodedRecipient) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeEncodedRecipient) Must() EncodedRecipient {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__EncodedRecipient_Header        = _String{"header"}
	fieldName__EncodedRecipient_Encrypted_key = _String{"encrypted_key"}
)
var _ datamodel.Node = (EncodedRecipient)(&_EncodedRecipient{})
var _ schema.TypedNode = (EncodedRecipient)(&_EncodedRecipient{})

func (EncodedRecipient) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n EncodedRecipient) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "header":
		if n.header.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return n.header.v, nil
	case "encrypted_key":
		if n.encrypted_key.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.encrypted_key.v, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n EncodedRecipient) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (EncodedRecipient) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.EncodedRecipient"}.LookupByIndex(0)
}
func (n EncodedRecipient) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n EncodedRecipient) MapIterator() datamodel.MapIterator {
	return &_EncodedRecipient__MapItr{n, 0}
}

type _EncodedRecipient__MapItr struct {
	n   EncodedRecipient
	idx int
}

func (itr *_EncodedRecipient__MapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
	if itr.idx >= 2 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__EncodedRecipient_Header
		if itr.n.header.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = itr.n.header.v
	case 1:
		k = &fieldName__EncodedRecipient_Encrypted_key
		if itr.n.encrypted_key.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.encrypted_key.v
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_EncodedRecipient__MapItr) Done() bool {
	return itr.idx >= 2
}

func (EncodedRecipient) ListIterator() datamodel.ListIterator {
	return nil
}
func (EncodedRecipient) Length() int64 {
	return 2
}
func (EncodedRecipient) IsAbsent() bool {
	return false
}
func (EncodedRecipient) IsNull() bool {
	return false
}
func (EncodedRecipient) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.EncodedRecipient"}.AsBool()
}
func (EncodedRecipient) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedRecipient"}.AsInt()
}
func (EncodedRecipient) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedRecipient"}.AsFloat()
}
func (EncodedRecipient) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.EncodedRecipient"}.AsString()
}
func (EncodedRecipient) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.EncodedRecipient"}.AsBytes()
}
func (EncodedRecipient) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.EncodedRecipient"}.AsLink()
}
func (EncodedRecipient) Prototype() datamodel.NodePrototype {
	return _EncodedRecipient__Prototype{}
}

type _EncodedRecipient__Prototype struct{}

func (_EncodedRecipient__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _EncodedRecipient__Builder
	nb.Reset()
	return &nb
}

type _EncodedRecipient__Builder struct {
	_EncodedRecipient__Assembler
}

func (nb *_EncodedRecipient__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_EncodedRecipient__Builder) Reset() {
	var w _EncodedRecipient
	var m schema.Maybe
	*nb = _EncodedRecipient__Builder{_EncodedRecipient__Assembler{w: &w, m: &m}}
}

type _EncodedRecipient__Assembler struct {
	w     *_EncodedRecipient
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm               schema.Maybe
	ca_header        _Any__Assembler
	ca_encrypted_key _Raw__Assembler
}

func (na *_EncodedRecipient__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_header.reset()
	na.ca_encrypted_key.reset()
}

var (
	fieldBit__EncodedRecipient_Header        = 1 << 0
	fieldBit__EncodedRecipient_Encrypted_key = 1 << 1
	fieldBits__EncodedRecipient_sufficient   = 0
)

func (na *_EncodedRecipient__Assembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_EncodedRecipient{}
	}
	return na, nil
}
func (_EncodedRecipient__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient"}.BeginList(0)
}
func (na *_EncodedRecipient__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_EncodedRecipient__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient"}.AssignBool(false)
}
func (_EncodedRecipient__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient"}.AssignInt(0)
}
func (_EncodedRecipient__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient"}.AssignFloat(0)
}
func (_EncodedRecipient__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient"}.AssignString("")
}
func (_EncodedRecipient__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient"}.AssignBytes(nil)
}
func (_EncodedRecipient__Assembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient"}.AssignLink(nil)
}
func (na *_EncodedRecipient__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_EncodedRecipient); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.EncodedRecipient", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_EncodedRecipient__Assembler) Prototype() datamodel.NodePrototype {
	return _EncodedRecipient__Prototype{}
}
func (ma *_EncodedRecipient__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.header.m {
		case schema.Maybe_Value:
			ma.w.header.v = ma.ca_header.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.encrypted_key.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedRecipient__Assembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "header":
		if ma.s&fieldBit__EncodedRecipient_Header != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedRecipient_Header}
		}
		ma.s += fieldBit__EncodedRecipient_Header
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m
		return &ma.ca_header, nil
	case "encrypted_key":
		if ma.s&fieldBit__EncodedRecipient_Encrypted_key != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedRecipient_Encrypted_key}
		}
		ma.s += fieldBit__EncodedRecipient_Encrypted_key
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_encrypted_key.w = &ma.w.encrypted_key.v
		ma.ca_encrypted_key.m = &ma.w.encrypted_key.m
		return &ma.ca_encrypted_key, nil
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.EncodedRecipient", Key: &_String{k}}
}
func (ma *_EncodedRecipient__Assembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_EncodedRecipient__KeyAssembler)(ma)
}
func (ma *_EncodedRecipient__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m
		return &ma.ca_header
	case 1:
		ma.ca_encrypted_key.w = &ma.w.encrypted_key.v
		ma.ca_encrypted_key.m = &ma.w.encrypted_key.m
		return &ma.ca_encrypted_key
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedRecipient__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__EncodedRecipient_sufficient != fieldBits__EncodedRecipient_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_EncodedRecipient__Assembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_EncodedRecipient__Assembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _EncodedRecipient__KeyAssembler _EncodedRecipient__Assembler

func (_EncodedRecipient__KeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.KeyAssembler"}.BeginMap(0)
}
func (_EncodedRecipient__KeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.KeyAssembler"}.BeginList(0)
}
func (na *_EncodedRecipient__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.KeyAssembler"}.AssignNull()
}
func (_EncodedRecipient__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.KeyAssembler"}.AssignBool(false)
}
func (_EncodedRecipient__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.KeyAssembler"}.AssignInt(0)
}
func (_EncodedRecipient__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.KeyAssembler"}.AssignFloat(0)
}
func (ka *_EncodedRecipient__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "header":
		if ka.s&fieldBit__EncodedRecipient_Header != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedRecipient_Header}
		}
		ka.s += fieldBit__EncodedRecipient_Header
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "encrypted_key":
		if ka.s&fieldBit__EncodedRecipient_Encrypted_key != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedRecipient_Encrypted_key}
		}
		ka.s += fieldBit__EncodedRecipient_Encrypted_key
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	default:
		return schema.ErrInvalidKey{TypeName: "dagjose.EncodedRecipient", Key: &_String{k}}
	}
}
func (_EncodedRecipient__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.KeyAssembler"}.AssignBytes(nil)
}
func (_EncodedRecipient__KeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.KeyAssembler"}.AssignLink(nil)
}
func (ka *_EncodedRecipient__KeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_EncodedRecipient__KeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (EncodedRecipient) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n EncodedRecipient) Representation() datamodel.Node {
	return (*_EncodedRecipient__Repr)(n)
}

type _EncodedRecipient__Repr _EncodedRecipient

var (
	fieldName__EncodedRecipient_Header_serial        = _String{"header"}
	fieldName__EncodedRecipient_Encrypted_key_serial = _String{"encrypted_key"}
)
var _ datamodel.Node = &_EncodedRecipient__Repr{}

func (_EncodedRecipient__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n *_EncodedRecipient__Repr) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "header":
		if n.header.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.header.v.Representation(), nil
	case "encrypted_key":
		if n.encrypted_key.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.encrypted_key.v.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n *_EncodedRecipient__Repr) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_EncodedRecipient__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.EncodedRecipient.Repr"}.LookupByIndex(0)
}
func (n _EncodedRecipient__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_EncodedRecipient__Repr) MapIterator() datamodel.MapIterator {
	end := 2
	if n.encrypted_key.m == schema.Maybe_Absent {
		end = 1
	} else {
		goto done
	}
	if n.header.m == schema.Maybe_Absent {
		end = 0
	} else {
		goto done
	}
done:
	return &_EncodedRecipient__ReprMapItr{n, 0, end}
}

type _EncodedRecipient__ReprMapItr struct {
	n   *_EncodedRecipient__Repr
	idx int
	end int
}

func (itr *_EncodedRecipient__ReprMapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
advance:
	if itr.idx >= 2 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__EncodedRecipient_Header_serial
		if itr.n.header.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.header.v.Representation()
	case 1:
		k = &fieldName__EncodedRecipient_Encrypted_key_serial
		if itr.n.encrypted_key.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.encrypted_key.v.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_EncodedRecipient__ReprMapItr) Done() bool {
	return itr.idx >= itr.end
}
func (_EncodedRecipient__Repr) ListIterator() datamodel.ListIterator {
	return nil
}
func (rn *_EncodedRecipient__Repr) Length() int64 {
	l := 2
	if rn.header.m == schema.Maybe_Absent {
		l--
	}
	if rn.encrypted_key.m == schema.Maybe_Absent {
		l--
	}
	return int64(l)
}
func (_EncodedRecipient__Repr) IsAbsent() bool {
	return false
}
func (_EncodedRecipient__Repr) IsNull() bool {
	return false
}
func (_EncodedRecipient__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.EncodedRecipient.Repr"}.AsBool()
}
func (_EncodedRecipient__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedRecipient.Repr"}.AsInt()
}
func (_EncodedRecipient__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedRecipient.Repr"}.AsFloat()
}
func (_EncodedRecipient__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.EncodedRecipient.Repr"}.AsString()
}
func (_EncodedRecipient__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.EncodedRecipient.Repr"}.AsBytes()
}
func (_EncodedRecipient__Repr) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.EncodedRecipient.Repr"}.AsLink()
}
func (_EncodedRecipient__Repr) Prototype() datamodel.NodePrototype {
	return _EncodedRecipient__ReprPrototype{}
}

type _EncodedRecipient__ReprPrototype struct{}

func (_EncodedRecipient__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _EncodedRecipient__ReprBuilder
	nb.Reset()
	return &nb
}

type _EncodedRecipient__ReprBuilder struct {
	_EncodedRecipient__ReprAssembler
}

func (nb *_EncodedRecipient__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_EncodedRecipient__ReprBuilder) Reset() {
	var w _EncodedRecipient
	var m schema.Maybe
	*nb = _EncodedRecipient__ReprBuilder{_EncodedRecipient__ReprAssembler{w: &w, m: &m}}
}

type _EncodedRecipient__ReprAssembler struct {
	w     *_EncodedRecipient
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm               schema.Maybe
	ca_header        _Any__ReprAssembler
	ca_encrypted_key _Raw__ReprAssembler
}

func (na *_EncodedRecipient__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_header.reset()
	na.ca_encrypted_key.reset()
}
func (na *_EncodedRecipient__ReprAssembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_EncodedRecipient{}
	}
	return na, nil
}
func (_EncodedRecipient__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient.Repr"}.BeginList(0)
}
func (na *_EncodedRecipient__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_EncodedRecipient__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient.Repr"}.AssignBool(false)
}
func (_EncodedRecipient__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient.Repr"}.AssignInt(0)
}
func (_EncodedRecipient__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient.Repr"}.AssignFloat(0)
}
func (_EncodedRecipient__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient.Repr"}.AssignString("")
}
func (_EncodedRecipient__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient.Repr"}.AssignBytes(nil)
}
func (_EncodedRecipient__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedRecipient.Repr"}.AssignLink(nil)
}
func (na *_EncodedRecipient__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_EncodedRecipient); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.EncodedRecipient.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_EncodedRecipient__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _EncodedRecipient__ReprPrototype{}
}
func (ma *_EncodedRecipient__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.header.m {
		case schema.Maybe_Value:
			ma.w.header.v = ma.ca_header.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.encrypted_key.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedRecipient__ReprAssembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "header":
		if ma.s&fieldBit__EncodedRecipient_Header != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedRecipient_Header_serial}
		}
		ma.s += fieldBit__EncodedRecipient_Header
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m

		return &ma.ca_header, nil
	case "encrypted_key":
		if ma.s&fieldBit__EncodedRecipient_Encrypted_key != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedRecipient_Encrypted_key_serial}
		}
		ma.s += fieldBit__EncodedRecipient_Encrypted_key
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_encrypted_key.w = &ma.w.encrypted_key.v
		ma.ca_encrypted_key.m = &ma.w.encrypted_key.m

		return &ma.ca_encrypted_key, nil
	default:
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.EncodedRecipient.Repr", Key: &_String{k}}
}
func (ma *_EncodedRecipient__ReprAssembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_EncodedRecipient__ReprKeyAssembler)(ma)
}
func (ma *_EncodedRecipient__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m

		return &ma.ca_header
	case 1:
		ma.ca_encrypted_key.w = &ma.w.encrypted_key.v
		ma.ca_encrypted_key.m = &ma.w.encrypted_key.m

		return &ma.ca_encrypted_key
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedRecipient__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__EncodedRecipient_sufficient != fieldBits__EncodedRecipient_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_EncodedRecipient__ReprAssembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_EncodedRecipient__ReprAssembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _EncodedRecipient__ReprKeyAssembler _EncodedRecipient__ReprAssembler

func (_EncodedRecipient__ReprKeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.Repr.KeyAssembler"}.BeginMap(0)
}
func (_EncodedRecipient__ReprKeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_EncodedRecipient__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.Repr.KeyAssembler"}.AssignNull()
}
func (_EncodedRecipient__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.Repr.KeyAssembler"}.AssignBool(false)
}
func (_EncodedRecipient__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.Repr.KeyAssembler"}.AssignInt(0)
}
func (_EncodedRecipient__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_EncodedRecipient__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "header":
		if ka.s&fieldBit__EncodedRecipient_Header != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedRecipient_Header_serial}
		}
		ka.s += fieldBit__EncodedRecipient_Header
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "encrypted_key":
		if ka.s&fieldBit__EncodedRecipient_Encrypted_key != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedRecipient_Encrypted_key_serial}
		}
		ka.s += fieldBit__EncodedRecipient_Encrypted_key
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	}
	return schema.ErrInvalidKey{TypeName: "dagjose.EncodedRecipient.Repr", Key: &_String{k}}
}
func (_EncodedRecipient__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_EncodedRecipient__ReprKeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedRecipient.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_EncodedRecipient__ReprKeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_EncodedRecipient__ReprKeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}

func (n *_EncodedRecipients) Lookup(idx int64) EncodedRecipient {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return v
}
func (n *_EncodedRecipients) LookupMaybe(idx int64) MaybeEncodedRecipient {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return &_EncodedRecipient__Maybe{
		m: schema.Maybe_Value,
		v: v,
	}
}

var _EncodedRecipients__valueAbsent = _EncodedRecipient__Maybe{m: schema.Maybe_Absent}

func (n EncodedRecipients) Iterator() *EncodedRecipients__Itr {
	return &EncodedRecipients__Itr{n, 0}
}

type EncodedRecipients__Itr struct {
	n   EncodedRecipients
	idx int
}

func (itr *EncodedRecipients__Itr) Next() (idx int64, v EncodedRecipient) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil
	}
	idx = int64(itr.idx)
	v = &itr.n.x[itr.idx]
	itr.idx++
	return
}
func (itr *EncodedRecipients__Itr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

type _EncodedRecipients__Maybe struct {
	m schema.Maybe
	v _EncodedRecipients
}
type MaybeEncodedRecipients = *_EncodedRecipients__Maybe

func (m MaybeEncodedRecipients) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeEncodedRecipients) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeEncodedRecipients) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeEncodedRecipients) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeEncodedRecipients) Must() EncodedRecipients {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (EncodedRecipients)(&_EncodedRecipients{})
var _ schema.TypedNode = (EncodedRecipients)(&_EncodedRecipients{})

func (EncodedRecipients) Kind() datamodel.Kind {
	return datamodel.Kind_List
}
func (EncodedRecipients) LookupByString(string) (datamodel.Node, error) {
	return mixins.List{TypeName: "dagjose.EncodedRecipients"}.LookupByString("")
}
func (n EncodedRecipients) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	idx, err := k.AsInt()
	if err != nil {
		return nil, err
	}
	return n.LookupByIndex(idx)
}
func (n EncodedRecipients) LookupByIndex(idx int64) (datamodel.Node, error) {
	if n.Length() <= idx {
		return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfInt(idx)}
	}
	v := &n.x[idx]
	return v, nil
}
func (n EncodedRecipients) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, datamodel.ErrInvalidSegmentForList{TypeName: "dagjose.EncodedRecipients", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (EncodedRecipients) MapIterator() datamodel.MapIterator {
	return nil
}
func (n EncodedRecipients) ListIterator() datamodel.ListIterator {
	return &_EncodedRecipients__ListItr{n, 0}
}

type _EncodedRecipients__ListItr struct {
	n   EncodedRecipients
	idx int
}

func (itr *_EncodedRecipients__ListItr) Next() (idx int64, v datamodel.Node, _ error) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil, datamodel.ErrIteratorOverread{}
	}
	idx = int64(itr.idx)
	x := &itr.n.x[itr.idx]
	v = x
	itr.idx++
	return
}
func (itr *_EncodedRecipients__ListItr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

func (n EncodedRecipients) Length() int64 {
	return int64(len(n.x))
}
func (EncodedRecipients) IsAbsent() bool {
	return false
}
func (EncodedRecipients) IsNull() bool {
	return false
}
func (EncodedRecipients) AsBool() (bool, error) {
	return mixins.List{TypeName: "dagjose.EncodedRecipients"}.AsBool()
}
func (EncodedRecipients) AsInt() (int64, error) {
	return mixins.List{TypeName: "dagjose.EncodedRecipients"}.AsInt()
}
func (EncodedRecipients) AsFloat() (float64, error) {
	return mixins.List{TypeName: "dagjose.EncodedRecipients"}.AsFloat()
}
func (EncodedRecipients) AsString() (string, error) {
	return mixins.List{TypeName: "dagjose.EncodedRecipients"}.AsString()
}
func (EncodedRecipients) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "dagjose.EncodedRecipients"}.AsBytes()
}
func (EncodedRecipients) AsLink() (datamodel.Link, error) {
	return mixins.List{TypeName: "dagjose.EncodedRecipients"}.AsLink()
}
func (EncodedRecipients) Prototype() datamodel.NodePrototype {
	return _EncodedRecipients__Prototype{}
}

type _EncodedRecipients__Prototype struct{}

func (_EncodedRecipients__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _EncodedRecipients__Builder
	nb.Reset()
	return &nb
}

type _EncodedRecipients__Builder struct {
	_EncodedRecipients__Assembler
}

func (nb *_EncodedRecipients__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_EncodedRecipients__Builder) Reset() {
	var w _EncodedRecipients
	var m schema.Maybe
	*nb = _EncodedRecipients__Builder{_EncodedRecipients__Assembler{w: &w, m: &m}}
}

type _EncodedRecipients__Assembler struct {
	w     *_EncodedRecipients
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _EncodedRecipient__Assembler
}

func (na *_EncodedRecipients__Assembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_EncodedRecipients__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients"}.BeginMap(0)
}
func (na *_EncodedRecipients__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_EncodedRecipient, 0, sizeHint)
	}
	return na, nil
}
func (na *_EncodedRecipients__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_EncodedRecipients__Assembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients"}.AssignBool(false)
}
func (_EncodedRecipients__Assembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients"}.AssignInt(0)
}
func (_EncodedRecipients__Assembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients"}.AssignFloat(0)
}
func (_EncodedRecipients__Assembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients"}.AssignString("")
}
func (_EncodedRecipients__Assembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients"}.AssignBytes(nil)
}
func (_EncodedRecipients__Assembler) AssignLink(datamodel.Link) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients"}.AssignLink(nil)
}
func (na *_EncodedRecipients__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_EncodedRecipients); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_List {
		return datamodel.ErrWrongKind{TypeName: "dagjose.EncodedRecipients", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_EncodedRecipients__Assembler) Prototype() datamodel.NodePrototype {
	return _EncodedRecipients__Prototype{}
}
func (la *_EncodedRecipients__Assembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_EncodedRecipients__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _EncodedRecipient{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_EncodedRecipients__Assembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_EncodedRecipients__Assembler) ValuePrototype(_ int64) datamodel.NodePrototype {
	return _EncodedRecipient__Prototype{}
}
func (EncodedRecipients) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n EncodedRecipients) Representation() datamodel.Node {
	return (*_EncodedRecipients__Repr)(n)
}

type _EncodedRecipients__Repr _EncodedRecipients

var _ datamodel.Node = &_EncodedRecipients__Repr{}

func (_EncodedRecipients__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_List
}
func (_EncodedRecipients__Repr) LookupByString(string) (datamodel.Node, error) {
	return mixins.List{TypeName: "dagjose.EncodedRecipients.Repr"}.LookupByString("")
}
func (nr *_EncodedRecipients__Repr) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	v, err := (EncodedRecipients)(nr).LookupByNode(k)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(EncodedRecipient).Representation(), nil
}
func (nr *_EncodedRecipients__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	v, err := (EncodedRecipients)(nr).LookupByIndex(idx)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(EncodedRecipient).Representation(), nil
}
func (n _EncodedRecipients__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, datamodel.ErrInvalidSegmentForList{TypeName: "dagjose.EncodedRecipients.Repr", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (_EncodedRecipients__Repr) MapIterator() datamodel.MapIterator {
	return nil
}
func (nr *_EncodedRecipients__Repr) ListIterator() datamodel.ListIterator {
	return &_EncodedRecipients__ReprListItr{(EncodedRecipients)(nr), 0}
}

type _EncodedRecipients__ReprListItr _EncodedRecipients__ListItr

func (itr *_EncodedRecipients__ReprListItr) Next() (idx int64, v datamodel.Node, err error) {
	idx, v, err = (*_EncodedRecipients__ListItr)(itr).Next()
	if err != nil || v == datamodel.Null {
		return
	}
	return idx, v.(EncodedRecipient).Representation(), nil
}
func (itr *_EncodedRecipients__ReprListItr) Done() bool {
	return (*_EncodedRecipients__ListItr)(itr).Done()
}

func (rn *_EncodedRecipients__Repr) Length() int64 {
	return int64(len(rn.x))
}
func (_EncodedRecipients__Repr) IsAbsent() bool {
	return false
}
func (_EncodedRecipients__Repr) IsNull() bool {
	return false
}
func (_EncodedRecipients__Repr) AsBool() (bool, error) {
	return mixins.List{TypeName: "dagjose.EncodedRecipients.Repr"}.AsBool()
}
func (_EncodedRecipients__Repr) AsInt() (int64, error) {
	return mixins.List{TypeName: "dagjose.EncodedRecipients.Repr"}.AsInt()
}
func (_EncodedRecipients__Repr) AsFloat() (float64, error) {
	return mixins.List{TypeName: "dagjose.EncodedRecipients.Repr"}.AsFloat()
}
func (_EncodedRecipients__Repr) AsString() (string, error) {
	return mixins.List{TypeName: "dagjose.EncodedRecipients.Repr"}.AsString()
}
func (_EncodedRecipients__Repr) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "dagjose.EncodedRecipients.Repr"}.AsBytes()
}
func (_EncodedRecipients__Repr) AsLink() (datamodel.Link, error) {
	return mixins.List{TypeName: "dagjose.EncodedRecipients.Repr"}.AsLink()
}
func (_EncodedRecipients__Repr) Prototype() datamodel.NodePrototype {
	return _EncodedRecipients__ReprPrototype{}
}

type _EncodedRecipients__ReprPrototype struct{}

func (_EncodedRecipients__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _EncodedRecipients__ReprBuilder
	nb.Reset()
	return &nb
}

type _EncodedRecipients__ReprBuilder struct {
	_EncodedRecipients__ReprAssembler
}

func (nb *_EncodedRecipients__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_EncodedRecipients__ReprBuilder) Reset() {
	var w _EncodedRecipients
	var m schema.Maybe
	*nb = _EncodedRecipients__ReprBuilder{_EncodedRecipients__ReprAssembler{w: &w, m: &m}}
}

type _EncodedRecipients__ReprAssembler struct {
	w     *_EncodedRecipients
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _EncodedRecipient__ReprAssembler
}

func (na *_EncodedRecipients__ReprAssembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_EncodedRecipients__ReprAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients.Repr"}.BeginMap(0)
}
func (na *_EncodedRecipients__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_EncodedRecipient, 0, sizeHint)
	}
	return na, nil
}
func (na *_EncodedRecipients__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_EncodedRecipients__ReprAssembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients.Repr"}.AssignBool(false)
}
func (_EncodedRecipients__ReprAssembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients.Repr"}.AssignInt(0)
}
func (_EncodedRecipients__ReprAssembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients.Repr"}.AssignFloat(0)
}
func (_EncodedRecipients__ReprAssembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients.Repr"}.AssignString("")
}
func (_EncodedRecipients__ReprAssembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients.Repr"}.AssignBytes(nil)
}
func (_EncodedRecipients__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedRecipients.Repr"}.AssignLink(nil)
}
func (na *_EncodedRecipients__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_EncodedRecipients); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_List {
		return datamodel.ErrWrongKind{TypeName: "dagjose.EncodedRecipients.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_EncodedRecipients__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _EncodedRecipients__ReprPrototype{}
}
func (la *_EncodedRecipients__ReprAssembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_EncodedRecipients__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _EncodedRecipient{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_EncodedRecipients__ReprAssembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_EncodedRecipients__ReprAssembler) ValuePrototype(_ int64) datamodel.NodePrototype {
	return _EncodedRecipient__ReprPrototype{}
}

func (n _EncodedSignature) FieldHeader() MaybeAny {
	return &n.header
}
func (n _EncodedSignature) FieldProtected() MaybeRaw {
	return &n.protected
}
func (n _EncodedSignature) FieldSignature() Raw {
	return &n.signature
}

type _EncodedSignature__Maybe struct {
	m schema.Maybe
	v EncodedSignature
}
type MaybeEncodedSignature = *_EncodedSignature__Maybe

func (m MaybeEncodedSignature) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeEncodedSignature) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeEncodedSignature) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeEncodedSignature) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeEncodedSignature) Must() EncodedSignature {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return m.v
}

var (
	fieldName__EncodedSignature_Header    = _String{"header"}
	fieldName__EncodedSignature_Protected = _String{"protected"}
	fieldName__EncodedSignature_Signature = _String{"signature"}
)
var _ datamodel.Node = (EncodedSignature)(&_EncodedSignature{})
var _ schema.TypedNode = (EncodedSignature)(&_EncodedSignature{})

func (EncodedSignature) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n EncodedSignature) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "header":
		if n.header.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return n.header.v, nil
	case "protected":
		if n.protected.m == schema.Maybe_Absent {
			return datamodel.Absent, nil
		}
		return &n.protected.v, nil
	case "signature":
		return &n.signature, nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n EncodedSignature) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (EncodedSignature) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.EncodedSignature"}.LookupByIndex(0)
}
func (n EncodedSignature) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n EncodedSignature) MapIterator() datamodel.MapIterator {
	return &_EncodedSignature__MapItr{n, 0}
}

type _EncodedSignature__MapItr struct {
	n   EncodedSignature
	idx int
}

func (itr *_EncodedSignature__MapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
	if itr.idx >= 3 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__EncodedSignature_Header
		if itr.n.header.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = itr.n.header.v
	case 1:
		k = &fieldName__EncodedSignature_Protected
		if itr.n.protected.m == schema.Maybe_Absent {
			v = datamodel.Absent
			break
		}
		v = &itr.n.protected.v
	case 2:
		k = &fieldName__EncodedSignature_Signature
		v = &itr.n.signature
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_EncodedSignature__MapItr) Done() bool {
	return itr.idx >= 3
}

func (EncodedSignature) ListIterator() datamodel.ListIterator {
	return nil
}
func (EncodedSignature) Length() int64 {
	return 3
}
func (EncodedSignature) IsAbsent() bool {
	return false
}
func (EncodedSignature) IsNull() bool {
	return false
}
func (EncodedSignature) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.EncodedSignature"}.AsBool()
}
func (EncodedSignature) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedSignature"}.AsInt()
}
func (EncodedSignature) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedSignature"}.AsFloat()
}
func (EncodedSignature) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.EncodedSignature"}.AsString()
}
func (EncodedSignature) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.EncodedSignature"}.AsBytes()
}
func (EncodedSignature) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.EncodedSignature"}.AsLink()
}
func (EncodedSignature) Prototype() datamodel.NodePrototype {
	return _EncodedSignature__Prototype{}
}

type _EncodedSignature__Prototype struct{}

func (_EncodedSignature__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _EncodedSignature__Builder
	nb.Reset()
	return &nb
}

type _EncodedSignature__Builder struct {
	_EncodedSignature__Assembler
}

func (nb *_EncodedSignature__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_EncodedSignature__Builder) Reset() {
	var w _EncodedSignature
	var m schema.Maybe
	*nb = _EncodedSignature__Builder{_EncodedSignature__Assembler{w: &w, m: &m}}
}

type _EncodedSignature__Assembler struct {
	w     *_EncodedSignature
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm           schema.Maybe
	ca_header    _Any__Assembler
	ca_protected _Raw__Assembler
	ca_signature _Raw__Assembler
}

func (na *_EncodedSignature__Assembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_header.reset()
	na.ca_protected.reset()
	na.ca_signature.reset()
}

var (
	fieldBit__EncodedSignature_Header      = 1 << 0
	fieldBit__EncodedSignature_Protected   = 1 << 1
	fieldBit__EncodedSignature_Signature   = 1 << 2
	fieldBits__EncodedSignature_sufficient = 0 + 1<<2
)

func (na *_EncodedSignature__Assembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_EncodedSignature{}
	}
	return na, nil
}
func (_EncodedSignature__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature"}.BeginList(0)
}
func (na *_EncodedSignature__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_EncodedSignature__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature"}.AssignBool(false)
}
func (_EncodedSignature__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature"}.AssignInt(0)
}
func (_EncodedSignature__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature"}.AssignFloat(0)
}
func (_EncodedSignature__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature"}.AssignString("")
}
func (_EncodedSignature__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature"}.AssignBytes(nil)
}
func (_EncodedSignature__Assembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature"}.AssignLink(nil)
}
func (na *_EncodedSignature__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_EncodedSignature); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.EncodedSignature", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_EncodedSignature__Assembler) Prototype() datamodel.NodePrototype {
	return _EncodedSignature__Prototype{}
}
func (ma *_EncodedSignature__Assembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.header.m {
		case schema.Maybe_Value:
			ma.w.header.v = ma.ca_header.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.protected.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.ca_signature.w = nil
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedSignature__Assembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "header":
		if ma.s&fieldBit__EncodedSignature_Header != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedSignature_Header}
		}
		ma.s += fieldBit__EncodedSignature_Header
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m
		return &ma.ca_header, nil
	case "protected":
		if ma.s&fieldBit__EncodedSignature_Protected != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedSignature_Protected}
		}
		ma.s += fieldBit__EncodedSignature_Protected
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m
		return &ma.ca_protected, nil
	case "signature":
		if ma.s&fieldBit__EncodedSignature_Signature != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedSignature_Signature}
		}
		ma.s += fieldBit__EncodedSignature_Signature
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_signature.w = &ma.w.signature
		ma.ca_signature.m = &ma.cm
		return &ma.ca_signature, nil
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.EncodedSignature", Key: &_String{k}}
}
func (ma *_EncodedSignature__Assembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_EncodedSignature__KeyAssembler)(ma)
}
func (ma *_EncodedSignature__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m
		return &ma.ca_header
	case 1:
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m
		return &ma.ca_protected
	case 2:
		ma.ca_signature.w = &ma.w.signature
		ma.ca_signature.m = &ma.cm
		return &ma.ca_signature
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedSignature__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__EncodedSignature_sufficient != fieldBits__EncodedSignature_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__EncodedSignature_Signature == 0 {
			err.Missing = append(err.Missing, "signature")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_EncodedSignature__Assembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_EncodedSignature__Assembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler valueprototype")
}

type _EncodedSignature__KeyAssembler _EncodedSignature__Assembler

func (_EncodedSignature__KeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.KeyAssembler"}.BeginMap(0)
}
func (_EncodedSignature__KeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.KeyAssembler"}.BeginList(0)
}
func (na *_EncodedSignature__KeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.KeyAssembler"}.AssignNull()
}
func (_EncodedSignature__KeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.KeyAssembler"}.AssignBool(false)
}
func (_EncodedSignature__KeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.KeyAssembler"}.AssignInt(0)
}
func (_EncodedSignature__KeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.KeyAssembler"}.AssignFloat(0)
}
func (ka *_EncodedSignature__KeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "header":
		if ka.s&fieldBit__EncodedSignature_Header != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedSignature_Header}
		}
		ka.s += fieldBit__EncodedSignature_Header
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "protected":
		if ka.s&fieldBit__EncodedSignature_Protected != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedSignature_Protected}
		}
		ka.s += fieldBit__EncodedSignature_Protected
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "signature":
		if ka.s&fieldBit__EncodedSignature_Signature != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedSignature_Signature}
		}
		ka.s += fieldBit__EncodedSignature_Signature
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	default:
		return schema.ErrInvalidKey{TypeName: "dagjose.EncodedSignature", Key: &_String{k}}
	}
}
func (_EncodedSignature__KeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.KeyAssembler"}.AssignBytes(nil)
}
func (_EncodedSignature__KeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.KeyAssembler"}.AssignLink(nil)
}
func (ka *_EncodedSignature__KeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_EncodedSignature__KeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (EncodedSignature) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n EncodedSignature) Representation() datamodel.Node {
	return (*_EncodedSignature__Repr)(n)
}

type _EncodedSignature__Repr _EncodedSignature

var (
	fieldName__EncodedSignature_Header_serial    = _String{"header"}
	fieldName__EncodedSignature_Protected_serial = _String{"protected"}
	fieldName__EncodedSignature_Signature_serial = _String{"signature"}
)
var _ datamodel.Node = &_EncodedSignature__Repr{}

func (_EncodedSignature__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n *_EncodedSignature__Repr) LookupByString(key string) (datamodel.Node, error) {
	switch key {
	case "header":
		if n.header.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.header.v.Representation(), nil
	case "protected":
		if n.protected.m == schema.Maybe_Absent {
			return datamodel.Absent, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(key)}
		}
		return n.protected.v.Representation(), nil
	case "signature":
		return n.signature.Representation(), nil
	default:
		return nil, schema.ErrNoSuchField{Type: nil /*TODO*/, Field: datamodel.PathSegmentOfString(key)}
	}
}
func (n *_EncodedSignature__Repr) LookupByNode(key datamodel.Node) (datamodel.Node, error) {
	ks, err := key.AsString()
	if err != nil {
		return nil, err
	}
	return n.LookupByString(ks)
}
func (_EncodedSignature__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.EncodedSignature.Repr"}.LookupByIndex(0)
}
func (n _EncodedSignature__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n *_EncodedSignature__Repr) MapIterator() datamodel.MapIterator {
	return &_EncodedSignature__ReprMapItr{n, 0}
}

type _EncodedSignature__ReprMapItr struct {
	n   *_EncodedSignature__Repr
	idx int
}

func (itr *_EncodedSignature__ReprMapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
advance:
	if itr.idx >= 3 {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	switch itr.idx {
	case 0:
		k = &fieldName__EncodedSignature_Header_serial
		if itr.n.header.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.header.v.Representation()
	case 1:
		k = &fieldName__EncodedSignature_Protected_serial
		if itr.n.protected.m == schema.Maybe_Absent {
			itr.idx++
			goto advance
		}
		v = itr.n.protected.v.Representation()
	case 2:
		k = &fieldName__EncodedSignature_Signature_serial
		v = itr.n.signature.Representation()
	default:
		panic("unreachable")
	}
	itr.idx++
	return
}
func (itr *_EncodedSignature__ReprMapItr) Done() bool {
	return itr.idx >= 3
}
func (_EncodedSignature__Repr) ListIterator() datamodel.ListIterator {
	return nil
}
func (rn *_EncodedSignature__Repr) Length() int64 {
	l := 3
	if rn.header.m == schema.Maybe_Absent {
		l--
	}
	if rn.protected.m == schema.Maybe_Absent {
		l--
	}
	return int64(l)
}
func (_EncodedSignature__Repr) IsAbsent() bool {
	return false
}
func (_EncodedSignature__Repr) IsNull() bool {
	return false
}
func (_EncodedSignature__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.EncodedSignature.Repr"}.AsBool()
}
func (_EncodedSignature__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedSignature.Repr"}.AsInt()
}
func (_EncodedSignature__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.EncodedSignature.Repr"}.AsFloat()
}
func (_EncodedSignature__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.EncodedSignature.Repr"}.AsString()
}
func (_EncodedSignature__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.EncodedSignature.Repr"}.AsBytes()
}
func (_EncodedSignature__Repr) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.EncodedSignature.Repr"}.AsLink()
}
func (_EncodedSignature__Repr) Prototype() datamodel.NodePrototype {
	return _EncodedSignature__ReprPrototype{}
}

type _EncodedSignature__ReprPrototype struct{}

func (_EncodedSignature__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _EncodedSignature__ReprBuilder
	nb.Reset()
	return &nb
}

type _EncodedSignature__ReprBuilder struct {
	_EncodedSignature__ReprAssembler
}

func (nb *_EncodedSignature__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_EncodedSignature__ReprBuilder) Reset() {
	var w _EncodedSignature
	var m schema.Maybe
	*nb = _EncodedSignature__ReprBuilder{_EncodedSignature__ReprAssembler{w: &w, m: &m}}
}

type _EncodedSignature__ReprAssembler struct {
	w     *_EncodedSignature
	m     *schema.Maybe
	state maState
	s     int
	f     int

	cm           schema.Maybe
	ca_header    _Any__ReprAssembler
	ca_protected _Raw__ReprAssembler
	ca_signature _Raw__ReprAssembler
}

func (na *_EncodedSignature__ReprAssembler) reset() {
	na.state = maState_initial
	na.s = 0
	na.ca_header.reset()
	na.ca_protected.reset()
	na.ca_signature.reset()
}
func (na *_EncodedSignature__ReprAssembler) BeginMap(int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if na.w == nil {
		na.w = &_EncodedSignature{}
	}
	return na, nil
}
func (_EncodedSignature__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature.Repr"}.BeginList(0)
}
func (na *_EncodedSignature__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_EncodedSignature__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature.Repr"}.AssignBool(false)
}
func (_EncodedSignature__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature.Repr"}.AssignInt(0)
}
func (_EncodedSignature__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature.Repr"}.AssignFloat(0)
}
func (_EncodedSignature__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature.Repr"}.AssignString("")
}
func (_EncodedSignature__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature.Repr"}.AssignBytes(nil)
}
func (_EncodedSignature__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.EncodedSignature.Repr"}.AssignLink(nil)
}
func (na *_EncodedSignature__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_EncodedSignature); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		if na.w == nil {
			na.w = v2
			*na.m = schema.Maybe_Value
			return nil
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.EncodedSignature.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_EncodedSignature__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _EncodedSignature__ReprPrototype{}
}
func (ma *_EncodedSignature__ReprAssembler) valueFinishTidy() bool {
	switch ma.f {
	case 0:
		switch ma.w.header.m {
		case schema.Maybe_Value:
			ma.w.header.v = ma.ca_header.w
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 1:
		switch ma.w.protected.m {
		case schema.Maybe_Value:
			ma.state = maState_initial
			return true
		default:
			return false
		}
	case 2:
		switch ma.cm {
		case schema.Maybe_Value:
			ma.cm = schema.Maybe_Absent
			ma.state = maState_initial
			return true
		default:
			return false
		}
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedSignature__ReprAssembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}
	switch k {
	case "header":
		if ma.s&fieldBit__EncodedSignature_Header != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedSignature_Header_serial}
		}
		ma.s += fieldBit__EncodedSignature_Header
		ma.state = maState_midValue
		ma.f = 0
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m

		return &ma.ca_header, nil
	case "protected":
		if ma.s&fieldBit__EncodedSignature_Protected != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedSignature_Protected_serial}
		}
		ma.s += fieldBit__EncodedSignature_Protected
		ma.state = maState_midValue
		ma.f = 1
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m

		return &ma.ca_protected, nil
	case "signature":
		if ma.s&fieldBit__EncodedSignature_Signature != 0 {
			return nil, datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedSignature_Signature_serial}
		}
		ma.s += fieldBit__EncodedSignature_Signature
		ma.state = maState_midValue
		ma.f = 2
		ma.ca_signature.w = &ma.w.signature
		ma.ca_signature.m = &ma.cm
		return &ma.ca_signature, nil
	default:
	}
	return nil, schema.ErrInvalidKey{TypeName: "dagjose.EncodedSignature.Repr", Key: &_String{k}}
}
func (ma *_EncodedSignature__ReprAssembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midKey
	return (*_EncodedSignature__ReprKeyAssembler)(ma)
}
func (ma *_EncodedSignature__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	switch ma.f {
	case 0:
		ma.ca_header.w = ma.w.header.v
		ma.ca_header.m = &ma.w.header.m

		return &ma.ca_header
	case 1:
		ma.ca_protected.w = &ma.w.protected.v
		ma.ca_protected.m = &ma.w.protected.m

		return &ma.ca_protected
	case 2:
		ma.ca_signature.w = &ma.w.signature
		ma.ca_signature.m = &ma.cm
		return &ma.ca_signature
	default:
		panic("unreachable")
	}
}
func (ma *_EncodedSignature__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	if ma.s&fieldBits__EncodedSignature_sufficient != fieldBits__EncodedSignature_sufficient {
		err := schema.ErrMissingRequiredField{Missing: make([]string, 0)}
		if ma.s&fieldBit__EncodedSignature_Signature == 0 {
			err.Missing = append(err.Missing, "signature")
		}
		return err
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_EncodedSignature__ReprAssembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_EncodedSignature__ReprAssembler) ValuePrototype(k string) datamodel.NodePrototype {
	panic("todo structbuilder mapassembler repr valueprototype")
}

type _EncodedSignature__ReprKeyAssembler _EncodedSignature__ReprAssembler

func (_EncodedSignature__ReprKeyAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.Repr.KeyAssembler"}.BeginMap(0)
}
func (_EncodedSignature__ReprKeyAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.Repr.KeyAssembler"}.BeginList(0)
}
func (na *_EncodedSignature__ReprKeyAssembler) AssignNull() error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.Repr.KeyAssembler"}.AssignNull()
}
func (_EncodedSignature__ReprKeyAssembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.Repr.KeyAssembler"}.AssignBool(false)
}
func (_EncodedSignature__ReprKeyAssembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.Repr.KeyAssembler"}.AssignInt(0)
}
func (_EncodedSignature__ReprKeyAssembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.Repr.KeyAssembler"}.AssignFloat(0)
}
func (ka *_EncodedSignature__ReprKeyAssembler) AssignString(k string) error {
	if ka.state != maState_midKey {
		panic("misuse: KeyAssembler held beyond its valid lifetime")
	}
	switch k {
	case "header":
		if ka.s&fieldBit__EncodedSignature_Header != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedSignature_Header_serial}
		}
		ka.s += fieldBit__EncodedSignature_Header
		ka.state = maState_expectValue
		ka.f = 0
		return nil
	case "protected":
		if ka.s&fieldBit__EncodedSignature_Protected != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedSignature_Protected_serial}
		}
		ka.s += fieldBit__EncodedSignature_Protected
		ka.state = maState_expectValue
		ka.f = 1
		return nil
	case "signature":
		if ka.s&fieldBit__EncodedSignature_Signature != 0 {
			return datamodel.ErrRepeatedMapKey{Key: &fieldName__EncodedSignature_Signature_serial}
		}
		ka.s += fieldBit__EncodedSignature_Signature
		ka.state = maState_expectValue
		ka.f = 2
		return nil
	}
	return schema.ErrInvalidKey{TypeName: "dagjose.EncodedSignature.Repr", Key: &_String{k}}
}
func (_EncodedSignature__ReprKeyAssembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.Repr.KeyAssembler"}.AssignBytes(nil)
}
func (_EncodedSignature__ReprKeyAssembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.EncodedSignature.Repr.KeyAssembler"}.AssignLink(nil)
}
func (ka *_EncodedSignature__ReprKeyAssembler) AssignNode(v datamodel.Node) error {
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return ka.AssignString(v2)
	}
}
func (_EncodedSignature__ReprKeyAssembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}

func (n *_EncodedSignatures) Lookup(idx int64) EncodedSignature {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return v
}
func (n *_EncodedSignatures) LookupMaybe(idx int64) MaybeEncodedSignature {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return &_EncodedSignature__Maybe{
		m: schema.Maybe_Value,
		v: v,
	}
}

var _EncodedSignatures__valueAbsent = _EncodedSignature__Maybe{m: schema.Maybe_Absent}

func (n EncodedSignatures) Iterator() *EncodedSignatures__Itr {
	return &EncodedSignatures__Itr{n, 0}
}

type EncodedSignatures__Itr struct {
	n   EncodedSignatures
	idx int
}

func (itr *EncodedSignatures__Itr) Next() (idx int64, v EncodedSignature) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil
	}
	idx = int64(itr.idx)
	v = &itr.n.x[itr.idx]
	itr.idx++
	return
}
func (itr *EncodedSignatures__Itr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

type _EncodedSignatures__Maybe struct {
	m schema.Maybe
	v _EncodedSignatures
}
type MaybeEncodedSignatures = *_EncodedSignatures__Maybe

func (m MaybeEncodedSignatures) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeEncodedSignatures) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeEncodedSignatures) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeEncodedSignatures) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeEncodedSignatures) Must() EncodedSignatures {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (EncodedSignatures)(&_EncodedSignatures{})
var _ schema.TypedNode = (EncodedSignatures)(&_EncodedSignatures{})

func (EncodedSignatures) Kind() datamodel.Kind {
	return datamodel.Kind_List
}
func (EncodedSignatures) LookupByString(string) (datamodel.Node, error) {
	return mixins.List{TypeName: "dagjose.EncodedSignatures"}.LookupByString("")
}
func (n EncodedSignatures) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	idx, err := k.AsInt()
	if err != nil {
		return nil, err
	}
	return n.LookupByIndex(idx)
}
func (n EncodedSignatures) LookupByIndex(idx int64) (datamodel.Node, error) {
	if n.Length() <= idx {
		return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfInt(idx)}
	}
	v := &n.x[idx]
	return v, nil
}
func (n EncodedSignatures) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, datamodel.ErrInvalidSegmentForList{TypeName: "dagjose.EncodedSignatures", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (EncodedSignatures) MapIterator() datamodel.MapIterator {
	return nil
}
func (n EncodedSignatures) ListIterator() datamodel.ListIterator {
	return &_EncodedSignatures__ListItr{n, 0}
}

type _EncodedSignatures__ListItr struct {
	n   EncodedSignatures
	idx int
}

func (itr *_EncodedSignatures__ListItr) Next() (idx int64, v datamodel.Node, _ error) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil, datamodel.ErrIteratorOverread{}
	}
	idx = int64(itr.idx)
	x := &itr.n.x[itr.idx]
	v = x
	itr.idx++
	return
}
func (itr *_EncodedSignatures__ListItr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

func (n EncodedSignatures) Length() int64 {
	return int64(len(n.x))
}
func (EncodedSignatures) IsAbsent() bool {
	return false
}
func (EncodedSignatures) IsNull() bool {
	return false
}
func (EncodedSignatures) AsBool() (bool, error) {
	return mixins.List{TypeName: "dagjose.EncodedSignatures"}.AsBool()
}
func (EncodedSignatures) AsInt() (int64, error) {
	return mixins.List{TypeName: "dagjose.EncodedSignatures"}.AsInt()
}
func (EncodedSignatures) AsFloat() (float64, error) {
	return mixins.List{TypeName: "dagjose.EncodedSignatures"}.AsFloat()
}
func (EncodedSignatures) AsString() (string, error) {
	return mixins.List{TypeName: "dagjose.EncodedSignatures"}.AsString()
}
func (EncodedSignatures) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "dagjose.EncodedSignatures"}.AsBytes()
}
func (EncodedSignatures) AsLink() (datamodel.Link, error) {
	return mixins.List{TypeName: "dagjose.EncodedSignatures"}.AsLink()
}
func (EncodedSignatures) Prototype() datamodel.NodePrototype {
	return _EncodedSignatures__Prototype{}
}

type _EncodedSignatures__Prototype struct{}

func (_EncodedSignatures__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _EncodedSignatures__Builder
	nb.Reset()
	return &nb
}

type _EncodedSignatures__Builder struct {
	_EncodedSignatures__Assembler
}

func (nb *_EncodedSignatures__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_EncodedSignatures__Builder) Reset() {
	var w _EncodedSignatures
	var m schema.Maybe
	*nb = _EncodedSignatures__Builder{_EncodedSignatures__Assembler{w: &w, m: &m}}
}

type _EncodedSignatures__Assembler struct {
	w     *_EncodedSignatures
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _EncodedSignature__Assembler
}

func (na *_EncodedSignatures__Assembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_EncodedSignatures__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures"}.BeginMap(0)
}
func (na *_EncodedSignatures__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_EncodedSignature, 0, sizeHint)
	}
	return na, nil
}
func (na *_EncodedSignatures__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_EncodedSignatures__Assembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures"}.AssignBool(false)
}
func (_EncodedSignatures__Assembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures"}.AssignInt(0)
}
func (_EncodedSignatures__Assembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures"}.AssignFloat(0)
}
func (_EncodedSignatures__Assembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures"}.AssignString("")
}
func (_EncodedSignatures__Assembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures"}.AssignBytes(nil)
}
func (_EncodedSignatures__Assembler) AssignLink(datamodel.Link) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures"}.AssignLink(nil)
}
func (na *_EncodedSignatures__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_EncodedSignatures); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_List {
		return datamodel.ErrWrongKind{TypeName: "dagjose.EncodedSignatures", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_EncodedSignatures__Assembler) Prototype() datamodel.NodePrototype {
	return _EncodedSignatures__Prototype{}
}
func (la *_EncodedSignatures__Assembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_EncodedSignatures__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _EncodedSignature{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_EncodedSignatures__Assembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_EncodedSignatures__Assembler) ValuePrototype(_ int64) datamodel.NodePrototype {
	return _EncodedSignature__Prototype{}
}
func (EncodedSignatures) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n EncodedSignatures) Representation() datamodel.Node {
	return (*_EncodedSignatures__Repr)(n)
}

type _EncodedSignatures__Repr _EncodedSignatures

var _ datamodel.Node = &_EncodedSignatures__Repr{}

func (_EncodedSignatures__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_List
}
func (_EncodedSignatures__Repr) LookupByString(string) (datamodel.Node, error) {
	return mixins.List{TypeName: "dagjose.EncodedSignatures.Repr"}.LookupByString("")
}
func (nr *_EncodedSignatures__Repr) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	v, err := (EncodedSignatures)(nr).LookupByNode(k)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(EncodedSignature).Representation(), nil
}
func (nr *_EncodedSignatures__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	v, err := (EncodedSignatures)(nr).LookupByIndex(idx)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(EncodedSignature).Representation(), nil
}
func (n _EncodedSignatures__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, datamodel.ErrInvalidSegmentForList{TypeName: "dagjose.EncodedSignatures.Repr", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (_EncodedSignatures__Repr) MapIterator() datamodel.MapIterator {
	return nil
}
func (nr *_EncodedSignatures__Repr) ListIterator() datamodel.ListIterator {
	return &_EncodedSignatures__ReprListItr{(EncodedSignatures)(nr), 0}
}

type _EncodedSignatures__ReprListItr _EncodedSignatures__ListItr

func (itr *_EncodedSignatures__ReprListItr) Next() (idx int64, v datamodel.Node, err error) {
	idx, v, err = (*_EncodedSignatures__ListItr)(itr).Next()
	if err != nil || v == datamodel.Null {
		return
	}
	return idx, v.(EncodedSignature).Representation(), nil
}
func (itr *_EncodedSignatures__ReprListItr) Done() bool {
	return (*_EncodedSignatures__ListItr)(itr).Done()
}

func (rn *_EncodedSignatures__Repr) Length() int64 {
	return int64(len(rn.x))
}
func (_EncodedSignatures__Repr) IsAbsent() bool {
	return false
}
func (_EncodedSignatures__Repr) IsNull() bool {
	return false
}
func (_EncodedSignatures__Repr) AsBool() (bool, error) {
	return mixins.List{TypeName: "dagjose.EncodedSignatures.Repr"}.AsBool()
}
func (_EncodedSignatures__Repr) AsInt() (int64, error) {
	return mixins.List{TypeName: "dagjose.EncodedSignatures.Repr"}.AsInt()
}
func (_EncodedSignatures__Repr) AsFloat() (float64, error) {
	return mixins.List{TypeName: "dagjose.EncodedSignatures.Repr"}.AsFloat()
}
func (_EncodedSignatures__Repr) AsString() (string, error) {
	return mixins.List{TypeName: "dagjose.EncodedSignatures.Repr"}.AsString()
}
func (_EncodedSignatures__Repr) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "dagjose.EncodedSignatures.Repr"}.AsBytes()
}
func (_EncodedSignatures__Repr) AsLink() (datamodel.Link, error) {
	return mixins.List{TypeName: "dagjose.EncodedSignatures.Repr"}.AsLink()
}
func (_EncodedSignatures__Repr) Prototype() datamodel.NodePrototype {
	return _EncodedSignatures__ReprPrototype{}
}

type _EncodedSignatures__ReprPrototype struct{}

func (_EncodedSignatures__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _EncodedSignatures__ReprBuilder
	nb.Reset()
	return &nb
}

type _EncodedSignatures__ReprBuilder struct {
	_EncodedSignatures__ReprAssembler
}

func (nb *_EncodedSignatures__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_EncodedSignatures__ReprBuilder) Reset() {
	var w _EncodedSignatures
	var m schema.Maybe
	*nb = _EncodedSignatures__ReprBuilder{_EncodedSignatures__ReprAssembler{w: &w, m: &m}}
}

type _EncodedSignatures__ReprAssembler struct {
	w     *_EncodedSignatures
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _EncodedSignature__ReprAssembler
}

func (na *_EncodedSignatures__ReprAssembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_EncodedSignatures__ReprAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures.Repr"}.BeginMap(0)
}
func (na *_EncodedSignatures__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_EncodedSignature, 0, sizeHint)
	}
	return na, nil
}
func (na *_EncodedSignatures__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_EncodedSignatures__ReprAssembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures.Repr"}.AssignBool(false)
}
func (_EncodedSignatures__ReprAssembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures.Repr"}.AssignInt(0)
}
func (_EncodedSignatures__ReprAssembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures.Repr"}.AssignFloat(0)
}
func (_EncodedSignatures__ReprAssembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures.Repr"}.AssignString("")
}
func (_EncodedSignatures__ReprAssembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures.Repr"}.AssignBytes(nil)
}
func (_EncodedSignatures__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.ListAssembler{TypeName: "dagjose.EncodedSignatures.Repr"}.AssignLink(nil)
}
func (na *_EncodedSignatures__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_EncodedSignatures); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_List {
		return datamodel.ErrWrongKind{TypeName: "dagjose.EncodedSignatures.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_EncodedSignatures__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _EncodedSignatures__ReprPrototype{}
}
func (la *_EncodedSignatures__ReprAssembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_EncodedSignatures__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _EncodedSignature{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_EncodedSignatures__ReprAssembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_EncodedSignatures__ReprAssembler) ValuePrototype(_ int64) datamodel.NodePrototype {
	return _EncodedSignature__ReprPrototype{}
}

func (n Float) Float() float64 {
	return n.x
}
func (_Float__Prototype) FromFloat(v float64) (Float, error) {
	n := _Float{v}
	return &n, nil
}

type _Float__Maybe struct {
	m schema.Maybe
	v _Float
}
type MaybeFloat = *_Float__Maybe

func (m MaybeFloat) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeFloat) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeFloat) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeFloat) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeFloat) Must() Float {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (Float)(&_Float{})
var _ schema.TypedNode = (Float)(&_Float{})

func (Float) Kind() datamodel.Kind {
	return datamodel.Kind_Float
}
func (Float) LookupByString(string) (datamodel.Node, error) {
	return mixins.Float{TypeName: "dagjose.Float"}.LookupByString("")
}
func (Float) LookupByNode(datamodel.Node) (datamodel.Node, error) {
	return mixins.Float{TypeName: "dagjose.Float"}.LookupByNode(nil)
}
func (Float) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Float{TypeName: "dagjose.Float"}.LookupByIndex(0)
}
func (Float) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return mixins.Float{TypeName: "dagjose.Float"}.LookupBySegment(seg)
}
func (Float) MapIterator() datamodel.MapIterator {
	return nil
}
func (Float) ListIterator() datamodel.ListIterator {
	return nil
}
func (Float) Length() int64 {
	return -1
}
func (Float) IsAbsent() bool {
	return false
}
func (Float) IsNull() bool {
	return false
}
func (Float) AsBool() (bool, error) {
	return mixins.Float{TypeName: "dagjose.Float"}.AsBool()
}
func (Float) AsInt() (int64, error) {
	return mixins.Float{TypeName: "dagjose.Float"}.AsInt()
}
func (n Float) AsFloat() (float64, error) {
	return n.x, nil
}
func (Float) AsString() (string, error) {
	return mixins.Float{TypeName: "dagjose.Float"}.AsString()
}
func (Float) AsBytes() ([]byte, error) {
	return mixins.Float{TypeName: "dagjose.Float"}.AsBytes()
}
func (Float) AsLink() (datamodel.Link, error) {
	return mixins.Float{TypeName: "dagjose.Float"}.AsLink()
}
func (Float) Prototype() datamodel.NodePrototype {
	return _Float__Prototype{}
}

type _Float__Prototype struct{}

func (_Float__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Float__Builder
	nb.Reset()
	return &nb
}

type _Float__Builder struct {
	_Float__Assembler
}

func (nb *_Float__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Float__Builder) Reset() {
	var w _Float
	var m schema.Maybe
	*nb = _Float__Builder{_Float__Assembler{w: &w, m: &m}}
}

type _Float__Assembler struct {
	w *_Float
	m *schema.Maybe
}

func (na *_Float__Assembler) reset() {}
func (_Float__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.FloatAssembler{TypeName: "dagjose.Float"}.BeginMap(0)
}
func (_Float__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.FloatAssembler{TypeName: "dagjose.Float"}.BeginList(0)
}
func (na *_Float__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.FloatAssembler{TypeName: "dagjose.Float"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Float__Assembler) AssignBool(bool) error {
	return mixins.FloatAssembler{TypeName: "dagjose.Float"}.AssignBool(false)
}
func (_Float__Assembler) AssignInt(int64) error {
	return mixins.FloatAssembler{TypeName: "dagjose.Float"}.AssignInt(0)
}
func (na *_Float__Assembler) AssignFloat(v float64) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_Float__Assembler) AssignString(string) error {
	return mixins.FloatAssembler{TypeName: "dagjose.Float"}.AssignString("")
}
func (_Float__Assembler) AssignBytes([]byte) error {
	return mixins.FloatAssembler{TypeName: "dagjose.Float"}.AssignBytes(nil)
}
func (_Float__Assembler) AssignLink(datamodel.Link) error {
	return mixins.FloatAssembler{TypeName: "dagjose.Float"}.AssignLink(nil)
}
func (na *_Float__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Float); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsFloat(); err != nil {
		return err
	} else {
		return na.AssignFloat(v2)
	}
}
func (_Float__Assembler) Prototype() datamodel.NodePrototype {
	return _Float__Prototype{}
}
func (Float) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Float) Representation() datamodel.Node {
	return (*_Float__Repr)(n)
}

type _Float__Repr = _Float

var _ datamodel.Node = &_Float__Repr{}

type _Float__ReprPrototype = _Float__Prototype
type _Float__ReprAssembler = _Float__Assembler

func (n Int) Int() int64 {
	return n.x
}
func (_Int__Prototype) FromInt(v int64) (Int, error) {
	n := _Int{v}
	return &n, nil
}

type _Int__Maybe struct {
	m schema.Maybe
	v _Int
}
type MaybeInt = *_Int__Maybe

func (m MaybeInt) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeInt) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeInt) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeInt) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeInt) Must() Int {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (Int)(&_Int{})
var _ schema.TypedNode = (Int)(&_Int{})

func (Int) Kind() datamodel.Kind {
	return datamodel.Kind_Int
}
func (Int) LookupByString(string) (datamodel.Node, error) {
	return mixins.Int{TypeName: "dagjose.Int"}.LookupByString("")
}
func (Int) LookupByNode(datamodel.Node) (datamodel.Node, error) {
	return mixins.Int{TypeName: "dagjose.Int"}.LookupByNode(nil)
}
func (Int) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Int{TypeName: "dagjose.Int"}.LookupByIndex(0)
}
func (Int) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return mixins.Int{TypeName: "dagjose.Int"}.LookupBySegment(seg)
}
func (Int) MapIterator() datamodel.MapIterator {
	return nil
}
func (Int) ListIterator() datamodel.ListIterator {
	return nil
}
func (Int) Length() int64 {
	return -1
}
func (Int) IsAbsent() bool {
	return false
}
func (Int) IsNull() bool {
	return false
}
func (Int) AsBool() (bool, error) {
	return mixins.Int{TypeName: "dagjose.Int"}.AsBool()
}
func (n Int) AsInt() (int64, error) {
	return n.x, nil
}
func (Int) AsFloat() (float64, error) {
	return mixins.Int{TypeName: "dagjose.Int"}.AsFloat()
}
func (Int) AsString() (string, error) {
	return mixins.Int{TypeName: "dagjose.Int"}.AsString()
}
func (Int) AsBytes() ([]byte, error) {
	return mixins.Int{TypeName: "dagjose.Int"}.AsBytes()
}
func (Int) AsLink() (datamodel.Link, error) {
	return mixins.Int{TypeName: "dagjose.Int"}.AsLink()
}
func (Int) Prototype() datamodel.NodePrototype {
	return _Int__Prototype{}
}

type _Int__Prototype struct{}

func (_Int__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Int__Builder
	nb.Reset()
	return &nb
}

type _Int__Builder struct {
	_Int__Assembler
}

func (nb *_Int__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Int__Builder) Reset() {
	var w _Int
	var m schema.Maybe
	*nb = _Int__Builder{_Int__Assembler{w: &w, m: &m}}
}

type _Int__Assembler struct {
	w *_Int
	m *schema.Maybe
}

func (na *_Int__Assembler) reset() {}
func (_Int__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.IntAssembler{TypeName: "dagjose.Int"}.BeginMap(0)
}
func (_Int__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.IntAssembler{TypeName: "dagjose.Int"}.BeginList(0)
}
func (na *_Int__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.IntAssembler{TypeName: "dagjose.Int"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Int__Assembler) AssignBool(bool) error {
	return mixins.IntAssembler{TypeName: "dagjose.Int"}.AssignBool(false)
}
func (na *_Int__Assembler) AssignInt(v int64) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_Int__Assembler) AssignFloat(float64) error {
	return mixins.IntAssembler{TypeName: "dagjose.Int"}.AssignFloat(0)
}
func (_Int__Assembler) AssignString(string) error {
	return mixins.IntAssembler{TypeName: "dagjose.Int"}.AssignString("")
}
func (_Int__Assembler) AssignBytes([]byte) error {
	return mixins.IntAssembler{TypeName: "dagjose.Int"}.AssignBytes(nil)
}
func (_Int__Assembler) AssignLink(datamodel.Link) error {
	return mixins.IntAssembler{TypeName: "dagjose.Int"}.AssignLink(nil)
}
func (na *_Int__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Int); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsInt(); err != nil {
		return err
	} else {
		return na.AssignInt(v2)
	}
}
func (_Int__Assembler) Prototype() datamodel.NodePrototype {
	return _Int__Prototype{}
}
func (Int) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Int) Representation() datamodel.Node {
	return (*_Int__Repr)(n)
}

type _Int__Repr = _Int

var _ datamodel.Node = &_Int__Repr{}

type _Int__ReprPrototype = _Int__Prototype
type _Int__ReprAssembler = _Int__Assembler

func (n Link) Link() datamodel.Link {
	return n.x
}
func (_Link__Prototype) FromLink(v datamodel.Link) (Link, error) {
	n := _Link{v}
	return &n, nil
}

type _Link__Maybe struct {
	m schema.Maybe
	v _Link
}
type MaybeLink = *_Link__Maybe

func (m MaybeLink) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeLink) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeLink) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeLink) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeLink) Must() Link {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (Link)(&_Link{})
var _ schema.TypedNode = (Link)(&_Link{})

func (Link) Kind() datamodel.Kind {
	return datamodel.Kind_Link
}
func (Link) LookupByString(string) (datamodel.Node, error) {
	return mixins.Link{TypeName: "dagjose.Link"}.LookupByString("")
}
func (Link) LookupByNode(datamodel.Node) (datamodel.Node, error) {
	return mixins.Link{TypeName: "dagjose.Link"}.LookupByNode(nil)
}
func (Link) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Link{TypeName: "dagjose.Link"}.LookupByIndex(0)
}
func (Link) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return mixins.Link{TypeName: "dagjose.Link"}.LookupBySegment(seg)
}
func (Link) MapIterator() datamodel.MapIterator {
	return nil
}
func (Link) ListIterator() datamodel.ListIterator {
	return nil
}
func (Link) Length() int64 {
	return -1
}
func (Link) IsAbsent() bool {
	return false
}
func (Link) IsNull() bool {
	return false
}
func (Link) AsBool() (bool, error) {
	return mixins.Link{TypeName: "dagjose.Link"}.AsBool()
}
func (Link) AsInt() (int64, error) {
	return mixins.Link{TypeName: "dagjose.Link"}.AsInt()
}
func (Link) AsFloat() (float64, error) {
	return mixins.Link{TypeName: "dagjose.Link"}.AsFloat()
}
func (Link) AsString() (string, error) {
	return mixins.Link{TypeName: "dagjose.Link"}.AsString()
}
func (Link) AsBytes() ([]byte, error) {
	return mixins.Link{TypeName: "dagjose.Link"}.AsBytes()
}
func (n Link) AsLink() (datamodel.Link, error) {
	return n.x, nil
}
func (Link) Prototype() datamodel.NodePrototype {
	return _Link__Prototype{}
}

type _Link__Prototype struct{}

func (_Link__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Link__Builder
	nb.Reset()
	return &nb
}

type _Link__Builder struct {
	_Link__Assembler
}

func (nb *_Link__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Link__Builder) Reset() {
	var w _Link
	var m schema.Maybe
	*nb = _Link__Builder{_Link__Assembler{w: &w, m: &m}}
}

type _Link__Assembler struct {
	w *_Link
	m *schema.Maybe
}

func (na *_Link__Assembler) reset() {}
func (_Link__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.LinkAssembler{TypeName: "dagjose.Link"}.BeginMap(0)
}
func (_Link__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.LinkAssembler{TypeName: "dagjose.Link"}.BeginList(0)
}
func (na *_Link__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.LinkAssembler{TypeName: "dagjose.Link"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_Link__Assembler) AssignBool(bool) error {
	return mixins.LinkAssembler{TypeName: "dagjose.Link"}.AssignBool(false)
}
func (_Link__Assembler) AssignInt(int64) error {
	return mixins.LinkAssembler{TypeName: "dagjose.Link"}.AssignInt(0)
}
func (_Link__Assembler) AssignFloat(float64) error {
	return mixins.LinkAssembler{TypeName: "dagjose.Link"}.AssignFloat(0)
}
func (_Link__Assembler) AssignString(string) error {
	return mixins.LinkAssembler{TypeName: "dagjose.Link"}.AssignString("")
}
func (_Link__Assembler) AssignBytes([]byte) error {
	return mixins.LinkAssembler{TypeName: "dagjose.Link"}.AssignBytes(nil)
}
func (na *_Link__Assembler) AssignLink(v datamodel.Link) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (na *_Link__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Link); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsLink(); err != nil {
		return err
	} else {
		return na.AssignLink(v2)
	}
}
func (_Link__Assembler) Prototype() datamodel.NodePrototype {
	return _Link__Prototype{}
}
func (Link) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Link) Representation() datamodel.Node {
	return (*_Link__Repr)(n)
}

type _Link__Repr = _Link

var _ datamodel.Node = &_Link__Repr{}

type _Link__ReprPrototype = _Link__Prototype
type _Link__ReprAssembler = _Link__Assembler

func (n *_List) Lookup(idx int64) Any {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return v
}
func (n *_List) LookupMaybe(idx int64) MaybeAny {
	if n.Length() <= idx {
		return nil
	}
	v := &n.x[idx]
	return &_Any__Maybe{
		m: schema.Maybe_Value,
		v: v,
	}
}

var _List__valueAbsent = _Any__Maybe{m: schema.Maybe_Absent}

func (n List) Iterator() *List__Itr {
	return &List__Itr{n, 0}
}

type List__Itr struct {
	n   List
	idx int
}

func (itr *List__Itr) Next() (idx int64, v Any) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil
	}
	idx = int64(itr.idx)
	v = &itr.n.x[itr.idx]
	itr.idx++
	return
}
func (itr *List__Itr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

type _List__Maybe struct {
	m schema.Maybe
	v _List
}
type MaybeList = *_List__Maybe

func (m MaybeList) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeList) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeList) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeList) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeList) Must() List {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (List)(&_List{})
var _ schema.TypedNode = (List)(&_List{})

func (List) Kind() datamodel.Kind {
	return datamodel.Kind_List
}
func (List) LookupByString(string) (datamodel.Node, error) {
	return mixins.List{TypeName: "dagjose.List"}.LookupByString("")
}
func (n List) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	idx, err := k.AsInt()
	if err != nil {
		return nil, err
	}
	return n.LookupByIndex(idx)
}
func (n List) LookupByIndex(idx int64) (datamodel.Node, error) {
	if n.Length() <= idx {
		return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfInt(idx)}
	}
	v := &n.x[idx]
	return v, nil
}
func (n List) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, datamodel.ErrInvalidSegmentForList{TypeName: "dagjose.List", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (List) MapIterator() datamodel.MapIterator {
	return nil
}
func (n List) ListIterator() datamodel.ListIterator {
	return &_List__ListItr{n, 0}
}

type _List__ListItr struct {
	n   List
	idx int
}

func (itr *_List__ListItr) Next() (idx int64, v datamodel.Node, _ error) {
	if itr.idx >= len(itr.n.x) {
		return -1, nil, datamodel.ErrIteratorOverread{}
	}
	idx = int64(itr.idx)
	x := &itr.n.x[itr.idx]
	v = x
	itr.idx++
	return
}
func (itr *_List__ListItr) Done() bool {
	return itr.idx >= len(itr.n.x)
}

func (n List) Length() int64 {
	return int64(len(n.x))
}
func (List) IsAbsent() bool {
	return false
}
func (List) IsNull() bool {
	return false
}
func (List) AsBool() (bool, error) {
	return mixins.List{TypeName: "dagjose.List"}.AsBool()
}
func (List) AsInt() (int64, error) {
	return mixins.List{TypeName: "dagjose.List"}.AsInt()
}
func (List) AsFloat() (float64, error) {
	return mixins.List{TypeName: "dagjose.List"}.AsFloat()
}
func (List) AsString() (string, error) {
	return mixins.List{TypeName: "dagjose.List"}.AsString()
}
func (List) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "dagjose.List"}.AsBytes()
}
func (List) AsLink() (datamodel.Link, error) {
	return mixins.List{TypeName: "dagjose.List"}.AsLink()
}
func (List) Prototype() datamodel.NodePrototype {
	return _List__Prototype{}
}

type _List__Prototype struct{}

func (_List__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _List__Builder
	nb.Reset()
	return &nb
}

type _List__Builder struct {
	_List__Assembler
}

func (nb *_List__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_List__Builder) Reset() {
	var w _List
	var m schema.Maybe
	*nb = _List__Builder{_List__Assembler{w: &w, m: &m}}
}

type _List__Assembler struct {
	w     *_List
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _Any__Assembler
}

func (na *_List__Assembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_List__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "dagjose.List"}.BeginMap(0)
}
func (na *_List__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_Any, 0, sizeHint)
	}
	return na, nil
}
func (na *_List__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "dagjose.List"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_List__Assembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "dagjose.List"}.AssignBool(false)
}
func (_List__Assembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "dagjose.List"}.AssignInt(0)
}
func (_List__Assembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "dagjose.List"}.AssignFloat(0)
}
func (_List__Assembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "dagjose.List"}.AssignString("")
}
func (_List__Assembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "dagjose.List"}.AssignBytes(nil)
}
func (_List__Assembler) AssignLink(datamodel.Link) error {
	return mixins.ListAssembler{TypeName: "dagjose.List"}.AssignLink(nil)
}
func (na *_List__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_List); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_List {
		return datamodel.ErrWrongKind{TypeName: "dagjose.List", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_List__Assembler) Prototype() datamodel.NodePrototype {
	return _List__Prototype{}
}
func (la *_List__Assembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_List__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _Any{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_List__Assembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_List__Assembler) ValuePrototype(_ int64) datamodel.NodePrototype {
	return _Any__Prototype{}
}
func (List) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n List) Representation() datamodel.Node {
	return (*_List__Repr)(n)
}

type _List__Repr _List

var _ datamodel.Node = &_List__Repr{}

func (_List__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_List
}
func (_List__Repr) LookupByString(string) (datamodel.Node, error) {
	return mixins.List{TypeName: "dagjose.List.Repr"}.LookupByString("")
}
func (nr *_List__Repr) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	v, err := (List)(nr).LookupByNode(k)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(Any).Representation(), nil
}
func (nr *_List__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	v, err := (List)(nr).LookupByIndex(idx)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(Any).Representation(), nil
}
func (n _List__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	i, err := seg.Index()
	if err != nil {
		return nil, datamodel.ErrInvalidSegmentForList{TypeName: "dagjose.List.Repr", TroubleSegment: seg, Reason: err}
	}
	return n.LookupByIndex(i)
}
func (_List__Repr) MapIterator() datamodel.MapIterator {
	return nil
}
func (nr *_List__Repr) ListIterator() datamodel.ListIterator {
	return &_List__ReprListItr{(List)(nr), 0}
}

type _List__ReprListItr _List__ListItr

func (itr *_List__ReprListItr) Next() (idx int64, v datamodel.Node, err error) {
	idx, v, err = (*_List__ListItr)(itr).Next()
	if err != nil || v == datamodel.Null {
		return
	}
	return idx, v.(Any).Representation(), nil
}
func (itr *_List__ReprListItr) Done() bool {
	return (*_List__ListItr)(itr).Done()
}

func (rn *_List__Repr) Length() int64 {
	return int64(len(rn.x))
}
func (_List__Repr) IsAbsent() bool {
	return false
}
func (_List__Repr) IsNull() bool {
	return false
}
func (_List__Repr) AsBool() (bool, error) {
	return mixins.List{TypeName: "dagjose.List.Repr"}.AsBool()
}
func (_List__Repr) AsInt() (int64, error) {
	return mixins.List{TypeName: "dagjose.List.Repr"}.AsInt()
}
func (_List__Repr) AsFloat() (float64, error) {
	return mixins.List{TypeName: "dagjose.List.Repr"}.AsFloat()
}
func (_List__Repr) AsString() (string, error) {
	return mixins.List{TypeName: "dagjose.List.Repr"}.AsString()
}
func (_List__Repr) AsBytes() ([]byte, error) {
	return mixins.List{TypeName: "dagjose.List.Repr"}.AsBytes()
}
func (_List__Repr) AsLink() (datamodel.Link, error) {
	return mixins.List{TypeName: "dagjose.List.Repr"}.AsLink()
}
func (_List__Repr) Prototype() datamodel.NodePrototype {
	return _List__ReprPrototype{}
}

type _List__ReprPrototype struct{}

func (_List__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _List__ReprBuilder
	nb.Reset()
	return &nb
}

type _List__ReprBuilder struct {
	_List__ReprAssembler
}

func (nb *_List__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_List__ReprBuilder) Reset() {
	var w _List
	var m schema.Maybe
	*nb = _List__ReprBuilder{_List__ReprAssembler{w: &w, m: &m}}
}

type _List__ReprAssembler struct {
	w     *_List
	m     *schema.Maybe
	state laState

	cm schema.Maybe
	va _Any__ReprAssembler
}

func (na *_List__ReprAssembler) reset() {
	na.state = laState_initial
	na.va.reset()
}
func (_List__ReprAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.ListAssembler{TypeName: "dagjose.List.Repr"}.BeginMap(0)
}
func (na *_List__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	if sizeHint > 0 {
		na.w.x = make([]_Any, 0, sizeHint)
	}
	return na, nil
}
func (na *_List__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.ListAssembler{TypeName: "dagjose.List.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_List__ReprAssembler) AssignBool(bool) error {
	return mixins.ListAssembler{TypeName: "dagjose.List.Repr"}.AssignBool(false)
}
func (_List__ReprAssembler) AssignInt(int64) error {
	return mixins.ListAssembler{TypeName: "dagjose.List.Repr"}.AssignInt(0)
}
func (_List__ReprAssembler) AssignFloat(float64) error {
	return mixins.ListAssembler{TypeName: "dagjose.List.Repr"}.AssignFloat(0)
}
func (_List__ReprAssembler) AssignString(string) error {
	return mixins.ListAssembler{TypeName: "dagjose.List.Repr"}.AssignString("")
}
func (_List__ReprAssembler) AssignBytes([]byte) error {
	return mixins.ListAssembler{TypeName: "dagjose.List.Repr"}.AssignBytes(nil)
}
func (_List__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.ListAssembler{TypeName: "dagjose.List.Repr"}.AssignLink(nil)
}
func (na *_List__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_List); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_List {
		return datamodel.ErrWrongKind{TypeName: "dagjose.List.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustList, ActualKind: v.Kind()}
	}
	itr := v.ListIterator()
	for !itr.Done() {
		_, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_List__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _List__ReprPrototype{}
}
func (la *_List__ReprAssembler) valueFinishTidy() bool {
	switch la.cm {
	case schema.Maybe_Value:
		la.va.w = nil
		la.cm = schema.Maybe_Absent
		la.state = laState_initial
		la.va.reset()
		return true
	default:
		return false
	}
}
func (la *_List__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when still in the middle of assembling the previous value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	la.w.x = append(la.w.x, _Any{})
	la.state = laState_midValue
	row := &la.w.x[len(la.w.x)-1]
	la.va.w = row
	la.va.m = &la.cm
	return &la.va
}
func (la *_List__ReprAssembler) Finish() error {
	switch la.state {
	case laState_initial:
		// carry on
	case laState_midValue:
		if !la.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case laState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	la.state = laState_finished
	*la.m = schema.Maybe_Value
	return nil
}
func (la *_List__ReprAssembler) ValuePrototype(_ int64) datamodel.NodePrototype {
	return _Any__ReprPrototype{}
}

func (n *_Map) Lookup(k String) Any {
	v, exists := n.m[*k]
	if !exists {
		return nil
	}
	return v
}
func (n *_Map) LookupMaybe(k String) MaybeAny {
	v, exists := n.m[*k]
	if !exists {
		return &_Map__valueAbsent
	}
	return &_Any__Maybe{
		m: schema.Maybe_Value,
		v: v,
	}
}

var _Map__valueAbsent = _Any__Maybe{m: schema.Maybe_Absent}

func (n Map) Iterator() *Map__Itr {
	return &Map__Itr{n, 0}
}

type Map__Itr struct {
	n   Map
	idx int
}

func (itr *Map__Itr) Next() (k String, v Any) {
	if itr.idx >= len(itr.n.t) {
		return nil, nil
	}
	x := &itr.n.t[itr.idx]
	k = &x.k
	v = &x.v
	itr.idx++
	return
}
func (itr *Map__Itr) Done() bool {
	return itr.idx >= len(itr.n.t)
}

type _Map__Maybe struct {
	m schema.Maybe
	v _Map
}
type MaybeMap = *_Map__Maybe

func (m MaybeMap) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeMap) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeMap) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeMap) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeMap) Must() Map {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (Map)(&_Map{})
var _ schema.TypedNode = (Map)(&_Map{})

func (Map) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (n Map) LookupByString(k string) (datamodel.Node, error) {
	var k2 _String
	if err := (_String__ReprPrototype{}).fromString(&k2, k); err != nil {
		return nil, err // TODO wrap in some kind of ErrInvalidKey
	}
	v, exists := n.m[k2]
	if !exists {
		return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(k)}
	}
	return v, nil
}
func (n Map) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	k2, ok := k.(String)
	if !ok {
		panic("todo invalid key type error")
		// 'schema.ErrInvalidKey{TypeName:"dagjose.Map", Key:&_String{k}}' doesn't quite cut it: need room to explain the type, and it's not guaranteed k can be turned into a string at all
	}
	v, exists := n.m[*k2]
	if !exists {
		return nil, datamodel.ErrNotExists{Segment: datamodel.PathSegmentOfString(k2.String())}
	}
	return v, nil
}
func (Map) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.Map"}.LookupByIndex(0)
}
func (n Map) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (n Map) MapIterator() datamodel.MapIterator {
	return &_Map__MapItr{n, 0}
}

type _Map__MapItr struct {
	n   Map
	idx int
}

func (itr *_Map__MapItr) Next() (k datamodel.Node, v datamodel.Node, _ error) {
	if itr.idx >= len(itr.n.t) {
		return nil, nil, datamodel.ErrIteratorOverread{}
	}
	x := &itr.n.t[itr.idx]
	k = &x.k
	v = &x.v
	itr.idx++
	return
}
func (itr *_Map__MapItr) Done() bool {
	return itr.idx >= len(itr.n.t)
}

func (Map) ListIterator() datamodel.ListIterator {
	return nil
}
func (n Map) Length() int64 {
	return int64(len(n.t))
}
func (Map) IsAbsent() bool {
	return false
}
func (Map) IsNull() bool {
	return false
}
func (Map) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.Map"}.AsBool()
}
func (Map) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.Map"}.AsInt()
}
func (Map) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.Map"}.AsFloat()
}
func (Map) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.Map"}.AsString()
}
func (Map) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.Map"}.AsBytes()
}
func (Map) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.Map"}.AsLink()
}
func (Map) Prototype() datamodel.NodePrototype {
	return _Map__Prototype{}
}

type _Map__Prototype struct{}

func (_Map__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Map__Builder
	nb.Reset()
	return &nb
}

type _Map__Builder struct {
	_Map__Assembler
}

func (nb *_Map__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Map__Builder) Reset() {
	var w _Map
	var m schema.Maybe
	*nb = _Map__Builder{_Map__Assembler{w: &w, m: &m}}
}

type _Map__Assembler struct {
	w     *_Map
	m     *schema.Maybe
	state maState

	cm schema.Maybe
	ka _String__Assembler
	va _Any__Assembler
}

func (na *_Map__Assembler) reset() {
	na.state = maState_initial
	na.ka.reset()
	na.va.reset()
}
func (na *_Map__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	na.w.m = make(map[_String]*_Any, sizeHint)
	na.w.t = make([]_Map__entry, 0, sizeHint)
	return na, nil
}
func (_Map__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.Map"}.BeginList(0)
}
func (na *_Map__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.Map"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Map__Assembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.Map"}.AssignBool(false)
}
func (_Map__Assembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.Map"}.AssignInt(0)
}
func (_Map__Assembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.Map"}.AssignFloat(0)
}
func (_Map__Assembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.Map"}.AssignString("")
}
func (_Map__Assembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.Map"}.AssignBytes(nil)
}
func (_Map__Assembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.Map"}.AssignLink(nil)
}
func (na *_Map__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Map); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.Map", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Map__Assembler) Prototype() datamodel.NodePrototype {
	return _Map__Prototype{}
}
func (ma *_Map__Assembler) keyFinishTidy() bool {
	switch ma.cm {
	case schema.Maybe_Value:
		ma.ka.w = nil
		tz := &ma.w.t[len(ma.w.t)-1]
		ma.cm = schema.Maybe_Absent
		ma.state = maState_expectValue
		ma.w.m[tz.k] = &tz.v
		ma.va.w = &tz.v
		ma.va.m = &ma.cm
		ma.ka.reset()
		return true
	default:
		return false
	}
}
func (ma *_Map__Assembler) valueFinishTidy() bool {
	switch ma.cm {
	case schema.Maybe_Value:
		ma.va.w = nil
		ma.cm = schema.Maybe_Absent
		ma.state = maState_initial
		ma.va.reset()
		return true
	default:
		return false
	}
}
func (ma *_Map__Assembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}

	var k2 _String
	if err := (_String__ReprPrototype{}).fromString(&k2, k); err != nil {
		return nil, err // TODO wrap in some kind of ErrInvalidKey
	}
	if _, exists := ma.w.m[k2]; exists {
		return nil, datamodel.ErrRepeatedMapKey{Key: &k2}
	}
	ma.w.t = append(ma.w.t, _Map__entry{k: k2})
	tz := &ma.w.t[len(ma.w.t)-1]
	ma.state = maState_midValue

	ma.w.m[k2] = &tz.v
	ma.va.w = &tz.v
	ma.va.m = &ma.cm
	return &ma.va, nil
}
func (ma *_Map__Assembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.w.t = append(ma.w.t, _Map__entry{})
	ma.state = maState_midKey
	ma.ka.m = &ma.cm
	ma.ka.w = &ma.w.t[len(ma.w.t)-1].k
	return &ma.ka
}
func (ma *_Map__Assembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		if !ma.keyFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
		} // if tidy success: carry on
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	return &ma.va
}
func (ma *_Map__Assembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_Map__Assembler) KeyPrototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (ma *_Map__Assembler) ValuePrototype(_ string) datamodel.NodePrototype {
	return _Any__Prototype{}
}
func (Map) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n Map) Representation() datamodel.Node {
	return (*_Map__Repr)(n)
}

type _Map__Repr _Map

var _ datamodel.Node = &_Map__Repr{}

func (_Map__Repr) Kind() datamodel.Kind {
	return datamodel.Kind_Map
}
func (nr *_Map__Repr) LookupByString(k string) (datamodel.Node, error) {
	v, err := (Map)(nr).LookupByString(k)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(Any).Representation(), nil
}
func (nr *_Map__Repr) LookupByNode(k datamodel.Node) (datamodel.Node, error) {
	v, err := (Map)(nr).LookupByNode(k)
	if err != nil || v == datamodel.Null {
		return v, err
	}
	return v.(Any).Representation(), nil
}
func (_Map__Repr) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.Map{TypeName: "dagjose.Map.Repr"}.LookupByIndex(0)
}
func (n _Map__Repr) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return n.LookupByString(seg.String())
}
func (nr *_Map__Repr) MapIterator() datamodel.MapIterator {
	return &_Map__ReprMapItr{(Map)(nr), 0}
}

type _Map__ReprMapItr _Map__MapItr

func (itr *_Map__ReprMapItr) Next() (k datamodel.Node, v datamodel.Node, err error) {
	k, v, err = (*_Map__MapItr)(itr).Next()
	if err != nil || v == datamodel.Null {
		return
	}
	return k, v.(Any).Representation(), nil
}
func (itr *_Map__ReprMapItr) Done() bool {
	return (*_Map__MapItr)(itr).Done()
}

func (_Map__Repr) ListIterator() datamodel.ListIterator {
	return nil
}
func (rn *_Map__Repr) Length() int64 {
	return int64(len(rn.t))
}
func (_Map__Repr) IsAbsent() bool {
	return false
}
func (_Map__Repr) IsNull() bool {
	return false
}
func (_Map__Repr) AsBool() (bool, error) {
	return mixins.Map{TypeName: "dagjose.Map.Repr"}.AsBool()
}
func (_Map__Repr) AsInt() (int64, error) {
	return mixins.Map{TypeName: "dagjose.Map.Repr"}.AsInt()
}
func (_Map__Repr) AsFloat() (float64, error) {
	return mixins.Map{TypeName: "dagjose.Map.Repr"}.AsFloat()
}
func (_Map__Repr) AsString() (string, error) {
	return mixins.Map{TypeName: "dagjose.Map.Repr"}.AsString()
}
func (_Map__Repr) AsBytes() ([]byte, error) {
	return mixins.Map{TypeName: "dagjose.Map.Repr"}.AsBytes()
}
func (_Map__Repr) AsLink() (datamodel.Link, error) {
	return mixins.Map{TypeName: "dagjose.Map.Repr"}.AsLink()
}
func (_Map__Repr) Prototype() datamodel.NodePrototype {
	return _Map__ReprPrototype{}
}

type _Map__ReprPrototype struct{}

func (_Map__ReprPrototype) NewBuilder() datamodel.NodeBuilder {
	var nb _Map__ReprBuilder
	nb.Reset()
	return &nb
}

type _Map__ReprBuilder struct {
	_Map__ReprAssembler
}

func (nb *_Map__ReprBuilder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_Map__ReprBuilder) Reset() {
	var w _Map
	var m schema.Maybe
	*nb = _Map__ReprBuilder{_Map__ReprAssembler{w: &w, m: &m}}
}

type _Map__ReprAssembler struct {
	w     *_Map
	m     *schema.Maybe
	state maState

	cm schema.Maybe
	ka _String__ReprAssembler
	va _Any__ReprAssembler
}

func (na *_Map__ReprAssembler) reset() {
	na.state = maState_initial
	na.ka.reset()
	na.va.reset()
}
func (na *_Map__ReprAssembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: it makes no sense to 'begin' twice on the same assembler!")
	}
	*na.m = midvalue
	if sizeHint < 0 {
		sizeHint = 0
	}
	na.w.m = make(map[_String]*_Any, sizeHint)
	na.w.t = make([]_Map__entry, 0, sizeHint)
	return na, nil
}
func (_Map__ReprAssembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.MapAssembler{TypeName: "dagjose.Map.Repr"}.BeginList(0)
}
func (na *_Map__ReprAssembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.MapAssembler{TypeName: "dagjose.Map.Repr.Repr"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	case midvalue:
		panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
	}
	panic("unreachable")
}
func (_Map__ReprAssembler) AssignBool(bool) error {
	return mixins.MapAssembler{TypeName: "dagjose.Map.Repr"}.AssignBool(false)
}
func (_Map__ReprAssembler) AssignInt(int64) error {
	return mixins.MapAssembler{TypeName: "dagjose.Map.Repr"}.AssignInt(0)
}
func (_Map__ReprAssembler) AssignFloat(float64) error {
	return mixins.MapAssembler{TypeName: "dagjose.Map.Repr"}.AssignFloat(0)
}
func (_Map__ReprAssembler) AssignString(string) error {
	return mixins.MapAssembler{TypeName: "dagjose.Map.Repr"}.AssignString("")
}
func (_Map__ReprAssembler) AssignBytes([]byte) error {
	return mixins.MapAssembler{TypeName: "dagjose.Map.Repr"}.AssignBytes(nil)
}
func (_Map__ReprAssembler) AssignLink(datamodel.Link) error {
	return mixins.MapAssembler{TypeName: "dagjose.Map.Repr"}.AssignLink(nil)
}
func (na *_Map__ReprAssembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_Map); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		case midvalue:
			panic("invalid state: cannot assign null into an assembler that's already begun working on recursive structures!")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v.Kind() != datamodel.Kind_Map {
		return datamodel.ErrWrongKind{TypeName: "dagjose.Map.Repr", MethodName: "AssignNode", AppropriateKind: datamodel.KindSet_JustMap, ActualKind: v.Kind()}
	}
	itr := v.MapIterator()
	for !itr.Done() {
		k, v, err := itr.Next()
		if err != nil {
			return err
		}
		if err := na.AssembleKey().AssignNode(k); err != nil {
			return err
		}
		if err := na.AssembleValue().AssignNode(v); err != nil {
			return err
		}
	}
	return na.Finish()
}
func (_Map__ReprAssembler) Prototype() datamodel.NodePrototype {
	return _Map__ReprPrototype{}
}
func (ma *_Map__ReprAssembler) keyFinishTidy() bool {
	switch ma.cm {
	case schema.Maybe_Value:
		ma.ka.w = nil
		tz := &ma.w.t[len(ma.w.t)-1]
		ma.cm = schema.Maybe_Absent
		ma.state = maState_expectValue
		ma.w.m[tz.k] = &tz.v
		ma.va.w = &tz.v
		ma.va.m = &ma.cm
		ma.ka.reset()
		return true
	default:
		return false
	}
}
func (ma *_Map__ReprAssembler) valueFinishTidy() bool {
	switch ma.cm {
	case schema.Maybe_Value:
		ma.va.w = nil
		ma.cm = schema.Maybe_Absent
		ma.state = maState_initial
		ma.va.reset()
		return true
	default:
		return false
	}
}
func (ma *_Map__ReprAssembler) AssembleEntry(k string) (datamodel.NodeAssembler, error) {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleEntry cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleEntry cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleEntry cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleEntry cannot be called on an assembler that's already finished")
	}

	var k2 _String
	if err := (_String__ReprPrototype{}).fromString(&k2, k); err != nil {
		return nil, err // TODO wrap in some kind of ErrInvalidKey
	}
	if _, exists := ma.w.m[k2]; exists {
		return nil, datamodel.ErrRepeatedMapKey{Key: &k2}
	}
	ma.w.t = append(ma.w.t, _Map__entry{k: k2})
	tz := &ma.w.t[len(ma.w.t)-1]
	ma.state = maState_midValue

	ma.w.m[k2] = &tz.v
	ma.va.w = &tz.v
	ma.va.m = &ma.cm
	return &ma.va, nil
}
func (ma *_Map__ReprAssembler) AssembleKey() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: AssembleKey cannot be called when in the middle of assembling another key")
	case maState_expectValue:
		panic("invalid state: AssembleKey cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: AssembleKey cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: AssembleKey cannot be called on an assembler that's already finished")
	}
	ma.w.t = append(ma.w.t, _Map__entry{})
	ma.state = maState_midKey
	ma.ka.m = &ma.cm
	ma.ka.w = &ma.w.t[len(ma.w.t)-1].k
	return &ma.ka
}
func (ma *_Map__ReprAssembler) AssembleValue() datamodel.NodeAssembler {
	switch ma.state {
	case maState_initial:
		panic("invalid state: AssembleValue cannot be called when no key is primed")
	case maState_midKey:
		if !ma.keyFinishTidy() {
			panic("invalid state: AssembleValue cannot be called when in the middle of assembling a key")
		} // if tidy success: carry on
	case maState_expectValue:
		// carry on
	case maState_midValue:
		panic("invalid state: AssembleValue cannot be called when in the middle of assembling another value")
	case maState_finished:
		panic("invalid state: AssembleValue cannot be called on an assembler that's already finished")
	}
	ma.state = maState_midValue
	return &ma.va
}
func (ma *_Map__ReprAssembler) Finish() error {
	switch ma.state {
	case maState_initial:
		// carry on
	case maState_midKey:
		panic("invalid state: Finish cannot be called when in the middle of assembling a key")
	case maState_expectValue:
		panic("invalid state: Finish cannot be called when expecting start of value assembly")
	case maState_midValue:
		if !ma.valueFinishTidy() {
			panic("invalid state: Finish cannot be called when in the middle of assembling a value")
		} // if tidy success: carry on
	case maState_finished:
		panic("invalid state: Finish cannot be called on an assembler that's already finished")
	}
	ma.state = maState_finished
	*ma.m = schema.Maybe_Value
	return nil
}
func (ma *_Map__ReprAssembler) KeyPrototype() datamodel.NodePrototype {
	return _String__ReprPrototype{}
}
func (ma *_Map__ReprAssembler) ValuePrototype(_ string) datamodel.NodePrototype {
	return _Any__ReprPrototype{}
}

func (n String) String() string {
	return n.x
}
func (_String__Prototype) fromString(w *_String, v string) error {
	*w = _String{v}
	return nil
}
func (_String__Prototype) FromString(v string) (String, error) {
	n := _String{v}
	return &n, nil
}

type _String__Maybe struct {
	m schema.Maybe
	v _String
}
type MaybeString = *_String__Maybe

func (m MaybeString) IsNull() bool {
	return m.m == schema.Maybe_Null
}
func (m MaybeString) IsAbsent() bool {
	return m.m == schema.Maybe_Absent
}
func (m MaybeString) Exists() bool {
	return m.m == schema.Maybe_Value
}
func (m MaybeString) AsNode() datamodel.Node {
	switch m.m {
	case schema.Maybe_Absent:
		return datamodel.Absent
	case schema.Maybe_Null:
		return datamodel.Null
	case schema.Maybe_Value:
		return &m.v
	default:
		panic("unreachable")
	}
}
func (m MaybeString) Must() String {
	if !m.Exists() {
		panic("unbox of a maybe rejected")
	}
	return &m.v
}

var _ datamodel.Node = (String)(&_String{})
var _ schema.TypedNode = (String)(&_String{})

func (String) Kind() datamodel.Kind {
	return datamodel.Kind_String
}
func (String) LookupByString(string) (datamodel.Node, error) {
	return mixins.String{TypeName: "dagjose.String"}.LookupByString("")
}
func (String) LookupByNode(datamodel.Node) (datamodel.Node, error) {
	return mixins.String{TypeName: "dagjose.String"}.LookupByNode(nil)
}
func (String) LookupByIndex(idx int64) (datamodel.Node, error) {
	return mixins.String{TypeName: "dagjose.String"}.LookupByIndex(0)
}
func (String) LookupBySegment(seg datamodel.PathSegment) (datamodel.Node, error) {
	return mixins.String{TypeName: "dagjose.String"}.LookupBySegment(seg)
}
func (String) MapIterator() datamodel.MapIterator {
	return nil
}
func (String) ListIterator() datamodel.ListIterator {
	return nil
}
func (String) Length() int64 {
	return -1
}
func (String) IsAbsent() bool {
	return false
}
func (String) IsNull() bool {
	return false
}
func (String) AsBool() (bool, error) {
	return mixins.String{TypeName: "dagjose.String"}.AsBool()
}
func (String) AsInt() (int64, error) {
	return mixins.String{TypeName: "dagjose.String"}.AsInt()
}
func (String) AsFloat() (float64, error) {
	return mixins.String{TypeName: "dagjose.String"}.AsFloat()
}
func (n String) AsString() (string, error) {
	return n.x, nil
}
func (String) AsBytes() ([]byte, error) {
	return mixins.String{TypeName: "dagjose.String"}.AsBytes()
}
func (String) AsLink() (datamodel.Link, error) {
	return mixins.String{TypeName: "dagjose.String"}.AsLink()
}
func (String) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}

type _String__Prototype struct{}

func (_String__Prototype) NewBuilder() datamodel.NodeBuilder {
	var nb _String__Builder
	nb.Reset()
	return &nb
}

type _String__Builder struct {
	_String__Assembler
}

func (nb *_String__Builder) Build() datamodel.Node {
	if *nb.m != schema.Maybe_Value {
		panic("invalid state: cannot call Build on an assembler that's not finished")
	}
	return nb.w
}
func (nb *_String__Builder) Reset() {
	var w _String
	var m schema.Maybe
	*nb = _String__Builder{_String__Assembler{w: &w, m: &m}}
}

type _String__Assembler struct {
	w *_String
	m *schema.Maybe
}

func (na *_String__Assembler) reset() {}
func (_String__Assembler) BeginMap(sizeHint int64) (datamodel.MapAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.String"}.BeginMap(0)
}
func (_String__Assembler) BeginList(sizeHint int64) (datamodel.ListAssembler, error) {
	return mixins.StringAssembler{TypeName: "dagjose.String"}.BeginList(0)
}
func (na *_String__Assembler) AssignNull() error {
	switch *na.m {
	case allowNull:
		*na.m = schema.Maybe_Null
		return nil
	case schema.Maybe_Absent:
		return mixins.StringAssembler{TypeName: "dagjose.String"}.AssignNull()
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	panic("unreachable")
}
func (_String__Assembler) AssignBool(bool) error {
	return mixins.StringAssembler{TypeName: "dagjose.String"}.AssignBool(false)
}
func (_String__Assembler) AssignInt(int64) error {
	return mixins.StringAssembler{TypeName: "dagjose.String"}.AssignInt(0)
}
func (_String__Assembler) AssignFloat(float64) error {
	return mixins.StringAssembler{TypeName: "dagjose.String"}.AssignFloat(0)
}
func (na *_String__Assembler) AssignString(v string) error {
	switch *na.m {
	case schema.Maybe_Value, schema.Maybe_Null:
		panic("invalid state: cannot assign into assembler that's already finished")
	}
	na.w.x = v
	*na.m = schema.Maybe_Value
	return nil
}
func (_String__Assembler) AssignBytes([]byte) error {
	return mixins.StringAssembler{TypeName: "dagjose.String"}.AssignBytes(nil)
}
func (_String__Assembler) AssignLink(datamodel.Link) error {
	return mixins.StringAssembler{TypeName: "dagjose.String"}.AssignLink(nil)
}
func (na *_String__Assembler) AssignNode(v datamodel.Node) error {
	if v.IsNull() {
		return na.AssignNull()
	}
	if v2, ok := v.(*_String); ok {
		switch *na.m {
		case schema.Maybe_Value, schema.Maybe_Null:
			panic("invalid state: cannot assign into assembler that's already finished")
		}
		*na.w = *v2
		*na.m = schema.Maybe_Value
		return nil
	}
	if v2, err := v.AsString(); err != nil {
		return err
	} else {
		return na.AssignString(v2)
	}
}
func (_String__Assembler) Prototype() datamodel.NodePrototype {
	return _String__Prototype{}
}
func (String) Type() schema.Type {
	return nil /*TODO:typelit*/
}
func (n String) Representation() datamodel.Node {
	return (*_String__Repr)(n)
}

type _String__Repr = _String

var _ datamodel.Node = &_String__Repr{}

type _String__ReprPrototype = _String__Prototype
type _String__ReprAssembler = _String__Assembler
