// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/gkemulticloud/v1/azure_service.proto

package gkemulticloudpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AzureClusters_CreateAzureClient_FullMethodName              = "/google.cloud.gkemulticloud.v1.AzureClusters/CreateAzureClient"
	AzureClusters_GetAzureClient_FullMethodName                 = "/google.cloud.gkemulticloud.v1.AzureClusters/GetAzureClient"
	AzureClusters_ListAzureClients_FullMethodName               = "/google.cloud.gkemulticloud.v1.AzureClusters/ListAzureClients"
	AzureClusters_DeleteAzureClient_FullMethodName              = "/google.cloud.gkemulticloud.v1.AzureClusters/DeleteAzureClient"
	AzureClusters_CreateAzureCluster_FullMethodName             = "/google.cloud.gkemulticloud.v1.AzureClusters/CreateAzureCluster"
	AzureClusters_UpdateAzureCluster_FullMethodName             = "/google.cloud.gkemulticloud.v1.AzureClusters/UpdateAzureCluster"
	AzureClusters_GetAzureCluster_FullMethodName                = "/google.cloud.gkemulticloud.v1.AzureClusters/GetAzureCluster"
	AzureClusters_ListAzureClusters_FullMethodName              = "/google.cloud.gkemulticloud.v1.AzureClusters/ListAzureClusters"
	AzureClusters_DeleteAzureCluster_FullMethodName             = "/google.cloud.gkemulticloud.v1.AzureClusters/DeleteAzureCluster"
	AzureClusters_GenerateAzureClusterAgentToken_FullMethodName = "/google.cloud.gkemulticloud.v1.AzureClusters/GenerateAzureClusterAgentToken"
	AzureClusters_GenerateAzureAccessToken_FullMethodName       = "/google.cloud.gkemulticloud.v1.AzureClusters/GenerateAzureAccessToken"
	AzureClusters_CreateAzureNodePool_FullMethodName            = "/google.cloud.gkemulticloud.v1.AzureClusters/CreateAzureNodePool"
	AzureClusters_UpdateAzureNodePool_FullMethodName            = "/google.cloud.gkemulticloud.v1.AzureClusters/UpdateAzureNodePool"
	AzureClusters_GetAzureNodePool_FullMethodName               = "/google.cloud.gkemulticloud.v1.AzureClusters/GetAzureNodePool"
	AzureClusters_ListAzureNodePools_FullMethodName             = "/google.cloud.gkemulticloud.v1.AzureClusters/ListAzureNodePools"
	AzureClusters_DeleteAzureNodePool_FullMethodName            = "/google.cloud.gkemulticloud.v1.AzureClusters/DeleteAzureNodePool"
	AzureClusters_GetAzureOpenIdConfig_FullMethodName           = "/google.cloud.gkemulticloud.v1.AzureClusters/GetAzureOpenIdConfig"
	AzureClusters_GetAzureJsonWebKeys_FullMethodName            = "/google.cloud.gkemulticloud.v1.AzureClusters/GetAzureJsonWebKeys"
	AzureClusters_GetAzureServerConfig_FullMethodName           = "/google.cloud.gkemulticloud.v1.AzureClusters/GetAzureServerConfig"
)

// AzureClustersClient is the client API for AzureClusters service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Deprecated: Do not use.
type AzureClustersClient interface {
	// Deprecated: Do not use.
	// Creates a new [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
	// resource on a given Google Cloud project and region.
	//
	// `AzureClient` resources hold client authentication
	// information needed by the Anthos Multicloud API to manage Azure resources
	// on your Azure subscription on your behalf.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAzureClient(ctx context.Context, in *CreateAzureClientRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Describes a specific
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource.
	GetAzureClient(ctx context.Context, in *GetAzureClientRequest, opts ...grpc.CallOption) (*AzureClient, error)
	// Deprecated: Do not use.
	// Lists all [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
	// resources on a given Google Cloud project and region.
	ListAzureClients(ctx context.Context, in *ListAzureClientsRequest, opts ...grpc.CallOption) (*ListAzureClientsResponse, error)
	// Deprecated: Do not use.
	// Deletes a specific [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
	// resource.
	//
	// If the client is used by one or more clusters, deletion will
	// fail and a `FAILED_PRECONDITION` error will be returned.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAzureClient(ctx context.Context, in *DeleteAzureClientRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Creates a new [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
	// resource on a given Google Cloud Platform project and region.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAzureCluster(ctx context.Context, in *CreateAzureClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Updates an [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
	UpdateAzureCluster(ctx context.Context, in *UpdateAzureClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Describes a specific
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
	GetAzureCluster(ctx context.Context, in *GetAzureClusterRequest, opts ...grpc.CallOption) (*AzureCluster, error)
	// Deprecated: Do not use.
	// Lists all [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
	// resources on a given Google Cloud project and region.
	ListAzureClusters(ctx context.Context, in *ListAzureClustersRequest, opts ...grpc.CallOption) (*ListAzureClustersResponse, error)
	// Deprecated: Do not use.
	// Deletes a specific
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
	//
	// Fails if the cluster has one or more associated
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resources.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAzureCluster(ctx context.Context, in *DeleteAzureClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Generates an access token for a cluster agent.
	GenerateAzureClusterAgentToken(ctx context.Context, in *GenerateAzureClusterAgentTokenRequest, opts ...grpc.CallOption) (*GenerateAzureClusterAgentTokenResponse, error)
	// Deprecated: Do not use.
	// Generates a short-lived access token to authenticate to a given
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
	GenerateAzureAccessToken(ctx context.Context, in *GenerateAzureAccessTokenRequest, opts ...grpc.CallOption) (*GenerateAzureAccessTokenResponse, error)
	// Deprecated: Do not use.
	// Creates a new [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool],
	// attached to a given
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAzureNodePool(ctx context.Context, in *CreateAzureNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Updates an [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool].
	UpdateAzureNodePool(ctx context.Context, in *UpdateAzureNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Describes a specific
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
	GetAzureNodePool(ctx context.Context, in *GetAzureNodePoolRequest, opts ...grpc.CallOption) (*AzureNodePool, error)
	// Deprecated: Do not use.
	// Lists all [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]
	// resources on a given
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
	ListAzureNodePools(ctx context.Context, in *ListAzureNodePoolsRequest, opts ...grpc.CallOption) (*ListAzureNodePoolsResponse, error)
	// Deprecated: Do not use.
	// Deletes a specific
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAzureNodePool(ctx context.Context, in *DeleteAzureNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Gets the OIDC discovery document for the cluster.
	// See the
	// [OpenID Connect Discovery 1.0
	// specification](https://openid.net/specs/openid-connect-discovery-1_0.html)
	// for details.
	GetAzureOpenIdConfig(ctx context.Context, in *GetAzureOpenIdConfigRequest, opts ...grpc.CallOption) (*AzureOpenIdConfig, error)
	// Deprecated: Do not use.
	// Gets the public component of the cluster signing keys in
	// JSON Web Key format.
	GetAzureJsonWebKeys(ctx context.Context, in *GetAzureJsonWebKeysRequest, opts ...grpc.CallOption) (*AzureJsonWebKeys, error)
	// Deprecated: Do not use.
	// Returns information, such as supported Azure regions and Kubernetes
	// versions, on a given Google Cloud location.
	GetAzureServerConfig(ctx context.Context, in *GetAzureServerConfigRequest, opts ...grpc.CallOption) (*AzureServerConfig, error)
}

type azureClustersClient struct {
	cc grpc.ClientConnInterface
}

// Deprecated: Do not use.
func NewAzureClustersClient(cc grpc.ClientConnInterface) AzureClustersClient {
	return &azureClustersClient{cc}
}

// Deprecated: Do not use.
func (c *azureClustersClient) CreateAzureClient(ctx context.Context, in *CreateAzureClientRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AzureClusters_CreateAzureClient_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) GetAzureClient(ctx context.Context, in *GetAzureClientRequest, opts ...grpc.CallOption) (*AzureClient, error) {
	out := new(AzureClient)
	err := c.cc.Invoke(ctx, AzureClusters_GetAzureClient_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) ListAzureClients(ctx context.Context, in *ListAzureClientsRequest, opts ...grpc.CallOption) (*ListAzureClientsResponse, error) {
	out := new(ListAzureClientsResponse)
	err := c.cc.Invoke(ctx, AzureClusters_ListAzureClients_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) DeleteAzureClient(ctx context.Context, in *DeleteAzureClientRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AzureClusters_DeleteAzureClient_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) CreateAzureCluster(ctx context.Context, in *CreateAzureClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AzureClusters_CreateAzureCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) UpdateAzureCluster(ctx context.Context, in *UpdateAzureClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AzureClusters_UpdateAzureCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) GetAzureCluster(ctx context.Context, in *GetAzureClusterRequest, opts ...grpc.CallOption) (*AzureCluster, error) {
	out := new(AzureCluster)
	err := c.cc.Invoke(ctx, AzureClusters_GetAzureCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) ListAzureClusters(ctx context.Context, in *ListAzureClustersRequest, opts ...grpc.CallOption) (*ListAzureClustersResponse, error) {
	out := new(ListAzureClustersResponse)
	err := c.cc.Invoke(ctx, AzureClusters_ListAzureClusters_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) DeleteAzureCluster(ctx context.Context, in *DeleteAzureClusterRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AzureClusters_DeleteAzureCluster_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) GenerateAzureClusterAgentToken(ctx context.Context, in *GenerateAzureClusterAgentTokenRequest, opts ...grpc.CallOption) (*GenerateAzureClusterAgentTokenResponse, error) {
	out := new(GenerateAzureClusterAgentTokenResponse)
	err := c.cc.Invoke(ctx, AzureClusters_GenerateAzureClusterAgentToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) GenerateAzureAccessToken(ctx context.Context, in *GenerateAzureAccessTokenRequest, opts ...grpc.CallOption) (*GenerateAzureAccessTokenResponse, error) {
	out := new(GenerateAzureAccessTokenResponse)
	err := c.cc.Invoke(ctx, AzureClusters_GenerateAzureAccessToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) CreateAzureNodePool(ctx context.Context, in *CreateAzureNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AzureClusters_CreateAzureNodePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) UpdateAzureNodePool(ctx context.Context, in *UpdateAzureNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AzureClusters_UpdateAzureNodePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) GetAzureNodePool(ctx context.Context, in *GetAzureNodePoolRequest, opts ...grpc.CallOption) (*AzureNodePool, error) {
	out := new(AzureNodePool)
	err := c.cc.Invoke(ctx, AzureClusters_GetAzureNodePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) ListAzureNodePools(ctx context.Context, in *ListAzureNodePoolsRequest, opts ...grpc.CallOption) (*ListAzureNodePoolsResponse, error) {
	out := new(ListAzureNodePoolsResponse)
	err := c.cc.Invoke(ctx, AzureClusters_ListAzureNodePools_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) DeleteAzureNodePool(ctx context.Context, in *DeleteAzureNodePoolRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, AzureClusters_DeleteAzureNodePool_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) GetAzureOpenIdConfig(ctx context.Context, in *GetAzureOpenIdConfigRequest, opts ...grpc.CallOption) (*AzureOpenIdConfig, error) {
	out := new(AzureOpenIdConfig)
	err := c.cc.Invoke(ctx, AzureClusters_GetAzureOpenIdConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) GetAzureJsonWebKeys(ctx context.Context, in *GetAzureJsonWebKeysRequest, opts ...grpc.CallOption) (*AzureJsonWebKeys, error) {
	out := new(AzureJsonWebKeys)
	err := c.cc.Invoke(ctx, AzureClusters_GetAzureJsonWebKeys_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *azureClustersClient) GetAzureServerConfig(ctx context.Context, in *GetAzureServerConfigRequest, opts ...grpc.CallOption) (*AzureServerConfig, error) {
	out := new(AzureServerConfig)
	err := c.cc.Invoke(ctx, AzureClusters_GetAzureServerConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AzureClustersServer is the server API for AzureClusters service.
// All implementations should embed UnimplementedAzureClustersServer
// for forward compatibility
//
// Deprecated: Do not use.
type AzureClustersServer interface {
	// Deprecated: Do not use.
	// Creates a new [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
	// resource on a given Google Cloud project and region.
	//
	// `AzureClient` resources hold client authentication
	// information needed by the Anthos Multicloud API to manage Azure resources
	// on your Azure subscription on your behalf.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAzureClient(context.Context, *CreateAzureClientRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Describes a specific
	// [AzureClient][google.cloud.gkemulticloud.v1.AzureClient] resource.
	GetAzureClient(context.Context, *GetAzureClientRequest) (*AzureClient, error)
	// Deprecated: Do not use.
	// Lists all [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
	// resources on a given Google Cloud project and region.
	ListAzureClients(context.Context, *ListAzureClientsRequest) (*ListAzureClientsResponse, error)
	// Deprecated: Do not use.
	// Deletes a specific [AzureClient][google.cloud.gkemulticloud.v1.AzureClient]
	// resource.
	//
	// If the client is used by one or more clusters, deletion will
	// fail and a `FAILED_PRECONDITION` error will be returned.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAzureClient(context.Context, *DeleteAzureClientRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Creates a new [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
	// resource on a given Google Cloud Platform project and region.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAzureCluster(context.Context, *CreateAzureClusterRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Updates an [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
	UpdateAzureCluster(context.Context, *UpdateAzureClusterRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Describes a specific
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
	GetAzureCluster(context.Context, *GetAzureClusterRequest) (*AzureCluster, error)
	// Deprecated: Do not use.
	// Lists all [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster]
	// resources on a given Google Cloud project and region.
	ListAzureClusters(context.Context, *ListAzureClustersRequest) (*ListAzureClustersResponse, error)
	// Deprecated: Do not use.
	// Deletes a specific
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
	//
	// Fails if the cluster has one or more associated
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resources.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAzureCluster(context.Context, *DeleteAzureClusterRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Generates an access token for a cluster agent.
	GenerateAzureClusterAgentToken(context.Context, *GenerateAzureClusterAgentTokenRequest) (*GenerateAzureClusterAgentTokenResponse, error)
	// Deprecated: Do not use.
	// Generates a short-lived access token to authenticate to a given
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster] resource.
	GenerateAzureAccessToken(context.Context, *GenerateAzureAccessTokenRequest) (*GenerateAzureAccessTokenResponse, error)
	// Deprecated: Do not use.
	// Creates a new [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool],
	// attached to a given
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	CreateAzureNodePool(context.Context, *CreateAzureNodePoolRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Updates an [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool].
	UpdateAzureNodePool(context.Context, *UpdateAzureNodePoolRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Describes a specific
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
	GetAzureNodePool(context.Context, *GetAzureNodePoolRequest) (*AzureNodePool, error)
	// Deprecated: Do not use.
	// Lists all [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool]
	// resources on a given
	// [AzureCluster][google.cloud.gkemulticloud.v1.AzureCluster].
	ListAzureNodePools(context.Context, *ListAzureNodePoolsRequest) (*ListAzureNodePoolsResponse, error)
	// Deprecated: Do not use.
	// Deletes a specific
	// [AzureNodePool][google.cloud.gkemulticloud.v1.AzureNodePool] resource.
	//
	// If successful, the response contains a newly created
	// [Operation][google.longrunning.Operation] resource that can be
	// described to track the status of the operation.
	DeleteAzureNodePool(context.Context, *DeleteAzureNodePoolRequest) (*longrunningpb.Operation, error)
	// Deprecated: Do not use.
	// Gets the OIDC discovery document for the cluster.
	// See the
	// [OpenID Connect Discovery 1.0
	// specification](https://openid.net/specs/openid-connect-discovery-1_0.html)
	// for details.
	GetAzureOpenIdConfig(context.Context, *GetAzureOpenIdConfigRequest) (*AzureOpenIdConfig, error)
	// Deprecated: Do not use.
	// Gets the public component of the cluster signing keys in
	// JSON Web Key format.
	GetAzureJsonWebKeys(context.Context, *GetAzureJsonWebKeysRequest) (*AzureJsonWebKeys, error)
	// Deprecated: Do not use.
	// Returns information, such as supported Azure regions and Kubernetes
	// versions, on a given Google Cloud location.
	GetAzureServerConfig(context.Context, *GetAzureServerConfigRequest) (*AzureServerConfig, error)
}

// UnimplementedAzureClustersServer should be embedded to have forward compatible implementations.
type UnimplementedAzureClustersServer struct {
}

func (UnimplementedAzureClustersServer) CreateAzureClient(context.Context, *CreateAzureClientRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAzureClient not implemented")
}
func (UnimplementedAzureClustersServer) GetAzureClient(context.Context, *GetAzureClientRequest) (*AzureClient, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAzureClient not implemented")
}
func (UnimplementedAzureClustersServer) ListAzureClients(context.Context, *ListAzureClientsRequest) (*ListAzureClientsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAzureClients not implemented")
}
func (UnimplementedAzureClustersServer) DeleteAzureClient(context.Context, *DeleteAzureClientRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAzureClient not implemented")
}
func (UnimplementedAzureClustersServer) CreateAzureCluster(context.Context, *CreateAzureClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAzureCluster not implemented")
}
func (UnimplementedAzureClustersServer) UpdateAzureCluster(context.Context, *UpdateAzureClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAzureCluster not implemented")
}
func (UnimplementedAzureClustersServer) GetAzureCluster(context.Context, *GetAzureClusterRequest) (*AzureCluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAzureCluster not implemented")
}
func (UnimplementedAzureClustersServer) ListAzureClusters(context.Context, *ListAzureClustersRequest) (*ListAzureClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAzureClusters not implemented")
}
func (UnimplementedAzureClustersServer) DeleteAzureCluster(context.Context, *DeleteAzureClusterRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAzureCluster not implemented")
}
func (UnimplementedAzureClustersServer) GenerateAzureClusterAgentToken(context.Context, *GenerateAzureClusterAgentTokenRequest) (*GenerateAzureClusterAgentTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAzureClusterAgentToken not implemented")
}
func (UnimplementedAzureClustersServer) GenerateAzureAccessToken(context.Context, *GenerateAzureAccessTokenRequest) (*GenerateAzureAccessTokenResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateAzureAccessToken not implemented")
}
func (UnimplementedAzureClustersServer) CreateAzureNodePool(context.Context, *CreateAzureNodePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAzureNodePool not implemented")
}
func (UnimplementedAzureClustersServer) UpdateAzureNodePool(context.Context, *UpdateAzureNodePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAzureNodePool not implemented")
}
func (UnimplementedAzureClustersServer) GetAzureNodePool(context.Context, *GetAzureNodePoolRequest) (*AzureNodePool, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAzureNodePool not implemented")
}
func (UnimplementedAzureClustersServer) ListAzureNodePools(context.Context, *ListAzureNodePoolsRequest) (*ListAzureNodePoolsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAzureNodePools not implemented")
}
func (UnimplementedAzureClustersServer) DeleteAzureNodePool(context.Context, *DeleteAzureNodePoolRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAzureNodePool not implemented")
}
func (UnimplementedAzureClustersServer) GetAzureOpenIdConfig(context.Context, *GetAzureOpenIdConfigRequest) (*AzureOpenIdConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAzureOpenIdConfig not implemented")
}
func (UnimplementedAzureClustersServer) GetAzureJsonWebKeys(context.Context, *GetAzureJsonWebKeysRequest) (*AzureJsonWebKeys, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAzureJsonWebKeys not implemented")
}
func (UnimplementedAzureClustersServer) GetAzureServerConfig(context.Context, *GetAzureServerConfigRequest) (*AzureServerConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAzureServerConfig not implemented")
}

// UnsafeAzureClustersServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AzureClustersServer will
// result in compilation errors.
type UnsafeAzureClustersServer interface {
	mustEmbedUnimplementedAzureClustersServer()
}

// Deprecated: Do not use.
func RegisterAzureClustersServer(s grpc.ServiceRegistrar, srv AzureClustersServer) {
	s.RegisterService(&AzureClusters_ServiceDesc, srv)
}

func _AzureClusters_CreateAzureClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAzureClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).CreateAzureClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_CreateAzureClient_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).CreateAzureClient(ctx, req.(*CreateAzureClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_GetAzureClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAzureClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).GetAzureClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_GetAzureClient_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).GetAzureClient(ctx, req.(*GetAzureClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_ListAzureClients_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAzureClientsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).ListAzureClients(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_ListAzureClients_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).ListAzureClients(ctx, req.(*ListAzureClientsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_DeleteAzureClient_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAzureClientRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).DeleteAzureClient(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_DeleteAzureClient_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).DeleteAzureClient(ctx, req.(*DeleteAzureClientRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_CreateAzureCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAzureClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).CreateAzureCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_CreateAzureCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).CreateAzureCluster(ctx, req.(*CreateAzureClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_UpdateAzureCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAzureClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).UpdateAzureCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_UpdateAzureCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).UpdateAzureCluster(ctx, req.(*UpdateAzureClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_GetAzureCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAzureClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).GetAzureCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_GetAzureCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).GetAzureCluster(ctx, req.(*GetAzureClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_ListAzureClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAzureClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).ListAzureClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_ListAzureClusters_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).ListAzureClusters(ctx, req.(*ListAzureClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_DeleteAzureCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAzureClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).DeleteAzureCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_DeleteAzureCluster_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).DeleteAzureCluster(ctx, req.(*DeleteAzureClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_GenerateAzureClusterAgentToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAzureClusterAgentTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).GenerateAzureClusterAgentToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_GenerateAzureClusterAgentToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).GenerateAzureClusterAgentToken(ctx, req.(*GenerateAzureClusterAgentTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_GenerateAzureAccessToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateAzureAccessTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).GenerateAzureAccessToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_GenerateAzureAccessToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).GenerateAzureAccessToken(ctx, req.(*GenerateAzureAccessTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_CreateAzureNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAzureNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).CreateAzureNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_CreateAzureNodePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).CreateAzureNodePool(ctx, req.(*CreateAzureNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_UpdateAzureNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAzureNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).UpdateAzureNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_UpdateAzureNodePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).UpdateAzureNodePool(ctx, req.(*UpdateAzureNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_GetAzureNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAzureNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).GetAzureNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_GetAzureNodePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).GetAzureNodePool(ctx, req.(*GetAzureNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_ListAzureNodePools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAzureNodePoolsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).ListAzureNodePools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_ListAzureNodePools_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).ListAzureNodePools(ctx, req.(*ListAzureNodePoolsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_DeleteAzureNodePool_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAzureNodePoolRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).DeleteAzureNodePool(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_DeleteAzureNodePool_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).DeleteAzureNodePool(ctx, req.(*DeleteAzureNodePoolRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_GetAzureOpenIdConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAzureOpenIdConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).GetAzureOpenIdConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_GetAzureOpenIdConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).GetAzureOpenIdConfig(ctx, req.(*GetAzureOpenIdConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_GetAzureJsonWebKeys_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAzureJsonWebKeysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).GetAzureJsonWebKeys(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_GetAzureJsonWebKeys_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).GetAzureJsonWebKeys(ctx, req.(*GetAzureJsonWebKeysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AzureClusters_GetAzureServerConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAzureServerConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AzureClustersServer).GetAzureServerConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AzureClusters_GetAzureServerConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AzureClustersServer).GetAzureServerConfig(ctx, req.(*GetAzureServerConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AzureClusters_ServiceDesc is the grpc.ServiceDesc for AzureClusters service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AzureClusters_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.gkemulticloud.v1.AzureClusters",
	HandlerType: (*AzureClustersServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAzureClient",
			Handler:    _AzureClusters_CreateAzureClient_Handler,
		},
		{
			MethodName: "GetAzureClient",
			Handler:    _AzureClusters_GetAzureClient_Handler,
		},
		{
			MethodName: "ListAzureClients",
			Handler:    _AzureClusters_ListAzureClients_Handler,
		},
		{
			MethodName: "DeleteAzureClient",
			Handler:    _AzureClusters_DeleteAzureClient_Handler,
		},
		{
			MethodName: "CreateAzureCluster",
			Handler:    _AzureClusters_CreateAzureCluster_Handler,
		},
		{
			MethodName: "UpdateAzureCluster",
			Handler:    _AzureClusters_UpdateAzureCluster_Handler,
		},
		{
			MethodName: "GetAzureCluster",
			Handler:    _AzureClusters_GetAzureCluster_Handler,
		},
		{
			MethodName: "ListAzureClusters",
			Handler:    _AzureClusters_ListAzureClusters_Handler,
		},
		{
			MethodName: "DeleteAzureCluster",
			Handler:    _AzureClusters_DeleteAzureCluster_Handler,
		},
		{
			MethodName: "GenerateAzureClusterAgentToken",
			Handler:    _AzureClusters_GenerateAzureClusterAgentToken_Handler,
		},
		{
			MethodName: "GenerateAzureAccessToken",
			Handler:    _AzureClusters_GenerateAzureAccessToken_Handler,
		},
		{
			MethodName: "CreateAzureNodePool",
			Handler:    _AzureClusters_CreateAzureNodePool_Handler,
		},
		{
			MethodName: "UpdateAzureNodePool",
			Handler:    _AzureClusters_UpdateAzureNodePool_Handler,
		},
		{
			MethodName: "GetAzureNodePool",
			Handler:    _AzureClusters_GetAzureNodePool_Handler,
		},
		{
			MethodName: "ListAzureNodePools",
			Handler:    _AzureClusters_ListAzureNodePools_Handler,
		},
		{
			MethodName: "DeleteAzureNodePool",
			Handler:    _AzureClusters_DeleteAzureNodePool_Handler,
		},
		{
			MethodName: "GetAzureOpenIdConfig",
			Handler:    _AzureClusters_GetAzureOpenIdConfig_Handler,
		},
		{
			MethodName: "GetAzureJsonWebKeys",
			Handler:    _AzureClusters_GetAzureJsonWebKeys_Handler,
		},
		{
			MethodName: "GetAzureServerConfig",
			Handler:    _AzureClusters_GetAzureServerConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/gkemulticloud/v1/azure_service.proto",
}
