// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/v2beta1/generator_evaluation.proto

package dialogflowpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	GeneratorEvaluations_CreateGeneratorEvaluation_FullMethodName = "/google.cloud.dialogflow.v2beta1.GeneratorEvaluations/CreateGeneratorEvaluation"
	GeneratorEvaluations_GetGeneratorEvaluation_FullMethodName    = "/google.cloud.dialogflow.v2beta1.GeneratorEvaluations/GetGeneratorEvaluation"
	GeneratorEvaluations_ListGeneratorEvaluations_FullMethodName  = "/google.cloud.dialogflow.v2beta1.GeneratorEvaluations/ListGeneratorEvaluations"
	GeneratorEvaluations_DeleteGeneratorEvaluation_FullMethodName = "/google.cloud.dialogflow.v2beta1.GeneratorEvaluations/DeleteGeneratorEvaluation"
)

// GeneratorEvaluationsClient is the client API for GeneratorEvaluations service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GeneratorEvaluationsClient interface {
	// Creates evaluation of a generator.
	CreateGeneratorEvaluation(ctx context.Context, in *CreateGeneratorEvaluationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets an evaluation of generator.
	GetGeneratorEvaluation(ctx context.Context, in *GetGeneratorEvaluationRequest, opts ...grpc.CallOption) (*GeneratorEvaluation, error)
	// Lists evaluations of generator.
	ListGeneratorEvaluations(ctx context.Context, in *ListGeneratorEvaluationsRequest, opts ...grpc.CallOption) (*ListGeneratorEvaluationsResponse, error)
	// Deletes an evaluation of generator.
	DeleteGeneratorEvaluation(ctx context.Context, in *DeleteGeneratorEvaluationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type generatorEvaluationsClient struct {
	cc grpc.ClientConnInterface
}

func NewGeneratorEvaluationsClient(cc grpc.ClientConnInterface) GeneratorEvaluationsClient {
	return &generatorEvaluationsClient{cc}
}

func (c *generatorEvaluationsClient) CreateGeneratorEvaluation(ctx context.Context, in *CreateGeneratorEvaluationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, GeneratorEvaluations_CreateGeneratorEvaluation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generatorEvaluationsClient) GetGeneratorEvaluation(ctx context.Context, in *GetGeneratorEvaluationRequest, opts ...grpc.CallOption) (*GeneratorEvaluation, error) {
	out := new(GeneratorEvaluation)
	err := c.cc.Invoke(ctx, GeneratorEvaluations_GetGeneratorEvaluation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generatorEvaluationsClient) ListGeneratorEvaluations(ctx context.Context, in *ListGeneratorEvaluationsRequest, opts ...grpc.CallOption) (*ListGeneratorEvaluationsResponse, error) {
	out := new(ListGeneratorEvaluationsResponse)
	err := c.cc.Invoke(ctx, GeneratorEvaluations_ListGeneratorEvaluations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *generatorEvaluationsClient) DeleteGeneratorEvaluation(ctx context.Context, in *DeleteGeneratorEvaluationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, GeneratorEvaluations_DeleteGeneratorEvaluation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GeneratorEvaluationsServer is the server API for GeneratorEvaluations service.
// All implementations should embed UnimplementedGeneratorEvaluationsServer
// for forward compatibility
type GeneratorEvaluationsServer interface {
	// Creates evaluation of a generator.
	CreateGeneratorEvaluation(context.Context, *CreateGeneratorEvaluationRequest) (*longrunningpb.Operation, error)
	// Gets an evaluation of generator.
	GetGeneratorEvaluation(context.Context, *GetGeneratorEvaluationRequest) (*GeneratorEvaluation, error)
	// Lists evaluations of generator.
	ListGeneratorEvaluations(context.Context, *ListGeneratorEvaluationsRequest) (*ListGeneratorEvaluationsResponse, error)
	// Deletes an evaluation of generator.
	DeleteGeneratorEvaluation(context.Context, *DeleteGeneratorEvaluationRequest) (*emptypb.Empty, error)
}

// UnimplementedGeneratorEvaluationsServer should be embedded to have forward compatible implementations.
type UnimplementedGeneratorEvaluationsServer struct {
}

func (UnimplementedGeneratorEvaluationsServer) CreateGeneratorEvaluation(context.Context, *CreateGeneratorEvaluationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGeneratorEvaluation not implemented")
}
func (UnimplementedGeneratorEvaluationsServer) GetGeneratorEvaluation(context.Context, *GetGeneratorEvaluationRequest) (*GeneratorEvaluation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGeneratorEvaluation not implemented")
}
func (UnimplementedGeneratorEvaluationsServer) ListGeneratorEvaluations(context.Context, *ListGeneratorEvaluationsRequest) (*ListGeneratorEvaluationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGeneratorEvaluations not implemented")
}
func (UnimplementedGeneratorEvaluationsServer) DeleteGeneratorEvaluation(context.Context, *DeleteGeneratorEvaluationRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGeneratorEvaluation not implemented")
}

// UnsafeGeneratorEvaluationsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GeneratorEvaluationsServer will
// result in compilation errors.
type UnsafeGeneratorEvaluationsServer interface {
	mustEmbedUnimplementedGeneratorEvaluationsServer()
}

func RegisterGeneratorEvaluationsServer(s grpc.ServiceRegistrar, srv GeneratorEvaluationsServer) {
	s.RegisterService(&GeneratorEvaluations_ServiceDesc, srv)
}

func _GeneratorEvaluations_CreateGeneratorEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGeneratorEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GeneratorEvaluationsServer).CreateGeneratorEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GeneratorEvaluations_CreateGeneratorEvaluation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GeneratorEvaluationsServer).CreateGeneratorEvaluation(ctx, req.(*CreateGeneratorEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GeneratorEvaluations_GetGeneratorEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGeneratorEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GeneratorEvaluationsServer).GetGeneratorEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GeneratorEvaluations_GetGeneratorEvaluation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GeneratorEvaluationsServer).GetGeneratorEvaluation(ctx, req.(*GetGeneratorEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GeneratorEvaluations_ListGeneratorEvaluations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGeneratorEvaluationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GeneratorEvaluationsServer).ListGeneratorEvaluations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GeneratorEvaluations_ListGeneratorEvaluations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GeneratorEvaluationsServer).ListGeneratorEvaluations(ctx, req.(*ListGeneratorEvaluationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GeneratorEvaluations_DeleteGeneratorEvaluation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGeneratorEvaluationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GeneratorEvaluationsServer).DeleteGeneratorEvaluation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GeneratorEvaluations_DeleteGeneratorEvaluation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GeneratorEvaluationsServer).DeleteGeneratorEvaluation(ctx, req.(*DeleteGeneratorEvaluationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GeneratorEvaluations_ServiceDesc is the grpc.ServiceDesc for GeneratorEvaluations service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GeneratorEvaluations_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.GeneratorEvaluations",
	HandlerType: (*GeneratorEvaluationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateGeneratorEvaluation",
			Handler:    _GeneratorEvaluations_CreateGeneratorEvaluation_Handler,
		},
		{
			MethodName: "GetGeneratorEvaluation",
			Handler:    _GeneratorEvaluations_GetGeneratorEvaluation_Handler,
		},
		{
			MethodName: "ListGeneratorEvaluations",
			Handler:    _GeneratorEvaluations_ListGeneratorEvaluations_Handler,
		},
		{
			MethodName: "DeleteGeneratorEvaluation",
			Handler:    _GeneratorEvaluations_DeleteGeneratorEvaluation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/generator_evaluation.proto",
}
