// Code generated by cmd/lexgen (see Makefile's lexgen); DO NOT EDIT.

package bsky

// schema: app.bsky.notification.listNotifications

import (
	"context"

	comatprototypes "github.com/bluesky-social/indigo/api/atproto"
	"github.com/bluesky-social/indigo/lex/util"
)

// NotificationListNotifications_Notification is a "notification" in the app.bsky.notification.listNotifications schema.
type NotificationListNotifications_Notification struct {
	Author    *ActorDefs_ProfileView             `json:"author" cborgen:"author"`
	Cid       string                             `json:"cid" cborgen:"cid"`
	IndexedAt string                             `json:"indexedAt" cborgen:"indexedAt"`
	IsRead    bool                               `json:"isRead" cborgen:"isRead"`
	Labels    []*comatprototypes.LabelDefs_Label `json:"labels,omitempty" cborgen:"labels,omitempty"`
	// reason: The reason why this notification was delivered - e.g. your post was liked, or you received a new follower.
	Reason        string                   `json:"reason" cborgen:"reason"`
	ReasonSubject *string                  `json:"reasonSubject,omitempty" cborgen:"reasonSubject,omitempty"`
	Record        *util.LexiconTypeDecoder `json:"record" cborgen:"record"`
	Uri           string                   `json:"uri" cborgen:"uri"`
}

// NotificationListNotifications_Output is the output of a app.bsky.notification.listNotifications call.
type NotificationListNotifications_Output struct {
	Cursor        *string                                       `json:"cursor,omitempty" cborgen:"cursor,omitempty"`
	Notifications []*NotificationListNotifications_Notification `json:"notifications" cborgen:"notifications"`
	Priority      *bool                                         `json:"priority,omitempty" cborgen:"priority,omitempty"`
	SeenAt        *string                                       `json:"seenAt,omitempty" cborgen:"seenAt,omitempty"`
}

// NotificationListNotifications calls the XRPC method "app.bsky.notification.listNotifications".
//
// reasons: Notification reasons to include in response.
func NotificationListNotifications(ctx context.Context, c util.LexClient, cursor string, limit int64, priority bool, reasons []string, seenAt string) (*NotificationListNotifications_Output, error) {
	var out NotificationListNotifications_Output

	params := map[string]interface{}{}
	if cursor != "" {
		params["cursor"] = cursor
	}
	if limit != 0 {
		params["limit"] = limit
	}
	if priority {
		params["priority"] = priority
	}
	if len(reasons) != 0 {
		params["reasons"] = reasons
	}
	if seenAt != "" {
		params["seenAt"] = seenAt
	}
	if err := c.LexDo(ctx, util.Query, "", "app.bsky.notification.listNotifications", params, nil, &out); err != nil {
		return nil, err
	}

	return &out, nil
}
