// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
	"github.com/go-acme/jdcloud-sdk-go/core"
	domainservice "github.com/go-acme/jdcloud-sdk-go/services/domainservice/models"
)

type DescribeMonitorAlarmRequest struct {
	core.JDCloudRequest

	/* 实例所属的地域ID  */
	RegionId string `json:"regionId"`

	/* 域名ID，请使用describeDomains接口获取。  */
	DomainId string `json:"domainId"`

	/* 当前页数，起始值为1，默认为1 (Optional) */
	PageIndex *int `json:"pageIndex"`

	/* 分页查询时设置的每页行数 (Optional) */
	PageSize *int `json:"pageSize"`

	/* 关键字 (Optional) */
	SearchValue *string `json:"searchValue"`
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewDescribeMonitorAlarmRequest(
	regionId string,
	domainId string,
) *DescribeMonitorAlarmRequest {

	return &DescribeMonitorAlarmRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/monitorAlarm",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
		RegionId: regionId,
		DomainId: domainId,
	}
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param pageIndex: 当前页数，起始值为1，默认为1 (Optional)
 * param pageSize: 分页查询时设置的每页行数 (Optional)
 * param searchValue: 关键字 (Optional)
 */
func NewDescribeMonitorAlarmRequestWithAllParams(
	regionId string,
	domainId string,
	pageIndex *int,
	pageSize *int,
	searchValue *string,
) *DescribeMonitorAlarmRequest {

	return &DescribeMonitorAlarmRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/monitorAlarm",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
		RegionId:    regionId,
		DomainId:    domainId,
		PageIndex:   pageIndex,
		PageSize:    pageSize,
		SearchValue: searchValue,
	}
}

/* This constructor has better compatible ability when API parameters changed */
func NewDescribeMonitorAlarmRequestWithoutParam() *DescribeMonitorAlarmRequest {

	return &DescribeMonitorAlarmRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/monitorAlarm",
			Method:  "GET",
			Header:  nil,
			Version: "v2",
		},
	}
}

/* param regionId: 实例所属的地域ID(Required) */
func (r *DescribeMonitorAlarmRequest) SetRegionId(regionId string) {
	r.RegionId = regionId
}

/* param domainId: 域名ID，请使用describeDomains接口获取。(Required) */
func (r *DescribeMonitorAlarmRequest) SetDomainId(domainId string) {
	r.DomainId = domainId
}

/* param pageIndex: 当前页数，起始值为1，默认为1(Optional) */
func (r *DescribeMonitorAlarmRequest) SetPageIndex(pageIndex int) {
	r.PageIndex = &pageIndex
}

/* param pageSize: 分页查询时设置的每页行数(Optional) */
func (r *DescribeMonitorAlarmRequest) SetPageSize(pageSize int) {
	r.PageSize = &pageSize
}

/* param searchValue: 关键字(Optional) */
func (r *DescribeMonitorAlarmRequest) SetSearchValue(searchValue string) {
	r.SearchValue = &searchValue
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r DescribeMonitorAlarmRequest) GetRegionId() string {
	return r.RegionId
}

type DescribeMonitorAlarmResponse struct {
	RequestID string                     `json:"requestId"`
	Error     core.ErrorResponse         `json:"error"`
	Result    DescribeMonitorAlarmResult `json:"result"`
}

type DescribeMonitorAlarmResult struct {
	CurrentCount int                              `json:"currentCount"`
	TotalCount   int                              `json:"totalCount"`
	TotalPage    int                              `json:"totalPage"`
	DataList     []domainservice.MonitorAlarmInfo `json:"dataList"`
}
