/*
 * Decompiled with CFR 0.152.
 */
package mockit.coverage.reporting.parsing;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.coverage.reporting.parsing.LineElement;
import mockit.coverage.reporting.parsing.LineParser;

public final class FileParser {
    @Nonnull
    public final LineParser lineParser = new LineParser();
    @Nonnull
    public final List<PendingClass> currentClasses = new ArrayList<PendingClass>(2);
    @Nullable
    private PendingClass currentClass;
    private boolean openingBraceForClassFound;
    private int currentBraceBalance;

    public boolean parseCurrentLine(@Nonnull String line) {
        if (!this.lineParser.parse(line)) {
            return false;
        }
        LineElement firstElement = this.lineParser.getInitialElement();
        LineElement classDeclaration = this.findClassNameInNewClassDeclaration();
        if (classDeclaration != null) {
            firstElement = classDeclaration;
            this.registerStartOfClassDeclaration(classDeclaration);
        }
        if (this.currentClass != null) {
            this.detectPotentialEndOfClassDeclaration(firstElement);
        }
        return true;
    }

    @Nullable
    private LineElement findClassNameInNewClassDeclaration() {
        LineElement previous = null;
        for (LineElement element : this.lineParser.getInitialElement()) {
            if (element.isKeyword("class") && (previous == null || !previous.isDotSeparator())) {
                return element.getNextCodeElement();
            }
            previous = element;
        }
        return null;
    }

    private void registerStartOfClassDeclaration(@Nonnull LineElement elementWithClassName) {
        String className = elementWithClassName.getText();
        if (this.currentClass != null) {
            this.currentClass.braceBalance = this.currentBraceBalance;
        }
        this.currentClass = new PendingClass(className);
        this.currentClasses.add(this.currentClass);
        this.currentBraceBalance = 0;
    }

    private void detectPotentialEndOfClassDeclaration(@Nonnull LineElement firstElement) {
        this.currentBraceBalance += firstElement.getBraceBalanceUntilEndOfLine();
        if (!this.openingBraceForClassFound && this.currentBraceBalance > 0) {
            this.openingBraceForClassFound = true;
        } else if (this.openingBraceForClassFound && this.currentBraceBalance == 0) {
            this.restorePreviousPendingClassIfAny();
        }
    }

    private void restorePreviousPendingClassIfAny() {
        this.currentClasses.remove(this.currentClass);
        if (this.currentClasses.isEmpty()) {
            this.currentClass = null;
        } else {
            this.currentClass = this.currentClasses.get(this.currentClasses.size() - 1);
            this.currentBraceBalance = this.currentClass.braceBalance;
        }
    }

    @Nullable
    public String getCurrentlyPendingClass() {
        return this.currentClass == null ? null : this.currentClass.className;
    }

    private static final class PendingClass {
        @Nonnull
        final String className;
        int braceBalance;

        PendingClass(@Nonnull String className) {
            this.className = className;
        }
    }
}

