/*
 * Decompiled with CFR 0.152.
 */
package mockit.internal.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mockit.internal.reflection.ConstructorReflection;
import mockit.internal.util.ClassLoad;
import mockit.internal.util.TypeDescriptor;

public final class RealMethodOrConstructor {
    @Nonnull
    public final Member member;

    public RealMethodOrConstructor(@Nonnull String className, @Nonnull String memberNameAndDesc) throws NoSuchMethodException {
        this(ClassLoad.loadFromLoader(RealMethodOrConstructor.class.getClassLoader(), className), memberNameAndDesc);
    }

    public RealMethodOrConstructor(@Nonnull Class<?> realClass, @Nonnull String memberNameAndDesc) throws NoSuchMethodException {
        int p = memberNameAndDesc.indexOf(40);
        String memberDesc = memberNameAndDesc.substring(p);
        if (memberNameAndDesc.charAt(0) == '<') {
            this.member = RealMethodOrConstructor.findConstructor(realClass, memberDesc);
        } else {
            String methodName = memberNameAndDesc.substring(0, p);
            this.member = RealMethodOrConstructor.findMethod(realClass, methodName, memberDesc);
        }
    }

    public RealMethodOrConstructor(@Nonnull Class<?> realClass, @Nonnull String memberName, @Nonnull String memberDesc) throws NoSuchMethodException {
        this.member = memberName.charAt(0) == '<' ? RealMethodOrConstructor.findConstructor(realClass, memberDesc) : RealMethodOrConstructor.findMethod(realClass, memberName, memberDesc);
    }

    @Nonnull
    private static Constructor<?> findConstructor(@Nonnull Class<?> realClass, @Nonnull String constructorDesc) {
        Class<?>[] parameterTypes = TypeDescriptor.getParameterTypes(constructorDesc);
        return ConstructorReflection.findSpecifiedConstructor(realClass, parameterTypes);
    }

    @Nonnull
    private static Method findMethod(@Nonnull Class<?> realClass, @Nonnull String methodName, @Nonnull String methodDesc) throws NoSuchMethodException {
        Class<?>[] parameterTypes = TypeDescriptor.getParameterTypes(methodDesc);
        Class<?> ownerClass = realClass;
        while (true) {
            try {
                Method method;
                while ((method = ownerClass.getDeclaredMethod(methodName, parameterTypes)).isBridge()) {
                    ownerClass = ownerClass.getSuperclass();
                }
                return method;
            }
            catch (NoSuchMethodException e) {
                Method interfaceMethod = RealMethodOrConstructor.findInterfaceMethod(ownerClass, methodName, parameterTypes);
                if (interfaceMethod == null) continue;
                return interfaceMethod;
                if ((ownerClass = ownerClass.getSuperclass()) != null && ownerClass != Object.class) continue;
                throw e;
            }
            break;
        }
    }

    @Nullable
    private static Method findInterfaceMethod(@Nonnull Class<?> aType, @Nonnull String methodName, @Nonnull Class<?>[] parameterTypes) {
        for (Class<?> anInterface : aType.getInterfaces()) {
            try {
                return anInterface.getMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return null;
    }

    @Nonnull
    public <M extends Member> M getMember() {
        return (M)this.member;
    }
}

