package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// CreateAlarmTemplateResponse Response Object
type CreateAlarmTemplateResponse struct {

	// **参数解释**： 告警模板的ID。 **取值范围**： 以at开头，后跟字母、数字，长度为[2,64]个字符。
	TemplateId *string `json:"template_id,omitempty"`

	OverwriteResult *OverwriteResultResp `json:"overwrite_result,omitempty"`
	HttpStatusCode  int                  `json:"-"`
}

func (o CreateAlarmTemplateResponse) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "CreateAlarmTemplateResponse struct{}"
	}

	return strings.Join([]string{"CreateAlarmTemplateResponse", string(data)}, " ")
}
