package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// VulnerabilityDataObjectVulnerabilityType 漏洞类型信息
type VulnerabilityDataObjectVulnerabilityType struct {

	// 类型ID
	Id *string `json:"id,omitempty"`

	// 漏洞类别
	Category *string `json:"category,omitempty"`

	// 漏洞类别英文
	CategoryEn *string `json:"category_en,omitempty"`

	// 漏洞类别中文
	CategoryZh *string `json:"category_zh,omitempty"`

	// 漏洞类型
	VulnerabilityType *string `json:"vulnerability_type,omitempty"`

	// 漏洞类型英文
	VulnerabilityTypeEn *string `json:"vulnerability_type_en,omitempty"`

	// 漏洞类型中文
	VulnerabilityTypeZh *string `json:"vulnerability_type_zh,omitempty"`
}

func (o VulnerabilityDataObjectVulnerabilityType) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "VulnerabilityDataObjectVulnerabilityType struct{}"
	}

	return strings.Join([]string{"VulnerabilityDataObjectVulnerabilityType", string(data)}, " ")
}
