// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package notebooks

import (
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/url"
	"time"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	notebookspb "cloud.google.com/go/notebooks/apiv1/notebookspb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/proto"
)

var newManagedNotebookClientHook clientHook

// ManagedNotebookCallOptions contains the retry settings for each method of ManagedNotebookClient.
type ManagedNotebookCallOptions struct {
	ListRuntimes                []gax.CallOption
	GetRuntime                  []gax.CallOption
	CreateRuntime               []gax.CallOption
	UpdateRuntime               []gax.CallOption
	DeleteRuntime               []gax.CallOption
	StartRuntime                []gax.CallOption
	StopRuntime                 []gax.CallOption
	SwitchRuntime               []gax.CallOption
	ResetRuntime                []gax.CallOption
	UpgradeRuntime              []gax.CallOption
	ReportRuntimeEvent          []gax.CallOption
	RefreshRuntimeTokenInternal []gax.CallOption
	DiagnoseRuntime             []gax.CallOption
	GetLocation                 []gax.CallOption
	ListLocations               []gax.CallOption
	GetIamPolicy                []gax.CallOption
	SetIamPolicy                []gax.CallOption
	TestIamPermissions          []gax.CallOption
	CancelOperation             []gax.CallOption
	DeleteOperation             []gax.CallOption
	GetOperation                []gax.CallOption
	ListOperations              []gax.CallOption
}

func defaultManagedNotebookGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("notebooks.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("notebooks.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("notebooks.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://notebooks.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultManagedNotebookCallOptions() *ManagedNotebookCallOptions {
	return &ManagedNotebookCallOptions{
		ListRuntimes: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetRuntime: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		CreateRuntime: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		UpdateRuntime: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		DeleteRuntime: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StartRuntime: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		StopRuntime: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		SwitchRuntime: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		ResetRuntime: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		UpgradeRuntime: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ReportRuntimeEvent: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		RefreshRuntimeTokenInternal: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        60000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DiagnoseRuntime: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
		},
		GetLocation:        []gax.CallOption{},
		ListLocations:      []gax.CallOption{},
		GetIamPolicy:       []gax.CallOption{},
		SetIamPolicy:       []gax.CallOption{},
		TestIamPermissions: []gax.CallOption{},
		CancelOperation:    []gax.CallOption{},
		DeleteOperation:    []gax.CallOption{},
		GetOperation:       []gax.CallOption{},
		ListOperations: []gax.CallOption{
			gax.WithTimeout(300000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
					codes.DeadlineExceeded,
				}, gax.Backoff{
					Initial:    100 * time.Millisecond,
					Max:        300000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

// internalManagedNotebookClient is an interface that defines the methods available from Notebooks API.
type internalManagedNotebookClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListRuntimes(context.Context, *notebookspb.ListRuntimesRequest, ...gax.CallOption) *RuntimeIterator
	GetRuntime(context.Context, *notebookspb.GetRuntimeRequest, ...gax.CallOption) (*notebookspb.Runtime, error)
	CreateRuntime(context.Context, *notebookspb.CreateRuntimeRequest, ...gax.CallOption) (*CreateRuntimeOperation, error)
	CreateRuntimeOperation(name string) *CreateRuntimeOperation
	UpdateRuntime(context.Context, *notebookspb.UpdateRuntimeRequest, ...gax.CallOption) (*UpdateRuntimeOperation, error)
	UpdateRuntimeOperation(name string) *UpdateRuntimeOperation
	DeleteRuntime(context.Context, *notebookspb.DeleteRuntimeRequest, ...gax.CallOption) (*DeleteRuntimeOperation, error)
	DeleteRuntimeOperation(name string) *DeleteRuntimeOperation
	StartRuntime(context.Context, *notebookspb.StartRuntimeRequest, ...gax.CallOption) (*StartRuntimeOperation, error)
	StartRuntimeOperation(name string) *StartRuntimeOperation
	StopRuntime(context.Context, *notebookspb.StopRuntimeRequest, ...gax.CallOption) (*StopRuntimeOperation, error)
	StopRuntimeOperation(name string) *StopRuntimeOperation
	SwitchRuntime(context.Context, *notebookspb.SwitchRuntimeRequest, ...gax.CallOption) (*SwitchRuntimeOperation, error)
	SwitchRuntimeOperation(name string) *SwitchRuntimeOperation
	ResetRuntime(context.Context, *notebookspb.ResetRuntimeRequest, ...gax.CallOption) (*ResetRuntimeOperation, error)
	ResetRuntimeOperation(name string) *ResetRuntimeOperation
	UpgradeRuntime(context.Context, *notebookspb.UpgradeRuntimeRequest, ...gax.CallOption) (*UpgradeRuntimeOperation, error)
	UpgradeRuntimeOperation(name string) *UpgradeRuntimeOperation
	ReportRuntimeEvent(context.Context, *notebookspb.ReportRuntimeEventRequest, ...gax.CallOption) (*ReportRuntimeEventOperation, error)
	ReportRuntimeEventOperation(name string) *ReportRuntimeEventOperation
	RefreshRuntimeTokenInternal(context.Context, *notebookspb.RefreshRuntimeTokenInternalRequest, ...gax.CallOption) (*notebookspb.RefreshRuntimeTokenInternalResponse, error)
	DiagnoseRuntime(context.Context, *notebookspb.DiagnoseRuntimeRequest, ...gax.CallOption) (*DiagnoseRuntimeOperation, error)
	DiagnoseRuntimeOperation(name string) *DiagnoseRuntimeOperation
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest, ...gax.CallOption) (*iampb.Policy, error)
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest, ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error)
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// ManagedNotebookClient is a client for interacting with Notebooks API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// API v1 service for Managed Notebooks.
type ManagedNotebookClient struct {
	// The internal transport-dependent client.
	internalClient internalManagedNotebookClient

	// The call options for this service.
	CallOptions *ManagedNotebookCallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *ManagedNotebookClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *ManagedNotebookClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *ManagedNotebookClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListRuntimes lists Runtimes in a given project and location.
func (c *ManagedNotebookClient) ListRuntimes(ctx context.Context, req *notebookspb.ListRuntimesRequest, opts ...gax.CallOption) *RuntimeIterator {
	return c.internalClient.ListRuntimes(ctx, req, opts...)
}

// GetRuntime gets details of a single Runtime. The location must be a regional endpoint
// rather than zonal.
func (c *ManagedNotebookClient) GetRuntime(ctx context.Context, req *notebookspb.GetRuntimeRequest, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	return c.internalClient.GetRuntime(ctx, req, opts...)
}

// CreateRuntime creates a new Runtime in a given project and location.
func (c *ManagedNotebookClient) CreateRuntime(ctx context.Context, req *notebookspb.CreateRuntimeRequest, opts ...gax.CallOption) (*CreateRuntimeOperation, error) {
	return c.internalClient.CreateRuntime(ctx, req, opts...)
}

// CreateRuntimeOperation returns a new CreateRuntimeOperation from a given name.
// The name must be that of a previously created CreateRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) CreateRuntimeOperation(name string) *CreateRuntimeOperation {
	return c.internalClient.CreateRuntimeOperation(name)
}

// UpdateRuntime update Notebook Runtime configuration.
func (c *ManagedNotebookClient) UpdateRuntime(ctx context.Context, req *notebookspb.UpdateRuntimeRequest, opts ...gax.CallOption) (*UpdateRuntimeOperation, error) {
	return c.internalClient.UpdateRuntime(ctx, req, opts...)
}

// UpdateRuntimeOperation returns a new UpdateRuntimeOperation from a given name.
// The name must be that of a previously created UpdateRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) UpdateRuntimeOperation(name string) *UpdateRuntimeOperation {
	return c.internalClient.UpdateRuntimeOperation(name)
}

// DeleteRuntime deletes a single Runtime.
func (c *ManagedNotebookClient) DeleteRuntime(ctx context.Context, req *notebookspb.DeleteRuntimeRequest, opts ...gax.CallOption) (*DeleteRuntimeOperation, error) {
	return c.internalClient.DeleteRuntime(ctx, req, opts...)
}

// DeleteRuntimeOperation returns a new DeleteRuntimeOperation from a given name.
// The name must be that of a previously created DeleteRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) DeleteRuntimeOperation(name string) *DeleteRuntimeOperation {
	return c.internalClient.DeleteRuntimeOperation(name)
}

// StartRuntime starts a Managed Notebook Runtime.
// Perform “Start” on GPU instances; “Resume” on CPU instances
// See:
// https://cloud.google.com/compute/docs/instances/stop-start-instance (at https://cloud.google.com/compute/docs/instances/stop-start-instance)
// https://cloud.google.com/compute/docs/instances/suspend-resume-instance (at https://cloud.google.com/compute/docs/instances/suspend-resume-instance)
func (c *ManagedNotebookClient) StartRuntime(ctx context.Context, req *notebookspb.StartRuntimeRequest, opts ...gax.CallOption) (*StartRuntimeOperation, error) {
	return c.internalClient.StartRuntime(ctx, req, opts...)
}

// StartRuntimeOperation returns a new StartRuntimeOperation from a given name.
// The name must be that of a previously created StartRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) StartRuntimeOperation(name string) *StartRuntimeOperation {
	return c.internalClient.StartRuntimeOperation(name)
}

// StopRuntime stops a Managed Notebook Runtime.
// Perform “Stop” on GPU instances; “Suspend” on CPU instances
// See:
// https://cloud.google.com/compute/docs/instances/stop-start-instance (at https://cloud.google.com/compute/docs/instances/stop-start-instance)
// https://cloud.google.com/compute/docs/instances/suspend-resume-instance (at https://cloud.google.com/compute/docs/instances/suspend-resume-instance)
func (c *ManagedNotebookClient) StopRuntime(ctx context.Context, req *notebookspb.StopRuntimeRequest, opts ...gax.CallOption) (*StopRuntimeOperation, error) {
	return c.internalClient.StopRuntime(ctx, req, opts...)
}

// StopRuntimeOperation returns a new StopRuntimeOperation from a given name.
// The name must be that of a previously created StopRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) StopRuntimeOperation(name string) *StopRuntimeOperation {
	return c.internalClient.StopRuntimeOperation(name)
}

// SwitchRuntime switch a Managed Notebook Runtime.
func (c *ManagedNotebookClient) SwitchRuntime(ctx context.Context, req *notebookspb.SwitchRuntimeRequest, opts ...gax.CallOption) (*SwitchRuntimeOperation, error) {
	return c.internalClient.SwitchRuntime(ctx, req, opts...)
}

// SwitchRuntimeOperation returns a new SwitchRuntimeOperation from a given name.
// The name must be that of a previously created SwitchRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) SwitchRuntimeOperation(name string) *SwitchRuntimeOperation {
	return c.internalClient.SwitchRuntimeOperation(name)
}

// ResetRuntime resets a Managed Notebook Runtime.
func (c *ManagedNotebookClient) ResetRuntime(ctx context.Context, req *notebookspb.ResetRuntimeRequest, opts ...gax.CallOption) (*ResetRuntimeOperation, error) {
	return c.internalClient.ResetRuntime(ctx, req, opts...)
}

// ResetRuntimeOperation returns a new ResetRuntimeOperation from a given name.
// The name must be that of a previously created ResetRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) ResetRuntimeOperation(name string) *ResetRuntimeOperation {
	return c.internalClient.ResetRuntimeOperation(name)
}

// UpgradeRuntime upgrades a Managed Notebook Runtime to the latest version.
func (c *ManagedNotebookClient) UpgradeRuntime(ctx context.Context, req *notebookspb.UpgradeRuntimeRequest, opts ...gax.CallOption) (*UpgradeRuntimeOperation, error) {
	return c.internalClient.UpgradeRuntime(ctx, req, opts...)
}

// UpgradeRuntimeOperation returns a new UpgradeRuntimeOperation from a given name.
// The name must be that of a previously created UpgradeRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) UpgradeRuntimeOperation(name string) *UpgradeRuntimeOperation {
	return c.internalClient.UpgradeRuntimeOperation(name)
}

// ReportRuntimeEvent report and process a runtime event.
func (c *ManagedNotebookClient) ReportRuntimeEvent(ctx context.Context, req *notebookspb.ReportRuntimeEventRequest, opts ...gax.CallOption) (*ReportRuntimeEventOperation, error) {
	return c.internalClient.ReportRuntimeEvent(ctx, req, opts...)
}

// ReportRuntimeEventOperation returns a new ReportRuntimeEventOperation from a given name.
// The name must be that of a previously created ReportRuntimeEventOperation, possibly from a different process.
func (c *ManagedNotebookClient) ReportRuntimeEventOperation(name string) *ReportRuntimeEventOperation {
	return c.internalClient.ReportRuntimeEventOperation(name)
}

// RefreshRuntimeTokenInternal gets an access token for the consumer service account that the customer
// attached to the runtime. Only accessible from the tenant instance.
func (c *ManagedNotebookClient) RefreshRuntimeTokenInternal(ctx context.Context, req *notebookspb.RefreshRuntimeTokenInternalRequest, opts ...gax.CallOption) (*notebookspb.RefreshRuntimeTokenInternalResponse, error) {
	return c.internalClient.RefreshRuntimeTokenInternal(ctx, req, opts...)
}

// DiagnoseRuntime creates a Diagnostic File and runs Diagnostic Tool given a Runtime.
func (c *ManagedNotebookClient) DiagnoseRuntime(ctx context.Context, req *notebookspb.DiagnoseRuntimeRequest, opts ...gax.CallOption) (*DiagnoseRuntimeOperation, error) {
	return c.internalClient.DiagnoseRuntime(ctx, req, opts...)
}

// DiagnoseRuntimeOperation returns a new DiagnoseRuntimeOperation from a given name.
// The name must be that of a previously created DiagnoseRuntimeOperation, possibly from a different process.
func (c *ManagedNotebookClient) DiagnoseRuntimeOperation(name string) *DiagnoseRuntimeOperation {
	return c.internalClient.DiagnoseRuntimeOperation(name)
}

// GetLocation gets information about a location.
func (c *ManagedNotebookClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *ManagedNotebookClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// GetIamPolicy gets the access control policy for a resource. Returns an empty policy
// if the resource exists and does not have a policy set.
func (c *ManagedNotebookClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.GetIamPolicy(ctx, req, opts...)
}

// SetIamPolicy sets the access control policy on the specified resource. Replaces
// any existing policy.
//
// Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED
// errors.
func (c *ManagedNotebookClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	return c.internalClient.SetIamPolicy(ctx, req, opts...)
}

// TestIamPermissions returns permissions that a caller has on the specified resource. If the
// resource does not exist, this will return an empty set of
// permissions, not a NOT_FOUND error.
//
// Note: This operation is designed to be used for building
// permission-aware UIs and command-line tools, not for authorization
// checking. This operation may “fail open” without warning.
func (c *ManagedNotebookClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	return c.internalClient.TestIamPermissions(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *ManagedNotebookClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *ManagedNotebookClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *ManagedNotebookClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *ManagedNotebookClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// managedNotebookGRPCClient is a client for interacting with Notebooks API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type managedNotebookGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing ManagedNotebookClient
	CallOptions **ManagedNotebookCallOptions

	// The gRPC API client.
	managedNotebookClient notebookspb.ManagedNotebookServiceClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	iamPolicyClient iampb.IAMPolicyClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewManagedNotebookClient creates a new managed notebook service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// API v1 service for Managed Notebooks.
func NewManagedNotebookClient(ctx context.Context, opts ...option.ClientOption) (*ManagedNotebookClient, error) {
	clientOpts := defaultManagedNotebookGRPCClientOptions()
	if newManagedNotebookClientHook != nil {
		hookOpts, err := newManagedNotebookClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := ManagedNotebookClient{CallOptions: defaultManagedNotebookCallOptions()}

	c := &managedNotebookGRPCClient{
		connPool:              connPool,
		managedNotebookClient: notebookspb.NewManagedNotebookServiceClient(connPool),
		CallOptions:           &client.CallOptions,
		logger:                internaloption.GetLogger(opts),
		operationsClient:      longrunningpb.NewOperationsClient(connPool),
		iamPolicyClient:       iampb.NewIAMPolicyClient(connPool),
		locationsClient:       locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *managedNotebookGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *managedNotebookGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version, "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *managedNotebookGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *managedNotebookGRPCClient) ListRuntimes(ctx context.Context, req *notebookspb.ListRuntimesRequest, opts ...gax.CallOption) *RuntimeIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListRuntimes[0:len((*c.CallOptions).ListRuntimes):len((*c.CallOptions).ListRuntimes)], opts...)
	it := &RuntimeIterator{}
	req = proto.Clone(req).(*notebookspb.ListRuntimesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*notebookspb.Runtime, string, error) {
		resp := &notebookspb.ListRuntimesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.managedNotebookClient.ListRuntimes, req, settings.GRPC, c.logger, "ListRuntimes")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetRuntimes(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *managedNotebookGRPCClient) GetRuntime(ctx context.Context, req *notebookspb.GetRuntimeRequest, opts ...gax.CallOption) (*notebookspb.Runtime, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetRuntime[0:len((*c.CallOptions).GetRuntime):len((*c.CallOptions).GetRuntime)], opts...)
	var resp *notebookspb.Runtime
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.managedNotebookClient.GetRuntime, req, settings.GRPC, c.logger, "GetRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *managedNotebookGRPCClient) CreateRuntime(ctx context.Context, req *notebookspb.CreateRuntimeRequest, opts ...gax.CallOption) (*CreateRuntimeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateRuntime[0:len((*c.CallOptions).CreateRuntime):len((*c.CallOptions).CreateRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.managedNotebookClient.CreateRuntime, req, settings.GRPC, c.logger, "CreateRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) UpdateRuntime(ctx context.Context, req *notebookspb.UpdateRuntimeRequest, opts ...gax.CallOption) (*UpdateRuntimeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "runtime.name", url.QueryEscape(req.GetRuntime().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateRuntime[0:len((*c.CallOptions).UpdateRuntime):len((*c.CallOptions).UpdateRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.managedNotebookClient.UpdateRuntime, req, settings.GRPC, c.logger, "UpdateRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpdateRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) DeleteRuntime(ctx context.Context, req *notebookspb.DeleteRuntimeRequest, opts ...gax.CallOption) (*DeleteRuntimeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteRuntime[0:len((*c.CallOptions).DeleteRuntime):len((*c.CallOptions).DeleteRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.managedNotebookClient.DeleteRuntime, req, settings.GRPC, c.logger, "DeleteRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) StartRuntime(ctx context.Context, req *notebookspb.StartRuntimeRequest, opts ...gax.CallOption) (*StartRuntimeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).StartRuntime[0:len((*c.CallOptions).StartRuntime):len((*c.CallOptions).StartRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.managedNotebookClient.StartRuntime, req, settings.GRPC, c.logger, "StartRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StartRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) StopRuntime(ctx context.Context, req *notebookspb.StopRuntimeRequest, opts ...gax.CallOption) (*StopRuntimeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).StopRuntime[0:len((*c.CallOptions).StopRuntime):len((*c.CallOptions).StopRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.managedNotebookClient.StopRuntime, req, settings.GRPC, c.logger, "StopRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &StopRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) SwitchRuntime(ctx context.Context, req *notebookspb.SwitchRuntimeRequest, opts ...gax.CallOption) (*SwitchRuntimeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SwitchRuntime[0:len((*c.CallOptions).SwitchRuntime):len((*c.CallOptions).SwitchRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.managedNotebookClient.SwitchRuntime, req, settings.GRPC, c.logger, "SwitchRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &SwitchRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) ResetRuntime(ctx context.Context, req *notebookspb.ResetRuntimeRequest, opts ...gax.CallOption) (*ResetRuntimeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ResetRuntime[0:len((*c.CallOptions).ResetRuntime):len((*c.CallOptions).ResetRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.managedNotebookClient.ResetRuntime, req, settings.GRPC, c.logger, "ResetRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ResetRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) UpgradeRuntime(ctx context.Context, req *notebookspb.UpgradeRuntimeRequest, opts ...gax.CallOption) (*UpgradeRuntimeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpgradeRuntime[0:len((*c.CallOptions).UpgradeRuntime):len((*c.CallOptions).UpgradeRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.managedNotebookClient.UpgradeRuntime, req, settings.GRPC, c.logger, "UpgradeRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &UpgradeRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) ReportRuntimeEvent(ctx context.Context, req *notebookspb.ReportRuntimeEventRequest, opts ...gax.CallOption) (*ReportRuntimeEventOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ReportRuntimeEvent[0:len((*c.CallOptions).ReportRuntimeEvent):len((*c.CallOptions).ReportRuntimeEvent)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.managedNotebookClient.ReportRuntimeEvent, req, settings.GRPC, c.logger, "ReportRuntimeEvent")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &ReportRuntimeEventOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) RefreshRuntimeTokenInternal(ctx context.Context, req *notebookspb.RefreshRuntimeTokenInternalRequest, opts ...gax.CallOption) (*notebookspb.RefreshRuntimeTokenInternalResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RefreshRuntimeTokenInternal[0:len((*c.CallOptions).RefreshRuntimeTokenInternal):len((*c.CallOptions).RefreshRuntimeTokenInternal)], opts...)
	var resp *notebookspb.RefreshRuntimeTokenInternalResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.managedNotebookClient.RefreshRuntimeTokenInternal, req, settings.GRPC, c.logger, "RefreshRuntimeTokenInternal")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *managedNotebookGRPCClient) DiagnoseRuntime(ctx context.Context, req *notebookspb.DiagnoseRuntimeRequest, opts ...gax.CallOption) (*DiagnoseRuntimeOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DiagnoseRuntime[0:len((*c.CallOptions).DiagnoseRuntime):len((*c.CallOptions).DiagnoseRuntime)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.managedNotebookClient.DiagnoseRuntime, req, settings.GRPC, c.logger, "DiagnoseRuntime")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DiagnoseRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *managedNotebookGRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.locationsClient.GetLocation, req, settings.GRPC, c.logger, "GetLocation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *managedNotebookGRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.locationsClient.ListLocations, req, settings.GRPC, c.logger, "ListLocations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *managedNotebookGRPCClient) GetIamPolicy(ctx context.Context, req *iampb.GetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetIamPolicy[0:len((*c.CallOptions).GetIamPolicy):len((*c.CallOptions).GetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.GetIamPolicy, req, settings.GRPC, c.logger, "GetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *managedNotebookGRPCClient) SetIamPolicy(ctx context.Context, req *iampb.SetIamPolicyRequest, opts ...gax.CallOption) (*iampb.Policy, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SetIamPolicy[0:len((*c.CallOptions).SetIamPolicy):len((*c.CallOptions).SetIamPolicy)], opts...)
	var resp *iampb.Policy
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.SetIamPolicy, req, settings.GRPC, c.logger, "SetIamPolicy")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *managedNotebookGRPCClient) TestIamPermissions(ctx context.Context, req *iampb.TestIamPermissionsRequest, opts ...gax.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "resource", url.QueryEscape(req.GetResource()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).TestIamPermissions[0:len((*c.CallOptions).TestIamPermissions):len((*c.CallOptions).TestIamPermissions)], opts...)
	var resp *iampb.TestIamPermissionsResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.iamPolicyClient.TestIamPermissions, req, settings.GRPC, c.logger, "TestIamPermissions")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *managedNotebookGRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *managedNotebookGRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *managedNotebookGRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *managedNotebookGRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateRuntimeOperation returns a new CreateRuntimeOperation from a given name.
// The name must be that of a previously created CreateRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) CreateRuntimeOperation(name string) *CreateRuntimeOperation {
	return &CreateRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteRuntimeOperation returns a new DeleteRuntimeOperation from a given name.
// The name must be that of a previously created DeleteRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) DeleteRuntimeOperation(name string) *DeleteRuntimeOperation {
	return &DeleteRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DiagnoseRuntimeOperation returns a new DiagnoseRuntimeOperation from a given name.
// The name must be that of a previously created DiagnoseRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) DiagnoseRuntimeOperation(name string) *DiagnoseRuntimeOperation {
	return &DiagnoseRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ReportRuntimeEventOperation returns a new ReportRuntimeEventOperation from a given name.
// The name must be that of a previously created ReportRuntimeEventOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) ReportRuntimeEventOperation(name string) *ReportRuntimeEventOperation {
	return &ReportRuntimeEventOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// ResetRuntimeOperation returns a new ResetRuntimeOperation from a given name.
// The name must be that of a previously created ResetRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) ResetRuntimeOperation(name string) *ResetRuntimeOperation {
	return &ResetRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// StartRuntimeOperation returns a new StartRuntimeOperation from a given name.
// The name must be that of a previously created StartRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) StartRuntimeOperation(name string) *StartRuntimeOperation {
	return &StartRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// StopRuntimeOperation returns a new StopRuntimeOperation from a given name.
// The name must be that of a previously created StopRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) StopRuntimeOperation(name string) *StopRuntimeOperation {
	return &StopRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// SwitchRuntimeOperation returns a new SwitchRuntimeOperation from a given name.
// The name must be that of a previously created SwitchRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) SwitchRuntimeOperation(name string) *SwitchRuntimeOperation {
	return &SwitchRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpdateRuntimeOperation returns a new UpdateRuntimeOperation from a given name.
// The name must be that of a previously created UpdateRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) UpdateRuntimeOperation(name string) *UpdateRuntimeOperation {
	return &UpdateRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// UpgradeRuntimeOperation returns a new UpgradeRuntimeOperation from a given name.
// The name must be that of a previously created UpgradeRuntimeOperation, possibly from a different process.
func (c *managedNotebookGRPCClient) UpgradeRuntimeOperation(name string) *UpgradeRuntimeOperation {
	return &UpgradeRuntimeOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}
