// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/devtools/clouderrorreporting/v1beta1/error_stats_service.proto

package errorreportingpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ErrorStatsService_ListGroupStats_FullMethodName = "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/ListGroupStats"
	ErrorStatsService_ListEvents_FullMethodName     = "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/ListEvents"
	ErrorStatsService_DeleteEvents_FullMethodName   = "/google.devtools.clouderrorreporting.v1beta1.ErrorStatsService/DeleteEvents"
)

// ErrorStatsServiceClient is the client API for ErrorStatsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ErrorStatsServiceClient interface {
	// Lists the specified groups.
	ListGroupStats(ctx context.Context, in *ListGroupStatsRequest, opts ...grpc.CallOption) (*ListGroupStatsResponse, error)
	// Lists the specified events.
	ListEvents(ctx context.Context, in *ListEventsRequest, opts ...grpc.CallOption) (*ListEventsResponse, error)
	// Deletes all error events of a given project.
	DeleteEvents(ctx context.Context, in *DeleteEventsRequest, opts ...grpc.CallOption) (*DeleteEventsResponse, error)
}

type errorStatsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewErrorStatsServiceClient(cc grpc.ClientConnInterface) ErrorStatsServiceClient {
	return &errorStatsServiceClient{cc}
}

func (c *errorStatsServiceClient) ListGroupStats(ctx context.Context, in *ListGroupStatsRequest, opts ...grpc.CallOption) (*ListGroupStatsResponse, error) {
	out := new(ListGroupStatsResponse)
	err := c.cc.Invoke(ctx, ErrorStatsService_ListGroupStats_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *errorStatsServiceClient) ListEvents(ctx context.Context, in *ListEventsRequest, opts ...grpc.CallOption) (*ListEventsResponse, error) {
	out := new(ListEventsResponse)
	err := c.cc.Invoke(ctx, ErrorStatsService_ListEvents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *errorStatsServiceClient) DeleteEvents(ctx context.Context, in *DeleteEventsRequest, opts ...grpc.CallOption) (*DeleteEventsResponse, error) {
	out := new(DeleteEventsResponse)
	err := c.cc.Invoke(ctx, ErrorStatsService_DeleteEvents_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ErrorStatsServiceServer is the server API for ErrorStatsService service.
// All implementations should embed UnimplementedErrorStatsServiceServer
// for forward compatibility
type ErrorStatsServiceServer interface {
	// Lists the specified groups.
	ListGroupStats(context.Context, *ListGroupStatsRequest) (*ListGroupStatsResponse, error)
	// Lists the specified events.
	ListEvents(context.Context, *ListEventsRequest) (*ListEventsResponse, error)
	// Deletes all error events of a given project.
	DeleteEvents(context.Context, *DeleteEventsRequest) (*DeleteEventsResponse, error)
}

// UnimplementedErrorStatsServiceServer should be embedded to have forward compatible implementations.
type UnimplementedErrorStatsServiceServer struct {
}

func (UnimplementedErrorStatsServiceServer) ListGroupStats(context.Context, *ListGroupStatsRequest) (*ListGroupStatsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGroupStats not implemented")
}
func (UnimplementedErrorStatsServiceServer) ListEvents(context.Context, *ListEventsRequest) (*ListEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEvents not implemented")
}
func (UnimplementedErrorStatsServiceServer) DeleteEvents(context.Context, *DeleteEventsRequest) (*DeleteEventsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEvents not implemented")
}

// UnsafeErrorStatsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ErrorStatsServiceServer will
// result in compilation errors.
type UnsafeErrorStatsServiceServer interface {
	mustEmbedUnimplementedErrorStatsServiceServer()
}

func RegisterErrorStatsServiceServer(s grpc.ServiceRegistrar, srv ErrorStatsServiceServer) {
	s.RegisterService(&ErrorStatsService_ServiceDesc, srv)
}

func _ErrorStatsService_ListGroupStats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGroupStatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ErrorStatsServiceServer).ListGroupStats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ErrorStatsService_ListGroupStats_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ErrorStatsServiceServer).ListGroupStats(ctx, req.(*ListGroupStatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ErrorStatsService_ListEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ErrorStatsServiceServer).ListEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ErrorStatsService_ListEvents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ErrorStatsServiceServer).ListEvents(ctx, req.(*ListEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ErrorStatsService_DeleteEvents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEventsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ErrorStatsServiceServer).DeleteEvents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ErrorStatsService_DeleteEvents_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ErrorStatsServiceServer).DeleteEvents(ctx, req.(*DeleteEventsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ErrorStatsService_ServiceDesc is the grpc.ServiceDesc for ErrorStatsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ErrorStatsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.clouderrorreporting.v1beta1.ErrorStatsService",
	HandlerType: (*ErrorStatsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListGroupStats",
			Handler:    _ErrorStatsService_ListGroupStats_Handler,
		},
		{
			MethodName: "ListEvents",
			Handler:    _ErrorStatsService_ListEvents_Handler,
		},
		{
			MethodName: "DeleteEvents",
			Handler:    _ErrorStatsService_DeleteEvents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/clouderrorreporting/v1beta1/error_stats_service.proto",
}
