// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/datacatalog/v1beta1/tags.proto

package datacatalogpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This enum describes TagTemplate transfer status to Dataplex service.
type TagTemplate_DataplexTransferStatus int32

const (
	// Default value. TagTemplate and its tags are only visible and editable in
	// DataCatalog.
	TagTemplate_DATAPLEX_TRANSFER_STATUS_UNSPECIFIED TagTemplate_DataplexTransferStatus = 0
	// TagTemplate and its tags are auto-copied to Dataplex service.
	// Visible in both services. Editable in DataCatalog, read-only in Dataplex.
	// Deprecated: Individual TagTemplate migration is deprecated in favor of
	// organization or project wide TagTemplate migration opt-in.
	//
	// Deprecated: Marked as deprecated in google/cloud/datacatalog/v1beta1/tags.proto.
	TagTemplate_MIGRATED TagTemplate_DataplexTransferStatus = 1
)

// Enum value maps for TagTemplate_DataplexTransferStatus.
var (
	TagTemplate_DataplexTransferStatus_name = map[int32]string{
		0: "DATAPLEX_TRANSFER_STATUS_UNSPECIFIED",
		1: "MIGRATED",
	}
	TagTemplate_DataplexTransferStatus_value = map[string]int32{
		"DATAPLEX_TRANSFER_STATUS_UNSPECIFIED": 0,
		"MIGRATED":                             1,
	}
)

func (x TagTemplate_DataplexTransferStatus) Enum() *TagTemplate_DataplexTransferStatus {
	p := new(TagTemplate_DataplexTransferStatus)
	*p = x
	return p
}

func (x TagTemplate_DataplexTransferStatus) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TagTemplate_DataplexTransferStatus) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datacatalog_v1beta1_tags_proto_enumTypes[0].Descriptor()
}

func (TagTemplate_DataplexTransferStatus) Type() protoreflect.EnumType {
	return &file_google_cloud_datacatalog_v1beta1_tags_proto_enumTypes[0]
}

func (x TagTemplate_DataplexTransferStatus) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TagTemplate_DataplexTransferStatus.Descriptor instead.
func (TagTemplate_DataplexTransferStatus) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescGZIP(), []int{2, 0}
}

type FieldType_PrimitiveType int32

const (
	// This is the default invalid value for a type.
	FieldType_PRIMITIVE_TYPE_UNSPECIFIED FieldType_PrimitiveType = 0
	// A double precision number.
	FieldType_DOUBLE FieldType_PrimitiveType = 1
	// An UTF-8 string.
	FieldType_STRING FieldType_PrimitiveType = 2
	// A boolean value.
	FieldType_BOOL FieldType_PrimitiveType = 3
	// A timestamp.
	FieldType_TIMESTAMP FieldType_PrimitiveType = 4
)

// Enum value maps for FieldType_PrimitiveType.
var (
	FieldType_PrimitiveType_name = map[int32]string{
		0: "PRIMITIVE_TYPE_UNSPECIFIED",
		1: "DOUBLE",
		2: "STRING",
		3: "BOOL",
		4: "TIMESTAMP",
	}
	FieldType_PrimitiveType_value = map[string]int32{
		"PRIMITIVE_TYPE_UNSPECIFIED": 0,
		"DOUBLE":                     1,
		"STRING":                     2,
		"BOOL":                       3,
		"TIMESTAMP":                  4,
	}
)

func (x FieldType_PrimitiveType) Enum() *FieldType_PrimitiveType {
	p := new(FieldType_PrimitiveType)
	*p = x
	return p
}

func (x FieldType_PrimitiveType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (FieldType_PrimitiveType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_datacatalog_v1beta1_tags_proto_enumTypes[1].Descriptor()
}

func (FieldType_PrimitiveType) Type() protoreflect.EnumType {
	return &file_google_cloud_datacatalog_v1beta1_tags_proto_enumTypes[1]
}

func (x FieldType_PrimitiveType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use FieldType_PrimitiveType.Descriptor instead.
func (FieldType_PrimitiveType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescGZIP(), []int{4, 0}
}

// Tags are used to attach custom metadata to Data Catalog resources. Tags
// conform to the specifications within their tag template.
//
// See [Data Catalog
// IAM](https://cloud.google.com/data-catalog/docs/concepts/iam) for information
// on the permissions needed to create or view tags.
type Tag struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the tag in URL format. Example:
	//
	// * projects/{project_id}/locations/{location}/entrygroups/{entry_group_id}/entries/{entry_id}/tags/{tag_id}
	//
	// where `tag_id` is a system-generated identifier.
	// Note that this Tag may not actually be stored in the location in this name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The resource name of the tag template that this tag uses.
	// Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
	//
	// This field cannot be modified after creation.
	Template string `protobuf:"bytes,2,opt,name=template,proto3" json:"template,omitempty"`
	// Output only. The display name of the tag template.
	TemplateDisplayName string `protobuf:"bytes,5,opt,name=template_display_name,json=templateDisplayName,proto3" json:"template_display_name,omitempty"`
	// The scope within the parent resource that this tag is attached to. If not
	// provided, the tag is attached to the parent resource itself.
	// Deleting the scope from the parent resource will delete all tags attached
	// to that scope. These fields cannot be updated after creation.
	//
	// Types that are assignable to Scope:
	//
	//	*Tag_Column
	Scope isTag_Scope `protobuf_oneof:"scope"`
	// Required. This maps the ID of a tag field to the value of and additional
	// information about that field. Valid field IDs are defined by the tag's
	// template. A tag must have at least 1 field and at most 500 fields.
	Fields map[string]*TagField `protobuf:"bytes,3,rep,name=fields,proto3" json:"fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Tag) Reset() {
	*x = Tag{}
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Tag) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Tag) ProtoMessage() {}

func (x *Tag) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Tag.ProtoReflect.Descriptor instead.
func (*Tag) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescGZIP(), []int{0}
}

func (x *Tag) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Tag) GetTemplate() string {
	if x != nil {
		return x.Template
	}
	return ""
}

func (x *Tag) GetTemplateDisplayName() string {
	if x != nil {
		return x.TemplateDisplayName
	}
	return ""
}

func (m *Tag) GetScope() isTag_Scope {
	if m != nil {
		return m.Scope
	}
	return nil
}

func (x *Tag) GetColumn() string {
	if x, ok := x.GetScope().(*Tag_Column); ok {
		return x.Column
	}
	return ""
}

func (x *Tag) GetFields() map[string]*TagField {
	if x != nil {
		return x.Fields
	}
	return nil
}

type isTag_Scope interface {
	isTag_Scope()
}

type Tag_Column struct {
	// Resources like Entry can have schemas associated with them. This scope
	// allows users to attach tags to an individual column based on that schema.
	//
	// For attaching a tag to a nested column, use `.` to separate the column
	// names. Example:
	//
	// * `outer_column.inner_column`
	Column string `protobuf:"bytes,4,opt,name=column,proto3,oneof"`
}

func (*Tag_Column) isTag_Scope() {}

// Contains the value and supporting information for a field within
// a [Tag][google.cloud.datacatalog.v1beta1.Tag].
type TagField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The display name of this field.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The value of this field.
	//
	// Types that are assignable to Kind:
	//
	//	*TagField_DoubleValue
	//	*TagField_StringValue
	//	*TagField_BoolValue
	//	*TagField_TimestampValue
	//	*TagField_EnumValue_
	Kind isTagField_Kind `protobuf_oneof:"kind"`
	// Output only. The order of this field with respect to other fields in this
	// tag. It can be set in
	// [Tag][google.cloud.datacatalog.v1beta1.TagTemplateField.order]. For
	// example, a higher value can indicate a more important field. The value can
	// be negative. Multiple fields can have the same order, and field orders
	// within a tag do not have to be sequential.
	Order int32 `protobuf:"varint,7,opt,name=order,proto3" json:"order,omitempty"`
}

func (x *TagField) Reset() {
	*x = TagField{}
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TagField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TagField) ProtoMessage() {}

func (x *TagField) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TagField.ProtoReflect.Descriptor instead.
func (*TagField) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescGZIP(), []int{1}
}

func (x *TagField) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (m *TagField) GetKind() isTagField_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *TagField) GetDoubleValue() float64 {
	if x, ok := x.GetKind().(*TagField_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (x *TagField) GetStringValue() string {
	if x, ok := x.GetKind().(*TagField_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (x *TagField) GetBoolValue() bool {
	if x, ok := x.GetKind().(*TagField_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (x *TagField) GetTimestampValue() *timestamppb.Timestamp {
	if x, ok := x.GetKind().(*TagField_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

func (x *TagField) GetEnumValue() *TagField_EnumValue {
	if x, ok := x.GetKind().(*TagField_EnumValue_); ok {
		return x.EnumValue
	}
	return nil
}

func (x *TagField) GetOrder() int32 {
	if x != nil {
		return x.Order
	}
	return 0
}

type isTagField_Kind interface {
	isTagField_Kind()
}

type TagField_DoubleValue struct {
	// Holds the value for a tag field with double type.
	DoubleValue float64 `protobuf:"fixed64,2,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type TagField_StringValue struct {
	// Holds the value for a tag field with string type.
	StringValue string `protobuf:"bytes,3,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type TagField_BoolValue struct {
	// Holds the value for a tag field with boolean type.
	BoolValue bool `protobuf:"varint,4,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type TagField_TimestampValue struct {
	// Holds the value for a tag field with timestamp type.
	TimestampValue *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=timestamp_value,json=timestampValue,proto3,oneof"`
}

type TagField_EnumValue_ struct {
	// Holds the value for a tag field with enum type. This value must be
	// one of the allowed values in the definition of this enum.
	EnumValue *TagField_EnumValue `protobuf:"bytes,6,opt,name=enum_value,json=enumValue,proto3,oneof"`
}

func (*TagField_DoubleValue) isTagField_Kind() {}

func (*TagField_StringValue) isTagField_Kind() {}

func (*TagField_BoolValue) isTagField_Kind() {}

func (*TagField_TimestampValue) isTagField_Kind() {}

func (*TagField_EnumValue_) isTagField_Kind() {}

// A tag template defines a tag, which can have one or more typed fields.
// The template is used to create and attach the tag to Google Cloud resources.
// [Tag template
// roles](https://cloud.google.com/iam/docs/understanding-roles#data-catalog-roles)
// provide permissions to create, edit, and use the template. See, for example,
// the [TagTemplate
// User](https://cloud.google.com/data-catalog/docs/how-to/template-user) role,
// which includes permission to use the tag template to tag resources.
type TagTemplate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the tag template in URL format. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template_id}
	//
	// Note that this TagTemplate and its child resources may not actually be
	// stored in the location in this name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The display name for this template. Defaults to an empty string.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Map of tag template field IDs to the settings for the field.
	// This map is an exhaustive list of the allowed fields. This map must contain
	// at least one field and at most 500 fields.
	//
	// The keys to this map are tag template field IDs. Field IDs can contain
	// letters (both uppercase and lowercase), numbers (0-9) and underscores (_).
	// Field IDs must be at least 1 character long and at most
	// 64 characters long. Field IDs must start with a letter or underscore.
	Fields map[string]*TagTemplateField `protobuf:"bytes,3,rep,name=fields,proto3" json:"fields,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. Transfer status of the TagTemplate
	DataplexTransferStatus TagTemplate_DataplexTransferStatus `protobuf:"varint,7,opt,name=dataplex_transfer_status,json=dataplexTransferStatus,proto3,enum=google.cloud.datacatalog.v1beta1.TagTemplate_DataplexTransferStatus" json:"dataplex_transfer_status,omitempty"`
}

func (x *TagTemplate) Reset() {
	*x = TagTemplate{}
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TagTemplate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TagTemplate) ProtoMessage() {}

func (x *TagTemplate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TagTemplate.ProtoReflect.Descriptor instead.
func (*TagTemplate) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescGZIP(), []int{2}
}

func (x *TagTemplate) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TagTemplate) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *TagTemplate) GetFields() map[string]*TagTemplateField {
	if x != nil {
		return x.Fields
	}
	return nil
}

func (x *TagTemplate) GetDataplexTransferStatus() TagTemplate_DataplexTransferStatus {
	if x != nil {
		return x.DataplexTransferStatus
	}
	return TagTemplate_DATAPLEX_TRANSFER_STATUS_UNSPECIFIED
}

// The template for an individual field within a tag template.
type TagTemplateField struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Identifier. The resource name of the tag template field in URL
	// format. Example:
	//
	// * projects/{project_id}/locations/{location}/tagTemplates/{tag_template}/fields/{field}
	//
	// Note that this TagTemplateField may not actually be stored in the location
	// in this name.
	Name string `protobuf:"bytes,6,opt,name=name,proto3" json:"name,omitempty"`
	// The display name for this field. Defaults to an empty string.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The type of value this tag field can contain.
	Type *FieldType `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Whether this is a required field. Defaults to false.
	IsRequired bool `protobuf:"varint,3,opt,name=is_required,json=isRequired,proto3" json:"is_required,omitempty"`
	// The description for this field. Defaults to an empty string.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// The order of this field with respect to other fields in this tag
	// template.  A higher value indicates a more important field. The value can
	// be negative. Multiple fields can have the same order, and field orders
	// within a tag do not have to be sequential.
	Order int32 `protobuf:"varint,5,opt,name=order,proto3" json:"order,omitempty"`
}

func (x *TagTemplateField) Reset() {
	*x = TagTemplateField{}
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TagTemplateField) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TagTemplateField) ProtoMessage() {}

func (x *TagTemplateField) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TagTemplateField.ProtoReflect.Descriptor instead.
func (*TagTemplateField) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescGZIP(), []int{3}
}

func (x *TagTemplateField) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TagTemplateField) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *TagTemplateField) GetType() *FieldType {
	if x != nil {
		return x.Type
	}
	return nil
}

func (x *TagTemplateField) GetIsRequired() bool {
	if x != nil {
		return x.IsRequired
	}
	return false
}

func (x *TagTemplateField) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TagTemplateField) GetOrder() int32 {
	if x != nil {
		return x.Order
	}
	return 0
}

type FieldType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required.
	//
	// Types that are assignable to TypeDecl:
	//
	//	*FieldType_PrimitiveType_
	//	*FieldType_EnumType_
	TypeDecl isFieldType_TypeDecl `protobuf_oneof:"type_decl"`
}

func (x *FieldType) Reset() {
	*x = FieldType{}
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FieldType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldType) ProtoMessage() {}

func (x *FieldType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldType.ProtoReflect.Descriptor instead.
func (*FieldType) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescGZIP(), []int{4}
}

func (m *FieldType) GetTypeDecl() isFieldType_TypeDecl {
	if m != nil {
		return m.TypeDecl
	}
	return nil
}

func (x *FieldType) GetPrimitiveType() FieldType_PrimitiveType {
	if x, ok := x.GetTypeDecl().(*FieldType_PrimitiveType_); ok {
		return x.PrimitiveType
	}
	return FieldType_PRIMITIVE_TYPE_UNSPECIFIED
}

func (x *FieldType) GetEnumType() *FieldType_EnumType {
	if x, ok := x.GetTypeDecl().(*FieldType_EnumType_); ok {
		return x.EnumType
	}
	return nil
}

type isFieldType_TypeDecl interface {
	isFieldType_TypeDecl()
}

type FieldType_PrimitiveType_ struct {
	// Represents primitive types - string, bool etc.
	PrimitiveType FieldType_PrimitiveType `protobuf:"varint,1,opt,name=primitive_type,json=primitiveType,proto3,enum=google.cloud.datacatalog.v1beta1.FieldType_PrimitiveType,oneof"`
}

type FieldType_EnumType_ struct {
	// Represents an enum type.
	EnumType *FieldType_EnumType `protobuf:"bytes,2,opt,name=enum_type,json=enumType,proto3,oneof"`
}

func (*FieldType_PrimitiveType_) isFieldType_TypeDecl() {}

func (*FieldType_EnumType_) isFieldType_TypeDecl() {}

// Holds an enum value.
type TagField_EnumValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The display name of the enum value.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *TagField_EnumValue) Reset() {
	*x = TagField_EnumValue{}
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TagField_EnumValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TagField_EnumValue) ProtoMessage() {}

func (x *TagField_EnumValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TagField_EnumValue.ProtoReflect.Descriptor instead.
func (*TagField_EnumValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescGZIP(), []int{1, 0}
}

func (x *TagField_EnumValue) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

type FieldType_EnumType struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	AllowedValues []*FieldType_EnumType_EnumValue `protobuf:"bytes,1,rep,name=allowed_values,json=allowedValues,proto3" json:"allowed_values,omitempty"`
}

func (x *FieldType_EnumType) Reset() {
	*x = FieldType_EnumType{}
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FieldType_EnumType) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldType_EnumType) ProtoMessage() {}

func (x *FieldType_EnumType) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldType_EnumType.ProtoReflect.Descriptor instead.
func (*FieldType_EnumType) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescGZIP(), []int{4, 0}
}

func (x *FieldType_EnumType) GetAllowedValues() []*FieldType_EnumType_EnumValue {
	if x != nil {
		return x.AllowedValues
	}
	return nil
}

type FieldType_EnumType_EnumValue struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The display name of the enum value. Must not be an empty
	// string.
	DisplayName string `protobuf:"bytes,1,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
}

func (x *FieldType_EnumType_EnumValue) Reset() {
	*x = FieldType_EnumType_EnumValue{}
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FieldType_EnumType_EnumValue) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FieldType_EnumType_EnumValue) ProtoMessage() {}

func (x *FieldType_EnumType_EnumValue) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FieldType_EnumType_EnumValue.ProtoReflect.Descriptor instead.
func (*FieldType_EnumType_EnumValue) Descriptor() ([]byte, []int) {
	return file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescGZIP(), []int{4, 0, 0}
}

func (x *FieldType_EnumType_EnumValue) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

var File_google_cloud_datacatalog_v1beta1_tags_proto protoreflect.FileDescriptor

var file_google_cloud_datacatalog_v1beta1_tags_proto_rawDesc = []byte{
	0x0a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x74, 0x61, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd6, 0x03, 0x0a,
	0x03, 0x54, 0x61, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a,
	0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x37,
	0x0a, 0x15, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c,
	0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x13, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x44, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x63, 0x6f, 0x6c, 0x75, 0x6d,
	0x6e, 0x12, 0x4e, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64,
	0x73, 0x1a, 0x65, 0x0a, 0x0b, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x40, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x52, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x81, 0x01, 0xea, 0x41, 0x7e, 0x0a, 0x1e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x12, 0x5c,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x72, 0x79,
	0x7d, 0x2f, 0x74, 0x61, 0x67, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x67, 0x7d, 0x42, 0x07, 0x0a, 0x05,
	0x73, 0x63, 0x6f, 0x70, 0x65, 0x22, 0x8e, 0x03, 0x0a, 0x08, 0x54, 0x61, 0x67, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x64, 0x6f,
	0x75, 0x62, 0x6c, 0x65, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x00, 0x52, 0x0b, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x23, 0x0a, 0x0c, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x0a, 0x62, 0x6f, 0x6f, 0x6c, 0x5f, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x6c,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x48, 0x00, 0x52, 0x0e, 0x74, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x55, 0x0a, 0x0a,
	0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x2e, 0x45, 0x6e, 0x75,
	0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x48, 0x00, 0x52, 0x09, 0x65, 0x6e, 0x75, 0x6d, 0x56, 0x61,
	0x6c, 0x75, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x1a, 0x2e,
	0x0a, 0x09, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64,
	0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x42, 0x06,
	0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x22, 0xde, 0x04, 0x0a, 0x0b, 0x54, 0x61, 0x67, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x12, 0x56, 0x0a, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x12, 0x83, 0x01, 0x0a, 0x18, 0x64,
	0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72,
	0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x61, 0x74,
	0x61, 0x70, 0x6c, 0x65, 0x78, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x16, 0x64, 0x61, 0x74, 0x61, 0x70, 0x6c,
	0x65, 0x78, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x1a, 0x6d, 0x0a, 0x0b, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x48, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x54, 0x0a, 0x16, 0x44, 0x61, 0x74, 0x61, 0x70, 0x6c, 0x65, 0x78, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x66, 0x65, 0x72, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x28, 0x0a, 0x24, 0x44, 0x41, 0x54,
	0x41, 0x50, 0x4c, 0x45, 0x58, 0x5f, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x46, 0x45, 0x52, 0x5f, 0x53,
	0x54, 0x41, 0x54, 0x55, 0x53, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x08, 0x4d, 0x49, 0x47, 0x52, 0x41, 0x54, 0x45, 0x44, 0x10,
	0x01, 0x1a, 0x02, 0x08, 0x01, 0x3a, 0x70, 0xea, 0x41, 0x6d, 0x0a, 0x26, 0x64, 0x61, 0x74, 0x61,
	0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x12, 0x43, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x61, 0x67, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x7d, 0x22, 0xf8, 0x02, 0x0a, 0x10, 0x54, 0x61, 0x67, 0x54,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x1a, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x06, 0xe0, 0x41, 0x08, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70,
	0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x44, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x74, 0x79, 0x70,
	0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x73, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0a, 0x69, 0x73, 0x52, 0x65, 0x71, 0x75, 0x69, 0x72,
	0x65, 0x64, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x05, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x3a, 0x85, 0x01, 0xea, 0x41, 0x81,
	0x01, 0x0a, 0x2b, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x61,
	0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x12, 0x52,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x61, 0x67, 0x54, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x61, 0x67, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61,
	0x74, 0x65, 0x7d, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x2f, 0x7b, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x7d, 0x22, 0xdc, 0x03, 0x0a, 0x09, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x62, 0x0a, 0x0e, 0x70, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61,
	0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x48, 0x00, 0x52, 0x0d, 0x70, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x53, 0x0a, 0x09, 0x65, 0x6e, 0x75, 0x6d, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64,
	0x54, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x48, 0x00, 0x52,
	0x08, 0x65, 0x6e, 0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xa6, 0x01, 0x0a, 0x08, 0x45, 0x6e,
	0x75, 0x6d, 0x54, 0x79, 0x70, 0x65, 0x12, 0x65, 0x0a, 0x0e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
	0x64, 0x5f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x6e, 0x75, 0x6d,
	0x54, 0x79, 0x70, 0x65, 0x2e, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0d,
	0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x1a, 0x33, 0x0a,
	0x09, 0x45, 0x6e, 0x75, 0x6d, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61,
	0x6d, 0x65, 0x22, 0x60, 0x0a, 0x0d, 0x50, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x52, 0x49, 0x4d, 0x49, 0x54, 0x49, 0x56, 0x45,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x44, 0x4f, 0x55, 0x42, 0x4c, 0x45, 0x10, 0x01, 0x12,
	0x0a, 0x0a, 0x06, 0x53, 0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x42,
	0x4f, 0x4f, 0x4c, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x54, 0x49, 0x4d, 0x45, 0x53, 0x54, 0x41,
	0x4d, 0x50, 0x10, 0x04, 0x42, 0x0b, 0x0a, 0x09, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x64, 0x65, 0x63,
	0x6c, 0x42, 0xdc, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x50, 0x01, 0x5a, 0x46, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67,
	0x6f, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2f, 0x61, 0x70,
	0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74,
	0x61, 0x6c, 0x6f, 0x67, 0x70, 0x62, 0x3b, 0x64, 0x61, 0x74, 0x61, 0x63, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x70, 0x62, 0xaa, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x2e,
	0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x20, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x61, 0x74, 0x61, 0x43, 0x61, 0x74, 0x61, 0x6c,
	0x6f, 0x67, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x23, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x61, 0x74, 0x61,
	0x43, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescOnce sync.Once
	file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescData = file_google_cloud_datacatalog_v1beta1_tags_proto_rawDesc
)

func file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescGZIP() []byte {
	file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescOnce.Do(func() {
		file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescData)
	})
	return file_google_cloud_datacatalog_v1beta1_tags_proto_rawDescData
}

var file_google_cloud_datacatalog_v1beta1_tags_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_datacatalog_v1beta1_tags_proto_goTypes = []any{
	(TagTemplate_DataplexTransferStatus)(0), // 0: google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus
	(FieldType_PrimitiveType)(0),            // 1: google.cloud.datacatalog.v1beta1.FieldType.PrimitiveType
	(*Tag)(nil),                             // 2: google.cloud.datacatalog.v1beta1.Tag
	(*TagField)(nil),                        // 3: google.cloud.datacatalog.v1beta1.TagField
	(*TagTemplate)(nil),                     // 4: google.cloud.datacatalog.v1beta1.TagTemplate
	(*TagTemplateField)(nil),                // 5: google.cloud.datacatalog.v1beta1.TagTemplateField
	(*FieldType)(nil),                       // 6: google.cloud.datacatalog.v1beta1.FieldType
	nil,                                     // 7: google.cloud.datacatalog.v1beta1.Tag.FieldsEntry
	(*TagField_EnumValue)(nil),              // 8: google.cloud.datacatalog.v1beta1.TagField.EnumValue
	nil,                                     // 9: google.cloud.datacatalog.v1beta1.TagTemplate.FieldsEntry
	(*FieldType_EnumType)(nil),              // 10: google.cloud.datacatalog.v1beta1.FieldType.EnumType
	(*FieldType_EnumType_EnumValue)(nil),    // 11: google.cloud.datacatalog.v1beta1.FieldType.EnumType.EnumValue
	(*timestamppb.Timestamp)(nil),           // 12: google.protobuf.Timestamp
}
var file_google_cloud_datacatalog_v1beta1_tags_proto_depIdxs = []int32{
	7,  // 0: google.cloud.datacatalog.v1beta1.Tag.fields:type_name -> google.cloud.datacatalog.v1beta1.Tag.FieldsEntry
	12, // 1: google.cloud.datacatalog.v1beta1.TagField.timestamp_value:type_name -> google.protobuf.Timestamp
	8,  // 2: google.cloud.datacatalog.v1beta1.TagField.enum_value:type_name -> google.cloud.datacatalog.v1beta1.TagField.EnumValue
	9,  // 3: google.cloud.datacatalog.v1beta1.TagTemplate.fields:type_name -> google.cloud.datacatalog.v1beta1.TagTemplate.FieldsEntry
	0,  // 4: google.cloud.datacatalog.v1beta1.TagTemplate.dataplex_transfer_status:type_name -> google.cloud.datacatalog.v1beta1.TagTemplate.DataplexTransferStatus
	6,  // 5: google.cloud.datacatalog.v1beta1.TagTemplateField.type:type_name -> google.cloud.datacatalog.v1beta1.FieldType
	1,  // 6: google.cloud.datacatalog.v1beta1.FieldType.primitive_type:type_name -> google.cloud.datacatalog.v1beta1.FieldType.PrimitiveType
	10, // 7: google.cloud.datacatalog.v1beta1.FieldType.enum_type:type_name -> google.cloud.datacatalog.v1beta1.FieldType.EnumType
	3,  // 8: google.cloud.datacatalog.v1beta1.Tag.FieldsEntry.value:type_name -> google.cloud.datacatalog.v1beta1.TagField
	5,  // 9: google.cloud.datacatalog.v1beta1.TagTemplate.FieldsEntry.value:type_name -> google.cloud.datacatalog.v1beta1.TagTemplateField
	11, // 10: google.cloud.datacatalog.v1beta1.FieldType.EnumType.allowed_values:type_name -> google.cloud.datacatalog.v1beta1.FieldType.EnumType.EnumValue
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_datacatalog_v1beta1_tags_proto_init() }
func file_google_cloud_datacatalog_v1beta1_tags_proto_init() {
	if File_google_cloud_datacatalog_v1beta1_tags_proto != nil {
		return
	}
	file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[0].OneofWrappers = []any{
		(*Tag_Column)(nil),
	}
	file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[1].OneofWrappers = []any{
		(*TagField_DoubleValue)(nil),
		(*TagField_StringValue)(nil),
		(*TagField_BoolValue)(nil),
		(*TagField_TimestampValue)(nil),
		(*TagField_EnumValue_)(nil),
	}
	file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes[4].OneofWrappers = []any{
		(*FieldType_PrimitiveType_)(nil),
		(*FieldType_EnumType_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_datacatalog_v1beta1_tags_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_datacatalog_v1beta1_tags_proto_goTypes,
		DependencyIndexes: file_google_cloud_datacatalog_v1beta1_tags_proto_depIdxs,
		EnumInfos:         file_google_cloud_datacatalog_v1beta1_tags_proto_enumTypes,
		MessageInfos:      file_google_cloud_datacatalog_v1beta1_tags_proto_msgTypes,
	}.Build()
	File_google_cloud_datacatalog_v1beta1_tags_proto = out.File
	file_google_cloud_datacatalog_v1beta1_tags_proto_rawDesc = nil
	file_google_cloud_datacatalog_v1beta1_tags_proto_goTypes = nil
	file_google_cloud_datacatalog_v1beta1_tags_proto_depIdxs = nil
}
