// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1/prediction_service.proto

package aiplatformpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	httpbody "google.golang.org/genproto/googleapis/api/httpbody"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Blocked reason enumeration.
type GenerateContentResponse_PromptFeedback_BlockedReason int32

const (
	// Unspecified blocked reason.
	GenerateContentResponse_PromptFeedback_BLOCKED_REASON_UNSPECIFIED GenerateContentResponse_PromptFeedback_BlockedReason = 0
	// Candidates blocked due to safety.
	GenerateContentResponse_PromptFeedback_SAFETY GenerateContentResponse_PromptFeedback_BlockedReason = 1
	// Candidates blocked due to other reason.
	GenerateContentResponse_PromptFeedback_OTHER GenerateContentResponse_PromptFeedback_BlockedReason = 2
	// Candidates blocked due to the terms which are included from the
	// terminology blocklist.
	GenerateContentResponse_PromptFeedback_BLOCKLIST GenerateContentResponse_PromptFeedback_BlockedReason = 3
	// Candidates blocked due to prohibited content.
	GenerateContentResponse_PromptFeedback_PROHIBITED_CONTENT GenerateContentResponse_PromptFeedback_BlockedReason = 4
)

// Enum value maps for GenerateContentResponse_PromptFeedback_BlockedReason.
var (
	GenerateContentResponse_PromptFeedback_BlockedReason_name = map[int32]string{
		0: "BLOCKED_REASON_UNSPECIFIED",
		1: "SAFETY",
		2: "OTHER",
		3: "BLOCKLIST",
		4: "PROHIBITED_CONTENT",
	}
	GenerateContentResponse_PromptFeedback_BlockedReason_value = map[string]int32{
		"BLOCKED_REASON_UNSPECIFIED": 0,
		"SAFETY":                     1,
		"OTHER":                      2,
		"BLOCKLIST":                  3,
		"PROHIBITED_CONTENT":         4,
	}
)

func (x GenerateContentResponse_PromptFeedback_BlockedReason) Enum() *GenerateContentResponse_PromptFeedback_BlockedReason {
	p := new(GenerateContentResponse_PromptFeedback_BlockedReason)
	*p = x
	return p
}

func (x GenerateContentResponse_PromptFeedback_BlockedReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (GenerateContentResponse_PromptFeedback_BlockedReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_enumTypes[0].Descriptor()
}

func (GenerateContentResponse_PromptFeedback_BlockedReason) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1_prediction_service_proto_enumTypes[0]
}

func (x GenerateContentResponse_PromptFeedback_BlockedReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use GenerateContentResponse_PromptFeedback_BlockedReason.Descriptor instead.
func (GenerateContentResponse_PromptFeedback_BlockedReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{21, 0, 0}
}

// Request message for
// [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
type PredictRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Endpoint requested to serve the prediction.
	// Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Required. The instances that are the input to the prediction call.
	// A DeployedModel may have an upper limit on the number of instances it
	// supports per request, and when it is exceeded the prediction call errors
	// in case of AutoML Models, or, in case of customer created Models, the
	// behaviour is as documented by that Model.
	// The schema of any single instance may be specified via Endpoint's
	// DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
	// [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
	// [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
	Instances []*structpb.Value `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
	// The parameters that govern the prediction. The schema of the parameters may
	// be specified via Endpoint's DeployedModels' [Model's
	// ][google.cloud.aiplatform.v1.DeployedModel.model]
	// [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
	// [parameters_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri].
	Parameters *structpb.Value `protobuf:"bytes,3,opt,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *PredictRequest) Reset() {
	*x = PredictRequest{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PredictRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredictRequest) ProtoMessage() {}

func (x *PredictRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredictRequest.ProtoReflect.Descriptor instead.
func (*PredictRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{0}
}

func (x *PredictRequest) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *PredictRequest) GetInstances() []*structpb.Value {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *PredictRequest) GetParameters() *structpb.Value {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Response message for
// [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict].
type PredictResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The predictions that are the output of the predictions call.
	// The schema of any single prediction may be specified via Endpoint's
	// DeployedModels' [Model's ][google.cloud.aiplatform.v1.DeployedModel.model]
	// [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
	// [prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri].
	Predictions []*structpb.Value `protobuf:"bytes,1,rep,name=predictions,proto3" json:"predictions,omitempty"`
	// ID of the Endpoint's DeployedModel that served this prediction.
	DeployedModelId string `protobuf:"bytes,2,opt,name=deployed_model_id,json=deployedModelId,proto3" json:"deployed_model_id,omitempty"`
	// Output only. The resource name of the Model which is deployed as the
	// DeployedModel that this prediction hits.
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	// Output only. The version ID of the Model which is deployed as the
	// DeployedModel that this prediction hits.
	ModelVersionId string `protobuf:"bytes,5,opt,name=model_version_id,json=modelVersionId,proto3" json:"model_version_id,omitempty"`
	// Output only. The [display
	// name][google.cloud.aiplatform.v1.Model.display_name] of the Model which is
	// deployed as the DeployedModel that this prediction hits.
	ModelDisplayName string `protobuf:"bytes,4,opt,name=model_display_name,json=modelDisplayName,proto3" json:"model_display_name,omitempty"`
	// Output only. Request-level metadata returned by the model. The metadata
	// type will be dependent upon the model implementation.
	Metadata *structpb.Value `protobuf:"bytes,6,opt,name=metadata,proto3" json:"metadata,omitempty"`
}

func (x *PredictResponse) Reset() {
	*x = PredictResponse{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PredictResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PredictResponse) ProtoMessage() {}

func (x *PredictResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PredictResponse.ProtoReflect.Descriptor instead.
func (*PredictResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{1}
}

func (x *PredictResponse) GetPredictions() []*structpb.Value {
	if x != nil {
		return x.Predictions
	}
	return nil
}

func (x *PredictResponse) GetDeployedModelId() string {
	if x != nil {
		return x.DeployedModelId
	}
	return ""
}

func (x *PredictResponse) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *PredictResponse) GetModelVersionId() string {
	if x != nil {
		return x.ModelVersionId
	}
	return ""
}

func (x *PredictResponse) GetModelDisplayName() string {
	if x != nil {
		return x.ModelDisplayName
	}
	return ""
}

func (x *PredictResponse) GetMetadata() *structpb.Value {
	if x != nil {
		return x.Metadata
	}
	return nil
}

// Request message for
// [PredictionService.RawPredict][google.cloud.aiplatform.v1.PredictionService.RawPredict].
type RawPredictRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Endpoint requested to serve the prediction.
	// Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// The prediction input. Supports HTTP headers and arbitrary data payload.
	//
	// A [DeployedModel][google.cloud.aiplatform.v1.DeployedModel] may have an
	// upper limit on the number of instances it supports per request. When this
	// limit it is exceeded for an AutoML model, the
	// [RawPredict][google.cloud.aiplatform.v1.PredictionService.RawPredict]
	// method returns an error. When this limit is exceeded for a custom-trained
	// model, the behavior varies depending on the model.
	//
	// You can specify the schema for each instance in the
	// [predict_schemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
	// field when you create a [Model][google.cloud.aiplatform.v1.Model]. This
	// schema applies when you deploy the `Model` as a `DeployedModel` to an
	// [Endpoint][google.cloud.aiplatform.v1.Endpoint] and use the `RawPredict`
	// method.
	HttpBody *httpbody.HttpBody `protobuf:"bytes,2,opt,name=http_body,json=httpBody,proto3" json:"http_body,omitempty"`
}

func (x *RawPredictRequest) Reset() {
	*x = RawPredictRequest{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RawPredictRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RawPredictRequest) ProtoMessage() {}

func (x *RawPredictRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RawPredictRequest.ProtoReflect.Descriptor instead.
func (*RawPredictRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{2}
}

func (x *RawPredictRequest) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *RawPredictRequest) GetHttpBody() *httpbody.HttpBody {
	if x != nil {
		return x.HttpBody
	}
	return nil
}

// Request message for
// [PredictionService.StreamRawPredict][google.cloud.aiplatform.v1.PredictionService.StreamRawPredict].
type StreamRawPredictRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Endpoint requested to serve the prediction.
	// Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// The prediction input. Supports HTTP headers and arbitrary data payload.
	HttpBody *httpbody.HttpBody `protobuf:"bytes,2,opt,name=http_body,json=httpBody,proto3" json:"http_body,omitempty"`
}

func (x *StreamRawPredictRequest) Reset() {
	*x = StreamRawPredictRequest{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamRawPredictRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamRawPredictRequest) ProtoMessage() {}

func (x *StreamRawPredictRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamRawPredictRequest.ProtoReflect.Descriptor instead.
func (*StreamRawPredictRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{3}
}

func (x *StreamRawPredictRequest) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *StreamRawPredictRequest) GetHttpBody() *httpbody.HttpBody {
	if x != nil {
		return x.HttpBody
	}
	return nil
}

// Request message for
// [PredictionService.DirectPredict][google.cloud.aiplatform.v1.PredictionService.DirectPredict].
type DirectPredictRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Endpoint requested to serve the prediction.
	// Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// The prediction input.
	Inputs []*Tensor `protobuf:"bytes,2,rep,name=inputs,proto3" json:"inputs,omitempty"`
	// The parameters that govern the prediction.
	Parameters *Tensor `protobuf:"bytes,3,opt,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *DirectPredictRequest) Reset() {
	*x = DirectPredictRequest{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DirectPredictRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectPredictRequest) ProtoMessage() {}

func (x *DirectPredictRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectPredictRequest.ProtoReflect.Descriptor instead.
func (*DirectPredictRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{4}
}

func (x *DirectPredictRequest) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *DirectPredictRequest) GetInputs() []*Tensor {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *DirectPredictRequest) GetParameters() *Tensor {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Response message for
// [PredictionService.DirectPredict][google.cloud.aiplatform.v1.PredictionService.DirectPredict].
type DirectPredictResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The prediction output.
	Outputs []*Tensor `protobuf:"bytes,1,rep,name=outputs,proto3" json:"outputs,omitempty"`
	// The parameters that govern the prediction.
	Parameters *Tensor `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *DirectPredictResponse) Reset() {
	*x = DirectPredictResponse{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DirectPredictResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectPredictResponse) ProtoMessage() {}

func (x *DirectPredictResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectPredictResponse.ProtoReflect.Descriptor instead.
func (*DirectPredictResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{5}
}

func (x *DirectPredictResponse) GetOutputs() []*Tensor {
	if x != nil {
		return x.Outputs
	}
	return nil
}

func (x *DirectPredictResponse) GetParameters() *Tensor {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Request message for
// [PredictionService.DirectRawPredict][google.cloud.aiplatform.v1.PredictionService.DirectRawPredict].
type DirectRawPredictRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Endpoint requested to serve the prediction.
	// Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Fully qualified name of the API method being invoked to perform
	// predictions.
	//
	// Format:
	// `/namespace.Service/Method/`
	// Example:
	// `/tensorflow.serving.PredictionService/Predict`
	MethodName string `protobuf:"bytes,2,opt,name=method_name,json=methodName,proto3" json:"method_name,omitempty"`
	// The prediction input.
	Input []byte `protobuf:"bytes,3,opt,name=input,proto3" json:"input,omitempty"`
}

func (x *DirectRawPredictRequest) Reset() {
	*x = DirectRawPredictRequest{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DirectRawPredictRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectRawPredictRequest) ProtoMessage() {}

func (x *DirectRawPredictRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectRawPredictRequest.ProtoReflect.Descriptor instead.
func (*DirectRawPredictRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{6}
}

func (x *DirectRawPredictRequest) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *DirectRawPredictRequest) GetMethodName() string {
	if x != nil {
		return x.MethodName
	}
	return ""
}

func (x *DirectRawPredictRequest) GetInput() []byte {
	if x != nil {
		return x.Input
	}
	return nil
}

// Response message for
// [PredictionService.DirectRawPredict][google.cloud.aiplatform.v1.PredictionService.DirectRawPredict].
type DirectRawPredictResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The prediction output.
	Output []byte `protobuf:"bytes,1,opt,name=output,proto3" json:"output,omitempty"`
}

func (x *DirectRawPredictResponse) Reset() {
	*x = DirectRawPredictResponse{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DirectRawPredictResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DirectRawPredictResponse) ProtoMessage() {}

func (x *DirectRawPredictResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DirectRawPredictResponse.ProtoReflect.Descriptor instead.
func (*DirectRawPredictResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{7}
}

func (x *DirectRawPredictResponse) GetOutput() []byte {
	if x != nil {
		return x.Output
	}
	return nil
}

// Request message for
// [PredictionService.StreamDirectPredict][google.cloud.aiplatform.v1.PredictionService.StreamDirectPredict].
//
// The first message must contain
// [endpoint][google.cloud.aiplatform.v1.StreamDirectPredictRequest.endpoint]
// field and optionally [input][]. The subsequent messages must contain
// [input][].
type StreamDirectPredictRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Endpoint requested to serve the prediction.
	// Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Optional. The prediction input.
	Inputs []*Tensor `protobuf:"bytes,2,rep,name=inputs,proto3" json:"inputs,omitempty"`
	// Optional. The parameters that govern the prediction.
	Parameters *Tensor `protobuf:"bytes,3,opt,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *StreamDirectPredictRequest) Reset() {
	*x = StreamDirectPredictRequest{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamDirectPredictRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamDirectPredictRequest) ProtoMessage() {}

func (x *StreamDirectPredictRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamDirectPredictRequest.ProtoReflect.Descriptor instead.
func (*StreamDirectPredictRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{8}
}

func (x *StreamDirectPredictRequest) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *StreamDirectPredictRequest) GetInputs() []*Tensor {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *StreamDirectPredictRequest) GetParameters() *Tensor {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Response message for
// [PredictionService.StreamDirectPredict][google.cloud.aiplatform.v1.PredictionService.StreamDirectPredict].
type StreamDirectPredictResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The prediction output.
	Outputs []*Tensor `protobuf:"bytes,1,rep,name=outputs,proto3" json:"outputs,omitempty"`
	// The parameters that govern the prediction.
	Parameters *Tensor `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *StreamDirectPredictResponse) Reset() {
	*x = StreamDirectPredictResponse{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamDirectPredictResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamDirectPredictResponse) ProtoMessage() {}

func (x *StreamDirectPredictResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamDirectPredictResponse.ProtoReflect.Descriptor instead.
func (*StreamDirectPredictResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{9}
}

func (x *StreamDirectPredictResponse) GetOutputs() []*Tensor {
	if x != nil {
		return x.Outputs
	}
	return nil
}

func (x *StreamDirectPredictResponse) GetParameters() *Tensor {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Request message for
// [PredictionService.StreamDirectRawPredict][google.cloud.aiplatform.v1.PredictionService.StreamDirectRawPredict].
//
// The first message must contain
// [endpoint][google.cloud.aiplatform.v1.StreamDirectRawPredictRequest.endpoint]
// and
// [method_name][google.cloud.aiplatform.v1.StreamDirectRawPredictRequest.method_name]
// fields and optionally
// [input][google.cloud.aiplatform.v1.StreamDirectRawPredictRequest.input]. The
// subsequent messages must contain
// [input][google.cloud.aiplatform.v1.StreamDirectRawPredictRequest.input].
// [method_name][google.cloud.aiplatform.v1.StreamDirectRawPredictRequest.method_name]
// in the subsequent messages have no effect.
type StreamDirectRawPredictRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Endpoint requested to serve the prediction.
	// Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Optional. Fully qualified name of the API method being invoked to perform
	// predictions.
	//
	// Format:
	// `/namespace.Service/Method/`
	// Example:
	// `/tensorflow.serving.PredictionService/Predict`
	MethodName string `protobuf:"bytes,2,opt,name=method_name,json=methodName,proto3" json:"method_name,omitempty"`
	// Optional. The prediction input.
	Input []byte `protobuf:"bytes,3,opt,name=input,proto3" json:"input,omitempty"`
}

func (x *StreamDirectRawPredictRequest) Reset() {
	*x = StreamDirectRawPredictRequest{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamDirectRawPredictRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamDirectRawPredictRequest) ProtoMessage() {}

func (x *StreamDirectRawPredictRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamDirectRawPredictRequest.ProtoReflect.Descriptor instead.
func (*StreamDirectRawPredictRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{10}
}

func (x *StreamDirectRawPredictRequest) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *StreamDirectRawPredictRequest) GetMethodName() string {
	if x != nil {
		return x.MethodName
	}
	return ""
}

func (x *StreamDirectRawPredictRequest) GetInput() []byte {
	if x != nil {
		return x.Input
	}
	return nil
}

// Response message for
// [PredictionService.StreamDirectRawPredict][google.cloud.aiplatform.v1.PredictionService.StreamDirectRawPredict].
type StreamDirectRawPredictResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The prediction output.
	Output []byte `protobuf:"bytes,1,opt,name=output,proto3" json:"output,omitempty"`
}

func (x *StreamDirectRawPredictResponse) Reset() {
	*x = StreamDirectRawPredictResponse{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamDirectRawPredictResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamDirectRawPredictResponse) ProtoMessage() {}

func (x *StreamDirectRawPredictResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamDirectRawPredictResponse.ProtoReflect.Descriptor instead.
func (*StreamDirectRawPredictResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{11}
}

func (x *StreamDirectRawPredictResponse) GetOutput() []byte {
	if x != nil {
		return x.Output
	}
	return nil
}

// Request message for
// [PredictionService.StreamingPredict][google.cloud.aiplatform.v1.PredictionService.StreamingPredict].
//
// The first message must contain
// [endpoint][google.cloud.aiplatform.v1.StreamingPredictRequest.endpoint] field
// and optionally [input][]. The subsequent messages must contain [input][].
type StreamingPredictRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Endpoint requested to serve the prediction.
	// Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// The prediction input.
	Inputs []*Tensor `protobuf:"bytes,2,rep,name=inputs,proto3" json:"inputs,omitempty"`
	// The parameters that govern the prediction.
	Parameters *Tensor `protobuf:"bytes,3,opt,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *StreamingPredictRequest) Reset() {
	*x = StreamingPredictRequest{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingPredictRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingPredictRequest) ProtoMessage() {}

func (x *StreamingPredictRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingPredictRequest.ProtoReflect.Descriptor instead.
func (*StreamingPredictRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{12}
}

func (x *StreamingPredictRequest) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *StreamingPredictRequest) GetInputs() []*Tensor {
	if x != nil {
		return x.Inputs
	}
	return nil
}

func (x *StreamingPredictRequest) GetParameters() *Tensor {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Response message for
// [PredictionService.StreamingPredict][google.cloud.aiplatform.v1.PredictionService.StreamingPredict].
type StreamingPredictResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The prediction output.
	Outputs []*Tensor `protobuf:"bytes,1,rep,name=outputs,proto3" json:"outputs,omitempty"`
	// The parameters that govern the prediction.
	Parameters *Tensor `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"`
}

func (x *StreamingPredictResponse) Reset() {
	*x = StreamingPredictResponse{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingPredictResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingPredictResponse) ProtoMessage() {}

func (x *StreamingPredictResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingPredictResponse.ProtoReflect.Descriptor instead.
func (*StreamingPredictResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{13}
}

func (x *StreamingPredictResponse) GetOutputs() []*Tensor {
	if x != nil {
		return x.Outputs
	}
	return nil
}

func (x *StreamingPredictResponse) GetParameters() *Tensor {
	if x != nil {
		return x.Parameters
	}
	return nil
}

// Request message for
// [PredictionService.StreamingRawPredict][google.cloud.aiplatform.v1.PredictionService.StreamingRawPredict].
//
// The first message must contain
// [endpoint][google.cloud.aiplatform.v1.StreamingRawPredictRequest.endpoint]
// and
// [method_name][google.cloud.aiplatform.v1.StreamingRawPredictRequest.method_name]
// fields and optionally
// [input][google.cloud.aiplatform.v1.StreamingRawPredictRequest.input]. The
// subsequent messages must contain
// [input][google.cloud.aiplatform.v1.StreamingRawPredictRequest.input].
// [method_name][google.cloud.aiplatform.v1.StreamingRawPredictRequest.method_name]
// in the subsequent messages have no effect.
type StreamingRawPredictRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Endpoint requested to serve the prediction.
	// Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Fully qualified name of the API method being invoked to perform
	// predictions.
	//
	// Format:
	// `/namespace.Service/Method/`
	// Example:
	// `/tensorflow.serving.PredictionService/Predict`
	MethodName string `protobuf:"bytes,2,opt,name=method_name,json=methodName,proto3" json:"method_name,omitempty"`
	// The prediction input.
	Input []byte `protobuf:"bytes,3,opt,name=input,proto3" json:"input,omitempty"`
}

func (x *StreamingRawPredictRequest) Reset() {
	*x = StreamingRawPredictRequest{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingRawPredictRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRawPredictRequest) ProtoMessage() {}

func (x *StreamingRawPredictRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRawPredictRequest.ProtoReflect.Descriptor instead.
func (*StreamingRawPredictRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{14}
}

func (x *StreamingRawPredictRequest) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *StreamingRawPredictRequest) GetMethodName() string {
	if x != nil {
		return x.MethodName
	}
	return ""
}

func (x *StreamingRawPredictRequest) GetInput() []byte {
	if x != nil {
		return x.Input
	}
	return nil
}

// Response message for
// [PredictionService.StreamingRawPredict][google.cloud.aiplatform.v1.PredictionService.StreamingRawPredict].
type StreamingRawPredictResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The prediction output.
	Output []byte `protobuf:"bytes,1,opt,name=output,proto3" json:"output,omitempty"`
}

func (x *StreamingRawPredictResponse) Reset() {
	*x = StreamingRawPredictResponse{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StreamingRawPredictResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamingRawPredictResponse) ProtoMessage() {}

func (x *StreamingRawPredictResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamingRawPredictResponse.ProtoReflect.Descriptor instead.
func (*StreamingRawPredictResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{15}
}

func (x *StreamingRawPredictResponse) GetOutput() []byte {
	if x != nil {
		return x.Output
	}
	return nil
}

// Request message for
// [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
type ExplainRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Endpoint requested to serve the explanation.
	// Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Required. The instances that are the input to the explanation call.
	// A DeployedModel may have an upper limit on the number of instances it
	// supports per request, and when it is exceeded the explanation call errors
	// in case of AutoML Models, or, in case of customer created Models, the
	// behaviour is as documented by that Model.
	// The schema of any single instance may be specified via Endpoint's
	// DeployedModels' [Model's][google.cloud.aiplatform.v1.DeployedModel.model]
	// [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
	// [instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri].
	Instances []*structpb.Value `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
	// The parameters that govern the prediction. The schema of the parameters may
	// be specified via Endpoint's DeployedModels' [Model's
	// ][google.cloud.aiplatform.v1.DeployedModel.model]
	// [PredictSchemata's][google.cloud.aiplatform.v1.Model.predict_schemata]
	// [parameters_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.parameters_schema_uri].
	Parameters *structpb.Value `protobuf:"bytes,4,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// If specified, overrides the
	// [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
	// of the DeployedModel. Can be used for explaining prediction results with
	// different configurations, such as:
	//   - Explaining top-5 predictions results as opposed to top-1;
	//   - Increasing path count or step count of the attribution methods to reduce
	//     approximate errors;
	//   - Using different baselines for explaining the prediction results.
	ExplanationSpecOverride *ExplanationSpecOverride `protobuf:"bytes,5,opt,name=explanation_spec_override,json=explanationSpecOverride,proto3" json:"explanation_spec_override,omitempty"`
	// If specified, this ExplainRequest will be served by the chosen
	// DeployedModel, overriding
	// [Endpoint.traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split].
	DeployedModelId string `protobuf:"bytes,3,opt,name=deployed_model_id,json=deployedModelId,proto3" json:"deployed_model_id,omitempty"`
}

func (x *ExplainRequest) Reset() {
	*x = ExplainRequest{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExplainRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplainRequest) ProtoMessage() {}

func (x *ExplainRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplainRequest.ProtoReflect.Descriptor instead.
func (*ExplainRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{16}
}

func (x *ExplainRequest) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *ExplainRequest) GetInstances() []*structpb.Value {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *ExplainRequest) GetParameters() *structpb.Value {
	if x != nil {
		return x.Parameters
	}
	return nil
}

func (x *ExplainRequest) GetExplanationSpecOverride() *ExplanationSpecOverride {
	if x != nil {
		return x.ExplanationSpecOverride
	}
	return nil
}

func (x *ExplainRequest) GetDeployedModelId() string {
	if x != nil {
		return x.DeployedModelId
	}
	return ""
}

// Response message for
// [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
type ExplainResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The explanations of the Model's
	// [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
	//
	// It has the same number of elements as
	// [instances][google.cloud.aiplatform.v1.ExplainRequest.instances] to be
	// explained.
	Explanations []*Explanation `protobuf:"bytes,1,rep,name=explanations,proto3" json:"explanations,omitempty"`
	// ID of the Endpoint's DeployedModel that served this explanation.
	DeployedModelId string `protobuf:"bytes,2,opt,name=deployed_model_id,json=deployedModelId,proto3" json:"deployed_model_id,omitempty"`
	// The predictions that are the output of the predictions call.
	// Same as
	// [PredictResponse.predictions][google.cloud.aiplatform.v1.PredictResponse.predictions].
	Predictions []*structpb.Value `protobuf:"bytes,3,rep,name=predictions,proto3" json:"predictions,omitempty"`
}

func (x *ExplainResponse) Reset() {
	*x = ExplainResponse{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ExplainResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExplainResponse) ProtoMessage() {}

func (x *ExplainResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExplainResponse.ProtoReflect.Descriptor instead.
func (*ExplainResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{17}
}

func (x *ExplainResponse) GetExplanations() []*Explanation {
	if x != nil {
		return x.Explanations
	}
	return nil
}

func (x *ExplainResponse) GetDeployedModelId() string {
	if x != nil {
		return x.DeployedModelId
	}
	return ""
}

func (x *ExplainResponse) GetPredictions() []*structpb.Value {
	if x != nil {
		return x.Predictions
	}
	return nil
}

// Request message for [PredictionService.CountTokens][].
type CountTokensRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Endpoint requested to perform token counting.
	// Format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Endpoint string `protobuf:"bytes,1,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Optional. The name of the publisher model requested to serve the
	// prediction. Format:
	// `projects/{project}/locations/{location}/publishers/*/models/*`
	Model string `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	// Optional. The instances that are the input to token counting call.
	// Schema is identical to the prediction schema of the underlying model.
	Instances []*structpb.Value `protobuf:"bytes,2,rep,name=instances,proto3" json:"instances,omitempty"`
	// Optional. Input content.
	Contents []*Content `protobuf:"bytes,4,rep,name=contents,proto3" json:"contents,omitempty"`
	// Optional. The user provided system instructions for the model.
	// Note: only text should be used in parts and content in each part will be in
	// a separate paragraph.
	SystemInstruction *Content `protobuf:"bytes,5,opt,name=system_instruction,json=systemInstruction,proto3,oneof" json:"system_instruction,omitempty"`
	// Optional. A list of `Tools` the model may use to generate the next
	// response.
	//
	// A `Tool` is a piece of code that enables the system to interact with
	// external systems to perform an action, or set of actions, outside of
	// knowledge and scope of the model.
	Tools []*Tool `protobuf:"bytes,6,rep,name=tools,proto3" json:"tools,omitempty"`
	// Optional. Generation config that the model will use to generate the
	// response.
	GenerationConfig *GenerationConfig `protobuf:"bytes,7,opt,name=generation_config,json=generationConfig,proto3,oneof" json:"generation_config,omitempty"`
}

func (x *CountTokensRequest) Reset() {
	*x = CountTokensRequest{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CountTokensRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CountTokensRequest) ProtoMessage() {}

func (x *CountTokensRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CountTokensRequest.ProtoReflect.Descriptor instead.
func (*CountTokensRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{18}
}

func (x *CountTokensRequest) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *CountTokensRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *CountTokensRequest) GetInstances() []*structpb.Value {
	if x != nil {
		return x.Instances
	}
	return nil
}

func (x *CountTokensRequest) GetContents() []*Content {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *CountTokensRequest) GetSystemInstruction() *Content {
	if x != nil {
		return x.SystemInstruction
	}
	return nil
}

func (x *CountTokensRequest) GetTools() []*Tool {
	if x != nil {
		return x.Tools
	}
	return nil
}

func (x *CountTokensRequest) GetGenerationConfig() *GenerationConfig {
	if x != nil {
		return x.GenerationConfig
	}
	return nil
}

// Response message for [PredictionService.CountTokens][].
type CountTokensResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total number of tokens counted across all instances from the request.
	TotalTokens int32 `protobuf:"varint,1,opt,name=total_tokens,json=totalTokens,proto3" json:"total_tokens,omitempty"`
	// The total number of billable characters counted across all instances from
	// the request.
	TotalBillableCharacters int32 `protobuf:"varint,2,opt,name=total_billable_characters,json=totalBillableCharacters,proto3" json:"total_billable_characters,omitempty"`
	// Output only. List of modalities that were processed in the request input.
	PromptTokensDetails []*ModalityTokenCount `protobuf:"bytes,3,rep,name=prompt_tokens_details,json=promptTokensDetails,proto3" json:"prompt_tokens_details,omitempty"`
}

func (x *CountTokensResponse) Reset() {
	*x = CountTokensResponse{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CountTokensResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CountTokensResponse) ProtoMessage() {}

func (x *CountTokensResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CountTokensResponse.ProtoReflect.Descriptor instead.
func (*CountTokensResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{19}
}

func (x *CountTokensResponse) GetTotalTokens() int32 {
	if x != nil {
		return x.TotalTokens
	}
	return 0
}

func (x *CountTokensResponse) GetTotalBillableCharacters() int32 {
	if x != nil {
		return x.TotalBillableCharacters
	}
	return 0
}

func (x *CountTokensResponse) GetPromptTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.PromptTokensDetails
	}
	return nil
}

// Request message for [PredictionService.GenerateContent].
type GenerateContentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The fully qualified name of the publisher model or tuned model
	// endpoint to use.
	//
	// Publisher model format:
	// `projects/{project}/locations/{location}/publishers/*/models/*`
	//
	// Tuned model endpoint format:
	// `projects/{project}/locations/{location}/endpoints/{endpoint}`
	Model string `protobuf:"bytes,5,opt,name=model,proto3" json:"model,omitempty"`
	// Required. The content of the current conversation with the model.
	//
	// For single-turn queries, this is a single instance. For multi-turn queries,
	// this is a repeated field that contains conversation history + latest
	// request.
	Contents []*Content `protobuf:"bytes,2,rep,name=contents,proto3" json:"contents,omitempty"`
	// Optional. The user provided system instructions for the model.
	// Note: only text should be used in parts and content in each part will be in
	// a separate paragraph.
	SystemInstruction *Content `protobuf:"bytes,8,opt,name=system_instruction,json=systemInstruction,proto3,oneof" json:"system_instruction,omitempty"`
	// Optional. The name of the cached content used as context to serve the
	// prediction. Note: only used in explicit caching, where users can have
	// control over caching (e.g. what content to cache) and enjoy guaranteed cost
	// savings. Format:
	// `projects/{project}/locations/{location}/cachedContents/{cachedContent}`
	CachedContent string `protobuf:"bytes,9,opt,name=cached_content,json=cachedContent,proto3" json:"cached_content,omitempty"`
	// Optional. A list of `Tools` the model may use to generate the next
	// response.
	//
	// A `Tool` is a piece of code that enables the system to interact with
	// external systems to perform an action, or set of actions, outside of
	// knowledge and scope of the model.
	Tools []*Tool `protobuf:"bytes,6,rep,name=tools,proto3" json:"tools,omitempty"`
	// Optional. Tool config. This config is shared for all tools provided in the
	// request.
	ToolConfig *ToolConfig `protobuf:"bytes,7,opt,name=tool_config,json=toolConfig,proto3" json:"tool_config,omitempty"`
	// Optional. The labels with user-defined metadata for the request. It is used
	// for billing and reporting only.
	//
	// Label keys and values can be no longer than 63 characters
	// (Unicode codepoints) and can only contain lowercase letters, numeric
	// characters, underscores, and dashes. International characters are allowed.
	// Label values are optional. Label keys must start with a letter.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Per request settings for blocking unsafe content.
	// Enforced on GenerateContentResponse.candidates.
	SafetySettings []*SafetySetting `protobuf:"bytes,3,rep,name=safety_settings,json=safetySettings,proto3" json:"safety_settings,omitempty"`
	// Optional. Generation config.
	GenerationConfig *GenerationConfig `protobuf:"bytes,4,opt,name=generation_config,json=generationConfig,proto3" json:"generation_config,omitempty"`
}

func (x *GenerateContentRequest) Reset() {
	*x = GenerateContentRequest{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateContentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateContentRequest) ProtoMessage() {}

func (x *GenerateContentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateContentRequest.ProtoReflect.Descriptor instead.
func (*GenerateContentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{20}
}

func (x *GenerateContentRequest) GetModel() string {
	if x != nil {
		return x.Model
	}
	return ""
}

func (x *GenerateContentRequest) GetContents() []*Content {
	if x != nil {
		return x.Contents
	}
	return nil
}

func (x *GenerateContentRequest) GetSystemInstruction() *Content {
	if x != nil {
		return x.SystemInstruction
	}
	return nil
}

func (x *GenerateContentRequest) GetCachedContent() string {
	if x != nil {
		return x.CachedContent
	}
	return ""
}

func (x *GenerateContentRequest) GetTools() []*Tool {
	if x != nil {
		return x.Tools
	}
	return nil
}

func (x *GenerateContentRequest) GetToolConfig() *ToolConfig {
	if x != nil {
		return x.ToolConfig
	}
	return nil
}

func (x *GenerateContentRequest) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *GenerateContentRequest) GetSafetySettings() []*SafetySetting {
	if x != nil {
		return x.SafetySettings
	}
	return nil
}

func (x *GenerateContentRequest) GetGenerationConfig() *GenerationConfig {
	if x != nil {
		return x.GenerationConfig
	}
	return nil
}

// Response message for [PredictionService.GenerateContent].
type GenerateContentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Generated candidates.
	Candidates []*Candidate `protobuf:"bytes,2,rep,name=candidates,proto3" json:"candidates,omitempty"`
	// Output only. The model version used to generate the response.
	ModelVersion string `protobuf:"bytes,11,opt,name=model_version,json=modelVersion,proto3" json:"model_version,omitempty"`
	// Output only. Timestamp when the request is made to the server.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. response_id is used to identify each response. It is the
	// encoding of the event_id.
	ResponseId string `protobuf:"bytes,13,opt,name=response_id,json=responseId,proto3" json:"response_id,omitempty"`
	// Output only. Content filter results for a prompt sent in the request.
	// Note: Sent only in the first stream chunk.
	// Only happens when no candidates were generated due to content violations.
	PromptFeedback *GenerateContentResponse_PromptFeedback `protobuf:"bytes,3,opt,name=prompt_feedback,json=promptFeedback,proto3" json:"prompt_feedback,omitempty"`
	// Usage metadata about the response(s).
	UsageMetadata *GenerateContentResponse_UsageMetadata `protobuf:"bytes,4,opt,name=usage_metadata,json=usageMetadata,proto3" json:"usage_metadata,omitempty"`
}

func (x *GenerateContentResponse) Reset() {
	*x = GenerateContentResponse{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateContentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateContentResponse) ProtoMessage() {}

func (x *GenerateContentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateContentResponse.ProtoReflect.Descriptor instead.
func (*GenerateContentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{21}
}

func (x *GenerateContentResponse) GetCandidates() []*Candidate {
	if x != nil {
		return x.Candidates
	}
	return nil
}

func (x *GenerateContentResponse) GetModelVersion() string {
	if x != nil {
		return x.ModelVersion
	}
	return ""
}

func (x *GenerateContentResponse) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *GenerateContentResponse) GetResponseId() string {
	if x != nil {
		return x.ResponseId
	}
	return ""
}

func (x *GenerateContentResponse) GetPromptFeedback() *GenerateContentResponse_PromptFeedback {
	if x != nil {
		return x.PromptFeedback
	}
	return nil
}

func (x *GenerateContentResponse) GetUsageMetadata() *GenerateContentResponse_UsageMetadata {
	if x != nil {
		return x.UsageMetadata
	}
	return nil
}

// Content filter results for a prompt sent in the request.
type GenerateContentResponse_PromptFeedback struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Blocked reason.
	BlockReason GenerateContentResponse_PromptFeedback_BlockedReason `protobuf:"varint,1,opt,name=block_reason,json=blockReason,proto3,enum=google.cloud.aiplatform.v1.GenerateContentResponse_PromptFeedback_BlockedReason" json:"block_reason,omitempty"`
	// Output only. Safety ratings.
	SafetyRatings []*SafetyRating `protobuf:"bytes,2,rep,name=safety_ratings,json=safetyRatings,proto3" json:"safety_ratings,omitempty"`
	// Output only. A readable block reason message.
	BlockReasonMessage string `protobuf:"bytes,3,opt,name=block_reason_message,json=blockReasonMessage,proto3" json:"block_reason_message,omitempty"`
}

func (x *GenerateContentResponse_PromptFeedback) Reset() {
	*x = GenerateContentResponse_PromptFeedback{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateContentResponse_PromptFeedback) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateContentResponse_PromptFeedback) ProtoMessage() {}

func (x *GenerateContentResponse_PromptFeedback) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateContentResponse_PromptFeedback.ProtoReflect.Descriptor instead.
func (*GenerateContentResponse_PromptFeedback) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{21, 0}
}

func (x *GenerateContentResponse_PromptFeedback) GetBlockReason() GenerateContentResponse_PromptFeedback_BlockedReason {
	if x != nil {
		return x.BlockReason
	}
	return GenerateContentResponse_PromptFeedback_BLOCKED_REASON_UNSPECIFIED
}

func (x *GenerateContentResponse_PromptFeedback) GetSafetyRatings() []*SafetyRating {
	if x != nil {
		return x.SafetyRatings
	}
	return nil
}

func (x *GenerateContentResponse_PromptFeedback) GetBlockReasonMessage() string {
	if x != nil {
		return x.BlockReasonMessage
	}
	return ""
}

// Usage metadata about response(s).
type GenerateContentResponse_UsageMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Number of tokens in the request. When `cached_content` is set, this is
	// still the total effective prompt size meaning this includes the number of
	// tokens in the cached content.
	PromptTokenCount int32 `protobuf:"varint,1,opt,name=prompt_token_count,json=promptTokenCount,proto3" json:"prompt_token_count,omitempty"`
	// Number of tokens in the response(s).
	CandidatesTokenCount int32 `protobuf:"varint,2,opt,name=candidates_token_count,json=candidatesTokenCount,proto3" json:"candidates_token_count,omitempty"`
	// Total token count for prompt and response candidates.
	TotalTokenCount int32 `protobuf:"varint,3,opt,name=total_token_count,json=totalTokenCount,proto3" json:"total_token_count,omitempty"`
	// Output only. Number of tokens in the cached part in the input (the cached
	// content).
	CachedContentTokenCount int32 `protobuf:"varint,5,opt,name=cached_content_token_count,json=cachedContentTokenCount,proto3" json:"cached_content_token_count,omitempty"`
	// Output only. List of modalities that were processed in the request input.
	PromptTokensDetails []*ModalityTokenCount `protobuf:"bytes,9,rep,name=prompt_tokens_details,json=promptTokensDetails,proto3" json:"prompt_tokens_details,omitempty"`
	// Output only. List of modalities of the cached content in the request
	// input.
	CacheTokensDetails []*ModalityTokenCount `protobuf:"bytes,10,rep,name=cache_tokens_details,json=cacheTokensDetails,proto3" json:"cache_tokens_details,omitempty"`
	// Output only. List of modalities that were returned in the response.
	CandidatesTokensDetails []*ModalityTokenCount `protobuf:"bytes,11,rep,name=candidates_tokens_details,json=candidatesTokensDetails,proto3" json:"candidates_tokens_details,omitempty"`
}

func (x *GenerateContentResponse_UsageMetadata) Reset() {
	*x = GenerateContentResponse_UsageMetadata{}
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GenerateContentResponse_UsageMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerateContentResponse_UsageMetadata) ProtoMessage() {}

func (x *GenerateContentResponse_UsageMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerateContentResponse_UsageMetadata.ProtoReflect.Descriptor instead.
func (*GenerateContentResponse_UsageMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP(), []int{21, 1}
}

func (x *GenerateContentResponse_UsageMetadata) GetPromptTokenCount() int32 {
	if x != nil {
		return x.PromptTokenCount
	}
	return 0
}

func (x *GenerateContentResponse_UsageMetadata) GetCandidatesTokenCount() int32 {
	if x != nil {
		return x.CandidatesTokenCount
	}
	return 0
}

func (x *GenerateContentResponse_UsageMetadata) GetTotalTokenCount() int32 {
	if x != nil {
		return x.TotalTokenCount
	}
	return 0
}

func (x *GenerateContentResponse_UsageMetadata) GetCachedContentTokenCount() int32 {
	if x != nil {
		return x.CachedContentTokenCount
	}
	return 0
}

func (x *GenerateContentResponse_UsageMetadata) GetPromptTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.PromptTokensDetails
	}
	return nil
}

func (x *GenerateContentResponse_UsageMetadata) GetCacheTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.CacheTokensDetails
	}
	return nil
}

func (x *GenerateContentResponse_UsageMetadata) GetCandidatesTokensDetails() []*ModalityTokenCount {
	if x != nil {
		return x.CandidatesTokensDetails
	}
	return nil
}

var File_google_cloud_aiplatform_v1_prediction_service_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1_prediction_service_proto_rawDesc = []byte{
	0x0a, 0x33, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65,
	0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x68, 0x74, 0x74, 0x70, 0x62, 0x6f, 0x64, 0x79, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x28, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x25, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x76, 0x31, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x26,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x73,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xcb, 0x01, 0x0a, 0x0e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x39, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x36, 0x0a, 0x0a, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x22, 0xd1, 0x02, 0x0a, 0x0f, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a, 0x0b, 0x70, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56,
	0x61, 0x6c, 0x75, 0x65, 0x52, 0x0b, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x12, 0x3d, 0x0a,
	0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41,
	0x03, 0xfa, 0x41, 0x21, 0x0a, 0x1f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x2d, 0x0a, 0x10,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x31, 0x0a, 0x12, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x37,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x6d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x22, 0x8e, 0x01, 0x0a, 0x11, 0x52, 0x61, 0x77, 0x50,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a,
	0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x31, 0x0a, 0x09, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x62, 0x6f,
	0x64, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x42, 0x6f, 0x64, 0x79, 0x52, 0x08,
	0x68, 0x74, 0x74, 0x70, 0x42, 0x6f, 0x64, 0x79, 0x22, 0x94, 0x01, 0x0a, 0x17, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x31, 0x0a, 0x09,
	0x68, 0x74, 0x74, 0x70, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x48, 0x74, 0x74,
	0x70, 0x42, 0x6f, 0x64, 0x79, 0x52, 0x08, 0x68, 0x74, 0x74, 0x70, 0x42, 0x6f, 0x64, 0x79, 0x22,
	0xde, 0x01, 0x0a, 0x14, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x3a, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x52, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x12, 0x42, 0x0a, 0x0a,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65,
	0x6e, 0x73, 0x6f, 0x72, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x22, 0x99, 0x01, 0x0a, 0x15, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x50, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x07, 0x6f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52,
	0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x42, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72,
	0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x98, 0x01, 0x0a,
	0x17, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c,
	0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x22, 0x32, 0x0a, 0x18, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x22, 0xee, 0x01, 0x0a, 0x1a,
	0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x08, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x12, 0x3f, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x73, 0x12, 0x47, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x9f, 0x01, 0x0a,
	0x1b, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x07,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f,
	0x72, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x12, 0x42, 0x0a, 0x0a, 0x70, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73,
	0x6f, 0x72, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0xa8,
	0x01, 0x0a, 0x1d, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x52,
	0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x46, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0b, 0x6d, 0x65, 0x74, 0x68,
	0x6f, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x19,
	0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x22, 0x38, 0x0a, 0x1e, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x06, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x22, 0xe1, 0x01, 0x0a, 0x17, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x46, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x69, 0x6e, 0x70, 0x75, 0x74,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x06, 0x69, 0x6e, 0x70,
	0x75, 0x74, 0x73, 0x12, 0x42, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x0a, 0x70, 0x61, 0x72,
	0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x9c, 0x01, 0x0a, 0x18, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x07, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x73, 0x12, 0x42, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x6e, 0x73, 0x6f, 0x72, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x22, 0x9b, 0x01, 0x0a, 0x1a, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a,
	0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x1f, 0x0a,
	0x0b, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0a, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x05, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x22, 0x35, 0x0a, 0x1b, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0c, 0x52, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x22, 0xe8, 0x02, 0x0a, 0x0e,
	0x45, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x39, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x12, 0x36, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0a, 0x70,
	0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x6f, 0x0a, 0x19, 0x65, 0x78, 0x70,
	0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x5f, 0x6f, 0x76,
	0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64,
	0x65, 0x52, 0x17, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x70,
	0x65, 0x63, 0x4f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x65,
	0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x4d,
	0x6f, 0x64, 0x65, 0x6c, 0x49, 0x64, 0x22, 0xc4, 0x01, 0x0a, 0x0f, 0x45, 0x78, 0x70, 0x6c, 0x61,
	0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x0a, 0x0c, 0x65, 0x78,
	0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x65, 0x78, 0x70, 0x6c, 0x61,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x64, 0x65, 0x70, 0x6c, 0x6f,
	0x79, 0x65, 0x64, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0f, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x4d, 0x6f, 0x64, 0x65,
	0x6c, 0x49, 0x64, 0x12, 0x38, 0x0a, 0x0b, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65,
	0x52, 0x0b, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xa5, 0x04,
	0x0a, 0x12, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x24, 0x0a, 0x22,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x19, 0x0a, 0x05,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x39, 0x0a, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c,
	0x75, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63,
	0x65, 0x73, 0x12, 0x44, 0x0a, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x5c, 0x0a, 0x12, 0x73, 0x79, 0x73, 0x74,
	0x65, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x11, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x3b, 0x0a, 0x05, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x18,
	0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x12, 0x63, 0x0a, 0x11, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x01, 0x52, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x88, 0x01, 0x01, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x14, 0x0a, 0x12, 0x5f, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0xdd, 0x01, 0x0a, 0x13, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x21, 0x0a,
	0x0c, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0b, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73,
	0x12, 0x3a, 0x0a, 0x19, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x62, 0x69, 0x6c, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x17, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x42, 0x69, 0x6c, 0x6c, 0x61, 0x62,
	0x6c, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x12, 0x67, 0x0a, 0x15,
	0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x64, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74,
	0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x13, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0xa2, 0x06, 0x0a, 0x16, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61,
	0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x19, 0x0a, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x44, 0x0a, 0x08, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0x5c, 0x0a, 0x12, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x69, 0x6e, 0x73, 0x74,
	0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x11, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x49, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x56, 0x0a, 0x0e, 0x63, 0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x29, 0x0a,
	0x27, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x61, 0x63, 0x68, 0x65,
	0x64, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x63, 0x61, 0x63, 0x68, 0x65, 0x64,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x05, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x4c, 0x0a, 0x0b, 0x74, 0x6f, 0x6f, 0x6c, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x74, 0x6f, 0x6f, 0x6c, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x12, 0x5b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12,
	0x57, 0x0a, 0x0f, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74,
	0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79,
	0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x5e, 0x0a, 0x11, 0x67, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a,
	0x02, 0x38, 0x01, 0x42, 0x15, 0x0a, 0x13, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x5f, 0x69,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x81, 0x0b, 0x0a, 0x17, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4a, 0x0a, 0x0a, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64,
	0x61, 0x74, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x24,
	0x0a, 0x0b, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x0d, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x49, 0x64, 0x12, 0x70, 0x0a, 0x0f, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x66,
	0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x42, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63,
	0x6b, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x46, 0x65,
	0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x12, 0x68, 0x0a, 0x0e, 0x75, 0x73, 0x61, 0x67, 0x65, 0x5f,
	0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x2e, 0x55, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x52, 0x0d, 0x75, 0x73, 0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x1a, 0x86, 0x03, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62,
	0x61, 0x63, 0x6b, 0x12, 0x78, 0x0a, 0x0c, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x50,
	0x72, 0x6f, 0x6d, 0x70, 0x74, 0x46, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x2e, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x65, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x0b, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x54, 0x0a,
	0x0e, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x35, 0x0a, 0x14, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x5f, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x52, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x6d, 0x0a, 0x0d, 0x42, 0x6c,
	0x6f, 0x63, 0x6b, 0x65, 0x64, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x1a, 0x42,
	0x4c, 0x4f, 0x43, 0x4b, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x41, 0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53,
	0x41, 0x46, 0x45, 0x54, 0x59, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52,
	0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x4c, 0x49, 0x53, 0x54, 0x10,
	0x03, 0x12, 0x16, 0x0a, 0x12, 0x50, 0x52, 0x4f, 0x48, 0x49, 0x42, 0x49, 0x54, 0x45, 0x44, 0x5f,
	0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x04, 0x1a, 0xa2, 0x04, 0x0a, 0x0d, 0x55, 0x73,
	0x61, 0x67, 0x65, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x2c, 0x0a, 0x12, 0x70,
	0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x34, 0x0a, 0x16, 0x63, 0x61, 0x6e,
	0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x14, 0x63, 0x61, 0x6e, 0x64, 0x69,
	0x64, 0x61, 0x74, 0x65, 0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x2a, 0x0a, 0x11, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x0f, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x1a, 0x63,
	0x61, 0x63, 0x68, 0x65, 0x64, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x61, 0x63, 0x68, 0x65, 0x64, 0x43, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x67, 0x0a,
	0x15, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x64,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69,
	0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x13, 0x70, 0x72, 0x6f, 0x6d, 0x70, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x65, 0x0a, 0x14, 0x63, 0x61, 0x63, 0x68, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0a,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x6f, 0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x63, 0x61, 0x63, 0x68, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x6f, 0x0a,
	0x19, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x6f,
	0x64, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x43, 0x6f, 0x75, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x17, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x73, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x32, 0xf2,
	0x19, 0x0a, 0x11, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x94, 0x02, 0x0a, 0x07, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xaf, 0x01, 0xda, 0x41, 0x1d, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x73, 0x2c, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x88, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x48, 0x3a, 0x01, 0x2a, 0x22, 0x43, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6d,
	0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74,
	0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x12, 0xfe, 0x01, 0x0a, 0x0a,
	0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x61, 0x70, 0x69, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x42, 0x6f, 0x64, 0x79, 0x22,
	0xaa, 0x01, 0xda, 0x41, 0x12, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2c, 0x68, 0x74,
	0x74, 0x70, 0x5f, 0x62, 0x6f, 0x64, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8e, 0x01, 0x3a, 0x01,
	0x2a, 0x5a, 0x4b, 0x3a, 0x01, 0x2a, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x22, 0x3c,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x3a, 0x72, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x12, 0x98, 0x02, 0x0a,
	0x10, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x14, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x61, 0x70, 0x69, 0x2e, 0x48, 0x74, 0x74, 0x70, 0x42, 0x6f, 0x64, 0x79, 0x22, 0xb6, 0x01, 0xda,
	0x41, 0x12, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x5f,
	0x62, 0x6f, 0x64, 0x79, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9a, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x51,
	0x3a, 0x01, 0x2a, 0x22, 0x4c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
	0x68, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x22, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x52, 0x61, 0x77, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x30, 0x01, 0x12, 0xc0, 0x01, 0x0a, 0x0d, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x12, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x31, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x50,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4a,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x44, 0x3a, 0x01, 0x2a, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x12, 0xcc, 0x01, 0x0a, 0x10, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x12,
	0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x4d, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x47, 0x3a, 0x01, 0x2a, 0x22, 0x42, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x52,
	0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x12, 0x8c, 0x01, 0x0a, 0x13, 0x53, 0x74,
	0x72, 0x65, 0x61, 0x6d, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x50, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x12, 0x95, 0x01, 0x0a, 0x16, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x52, 0x61, 0x77,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01,
	0x12, 0x83, 0x01, 0x0a, 0x10, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e,
	0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x12, 0xb5, 0x02, 0x0a, 0x16, 0x53, 0x65, 0x72, 0x76, 0x65,
	0x72, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x74, 0x12, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65,
	0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xad, 0x01, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0xa6, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x57, 0x3a, 0x01, 0x2a, 0x22, 0x52,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x3d, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x72, 0x76,
	0x65, 0x72, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69,
	0x63, 0x74, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x30, 0x01, 0x12, 0x8c,
	0x01, 0x0a, 0x13, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x77, 0x50,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x77,
	0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x37,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65,
	0x61, 0x6d, 0x69, 0x6e, 0x67, 0x52, 0x61, 0x77, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x00, 0x28, 0x01, 0x30, 0x01, 0x12, 0xda, 0x01,
	0x0a, 0x07, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x12, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x22, 0x76, 0xda, 0x41, 0x2f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2c,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2c, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x73, 0x2c, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x5f, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x3e, 0x3a, 0x01, 0x2a, 0x22,
	0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x12, 0x8d, 0x03, 0x0a, 0x0f, 0x47,
	0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x32,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65,
	0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x90, 0x02, 0xda, 0x41, 0x0e, 0x6d, 0x6f, 0x64,
	0x65, 0x6c, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xf8, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x4d, 0x3a, 0x01, 0x2a, 0x22, 0x48, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x75,
	0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5a, 0x2c, 0x3a, 0x01, 0x2a, 0x22, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x5a, 0x36, 0x3a, 0x01, 0x2a, 0x22, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x6f,
	0x64, 0x65, 0x6c, 0x3d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x3e, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x67, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0xad, 0x03, 0x0a, 0x15, 0x53,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x12, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa8, 0x02,
	0xda, 0x41, 0x0e, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x2c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x73, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x90, 0x02, 0x3a, 0x01, 0x2a, 0x5a, 0x53, 0x3a, 0x01, 0x2a,
	0x22, 0x4e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x5a, 0x32, 0x3a, 0x01, 0x2a, 0x22, 0x2d, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65,
	0x6c, 0x3d, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73,
	0x74, 0x72, 0x65, 0x61, 0x6d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5a, 0x3c, 0x3a, 0x01, 0x2a, 0x22, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x22, 0x44, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x3d, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x3a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74,
	0x65, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x30, 0x01, 0x1a, 0x86, 0x01, 0xca, 0x41, 0x19,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x67, 0x68, 0x74, 0x74, 0x70,
	0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x73,
	0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x72, 0x65, 0x61, 0x64, 0x2d, 0x6f,
	0x6e, 0x6c, 0x79, 0x42, 0xd4, 0x01, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x42, 0x16, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x3e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0xaa, 0x02, 0x1a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1a,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x1d, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescData = file_google_cloud_aiplatform_v1_prediction_service_proto_rawDesc
)

func file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1_prediction_service_proto_rawDescData
}

var file_google_cloud_aiplatform_v1_prediction_service_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes = make([]protoimpl.MessageInfo, 25)
var file_google_cloud_aiplatform_v1_prediction_service_proto_goTypes = []any{
	(GenerateContentResponse_PromptFeedback_BlockedReason)(0), // 0: google.cloud.aiplatform.v1.GenerateContentResponse.PromptFeedback.BlockedReason
	(*PredictRequest)(nil),                         // 1: google.cloud.aiplatform.v1.PredictRequest
	(*PredictResponse)(nil),                        // 2: google.cloud.aiplatform.v1.PredictResponse
	(*RawPredictRequest)(nil),                      // 3: google.cloud.aiplatform.v1.RawPredictRequest
	(*StreamRawPredictRequest)(nil),                // 4: google.cloud.aiplatform.v1.StreamRawPredictRequest
	(*DirectPredictRequest)(nil),                   // 5: google.cloud.aiplatform.v1.DirectPredictRequest
	(*DirectPredictResponse)(nil),                  // 6: google.cloud.aiplatform.v1.DirectPredictResponse
	(*DirectRawPredictRequest)(nil),                // 7: google.cloud.aiplatform.v1.DirectRawPredictRequest
	(*DirectRawPredictResponse)(nil),               // 8: google.cloud.aiplatform.v1.DirectRawPredictResponse
	(*StreamDirectPredictRequest)(nil),             // 9: google.cloud.aiplatform.v1.StreamDirectPredictRequest
	(*StreamDirectPredictResponse)(nil),            // 10: google.cloud.aiplatform.v1.StreamDirectPredictResponse
	(*StreamDirectRawPredictRequest)(nil),          // 11: google.cloud.aiplatform.v1.StreamDirectRawPredictRequest
	(*StreamDirectRawPredictResponse)(nil),         // 12: google.cloud.aiplatform.v1.StreamDirectRawPredictResponse
	(*StreamingPredictRequest)(nil),                // 13: google.cloud.aiplatform.v1.StreamingPredictRequest
	(*StreamingPredictResponse)(nil),               // 14: google.cloud.aiplatform.v1.StreamingPredictResponse
	(*StreamingRawPredictRequest)(nil),             // 15: google.cloud.aiplatform.v1.StreamingRawPredictRequest
	(*StreamingRawPredictResponse)(nil),            // 16: google.cloud.aiplatform.v1.StreamingRawPredictResponse
	(*ExplainRequest)(nil),                         // 17: google.cloud.aiplatform.v1.ExplainRequest
	(*ExplainResponse)(nil),                        // 18: google.cloud.aiplatform.v1.ExplainResponse
	(*CountTokensRequest)(nil),                     // 19: google.cloud.aiplatform.v1.CountTokensRequest
	(*CountTokensResponse)(nil),                    // 20: google.cloud.aiplatform.v1.CountTokensResponse
	(*GenerateContentRequest)(nil),                 // 21: google.cloud.aiplatform.v1.GenerateContentRequest
	(*GenerateContentResponse)(nil),                // 22: google.cloud.aiplatform.v1.GenerateContentResponse
	nil,                                            // 23: google.cloud.aiplatform.v1.GenerateContentRequest.LabelsEntry
	(*GenerateContentResponse_PromptFeedback)(nil), // 24: google.cloud.aiplatform.v1.GenerateContentResponse.PromptFeedback
	(*GenerateContentResponse_UsageMetadata)(nil),  // 25: google.cloud.aiplatform.v1.GenerateContentResponse.UsageMetadata
	(*structpb.Value)(nil),                         // 26: google.protobuf.Value
	(*httpbody.HttpBody)(nil),                      // 27: google.api.HttpBody
	(*Tensor)(nil),                                 // 28: google.cloud.aiplatform.v1.Tensor
	(*ExplanationSpecOverride)(nil),                // 29: google.cloud.aiplatform.v1.ExplanationSpecOverride
	(*Explanation)(nil),                            // 30: google.cloud.aiplatform.v1.Explanation
	(*Content)(nil),                                // 31: google.cloud.aiplatform.v1.Content
	(*Tool)(nil),                                   // 32: google.cloud.aiplatform.v1.Tool
	(*GenerationConfig)(nil),                       // 33: google.cloud.aiplatform.v1.GenerationConfig
	(*ModalityTokenCount)(nil),                     // 34: google.cloud.aiplatform.v1.ModalityTokenCount
	(*ToolConfig)(nil),                             // 35: google.cloud.aiplatform.v1.ToolConfig
	(*SafetySetting)(nil),                          // 36: google.cloud.aiplatform.v1.SafetySetting
	(*Candidate)(nil),                              // 37: google.cloud.aiplatform.v1.Candidate
	(*timestamppb.Timestamp)(nil),                  // 38: google.protobuf.Timestamp
	(*SafetyRating)(nil),                           // 39: google.cloud.aiplatform.v1.SafetyRating
}
var file_google_cloud_aiplatform_v1_prediction_service_proto_depIdxs = []int32{
	26, // 0: google.cloud.aiplatform.v1.PredictRequest.instances:type_name -> google.protobuf.Value
	26, // 1: google.cloud.aiplatform.v1.PredictRequest.parameters:type_name -> google.protobuf.Value
	26, // 2: google.cloud.aiplatform.v1.PredictResponse.predictions:type_name -> google.protobuf.Value
	26, // 3: google.cloud.aiplatform.v1.PredictResponse.metadata:type_name -> google.protobuf.Value
	27, // 4: google.cloud.aiplatform.v1.RawPredictRequest.http_body:type_name -> google.api.HttpBody
	27, // 5: google.cloud.aiplatform.v1.StreamRawPredictRequest.http_body:type_name -> google.api.HttpBody
	28, // 6: google.cloud.aiplatform.v1.DirectPredictRequest.inputs:type_name -> google.cloud.aiplatform.v1.Tensor
	28, // 7: google.cloud.aiplatform.v1.DirectPredictRequest.parameters:type_name -> google.cloud.aiplatform.v1.Tensor
	28, // 8: google.cloud.aiplatform.v1.DirectPredictResponse.outputs:type_name -> google.cloud.aiplatform.v1.Tensor
	28, // 9: google.cloud.aiplatform.v1.DirectPredictResponse.parameters:type_name -> google.cloud.aiplatform.v1.Tensor
	28, // 10: google.cloud.aiplatform.v1.StreamDirectPredictRequest.inputs:type_name -> google.cloud.aiplatform.v1.Tensor
	28, // 11: google.cloud.aiplatform.v1.StreamDirectPredictRequest.parameters:type_name -> google.cloud.aiplatform.v1.Tensor
	28, // 12: google.cloud.aiplatform.v1.StreamDirectPredictResponse.outputs:type_name -> google.cloud.aiplatform.v1.Tensor
	28, // 13: google.cloud.aiplatform.v1.StreamDirectPredictResponse.parameters:type_name -> google.cloud.aiplatform.v1.Tensor
	28, // 14: google.cloud.aiplatform.v1.StreamingPredictRequest.inputs:type_name -> google.cloud.aiplatform.v1.Tensor
	28, // 15: google.cloud.aiplatform.v1.StreamingPredictRequest.parameters:type_name -> google.cloud.aiplatform.v1.Tensor
	28, // 16: google.cloud.aiplatform.v1.StreamingPredictResponse.outputs:type_name -> google.cloud.aiplatform.v1.Tensor
	28, // 17: google.cloud.aiplatform.v1.StreamingPredictResponse.parameters:type_name -> google.cloud.aiplatform.v1.Tensor
	26, // 18: google.cloud.aiplatform.v1.ExplainRequest.instances:type_name -> google.protobuf.Value
	26, // 19: google.cloud.aiplatform.v1.ExplainRequest.parameters:type_name -> google.protobuf.Value
	29, // 20: google.cloud.aiplatform.v1.ExplainRequest.explanation_spec_override:type_name -> google.cloud.aiplatform.v1.ExplanationSpecOverride
	30, // 21: google.cloud.aiplatform.v1.ExplainResponse.explanations:type_name -> google.cloud.aiplatform.v1.Explanation
	26, // 22: google.cloud.aiplatform.v1.ExplainResponse.predictions:type_name -> google.protobuf.Value
	26, // 23: google.cloud.aiplatform.v1.CountTokensRequest.instances:type_name -> google.protobuf.Value
	31, // 24: google.cloud.aiplatform.v1.CountTokensRequest.contents:type_name -> google.cloud.aiplatform.v1.Content
	31, // 25: google.cloud.aiplatform.v1.CountTokensRequest.system_instruction:type_name -> google.cloud.aiplatform.v1.Content
	32, // 26: google.cloud.aiplatform.v1.CountTokensRequest.tools:type_name -> google.cloud.aiplatform.v1.Tool
	33, // 27: google.cloud.aiplatform.v1.CountTokensRequest.generation_config:type_name -> google.cloud.aiplatform.v1.GenerationConfig
	34, // 28: google.cloud.aiplatform.v1.CountTokensResponse.prompt_tokens_details:type_name -> google.cloud.aiplatform.v1.ModalityTokenCount
	31, // 29: google.cloud.aiplatform.v1.GenerateContentRequest.contents:type_name -> google.cloud.aiplatform.v1.Content
	31, // 30: google.cloud.aiplatform.v1.GenerateContentRequest.system_instruction:type_name -> google.cloud.aiplatform.v1.Content
	32, // 31: google.cloud.aiplatform.v1.GenerateContentRequest.tools:type_name -> google.cloud.aiplatform.v1.Tool
	35, // 32: google.cloud.aiplatform.v1.GenerateContentRequest.tool_config:type_name -> google.cloud.aiplatform.v1.ToolConfig
	23, // 33: google.cloud.aiplatform.v1.GenerateContentRequest.labels:type_name -> google.cloud.aiplatform.v1.GenerateContentRequest.LabelsEntry
	36, // 34: google.cloud.aiplatform.v1.GenerateContentRequest.safety_settings:type_name -> google.cloud.aiplatform.v1.SafetySetting
	33, // 35: google.cloud.aiplatform.v1.GenerateContentRequest.generation_config:type_name -> google.cloud.aiplatform.v1.GenerationConfig
	37, // 36: google.cloud.aiplatform.v1.GenerateContentResponse.candidates:type_name -> google.cloud.aiplatform.v1.Candidate
	38, // 37: google.cloud.aiplatform.v1.GenerateContentResponse.create_time:type_name -> google.protobuf.Timestamp
	24, // 38: google.cloud.aiplatform.v1.GenerateContentResponse.prompt_feedback:type_name -> google.cloud.aiplatform.v1.GenerateContentResponse.PromptFeedback
	25, // 39: google.cloud.aiplatform.v1.GenerateContentResponse.usage_metadata:type_name -> google.cloud.aiplatform.v1.GenerateContentResponse.UsageMetadata
	0,  // 40: google.cloud.aiplatform.v1.GenerateContentResponse.PromptFeedback.block_reason:type_name -> google.cloud.aiplatform.v1.GenerateContentResponse.PromptFeedback.BlockedReason
	39, // 41: google.cloud.aiplatform.v1.GenerateContentResponse.PromptFeedback.safety_ratings:type_name -> google.cloud.aiplatform.v1.SafetyRating
	34, // 42: google.cloud.aiplatform.v1.GenerateContentResponse.UsageMetadata.prompt_tokens_details:type_name -> google.cloud.aiplatform.v1.ModalityTokenCount
	34, // 43: google.cloud.aiplatform.v1.GenerateContentResponse.UsageMetadata.cache_tokens_details:type_name -> google.cloud.aiplatform.v1.ModalityTokenCount
	34, // 44: google.cloud.aiplatform.v1.GenerateContentResponse.UsageMetadata.candidates_tokens_details:type_name -> google.cloud.aiplatform.v1.ModalityTokenCount
	1,  // 45: google.cloud.aiplatform.v1.PredictionService.Predict:input_type -> google.cloud.aiplatform.v1.PredictRequest
	3,  // 46: google.cloud.aiplatform.v1.PredictionService.RawPredict:input_type -> google.cloud.aiplatform.v1.RawPredictRequest
	4,  // 47: google.cloud.aiplatform.v1.PredictionService.StreamRawPredict:input_type -> google.cloud.aiplatform.v1.StreamRawPredictRequest
	5,  // 48: google.cloud.aiplatform.v1.PredictionService.DirectPredict:input_type -> google.cloud.aiplatform.v1.DirectPredictRequest
	7,  // 49: google.cloud.aiplatform.v1.PredictionService.DirectRawPredict:input_type -> google.cloud.aiplatform.v1.DirectRawPredictRequest
	9,  // 50: google.cloud.aiplatform.v1.PredictionService.StreamDirectPredict:input_type -> google.cloud.aiplatform.v1.StreamDirectPredictRequest
	11, // 51: google.cloud.aiplatform.v1.PredictionService.StreamDirectRawPredict:input_type -> google.cloud.aiplatform.v1.StreamDirectRawPredictRequest
	13, // 52: google.cloud.aiplatform.v1.PredictionService.StreamingPredict:input_type -> google.cloud.aiplatform.v1.StreamingPredictRequest
	13, // 53: google.cloud.aiplatform.v1.PredictionService.ServerStreamingPredict:input_type -> google.cloud.aiplatform.v1.StreamingPredictRequest
	15, // 54: google.cloud.aiplatform.v1.PredictionService.StreamingRawPredict:input_type -> google.cloud.aiplatform.v1.StreamingRawPredictRequest
	17, // 55: google.cloud.aiplatform.v1.PredictionService.Explain:input_type -> google.cloud.aiplatform.v1.ExplainRequest
	21, // 56: google.cloud.aiplatform.v1.PredictionService.GenerateContent:input_type -> google.cloud.aiplatform.v1.GenerateContentRequest
	21, // 57: google.cloud.aiplatform.v1.PredictionService.StreamGenerateContent:input_type -> google.cloud.aiplatform.v1.GenerateContentRequest
	2,  // 58: google.cloud.aiplatform.v1.PredictionService.Predict:output_type -> google.cloud.aiplatform.v1.PredictResponse
	27, // 59: google.cloud.aiplatform.v1.PredictionService.RawPredict:output_type -> google.api.HttpBody
	27, // 60: google.cloud.aiplatform.v1.PredictionService.StreamRawPredict:output_type -> google.api.HttpBody
	6,  // 61: google.cloud.aiplatform.v1.PredictionService.DirectPredict:output_type -> google.cloud.aiplatform.v1.DirectPredictResponse
	8,  // 62: google.cloud.aiplatform.v1.PredictionService.DirectRawPredict:output_type -> google.cloud.aiplatform.v1.DirectRawPredictResponse
	10, // 63: google.cloud.aiplatform.v1.PredictionService.StreamDirectPredict:output_type -> google.cloud.aiplatform.v1.StreamDirectPredictResponse
	12, // 64: google.cloud.aiplatform.v1.PredictionService.StreamDirectRawPredict:output_type -> google.cloud.aiplatform.v1.StreamDirectRawPredictResponse
	14, // 65: google.cloud.aiplatform.v1.PredictionService.StreamingPredict:output_type -> google.cloud.aiplatform.v1.StreamingPredictResponse
	14, // 66: google.cloud.aiplatform.v1.PredictionService.ServerStreamingPredict:output_type -> google.cloud.aiplatform.v1.StreamingPredictResponse
	16, // 67: google.cloud.aiplatform.v1.PredictionService.StreamingRawPredict:output_type -> google.cloud.aiplatform.v1.StreamingRawPredictResponse
	18, // 68: google.cloud.aiplatform.v1.PredictionService.Explain:output_type -> google.cloud.aiplatform.v1.ExplainResponse
	22, // 69: google.cloud.aiplatform.v1.PredictionService.GenerateContent:output_type -> google.cloud.aiplatform.v1.GenerateContentResponse
	22, // 70: google.cloud.aiplatform.v1.PredictionService.StreamGenerateContent:output_type -> google.cloud.aiplatform.v1.GenerateContentResponse
	58, // [58:71] is the sub-list for method output_type
	45, // [45:58] is the sub-list for method input_type
	45, // [45:45] is the sub-list for extension type_name
	45, // [45:45] is the sub-list for extension extendee
	0,  // [0:45] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1_prediction_service_proto_init() }
func file_google_cloud_aiplatform_v1_prediction_service_proto_init() {
	if File_google_cloud_aiplatform_v1_prediction_service_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1_content_proto_init()
	file_google_cloud_aiplatform_v1_explanation_proto_init()
	file_google_cloud_aiplatform_v1_tool_proto_init()
	file_google_cloud_aiplatform_v1_types_proto_init()
	file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[18].OneofWrappers = []any{}
	file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes[20].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1_prediction_service_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   25,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_aiplatform_v1_prediction_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1_prediction_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1_prediction_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1_prediction_service_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1_prediction_service_proto = out.File
	file_google_cloud_aiplatform_v1_prediction_service_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1_prediction_service_proto_goTypes = nil
	file_google_cloud_aiplatform_v1_prediction_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PredictionServiceClient is the client API for PredictionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PredictionServiceClient interface {
	// Perform an online prediction.
	Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error)
	// Perform an online prediction with an arbitrary HTTP payload.
	//
	// The response includes the following HTTP headers:
	//
	// * `X-Vertex-AI-Endpoint-Id`: ID of the
	// [Endpoint][google.cloud.aiplatform.v1.Endpoint] that served this
	// prediction.
	//
	// * `X-Vertex-AI-Deployed-Model-Id`: ID of the Endpoint's
	// [DeployedModel][google.cloud.aiplatform.v1.DeployedModel] that served this
	// prediction.
	RawPredict(ctx context.Context, in *RawPredictRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error)
	// Perform a streaming online prediction with an arbitrary HTTP payload.
	StreamRawPredict(ctx context.Context, in *StreamRawPredictRequest, opts ...grpc.CallOption) (PredictionService_StreamRawPredictClient, error)
	// Perform an unary online prediction request to a gRPC model server for
	// Vertex first-party products and frameworks.
	DirectPredict(ctx context.Context, in *DirectPredictRequest, opts ...grpc.CallOption) (*DirectPredictResponse, error)
	// Perform an unary online prediction request to a gRPC model server for
	// custom containers.
	DirectRawPredict(ctx context.Context, in *DirectRawPredictRequest, opts ...grpc.CallOption) (*DirectRawPredictResponse, error)
	// Perform a streaming online prediction request to a gRPC model server for
	// Vertex first-party products and frameworks.
	StreamDirectPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamDirectPredictClient, error)
	// Perform a streaming online prediction request to a gRPC model server for
	// custom containers.
	StreamDirectRawPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamDirectRawPredictClient, error)
	// Perform a streaming online prediction request for Vertex first-party
	// products and frameworks.
	StreamingPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamingPredictClient, error)
	// Perform a server-side streaming online prediction request for Vertex
	// LLM streaming.
	ServerStreamingPredict(ctx context.Context, in *StreamingPredictRequest, opts ...grpc.CallOption) (PredictionService_ServerStreamingPredictClient, error)
	// Perform a streaming online prediction request through gRPC.
	StreamingRawPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamingRawPredictClient, error)
	// Perform an online explanation.
	//
	// If
	// [deployed_model_id][google.cloud.aiplatform.v1.ExplainRequest.deployed_model_id]
	// is specified, the corresponding DeployModel must have
	// [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
	// populated. If
	// [deployed_model_id][google.cloud.aiplatform.v1.ExplainRequest.deployed_model_id]
	// is not specified, all DeployedModels must have
	// [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
	// populated.
	Explain(ctx context.Context, in *ExplainRequest, opts ...grpc.CallOption) (*ExplainResponse, error)
	// Generate content with multimodal inputs.
	GenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (*GenerateContentResponse, error)
	// Generate content with multimodal inputs with streaming support.
	StreamGenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (PredictionService_StreamGenerateContentClient, error)
}

type predictionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPredictionServiceClient(cc grpc.ClientConnInterface) PredictionServiceClient {
	return &predictionServiceClient{cc}
}

func (c *predictionServiceClient) Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error) {
	out := new(PredictResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.PredictionService/Predict", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionServiceClient) RawPredict(ctx context.Context, in *RawPredictRequest, opts ...grpc.CallOption) (*httpbody.HttpBody, error) {
	out := new(httpbody.HttpBody)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.PredictionService/RawPredict", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionServiceClient) StreamRawPredict(ctx context.Context, in *StreamRawPredictRequest, opts ...grpc.CallOption) (PredictionService_StreamRawPredictClient, error) {
	stream, err := c.cc.NewStream(ctx, &_PredictionService_serviceDesc.Streams[0], "/google.cloud.aiplatform.v1.PredictionService/StreamRawPredict", opts...)
	if err != nil {
		return nil, err
	}
	x := &predictionServiceStreamRawPredictClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type PredictionService_StreamRawPredictClient interface {
	Recv() (*httpbody.HttpBody, error)
	grpc.ClientStream
}

type predictionServiceStreamRawPredictClient struct {
	grpc.ClientStream
}

func (x *predictionServiceStreamRawPredictClient) Recv() (*httpbody.HttpBody, error) {
	m := new(httpbody.HttpBody)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *predictionServiceClient) DirectPredict(ctx context.Context, in *DirectPredictRequest, opts ...grpc.CallOption) (*DirectPredictResponse, error) {
	out := new(DirectPredictResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.PredictionService/DirectPredict", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionServiceClient) DirectRawPredict(ctx context.Context, in *DirectRawPredictRequest, opts ...grpc.CallOption) (*DirectRawPredictResponse, error) {
	out := new(DirectRawPredictResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.PredictionService/DirectRawPredict", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionServiceClient) StreamDirectPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamDirectPredictClient, error) {
	stream, err := c.cc.NewStream(ctx, &_PredictionService_serviceDesc.Streams[1], "/google.cloud.aiplatform.v1.PredictionService/StreamDirectPredict", opts...)
	if err != nil {
		return nil, err
	}
	x := &predictionServiceStreamDirectPredictClient{stream}
	return x, nil
}

type PredictionService_StreamDirectPredictClient interface {
	Send(*StreamDirectPredictRequest) error
	Recv() (*StreamDirectPredictResponse, error)
	grpc.ClientStream
}

type predictionServiceStreamDirectPredictClient struct {
	grpc.ClientStream
}

func (x *predictionServiceStreamDirectPredictClient) Send(m *StreamDirectPredictRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *predictionServiceStreamDirectPredictClient) Recv() (*StreamDirectPredictResponse, error) {
	m := new(StreamDirectPredictResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *predictionServiceClient) StreamDirectRawPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamDirectRawPredictClient, error) {
	stream, err := c.cc.NewStream(ctx, &_PredictionService_serviceDesc.Streams[2], "/google.cloud.aiplatform.v1.PredictionService/StreamDirectRawPredict", opts...)
	if err != nil {
		return nil, err
	}
	x := &predictionServiceStreamDirectRawPredictClient{stream}
	return x, nil
}

type PredictionService_StreamDirectRawPredictClient interface {
	Send(*StreamDirectRawPredictRequest) error
	Recv() (*StreamDirectRawPredictResponse, error)
	grpc.ClientStream
}

type predictionServiceStreamDirectRawPredictClient struct {
	grpc.ClientStream
}

func (x *predictionServiceStreamDirectRawPredictClient) Send(m *StreamDirectRawPredictRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *predictionServiceStreamDirectRawPredictClient) Recv() (*StreamDirectRawPredictResponse, error) {
	m := new(StreamDirectRawPredictResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *predictionServiceClient) StreamingPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamingPredictClient, error) {
	stream, err := c.cc.NewStream(ctx, &_PredictionService_serviceDesc.Streams[3], "/google.cloud.aiplatform.v1.PredictionService/StreamingPredict", opts...)
	if err != nil {
		return nil, err
	}
	x := &predictionServiceStreamingPredictClient{stream}
	return x, nil
}

type PredictionService_StreamingPredictClient interface {
	Send(*StreamingPredictRequest) error
	Recv() (*StreamingPredictResponse, error)
	grpc.ClientStream
}

type predictionServiceStreamingPredictClient struct {
	grpc.ClientStream
}

func (x *predictionServiceStreamingPredictClient) Send(m *StreamingPredictRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *predictionServiceStreamingPredictClient) Recv() (*StreamingPredictResponse, error) {
	m := new(StreamingPredictResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *predictionServiceClient) ServerStreamingPredict(ctx context.Context, in *StreamingPredictRequest, opts ...grpc.CallOption) (PredictionService_ServerStreamingPredictClient, error) {
	stream, err := c.cc.NewStream(ctx, &_PredictionService_serviceDesc.Streams[4], "/google.cloud.aiplatform.v1.PredictionService/ServerStreamingPredict", opts...)
	if err != nil {
		return nil, err
	}
	x := &predictionServiceServerStreamingPredictClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type PredictionService_ServerStreamingPredictClient interface {
	Recv() (*StreamingPredictResponse, error)
	grpc.ClientStream
}

type predictionServiceServerStreamingPredictClient struct {
	grpc.ClientStream
}

func (x *predictionServiceServerStreamingPredictClient) Recv() (*StreamingPredictResponse, error) {
	m := new(StreamingPredictResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *predictionServiceClient) StreamingRawPredict(ctx context.Context, opts ...grpc.CallOption) (PredictionService_StreamingRawPredictClient, error) {
	stream, err := c.cc.NewStream(ctx, &_PredictionService_serviceDesc.Streams[5], "/google.cloud.aiplatform.v1.PredictionService/StreamingRawPredict", opts...)
	if err != nil {
		return nil, err
	}
	x := &predictionServiceStreamingRawPredictClient{stream}
	return x, nil
}

type PredictionService_StreamingRawPredictClient interface {
	Send(*StreamingRawPredictRequest) error
	Recv() (*StreamingRawPredictResponse, error)
	grpc.ClientStream
}

type predictionServiceStreamingRawPredictClient struct {
	grpc.ClientStream
}

func (x *predictionServiceStreamingRawPredictClient) Send(m *StreamingRawPredictRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *predictionServiceStreamingRawPredictClient) Recv() (*StreamingRawPredictResponse, error) {
	m := new(StreamingRawPredictResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *predictionServiceClient) Explain(ctx context.Context, in *ExplainRequest, opts ...grpc.CallOption) (*ExplainResponse, error) {
	out := new(ExplainResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.PredictionService/Explain", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionServiceClient) GenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (*GenerateContentResponse, error) {
	out := new(GenerateContentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.aiplatform.v1.PredictionService/GenerateContent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionServiceClient) StreamGenerateContent(ctx context.Context, in *GenerateContentRequest, opts ...grpc.CallOption) (PredictionService_StreamGenerateContentClient, error) {
	stream, err := c.cc.NewStream(ctx, &_PredictionService_serviceDesc.Streams[6], "/google.cloud.aiplatform.v1.PredictionService/StreamGenerateContent", opts...)
	if err != nil {
		return nil, err
	}
	x := &predictionServiceStreamGenerateContentClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type PredictionService_StreamGenerateContentClient interface {
	Recv() (*GenerateContentResponse, error)
	grpc.ClientStream
}

type predictionServiceStreamGenerateContentClient struct {
	grpc.ClientStream
}

func (x *predictionServiceStreamGenerateContentClient) Recv() (*GenerateContentResponse, error) {
	m := new(GenerateContentResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// PredictionServiceServer is the server API for PredictionService service.
type PredictionServiceServer interface {
	// Perform an online prediction.
	Predict(context.Context, *PredictRequest) (*PredictResponse, error)
	// Perform an online prediction with an arbitrary HTTP payload.
	//
	// The response includes the following HTTP headers:
	//
	// * `X-Vertex-AI-Endpoint-Id`: ID of the
	// [Endpoint][google.cloud.aiplatform.v1.Endpoint] that served this
	// prediction.
	//
	// * `X-Vertex-AI-Deployed-Model-Id`: ID of the Endpoint's
	// [DeployedModel][google.cloud.aiplatform.v1.DeployedModel] that served this
	// prediction.
	RawPredict(context.Context, *RawPredictRequest) (*httpbody.HttpBody, error)
	// Perform a streaming online prediction with an arbitrary HTTP payload.
	StreamRawPredict(*StreamRawPredictRequest, PredictionService_StreamRawPredictServer) error
	// Perform an unary online prediction request to a gRPC model server for
	// Vertex first-party products and frameworks.
	DirectPredict(context.Context, *DirectPredictRequest) (*DirectPredictResponse, error)
	// Perform an unary online prediction request to a gRPC model server for
	// custom containers.
	DirectRawPredict(context.Context, *DirectRawPredictRequest) (*DirectRawPredictResponse, error)
	// Perform a streaming online prediction request to a gRPC model server for
	// Vertex first-party products and frameworks.
	StreamDirectPredict(PredictionService_StreamDirectPredictServer) error
	// Perform a streaming online prediction request to a gRPC model server for
	// custom containers.
	StreamDirectRawPredict(PredictionService_StreamDirectRawPredictServer) error
	// Perform a streaming online prediction request for Vertex first-party
	// products and frameworks.
	StreamingPredict(PredictionService_StreamingPredictServer) error
	// Perform a server-side streaming online prediction request for Vertex
	// LLM streaming.
	ServerStreamingPredict(*StreamingPredictRequest, PredictionService_ServerStreamingPredictServer) error
	// Perform a streaming online prediction request through gRPC.
	StreamingRawPredict(PredictionService_StreamingRawPredictServer) error
	// Perform an online explanation.
	//
	// If
	// [deployed_model_id][google.cloud.aiplatform.v1.ExplainRequest.deployed_model_id]
	// is specified, the corresponding DeployModel must have
	// [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
	// populated. If
	// [deployed_model_id][google.cloud.aiplatform.v1.ExplainRequest.deployed_model_id]
	// is not specified, all DeployedModels must have
	// [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
	// populated.
	Explain(context.Context, *ExplainRequest) (*ExplainResponse, error)
	// Generate content with multimodal inputs.
	GenerateContent(context.Context, *GenerateContentRequest) (*GenerateContentResponse, error)
	// Generate content with multimodal inputs with streaming support.
	StreamGenerateContent(*GenerateContentRequest, PredictionService_StreamGenerateContentServer) error
}

// UnimplementedPredictionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedPredictionServiceServer struct {
}

func (*UnimplementedPredictionServiceServer) Predict(context.Context, *PredictRequest) (*PredictResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Predict not implemented")
}
func (*UnimplementedPredictionServiceServer) RawPredict(context.Context, *RawPredictRequest) (*httpbody.HttpBody, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RawPredict not implemented")
}
func (*UnimplementedPredictionServiceServer) StreamRawPredict(*StreamRawPredictRequest, PredictionService_StreamRawPredictServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamRawPredict not implemented")
}
func (*UnimplementedPredictionServiceServer) DirectPredict(context.Context, *DirectPredictRequest) (*DirectPredictResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DirectPredict not implemented")
}
func (*UnimplementedPredictionServiceServer) DirectRawPredict(context.Context, *DirectRawPredictRequest) (*DirectRawPredictResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DirectRawPredict not implemented")
}
func (*UnimplementedPredictionServiceServer) StreamDirectPredict(PredictionService_StreamDirectPredictServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamDirectPredict not implemented")
}
func (*UnimplementedPredictionServiceServer) StreamDirectRawPredict(PredictionService_StreamDirectRawPredictServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamDirectRawPredict not implemented")
}
func (*UnimplementedPredictionServiceServer) StreamingPredict(PredictionService_StreamingPredictServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingPredict not implemented")
}
func (*UnimplementedPredictionServiceServer) ServerStreamingPredict(*StreamingPredictRequest, PredictionService_ServerStreamingPredictServer) error {
	return status.Errorf(codes.Unimplemented, "method ServerStreamingPredict not implemented")
}
func (*UnimplementedPredictionServiceServer) StreamingRawPredict(PredictionService_StreamingRawPredictServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamingRawPredict not implemented")
}
func (*UnimplementedPredictionServiceServer) Explain(context.Context, *ExplainRequest) (*ExplainResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Explain not implemented")
}
func (*UnimplementedPredictionServiceServer) GenerateContent(context.Context, *GenerateContentRequest) (*GenerateContentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GenerateContent not implemented")
}
func (*UnimplementedPredictionServiceServer) StreamGenerateContent(*GenerateContentRequest, PredictionService_StreamGenerateContentServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamGenerateContent not implemented")
}

func RegisterPredictionServiceServer(s *grpc.Server, srv PredictionServiceServer) {
	s.RegisterService(&_PredictionService_serviceDesc, srv)
}

func _PredictionService_Predict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).Predict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.PredictionService/Predict",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).Predict(ctx, req.(*PredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionService_RawPredict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RawPredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).RawPredict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.PredictionService/RawPredict",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).RawPredict(ctx, req.(*RawPredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionService_StreamRawPredict_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamRawPredictRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(PredictionServiceServer).StreamRawPredict(m, &predictionServiceStreamRawPredictServer{stream})
}

type PredictionService_StreamRawPredictServer interface {
	Send(*httpbody.HttpBody) error
	grpc.ServerStream
}

type predictionServiceStreamRawPredictServer struct {
	grpc.ServerStream
}

func (x *predictionServiceStreamRawPredictServer) Send(m *httpbody.HttpBody) error {
	return x.ServerStream.SendMsg(m)
}

func _PredictionService_DirectPredict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DirectPredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).DirectPredict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.PredictionService/DirectPredict",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).DirectPredict(ctx, req.(*DirectPredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionService_DirectRawPredict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DirectRawPredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).DirectRawPredict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.PredictionService/DirectRawPredict",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).DirectRawPredict(ctx, req.(*DirectRawPredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionService_StreamDirectPredict_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(PredictionServiceServer).StreamDirectPredict(&predictionServiceStreamDirectPredictServer{stream})
}

type PredictionService_StreamDirectPredictServer interface {
	Send(*StreamDirectPredictResponse) error
	Recv() (*StreamDirectPredictRequest, error)
	grpc.ServerStream
}

type predictionServiceStreamDirectPredictServer struct {
	grpc.ServerStream
}

func (x *predictionServiceStreamDirectPredictServer) Send(m *StreamDirectPredictResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *predictionServiceStreamDirectPredictServer) Recv() (*StreamDirectPredictRequest, error) {
	m := new(StreamDirectPredictRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _PredictionService_StreamDirectRawPredict_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(PredictionServiceServer).StreamDirectRawPredict(&predictionServiceStreamDirectRawPredictServer{stream})
}

type PredictionService_StreamDirectRawPredictServer interface {
	Send(*StreamDirectRawPredictResponse) error
	Recv() (*StreamDirectRawPredictRequest, error)
	grpc.ServerStream
}

type predictionServiceStreamDirectRawPredictServer struct {
	grpc.ServerStream
}

func (x *predictionServiceStreamDirectRawPredictServer) Send(m *StreamDirectRawPredictResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *predictionServiceStreamDirectRawPredictServer) Recv() (*StreamDirectRawPredictRequest, error) {
	m := new(StreamDirectRawPredictRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _PredictionService_StreamingPredict_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(PredictionServiceServer).StreamingPredict(&predictionServiceStreamingPredictServer{stream})
}

type PredictionService_StreamingPredictServer interface {
	Send(*StreamingPredictResponse) error
	Recv() (*StreamingPredictRequest, error)
	grpc.ServerStream
}

type predictionServiceStreamingPredictServer struct {
	grpc.ServerStream
}

func (x *predictionServiceStreamingPredictServer) Send(m *StreamingPredictResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *predictionServiceStreamingPredictServer) Recv() (*StreamingPredictRequest, error) {
	m := new(StreamingPredictRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _PredictionService_ServerStreamingPredict_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamingPredictRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(PredictionServiceServer).ServerStreamingPredict(m, &predictionServiceServerStreamingPredictServer{stream})
}

type PredictionService_ServerStreamingPredictServer interface {
	Send(*StreamingPredictResponse) error
	grpc.ServerStream
}

type predictionServiceServerStreamingPredictServer struct {
	grpc.ServerStream
}

func (x *predictionServiceServerStreamingPredictServer) Send(m *StreamingPredictResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _PredictionService_StreamingRawPredict_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(PredictionServiceServer).StreamingRawPredict(&predictionServiceStreamingRawPredictServer{stream})
}

type PredictionService_StreamingRawPredictServer interface {
	Send(*StreamingRawPredictResponse) error
	Recv() (*StreamingRawPredictRequest, error)
	grpc.ServerStream
}

type predictionServiceStreamingRawPredictServer struct {
	grpc.ServerStream
}

func (x *predictionServiceStreamingRawPredictServer) Send(m *StreamingRawPredictResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *predictionServiceStreamingRawPredictServer) Recv() (*StreamingRawPredictRequest, error) {
	m := new(StreamingRawPredictRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _PredictionService_Explain_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExplainRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).Explain(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.PredictionService/Explain",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).Explain(ctx, req.(*ExplainRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionService_GenerateContent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GenerateContentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).GenerateContent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.aiplatform.v1.PredictionService/GenerateContent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).GenerateContent(ctx, req.(*GenerateContentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionService_StreamGenerateContent_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GenerateContentRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(PredictionServiceServer).StreamGenerateContent(m, &predictionServiceStreamGenerateContentServer{stream})
}

type PredictionService_StreamGenerateContentServer interface {
	Send(*GenerateContentResponse) error
	grpc.ServerStream
}

type predictionServiceStreamGenerateContentServer struct {
	grpc.ServerStream
}

func (x *predictionServiceStreamGenerateContentServer) Send(m *GenerateContentResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _PredictionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.aiplatform.v1.PredictionService",
	HandlerType: (*PredictionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Predict",
			Handler:    _PredictionService_Predict_Handler,
		},
		{
			MethodName: "RawPredict",
			Handler:    _PredictionService_RawPredict_Handler,
		},
		{
			MethodName: "DirectPredict",
			Handler:    _PredictionService_DirectPredict_Handler,
		},
		{
			MethodName: "DirectRawPredict",
			Handler:    _PredictionService_DirectRawPredict_Handler,
		},
		{
			MethodName: "Explain",
			Handler:    _PredictionService_Explain_Handler,
		},
		{
			MethodName: "GenerateContent",
			Handler:    _PredictionService_GenerateContent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamRawPredict",
			Handler:       _PredictionService_StreamRawPredict_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StreamDirectPredict",
			Handler:       _PredictionService_StreamDirectPredict_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "StreamDirectRawPredict",
			Handler:       _PredictionService_StreamDirectRawPredict_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "StreamingPredict",
			Handler:       _PredictionService_StreamingPredict_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "ServerStreamingPredict",
			Handler:       _PredictionService_ServerStreamingPredict_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "StreamingRawPredict",
			Handler:       _PredictionService_StreamingRawPredict_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "StreamGenerateContent",
			Handler:       _PredictionService_StreamGenerateContent_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/aiplatform/v1/prediction_service.proto",
}
