/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta2

import (
	resourcev1beta2 "k8s.io/api/resource/v1beta2"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
)

// DeviceTaintApplyConfiguration represents a declarative configuration of the DeviceTaint type for use
// with apply.
//
// The device this taint is attached to has the "effect" on
// any claim which does not tolerate the taint and, through the claim,
// to pods using the claim.
type DeviceTaintApplyConfiguration struct {
	// The taint key to be applied to a device.
	// Must be a label name.
	Key *string `json:"key,omitempty"`
	// The taint value corresponding to the taint key.
	// Must be a label value.
	Value *string `json:"value,omitempty"`
	// The effect of the taint on claims that do not tolerate the taint
	// and through such claims on the pods using them.
	//
	// Valid effects are None, NoSchedule and NoExecute. PreferNoSchedule as used for
	// nodes is not valid here. More effects may get added in the future.
	// Consumers must treat unknown effects like None.
	Effect *resourcev1beta2.DeviceTaintEffect `json:"effect,omitempty"`
	// TimeAdded represents the time at which the taint was added.
	// Added automatically during create or update if not set.
	TimeAdded *v1.Time `json:"timeAdded,omitempty"`
}

// DeviceTaintApplyConfiguration constructs a declarative configuration of the DeviceTaint type for use with
// apply.
func DeviceTaint() *DeviceTaintApplyConfiguration {
	return &DeviceTaintApplyConfiguration{}
}

// WithKey sets the Key field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Key field is set to the value of the last call.
func (b *DeviceTaintApplyConfiguration) WithKey(value string) *DeviceTaintApplyConfiguration {
	b.Key = &value
	return b
}

// WithValue sets the Value field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Value field is set to the value of the last call.
func (b *DeviceTaintApplyConfiguration) WithValue(value string) *DeviceTaintApplyConfiguration {
	b.Value = &value
	return b
}

// WithEffect sets the Effect field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Effect field is set to the value of the last call.
func (b *DeviceTaintApplyConfiguration) WithEffect(value resourcev1beta2.DeviceTaintEffect) *DeviceTaintApplyConfiguration {
	b.Effect = &value
	return b
}

// WithTimeAdded sets the TimeAdded field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the TimeAdded field is set to the value of the last call.
func (b *DeviceTaintApplyConfiguration) WithTimeAdded(value v1.Time) *DeviceTaintApplyConfiguration {
	b.TimeAdded = &value
	return b
}
