package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDohDomainStatistics invokes the alidns.DescribeDohDomainStatistics API synchronously
func (client *Client) DescribeDohDomainStatistics(request *DescribeDohDomainStatisticsRequest) (response *DescribeDohDomainStatisticsResponse, err error) {
	response = CreateDescribeDohDomainStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDohDomainStatisticsWithChan invokes the alidns.DescribeDohDomainStatistics API asynchronously
func (client *Client) DescribeDohDomainStatisticsWithChan(request *DescribeDohDomainStatisticsRequest) (<-chan *DescribeDohDomainStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeDohDomainStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDohDomainStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDohDomainStatisticsWithCallback invokes the alidns.DescribeDohDomainStatistics API asynchronously
func (client *Client) DescribeDohDomainStatisticsWithCallback(request *DescribeDohDomainStatisticsRequest, callback func(response *DescribeDohDomainStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDohDomainStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDohDomainStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDohDomainStatisticsRequest is the request struct for api DescribeDohDomainStatistics
type DescribeDohDomainStatisticsRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
	StartDate  string `position:"Query" name:"StartDate"`
	EndDate    string `position:"Query" name:"EndDate"`
	Lang       string `position:"Query" name:"Lang"`
}

// DescribeDohDomainStatisticsResponse is the response struct for api DescribeDohDomainStatistics
type DescribeDohDomainStatisticsResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	Statistics []Statistic `json:"Statistics" xml:"Statistics"`
}

// CreateDescribeDohDomainStatisticsRequest creates a request to invoke DescribeDohDomainStatistics API
func CreateDescribeDohDomainStatisticsRequest() (request *DescribeDohDomainStatisticsRequest) {
	request = &DescribeDohDomainStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDohDomainStatistics", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDohDomainStatisticsResponse creates a response to parse from DescribeDohDomainStatistics response
func CreateDescribeDohDomainStatisticsResponse() (response *DescribeDohDomainStatisticsResponse) {
	response = &DescribeDohDomainStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
