package amp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RoaDuheYsTest invokes the amp.RoaDuheYsTest API synchronously
func (client *Client) RoaDuheYsTest(request *RoaDuheYsTestRequest) (response *RoaDuheYsTestResponse, err error) {
	response = CreateRoaDuheYsTestResponse()
	err = client.DoAction(request, response)
	return
}

// RoaDuheYsTestWithChan invokes the amp.RoaDuheYsTest API asynchronously
func (client *Client) RoaDuheYsTestWithChan(request *RoaDuheYsTestRequest) (<-chan *RoaDuheYsTestResponse, <-chan error) {
	responseChan := make(chan *RoaDuheYsTestResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RoaDuheYsTest(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RoaDuheYsTestWithCallback invokes the amp.RoaDuheYsTest API asynchronously
func (client *Client) RoaDuheYsTestWithCallback(request *RoaDuheYsTestRequest, callback func(response *RoaDuheYsTestResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RoaDuheYsTestResponse
		var err error
		defer close(result)
		response, err = client.RoaDuheYsTest(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RoaDuheYsTestRequest is the request struct for api RoaDuheYsTest
type RoaDuheYsTestRequest struct {
	*requests.RoaRequest
	Body RoaDuheYsTestBody `position:"Body" name:"body"  type:"Struct"`
}

// RoaDuheYsTestBody is a repeated param struct in RoaDuheYsTestRequest
type RoaDuheYsTestBody struct {
	GatewayInfomation    map[string]string                                    `name:"GatewayInfomation" type:"Map"`
	BizSystemParameters  map[string]string                                    `name:"BizSystemParameters" type:"Map"`
	Data                 string                                               `name:"Data"`
	BizGenericParameters map[string]RoaDuheYsTestBodyBizGenericParametersItem `name:"BizGenericParameters" type:"Map"`
	BizContext           map[string]RoaDuheYsTestBodyBizContextItem           `name:"BizContext" type:"Map"`
	InvokeInfomation     map[string]string                                    `name:"InvokeInfomation" type:"Map"`
}

// RoaDuheYsTestBodyBizGenericParametersItem is a repeated param struct in RoaDuheYsTestRequest
type RoaDuheYsTestBodyBizGenericParametersItem struct {
	Param string `name:"Param"`
}

// RoaDuheYsTestBodyBizContextItem is a repeated param struct in RoaDuheYsTestRequest
type RoaDuheYsTestBodyBizContextItem struct {
	Param string `name:"Param"`
}

// RoaDuheYsTestResponse is the response struct for api RoaDuheYsTest
type RoaDuheYsTestResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateRoaDuheYsTestRequest creates a request to invoke RoaDuheYsTest API
func CreateRoaDuheYsTestRequest() (request *RoaDuheYsTestRequest) {
	request = &RoaDuheYsTestRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("amp", "2020-07-08", "RoaDuheYsTest", "/roa/duhe/test", "ServiceCode", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRoaDuheYsTestResponse creates a response to parse from RoaDuheYsTest response
func CreateRoaDuheYsTestResponse() (response *RoaDuheYsTestResponse) {
	response = &RoaDuheYsTestResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
