package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPrometheusIntegration invokes the arms.ListPrometheusIntegration API synchronously
func (client *Client) ListPrometheusIntegration(request *ListPrometheusIntegrationRequest) (response *ListPrometheusIntegrationResponse, err error) {
	response = CreateListPrometheusIntegrationResponse()
	err = client.DoAction(request, response)
	return
}

// ListPrometheusIntegrationWithChan invokes the arms.ListPrometheusIntegration API asynchronously
func (client *Client) ListPrometheusIntegrationWithChan(request *ListPrometheusIntegrationRequest) (<-chan *ListPrometheusIntegrationResponse, <-chan error) {
	responseChan := make(chan *ListPrometheusIntegrationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPrometheusIntegration(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPrometheusIntegrationWithCallback invokes the arms.ListPrometheusIntegration API asynchronously
func (client *Client) ListPrometheusIntegrationWithCallback(request *ListPrometheusIntegrationRequest, callback func(response *ListPrometheusIntegrationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPrometheusIntegrationResponse
		var err error
		defer close(result)
		response, err = client.ListPrometheusIntegration(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPrometheusIntegrationRequest is the request struct for api ListPrometheusIntegration
type ListPrometheusIntegrationRequest struct {
	*requests.RpcRequest
	IntegrationType string `position:"Query" name:"IntegrationType"`
	ClusterId       string `position:"Query" name:"ClusterId"`
}

// ListPrometheusIntegrationResponse is the response struct for api ListPrometheusIntegration
type ListPrometheusIntegrationResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Message   string     `json:"Message" xml:"Message"`
	Code      int        `json:"Code" xml:"Code"`
	Data      []Instance `json:"Data" xml:"Data"`
}

// CreateListPrometheusIntegrationRequest creates a request to invoke ListPrometheusIntegration API
func CreateListPrometheusIntegrationRequest() (request *ListPrometheusIntegrationRequest) {
	request = &ListPrometheusIntegrationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "ListPrometheusIntegration", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPrometheusIntegrationResponse creates a response to parse from ListPrometheusIntegration response
func CreateListPrometheusIntegrationResponse() (response *ListPrometheusIntegrationResponse) {
	response = &ListPrometheusIntegrationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
