package biz_ipdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetailNetCluster invokes the biz_ipdb.DetailNetCluster API synchronously
func (client *Client) DetailNetCluster(request *DetailNetClusterRequest) (response *DetailNetClusterResponse, err error) {
	response = CreateDetailNetClusterResponse()
	err = client.DoAction(request, response)
	return
}

// DetailNetClusterWithChan invokes the biz_ipdb.DetailNetCluster API asynchronously
func (client *Client) DetailNetClusterWithChan(request *DetailNetClusterRequest) (<-chan *DetailNetClusterResponse, <-chan error) {
	responseChan := make(chan *DetailNetClusterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetailNetCluster(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetailNetClusterWithCallback invokes the biz_ipdb.DetailNetCluster API asynchronously
func (client *Client) DetailNetClusterWithCallback(request *DetailNetClusterRequest, callback func(response *DetailNetClusterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetailNetClusterResponse
		var err error
		defer close(result)
		response, err = client.DetailNetCluster(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetailNetClusterRequest is the request struct for api DetailNetCluster
type DetailNetClusterRequest struct {
	*requests.RpcRequest
	LocationNo   string           `position:"Query" name:"LocationNo"`
	LocationId   requests.Integer `position:"Query" name:"LocationId"`
	LocationType string           `position:"Query" name:"LocationType"`
	BizLine      string           `position:"Query" name:"BizLine"`
}

// DetailNetClusterResponse is the response struct for api DetailNetCluster
type DetailNetClusterResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	LocationType string `json:"LocationType" xml:"LocationType"`
	BizLine      string `json:"BizLine" xml:"BizLine"`
	LocationId   int64  `json:"LocationId" xml:"LocationId"`
	LocationNo   string `json:"LocationNo" xml:"LocationNo"`
	Clusters     string `json:"Clusters" xml:"Clusters"`
	LogicPod     string `json:"LogicPod" xml:"LogicPod"`
	Id           int64  `json:"Id" xml:"Id"`
}

// CreateDetailNetClusterRequest creates a request to invoke DetailNetCluster API
func CreateDetailNetClusterRequest() (request *DetailNetClusterRequest) {
	request = &DetailNetClusterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Biz-ipdb", "2016-08-08", "DetailNetCluster", "", "")
	request.Method = requests.POST
	return
}

// CreateDetailNetClusterResponse creates a response to parse from DetailNetCluster response
func CreateDetailNetClusterResponse() (response *DetailNetClusterResponse) {
	response = &DetailNetClusterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
