package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableServiceForCloudSiem invokes the cloud_siem.EnableServiceForCloudSiem API synchronously
func (client *Client) EnableServiceForCloudSiem(request *EnableServiceForCloudSiemRequest) (response *EnableServiceForCloudSiemResponse, err error) {
	response = CreateEnableServiceForCloudSiemResponse()
	err = client.DoAction(request, response)
	return
}

// EnableServiceForCloudSiemWithChan invokes the cloud_siem.EnableServiceForCloudSiem API asynchronously
func (client *Client) EnableServiceForCloudSiemWithChan(request *EnableServiceForCloudSiemRequest) (<-chan *EnableServiceForCloudSiemResponse, <-chan error) {
	responseChan := make(chan *EnableServiceForCloudSiemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableServiceForCloudSiem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableServiceForCloudSiemWithCallback invokes the cloud_siem.EnableServiceForCloudSiem API asynchronously
func (client *Client) EnableServiceForCloudSiemWithCallback(request *EnableServiceForCloudSiemRequest, callback func(response *EnableServiceForCloudSiemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableServiceForCloudSiemResponse
		var err error
		defer close(result)
		response, err = client.EnableServiceForCloudSiem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableServiceForCloudSiemRequest is the request struct for api EnableServiceForCloudSiem
type EnableServiceForCloudSiemRequest struct {
	*requests.RpcRequest
}

// EnableServiceForCloudSiemResponse is the response struct for api EnableServiceForCloudSiem
type EnableServiceForCloudSiemResponse struct {
	*responses.BaseResponse
	Data      bool   `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableServiceForCloudSiemRequest creates a request to invoke EnableServiceForCloudSiem API
func CreateEnableServiceForCloudSiemRequest() (request *EnableServiceForCloudSiemRequest) {
	request = &EnableServiceForCloudSiemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "EnableServiceForCloudSiem", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableServiceForCloudSiemResponse creates a response to parse from EnableServiceForCloudSiem response
func CreateEnableServiceForCloudSiemResponse() (response *EnableServiceForCloudSiemResponse) {
	response = &EnableServiceForCloudSiemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
