package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetStorage invokes the cloud_siem.GetStorage API synchronously
func (client *Client) GetStorage(request *GetStorageRequest) (response *GetStorageResponse, err error) {
	response = CreateGetStorageResponse()
	err = client.DoAction(request, response)
	return
}

// GetStorageWithChan invokes the cloud_siem.GetStorage API asynchronously
func (client *Client) GetStorageWithChan(request *GetStorageRequest) (<-chan *GetStorageResponse, <-chan error) {
	responseChan := make(chan *GetStorageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetStorage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetStorageWithCallback invokes the cloud_siem.GetStorage API asynchronously
func (client *Client) GetStorageWithCallback(request *GetStorageRequest, callback func(response *GetStorageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetStorageResponse
		var err error
		defer close(result)
		response, err = client.GetStorage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetStorageRequest is the request struct for api GetStorage
type GetStorageRequest struct {
	*requests.RpcRequest
}

// GetStorageResponse is the response struct for api GetStorage
type GetStorageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetStorageRequest creates a request to invoke GetStorage API
func CreateGetStorageRequest() (request *GetStorageRequest) {
	request = &GetStorageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "GetStorage", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetStorageResponse creates a response to parse from GetStorage response
func CreateGetStorageResponse() (response *GetStorageResponse) {
	response = &GetStorageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
