package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitJobs invokes the cloud_siem.SubmitJobs API synchronously
func (client *Client) SubmitJobs(request *SubmitJobsRequest) (response *SubmitJobsResponse, err error) {
	response = CreateSubmitJobsResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitJobsWithChan invokes the cloud_siem.SubmitJobs API asynchronously
func (client *Client) SubmitJobsWithChan(request *SubmitJobsRequest) (<-chan *SubmitJobsResponse, <-chan error) {
	responseChan := make(chan *SubmitJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitJobsWithCallback invokes the cloud_siem.SubmitJobs API asynchronously
func (client *Client) SubmitJobsWithCallback(request *SubmitJobsRequest, callback func(response *SubmitJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitJobsResponse
		var err error
		defer close(result)
		response, err = client.SubmitJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitJobsRequest is the request struct for api SubmitJobs
type SubmitJobsRequest struct {
	*requests.RpcRequest
	JsonParam string `position:"Body" name:"JsonParam"`
}

// SubmitJobsResponse is the response struct for api SubmitJobs
type SubmitJobsResponse struct {
	*responses.BaseResponse
	Data      int    `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateSubmitJobsRequest creates a request to invoke SubmitJobs API
func CreateSubmitJobsRequest() (request *SubmitJobsRequest) {
	request = &SubmitJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "SubmitJobs", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitJobsResponse creates a response to parse from SubmitJobs response
func CreateSubmitJobsResponse() (response *SubmitJobsResponse) {
	response = &SubmitJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
